<?php // Promotor
	defined('BASEPATH') OR exit('No direct script access allowed');

	class Postventa extends MX_Controller {
		public $data,$vParameters,$mainView,$fv,$appProduction;
		public function __construct() {
			$this->nsession = $this->config->item('nsession');
			if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
			$this->fv = 'postventa'; // form validation variable
			$this->mainView = 'postventa';
			$this->data['fjs'] = '';
			$this->data['js'] = '<script src="assets/js/postventa/listado.js" type="text/javascript"></script>';
			$this->data['css'] = '';
			// Tools
			$this->load->helper(array('tools','numeros','url','form','date','text','security'));
			// Modelos
			$this->load->model(array('maltaventa','mprospecto','mproyecto','mfraccionamiento','musuario', 'mgestoria','mcomisionbono','mautorizacion','mdeposito','mnotaria','mentrega','mpostventa','mfraccionamientoxusuario','mincidente','mprototipos','mprototipoxfraccionamiento'));//maltaventa tiene los datos para gestoria, mgestoria se usa para obtener la funcion getNext id al guardar archivos
			$this->appProduction = $this->config->item('appProduction');
			// Lbrerias
            $this->load->library('csvarray','csvimport');
			$this->data['fotos_www'] = $this->config->item('base_www').'/alta_venta/postventa/';

			// Debugging
			$this->output->enable_profiler(false);

           //Validación de usuarios
			valSession("calidad",$this->fv);
			ini_set('memory_limit', '-1');
            ini_set('max_execution_time', 0);
		}

        public function csv(){
			$array1=$this->listadoIncidencias(true);
			$array2=$this->listadoIncidenciasCerradas(true);
			//Uniendo los 2 arrays
			$data=array_merge($array1, $array2);
			//Eliminando la columna de acciones
			$data=$this->csvarray->deleteColumnArray($data,"acciones");
			//Eliminando br y guiones
			$data=$this->csvarray->deleteCharArray($data,"garantiaAplicar","<br>");
			$data=$this->csvarray->deleteCharArray($data,"garantiaAplicar","-");
			$data=$this->csvarray->deleteCharArray($data,"descripcion","<br>");
			$data=$this->csvarray->deleteCharArray($data,"descripcion","-");

			$columnas = array(
				0 => 'Folio',
				1 => 'Fraccionamiento',
				2 => 'Lote',
				3 => 'Manzana',
				4 => 'Calle',
				5 => 'nOficial',
				6 => 'Cliente',
				7 => 'Telefono',
				8 => 'Promotor',
				9 => 'Usuario',
				10 => 'Fecha Incidencia',
				11 => 'Garantia Aplicar',
				12 => 'Descripcion',
				13 => 'Fecha Solucion',
				14 => 'ronda',
				15 => 'contratista',
				16 => 'estatus',
			);
			crearExcel2($data,"postventa",$columnas,'array');
        }

		public function index() {
			$data['q'] = '';
			$this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
			$this->load->view('templates/main_template',$this->data);
		}

     	public function listado(){
	        $q = $this->maltaventa->getJoinPostventa();

	        //print_r($infoPostventa);exit();
	        if (!is_numeric($q)){
	            // print_r($q->result());exit();
	            foreach ($q->result() as $row){
	            	$infoPostventa = (!is_numeric($q))?$this->mpostventa->getByIdAltaVenta($row->id):0;

	            	// print_r($infoPostventa); exit();
	                $total = $row->monto + $row->subCuenta - $row->gastosOperacion;
	                $array['aaData'][] = array(
	                	'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo',$this->mproyecto->getCampo('idFraccionamiento',$row->idProyecto)),
	                    'lote' => $this->mproyecto->getCampo('lote',$row->idProyecto),
	                    'manzana' => $row->manzana,
	                    'cliente' => strtoupper($this->mprospecto->getCampo('nombre',$row->idProspecto)." ".$this->mprospecto->getCampo('apellidoP',$row->idProspecto)." ".$this->mprospecto->getCampo('apellidoM',$row->idProspecto)),
	                    'nss' => $row->nss,
	                    'promotor' => strtoupper($this->musuario->getCampo("nombre",$row->idPromotor)." ".$this->musuario->getCampo("apellidoP",$row->idPromotor)." ".$this->musuario->getCampo("apellidoM",$row->idPromotor)),
	                    'precioVenta' => precio_format($row->precioVenta),
	                    'avaluo' => precio_format($row->avaluo),
	                    'precioVentaOci' => precio_format($row->precioVentaOci),
	                    'sumaFinal' => precio_format($row->sumaFinal),
	                    'bonoEquipamiento' => precio_format($row->bonoEquipamiento),
	                    //'comision' => $this->musuario->getCampo("comision",$row->idPromotor)."%",
	                    //'importeComision' => precio_format($row->importeComision),
	                    //'statusVivienda' => estatus_proyecto_reporte($row->statusVenta),
	                    'instElectricas' => (!is_numeric($infoPostventa))?date('d/m/Y',strtotime($infoPostventa['instElectricas'])):'',
	                    'instHidraulicas' => (!is_numeric($infoPostventa))?date('d/m/Y',strtotime($infoPostventa['instHidraulicas'])):'',
	                    'instSanitarias' => (!is_numeric($infoPostventa))?date('d/m/Y',strtotime($infoPostventa['instSanitarias'])):'',
	                    'instGas' => (!is_numeric($infoPostventa))?date('d/m/Y',strtotime($infoPostventa['instGas'])):'',
	                    'canceleria' => (!is_numeric($infoPostventa))?$infoPostventa['canceleria']:'',
	                    'impermeabilizacion' => (!is_numeric($infoPostventa))?date('d/m/Y',strtotime($infoPostventa['impermeabilizacion'])):'',
	                    'acabados' => (!is_numeric($infoPostventa))?date('d/m/Y',strtotime($infoPostventa['acabados'])):'',
	                    'estructural' => (!is_numeric($infoPostventa))?date('d/m/Y',strtotime($infoPostventa['estructural'])):'',
	                    'accesorios' => (!is_numeric($infoPostventa))?date('d/m/Y',strtotime($infoPostventa['accesorios'])):'',
	                    'calentadorAgua' => (!is_numeric($infoPostventa))?date('d/m/Y',strtotime($infoPostventa['calentadorAgua'])):'',
	                    'acciones' => getSession("calidad","postventa_edit") ? acciones($row->id,$this->router->class, true, true, false) : accionesNoEdit($row->id,$this->router->class)//acciones($row->id,$this->router->class, true, true, false)
	                    );
	            }
	        }else{
	            $array['aaData'][] = array(
	            	'fraccionamiento' => 'No hay registros',
	                'lote' => 'No hay registros',
	                'manzana' => 'No hay registros',
	                'cliente' => 'No hay registros',
	                'nss' => 'No hay registros',
	                'promotor' => 'No hay registros',
	                'precioVenta' => 'No hay registros',
	                'avaluo' => 'No hay registros',
	                'precioVentaOci' => 'No hay registros',
	                'sumaFinal' => 'No hay registros',
	                'bonoEquipamiento' => 'No hay registros',
	                //'comision' => 'No hay registros',
	                //'importeComision' => 'No hay registros',
	                'instElectricas' => 'No hay registros',
	                'instHidraulicas' => 'No hay registros',
	                'instSanitarias' => 'No hay registros',
	                'instGas' => 'No hay registros',
	                'canceleria' => 'No hay registros',
	                'impermeabilizacion' => 'No hay registros',
	                'acabados' => 'No hay registros',
	                'estructural' => 'No hay registros',
	                'accesorios' => 'No hay registros',
	                'calentadorAgua' => 'No hay registros',
	                'acciones' => 'No hay registros'
	                );
	        }
	        echo json_encode($array);
	    }

	    public function editar($id = null){ // $id = id en tabla alta venta, idGestoria es el id en la tabla gestoria
	    	$data['msg'] = '';
	    	$data['msgInvalid'] = '';
	    	$resultado = true;
	    	$contadorArchivos = 0;

        	//VERIFICAMOS SI EL REGISTRO SE ENCUENTRA EN TABLA POSTVENTA
			$tipoEdit;
			$idAltaVenta;
			$newId=explode("-",$id);
			if(COUNT($newId)==1){
				$newId=$newId[0];
        		$postventa = $this->mpostventa->getByIdAltaVenta($newId);
				$idAltaVenta=$newId;
				$tipoEdit="new";
			}else{
				$newId=$newId[0];
				$postventa=$this->mpostventa->getById($newId);
				$idAltaVenta=$postventa["idAltaVenta"];
				$tipoEdit="upd";
			}

			$info = $this->maltaventa->getByIdForPostventa($idAltaVenta);
        	$data = (!is_numeric($info))?$info:'';
        	$data['disabled'] = (!is_numeric($info))?false:true;

        	if(is_numeric($info)){
        		$data['id']='';
        		$data['msgInvalid'] = 'No se encontró el registro';
        	}else{
        		$data['msgInvalid'] = '';
        	}

        	$data['pdf_14'] = (!is_numeric($postventa))?$postventa['pdf_14']:0; // veridficamos si existe el archivo de conformidad
        	$data['idPostventa'] = (!is_numeric($postventa))?$postventa['id']:0;

        	// echo "<pre>"; print_r($postventa); echo "</pre>"; exit();

        	if (isset($_POST['instElectricas'])){
		        $this->load->library('form_validation');
		        if ($this->form_validation->run($this->fv) == FALSE) {
		            $data['msg'] = validation_errors();
		        } else {
	                // Subida de pdf
		            $config = array();
		            $this->load->library('upload', $config);
		            if (isset($_FILES)){
		                $imagenes = array();
		                foreach($_FILES as $key=>$value){
		                    if ($_FILES[$key]['size'] > 0){
		                        $_FILES[$key]['name'] = strtolower($_FILES[$key]['name']);
		                        $imagenes[] = $key;
		                    }
		                }
		                $totalImagenes = count($imagenes);
		                for($i=0; $i< $totalImagenes; $i++){
		                    $ext = pathinfo($_FILES[$imagenes[$i]]['name'],PATHINFO_EXTENSION);
		                    //Configuracion del thumbnail
		                    if($imagenes[$i]!='pdf'){
		                        $nCampoC = explode("_",$imagenes[$i]);
		                        $tipo = $nCampoC[0];
		                        $v = $nCampoC[1];
		                    } else {
		                        $v = 0;
		                        $tipo = 'pdf';
		                    }
		                    if ($tipo == 'pdf' || $tipo == 'jpg' || $tipo == 'png' || $tipo == 'jpeg'){
		                        $uploaddir = $this->data['fotos_www'];
		                        $nextId = (!is_numeric($postventa))?$postventa['id']:$this->mpostventa->nextId();
		                        $config['file_name'] =  $nextId."_".$v;
		                        $config['overwrite'] = TRUE;
		                        $config['upload_path'] = $uploaddir;
		                        $config['max_size'] = '8000';
		                        $config['allowed_types'] = 'pdf|jpg|jpeg|png|gif';
		                        $this->upload->initialize($config);
		                        if ( ! $this->upload->do_upload($imagenes[$i]) )
		                        {
		                            $redirect = 1;
		                            $data['error'] = $this->upload->display_errors();
		                        }
		                        else
		                        {
		                        	$contadorArchivos++;
		                            $dataFile = $this->upload->data($imagenes[$i]);
		                            $fotoI = 'pdf_'.$v;
		                            //$thumbI = 'thumbnail_'.$v;
		                            if ($v == 0){
		                                //Foto default
		                                $pData['pdf'] = $nextId.'_'.$v.'.'.$ext;//
		                            } else {
		                                $pData[$fotoI] = $nextId.'_'.$v.'.'.$ext;
		                            }
		                        }
		                    }
		                }
		            }

		        	$pData['idAltaVenta'] = $idAltaVenta;

		        	$instElectricas = $this->input->post('instElectricas', TRUE);
		        	$rInstElectricas =  str_replace('/', '-', $instElectricas);
		        	$pData['instElectricas'] = date('Y-m-d', strtotime($rInstElectricas));//date_format(new DateTime($instElectricas),'Y-m-d');

		        	$instHidraulicas = $this->input->post('instHidraulicas', TRUE);
		        	$rInstHidraulicas = str_replace('/', '-', $instHidraulicas);
		        	$pData['instHidraulicas'] = date_format(new DateTime($rInstHidraulicas),'Y-m-d');

		        	$instSanitarias = $this->input->post('instSanitarias', TRUE);
		        	$rInstSanitarias = str_replace('/', '-', $instSanitarias);
		        	$pData['instSanitarias'] = date_format(new DateTime($rInstSanitarias),'Y-m-d');

		        	$instGas = $this->input->post('instGas', TRUE);
		        	$rInstGas = str_replace('/', '-', $instGas);
		        	$pData['instGas'] = date_format(new DateTime($rInstGas),'Y-m-d');

		        	$impermeabilizacion = $this->input->post('impermeabilizacion', TRUE);
		        	$rImpermeabilizacion = str_replace('/', '-', $impermeabilizacion);
		        	$pData['impermeabilizacion'] = date_format(new DateTime($rImpermeabilizacion),'Y-m-d');

		        	$acabados = $this->input->post('acabados', TRUE);
		        	$rAcabados = str_replace('/', '-', $acabados);
		        	$pData['acabados'] = date_format(new DateTime($rAcabados),'Y-m-d');

		        	$estructural = $this->input->post('estructural', TRUE);
		        	$rEstructural = str_replace('/', '-', $estructural);
		        	$pData['estructural'] = date_format(new DateTime($rEstructural),'Y-m-d');

		        	$accesorios = $this->input->post('accesorios', TRUE);
		        	$rAccesorios = str_replace('/', '-', $accesorios);
		        	$pData['accesorios'] = date_format(new DateTime($rAccesorios),'Y-m-d');

		        	$calentadorAgua = $this->input->post('calentadorAgua', TRUE);
		        	$rCalentadorAgua = str_replace('/', '-', $calentadorAgua);
		        	$pData['calentadorAgua'] = date_format(new DateTime($rCalentadorAgua),'Y-m-d');


		        	// Validacion de incidencia
		        	$cbData['instElectricas'] = $this->input->post('cb_instElectricas', TRUE);
		        	$cbData['descInstElectricas'] = $this->input->post('desc_instElectricas', TRUE);
		        	$cbData['instHidraulicas'] = $this->input->post('cb_instHidraulicas', TRUE);
		        	$cbData['descInstHidraulicas'] = $this->input->post('desc_instHidraulicas', TRUE);
		        	$cbData['instSanitarias'] = $this->input->post('cb_instSanitarias', TRUE);
		        	$cbData['descInstSanitarias'] = $this->input->post('desc_instSanitarias', TRUE);
		        	$cbData['instGas'] = $this->input->post('cb_instGas', TRUE);
		        	$cbData['descInstGas'] = $this->input->post('desc_instGas', TRUE);
		        	$cbData['canceleria'] = $this->input->post('cb_canceleria', TRUE);
		        	$cbData['descCanceleria'] = $this->input->post('desc_canceleria', TRUE);
		        	$cbData['impermeabilizacion'] = $this->input->post('cb_impermeabilizacion', TRUE);
		        	$cbData['descImpermeabilizacion'] = $this->input->post('desc_impermeabilizacion', TRUE);
		        	$cbData['acabados'] = $this->input->post('cb_acabados', TRUE);
		        	$cbData['descAcabados'] = $this->input->post('desc_acabados', TRUE);
		        	$cbData['estructural'] = $this->input->post('cb_estructural', TRUE);
		        	$cbData['descEstructural'] = $this->input->post('desc_estructural', TRUE);
		        	$cbData['accesorios'] = $this->input->post('cb_accesorios', TRUE);
		        	$cbData['descAccesorios'] = $this->input->post('desc_accesorios', TRUE);
		        	$cbData['calentadorAgua'] = $this->input->post('cb_calentadorAgua', TRUE);
		        	$cbData['descCalentadorAgua'] = $this->input->post('desc_calentadorAgua', TRUE);
		        	$cbData['status'] = 1;

	            	if (($tipoEdit=="new") && ($cbData['instElectricas'] == 1 || $cbData['instHidraulicas'] == 1 || $cbData['instSanitarias'] == 1 || $cbData['instGas'] == 1 || $cbData['canceleria'] == 1 || $cbData['impermeabilizacion'] == 1 || $cbData['acabados'] == 1 || $cbData['estructural'] == 1 || $cbData['accesorios'] == 1 || $cbData['calentadorAgua'] == 1 )) {
			        	$idIncidente = $this->input->post('idIncidente', TRUE);
		        		$pData['statusIncidencia']=1;
						$cbData['statusIncidencia'] = 1;
		        		$idPostventa = $this->mpostventa->insertar($pData);
		        		$cbData['idPostventa'] = $idPostventa;
	            		$idIn = $this->mincidente->insertar($cbData);

	            		$this->autoRespuestaIncidencia($idAltaVenta, $idIn);

	            	}elseif(($contadorArchivos>0 || $tipoEdit=="upd") && !is_numeric($postventa)){
	            		$this->mpostventa->actualizar($pData,$postventa['id']);
						$this->mincidente->actualizar($cbData,$postventa['id']);
	            	}
	                redirect($this->router->class.'?close');
		        }
	        }

	        $data['mpromotor'] = $this->musuario;

	        if ( !is_numeric($postventa) ) {
				if($tipoEdit=="new"){
	        		//$data['incidencia'] = $this->mincidente->getLastRowByIdPostventa( $data['idPostventa'] );
				}else if($tipoEdit=="upd"){
					$data['incidencia'] = $this->mincidente->getById($data['idPostventa']);
				}
	        }else{
	        	$data['incidencia'] = 0;
	        }
			$data["id"]=$id;
	        $this->data['contenido'] = $this->load->view($this->mainView . '/editar_view', $data, true);
	        $this->load->view('templates/main_template', $this->data);
	    }

	    public function ver($id = null)
	    {
	        //Obtenemos el id del Proyecto a aprtir de id alta venta
	        $id = $this->maltaventa->getCampo("idProyecto",$id);
	        $info = $this->mproyecto->getById($id);
	        $data = $info;
	        $data['etapa_alta_venta'] = false;
	        $data['etapa_validacion_venta'] = false;
	        $data['etapa_gestoria'] = false;
	        $data['etapa_comisionbono'] = false;
	        $data['etapa_autorizaciones'] = false;
	        $data['etapa_deposito'] = false;
	        $data['etapa_entrega'] = false;
	        $data['etapa_encuesta'] = false;
	        $data['etapa_postventa'] = false;

	        $altaVenta = $this->maltaventa->getStatusByIdProyecto($id);
	        $idAltaVenta = $this->maltaventa->getIdAltaVentaByIdProyecto($id);
	        $statusProyecto = (!is_numeric($altaVenta))?$altaVenta->row()->statusValidacion:'';


	        /*
	        switch ($statusProyecto) {
	            case '0':
	                $data['etapa_alta_venta'] = true;
	                $data['detalle_venta'] = $this->maltaventa->getAltaVentaByIdProy($id);
	                break;
	            case '1':
	                $data['etapa_alta_venta'] = true;
	                $data['etapa_validacion_venta'] = true;
	                $data['detalle_venta'] = $this->maltaventa->getValidacionVentaByIdProy($id);
	                break;
	            case '2':
	                $data['etapa_alta_venta'] = true;
	                $data['etapa_validacion_venta'] = true;
	                $data['detalle_venta'] = $this->maltaventa->getValidacionVentaByIdProy($id);
	                break;
	            case '3':
	            case '4':
	            case '5':
	                $data['etapa_alta_venta'] = true;
	                $data['etapa_validacion_venta'] = true;
	                $data['etapa_gestoria'] = true;
	                $data['detalle_venta'] = $this->maltaventa->getGestoriaByIdProy($id);

	                $comisiones = $this->mcomisionbono->getByIdAV($data['detalle_venta']['id']);//($idAltaVenta->row()->id);
	                if ( !is_numeric($comisiones) ) {
	                    $data['etapa_comisionbono'] = true;
	                    $data['detalle_comisionbono'] = $comisiones;

	                }

	                $autorizaciones = $this->mautorizacion->getByIdAV($data['detalle_venta']['id']);
	                if ( !is_numeric($autorizaciones) ) {
	                    $data['etapa_autorizaciones'] = true;
	                    $data['detalle_autorizaciones'] = $autorizaciones;
	                }

	                $deposito = $this->mdeposito->getByIdAV($data['detalle_venta']['id']);
	                if ( !is_numeric($deposito) ) {
	                    $data['etapa_deposito'] = true;
	                    $data['detalle_deposito'] = $deposito;
	                }

	                $entrega = $this->mentrega->getByIdAV($data['detalle_venta']['id']);
	                if ( !is_numeric($entrega) ) {
	                    $data['etapa_entrega'] = true;
	                    $data['detalle_entrega'] = $entrega;
	                }

	                $encuesta = $this->mencuestavivienda->getByIdAV($data['detalle_venta']['id']);
	                if ( !is_numeric($entrega) ) {
	                    $data['etapa_encuesta'] = true;
	                    $data['detalle_encuesta'] = $encuesta;
	                }

	                $postventa = $this->mpostventa->getByIdAV($data['detalle_venta']['id']);
	                if ( !is_numeric($postventa) ) {
	                    $data['etapa_postventa'] = true;
	                    $data['detalle_postventa'] = $postventa;
	                }
	                break;
	            default:

	                break;
	        }*/

	        $data['etapa_alta_venta'] = true;
	        $data['etapa_validacion_venta'] = true;
	        $data['etapa_gestoria'] = true;
	        $data['detalle_venta'] = $this->maltaventa->getGestoriaByIdProy($id);

	        $comisiones = $this->mcomisionbono->getByIdAV($data['detalle_venta']['id']);//($idAltaVenta->row()->id);
	        if ( !is_numeric($comisiones) ) {
	            $data['etapa_comisionbono'] = true;
	            $data['detalle_comisionbono'] = $comisiones;

	        }

	        $autorizaciones = $this->mautorizacion->getByIdAV($data['detalle_venta']['id']);
	        if ( !is_numeric($autorizaciones) ) {
	            $data['etapa_autorizaciones'] = true;
	            $data['detalle_autorizaciones'] = $autorizaciones;
	        }

	        $deposito = $this->mdeposito->getByIdAV($data['detalle_venta']['id']);
	        if ( !is_numeric($deposito) ) {
	            $data['etapa_deposito'] = true;
	            $data['detalle_deposito'] = $deposito;
	        }

	        $entrega = $this->mentrega->getByIdAV($data['detalle_venta']['id']);
	        if ( !is_numeric($entrega) ) {
	            $data['etapa_entrega'] = true;
	            $data['detalle_entrega'] = $entrega;
	        }

	        $postventa = $this->mpostventa->getByIdAV($data['detalle_venta']['id']);
	        if ( !is_numeric($postventa) ) {
	            $data['etapa_postventa'] = true;
	            $data['detalle_postventa'] = $postventa;
	        }

	        $data['module'] = 0;//( !is_null($module) ? 'busqueda_vivienda' : 0);
	        $data['mpromotor'] = $this->musuario;
	        $data['mprototipoxfraccionamiento'] = $this->mprototipoxfraccionamiento;
	        $data['mprototipos'] = $this->mprototipos;
	        $this->data['contenido'] = $this->load->view($this->mainView . '/ver_view', $data, true);
	        $this->load->view('templates/main_template', $this->data);
	    }


        public function eliminar_archivo()
	    {

	        if (isset($_POST['elid'])){
	            $id = $this->input->post('elid');
	            $campo = $this->input->post('elcampo'); //Obteniendo el nombre de la foto y thumbnail
	            if($campo !="0"){
	                $archivo = $this->mpostventa->getCampo('pdf_'.$campo,$id);
	                if(unlink($this->data['fotos_www'].$archivo)){// Haciendo update a la tabla
	                    $c_data['pdf_'.$campo] ='';
	                    $this->mpostventa->actualizar($c_data,$id);
	                    $c_valor = "true";
	                    //$this->msomos->borrar($id);
	                }else{ $c_valor = "false";}
	            }else{
	                $archivo = $this->mpostventa->getCampo('pdf',$id);
	                if(unlink($this->data['fotos_www'].$archivo)){// Haciendo update a la tabla
	                    $c_data['pdf'] ='';
	                    $this->mpostventa->actualizar($c_data,$id);
	                    $c_valor = "true";
	                    //$this->msomos->borrar($id);
	                }else{ $c_valor = "false";}
	            }
	            $data = json_encode(array("valor"=>$c_valor));
	            echo $data;

	        }
	    }


	    public function autoRespuesta( $idAltaVenta = null ) {
	        $copiasNV = 'hsalinas@viviend.mx'. ', ';
        	$copiasNV .= 'esalinas@viviend.mx'. ', ';
        	$copiasNV .= 'mejora@viviend.mx'. ', ';
        	$copiasNV .= 'sistemas@viviend.mx';

	        // $para = $emailCliente; // Comprador

	        $subject = 'Notificación de Postventa';

	        $liga="http://viviend.mx/sistema/emailresources/";
	        $liga2="http://viviend.mx/sistema/img/";
	        $liga3="http://viviend.mx/sistema/";
	        $idFraccionamiento = $_SESSION['viv']['idFraccionamiento'];
	        $fotoFracc = $this->mfraccionamiento->getCampo('foto',$idFraccionamiento);
	        $urlLogoFracc = ($fotoFracc!=false)?'http://viviend.mx/sistema/uploads/fraccionamientos/'.$fotoFracc:'http://viviend.mx/sistema/img/logo-300.png';
	        $tp = '';

	        $data = array();

	        $info = $this->maltaventa->getByIdForPostventa($idAltaVenta);
	        $postventa = $this->mpostventa->getByIdAltaVenta($idAltaVenta);

	        $nomPromotor = $this->musuario->getCampo('nombre',$info['idPromotor'])." ".$this->musuario->getCampo('apellidoP',$info['idPromotor'])." ".$this->musuario->getCampo('apellidoM',$info['idPromotor']);

	        /*-----------------------------------------------------------------------------------------------------------------------------------------*/
	        $cuerpo = '<table id="table-blackboard" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
	                        <thead>
	                            <tr>
	                                <th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">CUANDO SEA EN NOTARIA</th>
	                            </tr>
	                        </thead>
	                        <tbody>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> LOTE: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['lote'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> MANZANA: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['manzana'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NÚMERO OFICIAL: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['nOficial'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> CALLE: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['calle'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NOMBRES: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['nombre'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> APELLIDO PATERNO: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['apellidoP'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> APELLIDO MATERNO: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['apellidoM'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> RFC: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['rfc'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> TELÉFONO: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['telefono'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NSS: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['nss'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> FECHA DE NACIMIENTO: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($info['fechaNac']), 'd/m/Y').' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> ESTATUS: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['statusProyecto'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> PROMOTOR: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nomPromotor.' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> FECHA ENTREGA: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($info['fechaEntrega']), 'd/m/Y').' </td>
	                            </tr>
	                        </tbody>
	                    </table>';
	        /*-----------------------------------------------------------------------------------------------------------------------------------------*/
	        $cuerpo .= '<table id="table-blackboard" style="width: 80%;margin: 50px auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
	                        <thead>
	                            <tr>
	                                <th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">GARANTÍAS</th>
	                            </tr>
	                        </thead>
	                        <tbody>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> INST. ELÉCTRICAS: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($postventa['instElectricas']), 'd/m/Y').' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> INST. HIDRÁULICAS: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($postventa['instHidraulicas']), 'd/m/Y').' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> INST. SANITARIAS: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($postventa['instSanitarias']), 'd/m/Y').' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> INST. GAS: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($postventa['instGas']), 'd/m/Y').' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> CANCELERÍA: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$postventa['canceleria'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> IMPERMEABILIZACION: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($postventa['impermeabilizacion']), 'd/m/Y').' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> ACABADOS: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($postventa['acabados']), 'd/m/Y').' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> ESTRUCTURAL: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($postventa['estructural']), 'd/m/Y').' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> ACCESORIOS: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($postventa['accesorios']), 'd/m/Y').' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> CALENTADOR AGUA: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($postventa['calentadorAgua']), 'd/m/Y').' </td>
	                            </tr>
	                        </tbody>
	                    </table>';


	        $mensaje = '
	        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
	        <html xmlns="http://www.w3.org/1999/xhtml">
	        <head>
	            <title>Email</title>
	            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
	            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
	            <style>
	                body, tr, td, span, div, p, a, li {
	                    -moz-text-size-adjust:none !important;
	                    -webkit-text-size-adjust:none !important;
	                    margin:0px !important;
	                    -ms-text-size-adjust:none !important;
	                    white-space: wrap;
	                }
	                .lato-light{
	                    font-family: "lato" sans-serif !important;
	                    font-weight: 300;
	                }
	                .lato-bold{
	                    font-family: "lato" sans-serif !important;
	                    font-weight: 700;
	                }
	                td img {
	                    display: block;
	                }
	                .ReadMsgBody {
	                    width: 100%;
	                }
	                .ExternalClass * {
	                    line-height: 100%;
	                }
	                @media only screen and (max-width:480px) {
	                    #logosim{
	                        padding:0!important;
	                    }
	                    *[class="code4email_wrapper"] {
	                        width: 100% !important;
	                    }
	                    *[class="code4email_main_table"] {
	                        width: 320px !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_center"] {
	                        text-align: center !important;
	                        padding:10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_clear"] {
	                        width: 100% !important;
	                        clear: both !important;
	                        float: left !important;
	                    }
	                    *[class="code4email_br"] {
	                        display:block !important;
	                        width: 1px !important;
	                        height:6px !important;
	                        clear: both !important;
	                    }
	                    *[class="code4email_text_p10"] {
	                        padding: 0px 10px 10px 10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_w20"] {
	                        width: 20px !important;
	                    }
	                    *[class="code4email_h20"] {
	                        height: 20px !important;
	                    }
	                    *[class="code4email_h20_center"] {
	                        height: 20px !important;
	                        text-align: center !important;
	                    }
	                }
	                @media only screen and (min-width:480px) and (max-width:599px) {
	                    *[class="code4email_wrapper"] {
	                        width: 100% !important;
	                    }
	                    *[class="code4email_main_table"] {
	                        width: 480px !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_center"] {
	                        text-align: center !important;
	                        padding:10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_clear"] {
	                        width: 100% !important;
	                        clear: both !important;
	                        float: left !important;
	                    }
	                    *[class="code4email_br"] {
	                        display:block !important;
	                        width: 1px !important;
	                        height:6px !important;
	                        clear: both !important;
	                    }
	                    *[class="code4email_text_p10"] {
	                        padding: 0px 10px 10px 10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_w20"] {
	                        width: 20px !important;
	                    }
	                    *[class="code4email_h20"] {
	                        height: 20px !important;
	                    }
	                    *[class="code4email_h20_center"] {
	                        height: 20px !important;
	                        text-align: center !important;
	                    }
	                }
	            </style>
	        </head>
	        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
	            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
	                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
	                <tr>
	                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
	                        <tr>
	                            <td>
	                                <a href="'.$liga3.'" target="_blank">
	                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
	                                        <tr>
	                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
	                                                <img src="'.$urlLogoFracc.'" />
	                                            </td>
	                                        </tr>
	                                    </table>
	                                </a>
	                            </td>
	                        </tr>
	                        <tr>
	                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
	                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
	                                    <tr>
	                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
	                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Notificación de Postventa </h3>
	                                            <!--<h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:16px;margin-top: 10px;"> De  </h4>-->
	                                            <br><br>
	                                            '.$cuerpo.'
	                                        </td>
	                                    </tr>
	                                </table>
	                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
	                            </td>
	                        </tr>
	                    </td>
	                </tr>
	            </table>
	        </body>
	        </html>';

	        // para el gerente de ventas -------------------------------------------------
	        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
	        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
	        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";

	        // Cabeceras adicionales
	        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

	        $emailPromotor = $this->musuario->getCampo('email',$info['idPromotor']);
	        if ($emailPromotor){
	        	mail($emailPromotor, $subject, $mensaje, $cabeceras);
	        }
	        //gerente
	        //$para = $this->musuario->getCampo("email", $this->musuario->getGerente2($info['idFraccionamiento']));
			$qGerentes = $this->musuario->getGerentes2($info['idFraccionamiento']);
			if( !is_numeric($qGerentes) ){
				foreach($qGerentes->result() as $gteV){
					$para = $this->musuario->getCampo("email", $gteV->id);
					if ($para){
						mail($para, $subject, $mensaje, $cabeceras);
					}
				}
			}

        	//gestores
	        $dGestores = $this->mfraccionamientoxusuario->getGestoriaSelectResultByIdFracc($info['idFraccionamiento']);
            if ( !is_numeric($dGestores) ) {
                foreach ($dGestores->result() as $row) {
                	mail($this->musuario->getCampo('email',$row->id), $subject, $mensaje, $cabeceras);
                }
            }
            //contadores
            $dContadores = $this->mfraccionamientoxusuario->getContabilidadSelectResultByIdFracc($idFraccionamiento);
	        if ( !is_numeric($dContadores) ) {
	            foreach ($dContadores->result() as $row) {
	                mail($this->musuario->getCampo('email',$row->id), $subject, $mensaje, $cabeceras);
	            }
	        }
	        //tecnica
	        $user_tecnica = $this->mfraccionamientoxusuario->getTecnicaSelectResultByIdFracc($info['idFraccionamiento']);
	        if ( !is_numeric($user_tecnica) ) {
	        	foreach ($user_tecnica->result() as $row) {
	        		$mail_ = $this->musuario->getCampo('email',$row->id);
	        		if ( $mail_ != null && $mail_ != '' ) { mail($mail_, $subject, $mensaje, $cabeceras); }
	        	}
	        }

	        //merca
	        $user_merca = $this->mfraccionamientoxusuario->getRolSelectResultByIdFracc($info['idFraccionamiento'],8);
	        if ( !is_numeric($user_merca) ) {
	        	foreach ($user_merca->result() as $row) {
	        		$mail_ = $this->musuario->getCampo('email',$row->id);
	        		if ( $mail_ != null && $mail_ != '' ) { mail($mail_, $subject, $mensaje, $cabeceras); }
	        	}
	        }

	        //residente
	        $user_residente = $this->mfraccionamientoxusuario->getRolSelectResultByIdFracc($info['idFraccionamiento'],9);
	        if ( !is_numeric($user_residente) ) {
	        	foreach ($user_residente->result() as $row) {
	        		$mail_ = $this->musuario->getCampo('email',$row->id);
	        		if ( $mail_ != null && $mail_ != '' ) { mail($mail_, $subject, $mensaje, $cabeceras); }
	        	}
	        }
	        //postventa
	        $userPostventa = $this->mfraccionamientoxusuario->getPostventaSelectResultByIdFracc( $info['idFraccionamiento'] );
	        if ( !is_numeric($userPostventa) ) {
	        	foreach ($userPostventa->result() as $key => $value) {
	        		$mail = $this->musuario->getCampo('email',$value->id);
	        		if ( !is_null($mail) ) {
	        			mail($para, $subject, $mensaje, $cabeceras);
	        		}
	        	}
	        }


	        $subject2 = $subject;

	        // para el gerente  -------------------------------------------------
	        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
	        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";

	        // Cabeceras adicionales
	        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

	        // para el administrador
	        mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);
	        //echo $mensaje;exit();
	        return true;
	    }

	    public function autoRespuestaIncidencia( $idAltaVenta = null, $idIncidente = null ) {
	        $copiasNV = 'hsalinas@viviend.mx'. ', ';
        	$copiasNV .= 'esalinas@viviend.mx'. ', ';
        	$copiasNV .= 'mejora@viviend.mx'. ', ';
        	$copiasNV .= 'sistemas@viviend.mx';

	        // $para = $emailCliente; // Comprador

	        $subject = 'Notificación de Nueva Incidencia';

	        $liga="http://viviend.mx/sistema/emailresources/";
	        $liga2="http://viviend.mx/sistema/img/";
	        $liga3="http://viviend.mx/sistema/";
	        $idFraccionamiento = $_SESSION['viv']['idFraccionamiento'];
	        $fotoFracc = $this->mfraccionamiento->getCampo('foto',$idFraccionamiento);
	        $urlLogoFracc = ($fotoFracc!=false)?'http://viviend.mx/sistema/uploads/fraccionamientos/'.$fotoFracc:'http://viviend.mx/sistema/img/logo-300.png';
	        $tp = '';

	        $data = array();

	        $info = $this->maltaventa->getByIdForPostventa($idAltaVenta);
	        //$postventa = $this->mpostventa->getByIdAltaVenta($idAltaVenta);

	        $altaVenta=$this->maltaventa->getById($idAltaVenta);

	        $incidencia = $this->mincidente->getById($idIncidente);
	        $m = date("m",strtotime($incidencia['created']));
            $y = date("Y",strtotime($incidencia['created']));
            $folio = $m.$y.$idIncidente;
            $fraccionamiento = $this->mfraccionamiento->getCampo('titulo',$info['idFraccionamiento']);
            $responsable = $this->musuario->getCampo("usuario",$incidencia['created_by']);
            $emailResponsable = $this->musuario->getCampo('email',$incidencia['created_by']);
            $garantias=($incidencia['instElectricas']==1) ? "-"."Inst. ELÉCTRICAS <br>" : "";
            $garantias.=($incidencia['instHidraulicas']==1) ? "-"."Inst. HIDRÁULICAS<br>" : "";
            $garantias.=($incidencia['instSanitarias']==1) ? "-"."Inst. SANITARIAS <br>" : "";
            $garantias.=($incidencia['instGas']==1) ? "-"."Inst. GAS <br>" : "";
            $garantias.=($incidencia['canceleria']==1) ? "-"."CANCELERÍA <br>" : "";
            $garantias.=($incidencia['impermeabilizacion']==1) ? "-"."IMPERMEABILIZACIÓN <br>" : "";
            $garantias.=($incidencia['acabados']==1) ? "-"."ACABADOS <br>" : "";
            $garantias.=($incidencia['estructural']==1) ? "-"."ESTRUCTURAL <br>" : "";
            $garantias.=($incidencia['accesorios']==1) ? "-"."ACCESORIOS <br>" : "";
            $garantias.=($incidencia['calentadorAgua']==1) ? "-"."CALENTADOR <br>" : "";

            $descripcion=($incidencia['descInstElectricas'] != "") ? "-".$incidencia['descInstElectricas']."<br>" : "";
            $descripcion.=($incidencia['descInstHidraulicas'] != "") ? "-".$incidencia['descInstHidraulicas']."<br>" : "";
            $descripcion.=($incidencia['descInstSanitarias'] != "") ? "-".$incidencia['descInstSanitarias']."<br>" : "";
            $descripcion.=($incidencia['descInstGas'] != "") ? "-".$incidencia['descInstGas']."<br>" : "";
            $descripcion.=($incidencia['descCanceleria'] != "") ? "-".$incidencia['descCanceleria']."<br>" : "";
            $descripcion.=($incidencia['descImpermeabilizacion'] != "") ? "-".$incidencia['descImpermeabilizacion']."<br>" : "";
            $descripcion.=($incidencia['descAcabados'] != "") ? "-".$incidencia['descAcabados']."<br>" : "";
            $descripcion.=($incidencia['descEstructural'] != "") ? "-".$incidencia['descEstructural']."<br>" : "";
            $descripcion.=($incidencia['descAccesorios'] != "") ? "-".$incidencia['descAccesorios']."<br>" : "";
            $descripcion.=($incidencia['descCalentadorAgua'] != "") ? "-".$incidencia['descCalentadorAgua']."<br>" : "";


	        $nomPromotor = $this->musuario->getCampo('nombre',$info['idPromotor'])." ".$this->musuario->getCampo('apellidoP',$info['idPromotor'])." ".$this->musuario->getCampo('apellidoM',$info['idPromotor']);

	        /*-----------------------------------------------------------------------------------------------------------------------------------------*/
	        $cuerpo = '<table id="table-blackboard" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
	                        <tbody>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> FOLIO: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$folio.' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> FRACCIONAMIENTO: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$fraccionamiento.' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> LOTE: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['lote'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> MANZANA: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['manzana'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> CLIENTE: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['nombre'].' '.$info['apellidoP'].' '.$info['apellidoM'].' </td>
	                            </tr>

	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> TELÉFONO: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['telefono'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> PROMOTOR: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nomPromotor.' </td>
	                            </tr>

	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> LEVANTA REPORTE: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$responsable.' </td>
	                            </tr>

	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> FECHA INCIDENCIA: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($incidencia['created']),"d-m-Y").' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> GARANTÍA A APLICAR: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$garantias.' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> DESCRIPCIÓN: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$descripcion.' </td>
	                            </tr>
	                        </tbody>
	                    </table>';



	        $mensaje = '
	        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
	        <html xmlns="http://www.w3.org/1999/xhtml">
	        <head>
	            <title>Email</title>
	            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
	            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
	            <style>
	                body, tr, td, span, div, p, a, li {
	                    -moz-text-size-adjust:none !important;
	                    -webkit-text-size-adjust:none !important;
	                    margin:0px !important;
	                    -ms-text-size-adjust:none !important;
	                    white-space: wrap;
	                }
	                .lato-light{
	                    font-family: "lato" sans-serif !important;
	                    font-weight: 300;
	                }
	                .lato-bold{
	                    font-family: "lato" sans-serif !important;
	                    font-weight: 700;
	                }
	                td img {
	                    display: block;
	                }
	                .ReadMsgBody {
	                    width: 100%;
	                }
	                .ExternalClass * {
	                    line-height: 100%;
	                }
	                @media only screen and (max-width:480px) {
	                    #logosim{
	                        padding:0!important;
	                    }
	                    *[class="code4email_wrapper"] {
	                        width: 100% !important;
	                    }
	                    *[class="code4email_main_table"] {
	                        width: 320px !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_center"] {
	                        text-align: center !important;
	                        padding:10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_clear"] {
	                        width: 100% !important;
	                        clear: both !important;
	                        float: left !important;
	                    }
	                    *[class="code4email_br"] {
	                        display:block !important;
	                        width: 1px !important;
	                        height:6px !important;
	                        clear: both !important;
	                    }
	                    *[class="code4email_text_p10"] {
	                        padding: 0px 10px 10px 10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_w20"] {
	                        width: 20px !important;
	                    }
	                    *[class="code4email_h20"] {
	                        height: 20px !important;
	                    }
	                    *[class="code4email_h20_center"] {
	                        height: 20px !important;
	                        text-align: center !important;
	                    }
	                }
	                @media only screen and (min-width:480px) and (max-width:599px) {
	                    *[class="code4email_wrapper"] {
	                        width: 100% !important;
	                    }
	                    *[class="code4email_main_table"] {
	                        width: 480px !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_center"] {
	                        text-align: center !important;
	                        padding:10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_clear"] {
	                        width: 100% !important;
	                        clear: both !important;
	                        float: left !important;
	                    }
	                    *[class="code4email_br"] {
	                        display:block !important;
	                        width: 1px !important;
	                        height:6px !important;
	                        clear: both !important;
	                    }
	                    *[class="code4email_text_p10"] {
	                        padding: 0px 10px 10px 10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_w20"] {
	                        width: 20px !important;
	                    }
	                    *[class="code4email_h20"] {
	                        height: 20px !important;
	                    }
	                    *[class="code4email_h20_center"] {
	                        height: 20px !important;
	                        text-align: center !important;
	                    }
	                }
	            </style>
	        </head>
	        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
	            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
	                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
	                <tr>
	                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
	                        <tr>
	                            <td>
	                                <a href="'.$liga3.'" target="_blank">
	                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
	                                        <tr>
	                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
	                                                <img src="'.$urlLogoFracc.'" />
	                                            </td>
	                                        </tr>
	                                    </table>
	                                </a>
	                            </td>
	                        </tr>
	                        <tr>
	                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
	                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
	                                    <tr>
	                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
	                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Notificación de Incidencia </h3>
	    
	                                            <br><br>
	                                            '.$cuerpo.'
	                                        </td>
	                                    </tr>
	                                </table>
	                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
	                            </td>
	                        </tr>
	                    </td>
	                </tr>
	            </table>
	        </body>
	        </html>';

	        // para el gerente de ventas -------------------------------------------------
	        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
	        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
	        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";

	        // Cabeceras adicionales
	        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

	        if($this->appProduction){
		        $emailPromotor = $this->musuario->getCampo('email',$info['idPromotor']);
		        if ($emailPromotor){
		        	//mail($emailPromotor, $subject, $mensaje, $cabeceras);
		        }
		        //gerente
		        $para = $this->musuario->getCampo("email", $this->musuario->getGerente2($info['idFraccionamiento']));
		        if ($para){
	            	//mail($para, $subject, $mensaje, $cabeceras);
	        	}

	        	if ($emailResponsable){
	        		mail($emailResponsable, $subject, $mensaje, $cabeceras);
	        	}

		        $subject2 = $subject;

		        // para el gerente  -------------------------------------------------
		        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
		        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";

		        // Cabeceras adicionales
		        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

		        // para el administrador
		        mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);
		        //echo $mensaje;exit();
	        }else{
	     		mail('sistemas@viviend.mx', $subject, $mensaje, $cabeceras);
             	mail('sistemas@viviend.mx', $subject, $mensaje, $cabeceras);
             	mail('alfredo@navegantes.mx', $subject, $mensaje, $cabeceras);
             	mail('alvaro@navegantes.mx', $subject, $mensaje, $cabeceras);
		     }

	        return true;
	    }

	    public function listadoIncidencias($csv=false){
	        $incidentes=$this->mincidente->getAll();

	        if (!is_numeric($incidentes)){
	            foreach ($incidentes->result() as $row){
	            	$postventa=$this->mpostventa->getById($row->idPostventa);
	            	$altaVenta=$this->maltaventa->getById($postventa["idAltaVenta"]);
	            	$prospecto=$this->mprospecto->getById($altaVenta["idProspecto"]);

					$garantias="";
	                $garantias.=($row->instElectricas==1) ? valConcat($garantias)."Inst. ELÉCTRICAS<br>" : "";
	                $garantias.=($row->instHidraulicas==1) ? valConcat($garantias)."Inst. HIDRÁULICA<br>" : "";
	                $garantias.=($row->instSanitarias==1) ? valConcat($garantias)."Inst. SANITARIAS<br>" : "";
	                $garantias.=($row->instGas==1) ? valConcat($garantias)."Inst. GAS<br>" : "";
	                $garantias.=($row->canceleria==1) ? valConcat($garantias)."CANCELERÍA<br>" : "";
	                $garantias.=($row->impermeabilizacion==1) ? valConcat($garantias)."IMPERMEABILIZACIÓN<br>" : "";
	                $garantias.=($row->acabados==1) ? valConcat($garantias)."ACABADOS<br>" : "";
	                $garantias.=($row->estructural==1) ? valConcat($garantias)."ESTRUCTURAL<br>" : "";
	                $garantias.=($row->accesorios==1) ? valConcat($garantias)."ACCESORIOS<br>" : "";
	                $garantias.=($row->calentadorAgua==1) ? valConcat($garantias)."CALENTADOR<br>" : "";

					$descripcion="";
	                $descripcion.=($row->descInstElectricas != "") ? valConcat($descripcion).$row->descInstElectricas."<br>" : "";
	                $descripcion.=($row->descInstHidraulicas != "") ? valConcat($descripcion).$row->descInstHidraulicas."<br>" : "";
	                $descripcion.=($row->descInstSanitarias != "") ? valConcat($descripcion).$row->descInstSanitarias."<br>" : "";
	                $descripcion.=($row->descInstGas != "") ? valConcat($descripcion).$row->descInstGas."<br>" : "";
	                $descripcion.=($row->descCanceleria != "") ? valConcat($descripcion).$row->descCanceleria."<br>" : "";
	                $descripcion.=($row->descImpermeabilizacion != "") ? valConcat($descripcion).$row->descImpermeabilizacion."<br>" : "";
	                $descripcion.=($row->descAcabados != "") ? valConcat($descripcion).$row->descAcabados."<br>" : "";
	                $descripcion.=($row->descEstructural != "") ? valConcat($descripcion).$row->descEstructural."<br>" : "";
	                $descripcion.=($row->descAccesorios != "") ? valConcat($descripcion).$row->descAccesorios."<br>" : "";
	                $descripcion.=($row->descCalentadorAgua != "") ? valConcat($descripcion).$row->descCalentadorAgua."<br>" : "";

	                $m = date("m",strtotime($row->created));
	                $y = date("Y",strtotime($row->created));
                	$contratista=$this->mincidente->getConstructorByIdProyecto($altaVenta["idProyecto"]);
	                $array['aaData'][] = array(
	                	'folio' => $m.$y.$row->id,
	                	'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo',$this->mproyecto->getCampo('idFraccionamiento',$altaVenta["idProyecto"])),
	                    'lote' => $this->mproyecto->getCampo('lote',$altaVenta["idProyecto"]),
	                    'manzana' => $this->mproyecto->getCampo('manzana',$altaVenta["idProyecto"]),
	                    'calle' => $this->mproyecto->getCampo('calle',$altaVenta["idProyecto"]),
	                    'nOficial' => $this->mproyecto->getCampo('nOficial',$altaVenta["idProyecto"]),
	                    'cliente' => $this->mprospecto->getCampo('nombre',$altaVenta["idProspecto"])." ".$this->mprospecto->getCampo('apellidoP',$altaVenta["idProspecto"])." ".$this->mprospecto->getCampo('apellidoM',$altaVenta["idProspecto"]),
	                    'telefono' => $this->mprospecto->getCampo('telefono',$altaVenta["idProspecto"]),
	                    'promotor' => $this->musuario->getCampo("nombre",$prospecto["idPromotor"])." ".$this->musuario->getCampo("apellidoP",$prospecto["idPromotor"])." ".$this->musuario->getCampo("apellidoM",$prospecto["idPromotor"]),
	                    'usuario' => $this->musuario->getCampo("usuario",$row->created_by),
	                    'fechaIncidencia' => date_format(new DateTime($row->created),"d-m-Y"),
	                    'garantiaAplicar' => $garantias,
	                    'descripcion' => $descripcion,
	                    'fechaSolucion' => "",
	                    'ronda' => $row->ronda,
	                    'contratista' => !is_numeric($contratista) ? $contratista : $this->mproyecto->getCampo('contratista',$altaVenta["idProyecto"]),
	                    'estatus' => "Abierta",
	                    'acciones' => (!$csv) ? acciones($row->id."-",$this->router->class, false, true, true, '', (!is_numeric($incidentes)?true:false),true,0,false,0,'') : ""
	                    );
	            }
	        }else{
	            $array['aaData'][] = array(
	            	'folio' => '',
	            	'fraccionamiento' => 'No hay registros',
	            	'lote' => 'No hay registros',
	            	'manzana' => 'No hay registros',
	            	'calle' => 'No hay registros',
	            	'nOficial' => 'No hay registros',
	            	'cliente' => 'No hay registros',
	            	'telefono' => 'No hay registros',
	            	'promotor' => 'No hay registros',
	            	'usuario' => 'No hay registros',
	            	'fechaIncidencia' => 'No hay registros',
	            	'garantiaAplicar' => 'No hay registros',
	            	'descripcion' => 'No hay registros',
	            	'fechaSolucion' => 'No hay registros',
	            	'ronda' => 'No hay registros',
	            	'contratista' => 'No hay registros',
	            	'estatus' => 'No hay registros',
	            	'acciones' => 'No hay registros'
	                );
	        }
	        if($csv){
	        	return $array["aaData"];
	        }else{
	        	echo json_encode($array);
	        }
	    }

	    public function listadoIncidenciasCerradas($csv=false){
	        $incidentes=$this->mincidente->getAll(2);

	        if (!is_numeric($incidentes)){
	            foreach ($incidentes->result() as $row){
	            	$postventa=$this->mpostventa->getById($row->idPostventa);
	            	$altaVenta=$this->maltaventa->getById($postventa["idAltaVenta"]);
	            	$prospecto=$this->mprospecto->getById($altaVenta["idProspecto"]);

					$garantias="";
	                $garantias.=($row->instElectricas==1) ? valConcat($garantias)."Inst. ELÉCTRICAS<br>" : "";
	                $garantias.=($row->instHidraulicas==1) ? valConcat($garantias)."Inst. HIDRÁULICA<br>" : "";
	                $garantias.=($row->instSanitarias==1) ? valConcat($garantias)."Inst. SANITARIAS<br>" : "";
	                $garantias.=($row->instGas==1) ? valConcat($garantias)."Inst. GAS<br>" : "";
	                $garantias.=($row->canceleria==1) ? valConcat($garantias)."CANCELERÍA<br>" : "";
	                $garantias.=($row->impermeabilizacion==1) ? valConcat($garantias)."IMPERMEABILIZACIÓN<br>" : "";
	                $garantias.=($row->acabados==1) ? valConcat($garantias)."ACABADOS<br>" : "";
	                $garantias.=($row->estructural==1) ? valConcat($garantias)."ESTRUCTURAL<br>" : "";
	                $garantias.=($row->accesorios==1) ? valConcat($garantias)."ACCESORIOS<br>" : "";
	                $garantias.=($row->calentadorAgua==1) ? valConcat($garantias)."CALENTADOR<br>" : "";

					$descripcion="";
	                $descripcion.=($row->descInstElectricas != "") ? valConcat($descripcion).$row->descInstElectricas."<br>" : "";
	                $descripcion.=($row->descInstHidraulicas != "") ? valConcat($descripcion).$row->descInstHidraulicas."<br>" : "";
	                $descripcion.=($row->descInstSanitarias != "") ? valConcat($descripcion).$row->descInstSanitarias."<br>" : "";
	                $descripcion.=($row->descInstGas != "") ? valConcat($descripcion).$row->descInstGas."<br>" : "";
	                $descripcion.=($row->descCanceleria != "") ? valConcat($descripcion).$row->descCanceleria."<br>" : "";
	                $descripcion.=($row->descImpermeabilizacion != "") ? valConcat($descripcion).$row->descImpermeabilizacion."<br>" : "";
	                $descripcion.=($row->descAcabados != "") ? valConcat($descripcion).$row->descAcabados."<br>" : "";
	                $descripcion.=($row->descEstructural != "") ? valConcat($descripcion).$row->descEstructural."<br>" : "";
	                $descripcion.=($row->descAccesorios != "") ? valConcat($descripcion).$row->descAccesorios."<br>" : "";
	                $descripcion.=($row->descCalentadorAgua != "") ? valConcat($descripcion).$row->descCalentadorAgua."<br>" : "";

	                $m = date("m",strtotime($row->created));
	                $y = date("Y",strtotime($row->created));
	                $contratista=$this->mincidente->getConstructorByIdProyecto($altaVenta["idProyecto"]);

	                $array['aaData'][] = array(
	                	'folio' => $m.$y.$row->id,
	                	'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo',$this->mproyecto->getCampo('idFraccionamiento',$altaVenta["idProyecto"])),
	                    'lote' => $this->mproyecto->getCampo('lote',$altaVenta["idProyecto"]),
	                    'manzana' => $this->mproyecto->getCampo('manzana',$altaVenta["idProyecto"]),
	                    'calle' => $this->mproyecto->getCampo('calle',$altaVenta["idProyecto"]),
	                    'nOficial' => $this->mproyecto->getCampo('nOficial',$altaVenta["idProyecto"]),
	                    'cliente' => $this->mprospecto->getCampo('nombre',$altaVenta["idProspecto"])." ".$this->mprospecto->getCampo('apellidoP',$altaVenta["idProspecto"])." ".$this->mprospecto->getCampo('apellidoM',$altaVenta["idProspecto"]),
	                    'telefono' => $this->mprospecto->getCampo('telefono',$altaVenta["idProspecto"]),
	                    'promotor' => $this->musuario->getCampo("nombre",$prospecto["idPromotor"])." ".$this->musuario->getCampo("apellidoP",$prospecto["idPromotor"])." ".$this->musuario->getCampo("apellidoM",$prospecto["idPromotor"]),
	                    'usuario' => $this->musuario->getCampo("usuario",$row->created_by),
	                    'fechaIncidencia' => date_format(new DateTime($row->created),"d-m-Y"),
	                    'garantiaAplicar' => $garantias,
	                    'descripcion' => $descripcion,
	                    'fechaSolucion' => date_format(new DateTime($row->fechaCierre),"d-m-Y"),
	                    'ronda' => $row->ronda,
	                    'contratista' => !is_numeric($contratista) ? $contratista : $this->mproyecto->getCampo('contratista',$altaVenta["idProyecto"]),
	                    'estatus' => "Cerrada",
	                    'acciones' => acciones($row->id."-",$this->router->class, false, true, true, '', (!is_numeric($incidentes)?true:false),false,0,false,0,'')
	                    );
	            }
	        }else{
	            $array['aaData'][] = array(
	            	'folio' => '',
	            	'fraccionamiento' => 'No hay registros',
	            	'lote' => 'No hay registros',
	            	'manzana' => 'No hay registros',
	            	'calle' => 'No hay registros',
	            	'nOficial' => 'No hay registros',
	            	'cliente' => 'No hay registros',
	            	'telefono' => 'No hay registros',
	            	'promotor' => 'No hay registros',
	            	'usuario' => 'No hay registros',
	            	'fechaIncidencia' => 'No hay registros',
	            	'garantiaAplicar' => 'No hay registros',
	            	'descripcion' => 'No hay registros',
	            	'fechaSolucion' => 'No hay registros',
	            	'ronda' => 'No hay registros',
	            	'contratista' => 'No hay registros',
	            	'estatus' => 'No hay registros',
	            	'acciones' => 'No hay registros'
	                );
	        }
	        if($csv){
	        	return $array["aaData"];
	        }else{
	        	echo json_encode($array);
	        }
	    }

	    public function cerrar(){
	    	$idIncidente=$this->input->post("id");
	        $incidente=$this->mincidente->getById($idIncidente);
	        $this->mincidente->actualizar(array('statusIncidencia' => 2),$idIncidente);
	        $this->mincidente->actualizar(array('fechaCierre' => date_format(new DateTime(),"Y-m-d")),$idIncidente);
	        $this->mpostventa->actualizar(array('statusIncidencia' => 2),$incidente["idPostventa"]);
	    	echo json_encode("ready");
	    }

	    // public function incidencias($id = null){
	    public function formato($id = null){
	    	$incidente=$this->mincidente->getById($id);
        	$postventa=$this->mpostventa->getById($incidente["idPostventa"]);
        	//$altaVenta=$this->maltaventa->getById($postventa["idAltaVenta"]);
        	//$prospecto=$this->mprospecto->getById($altaVenta["idProspecto"]);

	        $this->load->library("mpdf_lib");
	        $data = array();
	        $info = $this->maltaventa->getByIdAll($postventa["idAltaVenta"]);
	        $data = $info;
			$data["entrega"]=$this->mentrega->getByIdAltaVenta($postventa["idAltaVenta"]);

	        $data['mfraccionamiento'] = $this->mfraccionamiento;

	        //Obtenemos el id del incidente en base al idAltaVenta
	        $arrayPostventa = $this->mpostventa->getByIdAltaVenta($id);
			$idPostventa='';
			if(isset($arrayPostventa['id'])){
				$idPostventa = $arrayPostventa['id'];
			}
	        $arrayIncidente = $this->mincidente->getByIdPostventa($idPostventa);
			if(isset($arrayIncidente['id'])){
	        	$data['idIncidente'] = ($arrayIncidente['id']>0)?$arrayIncidente['id']:'';
			}

	        $data['incidencia'] = 0;
	        $dPostventa = $this->mpostventa->getById($incidente["idPostventa"]);
	        if ( !is_numeric($dPostventa) ) {
	        	$data['incidencia'] = $this->mincidente->getById($id);
	        }

            $data["descripcion"]=($data['incidencia']["descInstElectricas"] != "") ? "-".$data['incidencia']["descInstElectricas"]."<br>" : "";
            $data["descripcion"].=($data['incidencia']["descInstHidraulicas"] != "") ? "-".$data['incidencia']["descInstHidraulicas"]."<br>" : "";
            $data["descripcion"].=($data['incidencia']["descInstSanitarias"] != "") ? "-".$data['incidencia']["descInstSanitarias"]."<br>" : "";
            $data["descripcion"].=($data['incidencia']["descInstGas"] != "") ? "-".$data['incidencia']["descInstGas"]."<br>" : "";
            $data["descripcion"].=($data['incidencia']["descCanceleria"] != "") ? "-".$data['incidencia']["descCanceleria"]."<br>" : "";
            $data["descripcion"].=($data['incidencia']["descImpermeabilizacion"] != "") ? "-".$data['incidencia']["descImpermeabilizacion"]."<br>" : "";
            $data["descripcion"].=($data['incidencia']["descAcabados"] != "") ? "-".$data['incidencia']["descAcabados"]."<br>" : "";
            $data["descripcion"].=($data['incidencia']["descEstructural"] != "") ? "-".$data['incidencia']["descEstructural"]."<br>" : "";
            $data["descripcion"].=($data['incidencia']["descAccesorios"] != "") ? "-".$data['incidencia']["descAccesorios"]."<br>" : "";
            $data["descripcion"].=($data['incidencia']["descCalentadorAgua"] != "") ? "-".$data['incidencia']["descCalentadorAgua"]."<br>" : "";

	        $this->idFraccionamiento = $info['idFraccionamiento'];
	        // $this->setLogo();

	        // echo "<pre>"; print_r($data); echo "</pre>"; exit();

	        $html = $this->load->view('formatospdf/incidencias_view.php',$data,true);
	        $this->mpdf_lib->downloadPDF($html,"incidencias",0,'footer','header',$this->urlLogo,'titHeader');
	    }

		public function eliminar(){
			$id = $this->input->post('elid');
			$q = $this->mincidente->getById($id);
			$cValor = "true";
			if(COUNT($q) > 0){
				$this->mincidente->actualizar(["status"=>0],$id);
			}
			$data = json_encode(array("valor" => $cValor));
			echo $data;
		}

	}
 ?>