<?php
	defined('BASEPATH') OR exit('No direct script access allowed');

	class pmat extends MX_Controller {
		public $data,$vParameters,$mainView,$fv;

		public function __construct() {
			$this->nsession = $this->config->item('nsession');
			if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
			$this->fv = 'pmat'; // form validation variable
			$this->mainView = 'pmat';
			$this->data['fjs'] = '';
			$this->data['js'] = ' <script src="assets/js/pmat/listado.js?v=0.2" type="text/javascript"></script>
								  <script src="assets/js/pmat/listadoDetalle.js?v=0.2" type="text/javascript"></script>
								  <script src="assets/js/pmat/listadoResumen.js?v=0.1" type="text/javascript"></script>
								  <script src="assets/js/pmat/bootstrap-fileinput.js" type="text/javascript"></script> ';
			$this->data['css'] = '<link href="assets/css/bootstrap-fileinput.css" rel="stylesheet" type="text/css" />';
			// Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mfraccionamiento', 'mprototipoxfraccionamiento', 'mprototipos', 'mpaquete', 'mactividadesprototipo', 
			'mmaterialesactividadprototipo', 'mmaterial', 'mpresupuestomat','mmateriales', 'munidades', 'mproveedor', 'mareamaterial', 'musuario', 
			'mmanoobra','mordencompra','mdetallepaquete','mpresupuestomo','malmacenes','mconstructores','mempresas','mcategoriamat','marranque',
			'majustes','mpresupuestos','mpmat'));

			$this->load->library('csvimport');
			$this->load->library('excel');
            $this->data['fotos_www'] = $this->config->item('base_www').'/pmat/';
			valSession("materiales",$this->fv);
		}

		public function index(){
			$data['q'] = '';
			$data['msg'] = '';
			$this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
	        $this->load->view('templates/main_template',$this->data);
		}
		
	    public function excel(){
	       $columnas = array(
	                    0 => 'PAQUETE',
	                    1 => 'PROTOTIPO',
	                    2 => 'TOTAL UNITARIO',
	                    3 => 'TOTAL PAQUETE'
	  		);
			$idEmpresa = $_SESSION["viv"]['idEmpresa'];
		    $q = $this->mmaterial->getByIdEmpresa($idEmpresa);
			$array = array();
		    if (!is_numeric($q)){
				foreach ($q->result() as $row){	
					$prototipo = $this->mprototipos->getCampo2('nombre', $row->idPrototipo);
					$paquete = $this->mpaquete->getCampo('titulo', $row->idPaquete);
					$totalUnitario = $this->mpresupuestomat->getSumTotalUnitario($row->id);
					$qPaquete = $this->mpaquete->getById($row->idPaquete);
					$lotesManzana = contarLotesManzanas($qPaquete['rango_lotes']);
					$lotes = $lotesManzana['total'];
					$totalPresupuesto = $totalUnitario * $lotes;
		            $array[] = array(
		                0 => $paquete,
		                1 => $prototipo,
		               	2 => precio_format($totalUnitario),
		               	3 => precio_format($totalPresupuesto)
		            );
		        }
		    }
	       	crearExcel($array,'pmat',$columnas,'array');
	    }

		public function listado(){
			$idEmpresa = $_SESSION["viv"]['idEmpresa'];
	        $q = $this->mpmat->get_datatables($idEmpresa);
	        if (!is_numeric($q)){
				foreach ($q->result() as $row){
					$validar = true;
					$qArranque = $this->db->query("SELECT * FROM arranque WHERE status = 1 AND FIND_IN_SET('$row->idPaquete',idPaquetes)");
					if($qArranque->num_rows() > 0){
						if($qArranque->row()->estatus_arranque == 3){
							$validar = false;
						}
					}
					//$inputFile =  'No disponible';
						$inputFile = '<form id="'. $row->id .'" role="form" enctype="multipart/form-data" action="'. $this->router->class . '/editar/'.$row->id. '" method="post">
											<label><input type="checkbox" name="checkEliminar"> Actualizar Y Eliminar</label><br>
											<div class="form-group">
												<div class="col-md-2">
													<div class="fileinput fileinput-new" data-provides="fileinput">
														<div class="input-group">
															<div class="form-control uneditable-input input-fixed" data-trigger="fileinput">
																<i class="fa fa-file fileinput-exists"></i>&nbsp;
																<span class="fileinput-filename"> </span>
															</div>
															<span class="input-group-addon btn default btn-file">
																<span class="fileinput-new"> Seleccionar </span>
																<span class="fileinput-exists"> Cambiar </span>
																<input type="file" name="archivoMateriales" accept=".csv"> </span>
															<a href="javascript:;" class="input-group-addon btn red fileinput-exists" data-dismiss="fileinput" onClick="editar('.$row->id.');"> Actualizar </a>
														</div>
													</div>
												</div>
											</div>
										</form>';
					//$qEstPaq = $this->db->query('SELECT statusPaquete FROM paquetes WHERE idManoObra = ' . $row->idManoObra . '');
					$eliminar=true;
					$estPaq = $qArranque->row_array();
					/*if (isset($estPaq)) {
						$etPaq = $estPaq['estatus_arranque'];

						switch($etPaq){
							case 2: $inputFile = "<p>Arranque En Curso :  No Puedes Actualizar.</p>";
								$eliminar=false;
								break;
							case 3: $inputFile = "<p>Arranque Finalizado :  No Puedes Actualizar.</p>";
								$eliminar=false;
								break;
							default: break;
						}	
					}*/
					$prototipo = $this->mprototipos->getCampo2('nombre', $row->idPrototipo);
					$paquete = $this->mpaquete->getCampo('titulo', $row->idPaquete);
					$totalUnitario = $this->mpresupuestomat->getSumTotalUnitario($row->id);
					$qPaquete = $this->mpaquete->getById($row->idPaquete);
					$lotesManzana = contarLotesManzanas($qPaquete['rango_lotes']);
					$lotes = $lotesManzana['total'];
					$totalPresupuesto = $totalUnitario * $lotes;
	                $array[] = array(
	                    'paquete' => $paquete,
	                    'prototipo' => $prototipo,
	                   	'totalUnitario' => precio_format($totalUnitario),
	                   	'totalPaquete' => precio_format($totalPresupuesto),
	                    'inputFile' => $inputFile,
	                    'acciones' => accionesPresupuestoMat($row->id, $this->router->class, false, false, $eliminar, $validar, true, true)
	                );
	            }
			}else{
				$array=[];
	        }
			$output = array(
				"draw" => $_POST['draw'],
				"recordsTotal" => $this->mpmat->count_all(),
				"recordsFiltered" => $this->mpmat->count_filtered(),
				"data" => $array,
			);
			//output to json format
			echo json_encode($output);
	    }

		public function nuevo()
	    {
			$data['msg'] = '';
			$data['msgFile'] = '';
			$data['fraccionamientos'] = $this->mfraccionamiento->getAll();
			$data['idEmpresa'] = $_SESSION[$this->nsession]['idEmpresa'];
			$data['prototipos'] = 0;
			$data['manoO'] = 0;
			
			$this->load->library('form_validation');
			if(isset($_POST['idFraccionamiento'])){
				$_POST['archivoMateriales'] = $_FILES['archivoMateriales']['name'];
				if ($this->form_validation->run($this->fv) == FALSE) {
					$data['msg'] = validation_errors();
				}else {
					$edit = 0;
					$mData['idFraccionamiento'] = $this->input->post('idFraccionamiento', TRUE);
					$mData['idPrototipo'] = $this->input->post('idPrototipo', TRUE);
					$mData['idPaquete'] = $this->input->post('idPaquete', TRUE);
					$mData['idEmpresa'] = $_SESSION["viv"]['idEmpresa'];
					$mData['idPresupuesto'] = $this->input->post('idPresupuesto', TRUE);
					$mData['status'] = 1;
					if($_POST["statusArchivo"]==0){
						$this->pptoByPrototipo($mData);
					}else if($_POST["statusArchivo"]==1 ){
						// Importar CSV materiales
						if (isset($_FILES['archivoMateriales']) && $_SERVER['REQUEST_METHOD'] == 'POST' && 
							(intval($mData['idFraccionamiento']) > 0 && intval($mData['idPrototipo']) && intval($mData['idPaquete']))){
							$config['upload_path'] = $this->data['fotos_www'];
							$config['allowed_types'] = 'csv';
							$config['max_size'] = '2000';

							$this->load->library('upload', $config);
							if (!$this->upload->do_upload("archivoMateriales")) {
								$msg = $this->upload->display_errors();
							}else{
								$file_data = $this->upload->data();
								$file_path = $this->data['fotos_www'] . $file_data['file_name'];

								if ($this->csvimport->get_array($file_path, '', TRUE)) {
									$csv_array = $this->csvimport->get_array($file_path);
									$this->db->trans_begin();
									if (isset($csv_array[0]['CLAVE']) && isset($csv_array[0]['CLAVE_CAT']) && isset($csv_array[0]['PRECIO UNITARIO']) && isset($csv_array[0]['SEMANA']) && isset($csv_array[0]['PROVEEDOR'])) {
											$idMaterial = $this->mmaterial->insertar($mData);

											foreach ($csv_array as $r) {
												//INSERTANDO materialesactividadprototipo
												$exist=$this->mmateriales->getByClave($r['CLAVE'], $mData['idEmpresa']);
												if(!is_numeric($exist)){
													//vinculando clave de categoria
													$categoriamat=$this->mcategoriamat->getByClave($r['CLAVE_CAT']);
													if(!is_numeric($categoriamat)){
														$qProveedor = $this->mproveedor->getByNombre($r['PROVEEDOR'], $mData['idEmpresa']);
														if(!is_numeric($qProveedor) && $qProveedor['id'] != ''){
															$mapData['idActividadPrototipo']=0;
															$mapData['idMaterial']=$exist->id;
															$mapData['cantidad']=$r['CANTIDAD'];
															$mapData['tipo']=2;
															$idMap = $this->mmaterialesactividadprototipo->insertar($mapData);

															$pData['idMaterial'] = $idMaterial;
															$pData['idMateriales'] = $idMap;
															$idProveedor = (!is_numeric($qProveedor)) ? $qProveedor['id'] : 0;
															$pData['idProveedor'] = $idProveedor;
															$pData['clave_cat'] = $r['CLAVE_CAT'];
															$pData['clave'] = $r["CLAVE"];
															$pData['precioUnitario'] = (is_numeric($r['PRECIO UNITARIO']) || is_float($r['PRECIO UNITARIO'])) ? $r['PRECIO UNITARIO'] : 0;
															$pData['precioUnitario'] = $pData['precioUnitario'];
															$pData['importe'] = $r['CANTIDAD'] * $pData['precioUnitario'];
															$pData['semana'] = ($r['SEMANA'] != '') ? $r['SEMANA'] : 0;
															$pData['status'] = 1;
															$idPresupuestoMaterial = $this->mpresupuestomat->insertar($pData);
														}else{
															echo "No existe el proveedor ".$r['PROVEEDOR'];
														}
													}else{
														echo "No existe la clave de categoría ".$r['CLAVE_CAT'];
													}
												}else{
													echo "No existe la clave ".$r['CLAVE'];
												}
											}

											$idPaq = $mData['idPaquete'];
											$qPaquete = $this->mpaquete->getById($idPaq);
											if(!is_numeric($qPaquete)){
												$qArranque = $this->db->query("SELECT * FROM arranque WHERE status = 1 AND FIND_IN_SET('$idPaq',idPaquetes)");
												if($qArranque->num_rows() > 0){
													$countPq = 0;
													$countAlmacenes = 0;
													$msgError = '';
													require('Almacenes.php');
													$almacenes = new Almacenes();
													$mData2 = array();
													if($qArranque->row()->estatus_arranque == 2){
														$edit = 1;
														$idEmpresa = $mData['idEmpresa'];
														$countPq++;
														$mData2['un'] = $idEmpresa;
														$mData2['nombre'] = $qPaquete['titulo'];
														$mData2['nombre_abrev'] = $qPaquete['titulo'];
														$mData2['ciudad_id'] = "0";
														$mData2['cp'] = "";
														$mData2['telefono1'] = "";
														$mData2['telefono2'] = "";

														$response = $almacenes->addAlmacen($mData2);

														if($response['error'] == false){
															if($response['responseObject']){
																unset($mData2['un']);
																$mData2['ciudad'] = $mData2['ciudad_id'];
																unset($mData2['ciudad_id']);
																//$idEmpresa = $_SESSION["viv"]['idEmpresa'];
																$mData2['idEmpresa'] = $idEmpresa;
																$mData2['idPaquete'] = $qPaquete['id'];
																$mData2['id'] = $response['resultado']['id'];

																if($this->malmacenes->valInsert($mData['id'],$idEmpresa)){
																	$idAlmacen = $this->malmacenes->insertar($mData2);
																	$countAlmacenes++;
																}
															}else{
																$msgError .= $response['error_message'].'<br><br>';
															}
														}else{
															$msgError .= $response['error_message'].'<br><br>';
														}
													}
												}
											}
											if ($this->db->trans_status() === FALSE){
												$this->db->trans_rollback();
											}else{
												$this->db->trans_commit();
											}
											//Todo correctamente
											redirect($this->router->class. '/detallepmat/' . $idMaterial.'/'.$edit);
									} else {
										// El archivo no tiene columnas especificada
										//$msg = "El archivo no contiene ninguna columna especificada";
									}
									@unlink($file_path);
								}
							}
						}
						//$id = $this->mprototipos->insertar($pData);
					}
					redirect($this->router->class);
				}
			}
			$this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
			$this->load->view('templates/main_template', $this->data);
	    }

		public function pptoByPrototipo($mData){
			$idMaterial=0;
			if($mData["idPresupuesto"]){
				$ppto=$this->mpresupuestos->getById($mData["idPresupuesto"]);
				$pmat=$this->mpresupuestomat->getByIdMaterial($ppto["idPmat"]);
				if(!is_numeric($pmat)){
					$idMaterial = $this->mmaterial->insertar($mData);
					foreach($pmat->result_array() as $rowPmat){
						$mact=$this->mmaterialesactividadprototipo->getById($rowPmat["idMateriales"]);
						unset($mact["id"]);
						unset($mact["msg"]);
						unset($rowPmat["id"]);
						unset($rowPmat["status"]);
						unset($rowPmat["txtstatus"]);
						//inserciones
						$rowPmat["idMateriales"]=$this->mmaterialesactividadprototipo->insertar($mact);
						$rowPmat["idMaterial"]=$idMaterial;
						$this->mpresupuestomat->insertar($rowPmat);
					}
				}
			}	
			return $idMaterial;
		}

	    public function _nuevo()
	    {
			$data['msg'] = '';
			$data['msgFile'] = '';
			$data['fraccionamientos'] = $this->mfraccionamiento->getAll();
			$data['prototipos'] = 0;
			$data['manoO'] = 0;

			$this->load->library('form_validation');
			if(isset($_POST['idFraccionamiento'])){
				$_POST['archivoMateriales'] = $_FILES['archivoMateriales']['name'];
				//redirect($this->router->class.'/detallepmo');
				if ($this->form_validation->run($this->fv) == FALSE) {
					$data['msg'] = validation_errors();
				}else {
					$mData['idFraccionamiento'] = $this->input->post('idFraccionamiento', TRUE);
					$mData['idPrototipo'] = $this->input->post('idPrototipo', TRUE);
					$mData['idManoObra'] = $this->input->post('idManoObra', TRUE);
					$mData['status'] = 1;
					
					$actividadesPrototipo = $this->mactividadesprototipo->getByIdPrototipoManoObra($mData['idPrototipo'], $mData['idManoObra']);
					$arrayMateriales = array();
					$seguir = false;
					//print_r($actividadesPrototipo->result());
					//exit();
					if(!is_numeric($actividadesPrototipo)){
						foreach($actividadesPrototipo->result() as $row){
							$materialesActividadPrototipo = $this->mmaterialesactividadprototipo->getAllMaterialesbyidActividadPrototipo($row->id);
							echo $row->id."<br>";
							print_r($materialesActividadPrototipo);
							exit();
							if(!is_numeric($materialesActividadPrototipo)){
								foreach($materialesActividadPrototipo->result() as $r){
									$material = $this->mmateriales->getById($r->idMaterial);
									if(!is_numeric($material)){
										$seguir = true;
										if (!array_key_exists($material['clave'], $arrayMateriales)) {
											//$arrayMateriales[$material['clave']] = array('idMaterialesPrototipo' => $r->id, 'cantidad' => $r->cantidad, 'precioUnitario' => $material['precioUnitario']);
											//$arrayMateriales[$claveAndActividad] = array('idMaterialesPrototipo' => $r->id, 'cantidad' => $r->cantidad, 'precioUnitario' => $material['precioUnitario']);
											$arrayMateriales[$material['clave']][$r->id] = array('idMaterialesPrototipo' => $r->id, 'cantidad' => $r->cantidad, 'precioUnitario' => $material['precioUnitario']);
										}else{
											$countArray = count($arrayMateriales[$material['clave']]);
											$arrayMateriales[$material['clave']][$r->id] = array('idMaterialesPrototipo' => $r->id, 'cantidad' => $r->cantidad, 'precioUnitario' => $material['precioUnitario']);
										}
									}
								}
							}
						}
					}

					/*$existMaterial = $arrayMateriales['ACE-001'];
					$idArray = $this->db->query('SELECT idMaterialesPrototipo FROM presupuesto_mat WHERE idMaterial = 1');
					$idArray = $idArray->result_array();
					$idArray = array_column($idArray, 'idMaterialesPrototipo');
					$idArray = array_flip($idArray);
					$exist = array_intersect_key($existMaterial, $idArray);
					$key = key($exist);
					//$array = array_diff_key($existMaterial, $idArray);
					unset($arrayMateriales['ACE-001'][$key]);
					echo '<pre>';
					print_r($arrayMateriales);
					echo '</pre>';
					exit();*/

					// Importar CSV Mano de Obra
					if($seguir){
						if (isset($_FILES['archivoMateriales']) && $_SERVER['REQUEST_METHOD'] == 'POST'){
							$config['upload_path'] = $this->data['fotos_www'];
							$config['allowed_types'] = 'csv';
							$config['max_size'] = '2000';

							$this->load->library('upload', $config);
							if (!$this->upload->do_upload("archivoMateriales")) {
								$msg = $this->upload->display_errors();
							}else{
								$file_data = $this->upload->data();
								$file_path = $this->data['fotos_www'] . $file_data['file_name'];

								if ($this->csvimport->get_array($file_path, '', TRUE)) {
									$csv_array = $this->csvimport->get_array($file_path);

									$registros = array();

									if (isset($csv_array[0]['CLAVE']) && isset($csv_array[0]['PRECIO UNITARIO']) && isset($csv_array[0]['SEMANA'])) {
										/*$idPaquete = $this->db->query("SELECT idPaquete FROM material WHERE idFraccionamiento = ". $mData['idFraccionamiento'] ." AND idPrototipo = ". $mData['idPrototipo'] ." AND idPaquete = " . $mData['idPaquete'] . ";");
										if ($idPaquete->num_rows() > 0) {
											//Mensaje de Error no puede existir el paquete mas 1 una vez
										}else{*/
											$idMaterial = $this->mmaterial->insertar($mData);
											foreach ($csv_array as $r) {
												if (count($arrayMateriales) > 0) {
													if (array_key_exists($r['CLAVE'], $arrayMateriales)) {
														$existMaterial = $arrayMateriales[$r['CLAVE']];
														$idArray = $this->db->query('SELECT idMaterialesPrototipo FROM presupuesto_mat WHERE idMaterial = '. $idMaterial);
														$idArray = $idArray->result_array();
														$idArray = array_column($idArray, 'idMaterialesPrototipo');
														$idArray = array_flip($idArray);
														$search = array_diff_key($existMaterial, $idArray);
														if(count($search) > 0){
															$selectArray = current($search);
															$pData['idMaterial'] = $idMaterial;
															$pData['idMaterialesPrototipo'] = $selectArray['idMaterialesPrototipo'];
															$pData['precioUnitario'] = ($r['PRECIO UNITARIO'] != '') ? $r['PRECIO UNITARIO'] : $selectArray['precioUnitario'];
															$pData['precioUnitario'] = round($pData['precioUnitario'], 2);
															$pData['importe'] = round($selectArray['cantidad'] * $pData['precioUnitario'], 2);
															$pData['semana'] = ($r['SEMANA'] != '') ? $r['SEMANA'] : 0;
															$pData['status'] = 1;

															$idPresupuestoMaterial = $this->mpresupuestomat->insertar($pData);
														}
													} else {
														//key no existe la clave de la actividad, No esta dado de alta
													}
												}
												
											}
											//Todo correctamente

											redirect($this->router->class. '/detallepmat/' . $idMaterial);
										//}

									} else {
										// El archivo no tiene columnas especificada
										//$msg = "El archivo no contiene ninguna columna especificada";
									}
									@unlink($file_path);
								}
							}
						}
					}else{
						//No se pudo realizar la importación
					}

					//$id = $this->mprototipos->insertar($pData);
					redirect($this->router->class);
				}
			}
			$this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
			$this->load->view('templates/main_template', $this->data);
	    }

	    public function _editar($id = null)
	    {
			$idMaterial = $id;
			$idManoObra = $this->mmaterial->getCampo2('idManoObra', $idMaterial);
			$idPrototipo = $this->mmaterial->getCampo2('idPrototipo', $idMaterial);
			$actualizados = 0;
			$registrados = 0;
			$noRegistrados = 0;
			$eliminados = 0;
			$noEliminados = 0;
			if(isset($_FILES['archivoMateriales']) && !empty($_FILES['archivoMateriales']['name'])){
				$checkEliminar = $this->input->post('checkEliminar', TRUE);
				$actividadesPrototipo = $this->mactividadesprototipo->getByIdPrototipoManoObra($idPrototipo, $idManoObra);
				$arrayPresupuestoMAT = array();
				$seguir = false;
				if (!is_numeric($actividadesPrototipo)) {
					foreach ($actividadesPrototipo->result() as $row) {
						$materialesActividadPrototipo = $this->mmaterialesactividadprototipo->getMaterialesNews($row->id);
						if(!is_numeric($materialesActividadPrototipo)){
							foreach($materialesActividadPrototipo->result() as $r){
								$material = $this->mmateriales->getById($r->idMaterial);
								if(!is_numeric($material)){
									$seguir = true;
									if (!array_key_exists($material['clave'], $arrayPresupuestoMAT)) {
										$arrayPresupuestoMAT[$material['clave']][$r->id] = array('idPresupuestoMAT' => $r->idPresupuestoMAT, 'idMaterialesPrototipo' => $r->id, 'cantidad' => $r->cantidad, 'precioUnitario' => $material['precioUnitario'], 'precioUnitarioActual' => $r->precioUnitario, 'semanaActual' => $r->semana);
									}else{
										$arrayPresupuestoMAT[$material['clave']][$r->id] = array('idPresupuestoMAT' => $r->idPresupuestoMAT, 'idMaterialesPrototipo' => $r->id, 'cantidad' => $r->cantidad, 'precioUnitario' => $material['precioUnitario'], 'precioUnitarioActual' => $r->precioUnitario, 'semanaActual' => $r->semana);
									}
								}
							}
						}
					}
				}

				if($seguir){
					if (isset($_FILES['archivoMateriales']) && $_SERVER['REQUEST_METHOD'] == 'POST') {
						$config['upload_path'] = $this->data['fotos_www'];
						$config['allowed_types'] = 'csv';
						$config['max_size'] = '2000';

						$this->load->library('upload', $config);
						if (!$this->upload->do_upload("archivoMateriales")) {
							$msg = $this->upload->display_errors();
						} else {
							$file_data = $this->upload->data();
							$file_path = $this->data['fotos_www'] . $file_data['file_name'];

							if ($this->csvimport->get_array($file_path, '', TRUE)) {
								$csv_array = $this->csvimport->get_array($file_path);

								/*$actualizados = 0;
								$registrados = 0;
								$noRegistrados = 0;
								$eliminados = 0;
								$noEliminados = 0;*/

								if($checkEliminar == 'on'){
									if (isset($csv_array[0]['CLAVE']) && isset($csv_array[0]['PRECIO UNITARIO']) && isset($csv_array[0]['SEMANA'])) {
										foreach ($csv_array as $r) {
											if (count($arrayPresupuestoMAT) > 0) {
												if (array_key_exists($r['CLAVE'], $arrayPresupuestoMAT)) {
													$existMaterial = $arrayPresupuestoMAT[$r['CLAVE']];
													$key = key($existMaterial);
													$selectArray = current($existMaterial);
													if($selectArray['idPresupuestoMAT'] != ''){
														$uData['precioUnitario'] = ($r['PRECIO UNITARIO'] != '') ? $r['PRECIO UNITARIO'] : $selectArray['precioUnitario'];
														$uData['precioUnitario'] = round ($uData['precioUnitario'], 2);
														$uData['importe'] = round($selectArray['cantidad'] * $uData['precioUnitario'], 2);
														$uData['semana'] = $r['SEMANA'];
														if ($uData['precioUnitario'] != $selectArray['precioUnitarioActual'] || $selectArray['semanaActual'] != $r['SEMANA']) {
															$existInOrdenCompra = $this->mpresupuestomat->getByIdMaterialSemanaIn($idMaterial, $uData['semana']);
															if(is_numeric($existInOrdenCompra)){
																$idPresupuestoMaterial = $this->mpresupuestomat->actualizar($uData, $selectArray['idPresupuestoMAT']);
																$actualizados++;
															}else{
																$noRegistrados++;
															}
														}
													}else{
														//Nuevos
														$pData['idMaterial'] = $idMaterial;
														$pData['idMaterialesPrototipo'] = $selectArray['idMaterialesPrototipo'];
														$pData['precioUnitario'] = ($r['PRECIO UNITARIO'] != '') ? $r['PRECIO UNITARIO'] : $selectArray['precioUnitario'];
														$pData['precioUnitario'] = round($pData['precioUnitario'], 2);
														$pData['importe'] = round($selectArray['cantidad'] * $pData['precioUnitario'], 2);
														$pData['semana'] = $r['SEMANA'];
														$pData['status'] = 1;
														$existInOrdenCompra = $this->mpresupuestomat->getByIdMaterialSemanaIn($idMaterial, $pData['semana']);
														if(is_numeric($existInOrdenCompra)){
															$idPresupuestoMaterial = $this->mpresupuestomat->insertar($pData);
															$registrados++;
														}else{
															$noRegistrados++;
														}
													}
													
													unset($arrayPresupuestoMAT[$r['CLAVE']][$key]);
													if(count($arrayPresupuestoMAT[$r['CLAVE']]) > 0){

													}else{
														unset($arrayPresupuestoMAT[$r['CLAVE']]);
													}
													//}
												} else {
													//key no existe la clave de la actividad, No esta dado de alta
												}
											}
										}
										if(count($arrayPresupuestoMAT) > 0){
											foreach($arrayPresupuestoMAT as $key=>$value){
												$arrayPresupuesto = $arrayPresupuestoMAT[$key];
												foreach($arrayPresupuesto as $k=>$v){
													if($v['idPresupuestoMAT'] != ''){
														$ordenCompra = $this->mpresupuestomat->getByIdMaterialSemanaIn($idMaterial, $v['semanaActual']);
														if(!is_numeric($ordenCompra)){
															$noEliminados++;
														}else{
															$this->mpresupuestomat->borrar($v['idPresupuestoMAT']);
															$eliminados++;
														}
													}
												}											
												//print_r($value[]['idPresupuestoMAT']);
											}
										}
										//Todo correctamente
									} else {
										// El archivo no tiene columnas especificada
										//$msg = "El archivo no contiene ninguna columna especificada";
									}
								}else{
									if (isset($csv_array[0]['CLAVE']) && isset($csv_array[0]['PRECIO UNITARIO']) && isset($csv_array[0]['SEMANA'])) {
										foreach ($csv_array as $r) {
											if (count($arrayPresupuestoMAT) > 0) {
												if (array_key_exists($r['CLAVE'], $arrayPresupuestoMAT)) {
													$existMaterial = $arrayPresupuestoMAT[$r['CLAVE']];
													$key = key($existMaterial);
													$selectArray = current($existMaterial);
													if($selectArray['idPresupuestoMAT'] != ''){
														$uData['precioUnitario'] = ($r['PRECIO UNITARIO'] != '') ? $r['PRECIO UNITARIO'] : $selectArray['precioUnitario'];
														$uData['precioUnitario'] = round ($uData['precioUnitario'], 2);
														$uData['importe'] = round($selectArray['cantidad'] * $uData['precioUnitario'], 2);
														$uData['semana'] = $r['SEMANA'];
														if ($uData['precioUnitario'] != $selectArray['precioUnitarioActual'] || $selectArray['semanaActual'] != $r['SEMANA']) {
															$existInOrdenCompra = $this->mpresupuestomat->getByIdMaterialSemanaIn($idMaterial, $uData['semana']);
															if(is_numeric($existInOrdenCompra)){
																$idPresupuestoMaterial = $this->mpresupuestomat->actualizar($uData, $selectArray['idPresupuestoMAT']);
																$actualizados++;
															}else{
																$noRegistrados++;
															}
														}
													}else{
														//Nuevos
														$pData['idMaterial'] = $idMaterial;
														$pData['idMaterialesPrototipo'] = $selectArray['idMaterialesPrototipo'];
														$pData['precioUnitario'] = ($r['PRECIO UNITARIO'] != '') ? $r['PRECIO UNITARIO'] : $selectArray['precioUnitario'];
														$pData['precioUnitario'] = round($pData['precioUnitario'], 2);
														$pData['importe'] = round($selectArray['cantidad'] * $pData['precioUnitario'], 2);
														$pData['semana'] = $r['SEMANA'];
														$pData['status'] = 1;
														$existInOrdenCompra = $this->mpresupuestomat->getByIdMaterialSemanaIn($idMaterial, $pData['semana']);
														if(is_numeric($existInOrdenCompra)){
															$idPresupuestoMaterial = $this->mpresupuestomat->insertar($pData);
															$registrados++;
														}else{
															$noRegistrados++;
														}
													}
													
													unset($arrayPresupuestoMAT[$r['CLAVE']][$key]);
													if(count($arrayPresupuestoMAT[$r['CLAVE']]) > 0){

													}else{
														unset($arrayPresupuestoMAT[$r['CLAVE']]);
													}
													//}
												} else {
													//key no existe la clave de la actividad, No esta dado de alta
												}
											}
										}
										//Todo correctamente
									} else {
										// El archivo no tiene columnas especificada
										//$msg = "El archivo no contiene ninguna columna especificada";
									}
								}
								@unlink($file_path);
							}
						}
					}
				}else{
					//No se pudo importar el archivo
				}
			}

			if($checkEliminar == 'on'){
				$data['msg'] = "<div style='text-align: center'>
									<p> Registros Actualizados : ".$actualizados."</p>
									<p> Registros Insertados : ".$registrados."</p>
									<p> Registros Eliminados : ".$eliminados."</p>
									<p> Registros que no se pudieron actualizar y/o registrar porque ya existe una orden de compra : ".$noRegistrados."</p>
									<p> Registros que no se pudieron eliminar porque ya existe una orden de compra : ".$noEliminados."</p>
								</div>";
			}else{
				$data['msg'] = "<div style='text-align: center'>
									<p> Registros Actualizados : ".$actualizados."</p>
									<p> Registros Insertados : ".$registrados."</p>
									<p> Registros que no se pudieron actualizar y/o registrar porque ya existe una orden de compra : ".$noRegistrados."</p>
								</div>";
			}
			$this->data['contenido'] = $this->load->view($this->mainView . '/index_view', $data, true);
			$this->load->view('templates/main_template', $this->data);
		}

		public function editar($id=null){
			$idMaterial = $id;
			$idEmpresa=$_SESSION["viv"]['idEmpresa'];
			$config['upload_path'] = $this->data['fotos_www'];
			$config['allowed_types'] = 'csv';
			$config['max_size'] = '2000';

			$this->load->library('upload', $config);
			if ($this->upload->do_upload("archivoMateriales")) {
				$config['upload_path'] = $this->data['fotos_www'];
				$file_data = $this->upload->data();
				$file_path = $this->data['fotos_www'] . $file_data['file_name'];
				$csv_array = $this->csvimport->get_array($file_path);
				$this->db->query("DELETE FROM presupuesto_mat WHERE idMaterial=$id");
				if (isset($csv_array[0]['CLAVE']) && isset($csv_array[0]['CLAVE_CAT']) && isset($csv_array[0]['PRECIO UNITARIO']) && isset($csv_array[0]['SEMANA']) && isset($csv_array[0]['PROVEEDOR'])) {
						foreach ($csv_array as $r) {
							//INSERTANDO materialesactividadprototipo
							$exist=$this->mmateriales->getByClave($r['CLAVE'], $idEmpresa);
							if(!is_numeric($exist)){
								$qProveedor = $this->mproveedor->getByNombre($r['PROVEEDOR'], $idEmpresa);
								if(!is_numeric($qProveedor) && $qProveedor['id'] != ''){
									$categoriamat=$this->mcategoriamat->getByClave($r['CLAVE_CAT']);
									if(!is_numeric($categoriamat)){
										$mapData['idActividadPrototipo']=0;
										$mapData['idMaterial']=$exist->id;
										$mapData['cantidad']=$r['CANTIDAD'];
										$mapData['tipo']=2;
										$idMap = $this->mmaterialesactividadprototipo->insertar($mapData);

										$pData['idMaterial'] = $idMaterial;
										$pData['idMateriales'] = $idMap;
										$idProveedor = (!is_numeric($qProveedor)) ? $qProveedor['id'] : 0;
										$pData['idProveedor'] = $idProveedor;
										$pData['clave'] = $r["CLAVE"];
										$pData['clave_cat'] = $r["CLAVE_CAT"];
										$pData['precioUnitario'] = (is_numeric($r['PRECIO UNITARIO']) || is_float($r['PRECIO UNITARIO'])) ? $r['PRECIO UNITARIO'] : 0;
										$pData['precioUnitario'] = $pData['precioUnitario'];
										$pData['importe'] = $r['CANTIDAD'] * $pData['precioUnitario'];
										$pData['semana'] = ($r['SEMANA'] != '') ? $r['SEMANA'] : 0;
										$pData['status'] = 1;
										$idPresupuestoMaterial = $this->mpresupuestomat->insertar($pData);
									}else{
										echo $r['CLAVE_CAT']." categoría no existe<br>";
									}
								}else{
									echo $r['PROVEEDOR']." proveedor no existe<br>";
								}
							}else{
								echo $r["CLAVE"]." clave no existe<br>";
							}
						}
					}
			}
			redirect($this->router->class);
		}
		
		public function __editar($id = null)
		{
			$idMaterial = $id;
			$material = $this->mmaterial->getById($id);
			$paquete = $this->mpaquete->getById($material['idPaquete']);
			$idManoObra = $paquete['idManoObra'];
			$idPrototipo = $material['idPrototipo'];
			$idEmpresa = (!is_numeric($material)) ? $material['idEmpresa'] : 0;
			$materialesPresupuesto = $this->mpresupuestomat->getByIdMaterial($material['id'], 0);
			$actualizados = 0;
			$noActualizadosOc = 0;
			$registrados = 0;
			$noRegistradosProveedor = 0;
			$noRegistradosOc = 0;
			$eliminados = 0;
			$noEliminadosOc = 0;
			if(isset($_FILES['archivoMateriales']) && !empty($_FILES['archivoMateriales']['name'])){
				$empty = true;
				$checkEliminar = $this->input->post('checkEliminar', TRUE);
				if (!is_numeric($materialesPresupuesto)) {
					$arrayPresupuestoMAT = array();
					foreach ($materialesPresupuesto->result() as $row) {
						$materialActividadPrototipo = $this->mmaterialesactividadprototipo->getById($row->idMateriales);
						if(!is_numeric($materialActividadPrototipo)){
							$material = $this->mmateriales->getById2($materialActividadPrototipo['idMaterial'], $material["idEmpresa"]);
							if(!is_numeric($material)){
								$empty = false;
								$proveedor = $this->mproveedor->getCampo2('nombre', $row->idProveedor);
								if (!array_key_exists($material['clave'], $arrayPresupuestoMAT)) {
									$arrayPresupuestoMAT[$material['clave']][$row->id] = array('clave' => $material['clave'], 'idMaterial' => $material['id'], 'idPresupuestoMAT' => $row->id, 'idMaterialesPrototipo' => $materialActividadPrototipo['id'], 'proveedor' => $proveedor, 'idProveedor' => $row->idProveedor, 'cantidad' => $materialActividadPrototipo['cantidad'], 'precioUnitario' => $row->precioUnitario, 'semana' => $row->semana);
								}else{
									$arrayPresupuestoMAT[$material['clave']][$row->id] = array('clave' => $material['clave'], 'idMaterial' => $material['id'], 'idPresupuestoMAT' => $row->id, 'idMaterialesPrototipo' => $materialActividadPrototipo['id'], 'proveedor' => $proveedor, 'idProveedor' => $row->idProveedor, 'cantidad' => $materialActividadPrototipo['cantidad'], 'precioUnitario' => $row->precioUnitario, 'semana' => $row->semana);
								}
							}
						}
					}
				}

				if(!$empty){
					if (isset($_FILES['archivoMateriales']) && $_SERVER['REQUEST_METHOD'] == 'POST') {
						$config['upload_path'] = $this->data['fotos_www'];
						$config['allowed_types'] = 'csv';
						$config['max_size'] = '2000';

						$this->load->library('upload', $config);
						if (!$this->upload->do_upload("archivoMateriales")) {
							$msg = $this->upload->display_errors();
						}else{
							$file_data = $this->upload->data();
							$file_path = $this->data['fotos_www'] . $file_data['file_name'];

							if ($this->csvimport->get_array($file_path, '', TRUE)) {
								$csv_array = $this->csvimport->get_array($file_path);

								if (isset($csv_array[0]['CLAVE']) && isset($csv_array[0]['PRECIO UNITARIO']) && isset($csv_array[0]['SEMANA'])) {
									foreach ($csv_array as $r) {
										if (count($arrayPresupuestoMAT) > 0) {
											if (array_key_exists($r['CLAVE'], $arrayPresupuestoMAT)) {
												$existMaterial = $arrayPresupuestoMAT[$r['CLAVE']];
												$existeKey = 0;
												foreach ($existMaterial as $key => $value) {
													if($existMaterial[$key]['clave'] == $r['CLAVE'] && $existMaterial[$key]['proveedor'] == $r['PROVEEDOR'] && $existMaterial[$key]['semana'] == $r['SEMANA']){
														//Se busca si hay coincidencias de semanas en ese material
														$existeKey = $key;
													}
												}
												
												if($existeKey > 0){
													//Se actualiza
													$existInOrdenCompra = $this->mpresupuestomat->getByIdMaterialSemanaIn($idMaterial, $r['SEMANA']);
													if(is_numeric($existInOrdenCompra)){
														$mapUData['idActividadPrototipo']=0;
														$mapUData['idMaterial']=$existMaterial[$existeKey]['idMaterial'];
														$mapUData['cantidad']=$r['CANTIDAD'];
														$mapUData['tipo']=2;

														$this->mmaterialesactividadprototipo->actualizar($mapUData, $existMaterial[$existeKey]['idMaterialesPrototipo']);

														$uData['idMaterial'] = $idMaterial;
														$uData['idMateriales'] = $existMaterial[$existeKey]['idMaterialesPrototipo'];
														$uData['idProveedor'] = $existMaterial[$existeKey]['idProveedor'];
														$uData['precioUnitario'] = (is_numeric($r['PRECIO UNITARIO']) || is_float($r['PRECIO UNITARIO'])) ? $r['PRECIO UNITARIO'] : 0;
														$uData['precioUnitario'] = round($uData['precioUnitario'], 2);
														$uData['importe'] = round($r['CANTIDAD'] * $uData['precioUnitario'], 2);
														$uData['semana'] = ($r['SEMANA'] != '') ? $r['SEMANA'] : 0;
														$uData['status'] = 1;

														$this->mpresupuestomat->actualizar($uData, $existMaterial[$existeKey]['idPresupuestoMAT']);

														$actualizados++;

														unset($arrayPresupuestoMAT[$r['CLAVE']][$existeKey]);
														if(count($arrayPresupuestoMAT[$r['CLAVE']]) > 0){

														}else{
															unset($arrayPresupuestoMAT[$r['CLAVE']]);
														}
													}else{
														$noActualizadosOc++;
														unset($arrayPresupuestoMAT[$r['CLAVE']][$existeKey]);
														if(count($arrayPresupuestoMAT[$r['CLAVE']]) > 0){

														}else{
															unset($arrayPresupuestoMAT[$r['CLAVE']]);
														}
													}
												}else{
													//Se inserta
													$existInOrdenCompra = $this->mpresupuestomat->getByIdMaterialSemanaIn($idMaterial, $r['SEMANA']);
													if(is_numeric($existInOrdenCompra)){
														$qProveedor = $this->mproveedor->getByNombre($r['PROVEEDOR'],$idEmpresa);
														if(!is_numeric($qProveedor) && $qProveedor['id'] != ''){
															$exist=$this->mmateriales->getByClave($r['CLAVE'], $idEmpresa);
															$mapData['idActividadPrototipo']=0;
															$mapData['idMaterial']=$exist->id;
															$mapData['cantidad']=$r['CANTIDAD'];
															$mapData['tipo']=2;
															$idMap = $this->mmaterialesactividadprototipo->insertar($mapData);

															$pData['idMaterial'] = $idMaterial;
															$pData['idMateriales'] = $idMap;
															$idProveedor = (!is_numeric($qProveedor)) ? $qProveedor['id'] : 0;
															$pData['idProveedor'] = $idProveedor;
															$pData['precioUnitario'] = (is_numeric($r['PRECIO UNITARIO']) || is_float($r['PRECIO UNITARIO'])) ? $r['PRECIO UNITARIO'] : 0;
															$pData['precioUnitario'] = round($pData['precioUnitario'], 2);
															$pData['importe'] = round($r['CANTIDAD'] * $pData['precioUnitario'], 2);
															$pData['semana'] = ($r['SEMANA'] != '') ? $r['SEMANA'] : 0;
															$pData['status'] = 1;
															$idPresupuestoMaterial = $this->mpresupuestomat->insertar($pData);

															$registrados++;
														}else{
															$noRegistradosProveedor++;
														}
													}else{
														$noRegistradosOc++;
													}
												}
											}else{
												//Insertar Nuevo Material
												$existInOrdenCompra = $this->mpresupuestomat->getByIdMaterialSemanaIn($idMaterial, $r['SEMANA']);
												if(is_numeric($existInOrdenCompra)){
													$qProveedor = $this->mproveedor->getByNombre($r['PROVEEDOR'],$idEmpresa);
													if(!is_numeric($qProveedor) && $qProveedor['id'] != ''){
														
														$exist=$this->mmateriales->getByClave($r['CLAVE'], $idEmpresa);
														if(!is_numeric($exist)){
															$mapData['idActividadPrototipo']=0;
															$mapData['idMaterial']=$exist->id;
															$mapData['cantidad']=$r['CANTIDAD'];
															$mapData['tipo']=2;
															$idMap = $this->mmaterialesactividadprototipo->insertar($mapData);

															$pData['idMaterial'] = $idMaterial;
															$pData['idMateriales'] = $idMap;
															$idProveedor = (!is_numeric($qProveedor)) ? $qProveedor['id'] : 0;
															$pData['idProveedor'] = $idProveedor;
															$pData['precioUnitario'] = (is_numeric($r['PRECIO UNITARIO']) || is_float($r['PRECIO UNITARIO'])) ? $r['PRECIO UNITARIO'] : 0;
															$pData['precioUnitario'] = round($pData['precioUnitario'], 2);
															$pData['importe'] = round($r['CANTIDAD'] * $pData['precioUnitario'], 2);
															$pData['semana'] = ($r['SEMANA'] != '') ? $r['SEMANA'] : 0;
															$pData['status'] = 1;
															$idPresupuestoMaterial = $this->mpresupuestomat->insertar($pData);

															$registrados++;
														}
													}else{
														$noRegistradosProveedor++;
													}
												}else{
													$noRegistradosOc++;
												}
											}
										}else{
											//Insertar Nuevo Material
											$existInOrdenCompra = $this->mpresupuestomat->getByIdMaterialSemanaIn($idMaterial, $r['SEMANA']);
											if(is_numeric($existInOrdenCompra)){
												$qProveedor = $this->mproveedor->getByNombre($r['PROVEEDOR'],$idEmpresa);
												if(!is_numeric($qProveedor) && $qProveedor['id'] != ''){
													
													$exist=$this->mmateriales->getByClave($r['CLAVE'], $idEmpresa);
													$mapData['idActividadPrototipo']=0;
													$mapData['idMaterial']=$exist->id;
													$mapData['cantidad']=$r['CANTIDAD'];
													$mapData['tipo']=2;
													$idMap = $this->mmaterialesactividadprototipo->insertar($mapData);

													$pData['idMaterial'] = $idMaterial;
													$pData['idMateriales'] = $idMap;
													$idProveedor = (!is_numeric($qProveedor)) ? $qProveedor['id'] : 0;
													$pData['idProveedor'] = $idProveedor;
													$pData['precioUnitario'] = (is_numeric($r['PRECIO UNITARIO']) || is_float($r['PRECIO UNITARIO'])) ? $r['PRECIO UNITARIO'] : 0;
													$pData['precioUnitario'] = round($pData['precioUnitario'], 2);
													$pData['importe'] = round($r['CANTIDAD'] * $pData['precioUnitario'], 2);
													$pData['semana'] = ($r['SEMANA'] != '') ? $r['SEMANA'] : 0;
													$pData['status'] = 1;
													$idPresupuestoMaterial = $this->mpresupuestomat->insertar($pData);

													$registrados++;

												}else{
													$noRegistradosProveedor++;
												}
											}else{
												$noRegistradosOc++;
											}
										}
									}

									if($checkEliminar == 'on'){
										foreach ($arrayPresupuestoMAT as $key => $value) {
											if(count($arrayPresupuestoMAT[$key]) > 0){
												$array = $arrayPresupuestoMAT[$key];
												foreach ($array as $k => $v) {
													$existInOrdenCompra = $this->mpresupuestomat->getByIdMaterialSemanaIn($idMaterial, $v['semana']);
													if(is_numeric($existInOrdenCompra)){
														$this->mmaterialesactividadprototipo->borrar($v['idMaterialesPrototipo']);
														$this->mpresupuestomat->borrar($v['idPresupuestoMAT']);
														$eliminados++;
													}else{
														$noEliminadosOc++;
													}
												}
											}
										}
									}
									
								}
								@unlink($file_path);
							}
						}
					}
				}
			}

			if($checkEliminar == 'on'){
				$data['msg'] = "<div style='text-align: center'>
									<p> Registros Actualizados : <span style='color: red;'> ".$actualizados." <span/></p>
									<p> Registros Insertados : <span style='color: red;'> ".$registrados."<span/></p>
									<p> Registros Eliminados : <span style='color: red;'> ".$eliminados."<span/></p>
									<p> Registros que no se pudieron actualizar porque ya existe una orden de compra : <span style='color: red;'> ".$noActualizadosOc."<span/></p>
									<p> Registros que no se pudieron insertar porque ya existe una orden de compra : <span style='color: red;'> ".$noRegistradosOc."<span/></p>
									<p> Registros que no se pudieron insertar porque no existe un proveedor : <span style='color: red;'> ".$noRegistradosProveedor."<span/></p>
									<p> Registros que no se pudieron eliminar porque ya existe una orden de compra : <span style='color: red;'> ".$noEliminadosOc."<span/></p>
								</div>";
			}else{
				$data['msg'] = "<div style='text-align: center'>
									<p> Registros Actualizados : <span style='color: red;'> ".$actualizados."<span/></p>
									<p> Registros Insertados : <span style='color: red;'> ".$registrados."<span/></p>
									<p> Registros que no se pudieron actualizar porque ya existe una orden de compra : <span style='color: red;'> ".$noActualizadosOc."<span/></p>
									<p> Registros que no se pudieron insertar porque ya existe una orden de compra : <span style='color: red;'> ".$noRegistradosOc."<span/></p>
									<p> Registros que no se pudieron insertar porque no existe un proveedor : <span style='color: red;'> ".$noRegistradosProveedor."<span/></p>
								</div>";
			}

			$this->data['contenido'] = $this->load->view($this->mainView . '/index_view', $data, true);
			$this->load->view('templates/main_template', $this->data);
		}

		public function eliminar(){
			$id = $this->input->post('elid');
			$q = $this->mmaterial->getById($id);
			$cValor = "true";
			$valorBorrar = $this->mmaterial->borrar($id);
			$this->db->query("DELETE FROM presupuesto_mat WHERE idMaterial=$id");
			$data = json_encode(array("valor" => $cValor));
			echo $data;
		}

	    public function detallepmat($id=0, $edit=0){
			$data["msg"] = "";
			$data['material'] = $material = $this->mmaterial->getById($id);
			$idPaq = $data['material']['idPaquete'];
			$data['claveMateriales'] = $this->mmateriales->getSelectResult();
			$data['proveedores'] = $this->mproveedor->getSelectResult();

			$qPaquetePmat = $this->mpaquete->getById($idPaq);

			$idPrototipo = $this->mmanoobra->getCampo('idPrototipo', $qPaquetePmat['idManoObra']);
			$superficieM2 = $this->mprototipos->getCampo('superficieM2',$idPrototipo);
			$lotesManzana = contarLotesManzanas($qPaquetePmat['rango_lotes']);
			$idFraccionamiento = $this->mmanoobra->getCampo('idFraccionamiento', $qPaquetePmat['idManoObra']);
	        $totalPresupuestoMO = $this->mpresupuestomo->getSumTotalUnitario($qPaquetePmat["idManoObra"]);
	        $totalUnitario = $totalPresupuestoMO;
			$costoM2 = $totalUnitario / $superficieM2;
	        $lotesManzana = contarLotesManzanas($qPaquetePmat['rango_lotes']);
	        $lotes = $lotesManzana['total'];
			$data['lotes'] = $lotes;
			$totalPaquete = $totalUnitario * $lotes;
			$manzana = '';

			//-----
			$arranque=$this->marranque->getByIdPaquete($idPaq);
			$data["estatus_arranque"]=(!is_numeric($arranque)) ? $arranque["estatus_arranque"] : 0;
	        if(!is_numeric($qPaquetePmat)){
	            foreach($lotesManzana['arrayMzs'] as $mz => $lotes){
	                $manzana = $manzana . $mz . ', ';
	            }
	        	// echo $qPaquetePmat['idConstructor']; exit();
	            $manzana = substr($manzana, 0, -2);
	            $paquetemat = array('titulo' => $qPaquetePmat['titulo'],
	                'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo',$idFraccionamiento), 
	                'prototipo' => $this->mprototipos->getCampo('nombre', $idPrototipo),
	                //'almacen' => $this->malmacenes->getCampo('nombre', $idPrototipo),
	                'manzana' => $manzana,
	                'statusPaquete' => $qPaquetePmat['statusPaquete'],
	                'fecha_inicio' => $qPaquetePmat['fecha_inicio'],
	                'fecha_fin' => $qPaquetePmat['fecha_fin'],
	                'contratista' => $this->mconstructores->getCampo("CONCAT(nombre,' ',apellidoP,' ',apellidoM)", $qPaquetePmat['idConstructor']),
	                'rango_lotes' => $lotesManzana['lotes'],
	                'total_unitario' => "$".number_format($totalUnitario,2),
	                'total_paquete' => "$".number_format($totalPaquete,2),
	                'costoM2' => "$".number_format($costoM2,2),
	            );
	            $idContratista = $qPaquetePmat['idConstructor'];
	            $lotes = $lotesManzana['total'];
	        }
	        $data['paquetemat'] = $paquetemat;




			$qArranque = $this->db->query("SELECT * FROM arranque WHERE status = 1 AND FIND_IN_SET('$idPaq',idPaquetes)");
			if($qArranque->num_rows() > 0){
				if($qArranque->row()->estatus_arranque == 3){
					if(!$edit){
						redirect($this->router->class);
					}
				}
			}
			$idPaquete = $this->mmaterial->getCampo('idPaquete',$id);
			$idMO = $this->mpaquete->getCampo('idManoObra', $idPaquete);
			$query = $this->db->query('SELECT semana AS id, semana AS titulo FROM presupuesto_mat WHERE idMaterial = '.$id.' GROUP BY semana');
			if ($query->num_rows() > 0) {
				$data['semana'] = $query;
			}else{
				$data['semana'] = 0;
			}
            $qPaquete = $this->mpaquete->getById($idPaquete);
			$data['paq'] = $qPaquetePmat['titulo'];

			require('Arranque.php');

            $arranque = new Arranque();
			$getInfo = $arranque->getInfoVer($qPaquete['id']);
			$sum = 0;
			$sum += ($getInfo != 0) ?  $getInfo['totalEncabezado'] : 0.00 ;

            if($getInfo != 0){
                $data['prototipo'] = $getInfo['prototipo'];
                $data['fraccionamiento'] = $getInfo['fraccionamiento'];
                $data['rangoLotes'] = $getInfo['rangoLotes'];
                $data['presupuestoViv'] = $getInfo['presupuestoViv'];
                $data['presupuestoPaq'] = $getInfo['presupuestoPaq'];
                $data['total_unitario'] = $getInfo['total_unitario'];
                $data['total_paquete'] = $getInfo['total_paquete'];
                $data['costoM2'] = $getInfo['costoM2'];
                $data['m2Viv'] = $getInfo['m2Viv'];
                $data['totalEncabezado'] = $sum;
                $data['pptoTotal'] = $getInfo['pptoTotal'];
                $data['contratista'] = $getInfo['contratista'];
                //ppt unitario materuales
            }else{
                $data['prototipo'] = '';
                $data['fraccionamiento'] = '';
                $data['rangoLotes'] = '';
                $data['presupuestoViv'] = '';
                $data['presupuestoPaq'] = '';
                $data['total_unitario'] = '';
                $data['total_paquete'] = '';
                $data['costoM2'] = '';
                $data['pptoTotal'] = '';
                $data['m2Viv'] = '';
                $data['totalEncabezado'] = '';
                $data['contratista'] = '';
            }
			$data['fraccionamiento'] = $this->mfraccionamiento->getCampo2('titulo', $data['material']['idFraccionamiento']);
			$data['folio'] = $this->mordencompra->getCampo2('folio',$data['material']['idFraccionamiento']);
			$data['prototipo'] = $this->mprototipos->getCampo2('nombre', $data['material']['idPrototipo']);
			$data['paquete'] = $this->mpaquete->getById($data['material']['idPaquete']);
			$data['manoObra'] = $this->mmanoobra->getCampo2('titulo', $data['paquete']['idManoObra']);
			$this->data['contenido'] = $this->load->view($this->mainView . '/detalle_view', $data, true);
			$this->load->view('templates/main_template', $this->data);
	    }

		public function listadoDetallepmat($idMaterial = 0, $filtroSemana="")
		{
			$material = $this->mmaterial->getById($idMaterial);
			$paquete = $this->mpaquete->getById($material['idPaquete']);
			$idManoObra = $paquete['idManoObra'];
			$idPrototipo = $material['idPrototipo'];
			$materialesPresupuesto = $this->mpresupuestomat->getByIdMaterial($idMaterial, $filtroSemana);
			$empty = true;
			$arranque=$this->marranque->getByIdPaquete($material['idPaquete']);
			$estatus_arranque=(!is_numeric($arranque)) ? $arranque["estatus_arranque"] : 0;
			if (!is_numeric($materialesPresupuesto)) {
				$arrayPresupuestoMAT = array();
				foreach ($materialesPresupuesto->result() as $row) {
					$materialActividadPrototipo = $this->mmaterialesactividadprototipo->getById($row->idMateriales);
					if(!is_numeric($materialActividadPrototipo)){
						$material = $this->mmateriales->getById2($materialActividadPrototipo['idMaterial'],$_SESSION[$this->nsession]["idEmpresa"]);
						if(!is_numeric($material)){
							$empty = false;
							//$area = $this->mareamaterial->getCampo2('area', $material['idArea']);
							$proveedor = $this->mproveedor->getCampo2('nombre', $row->idProveedor);
							//$nameUnidad = $this->munidades->getCampo2('unidad', $material['idUnidad']);
							//$abrevUnidad = $this->munidades->getCampo2('abreviatura', $material['idUnidad']);
							//$unidad = $nameUnidad . ' (' . $abrevUnidad .')';
							$unidad = $material['unidad_compra'];
							$clasificacion = $material['linea_art'];
							$categoriamat=$this->mcategoriamat->getByClave($row->clave_cat);
							$categoriamat=(!is_numeric($categoriamat)) ? $categoriamat["categoria"] : "N/A";
							array_push($arrayPresupuestoMAT, array('tipo'=> $row->tipo,'clave' => $row->clave,'categoria' => $categoriamat, 'proveedor' => $proveedor, 'descripcion' => $material['nombre'], 'unidad' => $unidad, 'clasificacion' => $clasificacion, 'cantidad' => $materialActividadPrototipo['cantidad'], 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe, 'idPresupuesto' => $row->id, 'semana' => $row->semana));
						}
					}
				}
			}

			if (!$empty) {
				if (count($arrayPresupuestoMAT) > 0) {
					foreach ($arrayPresupuestoMAT as $row) {
						$ajustes=$this->db->query("SELECT SUM(cantidad) total FROM ajustes WHERE idPaquete=".$paquete['id']." AND idPresupuesto=".$row["idPresupuesto"]." AND tipoPpto=1 AND tipo=".$row['tipo']);
						$signo=($row["tipo"]==3) ? "+" : "-";
						$ajuste="";
						if($row["tipo"]==3 || $row["tipo"]==4){
							$ajuste=($ajustes->row()->total > 0) ? '<span id="ajuste_' . $row['idPresupuesto'] . '" class="input-group-addon">'.$signo.$ajustes->row()->total.'</span>' : 
							'<span id="ajuste_' . $row['idPresupuesto'] . '" style="display:none" class="input-group-addon">'.$signo.$ajustes->row()->total.'</span>';
						}
						$cantidad = '
						<div class="input-group">
							<input id="cantidadPresupuesto_' . $row['idPresupuesto'] . '" type="text" class="form-control" value="' . $row['cantidad'] . '" disabled="disabled" style="width: 80px;">
						</div>';
						$input = '<div class="input-group">
											<input id="' . $row['idPresupuesto'] . '" type="text" class="form-control" value="' . $row['precioUnitario'] . '" disabled="disabled" style="width: 80px;">
											<span class="input-group-addon">
												<a id="editar_' . $row['idPresupuesto'] . '" data-id="' . $row['idPresupuesto'] . '" onclick="habilitarInput($(this));"><i class="fa fa-edit" /></i></a>
											</span>
											<span class="input-group-addon">
												<a id="aceptar_' . $row['idPresupuesto'] . '" data-id="' . $row['idPresupuesto'] . '" onclick="updatePrecio($(this));"><i class="fa fa-check" /></i></a>
											</span>
									</div>';
						$importe = '<span id="importePresupuesto_' . $row['idPresupuesto'] . '">' . precio_format($row['importe']) . '</span>';
						$array['aaData'][] = array(
							'ajustes'=>$ajuste,
							'tipo' => '<span id="tipo_' . $row['idPresupuesto'] . '"">'.getTipoAjuste($row['tipo']).'</span>',
							'clave' => $row['clave'],
							'categoria' => $row['categoria'],
							'clasificacion' => $row['clasificacion'],
							'proveedor' => $row['proveedor'],
							'descripcion' => $row['descripcion'],
							'unidad' => $row['unidad'],
							'cantidad' => $cantidad,
							'precioUnitario' => $input,
							'importe' => $importe,
							'semana' => $row['semana'],
							'acciones' => ($estatus_arranque==1) ? '<a href="javascript:void(0);" id="accionBorrar-'.$row['idPresupuesto'].'" data-id="'.$row['idPresupuesto'].'" onclick="accionBorrar($(this));"><i class="fa fa-trash" aria-hidden="true"></i></a>' : '',
						);
					}
				} else {
					$array['aaData']=[];
				}
			} else {
				$array['aaData']=[];
			}
			echo json_encode($array);
		}
		
		public function resumenpmat($id=0){
			$data["msg"]="";
			$data['material'] = $this->mmaterial->getById($id);
			$idPaq = $data['material']['idPaquete'];
			$qPaquetePmat = $this->mpaquete->getById($idPaq);
			$idPrototipo = $this->mmanoobra->getCampo('idPrototipo', $qPaquetePmat['idManoObra']);
			$superficieM2 = $this->mprototipos->getCampo('superficieM2',$idPrototipo);
			$lotesManzana = contarLotesManzanas($qPaquetePmat['rango_lotes']);
			$idFraccionamiento = $this->mmanoobra->getCampo('idFraccionamiento', $qPaquetePmat['idManoObra']);
	        $totalPresupuestoMO = $this->mpresupuestomo->getSumTotalUnitario($qPaquetePmat["idManoObra"]);
	        $totalUnitario = $totalPresupuestoMO;
			$costoM2 = $totalUnitario / $superficieM2;
	        $lotesManzana = contarLotesManzanas($qPaquetePmat['rango_lotes']);
	        $lotes = $lotesManzana['total'];
			$data['lotes'] = $lotes;
			$totalPaquete = $totalUnitario * $lotes;
			$manzana = '';

			//-----
			$arranque=$this->marranque->getByIdPaquete($idPaq);
			$data["estatus_arranque"]=(!is_numeric($arranque)) ? $arranque["estatus_arranque"] : 0;
	        if(!is_numeric($qPaquetePmat)){
	            foreach($lotesManzana['arrayMzs'] as $mz => $lotes){
	                $manzana = $manzana . $mz . ', ';
	            }
	        	// echo $qPaquetePmat['idConstructor']; exit();
	            $manzana = substr($manzana, 0, -2);
	            $paquetemat = array('titulo' => $qPaquetePmat['titulo'],
	                'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo',$idFraccionamiento), 
	                'prototipo' => $this->mprototipos->getCampo('nombre', $idPrototipo),
	                'almacen' => $this->malmacenes->getCampo('nombre', $idPrototipo),
	                'manzana' => $manzana,
	                'statusPaquete' => $qPaquetePmat['statusPaquete'],
	                'fecha_inicio' => $qPaquetePmat['fecha_inicio'],
	                'fecha_fin' => $qPaquetePmat['fecha_fin'],
	                'contratista' => $this->mconstructores->getCampo("CONCAT(nombre,' ',apellidoP,' ',apellidoM)", $qPaquetePmat['idConstructor']),
	                'rango_lotes' => $lotesManzana['lotes'],
	                'total_unitario' => "$".number_format($totalUnitario,2),
	                'total_paquete' => "$".number_format($totalPaquete,2),
	                'costoM2' => "$".number_format($costoM2,2),
	            );
	            $idContratista = $qPaquetePmat['idConstructor'];
	            $lotes = $lotesManzana['total'];
	        }
	        $data['paquetemat'] = $paquetemat;




			$idPaquete = $this->mmaterial->getCampo('idPaquete',$id);
			$idMO = $this->mpaquete->getCampo('idManoObra', $idPaquete);
			$qPaquete = $this->mpaquete->getById($idPaquete);

			$query = $this->db->query('SELECT semana AS id, semana AS titulo FROM presupuesto_mat WHERE idMaterial = '.$id.' GROUP BY semana');
			if ($query->num_rows() > 0) {
				$data['semana'] = $query;
			}else{
				$data['semana'] = 0;
			}
			$data['fraccionamiento'] = $this->mfraccionamiento->getCampo2('titulo', $data['material']['idFraccionamiento']);
			$data['prototipo'] = $this->mprototipos->getCampo2('nombre', $data['material']['idPrototipo']);
			$data['paquete'] = $this->mpaquete->getById($data['material']['idPaquete']);
			$data['manoObra'] = $this->mmanoobra->getCampo2('titulo', $data['paquete']['idManoObra']);
			$data['paq'] = $qPaquetePmat['titulo'];
			
			require('Arranque.php');

            $arranque = new Arranque();
			$getInfo = $arranque->getInfoVer($qPaquete['id']);
			$sum = 0;
			$sum += ($getInfo != 0) ?  $getInfo['totalEncabezado'] : 0.00 ;

            if($getInfo != 0){
                $data['prototipo'] = $getInfo['prototipo'];
                $data['fraccionamiento'] = $getInfo['fraccionamiento'];
                $data['rangoLotes'] = $getInfo['rangoLotes'];
                $data['presupuestoViv'] = $getInfo['presupuestoViv'];
                $data['presupuestoPaq'] = $getInfo['presupuestoPaq'];
                $data['total_unitario'] = $getInfo['total_unitario'];
                $data['total_paquete'] = $getInfo['total_paquete'];
                $data['costoM2'] = $getInfo['costoM2'];
                $data['m2Viv'] = $getInfo['m2Viv'];
                $data['totalEncabezado'] = $sum;
                $data['pptoTotal'] = $getInfo['pptoTotal'];
                $data['contratista'] = $getInfo['contratista'];
                //ppt unitario materuales
            }else{
                $data['prototipo'] = '';
                $data['fraccionamiento'] = '';
                $data['rangoLotes'] = '';
                $data['presupuestoViv'] = '';
                $data['presupuestoPaq'] = '';
                $data['total_unitario'] = '';
                $data['total_paquete'] = '';
                $data['costoM2'] = '';
                $data['pptoTotal'] = '';
                $data['m2Viv'] = '';
                $data['totalEncabezado'] = '';
                $data['contratista'] = '';
            }
    		$this->data['contenido'] = $this->load->view($this->mainView.'/resumen_view',$data,true);
			$this->load->view('templates/main_template',$this->data);
	    }


	    public function getInfoVer($idPaquete)
	    {
	        $paquete = $this->mpaquete->getById($idPaquete);
	        $qManoObra = $this->mmanoobra->getById($paquete['idManoObra']);
			$superficieM2 = $this->mprototipos->getCampo('superficieM2',$qManoObra['idPrototipo']);
			$prototipo = $this->mprototipos->getById($qManoObra['idPrototipo']);
			
			$totalPresupuestoMO = $this->mpresupuestomo->getSumTotalUnitario($paquete["idManoObra"]);
			$totalUnitario = $totalPresupuestoMO;
			$lotesManzana = contarLotesManzanas($paquete['rango_lotes']);
			$lotes = $lotesManzana['total'];
			$totalPaquete = $totalUnitario * $lotes;

	        $material = $this->mmaterial->getByIdFraccIdProtIdMO($qManoObra['idFraccionamiento'], $qManoObra['idPrototipo'], $idPaquete);
	        
	        $detalle = $this->mdetallepaquete->getByIdPaquete($idPaquete);
	        if (!is_numeric($paquete) && !is_numeric($prototipo) && !is_numeric($material)) {
	            $presupuestoViv = $this->mpresupuestomat->getSumTotalImporte($material['id']);
	            //$lotes = (!is_numeric($detalle)) ? $detalle->num_rows() : 0;
	            $presupuestoPaq = $presupuestoViv * $lotes;
	            $costoM2 = $presupuestoViv / $superficieM2;
	            $response = array('prototipo' => $prototipo['titulo'],
	                'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo', $qManoObra['idFraccionamiento']),
	                'rangoLotes' => (!is_numeric($detalle))? $detalle->num_rows() : 0,
	                'presupuestoViv' => precio_format($presupuestoViv),
					'presupuestoPaq' => precio_format($presupuestoPaq),
					'total_unitario' => "$".number_format($totalUnitario,2),
					'total_paquete' => "$".number_format($totalPaquete,2),
	                'costoM2' => precio_format($costoM2),
	                'm2Viv' => $prototipo['superficieM2']
	            );
	        } else {
	            $response = 0;
	        }
	        return $response;
	    }

		public function listadoResumenpmat($idMaterial = 0, $filtroSemana ="")
		{
			$material = $this->mmaterial->getById($idMaterial);
			$paquete = $this->mpaquete->getById($material['idPaquete']);
			$idManoObra = $paquete['idManoObra'];
			$idPrototipo = $material['idPrototipo'];
			$materialesPresupuesto = $this->mpresupuestomat->getByIdMaterial($idMaterial, $filtroSemana);
			$empty = true;
			if (!is_numeric($materialesPresupuesto)) {
				$arrayPresupuestoMAT = array();
				$countArray = 0;
				foreach ($materialesPresupuesto->result() as $row) {
					$existe = 0;
					$materialActividadPrototipo = $this->mmaterialesactividadprototipo->getById($row->idMateriales);
					if (!is_numeric($materialActividadPrototipo)) {
						$material = $this->mmateriales->getById2($materialActividadPrototipo['idMaterial'],$_SESSION[$this->nsession]["idEmpresa"]);
						if (!is_numeric($material)) {
							$empty = false;
							//$area = $this->mareamaterial->getCampo2('area', $material['idArea']);
							$proveedor = $this->mproveedor->getCampo2('nombre', $row->idProveedor);
							//$nameUnidad = $this->munidades->getCampo2('unidad', $material['idUnidad']);
							//$abrevUnidad = $this->munidades->getCampo2('abreviatura', $material['idUnidad']);
							//$unidad = $nameUnidad . ' (' . $abrevUnidad . ')';
							$unidad = $material['unidad_compra'];
							$clasificacion = $material['linea_art'];
							$categoriamat=$this->mcategoriamat->getByClave($row->clave_cat);
							$categoriamat=(!is_numeric($categoriamat)) ? $categoriamat["categoria"] : "N/A";
							array_push($arrayPresupuestoMAT, array('tipo'=>  $row->tipo,'clave' => $row->clave, 'categoria' => $categoriamat ,'proveedor' => $proveedor, 'descripcion' => $material['nombre'], 'unidad' => $unidad, 'clasificacion' => $clasificacion, 'cantidad' => $materialActividadPrototipo['cantidad'], 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe, 'idPresupuesto' => $row->id, 'semana' => $row->semana));
						}
					}
				}
			}

			if (!$empty) {
				if (count($arrayPresupuestoMAT) > 0) {
					foreach ($arrayPresupuestoMAT as $row) {
						$array['aaData'][] = array(
							'tipo' => getTipoAjuste($row['tipo']),
							'clave' => $row['clave'],
							'categoria' => $row['categoria'],
							'clasificacion' => $row['clasificacion'],
							'proveedor' => $row['proveedor'],
							'descripcion' => $row['descripcion'],
							'unidad' => $row['unidad'],
							'cantidad' => $row['cantidad'],
							'precioUnitario' => precio_format($row['precioUnitario']),
							'importe' => precio_format($row['importe']),
							'semana' => $row['semana']
						);
					}
				} else {
					$array['aaData']=[];
				}
			} else {
				$array['aaData']=[];
			}
			echo json_encode($array);
		}

		public function getPrototiposByFracc($id = '')
		{
			$prototipos = $this->mprototipoxfraccionamiento->getByIdFraccionamiento($id);
			$array = array();
			$response = array();
			if (!is_numeric($prototipos)) {
				foreach ($prototipos->result() as $key => $value) {
					$array = array(
						'id' => $value->idPrototipo,
						'titulo' => $this->mprototipos->getCampo('nombre', $value->idPrototipo)
					);
					array_push($response, $array);
				}
			} else {
				$response = 0;
			}
			echo json_encode($response);
		}

		public function getPaquetesByFraccProto($idFraccionamiento = '', $idPrototipo = '')
		{
			$paquetes = $this->mpaquete->getByIdFraccionamientoPrototipo($idFraccionamiento, $idPrototipo, true, 'material');
			$array = array();
			$response = array();
			if (!is_numeric($paquetes)) {
				foreach ($paquetes->result() as $key => $value) {
					$array = array(
						'id' => $value->id,
						'titulo' => $this->mpaquete->getCampo('titulo', $value->id)
					);
					array_push($response, $array);
				}
			} else {
				$response = 0;
			}
			echo json_encode($response);
		}

		public function updatePrecio(){
			$idPresupuesto = $this->input->post('idPresupuesto');
			$presupuesto = $this->mpresupuestomat->getById($idPresupuesto);
			$idMaterial = $this->input->post('idMaterial');
			$cantidad = $this->input->post('cantidad');
			$precioUnitario = $this->input->post('precioUnitario');
			$material=$this->mmaterial->getById($idMaterial);
			$idPaquete=$material["idPaquete"];
			$arranque=$this->marranque->getByIdPaquete($idPaquete);
			$estatus_arranque=(!is_numeric($arranque)) ? $arranque["estatus_arranque"] : 0;
			
			//ajustes
			if($estatus_arranque==2 && $presupuesto["tipo"]!=2){
				$mact=$this->mmaterialesactividadprototipo->getById($presupuesto['idMateriales']);
				$ajustes=$this->db->query("SELECT SUM(cantidad) total FROM ajustes WHERE idPaquete=$idPaquete AND idPresupuesto=$idPresupuesto AND
				tipoPpto=1 AND tipo=".$presupuesto["tipo"]);
				$totalAjustes=$ajustes->row()->total;
				$signo='';
				$tipo=0;

				if($presupuesto["tipo"]==3){
					$cantidadOriginal=$mact["cantidad"] - $totalAjustes;
				}else if($presupuesto["tipo"]==4){
					$cantidadOriginal=$mact["cantidad"] + $totalAjustes;
				}else{
					$cantidadOriginal=$mact["cantidad"];
				}
				
				$ajuste["idPaquete"] = $idPaquete;
				$ajuste["idPresupuesto"] = $idPresupuesto;
				$ajuste["tipoPpto"] = 1;
				if($cantidadOriginal==$cantidad){
					$tipo=1;
					$this->db->query("DELETE FROM ajustes WHERE idPaquete=$idPaquete AND idPresupuesto=$idPresupuesto AND tipoPpto=1 AND (tipo=3 OR tipo=4)");
				}else if(($cantidad - $cantidadOriginal) > 0){
					$signo="+";
					$ajuste["cantidad"] = ($presupuesto["tipo"]==4) ? abs($cantidad - $cantidadOriginal) : abs($cantidad - $mact["cantidad"]);
					$ajuste["tipo"] = $tipo = 3;
					$this->db->query("DELETE FROM ajustes WHERE idPaquete=$idPaquete AND idPresupuesto=$idPresupuesto AND tipoPpto=1 AND tipo=4");
					$this->majustes->insertar($ajuste);	
				}else if(($cantidad - $cantidadOriginal) < 0){
					$signo="-";
					$ajuste["cantidad"] = ($presupuesto["tipo"]==3) ? abs($cantidad - $cantidadOriginal) : abs($cantidad - $mact["cantidad"]);
					$ajuste["tipo"] = $tipo = 4;
					$this->db->query("DELETE FROM ajustes WHERE idPaquete=$idPaquete AND idPresupuesto=$idPresupuesto AND tipoPpto=1 AND tipo=3");
					$this->majustes->insertar($ajuste);	
				}
			}
			//actualizaciones
			$uData['cantidad'] = $cantidad;
			$this->mmaterialesactividadprototipo->actualizar($uData, $presupuesto['idMateriales']);
			$pData['precioUnitario'] = round($precioUnitario, 2);
			$pData['importe'] = round($cantidad * $pData['precioUnitario'], 2);
			$pData['tipo'] = $tipo;
			$this->mpresupuestomat->actualizar($pData, $idPresupuesto);
			//respuesta
			$ajustes=$this->db->query("SELECT SUM(cantidad) total FROM ajustes WHERE idPaquete=$idPaquete AND idPresupuesto=$idPresupuesto AND tipoPpto=1 AND tipo=".$tipo);
			$totalAjustes=$ajustes->row()->total;
			$array = array('importe' => precio_format($pData['importe']),'tipo'=>getTipoAjuste($tipo),'ajuste'=>$signo.$totalAjustes);
			echo json_encode($array);
		}

		public function exportarEjemplo(){
			$objPHPExcel = new PhpOffice\PhpSpreadsheet\Spreadsheet();
			$objPHPExcel->getActiveSheet()->setTitle('Presupuesto de Materiales');
			$objPHPExcel->setActiveSheetIndex(0);
			$objPHPExcel->getActiveSheet()->SetCellValue('A1', 'CLAVE');
			$objPHPExcel->getActiveSheet()->SetCellValue('B1', 'CLAVE_CAT');
			$objPHPExcel->getActiveSheet()->SetCellValue('C1', 'DESCRIPCION_CAT');
			$objPHPExcel->getActiveSheet()->SetCellValue('D1', 'PROVEEDOR');
			$objPHPExcel->getActiveSheet()->SetCellValue('E1', 'SEMANA');
			$objPHPExcel->getActiveSheet()->SetCellValue('F1', 'DESCRIPCION');
			$objPHPExcel->getActiveSheet()->SetCellValue('G1', 'CANTIDAD');
			$objPHPExcel->getActiveSheet()->SetCellValue('H1', 'PRECIO UNITARIO');
			
			$name = 'Ejemplo de Importación de Presupuesto de Materiales';
			header('Content-Type: application/vnd.ms-excel');
			header('Content-Disposition: attachment;filename="' . $name . '_' . date('Ymd') . '.xls"');
			header('Cache-Control: max-age=0'); //no cache
			$objWriter = PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xls');
			// Forzamos a la descarga
			$objWriter->save('php://output');
		}

		public function exportarPpto($idMaterial){
			$material = $this->mmaterial->getById($idMaterial);
			$exportar = false;
			if(!is_numeric($material)){
				$objPHPExcel = new PhpOffice\PhpSpreadsheet\Spreadsheet();
				$objPHPExcel->getActiveSheet()->setTitle('Presupuesto de Materiales');
				$objPHPExcel->setActiveSheetIndex(0);
				$objPHPExcel->getActiveSheet()->SetCellValue('A1', 'CLAVE');
				$objPHPExcel->getActiveSheet()->SetCellValue('B1', 'CLAVE_CAT');
				$objPHPExcel->getActiveSheet()->SetCellValue('C1', 'CATEGORIA');
				$objPHPExcel->getActiveSheet()->SetCellValue('D1', 'DESCRIPCION');
				$objPHPExcel->getActiveSheet()->SetCellValue('E1', 'PROVEEDOR');
				$objPHPExcel->getActiveSheet()->SetCellValue('F1', 'SEMANA');
				$objPHPExcel->getActiveSheet()->SetCellValue('G1', 'PRECIO UNITARIO');
				$objPHPExcel->getActiveSheet()->SetCellValue('H1', 'CANTIDAD');
				$objPHPExcel->getActiveSheet()->SetCellValue('I1', 'TOTAL');
				$presupuesto = $this->mpresupuestomat->getByIdMaterial($material['id'], 0);
				if(!is_numeric($presupuesto)){
					$exportar = true;
					$rowCount = 2;
					$sumaTotal=0;
					foreach($presupuesto->result() as $row){
						$materialActividadPrototipo = $this->mmaterialesactividadprototipo->getById($row->idMateriales);
						if(!is_numeric($materialActividadPrototipo)){
							$materiales = $this->mmateriales->getById2($materialActividadPrototipo['idMaterial'],$_SESSION[$this->nsession]["idEmpresa"]);
							if(!is_numeric($materiales)){
								$proveedor = $this->mproveedor->getCampo2('nombre', $row->idProveedor);
								$categoriamat=$this->mcategoriamat->getByClave($row->clave_cat);
								$categoriamat=(!is_numeric($categoriamat)) ? $categoriamat["categoria"] : "N/A";
								$objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $row->clave);
								$objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $row->clave_cat);
								$objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, $categoriamat);
								$objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, $materiales['nombre']);
								$objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, $proveedor);
								$objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, $row->semana);
								$objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount, $row->precioUnitario);
								$objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, $materialActividadPrototipo['cantidad']);
								$total=ROUND($row->precioUnitario * $materialActividadPrototipo['cantidad'],2);
								$sumaTotal+=$total;
								$objPHPExcel->getActiveSheet()->SetCellValue('I'.$rowCount, $total);
							}
						}
						$rowCount++;
					}
					$objPHPExcel->getActiveSheet()->SetCellValue('I'.$rowCount, $sumaTotal);
				}

			}
			
			if($exportar){
				$name = 'Presupuesto de Materiales';
				header('Content-Type: application/vnd.ms-excel');
				header('Content-Disposition: attachment;filename="' . $name . '_' . date('Ymd') . '.xls"');
				header('Cache-Control: max-age=0'); //no cache
				$objWriter = PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xls');
				// Forzamos a la descarga
				$objWriter->save('php://output');
			}
		}

		public function getPaqueteByFraccProto($idFraccionamiento = '', $idPrototipo = '')
		{
			$manoobra = $this->mpaquete->getByIdFraccionamientoPrototipo3($idFraccionamiento, $idPrototipo);
			$array = array();
			$response = array();
			if (!is_numeric($manoobra)) {
				foreach ($manoobra->result() as $key => $value) {
					$array = array(
						'id' => $value->id,
						'titulo' => $value->titulo
					);
					array_push($response, $array);
				}
			} else {
				$response = 0;
			}
			echo json_encode($response);
		}

		public function borrarMatPresupuesto()
		{
			$response['status'] = 0;
			$idPresupuesto = $this->input->post('idPresupuesto');
			$presupuesto = $this->mpresupuestomat->getById($idPresupuesto);
			$idMaterial = $this->input->post('idMaterial');
			$material = $this->mmaterial->getById($idMaterial);
			$existInOrdenCompra = $this->mpresupuestomat->getByIdMaterialSemanaIn($idMaterial, $presupuesto['semana']);
			if(is_numeric($existInOrdenCompra)){
				$this->mmaterialesactividadprototipo->borrar($presupuesto['idMateriales']);
				$this->mpresupuestomat->borrar($idPresupuesto);
				$response['status'] = 1;
			}

			$response['cabecera'] = $this->getInfoVer($material['idPaquete']);
			echo json_encode($response);
		}

		public function addMatPresupuesto()
		{
			$response['status'] = 0;
			$response['count'] = 0;
			$response['rows'] = array();
			$idMaterial = $this->input->post('idMaterial');
			$material = $this->mmaterial->getById($idMaterial);
			$arrayMateriales = $this->input->post('arrayMateriales');
			$count = count($arrayMateriales);
			$i=0;
			$list = '';
			$idPaquete=$material["idPaquete"];
			$arranque=$this->marranque->getByIdPaquete($idPaquete);
			$estatus_arranque=(!is_numeric($arranque)) ? $arranque["estatus_arranque"] : 0;

			foreach ($arrayMateriales as $key => $value) {
					$qProveedor = $this->mproveedor->getByNombre($value['proveedor'],$material["idEmpresa"]);
					if(!is_numeric($qProveedor) && $qProveedor['id'] != ''){
						$exist=$this->mmateriales->getByClave($value['clave'],$material['idEmpresa']);
						$qExistPptoSem = $this->db->query("SELECT p.* FROM presupuesto_mat p 
						LEFT JOIN materialesactividadprototipo m ON m.id = p.idMateriales 
						WHERE p.idMaterial=$idMaterial AND m.idMaterial = $exist->id AND p.clave='".$value["clave"]."' AND p.idProveedor = ".$qProveedor['id']."");

						if($qExistPptoSem->num_rows() == 0){
							$mapData['idActividadPrototipo']=0;
							$mapData['idMaterial']=$exist->id;
							$mapData['cantidad']=$value['cantidad'];
							$mapData['tipo']=2;
							$idMap = $this->mmaterialesactividadprototipo->insertar($mapData);

							$pData['idMaterial'] = $idMaterial;
							$pData['idMateriales'] = $idMap;
							$idProveedor = (!is_numeric($qProveedor)) ? $qProveedor['id'] : 0;
							$pData['idProveedor'] = $idProveedor;
							$pData['precioUnitario'] = ($value['precioUnitario'] != '') ? $value['precioUnitario'] : 0;
							$pData['precioUnitario'] = round($pData['precioUnitario'], 2);
							$pData['cantidad']=$value['cantidad'];
							$pData['clave']=$value['clave'];
							$pData['importe'] = round($value['cantidad'] * $pData['precioUnitario'], 2);
							$pData['semana'] = ($value['semana'] != '') ? $value['semana'] : 0;
							$pData['tipo'] = ($estatus_arranque=2) ? 2 : 1;
							$pData['status'] = 1;
							$idPresupuestoMaterial = $this->mpresupuestomat->insertar($pData);

							if($estatus_arranque == 2){
								$ajuste["idPaquete"] = $idPaquete;
								$ajuste["idPresupuesto"] = $idPresupuestoMaterial;
								$ajuste["cantidad"] = $pData['cantidad'];
								$ajuste["precioUnitario"] = $pData['precioUnitario'];
								$ajuste["tipo"] = $pData['tipo'];
								$ajuste["tipoPpto"] = 1;
								$this->majustes->insertar($ajuste);
							}

							$response['count'] = $response['count'] + 1;

							$cantidad = '<input id="cantidadPresupuesto_' . $idPresupuestoMaterial . '" type="text" class="form-control" value="' . $value['cantidad'] . '" disabled="disabled" style="width: 80px;">';
							$input = '<div class="input-group">
												<input id="' . $idPresupuestoMaterial . '" type="text" class="form-control" value="' . $value['precioUnitario'] . '" disabled="disabled" style="width: 80px;">
												<span class="input-group-addon">
													<a id="editar_' . $idPresupuestoMaterial . '" data-id="' . $idPresupuestoMaterial . '" onclick="habilitarInput($(this));"><i class="fa fa-edit" /></i></a>
												</span>
												<span class="input-group-addon">
													<a id="aceptar_' . $idPresupuestoMaterial . '" data-id="' . $idPresupuestoMaterial . '" onclick="updatePrecio($(this));"><i class="fa fa-check" /></i></a>
												</span>
										</div>';
							$importe = '<span id="importePresupuesto_' . $idPresupuestoMaterial . '">' . precio_format($pData['importe']) . '</span>';

							$borrar = '<a href="javascript:void(0);" id="accionBorrar-'.$idPresupuestoMaterial.'" data-id="'.$idPresupuestoMaterial.'" onclick="accionBorrar($(this));"><i class="fa fa-trash" aria-hidden="true"></i></a>';

							$response['rows'][$key] = "<tr>
														<td>".$this->mmateriales->getCampo('linea_art',$exist->id)."</td>
														<td>".$exist->clave."</td>
														<td>".$qProveedor['nombre']."</td>
														<td>".$pData['semana']."</td>
														<td>".$this->mmateriales->getCampo('nombre',$exist->id)."</td>
														<td>".$this->mmateriales->getCampo('unidad_compra',$exist->id)."</td>
														<td>".$cantidad."</td>
														<td>".$input."</td>
														<td>".$importe."</td>
														<td>".$borrar."</td>
													</tr>";
						}else{
							if($i == $count - 1){
								$list .= $value['clave'].'';
							}else{
								$list .= $value['clave'].', ';
							}
						}
					}else{
						if($i == $count - 1){
							$list .= $value['clave'].'';
						}else{
							$list .= $value['clave'].', ';
						}
					}
				$i++;
			}

			if($response['count'] == $count){
				$response['status'] = 1;
			}

			$response['cabecera'] = $this->getInfoVer($material['idPaquete']);
			$response['list'] = $list;

			echo json_encode($response);
		}
	}
?>