<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class orden_compra extends MX_Controller {
    public $data,$vParameters,$mainView,$fv;
    public function __construct(){
    $this->nsession = $this->config->item('nsession');
    if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'orden_compra'; // form validation variable
            $this->mainView = 'orden_compra';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/orden_compra/listado.js?v=0.1" type="text/javascript"></script>
                                  <script src="assets/js/orden_compra/listadoDetalle.js?v=0.5 type="text/javascript"></script>
                                  <script src="assets/js/orden_compra/listadoEditar.js" type="text/javascript"></script>
                                  <script src="assets/js/orden_compra/listadoVer.js" type="text/javascript"></script>';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mfraccionamiento', 'mprototipoxfraccionamiento', 'mprototipos', 'mpaquete', 'mactividadesprototipo', 
            'mmaterialesactividadprototipo', 'mmaterial', 'mpresupuestomat', 'mordencompra', 'mordencompraviv', 'mdetalleorden', 'mdetalleordenviv', 
            'mmateriales', 'munidades', 'mproveedor', 'mareamaterial', 'musuario', 'mmanoobra', 'mdetallepaquete', 'malmacenes', 'mempresas', 'marranque',
            'mlogsws'));
            $this->load->library("curl");
            valSession("materiales",$this->fv);
            ini_set('max_execution_time', 0);
    }

    public function index(){
        $data['q'] = '';
        $idEmpresa = $_SESSION["viv"]['idEmpresa'];
        $logsWs = $this->mlogsws->getByIdEmpresaTabla($idEmpresa, 'orden_compra');
        $msgLogs = '';
        $showNotification = 0;
        if(!is_numeric($logsWs)){
            if($logsWs['status'] == 0){
                $user = $this->musuario->getById($logsWs['created_by']);
                if(!is_numeric($user)){
                    $msgLogs = 'Sincronización Realizada Por: '.$user['nombre'].' '.$user['apellidoP'].'<br><br><br>';
                }
                $msgLogs .= 'Registros Insertados: '.$logsWs['insertados'].'<br><br>';
                $msgLogs .= 'Registros Actualizados: '.$logsWs['actualizados'].'<br><br>';
                $msgLogs .= 'Total Registros: '.$logsWs['totalRegistros'].'<br><br>';
                $showNotification = 1;
                $pData['status'] = 1;
                $this->mlogsws->actualizar($pData, $logsWs['id']);
            }
        }
        $data['msgLogs'] = $msgLogs;
        $data['showNotification'] = $showNotification;
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
    }

    public function excel(){
       $q = $this->mordencompra->getAllExcelRows();
       $columnas = array(
                    0 => 'PAQUETE',
                    1 => 'FOLIO',
                    2 => 'FECHA',
                    3 => 'FECHA ENTREGA',
                    4 => 'PROVEEDOR',
                    5 => 'IMPORTE NETO',
                    6 => 'SEMANA'
        );
       crearExcel($q,'orden compra',$columnas);
    }

    public function listado(){
        $list = $this->mordencompra->get_datatables();
        /*echo '<pre>';  print_r($list); exit();*/
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $ordenC) {
            $paquete = ($ordenC->idPaquete > 0) ? $this->mpaquete->getCampo('titulo',$ordenC->idPaquete) : 'N/A';
            $provedor = ($ordenC->id_proveedor > 0) ? $this->mproveedor->getCampo('nombre',$ordenC->id_proveedor) : 'N/A';
            $importeN = '$'.number_format($ordenC->importe_neto,2);
            $acciones = acciones($ordenC->id, $this->router->class, true,false, false);
            $no++;
            $row = array();
            $row[] = $acciones;
            $row[] = $paquete;
            $row[] = $ordenC->folio;
            $row[] = $ordenC->fecha;
            $row[] = $ordenC->fecha_entrega;
            $row[] = $provedor;
            $row[] = $importeN;
            $row[] = $ordenC->semana;
            $data[] = $row;
        }

        $output = array(
                   
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->mordencompra->count_all(),
                        "recordsFiltered" => $this->mordencompra->count_filtered(),
                        "data" => $data,

                );
        //output to json format
        echo json_encode($output);
    }

    public function nuevo(){
        require('Cronjob.php');
        $cronjob = new Cronjob();
        $idEmpresa = $_SESSION["viv"]['idEmpresa'];
        $data['msg'] = '';
        $data['msgRegistro'] = '';
        $data['modal'] = '';
        $data['semanaOc'] = '';
        $data['fecha'] = date('d-m-Y');
        $qArranque = $this->marranque->getAllByEstatusArranque(2);
        $ids = array();
        if( !is_numeric($qArranque) ){
            foreach($qArranque->result() as $arranque){
                $temp = explode(',', $arranque->idPaquetes);
                if( !empty($temp[0]) ){
                    foreach($temp as $v){
                        if( !in_array($v, $ids, true) && is_numeric($v)){
                            $ids[] = $v;
                        }
                    }
                }
            }
        }
        $data['paquetes'] = ( empty($ids) )? 0 : $this->mpaquete->getSelectResultInIds($ids);
        $data['almacenes'] = $this->malmacenes->getSelectResult($idEmpresa);
        $data['semana'] = -1;
        $data['usuario'] = $_SESSION[$this->nsession]['usuario'];
        $data['idEmpresa']= $_SESSION[$this->nsession]['idEmpresa'];

        $this->load->library('form_validation');
        if (isset($_POST['idAlmacen'])) { 
            if ($this->form_validation->run($this->fv) == FALSE) {
                $data['msg'] = validation_errors();
            } else {
                $arrayCantidad = json_decode($this->input->post('arrayCantidad', TRUE), true);
                $arrayClaves = json_decode($this->input->post('arrayClaves', TRUE), true);
                $idPaquete=0;
                $idAlmacen = $this->input->post('idAlmacen', TRUE);
                $semana = $this->input->post('semana', TRUE);
                $data['semanaOc'] = $semana;
                $fecha = new DateTime($this->input->post('fecha', TRUE));
                $fecha = $fecha->format("Y-m-d");
                $idProveedor = 0;
                $empty = true;
                $countValid = 0;
                $almacen=$this->malmacenes->getByIdEmpresa($idAlmacen,$idEmpresa);
                if (!is_numeric($almacen)) {
                    $idPaquete=$almacen->idPaquete;
                    $tipoAlmacen=$almacen->tipoAlmacen;
                    $materialesPresupuesto = $this->mpresupuestomat->getByIdMaterialSemanaIn2($idPaquete,$semana,$tipoAlmacen);
                    if (!is_numeric($materialesPresupuesto)) {
                        //echo "<pre>";
                        //print_r($materialesPresupuesto->result());
                        //exit();
                        $arrayCategoriasMat = array();
                        $countArray = 0;
                        foreach ($materialesPresupuesto->result() as $row) {
                            $cantidad = 0;
                            $existe = 0;
                            $arrayPresupuestoMATCat = array();
                            $material = $this->mmateriales->getById2($row->idMaterial, $_SESSION["viv"]['idEmpresa']);
                            if (!is_numeric($material)) {
                                if(isset($arrayCantidad[$row->id])){
                                    if($arrayCantidad[$row->id] > 0){
                                        $empty = false;
                                        $idProveedor = $row->idProveedor;
                                        $cantidad = $arrayCantidad[$row->id];
                                        $clave = $arrayClaves[$row->id];
                                        $proveedor = $this->mproveedor->getCampo2('nombre', $row->idProveedor);
                                        $unidad = $material['unidad_compra'];

                                        if ( !array_key_exists($row->idCategoria."-".$row->idProveedor, $arrayCategoriasMat) ) {
                                            $importe = $cantidad * $row->precioUnitario;
                                            $arrayPresupuestoMATCat[] = array('idMateriales' => $material['id'], 'clave' => $material['clave'], 'proveedor' => $proveedor, 'descripcion' => $material['nombre'], 
                                            'unidad' => $unidad, 'cantidad' => $cantidad,'clave' => $clave, 'precioUnitario' => $row->precioUnitario, 'importe' => $importe, 'idMaterial' => $row->idMaterial, 'idPresupuesto' => $row->id, 
                                            'semana' => $row->semana, 'linea_art' => $material['linea_art']);
                                            $arrayCategoriasMat[$row->idCategoria."-".$row->idProveedor] = array('idProveedor' => $row->idProveedor, 'proveedor' => $proveedor, 'total' => $importe, 'materiales' => $arrayPresupuestoMATCat);
                                        } else {
                                            $importe = $cantidad * $row->precioUnitario;
                                            $total = $arrayCategoriasMat[$row->idCategoria."-".$row->idProveedor]['total'];
                                            $total = $total + $importe;
                                            $array = $arrayCategoriasMat[$row->idCategoria."-".$row->idProveedor]['materiales'];
                                            $arrayPresupuestoMATCat = array('idMateriales' => $material['id'], 'clave' => $material['clave'], 'proveedor' => $proveedor, 'descripcion' => $material['nombre'], 
                                            'unidad' => $unidad, 'cantidad' => $cantidad, 'clave' => $clave, 'precioUnitario' => $row->precioUnitario, 'importe' => $importe, 'idMaterial' => $row->idMaterial, 'idPresupuesto' => $row->id, 
                                            'semana' => $row->semana, 'linea_art' => $material['linea_art']);
                                            array_push($array, $arrayPresupuestoMATCat);
                                            $arrayCategoriasMat[$row->idCategoria."-".$row->idProveedor] = array('idProveedor' => $row->idProveedor, 'proveedor' => $proveedor, 'total' => $total, 'materiales' => $array);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                //echo "<pre>";
                //print_r($arrayCategoriasMat);
                //exit();
                if ( !$empty ) {
                    // if(count($arrayProveedores) > 0){
                    if ( count($arrayCategoriasMat) > 0 ) {
                        $arrayReport = array();
                        $totalOc = 0;
                        $totalRenglones = 0;
                        $totalInsumos = 0;
                        $importeTotal = 0.00;
                        $data['msgRegistro'] = '';
                        // foreach($arrayProveedores as $k => $v){
                        foreach ($arrayCategoriasMat as $key => $value) {
                            $folio = '';
                            $totalTemp = 0;
                            $nextId = '';
                            $arrayDetalle = array();
                            $mData=array();
                            $mData['un'] = $_SESSION["viv"]['idEmpresa'];
                            $mData['folio'] = '';
                            $mData['fecha'] = $fecha;
                            $mData['fecha_entrega'] = $fecha;
                            $mData['semana'] = $semana;
                            // $mData['id_proveedor'] = $k;
                            $mData['id_proveedor'] = $value["idProveedor"];
                            $mData['id_almacen'] = $idAlmacen;
                            $mData['descuento'] = 0.00;
                            $mData['descripcion'] = 'ORDEN SEMANA '.$semana;
                            $mData['fletes'] = 0.00;
                            $mData['otros_cargos'] = 0.00;
                            $mData['gastos_aduanales'] = 0.00;

                            // foreach($arrayProveedores[$k]['materiales'] as $row){
                            foreach ($value['materiales'] as $row) {
                                if ( $row['cantidad'] > 0 ) {
                                    // $precioUnitario = $this->GetPrecioUnitarioCM(array('un' => $_SESSION["viv"]['idEmpresa'], 'id_proveedor' => $k, 'id_articulo' => $row['idMateriales']));
                                    //$precioUnitario = $this->GetPrecioUnitarioCM(array('un' => $_SESSION["viv"]['idEmpresa'], 'id_proveedor' => $value["idProveedor"], 'id_articulo' => $row['idMateriales']));
                                    $precioUnitario = $this->GetPrecioUnitarioCM(array('un' => $_SESSION["viv"]['idEmpresa'], 'id_proveedor' => $key, 'id_articulo' => $row['idMateriales']));
                                    $precioUnitario=($precioUnitario > 0) ? $precioUnitario : ($row["precioUnitario"] / 1.16);
                                    $pData['id_articulo'] = $row['idMateriales'];
                                    $pData['unidades'] = $row['cantidad'];
                                    $pData['clave_articulo'] = $row['clave'];
                                    $pData['precio_unitario'] = round($precioUnitario,2);
                                    $pData['porcentaje_descuento'] = 0.00;
                                    $pData['descripcion'] = $row['descripcion'];
                                    array_push($arrayDetalle, $pData);
                                    $totalTemp = $totalTemp + ($precioUnitario * $row['cantidad']);
                                }
                            }
                            
                            $mData['importe_neto'] = $totalTemp;
                            $mData['registros'] = $arrayDetalle;

                            //echo "<pre>";
                            //echo json_encode($mData);
                            //exit();
                            if (count($mData) > 0) {
                                $response =  $this->AddCompraMsipAsync($mData);
                                // echo "<pre>";
                                // print_r($response);
                                // echo "</pre>";
                                // exit();
                                if ( $response['error'] == false ) {
                                    if ( $response['responseObject'] ) {
                                        $totalOc = $totalOc + 1;

                                        $mData2['id'] = $response['resultado']['id_orden_compra'];
                                        $mData2['idEmpresa'] = $_SESSION["viv"]['idEmpresa'];
                                        //$mData2['idMaterial'] = $idMaterial['id'];
                                        $mData2['idPaquete'] = $idPaquete;
                                        $mData2['semana'] = $semana;
                                        $mData2['folio'] = $response['resultado']['folio_orden_compra'];
                                        $folio = $mData2['folio'];
                                        $folio = " - ".$folio;
                                        $mData2['fecha'] = $fecha;
                                        // $mData2['id_proveedor'] = $k;
                                        $mData2['id_proveedor'] = $value["idProveedor"];
                                        $mData2['id_almacen'] = $idAlmacen;
                                        $mData2['importe_neto'] = $totalTemp;
                                        $mData2['descripcion'] = 'ORDEN SEMANA '.$semana;
                                        // $mData2['numero_articulos'] = count($arrayProveedores[$k]['materiales']);
                                        $mData2['numero_articulos'] = count($value['materiales']);
                                        $mData2['fecha_entrega'] = $fecha;
                                        $mData2['estatus'] = 'PENDIENTE';
                                        //$idOrdenCompra = $this->mordencompra->insertar($mData2);

                                        //$mData3['idMaterial'] = $idMaterial['id'];
                                        $mData3['idPaquete'] = $idPaquete;
                                        $mData3['semana'] = $semana;
                                        $mData3['folio'] = $response['resultado']['id_orden_compra'];
                                        $mData3['fecha'] = $fecha;
                                        // $mData3['id_proveedor'] = $k;
                                        $mData3['id_proveedor'] = $value["idProveedor"];
                                        $mData3['id_almacen'] = $idAlmacen;
                                        $mData3['importe_neto'] = $totalTemp;
                                        $mData3['descripcion'] = 'ORDEN SEMANA '.$semana;
                                        // $mData3['numero_articulos'] = count($arrayProveedores[$k]['materiales']);
                                        $mData3['numero_articulos'] = count($value['materiales']);
                                        $mData3['fecha_entrega'] = $fecha;
                                        $mData3['estatus'] = 'PENDIENTE';
                                        $mData3['status_ws'] = 1;
                                        $idOrdenCompra2 = $this->mordencompraviv->insertar($mData3);

                                        $countDetalle = 1;
                                        foreach($value['materiales'] as $row){
                                            $importeTemp = 0;
                                            $pData3['idPresupuestoMat'] = $row['idPresupuesto'];
                                            $pData3['semana'] = $row['semana'];
                                            $pData3['id_orden_compra'] = $idOrdenCompra2;
                                            $pData3['semana'] = $row['semana'];
                                            $pData3['clave_articulo'] = $row['clave'];
                                            $pData3['id_articulo'] = $row['idMateriales'];
                                            $pData3['unidades'] = $row['cantidad'];
                                            $pData3['precio_unitario'] = $precioUnitario;
                                            $idDetalleOrden2 = $this->mdetalleordenviv->insertar($pData3);

                                            $importeTemp = $row['cantidad'] * $precioUnitario;
                                            $totalInsumos = $totalInsumos + $row['cantidad'];
                                            $importeTotal = $importeTotal + $importeTemp;

                                            if(!array_key_exists($value["idProveedor"], $arrayReport)){
                                                $arrayReport[$value["idProveedor"]] = array('proveedor' => $row['proveedor']);
                                                if(!array_key_exists($row['linea_art'], $arrayReport[$value["idProveedor"]])){
                                                    $arrayReport[$value["idProveedor"]][$row['linea_art']] = array('linea_art' => $row['linea_art'], 'tipo' => 1, 'cantidad' => $row['cantidad'], 'importe' => $row['importe']);
                                                    $totalRenglones = $totalRenglones + 1;
                                                }else{
                                                    $tipo = $arrayReport[$value["idProveedor"]][$row['linea_art']]['tipo'];
                                                    $tipo = $tipo + 1;
                                                    $totalRenglones = $totalRenglones + 1;
                                                    $arrayReport[$value["idProveedor"]][$row['linea_art']]['tipo'] = $tipo;
                                                    $cantidad = $arrayReport[$value["idProveedor"]][$row['linea_art']]['cantidad'];
                                                    $cantidad = $cantidad + $row['cantidad'];
                                                    $arrayReport[$value["idProveedor"]][$row['linea_art']]['cantidad'] = $cantidad;
                                                    $importe = $arrayReport[$value["idProveedor"]][$row['linea_art']]['importe'];
                                                    $importe = $importe + $row['importe'];
                                                    $arrayReport[$value["idProveedor"]][$row['linea_art']]['importe'] = $importe;
                                                }
                                            }else{
                                                if(!array_key_exists($row['linea_art'], $arrayReport[$value["idProveedor"]])){
                                                    $arrayReport[$value["idProveedor"]][$row['linea_art']] = array('linea_art' => $row['linea_art'], 'tipo' => 1, 'cantidad' => $row['cantidad'], 'importe' => $importeTemp);
                                                    $totalRenglones = $totalRenglones + 1;
                                                }else{
                                                    $tipo = $arrayReport[$value["idProveedor"]][$row['linea_art']]['tipo'];
                                                    $tipo = $tipo + 1;
                                                    $totalRenglones = $totalRenglones + 1;
                                                    $arrayReport[$value["idProveedor"]][$row['linea_art']]['tipo'] = $tipo;
                                                    $cantidad = $arrayReport[$value["idProveedor"]][$row['linea_art']]['cantidad'];
                                                    $cantidad = $cantidad + $row['cantidad'];
                                                    $arrayReport[$value["idProveedor"]][$row['linea_art']]['cantidad'] = $cantidad;
                                                    $importe = $arrayReport[$value["idProveedor"]][$row['linea_art']]['importe'];
                                                    $importe = $importe + $importeTemp;
                                                    $arrayReport[$value["idProveedor"]][$row['linea_art']]['importe'] = $importe;
                                                }
                                            }

                                            $countDetalle++;
                                        }
                                        $countR = 1;
                                        $getOrdenCompraWs = $cronjob->GetOrdenCompra($idEmpresa, $mData2['id'], $idPaquete,false);
                                        $data['msgRegistro'] .= "<p> ".$value['proveedor'].$folio." : ".$response['error_message']." </p>";
                                    }else{
                                        $data['msgRegistro'] .= "<p> ".$value['proveedor']." : ".$response['error_message']." </p>";
                                    }
                                }else{
                                    $data['msgRegistro'] .= "<p> ".$value['proveedor']." : Error en la conexión del WS </p>";
                                }
                            }
                        }

                        $modal = '<div>
                                        <p>Total de OC: '.$totalOc.'</p>
                                        <p>Total de Renglones: '.$totalRenglones.'</p>
                                        <p>Total de Insumos: '.$totalInsumos.'</p>
                                        <p>Importe Total: '. precio_format($importeTotal) .'</p>
                                        <div>
                                            <table class="table table-striped table-bordered table-hover">
                                                <thead>
                                                    <tr>
                                                        <th>Proveedor</th>
                                                        <th>Tipo</th>
                                                        <th>Área</th>
                                                        <th>Cant.</th>
                                                        <th>Importe</th>
                                                    </tr>
                                                </thead>
                                                <tbody>';

                                                foreach($arrayReport as $k => $v){
                                                    $keys = array_keys($v);
                                                    $delete = array_shift($keys);
                                                    foreach($keys as $r){
                                                        $modal .= '<tr>
                                                                    <td>'.$v['proveedor'].'</td>
                                                                    <td>'.$arrayReport[$k][$r]['tipo'].'</td>
                                                                    <td>'.$arrayReport[$k][$r]['linea_art'].'</td>
                                                                    <td>'.$arrayReport[$k][$r]['cantidad'].'</td>
                                                                    <td>'.precio_format($arrayReport[$k][$r]['importe']).'</td>
                                                                </tr>';
                                                    }
                                                }

                                    $modal .= '</tbody>
                                            </table>
                                        </div>
                                    </div>';

                        $data['modal'] = $modal;
                    }
                }
                
            }
        }

        $this->data['contenido'] = $this->load->view($this->mainView.'/nuevo_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
    }

    public function getFolio($length = 7) { 
        return substr(str_shuffle("0123456789"), 0, $length); 
    }

    public function ver($id = null)
    {
        if ($id == null) {
            redirect($this->router->class);
        } else {
            $ordenCompra = $this->mordencompra->getById($id);
            // info
            $info = $this->mmaterial->getById($ordenCompra['idMaterial']);
            if( !empty($info['id']) && !empty($info['idPaquete']) ){
                $data['idOrdenCompra'] = $ordenCompra['id'];
                $data['idMaterial'] = $ordenCompra['idMaterial'];
                $idMO = $this->mpaquete->getCampo('idManoObra', $info['idPaquete']);
                //$qPaquete = $this->mpaquete->getByIdManoObra($idMO);
                $qPaquete = $this->mpaquete->getById($info['idPaquete']);
                $data['paquete'] = $qPaquete['titulo'];
                $data['fecha'] = date_format(new DateTime($ordenCompra['fecha']),'Y-m-d') ;
                $data['folio'] = $ordenCompra['folio'];
                //$data['semana'] = $this->mdetalleorden->getSemanaByIdOrden($ordenCompra['id']);
                $data['semana'] = $ordenCompra['semana'];
                $getInfo = $this->getInfoVer($qPaquete['id']);
                if($getInfo != 0){
                    $data['fraccionamiento'] = $getInfo['fraccionamiento'];
                    $data['prototipo'] = $getInfo['prototipo'];
                    $data['rangoLotes'] = $getInfo['rangoLotes'];
                    $data['presupuestoViv'] = $getInfo['presupuestoViv'];
                    $data['presupuestoPaq'] = $getInfo['presupuestoPaq'];
                    $data['costoM2'] = $getInfo['costoM2'];
                    $data['m2Viv'] = $getInfo['m2Viv'];
                }else{
                    $data['fraccionamiento'] = '';
                    $data['prototipo'] = '';
                    $data['rangoLotes'] = '';
                    $data['presupuestoViv'] = '';
                    $data['presupuestoPaq'] = '';
                    $data['costoM2'] = '';
                    $data['m2Viv'] = '';
                }
                $data['almacen'] = $this->malmacenes->getCampo('nombre', $ordenCompra['id_almacen']);
                $data['proveedor'] = $this->mproveedor->getCampo('nombre', $ordenCompra['id_proveedor']);
                $data['importeT'] = $ordenCompra['importe_neto'];
            }else{
                $data['idOrdenCompra'] = $ordenCompra['id'];
                $data['paquete'] = '';
                $data['fecha'] = date_format(new DateTime($ordenCompra['fecha']),'Y-m-d') ;
                $data['folio'] = $ordenCompra['folio'];
                $data['semana'] = $ordenCompra['semana'];
                $data['almacen'] = $this->malmacenes->getCampo('nombre', $ordenCompra['id_almacen']);
                $data['proveedor'] = $this->mproveedor->getCampo('nombre', $ordenCompra['id_proveedor']);
                $data['importeT'] = $ordenCompra['importe_neto'];
                $data['idMaterial'] = 0;
                $data['fraccionamiento'] = '';
                $data['prototipo'] = '';
                $data['rangoLotes'] = '';
                $data['presupuestoViv'] = '';
                $data['presupuestoPaq'] = '';
                $data['costoM2'] = '';
                $data['m2Viv'] = '';
            }

            $this->data['contenido'] = $this->load->view($this->mainView . '/ver_view', $data, true);
            $this->load->view('templates/main_template', $this->data);
        }
    }

    public function listadoVer()
    {
        $empty = true;
        $idMaterial = $this->input->post('idMaterial');
        $semana = $this->input->post('semana');
        $idOrdenCompra = $this->input->post('idOrdenCompra');
        $idEmpresa=$_SESSION[$this->nsession]['idEmpresa'];
        //$materialesPresupuesto = $this->mpresupuestomat->getByIdMaterial2($idMaterial, $semana, $idOrdenCompra);
        $materialesPresupuesto = $this->db->query("SELECT d.*, o.id_proveedor, o.id_almacen, o.semana FROM orden_compra AS o 
                                                  LEFT JOIN detalle_orden AS d ON o.id = d.id_orden_compra 
                                                  WHERE o.idEmpresa=$idEmpresa AND o.id = $idOrdenCompra");
        if ($materialesPresupuesto->num_rows() > 0) {
            $arrayProveedores = array();
            $arrayPresupuestoMAT = array();
            $countArray = 0;
            foreach ($materialesPresupuesto->result() as $row) {
                $existe = 0;
                $arrayPresupuestoMAT = array();
                //$materialActividadPrototipo = $this->mmaterialesactividadprototipo->getById($row->idMateriales);
                //if (!is_numeric($materialActividadPrototipo)) {
                    $material = $this->mmateriales->getById2($row->id_articulo,$idEmpresa);
                    if (!is_numeric($material)) {
                        $empty = false;
                        //$area = $this->mareamaterial->getCampo2('area', $material['idArea']);
                        $proveedor = $this->mproveedor->getCampo2('nombre', $row->id_proveedor);
                        //$nameUnidad = $this->munidades->getCampo2('unidad', $material['idUnidad']);
                        //$abrevUnidad = $this->munidades->getCampo2('abreviatura', $material['idUnidad']);
                        //$unidad = $nameUnidad . ' (' . $abrevUnidad . ')';
                        $unidad = $material['unidad_compra'];

                        if(!array_key_exists($row->id_proveedor, $arrayProveedores)){
                            //$importe = $materialActividadPrototipo['cantidad'] * $row->precioUnitario;
                            $importe = $row->unidades * $row->precio_unitario;
                            $arrayPresupuestoMAT[0] = array('clave' => $material['clave'], 'proveedor' => $proveedor, 'descripcion' => $material['nombre'], 'unidad' => $unidad, 'cantidad' => (int)$row->unidades, 'precioUnitario' => $row->precio_unitario, 'importe' => $importe, 'idPresupuesto' => $row->id, 'semana' => $row->semana);
                            $arrayProveedores[$row->id_proveedor] = array('proveedor' => $proveedor, 'total' => $importe, 'materiales' => $arrayPresupuestoMAT);
                        }else{
                            //$importe = $materialActividadPrototipo['cantidad'] * $row->precioUnitario;
                            $importe = $row->unidades * $row->precio_unitario;
                            $total = $arrayProveedores[$row->id_proveedor]['total'];
                            $total = $total + $importe;
                            $array = $arrayProveedores[$row->id_proveedor]['materiales'];
                            $arrayPresupuestoMAT = array('clave' => $material['clave'], 'proveedor' => $proveedor, 'descripcion' => $material['nombre'], 'unidad' => $unidad, 'cantidad' => (int)$row->unidades, 'precioUnitario' => $row->precio_unitario, 'importe' => $importe, 'idPresupuesto' => $row->id, 'semana' => $row->semana);
                            array_push($array, $arrayPresupuestoMAT);
                            $arrayProveedores[$row->id_proveedor] = array('proveedor' => $proveedor, 'total' => $total, 'materiales' => $array);
                        }

                        //array_push($arrayPresupuestoMAT, array('clave' => $material['clave'], 'proveedor' => $proveedor, 'descripcion' => $material['nombre'], 'unidad' => $unidad, 'cantidad' => $materialActividadPrototipo['cantidad'], 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe, 'idPresupuesto' => $row->id, 'semana' => $row->semana));
                    }
                //}
            }
        }

        if (!$empty) {
            if (count($arrayProveedores) > 0) {
                foreach ($arrayProveedores as $k => $v) {

                    $array['aaData'][] = array(
                        'clave' => '',
                        //'area' => $row['area'],
                        'proveedor' => $arrayProveedores[$k]['proveedor'],
                        'descripcion' => '',
                        'unidad' => '',
                        'cantidad' => '',
                        'precioUnitario' => '',
                        'importe' => precio_format($arrayProveedores[$k]['total']),
                        'semana' => ''
                    );

                    foreach($arrayProveedores[$k]['materiales'] as $row){
                        $array['aaData'][] = array(
                            'clave' => $row['clave'],
                            //'area' => $row['area'],
                            'proveedor' => $row['proveedor'],
                            'descripcion' => $row['descripcion'],
                            'unidad' => $row['unidad'],
                            'cantidad' => $row['cantidad'],
                            'precioUnitario' => precio_format($row['precioUnitario']),
                            'importe' => precio_format($row['importe']),
                            'semana' => $row['semana']
                        );
                    }
                }
            } else {
                $array['aaData'][] = array(
                    'clave' => 'No hay registros',
                    //'area' => 'No hay registros',
                    'proveedor' => 'No hay registros',
                    'descripcion' => 'No hay registros',
                    'unidad' => 'No hay registros',
                    'cantidad' => 'No hay registros',
                    'precioUnitario' => 'No hay registros',
                    'importe' => 'No hay registros',
                    'semana' => 'No hay registros'
                );
            }
        } else {
            $array['aaData'][] = array(
                'clave' => 'No hay registros',
                //'area' => 'No hay registros',
                'proveedor' => 'No hay registros',
                'descripcion' => 'No hay registros',
                'unidad' => 'No hay registros',
                'cantidad' => 'No hay registros',
                'precioUnitario' => 'No hay registros',
                'importe' => 'No hay registros',
                'semana' => 'No hay registros'
            );
        }
        echo json_encode($array);
    }

    public function getPrototiposByFracc($id = '')
    {
        $prototipos = $this->mprototipoxfraccionamiento->getByIdFraccionamiento($id);
        $array = array();
        $response = array();
        if (!is_numeric($prototipos)) {
            foreach ($prototipos->result() as $key => $value) {
                $array = array(
                    'id' => $value->idPrototipo,
                    'text' => $this->mprototipos->getCampo('nombre', $value->idPrototipo)
                );
                array_push($response, $array);
            }
        } else {
            $response = 0;
        }
        echo json_encode($response);
    }

    public function getPaquetesByFraccProto($idFraccionamiento = '', $idPrototipo = '')
    {
        $paquetes = $this->mpaquete->getByIdFraccionamientoPrototipo($idFraccionamiento, $idPrototipo);
        $array = array();
        $response = array();
        if (!is_numeric($paquetes)) {
            foreach ($paquetes->result() as $key => $value) {
                $array = array(
                    'id' => $value->id,
                    'text' => $this->mpaquete->getCampo('titulo', $value->id)
                );
                array_push($response, $array);
            }
        } else {
            $response = 0;
        }
        echo json_encode($response);
    }

    public function getSemanasByPaquete($idAlmacen=0){
        $idEmpresa=$_SESSION[$this->nsession]['idEmpresa'];
        $almacen=$this->malmacenes->getByIdEmpresa($idAlmacen,$idEmpresa);
        $response=[];
        if(!is_numeric($almacen)){
            $idPaquete=$almacen->idPaquete;
            $tipoAlmacen=$almacen->tipoAlmacen;
            $filter="";
            if($tipoAlmacen==1){
                $filter="paq.id = '$idPaquete'";
            }else if($tipoAlmacen==2){
                $filter="FIND_IN_SET(paq.id,'$idPaquete')";
            }
            $semanas = $this->db->query("SELECT p.semana AS id, p.semana AS titulo FROM material AS m 
                    INNER JOIN presupuesto_mat AS p ON m.id = p.idMaterial
                    INNER JOIN paquetes paq ON m.idPaquete = paq.id 
                    INNER JOIN mano_obra AS mo ON paq.idManoObra = mo.id 
                    WHERE $filter
                    GROUP BY p.semana ORDER BY p.semana ASC");

            /*sincronizacion ----
            require('Ms.php');
            $ms = new Ms();
            ini_set('max_execution_time', 0);
            $material=$this->mmaterial->getByIdPaquete($idPaquete);
            $almacen=$this->malmacenes->getByIdPaquete($material["idEmpresa"],$idPaquete);
            $ms->getDocsByEmpresaAlmacen($material["idEmpresa"],$almacen->id,'O',0);*/

            $array = array();
            $response = array();
            if ($semanas->num_rows() > 0) {
                foreach ($semanas->result() as $key => $value) {
                    $array = array(
                        'id' => $value->id,
                        'text' => 'Semana '. $value->titulo
                    );
                    array_push($response, $array);
                }
            } else {
                $response = 0;
            }
        }
        echo json_encode(["weeks"=>$response]);
    }

    public function getCategoriasByPaquete($idPaquete=0){
        $query=$this->db->query("SELECT pmat.clave_cat FROM presupuesto_mat pmat
        INNER JOIN categorias_mat cmat ON cmat.clave = pmat.clave_cat
        INNER JOIN material mat ON mat.id=pmat.idMaterial WHERE mat.idPaquete=$idPaquete");
    }

    public function getPresupuestoMaterial(){
        $idAlmacen = $this->input->post('idAlmacen');
        $semana = $this->input->post('semana');
        //$idMO = $this->mpaquete->getCampo('idManoObra', $idPaquete);
        //$idFraccionamiento = $this->mmanoobra->getCampo('idFraccionamiento', $idMO);
        //$idPrototipo = $this->mmanoobra->getCampo('idPrototipo', $idMO);
        //$detalle = $this->mdetallepaquete->getByIdPaquete($idPaquete);
        //$lotes = (!is_numeric($detalle)) ? $detalle->num_rows() : 0;
        //$material = $this->mmaterial->getByIdFraccIdProtIdMO($idFraccionamiento, $idPrototipo, $idPaquete);
        $idEmpresa=$_SESSION[$this->nsession]['idEmpresa'];
        $almacen=$this->malmacenes->getByIdEmpresa($idAlmacen,$idEmpresa);
        if(!is_numeric($almacen)){
            $idPaquete=$almacen->idPaquete;
            $tipoAlmacen=$almacen->tipoAlmacen;
            //sincronizacion
            /*require('Ms.php');
            $ms = new Ms();
            ini_set('max_execution_time', 0);
            $almacen=$this->malmacenes->getByIdPaquete($material["idEmpresa"],$idPaquete);
            $ms->getDocsByEmpresaAlmacen($material["idEmpresa"],$almacen->id,'O',0);*/
            //armado de tabla
            $materialesPresupuesto = $this->mpresupuestomat->getMaterialJoinOc($idEmpresa,$idPaquete,$semana,$tipoAlmacen);
            if (!is_numeric($materialesPresupuesto)) {
                $arrayProveedores = array();
                $arrayCategorias = array();
                $countArray = 0;
                if (!is_numeric($materialesPresupuesto)) {
                    $arrNoRepeats=[];
                    foreach ($materialesPresupuesto->result() as $row) {
                        if(!in_array($row->id_articulo."-".$row->clave,$arrNoRepeats)){
                            array_push($arrNoRepeats,$row->id_articulo."-".$row->clave);
                            if (($row->unidades_paq - $row->comprado) > 0) {
                                $input = '<input id="' . $row->idPresupuesto . '" name="values[]" type="text" class="form-control input-number" data-cantidad="'.$row->pendiente.'" 
                                data-proveedor="'.$row->idProveedor.'" data-clave="'.$row->clave.'" data-clave_cat="'.$row->clave_mat.'" value="'.round($row->pendiente,2).'" style="width: 80px;" onkeyup="getTotal($(this));">';
                            } else {
                                $input = 0;
                            }
                            // Se agrega proveedor
                            if(!in_array($row->idProveedor,$arrayProveedores)){
                                array_push($arrayProveedores,$row->idProveedor);
                                $arrayCategorias = array();
                                $array['aaData'][] = array(
                                    'clave' => "",
                                    'proveedor' => $row->proveedor,
                                    'categoria' => "",
                                    'articulo' => "",
                                    'unidad' => "",
                                    'unidades_viv' => "",
                                    'unidades_paq' => "",
                                    'comprado' => "",
                                    'pendiente' => "",
                                    'cantidad' => "",
                                    'precio_unitario' => "",
                                    'importe' => '<span id="proveedor_' . $row->idProveedor . '" class="moneda">' . precio_format(0,2) . '</span>',
                                    'semana' => "",
                                );
                            }
                            // Se agrega categoría
                            if(!in_array($row->categoria_mat,$arrayCategorias)){
                                array_push($arrayCategorias,$row->categoria_mat);
                                $array['aaData'][] = array(
                                    'clave' => "",
                                    'proveedor' => "",
                                    'categoria' => $row->categoria_mat,
                                    'articulo' => "",
                                    'unidad' => "",
                                    'unidades_viv' => "",
                                    'unidades_paq' => "",
                                    'comprado' => "",
                                    'pendiente' => "",
                                    'cantidad' => "",
                                    'precio_unitario' => "",
                                    'importe' => '<span id="cat_' . $row->idProveedor . '_' . $row->clave_mat . '" class="moneda">' . precio_format(0,2) . '</span>',
                                    'semana' => "",
                                );
                            }
                            $array['aaData'][] = array(
                                'clave' => $row->clave,
                                'proveedor' => $row->proveedor,
                                'categoria' => $row->categoria_mat,
                                'articulo' => $row->articulo,
                                'unidad' => $row->unidad,
                                'unidades_viv' => number_format($row->unidades_viv,2),
                                'unidades_paq' => number_format($row->unidades_paq,2),
                                'comprado' => number_format($row->comprado,2),
                                'pendiente' => number_format($row->pendiente,2),
                                'cantidad' => $input,
                                'precio_unitario' => '<span id="precioUnitario_' . $row->idPresupuesto . '" data-proveedor="'.$row->idProveedor.'" data-precio="'.$row->precio_unitario.'">' . precio_format($row->precio_unitario,2) . '</span>',
                                'importe' => '<span id="importe_' . $row->idPresupuesto. '" data-proveedor="'.$row->idProveedor.'">' . precio_format($row->importe_paq) . '</span>',
                                'semana' => $row->semana,
                            );
                        }
                    }
                }
            }else{
                $array['aaData'] = [];
            }
        }
        echo json_encode($array);
    }

    public function updateByAlmacenSemana($idEmpresa,$idPaquete,$semana=""){
        $filter="";
        if($semana != ""){
            $filter.=" AND semana=".$semana;
        }
        require('Cronjob.php');
        $cronjob = new Cronjob();
        $ordenes=$this->db->query("SELECT folio id FROM orden_compra_viv WHERE idPaquete=$idPaquete $filter");
        if($ordenes->num_rows() > 0){
            foreach ($ordenes->result() as $row) {
                $cronjob->GetOrdenCompra($idEmpresa,$row->id,$idPaquete,false);
            }
        }else{
            //echo "No hay nada que sincronizar";
        }
    }

    public function getInfo($idAlmacen=0){
        $datosAlmacen="";
        if($idAlmacen>0  && isset($_SESSION[$this->nsession]['idEmpresa'])){
            $idEmpresa = $_SESSION[$this->nsession]['idEmpresa'];
            $almacen=$this->malmacenes->getByIdEmpresa($idAlmacen,$idEmpresa);
            if(!is_numeric($almacen)){
                $query=$this->db->query("SELECT fra.titulo titleFracc,GROUP_CONCAT(paq.rango_lotes SEPARATOR ' | ') rango_lotes FROM paquetes paq
                LEFT JOIN mano_obra mo ON mo.id=paq.idManoObra
                LEFT JOIN fraccionamientos fra ON fra.id=mo.idFraccionamiento
                WHERE FIND_IN_SET(paq.id,'$almacen->idPaquete')
                GROUP BY fra.id");
                if($query->num_rows()>0){
                    foreach ($query->result() as $row) {
                        $datosAlmacen.=$row->titleFracc.': '.$row->rango_lotes.'<br>';
                    }
                }
            }
        }
        echo json_encode($datosAlmacen);
    }

    public function getInfoVer($idPaquete)
    {
        $paquete = $this->mpaquete->getById($idPaquete);
        $qManoObra = $this->mmanoobra->getById($paquete['idManoObra']);
        $superficieM2 = $this->mprototipos->getCampo('superficieM2',$qManoObra['idPrototipo']);
        $prototipo = $this->mprototipos->getById($qManoObra['idPrototipo']);
        $material = $this->mmaterial->getByIdFraccIdProtIdMO($qManoObra['idFraccionamiento'], $qManoObra['idPrototipo'], $idPaquete);
        $detalle = $this->mdetallepaquete->getByIdPaquete($idPaquete);
        if (!is_numeric($paquete) && !is_numeric($prototipo) && !is_numeric($material)) {
            $presupuestoViv = $this->mpresupuestomat->getSumTotalImporte($material['id']);
            $lotes = (!is_numeric($detalle)) ? $detalle->num_rows() : 0;
            $presupuestoPaq = $presupuestoViv * $lotes;
            $costoM2 = $presupuestoViv / $superficieM2 ;
            $response = array('prototipo' => $prototipo['titulo'],
                'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo', $qManoObra['idFraccionamiento']),
                'rangoLotes' => (!is_numeric($detalle))? $detalle->num_rows() : 0,
                'presupuestoViv' => precio_format($presupuestoViv),
                'presupuestoPaq' => precio_format($presupuestoPaq),
                'costoM2' => precio_format($costoM2),
            
                'm2Viv' => $prototipo['superficieM2']
            );
        } else {
            $response = 0;
        }
        return $response;
    }

    //INICIA WEB SERVICE
    public function updateWS(){
        ini_set('max_execution_time', 0);
        $curl = curl_init();
        //INFORMACION A ENVIAR POR POST EN FORMATO JSON
        $idEmpresa = $_SESSION["viv"]['idEmpresa'];
        $idUsuario = $_SESSION["viv"]['id'];
        $datos = json_encode(array('un' => $idEmpresa, 'bundle' => array('estatus' => 0)));
        $time_start = microtime(true);
        
        curl_setopt_array($curl, array(
            CURLOPT_PORT => $this->config->item('portmicro'),
            CURLOPT_URL => $this->config->item('dnsmicro')."GetOrdenesCompra",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 3600,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_FOLLOWLOCATION => 1,
            CURLOPT_POSTFIELDS => $datos,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "postman-token: ab5bf890-47c6-d504-ba8f-82667b58bebd",
                'Content-Type:application/json'
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);

        $json = [];
        if ($err) {
            echo "cURL Error #:" . $err;
            $time_end = microtime(true);
            $time = $time_end - $time_start;
            $dataL['time'] = $time;
            $dataL['idEmpresa'] = $idEmpresa;
            $dataL['nombreTabla'] = 'orden_compra';
            $dataL['funcion'] = 'GetOrdenesCompra';
            $dataL['http_code'] = 0;
            $dataL['insertados'] = 0;
            $dataL['actualizados'] = 0;
            $dataL['totalRegistros'] = 0;
            $dataL['json'] = "CURL Error #:" . $err;
            $dataL['created'] = date("Y-m-d H:i:s");
            $dataL['updated'] = date("Y-m-d H:i:s");
            $this->db->insert('logs_ws', $dataL);
        }else{
            $json = $response;
            // Comprueba el código de estado HTTP
            if (!curl_errno($curl)) {
              switch ($http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE)) {
                case 200:
                    //Contadores de prueba
                    $nInsert=0;
                    $nUpdate=0;
                    $nTotal=0;
                    $nInsert2=0;
                    $nUpdate2=0;
                    $data="";
                    //Objeto de respuesta
                    $json = json_decode($json);
                    //Recorre objeto stdClass
                    foreach ($json->object_result as $row) {
                        //Recorre ordenes de compra(orden_compra)
                        foreach ($row as $key => $val) {
                            switch ($key) {
                                case 'lista_articulos':
                                    //Recorre listado de articulos(detalle_orden)
                                    foreach ($val as $row2) {
                                        foreach ($row2 as $key2 => $val2){
                                            switch ($key2) {
                                                default:
                                                    $data2[$key2]=$val2;
                                            }
                                        }
                                    }
                                    //Validaciones de sincronizacion de detalle orden
                                    if($this->mdetalleorden->valInsert($data2['id'],$idEmpresa)){
                                        $this->mdetalleorden->insertar($data2);
                                        $nInsert2++;
                                    }else if($this->mdetalleorden->valUpdate($data2['id'],$data2)){
                                        $this->mdetalleorden->actualizar($data2,$data2['id']);
                                        $nUpdate2++;
                                    }
                                    break;
                                default:
                                   $data[$key]=$val;
                            }
                        }
                        //Validaciones de sincronizacion de ordenes de compra
                        $data["idEmpresa"]=$idEmpresa;
                        if($this->mordencompra->valInsert($data['id'],$idEmpresa)){
                            $this->mordencompra->insertar($data);
                            $nInsert++;
                        }else if($this->mordencompra->valUpdate($data['id'],$data)){
                            $this->mordencompra->actualizar($data,$data['id']);
                            $nUpdate++;
                        }
                        $nTotal++;
                    }
                    echo "Insertados: ".$nInsert." <br> ";
                    echo "Actualizados: ".$nUpdate." <br> ";
                    echo "Total de registros: ".$nTotal." <br> ";
                    curl_close($curl);
                    unset($json->object_result);
                    $json = json_encode($json);
                    $time_end = microtime(true);
                    $time = $time_end - $time_start;
                    $dataL['time'] = $time;
                    $dataL['idEmpresa'] = $idEmpresa;
                    $dataL['nombreTabla'] = 'orden_compra';
                    $dataL['funcion'] = 'GetOrdenesCompra';
                    $dataL['http_code'] = $http_code;
                    $dataL['insertados'] = $nInsert;
                    $dataL['actualizados'] = $nUpdate;
                    $dataL['totalRegistros'] = $nTotal;
                    $dataL['json'] = $json;
                    $dataL['created'] = date("Y-m-d H:i:s");
                    $dataL['updated'] = date("Y-m-d H:i:s");
                    $dataL['created_by'] = $idUsuario;
                    $dataL['updated_by'] = $idUsuario;
                    $this->db->insert('logs_ws', $dataL);
                    redirect($this->mainView);
                    break;
                case 404:
                    echo "Not found";
                    $json = json_decode($json);
                    unset($json->object_result);
                    $json = json_encode($json);
                    $time_end = microtime(true);
                    $time = $time_end - $time_start;
                    $dataL['time'] = $time;
                    $dataL['idEmpresa'] = $idEmpresa;
                    $dataL['nombreTabla'] = 'orden_compra';
                    $dataL['funcion'] = 'GetOrdenesCompra';
                    $dataL['http_code'] = $http_code;
                    $dataL['insertados'] = 0;
                    $dataL['actualizados'] = 0;
                    $dataL['totalRegistros'] = 0;
                    $dataL['json'] = $json;
                    $dataL['created'] = date("Y-m-d H:i:s");
                    $dataL['updated'] = date("Y-m-d H:i:s");
                    $dataL['created_by'] = $idUsuario;
                    $dataL['updated_by'] = $idUsuario;
                    $this->db->insert('logs_ws', $dataL);
                    break;
                default:
                    echo 'Unexpected HTTP code: ', $http_code, "\n";
                    $json = json_decode($json);
                    unset($json->object_result);
                    $json = json_encode($json);
                    $time_end = microtime(true);
                    $time = $time_end - $time_start;
                    $dataL['time'] = $time;
                    $dataL['idEmpresa'] = $idEmpresa;
                    $dataL['nombreTabla'] = 'orden_compra';
                    $dataL['funcion'] = 'GetOrdenesCompra';
                    $dataL['http_code'] = $http_code;
                    $dataL['insertados'] = 0;
                    $dataL['actualizados'] = 0;
                    $dataL['totalRegistros'] = 0;
                    $dataL['json'] = $json;
                    $dataL['created'] = date("Y-m-d H:i:s");
                    $dataL['updated'] = date("Y-m-d H:i:s");
                    $dataL['created_by'] = $idUsuario;
                    $dataL['updated_by'] = $idUsuario;
                    $this->db->insert('logs_ws', $dataL);
                    break;
              }
            }
        }
    }

    public function sync(){
        $idAlmacen=$_POST["idAlmacen"];
        $idEmpresa=$_POST["idEmpresa"];
        require('Ms.php');
        $ms = new Ms();
        $ms->getDocsByEmpresaAlmacen($idEmpresa,$idAlmacen,'',0,1);
        echo json_encode("Test");
    }

    public function AddCompraMsipAsync($array){
        ini_set('max_execution_time', 300);
        $curl = curl_init();
        //echo json_encode($array);
        //exit();
        //INFORMACION A ENVIAR POR POST EN FORMATO JSON
        $idEmpresa = $_SESSION["viv"]['idEmpresa'];
        $idUsuario = $_SESSION["viv"]['id'];
        $datos=$array;
        $datos = json_encode($datos);
        $time_start = microtime(true);

        curl_setopt_array($curl, array(
            CURLOPT_PORT => $this->config->item('portmicro'),
            CURLOPT_URL => $this->config->item('dnsmicro')."AddCompraMsipAsync",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 60000,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_FOLLOWLOCATION => 1,
            CURLOPT_POSTFIELDS => $datos,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "postman-token: ab5bf890-47c6-d504-ba8f-82667b58bebd",
                'Content-Type:application/json'
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        $res['resultado'] = '';

        $json = [];
        if ($err) {
            $res['error'] = true;
            echo "cURL Error #:" . $err;
            $dataL['idEmpresa'] = $idEmpresa;
            $dataL['nombreTabla'] = 'orden_compra';
            $dataL['funcion'] = 'AddCompraMsipAsync';
            $dataL['http_code'] = 0;
            $dataL['insertados'] = 0;
            $dataL['actualizados'] = 0;
            $dataL['totalRegistros'] = 0;
            $dataL['json'] = "CURL Error #:" . $err;
            $dataL['created'] = date("Y-m-d H:i:s");
            $dataL['updated'] = date("Y-m-d H:i:s");
            $dataL['created_by'] = $idUsuario;
            $dataL['updated_by'] = $idUsuario;
            $this->db->insert('logs_ws', $dataL);
        }else{
            $res['error'] = false;
            $json = $response;
            // Comprueba el código de estado HTTP
            if (!curl_errno($curl)) {
                switch ($http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE)) {
                    case 200:
                        $dataL['json'] = $json;
                        $json = json_decode($json, true);
                        if($json['result']){
                            $res['responseObject'] = true;
                            //$res['resultado'] = intval(preg_replace('/[^0-9]+/', '', $json['error_message']), 10);
                            $res['resultado'] = $json['object_result'];
                            $res['error_message'] = $json['error_message'];
                        }else{
                            $res['responseObject'] = false;
                            $res['error_message'] = $json['error_message'];
                        }
                        
                        $time_end = microtime(true);
                        $time = $time_end - $time_start;
                        $dataL['time'] = $time;
                        $dataL['idEmpresa'] = $idEmpresa;
                        $dataL['nombreTabla'] = 'orden_compra';
                        $dataL['funcion'] = 'AddCompraMsipAsync';
                        $dataL['http_code'] = $http_code;
                        $dataL['insertados'] = ($json['result'])? 1 : 0;
                        $dataL['actualizados'] = 0;
                        $dataL['totalRegistros'] = ($json['result'])? 1 : 0;
                        $json = json_encode($json);
                        $dataL['json'] = $json;
                        $dataL['created'] = date("Y-m-d H:i:s");
                        $dataL['updated'] = date("Y-m-d H:i:s");
                        $dataL['created_by'] = $idUsuario;
                        $dataL['updated_by'] = $idUsuario;
                        $this->db->insert('logs_ws', $dataL);
                        break;
                    case 404:
                        echo "Not found";
                        $time_end = microtime(true);
                        $time = $time_end - $time_start;
                        $dataL['time'] = $time;
                        $dataL['idEmpresa'] = $idEmpresa;
                        $dataL['nombreTabla'] = 'orden_compra';
                        $dataL['funcion'] = 'AddCompraMsipAsync';
                        $dataL['http_code'] = $http_code;
                        $dataL['insertados'] = 0;
                        $dataL['actualizados'] = 0;
                        $dataL['totalRegistros'] = 0;
                        $dataL['json'] = $json;
                        $dataL['created'] = date("Y-m-d H:i:s");
                        $dataL['updated'] = date("Y-m-d H:i:s");
                        $dataL['created_by'] = $idUsuario;
                        $dataL['updated_by'] = $idUsuario;
                        $this->db->insert('logs_ws', $dataL);
                        break;
                    default:
                        echo 'Unexpected HTTP code: ', $http_code, "\n";
                        $time_end = microtime(true);
                        $time = $time_end - $time_start;
                        $dataL['time'] = $time;
                        $dataL['idEmpresa'] = $idEmpresa;
                        $dataL['nombreTabla'] = 'orden_compra';
                        $dataL['funcion'] = 'AddCompraMsipAsync';
                        $dataL['http_code'] = $http_code;
                        $dataL['insertados'] = 0;
                        $dataL['actualizados'] = 0;
                        $dataL['totalRegistros'] = 0;
                        $dataL['json'] = $json;
                        $dataL['created'] = date("Y-m-d H:i:s");
                        $dataL['updated'] = date("Y-m-d H:i:s");
                        $dataL['created_by'] = $idUsuario;
                        $dataL['updated_by'] = $idUsuario;
                        $this->db->insert('logs_ws', $dataL);
                        break;
                }
            }
        }
        curl_close($curl);

        return $res;
    }

    public function GetPrecioUnitarioCM($array){
        ini_set('max_execution_time', 300);
        $curl = curl_init();
        //INFORMACION A ENVIAR POR POST EN FORMATO JSON
        $datos=$array;
        $datos = json_encode($datos);

        curl_setopt_array($curl, array(
            CURLOPT_PORT => $this->config->item('portmicro'),
            CURLOPT_URL => $this->config->item('dnsmicro')."GetPrecioUnitarioCM",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 60000,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_FOLLOWLOCATION => 1,
            CURLOPT_POSTFIELDS => $datos,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "postman-token: ab5bf890-47c6-d504-ba8f-82667b58bebd",
                'Content-Type:application/json'
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        $precioUnitario = 0.00;

        $json = [];
        if ($err) {
            echo "cURL Error #:" . $err;
        }else{
            $json = $response;
            // Comprueba el código de estado HTTP
            if (!curl_errno($curl)) {
              switch ($http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE)) {
                case 200:
                    $json = json_decode($json, true);
                    if($json['result'] == true || $json['result'] == "true"){
                        if(count($json) > 0){
                            $precioUnitario = $json['object_result']['precio_unitario'];
                        }
                    }
                    break;
                case 404:
                    echo "Not found";
                    break;
                default:
                    echo 'Unexpected HTTP code: ', $http_code, "\n";
              }
            }
        }
        curl_close($curl);
        return floatval($precioUnitario);
    }

    public function getValidSemana(){
        $idPaquete = $this->input->post('idPaquete');
        $semana = $this->input->post('semana');
        $idMO = $this->mpaquete->getCampo('idManoObra', $idPaquete);
        $idFraccionamiento = $this->mmanoobra->getCampo('idFraccionamiento', $idMO);
        $idPrototipo = $this->mmanoobra->getCampo('idPrototipo', $idMO);
        $response['status'] = false;

        $material = $this->mmaterial->getByIdFraccIdProtIdMO($idFraccionamiento, $idPrototipo, $idPaquete);
        if(!is_numeric($material)){
            $idMaterial = $material['id'];
            $qOrdenCompra = $this->db->query("SELECT * FROM orden_compra_viv WHERE idMaterial = $idMaterial AND idPaquete = $idPaquete AND semana = $semana");
            if($qOrdenCompra->num_rows() > 0){
                $response['status'] = true;
            }
        }

        echo json_encode($response);
    }

    public function getValidSession()
    {
        $usuario = $this->input->post('usuario');
        $password = $this->input->post('password');

        $res = $this->musuario->checkUser($usuario,sha1($password));
        if ($res->num_rows() == 1){
            if ($res->row()->status == 1){
                if($res->row()->id == 1 || $res->row()->id == 4 || $res->row()->id == 207){
                    $response['status'] = 1;
                }else{
                    $response['status'] = 0;
                }
            }else{
                $response['status'] = 0;
            }
        }else{
            $response['status'] = 0;
        }

        echo json_encode($response);
    }

    public function editar($id){
        $data['msg'] = '';
        //$data['almacenes'] = $this->malmacenes->getSelectResult();
        $data['articulos'] = $this->mmateriales->getSelectResult();
        $qOrdenC = $this->mordencompra->getById($id);
        $this->copy_orden_viv($id);
        $qOCviv = $this->mordencompraviv->getByIdMatPaqSemProvFol($qOrdenC['idMaterial'], $qOrdenC['idPaquete'], $qOrdenC['semana'], $qOrdenC['id_proveedor'], $qOrdenC['folio']);
        if( !is_numeric($qOCviv) ){
            // info
            if( !empty($qOrdenC['idMaterial']) && !empty($qOrdenC['idPaquete']) ){
                $info = $this->mmaterial->getById($qOCviv['idMaterial']);
                $data['idOrdenCompra'] = $qOrdenC['id'];
                $data['idMaterial'] = $qOrdenC['idMaterial'];
                $idMO = $this->mpaquete->getCampo('idManoObra', $info['idPaquete']);
                //$qPaquete = $this->mpaquete->getByIdManoObra($idMO);
                $qPaquete = $this->mpaquete->getById($info['idPaquete']);
                $data['paquete'] = $qPaquete['titulo'];
                $data['fecha'] = date_format(new DateTime($qOrdenC['fecha']),'d-m-Y') ;
                $data['folio'] = $qOrdenC['folio'];
                $data['semana'] = $qOrdenC['semana'];
                $data['almacen'] = $this->malmacenes->getCampo('nombre', $qOrdenC['id_almacen']);
                //$data['id_almacen'] = $qOrdenC['id_almacen'];
                $data['proveedor'] = $this->mproveedor->getCampo('nombre', $qOrdenC['id_proveedor']);
                $data['importeT'] = $qOrdenC['importe_neto'];
                $getInfo = $this->getInfoVer($qPaquete['id']);
                if($getInfo != 0){
                    $data['fraccionamiento'] = $getInfo['fraccionamiento'];
                    $data['prototipo'] = $getInfo['prototipo'];
                    $data['rangoLotes'] = $getInfo['rangoLotes'];
                    $data['presupuestoViv'] = $getInfo['presupuestoViv'];
                    $data['presupuestoPaq'] = $getInfo['presupuestoPaq'];
                    $data['costoM2'] = $getInfo['costoM2'];
                    $data['m2Viv'] = $getInfo['m2Viv'];
                }else{
                    $data['fraccionamiento'] = '';
                    $data['prototipo'] = '';
                    $data['rangoLotes'] = '';
                    $data['presupuestoViv'] = '';
                    $data['presupuestoPaq'] = '';
                    $data['costoM2'] = '';
                    $data['m2Viv'] = '';
                }
            } else{
                $data['idOrdenCompra'] = $qOrdenC['id'];
                $data['idMaterial'] = $qOrdenC['idMaterial'];
                $data['paquete'] = '';
                $data['fecha'] = date_format(new DateTime($qOrdenC['fecha']),'d-m-Y') ;
                $data['folio'] = $qOrdenC['folio'];
                $data['semana'] = $qOrdenC['semana'];
                $data['almacen'] = $this->malmacenes->getCampo('nombre', $qOrdenC['id_almacen']);
                //$data['id_almacen'] = $qOrdenC['id_almacen'];
                $data['proveedor'] = $this->mproveedor->getCampo('nombre', $qOrdenC['id_proveedor']);
                $data['importeT'] = $qOrdenC['importe_neto'];
                $data['fraccionamiento'] = '';
                $data['prototipo'] = '';
                $data['rangoLotes'] = '';
                $data['presupuestoViv'] = '';
                $data['presupuestoPaq'] = '';
                $data['costoM2'] = '';
                $data['m2Viv'] = '';
            }
        }

        $this->data['contenido'] = $this->load->view($this->mainView.'/editar_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
    }

    function copy_orden_viv($id){
        $qOrdenC = $this->mordencompra->getById($id);
        if( !is_numeric($qOrdenC) ){
            $qOCviv = $this->mordencompraviv->getByIdMatPaqSemProvFol($qOrdenC['idMaterial'], $qOrdenC['idPaquete'], $qOrdenC['semana'], $qOrdenC['id_proveedor'], $qOrdenC['folio']);
            if( is_numeric($qOCviv) ){
                $oData['idMaterial'] = $qOrdenC['idMaterial'];
                $oData['idPaquete'] = $qOrdenC['idPaquete'];
                $oData['semana'] = $qOrdenC['semana'];
                $oData['descripcion'] = $qOrdenC['descripcion'];
                $oData['fecha'] = $qOrdenC['fecha'];
                $oData['folio'] = $qOrdenC['folio'];
                $oData['id_proveedor'] = $qOrdenC['id_proveedor'];
                $oData['id_almacen'] = $qOrdenC['id_almacen'];
                $oData['importe_neto'] = $qOrdenC['importe_neto'];
                $oData['numero_articulos'] = $qOrdenC['numero_articulos'];
                if( !empty($qOrdenC['fecha_entrega']) && !is_null($qOrdenC['fecha_entrega']) ){
                    $oData['fecha_entrega'] = $qOrdenC['fecha_entrega'];
                }
                $idOCviv = $this->mordencompraviv->insertar($oData);
                if($idOCviv > 0){
                    $qOC = $this->mdetalleorden->getAllByIdOrdenCASC($qOrdenC['id']);
                    if( !is_numeric($qOC) ){
                        foreach($qOC->result() as $row){
                            $qDCviv = $this->mdetalleordenviv->getByIdOrdenCArticulo($idOCviv, $row->id_articulo);
                            $dData['idPresupuestoMat'] = $row->idPresupuestoMat;
                            $dData['semana'] = $row->semana;
                            $dData['id_orden_compra'] = $idOCviv;
                            $dData['clave_articulo'] = $row->clave_articulo;
                            $dData['id_articulo'] = $row->id_articulo;
                            $dData['unidades'] = $row->unidades;
                            $dData['precio_unitario'] = $row->precio_unitario;
                            $dData['descuento_art'] = $row->descuento_art;
                            if( is_numeric($qDCviv) ){
                                $idDOviv = $this->mdetalleordenviv->insertar($dData);
                            }
                            else{
                                $dData['idPresupuestoMat'] = ( empty($row->idPresupuestoMat) )? $qDCviv['idPresupuestoMat'] : $row->idPresupuestoMat;
                                $dData['semana'] = ( empty($row->semana) )? $qDCviv['semana'] : $row->semana;
                                $idDOviv = $this->mdetalleordenviv->actualizar($dData, $qDCviv['id']);
                            }
                        }
                    }
                }
            }
            else{
                $qOC = $this->mdetalleorden->getAllByIdOrdenCASC($qOrdenC['id']);
                if( !is_numeric($qOC) ){
                    foreach($qOC->result() as $row){
                        $qDCviv = $this->mdetalleordenviv->getByIdOrdenCArticulo($qOCviv['id'], $row->id_articulo);
                        $dData['idPresupuestoMat'] = $row->idPresupuestoMat;
                        $dData['semana'] = $row->semana;
                        $dData['id_orden_compra'] = $qOCviv['id'];
                        $dData['clave_articulo'] = $row->clave_articulo;
                        $dData['id_articulo'] = $row->id_articulo;
                        $dData['unidades'] = $row->unidades;
                        $dData['precio_unitario'] = $row->precio_unitario;
                        $dData['descuento_art'] = $row->descuento_art;
                        if( is_numeric($qDCviv) ){
                            $idDOviv = $this->mdetalleordenviv->insertar($dData);
                        }
                        else{
                            $dData['idPresupuestoMat'] = ( empty($row->idPresupuestoMat) )? $qDCviv['idPresupuestoMat'] : $row->idPresupuestoMat;
                            $dData['semana'] = ( empty($row->semana) )? $qDCviv['semana'] : $row->semana;
                            $idDOviv = $this->mdetalleordenviv->actualizar($dData, $qDCviv['id']);
                        }
                    }
                }
                unset($qOrdenC['id']);
                unset($qOrdenC['idEmpresa']);
                unset($qOrdenC['msg']);
                if($this->mordencompraviv->valUpdate($qOCviv['id'],$qOrdenC)){
                    $this->mordencompraviv->actualizar($qOrdenC, $qOCviv['id']);
                }
            }
        }
    }
    
    public function listadoEditar(){
        $idOrdenCompra = $this->input->post('idOrdenCompra');
        $qOrdenC = $this->mordencompra->getById($idOrdenCompra);
        if( !is_numeric($qOrdenC) ){
            $qOCviv = $this->mordencompraviv->getByIdMatPaqSemProvFol($qOrdenC['idMaterial'], $qOrdenC['idPaquete'], $qOrdenC['semana'], $qOrdenC['id_proveedor'], $qOrdenC['folio']);
            $material = $this->mmaterial->getById($qOrdenC['idMaterial']);
            if( !is_numeric($qOCviv) ){
                $qDC = $this->mdetalleorden->getAllByIdOrdenCASC($qOrdenC['id']);
                if( !is_numeric($qDC) ){
                    foreach($qDC->result() as $row){
                        $qDCviv = $this->mdetalleordenviv->getByIdOrdenCArticulo($qOCviv['id'], $row->id_articulo);
                        if( is_numeric($qDCviv) ){
                            $dData['idPresupuestoMat'] = $row->idPresupuestoMat;
                            $dData['semana'] = $row->semana;
                            $dData['id_orden_compra'] = $idOCviv;
                            $dData['clave_articulo'] = $row->clave_articulo;
                            $dData['id_articulo'] = $row->id_articulo;
                            $dData['unidades'] = $row->unidades;
                            $dData['precio_unitario'] = $row->precio_unitario;
                            $dData['descuento_art'] = $row->descuento_art;
                            $idDOviv = $this->mdetalleordenviv->insertar($dData);
                        }
                        else{
                            $idDOviv = $qDCviv['id'];
                        }
                        $inputC = '<input id="unidades_' . $idDOviv . '" type="text" class="form-control input-number" value="' . $row->unidades . '" style="width: 80px;" onchange="actualizar(' . $idDOviv . ', '. "'cantidad'" .')">';
                        $inputP = '<input id="precio_unitario_' . $idDOviv . '" type="text" class="form-control input-number" value="' . $row->precio_unitario . '" style="width: 80px;" onchange="actualizar(' . $idDOviv . ', ' . "'precio'" .')">';
                        $qMateriales = $this->mmateriales->getById2($row->id_articulo,$material["idEmpresa"]);
                        if( !is_numeric($qMateriales) ){
                            $descripcion = $qMateriales['nombre'];
                            $unidad = $qMateriales['unidad_compra'];
                            $idMatActProt = ( empty($row->idPresupuestoMat) )? '' : $this->mpresupuestomat->getCampo('idMateriales', $row->idPresupuestoMat);
                            if( is_numeric($idMatActProt) ){
                                $cantidad = $this->mmaterialesactividadprototipo->getCampo('cantidad', $idMatActProt);
                                $cantidad = ( is_numeric($cantidad) )? $cantidad : 0;
                            }else{
                                $cantidad = 0;
                            }
                        }
                        else{
                            $descripcion = '';
                            $unidad = '';
                            $cantidad = 0;
                        }
                        $array['aaData'][] = array(
                            'id' => $row->id,
                            'clave' => $row->clave_articulo,
                            'descripcion' => $descripcion,
                            'unidad' => $unidad,
                            'cantidadViv' => $cantidad,
                            'cantidadPaq' => $inputC,
                            'precioUnitario' => $inputP,
                            'importe' => '<span id="importe_' . $idDOviv . '">' . precio_format($row->unidades * $row->precio_unitario) . '</span>',
							'acciones' => '<!--<a href="javascript:void(0);" id="accionBorrar-'.$row->id.'" data-id="'.$row->id.'" onclick="accionBorrar($(this));"><i class="fa fa-trash" aria-hidden="true"></i></a>-->',
                            'precioUnitario_' => $row->precio_unitario,
                            'importe_' => $row->unidades * $row->precio_unitario
                        );
                    }
                } else {
                    $array['aaData'][] = array(
                        'id' => 'No hay registros',
                        'clave' => 'No hay registros',
                        'descripcion' => 'No hay registros',
                        'unidad' => 'No hay registros',
                        'cantidadViv' => 'No hay registros',
                        'cantidadPaq' => 'No hay registros',
                        'precioUnitario' => 'No hay registros',
                        'importe' => 'No hay registros',
						'acciones' => 'No hay registros',
                        'precioUnitario_' => 0.00,
                        'importe_' => 0.00
                    );
                }
            } else {
                $array['aaData'][] = array(
                    'id' => 'No hay registros',
                    'clave' => 'No hay registros',
                    'descripcion' => 'No hay registros',
                    'unidad' => 'No hay registros',
                    'cantidadViv' => 'No hay registros',
                    'cantidadPaq' => 'No hay registros',
                    'precioUnitario' => 'No hay registros',
                    'importe' => 'No hay registros',
					'acciones' => 'No hay registros',
                    'precioUnitario_' => 0.00,
                    'importe_' => 0.00
                );
            }
        } else {
            $array['aaData'][] = array(
                'id' => 'No hay registros',
                'clave' => 'No hay registros',
                'descripcion' => 'No hay registros',
                'unidad' => 'No hay registros',
                'cantidadViv' => 'No hay registros',
                'cantidadPaq' => 'No hay registros',
                'precioUnitario' => 'No hay registros',
                'importe' => 'No hay registros',
				'acciones' => 'No hay registros',
                'precioUnitario_' => 0.00,
                'importe_' => 0.00
            );
        }

        echo json_encode($array);
    }

    public function actualizarDetalle(){
        $vacio = true;
        $err = '';
        $errores = false;
        $datitos['valor'] = $_POST['cantidad'];
        $campo = ($_POST['campo'] == 'precio')? 'precio_unitario' : 'unidades';
        // Error por si ponen otra cosa que no sea un numero
        if( !is_numeric($_POST['cantidad']) || !is_numeric($_POST['precio']) ){
            $vacio = true;
            $errores = true;
            $err = '<br/>EL VALOR INGRESADO DEBE SER NUMÉRICO.';
            $anterior = $this->mdetalleordenviv->getCampo($campo, $_POST['id']);
        }
        //Aun no se si lleva un else :V sería para verificar la cantidad [?]
        if($errores){
            // Valores para el modal en caso de un error (no sea numero o no puede agregar mas lotes)
            $datitos['valor'] = 'error';
            $datitos['texto'] = $err;
            $datitos['in'] = $campo;
            $datitos['anterior'] = $anterior;
        }
        else{
            //Si no hay errores, puede continuar con la actualizacion
            $dData['unidades'] = $_POST['cantidad'];
            $dData['precio_unitario'] = $_POST['precio'];
            $this->mdetalleordenviv->actualizar($dData, $_POST['id']);
            $importe = $_POST['cantidad'] * $_POST['precio'];
            $idOCviv = $this->mdetalleordenviv->getCampo('id_orden_compra', $_POST['id']);
            $qPrecioU = $this->mdetalleordenviv->getPrecioUnitarioByIdOrden($idOCviv);
            $qImporte = $this->mdetalleordenviv->getImporteByIdOrden($idOCviv);
            $oData['importe_neto'] = $qImporte;
            $oData['status_ws'] = 0;
            $this->mordencompraviv->actualizar($oData, $idOCviv);

            $datitos['in'] = $campo;
            $datitos['importe'] = $importe;
            $datitos['precioU'] = $qPrecioU;
            $datitos['importeT'] = $qImporte;
            $datitos['valor'] = 'correcto';
            $datitos['texto'] = 'SE HAN GUARDADO LOS CAMBIOS.';
        }
        echo json_encode($datitos);
    }

    public function actualizarAlmacen(){
        $err = '';
        $errores = false;
        $id_almacen = $_POST['idAlmacen'];
        // Error por si ponen otra cosa que no sea un numero
        if( !is_numeric($_POST['idAlmacen']) ){
            $errores = true;
            $err = '<br/>QUITO EL ALMACEN.';
            $id_almacen = NULL;
        }
        $qOrdenC = $this->mordencompra->getById($_POST['idOC']);
        if( !is_numeric($qOrdenC) ){
            $qOCviv = $this->mordencompraviv->getByIdMatPaqSemProvFol($qOrdenC['idMaterial'], $qOrdenC['idPaquete'], $qOrdenC['semana'], $qOrdenC['id_proveedor'], $qOrdenC['folio']);
            if( !is_numeric($qOCviv) ){
                if( $qOCviv['id_almacen'] != $id_almacen){
                    $oData['id_almacen'] = $id_almacen;
                    $this->mordencompraviv->actualizar($oData, $qOCviv['id']);
                    $datitos['valor'] = 'correcto';
                    $datitos['texto'] = 'SE HAN GUARDADO LOS CAMBIOS.';
                    if($errores){
                        $datitos['valor'] = 'nulo';
                        $datitos['texto'] = $err;
                    }
                }
                else{
                    $datitos['valor'] = 'nulo';
                    $datitos['texto'] = 'EL ALMACEN ES EL MISMO';
                }
            }
        }
        else{
            $datitos['valor'] = 'error';
            $datitos['texto'] = 'NO SE PUDO ACTUALIZAR.';
        }
        echo json_encode($datitos);
    }

    public function borrarDetalle(){
        $vacio = true;
        $err = '';
        $errores = false;

        //Si no hay errores, puede continuar con la actualizacion
        $dData['status'] = 0;
        $this->mdetalleordenviv->actualizar($dData, $_POST['idDetalle']);
        $idOCviv = $this->mdetalleordenviv->getCampo('id_orden_compra', $_POST['idDetalle']);
        $noArt = $this->mdetalleordenviv->getAllByIdOrdenC($idOCviv);
        $qPrecioU = $this->mdetalleordenviv->getPrecioUnitarioByIdOrden($idOCviv);
        $qImporte = $this->mdetalleordenviv->getImporteByIdOrden($idOCviv);
        $oData['importe_neto'] = $qImporte;
        $oData['numero_articulos'] = ( !is_numeric($noArt) )? $noArt->num_rows() : 0;
        $this->mordencompraviv->actualizar($oData, $idOCviv);

        $datitos['valor'] = 'correcto';
        $datitos['precioU'] = $qPrecioU;
        $datitos['importeT'] = $qImporte;
        
        echo json_encode($datitos);
    }

    public function addMaterial(){
        $response['status'] = 0;
        $response['count'] = 0;
        $response['rows'] = array();
        $continuar = false;
        $arrayMateriales = $_POST['arrayMateriales'];
        $count = count($arrayMateriales);
        $qOrdenC = $this->mordencompra->getById($_POST['idOC']);
        if( !is_numeric($qOrdenC) ){
            $qOCviv = $this->mordencompraviv->getByIdMatPaqSemProvFol($qOrdenC['idMaterial'], $qOrdenC['idPaquete'], $qOrdenC['semana'], $qOrdenC['id_proveedor'], $qOrdenC['folio']);
            $continuar = ( !is_numeric($qOCviv) )? true : false;
        }
        if( $continuar ){
            foreach ($arrayMateriales as $key => $value) {
                $dData['idPresupuestoMat'] = 0;
                $cant = 0;
                if( !empty($qOCviv['idMaterial']) ){
                    $existPMat = $this->mpresupuestomat->getByIdMatMat2SemProv($qOCviv['idMaterial'], $value['id'], $qOCviv['semana'], $qOCviv['id_proveedor']);
                    if( !is_numeric($existPMat) ){
                        $dData['idPresupuestoMat'] =  $existPMat['id'];
                        $cant = $this->mmaterialesactividadprototipo->getCampo('cantidad', $existPMat['idMateriales']);
                        $cant = ( is_numeric($cant) )? $cant : 0;
                    }
                }
                $existDetalle = $this->mdetalleordenviv->getByIdOrdenCArticulo($qOCviv['id'], $value['id']);
                if( is_numeric($existDetalle) ){
                    $qMateriales = $this->mmateriales->getById2($value['id']);
                    if( !is_numeric($qMateriales) ){
                        $dData['id_orden_compra'] = $qOCviv['id'];
                        $dData['semana'] = $qOCviv['semana'];
                        $dData['clave_articulo'] = $qMateriales['clave'];
                        $dData['id_articulo'] = $value['id'];
                        $dData['unidades'] = ($value['cantidad'] != '')? $value['cantidad'] : 0;
                        $dData['precio_unitario'] = ($value['precioUnitario'] != '')? $value['precioUnitario'] : 0;
                        $dData['precio_unitario'] = round($dData['precio_unitario'], 2);
                        $dData['status'] = 1;
                        $idDetalle = $this->mdetalleordenviv->insertar($dData);

                        $response['count'] = $response['count'] + 1;

                        $cantidad = '<input id="unidades_' . $idDetalle . '" type="text" class="form-control input-number" value="' . $dData['unidades'] . '" style="width: 80px;" onchange="actualizar(' . $idDetalle . ', '. "'cantidad'" .')">';
                        $precio = '<input id="precio_unitario_' . $idDetalle . '" type="text" class="form-control input-number" value="' . $dData['precio_unitario'] . '" style="width: 80px;" onchange="actualizar(' . $idDetalle . ', ' . "'precio'" .')">';
                        $importe = '<span id="importe_' . $idDetalle . '">' . precio_format($dData['unidades'] * $dData['precio_unitario']) . '</span>';

                        $borrar = '<a href="javascript:void(0);" id="accionBorrar-'.$idDetalle.'" data-id="'.$idDetalle.'" onclick="accionBorrar($(this));"><i class="fa fa-trash" aria-hidden="true"></i></a>';

                        $response['rows'][$key] = "<tr>
                                                        <td>".$qMateriales['clave']."</td>
                                                        <td>".$qMateriales['nombre']."</td>
                                                        <td>".$qMateriales['unidad_compra']."</td>
                                                        <td>".$cant."</td>
                                                        <td class='cantidad-$idDetalle'>".$cantidad."</td>
                                                        <td class='precio-$idDetalle'>".$precio."</td>
                                                        <td>".$importe."</td>
                                                        <td>".$borrar."</td>
                                                    </tr>";
                    }
                    unset($dData);
                }
                else{
                    $qMateriales = $this->mmateriales->getById2($value['id']);
                    if( !is_numeric($qMateriales) ){
                        $dData['unidades'] = ($value['cantidad'] != '')? $value['cantidad'] : 0;
                        $dData['precio_unitario'] = ($value['precioUnitario'] != '')? $value['precioUnitario'] : 0;
                        $dData['precio_unitario'] = round($dData['precio_unitario'], 2);
                        $dData['status'] = 1;
                        $this->mdetalleordenviv->actualizar($dData, $existDetalle['id']);

                        $response['count'] = $response['count'] + 1;

                        $cantidad = '<input id="unidades_' . $existDetalle['id'] . '" type="text" class="form-control input-number" value="' . $dData['unidades'] . '" style="width: 80px;" onchange="actualizar(' . $existDetalle['id'] . ', '. "'cantidad'" .')">';
                        $precio = '<input id="precio_unitario_' . $existDetalle['id'] . '" type="text" class="form-control input-number" value="' . $dData['precio_unitario'] . '" style="width: 80px;" onchange="actualizar(' . $existDetalle['id'] . ', ' . "'precio'" .')">';
                        $importe = '<span id="importe_' . $existDetalle['id'] . '">' . precio_format($dData['unidades'] * $dData['precio_unitario']) . '</span>';

                        $borrar = '<a href="javascript:void(0);" id="accionBorrar-'.$existDetalle['id'].'" data-id="'.$existDetalle['id'].'" onclick="accionBorrar($(this));"><i class="fa fa-trash" aria-hidden="true"></i></a>';

                        $response['rows'][$key] = "<tr>
                                                        <td>".$qMateriales['clave']."</td>
                                                        <td>".$qMateriales['nombre']."</td>
                                                        <td>".$qMateriales['unidad_compra']."</td>
                                                        <td>".$cant."</td>
                                                        <td class='cantidad-".$existDetalle['id']."'>".$cantidad."</td>
                                                        <td class='precio-".$existDetalle['id']."'>".$precio."</td>
                                                        <td>".$importe."</td>
                                                        <td>".$borrar."</td>
                                                    </tr>";
                        unset($dData);
                    }
                }
            }
            $noArt = $this->mdetalleordenviv->getAllByIdOrdenC($idOCviv);
            $qPrecioU = $this->mdetalleordenviv->getPrecioUnitarioByIdOrden($qOCviv['id']);
            $qImporte = $this->mdetalleordenviv->getImporteByIdOrden($qOCviv['id']);
            $oData['numero_articulos'] = ( !is_numeric($noArt) )? $noArt->num_rows() : 0;
            $oData['importe_neto'] = $qImporte;
            $this->mordencompraviv->actualizar($oData, $qOCviv['id']);
            $response['precioU'] = $qPrecioU;
            $response['importe'] = $qImporte;
        }

        if($response['count'] == $count){
            $response['status'] = 1;
        }

        echo json_encode($response);
    }

    public function EditCompraMsip($array){
        ini_set('max_execution_time', 300);
        $curl = curl_init();
        //INFORMACION A ENVIAR POR POST EN FORMATO JSON
        $idEmpresa = $_SESSION["viv"]['idEmpresa'];
        $idUsuario = $_SESSION["viv"]['id'];
        $datos=$array;
        $datos = json_encode($datos);
        $time_start = microtime(true);

        curl_setopt_array($curl, array(
            CURLOPT_PORT => $this->config->item('portmicro'),
            CURLOPT_URL => $this->config->item('dnsmicro')."EditCompraMsip",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 60000,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_FOLLOWLOCATION => 1,
            CURLOPT_POSTFIELDS => $datos,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "postman-token: ab5bf890-47c6-d504-ba8f-82667b58bebd",
                'Content-Type:application/json'
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        $res['resultado'] = '';

        $json = [];
        if ($err) {
            $res['error'] = true;
            echo "cURL Error #:" . $err;
            $json = json_encode($json);
            $time_end = microtime(true);
            $time = $time_end - $time_start;
            $dataL['idEmpresa'] = $idEmpresa;
            $dataL['nombreTabla'] = 'orden_compra';
            $dataL['funcion'] = 'EditCompraMsip';
            $dataL['http_code'] = 0;
            $dataL['insertados'] = 0;
            $dataL['actualizados'] = 0;
            $dataL['totalRegistros'] = 0;
            $dataL['json'] = "CURL Error #:" . $err;
            $dataL['created'] = date("Y-m-d H:i:s");
            $dataL['updated'] = date("Y-m-d H:i:s");
            $dataL['created_by'] = $idUsuario;
            $dataL['updated_by'] = $idUsuario;
            $this->db->insert('logs_ws', $dataL);
        }else{
            $res['error'] = false;
            $json = $response;
            // Comprueba el código de estado HTTP
            if (!curl_errno($curl)) {
              switch ($http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE)) {
                case 200:
                    $json = json_decode($json, true);
                    if($json['result']){
                        $res['responseObject'] = true;
                        //$res['resultado'] = intval(preg_replace('/[^0-9]+/', '', $json['error_message']), 10);
                        $res['resultado'] = $json['object_result'];
                        $res['error_message'] = $json['error_message'];
                    }else{
                        $res['responseObject'] = false;
                        $res['error_message'] = $json['error_message'];
                    }
                    $time_end = microtime(true);
                    $time = $time_end - $time_start;
                    $dataL['idEmpresa'] = $idEmpresa;
                    $dataL['nombreTabla'] = 'orden_compra';
                    $dataL['funcion'] = 'EditCompraMsip';
                    $dataL['http_code'] = $http_code;
                    $dataL['insertados'] = 0;
                    $dataL['actualizados'] = ($json['result'])? 1 : 0;
                    $dataL['totalRegistros'] = ($json['result'])? 1 : 0;
                    $json = json_encode($json);
                    $dataL['json'] = $json;
                    $dataL['created'] = date("Y-m-d H:i:s");
                    $dataL['updated'] = date("Y-m-d H:i:s");
                    $dataL['created_by'] = $idUsuario;
                    $dataL['updated_by'] = $idUsuario;
                    $this->db->insert('logs_ws', $dataL);
                    break;
                case 404:
                    echo "Not found";
                    $time_end = microtime(true);
                    $time = $time_end - $time_start;
                    $dataL['idEmpresa'] = $idEmpresa;
                    $dataL['nombreTabla'] = 'orden_compra';
                    $dataL['funcion'] = 'EditCompraMsip';
                    $dataL['http_code'] = $http_code;
                    $dataL['insertados'] = 0;
                    $dataL['actualizados'] = 0;
                    $dataL['totalRegistros'] = 0;
                    $dataL['json'] = $json;
                    $dataL['created'] = date("Y-m-d H:i:s");
                    $dataL['updated'] = date("Y-m-d H:i:s");
                    $dataL['created_by'] = $idUsuario;
                    $dataL['updated_by'] = $idUsuario;
                    $this->db->insert('logs_ws', $dataL);
                    break;
                default:
                    echo 'Unexpected HTTP code: ', $http_code, "\n";
                    $time_end = microtime(true);
                    $time = $time_end - $time_start;
                    $dataL['idEmpresa'] = $idEmpresa;
                    $dataL['nombreTabla'] = 'orden_compra';
                    $dataL['funcion'] = 'EditCompraMsip';
                    $dataL['http_code'] = $http_code;
                    $dataL['insertados'] = 0;
                    $dataL['actualizados'] = 0;
                    $dataL['totalRegistros'] = 0;
                    $dataL['json'] = $json;
                    $dataL['created'] = date("Y-m-d H:i:s");
                    $dataL['updated'] = date("Y-m-d H:i:s");
                    $dataL['created_by'] = $idUsuario;
                    $dataL['updated_by'] = $idUsuario;
                    $this->db->insert('logs_ws', $dataL);
              }
            }
        }
        curl_close($curl);

        return $res;
    }

    public function editCompra()
    {
        $response['status'] = 0;
        $response['msg'] = '';
        $idOrdenCompra = $_POST['idOC'];
        $arrayMateriales = $_POST['arrayMateriales'];
        $qOrdenC = $this->mordencompra->getById($idOrdenCompra);
        if(!is_numeric($qOrdenC)){
            if($qOrdenC['estatus'] == 'PENDIENTE'){
                $qOrdenCViv = $this->mordencompraviv->getByFolio($qOrdenC['id']);
                if(!is_numeric($qOrdenCViv)){
                    $arrayDetalle = array();
                    $fecha = new DateTime($qOrdenC['fecha']);
                    $fecha = $fecha->format("Y-m-d");

                    $fechaEntrega = new DateTime($qOrdenC['fecha_entrega']);
                    $fechaEntrega = $fechaEntrega->format("Y-m-d");

                    $mData['un'] = $qOrdenC['idEmpresa'];
                    $mData['id_orden_compra'] = $qOrdenC['id'];
                    $mData['folio'] = $qOrdenC['folio'];
                    $mData['fecha'] = $fecha;
                    $mData['fecha_entrega'] = $fechaEntrega;
                    $mData['id_proveedor'] = $qOrdenC['id_proveedor'];
                    $mData['id_almacen'] = $qOrdenC['id_almacen'];
                    $mData['descuento'] = 0.00;
                    $mData['descripcion'] = $qOrdenC['descripcion'];
                    $mData['fletes'] = 0.00;
                    $mData['otros_cargos'] = 0.00;
                    $mData['gastos_aduanales'] = 0.00;

                    foreach ($arrayMateriales as $key => $value) {
                        $qDetalleOcViv = $this->mdetalleordenviv->getByIdAndIdOrdenCI($key, $qOrdenCViv['id']);
                        if(!is_numeric($qDetalleOcViv)){
                            $materiales = $this->mmateriales->getById2($qDetalleOcViv['id_articulo']);
                            $pData['id_articulo'] = $qDetalleOcViv['id_articulo'];
                            $pData['unidades'] = $qDetalleOcViv['unidades'];
                            $pData['precio_unitario'] = $qDetalleOcViv['precio_unitario'];
                            $pData['porcentaje_descuento'] = 0.00;
                            $pData['descripcion'] = $materiales['nombre'];
                            array_push($arrayDetalle, $pData);
                        }
                    }

                    $mData['registros'] = $arrayDetalle;

                    if(count($mData) > 0 && count($arrayDetalle) > 0){
                        $response =  $this->EditCompraMsip($mData);
                        if($response['error'] == false){
                            $oData['status_ws'] = 1;
                            $this->mordencompraviv->actualizar($oData, $qOrdenCViv['id']);
                            $response['status'] = 1;
                            $response['msg'] = "DATOS SINCRONIZADOS CORRECTAMENTE AL WS";
                            require('Cronjob.php');
                            $cronjob = new Cronjob();
                            $getOrdenCompraWs = $cronjob->GetOrdenCompra($qOrdenC['idEmpresa'], $qOrdenC['id']);
                        }else{
                            $response['status'] = 0;
                            $response['msg'] = "ERROR EN LA CONEXION DEL WS";
                        }
                    }else{
                        $response['status'] = 0;
                        $response['msg'] = 'NO SE PUDO ENVIAR LA INFORMACIÓN AL WS';
                    }

                }else{
                    $response['status'] = 0;
                    $response['msg'] = 'NO EXISTE LA ORDEN DE COMPRA COPIA';
                }
            }else{
                $response['status'] = 0;
                $response['msg'] = 'LA ORDEN DE COMPRA TIENE QUE ESTAR EN ESTADO PENDIENTE';
            }
        }else{
            $response['status'] = 0;
            $response['msg'] = 'NO EXISTE LA ORDEN DE COMPRA ORIGINAL';
        }

        echo json_encode($response);
    }

    public function syncOrdenCompra(){
        $idEmpresa = $_SESSION["viv"]['idEmpresa'];
        $qOrdenes = $this->mordencompra->getAllByEstatusEmpresa('PENDIENTE', $idEmpresa);
        if( !is_numeric($qOrdenes) ){
            foreach( $qOrdenes->result() as $orden){
                $this->updateWS2($orden->id);
            }
        }
        redirect($this->mainView);
    }
}