<?php
defined('BASEPATH') OR exit('No direct script access allowed');
date_default_timezone_set('America/Mexico_City');
class Notificaciones extends MX_Controller {
    public $data,$vParameters,$mainView,$fv;
    public function __construct(){
            $this->nsession = $this->config->item('nsession');
            $this->fv = 'notificaciones'; // form validation variable
            $this->mainView = 'notificaciones';
            $this->data['fjs'] = '';
            $this->data['js'] = '';
            $this->data['css'] = '';
            //librerias
            $this->load->library("sms");
            // Tools
            $this->load->helper(array('tools','url','form','date','text','security','numeros'));
            // Modelos
            $this->load->model(array('mprospecto','maltaventa','musuario','mproyecto','mfraccionamiento','mfraccionamientoxusuario','mprototipos','mnotaria','mgestoria','mentrega','mpostventa','mactivos','mmantenimientovehiculo','mcartaasignacion','mareastatus','mlugaresprospeccion'));
    }

    public function pruebaSMS(){
        //CONFIGURACIÓN Y ENVIO DE SMS
        $lada="+521";
        $numbers=$lada."9992344748";
        $this->sms->send($numbers,
                            "NUEVO PROSPECTO \n".
                            "Nombre: angel Aviles Dzul\n".
                            "Telefono: 9992344748\n"
                        );
    }

    public function index(){
        $prospectos=$this->mprospecto->getAll();
        $count=0;
        $autores = [];
        foreach($prospectos->result() as $row){
            $dateProspecto=new DateTime($row->fecha);
            $dateRequired=addDaysToDate($dateProspecto->format("d-m-Y"),20);
            $dateNow=new DateTime();
            $validAltaVenta = $this->maltaventa->getByIdProspecto($row->id);
            if( $dateRequired == $dateNow->format("d/m/Y") && is_numeric($validAltaVenta) ) { 
                $count+=1;
                //AQUI AGREGAR EL ENVIO DEL CORREO
                $autores[] = $this->autoRespuesta($row->id);
                $this->db->query("UPDATE prospectos SET idPromotor=0 WHERE id=".$row->id);
            }
        }
        // echo json_encode(array( 'count' => $count));
        // return $count;
        echo $count.'<br><br>';
        echo json_encode($autores);
    }
    
    
    public function validacionProspectosVencimiento() {
        // $prospectos=$this->mprospecto->getAll();
        $listadoProspectos = $this->mprospecto->getAllCron();
        if ( !is_numeric($listadoProspectos) ) {
            echo "<pre>"; print_r($listadoProspectos->result()); echo "</pre>"; exit();
            $arrayFraccionamiento5 = array();
            $arrayFraccionamiento10 = array();
            $arrayFraccionamiento15 = array();
            $arrayFraccionamiento20 = array();
            foreach ($listadoProspectos->result() as $key => $value) {
                $dateProspecto = new DateTime($value->fecha);
                $dateRequired5 = addDaysToDate($dateProspecto->format("d-m-Y"),5);
                $dateRequired10 = addDaysToDate($dateProspecto->format("d-m-Y"),10);
                $dateRequired15 = addDaysToDate($dateProspecto->format("d-m-Y"),15);
                $dateRequired20 = addDaysToDate($dateProspecto->format("d-m-Y"),20);
                
                $validAltaVenta = $this->maltaventa->getByIdProspecto($value->id);
                
                $today = new DateTime();
                
                if ( $today->format("d/m/Y") == $dateRequired5 && is_numeric($validAltaVenta) ) {
                    if ( array_key_exists($value->idFraccionamiento, $arrayFraccionamiento5) ) { array_push($arrayFraccionamiento5[$value->idFraccionamiento], $value->id); }
                    else { $arrayFraccionamiento5[$value->idFraccionamiento] = [$value->id]; }
                }
                if ( $today->format("d/m/Y") == $dateRequired10 && is_numeric($validAltaVenta) ) {
                    if ( array_key_exists($value->idFraccionamiento, $arrayFraccionamiento10) ) { array_push($arrayFraccionamiento10[$value->idFraccionamiento], $value->id); }
                    else { $arrayFraccionamiento10[$value->idFraccionamiento] = [$value->id]; }
                }
                if ( $today->format("d/m/Y") == $dateRequired15 && is_numeric($validAltaVenta) ) {
                    if ( array_key_exists($value->idFraccionamiento, $arrayFraccionamiento15) ) { array_push($arrayFraccionamiento15[$value->idFraccionamiento], $value->id); }
                    else { $arrayFraccionamiento15[$value->idFraccionamiento] = [$value->id]; }
                }
                if ( $today->format("d/m/Y") == $dateRequired20 && is_numeric($validAltaVenta) ) {
                    if ( array_key_exists($value->idFraccionamiento, $arrayFraccionamiento20) ) { array_push($arrayFraccionamiento20[$value->idFraccionamiento], $value->id); }
                    else { $arrayFraccionamiento20[$value->idFraccionamiento] = [$value->id]; }
                    $this->db->query("UPDATE prospectos SET idPromotor=0 WHERE id=".$value->id);
                }
            }
            $response['mail'][] = ( count($arrayFraccionamiento5) > 0 ) ? $this->autoRespuestaProspectosExcedido($arrayFraccionamiento5, 5) : false;
            $response['mail'][] = ( count($arrayFraccionamiento10) > 0 ) ? $this->autoRespuestaProspectosExcedido($arrayFraccionamiento10, 10) : false;
            $response['mail'][] = ( count($arrayFraccionamiento15) > 0 ) ? $this->autoRespuestaProspectosExcedido($arrayFraccionamiento15, 15) : false;
            $response['mail'][] = ( count($arrayFraccionamiento20) > 0 ) ? $this->autoRespuestaProspectosExcedido($arrayFraccionamiento20, 20) : false;
        }
        else {
            $response['mail'] = 0;
        }
        echo json_encode($response);
    }
    
    // Obsoleto
    function autoRespuesta( $idProspecto = null ) {
        // $copias = "ruben@navegantes.mx";
        // $copiasNV = 'sistemas@viviend.mx'. ', ';
        // $copiasNV .= 'ruben@navegantes.mx';
        
        $prospecto = $this->mprospecto->getById($idProspecto);
        // print_r($prospecto); echo "<br><br>"; exit();
        $subject = 'Tiempo sin actividad excedido'; // titulo

        $liga="http://viviend.mx/sistema/emailresources/";
        $liga2="http://viviend.mx/sistema/img/";
        $liga3="http://viviend.mx/sistema/";
        $tp = '';
        
        $data = array();
        
        $promotor = $this->musuario->getById($prospecto['idPromotor']);
        // print_r($promotor); exit();
        $nomPromotor = $promotor["nombre"]." ".$promotor["apellidoP"]." ".$promotor["apellidoM"];
        // print_r($promotor); exit();
        $cuerpo = '<table id="table-notificaciones" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
                        <tbody>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de prospecci&oacute;n: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($prospecto['fecha']), 'd/m/Y').' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Nombre de prospecto: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['nombre'].' '.$prospecto['apellidoP'].' '.$prospecto['apellidoM'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> RFC: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['rfc'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Tel&eacute;fono: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['telefono'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de nacimiento: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($prospecto['fechaNac']), 'd/m/Y').' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Lugar de prospecci&oacute;n: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['lugarProspeccion'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Prototipo: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['prototipo'].' </td>
                            </tr>
                            <!--<tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Nombre promotor: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nomPromotor.' </td>
                            </tr>-->
                        </tbody>
                    </table>
                    <!--<span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
                        Fecha de prospecci&oacute;n: '.$prospecto['fecha'].'
                    </span><br>
                    <span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
                        Nombre de prospecto: '.$prospecto['nombre'].' '.$prospecto['apellidoP'].' '.$prospecto['apellidoM'].'
                    </span><br>
                    <span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
                        RFC: '.$prospecto['rfc'].'
                    </span><br>
                    <span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
                        Telefono: '.$prospecto['telefono'].'
                    </span><br>
                    <span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
                        Fecha de nacimiento: '.$prospecto['fechaNac'].'
                    </span><br>
                    <span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
                        Lugar de prospecci&oacute;n: '.$prospecto['lugarProspeccion'].'
                    </span><br>
                    <span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
                        Prototipo: '.$prospecto['prototipo'].'
                    </span><br>
                    <span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
                        Nombre promotor: '.$nomPromotor.'
                    </span><br>-->';
        
        $mensaje = '
        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
        <html xmlns="http://www.w3.org/1999/xhtml">
        <head>
            <title>Email</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
            <style>
                body, tr, td, span, div, p, a, li {
                    -moz-text-size-adjust:none !important;
                    -webkit-text-size-adjust:none !important;
                    margin:0px !important;
                    -ms-text-size-adjust:none !important;
                    white-space: wrap;
                }
                .lato-light{
                    font-family: "lato" sans-serif !important;
                    font-weight: 300;
                }
                .lato-bold{
                    font-family: "lato" sans-serif !important;
                    font-weight: 700;
                }
                td img {
                    display: block;
                }
                .ReadMsgBody {
                    width: 100%;
                }
                .ExternalClass * {
                    line-height: 100%;
                }
                @media only screen and (max-width:480px) {
                    #logosim{
                        padding:0!important;
                    }
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 320px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
                @media only screen and (min-width:480px) and (max-width:599px) {
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 480px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
            </style>
        </head>
        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
                <tr>
                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
                        <tr>
                            <td>
                                <a href="'.$liga3.'" target="_blank">
                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                                        <tr>
                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
                                                <img src="'.$liga2.'logo-300.png" />
                                            </td>
                                        </tr>
                                    </table>
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
                                    <tr>
                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Prospecto sin actividad </h3>
                                            <h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:16px;margin-top: 10px;"> De '.$nomPromotor.' </h4>
                                            <br><br>
                                            '.$cuerpo.'
                                        </td>
                                    </tr>
                                </table>
                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 100px; margin-top: 75px !important;"></div>
                            </td>
                        </tr>
                    </td>
                </tr>
            </table>
        </body>
        </html>';

        // para el gerente de ventas -------------------------------------------------
        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
        
        // $para = "sistemas@viviend.mx";
        // $gerente = $this->musuario->getByIdLike($promotor["created_by"]);
        // $para = $this->musuario->getCampo("email", $promotor["created_by"]);
        //$para = $this->musuario->getCampo("email", $this->musuario->getGerente2($prospecto['idFraccionamiento']));
        $para = '';
        $qGerentes = $this->musuario->getGerentes2($prospecto['idFraccionamiento']);
        if( !is_numeric($qGerentes) ){
            foreach($qGerentes->result() as $gteV){
                $para = $para.$this->musuario->getCampo("email", $gteV->id).",";
            }
        }
        $para = trim($para, ',');
        $para = ( !is_null($para) && $para != '' ) ? $para : 'sistemas@viviend.mx';
        // else { $para = 'sistemas@viviend.mx'; }
        $response = 'No enviado';
        // Cabeceras adicionales
        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
        if ($para !=null){
            $response = mail($para, $subject, $mensaje, $cabeceras);
        }
        
        // return true;
        return $para.' -> '.$response;
    }
    
    // Obsoleto
    function autoRespuesta2( $idProspecto = null, $days = null ) {
        // $copias = "ruben@navegantes.mx";
        // $copiasNV = 'sistemas@viviend.mx'. ', ';
        // $copiasNV .= 'ruben@navegantes.mx';
        
        $prospecto = $this->mprospecto->getById($idProspecto);
        
        $subject = 'Recordatorio de prospecto'; // titulo

        $liga="http://viviend.mx/sistema/emailresources/";
        $liga2="http://viviend.mx/sistema/img/";
        $liga3="http://viviend.mx/sistema/";
        $tp = '';
        
        $data = array();
        
        $promotor = $this->musuario->getById($prospecto['idPromotor']);
        $nomPromotor = $promotor["nombre"]." ".$promotor["apellidoP"]." ".$promotor["apellidoM"];
        
        $cuerpo = '<table id="table-notificaciones" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
                        <tbody>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Número de días: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$days.' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de prospecci&oacute;n: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($prospecto['fecha']), 'd/m/Y').' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Nombre de prospecto: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['nombre'].' '.$prospecto['apellidoP'].' '.$prospecto['apellidoM'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> RFC: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['rfc'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Tel&eacute;fono: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['telefono'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de nacimiento: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($prospecto['fechaNac']), 'd/m/Y').' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Lugar de prospecci&oacute;n: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['lugarProspeccion'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Prototipo: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['prototipo'].' </td>
                            </tr>
                            <!--<tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Nombre promotor: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nomPromotor.' </td>
                            </tr>-->
                        </tbody>
                    </table>
                    <!--<span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
                        Número de días: '.$days.'
                    </span><br><br><br>
                    <span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
                        Fecha de prospecci&oacute;n: '.$prospecto['fecha'].'
                    </span><br>
                    <span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
                        Nombre de prospecto: '.$prospecto['nombre'].' '.$prospecto['apellidoP'].' '.$prospecto['apellidoM'].'
                    </span><br>
                    <span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
                        RFC: '.$prospecto['rfc'].'
                    </span><br>
                    <span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
                        Telefono: '.$prospecto['telefono'].'
                    </span><br>
                    <span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
                        Fecha de nacimiento: '.$prospecto['fechaNac'].'
                    </span><br>
                    <span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
                        Lugar de prospecci&oacute;n: '.$prospecto['lugarProspeccion'].'
                    </span><br>
                    <span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
                        Prototipo: '.$prospecto['prototipo'].'
                    </span><br>
                    <span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
                        Nombre promotor: '.$nomPromotor.'
                    </span><br>-->';
        
        $mensaje = '
        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
        <html xmlns="http://www.w3.org/1999/xhtml">
        <head>
            <title>Email</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
            <style>
                body, tr, td, span, div, p, a, li {
                    -moz-text-size-adjust:none !important;
                    -webkit-text-size-adjust:none !important;
                    margin:0px !important;
                    -ms-text-size-adjust:none !important;
                    white-space: wrap;
                }
                .lato-light{
                    font-family: "lato" sans-serif !important;
                    font-weight: 300;
                }
                .lato-bold{
                    font-family: "lato" sans-serif !important;
                    font-weight: 700;
                }
                td img {
                    display: block;
                }
                .ReadMsgBody {
                    width: 100%;
                }
                .ExternalClass * {
                    line-height: 100%;
                }
                @media only screen and (max-width:480px) {
                    #logosim{
                        padding:0!important;
                    }
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 320px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
                @media only screen and (min-width:480px) and (max-width:599px) {
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 480px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
            </style>
        </head>
        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
                <tr>
                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
                        <tr>
                            <td>
                                <a href="'.$liga3.'" target="_blank">
                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                                        <tr>
                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
                                                <img src="'.$liga2.'logo-300.png" />
                                            </td>
                                        </tr>
                                    </table>
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
                                    <tr>
                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Prospecto </h3>
                                            <h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:16px;margin-top: 10px;"> De '.$nomPromotor.' </h4>
                                            <br><br>
                                            '.$cuerpo.'
                                        </td>
                                    </tr>
                                </table>
                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 100px; margin-top: 75px !important;"></div>
                            </td>
                        </tr>
                    </td>
                </tr>
            </table>
        </body>
        </html>';

        // para el gerente de ventas -------------------------------------------------
        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
        
        // $para = "sistemas@viviend.mx";
        $para = $this->musuario->getCampo("email", $promotor["created_by"]);
        $response = 'No enviado';
        // Cabeceras adicionales
        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
        if ($para !=null){
            $response = mail($para, $subject, $mensaje, $cabeceras);
        }
        
        // return true;
        return $para.' -> '.$response;
    }
    
    function autoRespuestaProspectosExcedido( $fraccionamientos = null, $dias = null ) {
        /*$copiasNV = 'ruben@navegantes.mx, ';
        $copiasNV .= 'sistemas@viviend.mx';*/

        $copiasNV = 'hsalinas@viviend.mx'. ', ';
        $copiasNV .= 'esalinas@viviend.mx'. ', ';
        $copiasNV .= 'sistemas@viviend.mx';
        
        $subject = 'Notificación de tiempo sin actividad de prospectos ('.$dias.' días) | '.date("d-m-Y"); // titulo
        $cuerpo = '';
        
        $liga="http://viviend.mx/sistema/emailresources/";
        $liga2="http://viviend.mx/sistema/img/";
        $liga3="http://viviend.mx/sistema/";
        $urlLogoFracc = 'http://viviend.mx/sistema/img/logo-300.png';
        
        foreach ($fraccionamientos as $key1 => $value1) {
            $nomFraccionamiento = $this->mfraccionamiento->getCampo('titulo',$key1);
            $cuerpo .= '<h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:18px;margin-bottom: 0px;"> '.$nomFraccionamiento.' </h4>';
            foreach ($value1 as $key2 => $value2) {
                $dProspecto = $this->mprospecto->getById($value2);
                if ( !is_numeric($dProspecto) ) {
                    $promotor = $this->musuario->getById($dProspecto['idPromotor']);
                    $nomPromotor = $promotor["nombre"]." ".$promotor["apellidoP"]." ".$promotor["apellidoM"];
                    $prototipo = $this->mprototipos->getCampo('nombre', $dProspecto['idPrototipo']);
                    
                    $cuerpo .= '
                                <table id="table-prospecto" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;margin-bottom: 30px;">
                                    <tbody>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Tiempo sin actividad: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dias.' Días </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de prospección: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($dProspecto['fecha']), 'd/m/Y').' </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Nombre de prospecto: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['nombre'].' '.$dProspecto['apellidoP'].' '.$dProspecto['apellidoM'].' </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> RFC: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['rfc'].' </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Teléfono: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['telefono'].' </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NSS: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['nss'].' </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de nacimiento: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($dProspecto['fechaNac']), 'd/m/Y').' </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Status prospecto: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['statusProspecto'].' </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Lugar de prospección: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['lugarProspeccion'].' </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Interesado en fraccionamiento: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nomFraccionamiento.' </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Promotor: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nomPromotor.' </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Prototipo: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prototipo.' </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Comentarios: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['comentario'].' </td>
                                        </tr>
                                    </tbody>
                                </table>';
                }
            }
        }
        
        $mensaje = '
        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
        <html xmlns="http://www.w3.org/1999/xhtml">
        <head>
            <title>Email</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
            <style>
                body, tr, td, span, div, p, a, li {
                    -moz-text-size-adjust:none !important;
                    -webkit-text-size-adjust:none !important;
                    margin:0px !important;
                    -ms-text-size-adjust:none !important;
                    white-space: wrap;
                }
                .lato-light{
                    font-family: "lato" sans-serif !important;
                    font-weight: 300;
                }
                .lato-bold{
                    font-family: "lato" sans-serif !important;
                    font-weight: 700;
                }
                td img {
                    display: block;
                }
                .ReadMsgBody {
                    width: 100%;
                }
                .ExternalClass * {
                    line-height: 100%;
                }

                table#table-prospecto td:nth-child(1) {
                    width: 50%;
                    padding-left: 10px;
                }
                table#table-prospecto td:nth-child(2) {
                    width: 50%;
                    padding-left: 10px;
                }

                @media only screen and (max-width:480px) {
                    #logosim{
                        padding:0!important;
                    }
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 320px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
                @media only screen and (min-width:480px) and (max-width:599px) {
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 480px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
            </style>
        </head>
        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
                <tr>
                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
                        <tr>
                            <td>
                                <a href="'.$liga3.'" target="_blank">
                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                                        <tr>
                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
                                                <img width="280" src="'.$urlLogoFracc.'" />
                                            </td>
                                        </tr>
                                    </table>
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
                                    <tr>
                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Prospectos sin actividad </h3>
                                            <br><br>
                                            '.$cuerpo.'
                                        </td>
                                    </tr>
                                </table>
                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
                            </td>
                        </tr>
                    </td>
                </tr>
            </table>
        </body>
        </html>';
        
        
        // para el gerente de ventas -------------------------------------------------
        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
        // Cabeceras adicionales
        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
        
        $gerentes = "";
        $gestores = "";
        $usuarios = $this->musuario->getAll();
        if ( !is_numeric($usuarios) ){
            foreach ($usuarios->result() as $key3 => $value3) {
                if ( $value3->rol == 3 ) { $gestores .= $value3->email.","; }
                if ( $value3->rol == 4 ) { $gerentes .= $value3->email.","; }
            }
            $gestores = trim($gestores, ',');
            $gerentes = trim($gerentes, ',');
        }
        
        if ( $gerentes != "" ) { 
            mail($gerentes, $subject, $mensaje, $cabeceras);
        }
        if ( $gestores != "" ) { 
            mail($gestores, $subject, $mensaje, $cabeceras);
        }
        
        $subject2 = $subject;

        // para el gerente  -------------------------------------------------
        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";
        // Cabeceras adicionales
        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
        
        // para el administrador
        mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);

        return true;
    }
    
    
    /*---------------------------------------------------------------Notificaciones de Alta venta---------------------------------------------------------------*/
    
    public function validacionAltaVenta () {
        $alta_venta = $this->maltaventa->getAllList();
        // print_r($alta_venta->result()); echo "<br><br><br>";
        $count = 0;
        foreach ( $alta_venta->result() as $row ) { 
            $dateAltaVenta  = new DateTime($row->created);
            $dateRequired = addDaysToDate($dateAltaVenta->format("d-m-Y"),20);
            $dateNow = new DateTime();
            // $validAltaVenta = $this->maltaventa->getByIdProspecto($row->id);
            if( $dateRequired == $dateNow->format("d/m/Y") && $row->statusValidacion == 0 ) { 
                echo "id: " . $row->id . "<br>Created: " . $row->created . "<br><br>";
                print_r($row);
                echo "<br><br><br>";
                $count+=1;
                //AQUI AGREGAR EL ENVIO DEL CORREO
                $this->db->query("UPDATE alta_venta SET status=0 WHERE id=".$row->id);
                $this->db->query("UPDATE prospectos SET idPromotor=0 WHERE id=".$row->idProspecto);
                $autores = $this->autoRespuesta3($row->id);
            }
        }
        echo json_encode(array( 'count' => $count));
        // return $count;
    }
    
    
    function autoRespuesta3( $id_alta_venta = null ) {
        // $copias = "ruben@navegantes.mx";
        // $copiasNV = 'sistemas@viviend.mx'. ', ';
        // $copiasNV .= 'ruben@navegantes.mx';
        
        $alta_venta = $this->maltaventa->getById($id_alta_venta);
        echo "Alta venta<br>"; print_r($alta_venta);
        echo "<br><br><br>";
        $prospecto = $this->mprospecto->getById($alta_venta['idProspecto']);
        echo "Prospecto<br>"; print_r($prospecto);
        echo "<br><br><br>";
        $promotor = $this->musuario->getById($alta_venta['idProspecto']);
        echo "Promotor<br>"; print_r($promotor);
        echo "<br><br><br>";
        $proyecto = $this->mproyecto->getById($alta_venta['idProyecto']);
        echo "Proyecto<br>"; print_r($proyecto);
        exit();
        $subject = 'Viviend - Nuevo prospecto de vivienda'; // titulo

        $liga="http://navegantes.mx/web/viviend/emailresources/";
        $liga2="http://navegantes.mx/web/viviend/img/";
        $liga3="http://navegantes.mx/web/viviend/";
        $tp = '';
        
        $data = array();
        
        // $promotor = $this->musuario->getById($prospecto['idPromotor']);
        $nomPromotor = $promotor["nombre"]." ".$promotor["apellidoP"]." ".$promotor["apellidoM"];
        
        $cuerpo = '<table id="table-clientes" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;">
                        <thead>
                            <tr>
                                <th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">Cliente</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Nombre: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['nombre'].' '.$prospecto['apellidoP'].' '.$prospecto['apellidoM'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de prospecci&oacute;n: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($prospecto['fecha']), 'd/m/Y').' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> RFC: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['rfc'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Teléfono: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['telefono'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NSS: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['nss'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de nacimiento: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($prospecto['fechaNac']), 'd/m/Y').' </td>
                            </tr>
                        </tbody>
                    </table>';
        /*--------------------------------------------------------------------------------------------------------------------------------*/
        $cuerpo .= '<table id="table-clientes" style="width: 80%;margin: 50px auto;border: 3px solid #EAC633;border-spacing: 0px;">
                        <thead>
                            <tr>
                                <th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">Datos de venta</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Estatus: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['statusProspecto'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Promotor: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nomPromotor.' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Lote: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$proyecto['lote'].' MZ:'.$proyecto['manzana'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Monto de crédito: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$alta_venta['monto'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Sub cuenta: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$alta_venta['subCuenta'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Gastos de operación: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$alta_venta['gastosOperacion'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Total: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$alta_venta['total'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de preca: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($alta_venta['fechaPreca']), 'd/m/Y').' </td>
                            </tr>
                        </tbody>
                    </table>';
        /*--------------------------------------------------------------------------------------------------------------------------------*/
        
        $mensaje = '
        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
        <html xmlns="http://www.w3.org/1999/xhtml">
        <head>
            <title>Email</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
            <style>
                body, tr, td, span, div, p, a, li {
                    -moz-text-size-adjust:none !important;
                    -webkit-text-size-adjust:none !important;
                    margin:0px !important;
                    -ms-text-size-adjust:none !important;
                    white-space: wrap;
                }
                .lato-light{
                    font-family: "lato" sans-serif !important;
                    font-weight: 300;
                }
                .lato-bold{
                    font-family: "lato" sans-serif !important;
                    font-weight: 700;
                }
                td img {
                    display: block;
                }
                .ReadMsgBody {
                    width: 100%;
                }
                .ExternalClass * {
                    line-height: 100%;
                }
                @media only screen and (max-width:480px) {
                    #logosim{
                        padding:0!important;
                    }
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 320px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
                @media only screen and (min-width:480px) and (max-width:599px) {
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 480px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
            </style>
        </head>
        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
                <tr>
                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
                        <tr>
                            <td>
                                <a href="'.$liga3.'" target="_blank">
                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                                        <tr>
                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
                                                <img src="'.$liga2.'logo-300.png" />
                                            </td>
                                        </tr>
                                    </table>
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
                                    <tr>
                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
                                            <!--<h1 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;"> Nuevo prospecto </h1>-->
                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Nuevo prospecto </h3>
                                            <h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:16px;margin-top: 10px;"> De '.$nomPromotor.' </h4>
                                            <br><br>
                                            '.$cuerpo.'
                                        </td>
                                    </tr>
                                </table>
                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 100px; margin-top: 75px !important;"></div>
                            </td>
                        </tr>
                    </td>
                </tr>
            </table>
        </body>
        </html>';

        // para el gerente de ventas -------------------------------------------------
        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
        
        // $para = "sistemas@viviend.mx";
        $para = $this->musuario->getCampo("email", $promotor["created_by"]);
        
        // Cabeceras adicionales
        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
        if ($para !=null){
            mail($para, $subject, $mensaje, $cabeceras);
        }
        
        return true;
    }
    
    // Notificación de propuestos por día
    public function validacionProspectos()
    {
        $listadoProspectos = $this->mprospecto->getAllCron();
        if ( !is_numeric($listadoProspectos) ) {
            $arrayFraccionamiento = array();
            foreach ($listadoProspectos->result() as $key => $value) {
                $created = new DateTime($value->created);
                $today = new DateTime();
                
                if ( $today->format("d-m-Y") == $created->format("d-m-Y") ) {
                    if ( array_key_exists($value->idFraccionamiento, $arrayFraccionamiento) ) { array_push($arrayFraccionamiento[$value->idFraccionamiento], $value->id); }
                    else { $arrayFraccionamiento[$value->idFraccionamiento] = [$value->id]; }
                }
            }
            $response['mail'] = (count($arrayFraccionamiento)>0)?$this->autoRespuestaProspectos($arrayFraccionamiento):true;//$this->autoRespuestaProspectos($arrayFraccionamiento);
        }
        else {
            $response['mail'] = 0;
        }
        echo json_encode($response);
    }
    
    function autoRespuestaProspectos( $fraccionamientos = null ) {
        /*$copiasNV = 'ruben@navegantes.mx, ';
        $copiasNV .= 'sistemas@viviend.mx';*/

        $copiasNV = 'hsalinas@viviend.mx'. ', ';
        $copiasNV .= 'esalinas@viviend.mx'. ', ';
        $copiasNV .= 'mejora@viviend.mx'. ', ';
        $copiasNV .= 'sistemas@viviend.mx';
        
        $subject = 'Notificación de prospectos de vivienda | '.date("d-m-Y"); // titulo
        $cuerpo = '';
        
        $liga="http://viviend.mx/sistema/emailresources/";
        $liga2="http://viviend.mx/sistema/img/";
        $liga3="http://viviend.mx/sistema/";
        
        $urlLogoFracc = 'http://viviend.mx/sistema/img/logo-300.png';
        
        foreach ($fraccionamientos as $key1 => $value1) {
            $nomFraccionamiento = $this->mfraccionamiento->getCampo('titulo',$key1);
            $cuerpo .= '<h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:18px;margin-bottom: 0px;"> '.$nomFraccionamiento.' </h4>';
            foreach ($value1 as $key2 => $value2) {
                $dProspecto = $this->mprospecto->getById($value2);
                if ( !is_numeric($dProspecto) ) {
                    $promotor = $this->musuario->getById($dProspecto['idPromotor']);
                    $nomPromotor = $promotor["nombre"]." ".$promotor["apellidoP"]." ".$promotor["apellidoM"];
                    $prototipo = $this->mprototipos->getCampo('nombre', $dProspecto['idPrototipo']);
                    $lugarProspeccion = ($dProspecto['idLugar']>0)?$this->mlugaresprospeccion->getCampo('titulo',$dProspecto['idLugar']):'';
                    
                    $cuerpo .= '
                                <table id="table-prospecto" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;margin-bottom: 30px;">
                                    <tbody>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de prospección: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($dProspecto['fecha']), 'd/m/Y').' </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Nombre de prospecto: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['nombre'].' '.$dProspecto['apellidoP'].' '.$dProspecto['apellidoM'].' </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> RFC: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['rfc'].' </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Teléfono: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['telefono'].' </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NSS: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['nss'].' </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de nacimiento: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($dProspecto['fechaNac']), 'd/m/Y').' </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Status prospecto: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['statusProspecto'].' </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Lugar de prospección: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$lugarProspeccion.' </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Interesado en fraccionamiento: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nomFraccionamiento.' </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Promotor: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nomPromotor.' </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Prototipo: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prototipo.' </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Comentarios: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['comentario'].' </td>
                                        </tr>
                                    </tbody>
                                </table>';
                }
            }
        }
        
        $mensaje = '
        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
        <html xmlns="http://www.w3.org/1999/xhtml">
        <head>
            <title>Email</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
            <style>
                body, tr, td, span, div, p, a, li {
                    -moz-text-size-adjust:none !important;
                    -webkit-text-size-adjust:none !important;
                    margin:0px !important;
                    -ms-text-size-adjust:none !important;
                    white-space: wrap;
                }
                .lato-light{
                    font-family: "lato" sans-serif !important;
                    font-weight: 300;
                }
                .lato-bold{
                    font-family: "lato" sans-serif !important;
                    font-weight: 700;
                }
                td img {
                    display: block;
                }
                .ReadMsgBody {
                    width: 100%;
                }
                .ExternalClass * {
                    line-height: 100%;
                }

                table#table-prospecto td:nth-child(1) {
                    width: 50%;
                    padding-left: 10px;
                }
                table#table-prospecto td:nth-child(2) {
                    width: 50%;
                    padding-left: 10px;
                }

                @media only screen and (max-width:480px) {
                    #logosim{
                        padding:0!important;
                    }
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 320px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
                @media only screen and (min-width:480px) and (max-width:599px) {
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 480px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
            </style>
        </head>
        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
                <tr>
                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
                        <tr>
                            <td>
                                <a href="'.$liga3.'" target="_blank">
                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                                        <tr>
                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
                                                <img width="280" src="'.$urlLogoFracc.'" />
                                            </td>
                                        </tr>
                                    </table>
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
                                    <tr>
                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Nuevos prospectos </h3>
                                            <br><br>
                                            '.$cuerpo.'
                                        </td>
                                    </tr>
                                </table>
                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
                            </td>
                        </tr>
                    </td>
                </tr>
            </table>
        </body>
        </html>';
        
        
        // para el gerente de ventas -------------------------------------------------
        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
        // Cabeceras adicionales
        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
        
        $gerentes = "";
        $gestores = "";
        $usuarios = $this->musuario->getAll();
        if ( !is_numeric($usuarios) ){
            foreach ($usuarios->result() as $key3 => $value3) {
                if ( $value3->rol == 3 ) { $gestores .= $value3->email.","; }
                if ( $value3->rol == 4 ) { $gerentes .= $value3->email.","; }
            }
            $gestores = trim($gestores, ',');
            $gerentes = trim($gerentes, ',');
        }
        
        if ( $gerentes != "" ) { 
            mail($gerentes, $subject, $mensaje, $cabeceras);
        }
        if ( $gestores != "" ) { 
            mail($gestores, $subject, $mensaje, $cabeceras);
        }
        
        $subject2 = $subject;

        // para el gerente  -------------------------------------------------
        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";
        // Cabeceras adicionales
        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
        
        // para el administrador
        mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);

        return true;
    }
    
    // Notificación de altas de venta por día
    public function validacionNuevasAltaVenta()
    {
        $listadoAltaVenta = $this->maltaventa->getAllListJoinProspectos();
        if ( !is_numeric($listadoAltaVenta) ) {
            $arrayFraccionamiento = array();
            foreach ($listadoAltaVenta->result() as $key => $value) {
                $created = new DateTime($value->created);
                $today = new DateTime();
                if ( $today->format("d-m-Y") == $created->format("d-m-Y") ) {
                    if ( array_key_exists($value->idFraccionamiento, $arrayFraccionamiento) ) { 
                        $dAltaVenta = array(
                            "idAltaVenta" => $value->id,
                            "idProyecto" => $value->idProyecto,
                            "idProspecto" => $value->idProspecto,
                            "idPromotor" => $value->idPromotor,
                            "idFraccionamiento" => $value->idFraccionamiento,
                            "total" => $value->total
                        );
                        array_push($arrayFraccionamiento[$value->idFraccionamiento], $dAltaVenta); 
                    }
                    else { 
                        $dAltaVenta = array(
                            "idAltaVenta" => $value->id,
                            "idProyecto" => $value->idProyecto,
                            "idProspecto" => $value->idProspecto,
                            "idPromotor" => $value->idPromotor,
                            "idFraccionamiento" => $value->idFraccionamiento,
                            "total" => $value->total
                        );
                        $arrayFraccionamiento[$value->idFraccionamiento] = [$dAltaVenta]; 
                    }
                }
            }

            $response['mail'] = (count($arrayFraccionamiento)>0)?$this->autoRespuestaAltaVenta($arrayFraccionamiento):true;

        }
        else {
            $response['mail'] = 0;
        }
        echo json_encode($response);
    }
    
    function autoRespuestaAltaVenta( $fraccionamientos = null ) {
        /*$copiasNV = 'sistemas@viviend.mx,';
        $copiasNV .= 'ruben@navegantes.mx';*/

        $copiasNV = 'hsalinas@viviend.mx'. ', ';
        $copiasNV .= 'esalinas@viviend.mx'. ', ';
        $copiasNV .= 'mejora@viviend.mx'. ', ';
        $copiasNV .= 'sistemas@viviend.mx';
        
        $subject = 'Notificación de nuevas altas de venta | '.date("d-m-Y"); // titulo
        $cuerpo = '';
        
        $liga="http://viviend.mx/sistema/emailresources/";
        $liga2="http://viviend.mx/sistema/img/";
        $liga3="http://viviend.mx/sistema/";
        
        $urlLogoFracc = 'http://viviend.mx/sistema/img/logo-300.png';
        
        foreach ($fraccionamientos as $key1 => $value1) {
            $nomFraccionamiento = $this->mfraccionamiento->getCampo('titulo',$key1);
            $cuerpo .= '<h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:18px;margin-bottom: 0px;"> '.$nomFraccionamiento.' </h4>';
            foreach ($value1 as $key2 => $value2) {
                $prospecto = $this->mprospecto->getById($value2['idProspecto']);
                //$proyecto = $this->mproyecto->getById($value2['idProyecto']);
                $fraccionamiento = $this->mfraccionamiento->getById($value2['idFraccionamiento']);
                $promotor = $this->musuario->getById($value2['idPromotor']);
                $nomPromotor = $promotor["nombre"]." ".$promotor["apellidoP"]." ".$promotor["apellidoM"];
                
                $cuerpo .= '
                            <table id="table-alta-venta" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;margin-bottom:30px !important;">
                                <tbody>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de prospecci&oacute;n: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($prospecto['fecha']), 'd/m/Y').' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Nombre prospecto: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['nombre'].' '.$prospecto['apellidoP'].' '.$prospecto['apellidoM'].' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> RFC: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['rfc'].' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Tel&eacute;fono: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['telefono'].' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de nacimiento: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($prospecto['fechaNac']), 'd/m/Y').' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Nombre promotor: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nomPromotor.' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fraccionamiento: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$fraccionamiento['titulo'].' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Estado: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$fraccionamiento['estado'].' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Municipio: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$fraccionamiento['municipio'].' </td>
                                    </tr>

                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Precio venta: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($value2['total']).' </td>
                                    </tr>
                                </tbody>
                            </table>';
            }
        }
        
        $mensaje = '
        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
        <html xmlns="http://www.w3.org/1999/xhtml">
        <head>
            <title>Email</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
            <style>
                body, tr, td, span, div, p, a, li {
                    -moz-text-size-adjust:none !important;
                    -webkit-text-size-adjust:none !important;
                    margin:0px !important;
                    -ms-text-size-adjust:none !important;
                    white-space: wrap;
                }
                .lato-light{
                    font-family: "lato" sans-serif !important;
                    font-weight: 300;
                }
                .lato-bold{
                    font-family: "lato" sans-serif !important;
                    font-weight: 700;
                }
                td img {
                    display: block;
                }
                .ReadMsgBody {
                    width: 100%;
                }
                .ExternalClass * {
                    line-height: 100%;
                }
                @media only screen and (max-width:480px) {
                    #logosim{
                        padding:0!important;
                    }
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 320px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
                @media only screen and (min-width:480px) and (max-width:599px) {
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 480px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
            </style>
        </head>
        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
                <tr>
                    <td align="center" valign="top" bgcolor="#FFFFFE">
                        <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
                            <tr>
                                <td>
                                    <a href="'.$liga3.'" target="_blank">
                                        <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                                            <tr>
                                                <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
                                                    <img width="280" src="'.$urlLogoFracc.'" />
                                                </td>
                                            </tr>
                                        </table>
                                    </a>
                                </td>
                            </tr>
                            <tr>
                                <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
                                    <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
                                        <tr>
                                            <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center">
                                                <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Nuevas altas de venta </h3>
                                                <br><br>
                                                '.$cuerpo.'
                                            </td>
                                        </tr>
                                    </table>
                                    <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </body>
        </html>';
        
        
        // para el gerente de ventas -------------------------------------------------
        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
        // Cabeceras adicionales
        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
        
        $gerentes = "";
        $gestores = "";
        $usuarios = $this->musuario->getAll();
        if ( !is_numeric($usuarios) ){
            foreach ($usuarios->result() as $key3 => $value3) {
                if ( $value3->rol == 3 ) { $gestores .= $value3->email.","; }
                if ( $value3->rol == 4 ) { $gerentes .= $value3->email.","; }
            }
            $gestores = trim($gestores, ',');
            $gerentes = trim($gerentes, ',');
        }
        
        if ( $gerentes != "" ) { 
            mail($gerentes, $subject, $mensaje, $cabeceras);
        }
        if ( $gestores != "" ) { 
            mail($gestores, $subject, $mensaje, $cabeceras);
        }
        
        $subject2 = $subject;
        
        // para el Administrador  -------------------------------------------------
        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";
        // Cabeceras adicionales
        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
        
        // para el administrador
        mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);
        
        return true;
    }
    
    // Notificación de validación de venta por día
    public function validacionesVenta()
    {
        $listadoValidacionVenta = $this->maltaventa->getAllJoinCron();
        if ( !is_numeric($listadoValidacionVenta) ) {
            $arrayFraccionamiento = array();
            foreach ($listadoValidacionVenta->result() as $key => $value) {
                // echo "<pre>"; print_r($value); echo "</pre>";
                $created = new DateTime($value->created);
                $today = new DateTime();
                if ( $today->format("d-m-Y") == $created->format("d-m-Y") ) {
                    if ( array_key_exists($value->idFraccionamiento, $arrayFraccionamiento) ) { 
                        $dValidacionVenta = array(
                            "idAltaVenta" => $value->idAltaVenta,
                            "idProspecto" => $value->idProspecto,
                            "idFraccionamiento" => $value->idFraccionamiento,
                            "idProyecto" => $value->idProyecto,
                            "idPromotor" => $value->idPromotor
                        );
                        array_push($arrayFraccionamiento[$value->idFraccionamiento], $dValidacionVenta); 
                    }
                    else { 
                        $dValidacionVenta = array(
                            "idAltaVenta" => $value->idAltaVenta,
                            "idProspecto" => $value->idProspecto,
                            "idFraccionamiento" => $value->idFraccionamiento,
                            "idProyecto" => $value->idProyecto,
                            "idPromotor" => $value->idPromotor
                        );
                        $arrayFraccionamiento[$value->idFraccionamiento] = [$dValidacionVenta]; 
                    }
                }
            }
            // echo "<pre>"; print_r($arrayFraccionamiento); echo "</pre>"; exit();
            $response['mail'] = (count($arrayFraccionamiento)>0)?$this->autoRespuestaValidacionVenta($arrayFraccionamiento):true;
        }
        else {
            $response['mail'] = 0;
        }
        echo json_encode($response);
    }
    
    function autoRespuestaValidacionVenta( $fraccionamientos = null ) {
        /*$copiasNV = 'sistemas@viviend.mx,';
        $copiasNV .= 'ruben@navegantes.mx';*/

        $copiasNV = 'hsalinas@viviend.mx'. ', ';
        $copiasNV .= 'esalinas@viviend.mx'. ', ';
        $copiasNV .= 'mejora@viviend.mx'. ', ';
        $copiasNV .= 'sistemas@viviend.mx';
        
        $subject = 'Notificacion de Validación de venta | '.date('d-m-Y'); // titulo
        $cuerpo = '';
        
        $liga="http://viviend.mx/sistema/emailresources/";
        $liga2="http://viviend.mx/sistema/img/";
        $liga3="http://viviend.mx/sistema/";
        $urlLogoFracc = 'http://viviend.mx/sistema/img/logo-300.png';
        
        foreach ($fraccionamientos as $key1 => $value1) {
            $nomFraccionamiento = $this->mfraccionamiento->getCampo('titulo',$key1);
            $cuerpo .= '<h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:18px;margin-bottom: 0px;"> '.$nomFraccionamiento.' </h4>';
            foreach ($value1 as $key2 => $value2) {
                $altaventa = $this->maltaventa->getById($value2['idAltaVenta']);
                $prospecto = $this->mprospecto->getById($value2['idProspecto']);
                $proyecto = $this->mproyecto->getById($value2['idProyecto']);
                $fraccionamiento = $this->mfraccionamiento->getById($value2['idFraccionamiento']);
                $promotor = $this->musuario->getById($value2['idPromotor']);
                $nomPromotor = $promotor["nombre"]." ".$promotor["apellidoP"]." ".$promotor["apellidoM"];
                
                $cuerpo .= '<table id="table-validacion-venta" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;margin-bottom:30px;">
                                <tbody>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de prospecci&oacute;n: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($prospecto['fecha']), 'd/m/Y').' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Nombre de prospecto: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['nombre'].' '.$prospecto['apellidoP'].' '.$prospecto['apellidoM'].' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> RFC: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['rfc'].' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Tel&eacute;fono: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['telefono'].' </td>
                                    </tr>
                                    <!--<tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Nombre promotor: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nomPromotor.' </td>
                                    </tr>-->
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fraccionamiento: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$fraccionamiento['titulo'].' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Estado: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$fraccionamiento['estado'].' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Municipio: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$fraccionamiento['municipio'].' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Lote: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$proyecto['lote'].' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Manzana: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$proyecto['manzana'].' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Calle: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$proyecto['calle'].' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> N&uacute;mero oficial: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$proyecto['nOficial'].' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Clave catastral: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$proyecto['claveCatastral'].' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Superficie de terreno: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$proyecto['supTerreno'].' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Superficie de construcci&oacute;n: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$proyecto['supConstruccion'].' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Precio de venta: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($proyecto['precioVenta']).' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Revisión de montos: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$altaventa['revisionMontos'].' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Tipo de crédito: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$altaventa['tipoCredito'].' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Diferencia: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($altaventa['diferencia']).' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Bono de equipamiento: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($altaventa['bonoEquipamiento']).' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Id Notaría: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$altaventa['idNotaria'].' </td>
                                    </tr>
                                </tbody>
                            </table>';
            }
        }
        
        $mensaje = '
        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
        <html xmlns="http://www.w3.org/1999/xhtml">
        <head>
            <title>Email</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
            <style>
                body, tr, td, span, div, p, a, li {
                    -moz-text-size-adjust:none !important;
                    -webkit-text-size-adjust:none !important;
                    margin:0px !important;
                    -ms-text-size-adjust:none !important;
                    white-space: wrap;
                }
                .lato-light{
                    font-family: "lato" sans-serif !important;
                    font-weight: 300;
                }
                .lato-bold{
                    font-family: "lato" sans-serif !important;
                    font-weight: 700;
                }
                td img {
                    display: block;
                }
                .ReadMsgBody {
                    width: 100%;
                }
                .ExternalClass * {
                    line-height: 100%;
                }
                @media only screen and (max-width:480px) {
                    #logosim{
                        padding:0!important;
                    }
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 320px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
                @media only screen and (min-width:480px) and (max-width:599px) {
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 480px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
            </style>
        </head>
        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
                <tr>
                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
                        <tr>
                            <td>
                                <a href="'.$liga3.'" target="_blank">
                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                                        <tr>
                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
                                                <img width="280" src="'.$urlLogoFracc.'" />
                                            </td>
                                        </tr>
                                    </table>
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
                                    <tr>
                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
                                            <!--<h1 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;"> Validación de venta </h1>-->
                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Validación de venta </h3>
                                            <br><br>
                                            '.$cuerpo.'
                                        </td>
                                    </tr>
                                    
                                </table>
                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
                            </td>
                        </tr>
                    </td>
                </tr>
            </table>
        </body>
        </html>';
        // echo $mensaje;
        // para el gerente de ventas -------------------------------------------------
        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
        // Cabeceras adicionales
        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
        
        
        $gestores = "";
        $usuarios = $this->musuario->getAll();
        if ( !is_numeric($usuarios) ){
            foreach ($usuarios->result() as $key3 => $value3) {
                if ( $value3->rol == 3 ) { $gestores .= $value3->email.","; }
            }
            $gestores = trim($gestores, ',');
        }
        
        if ( $gestores != "" ) { 
            mail($gestores, $subject, $mensaje, $cabeceras);
        }
        
        $subject2 = $subject;
        
        // para el gerente  -------------------------------------------------
        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";
        // Cabeceras adicionales
        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
        
        // para el administrador
        mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);
        
        return true;
    }
    
    // Notificación de gestoria por día
    public function validacionGestoria()
    {
        $listadoGestoria = $this->maltaventa->getJoinGestoria();
        if ( !is_numeric($listadoGestoria) ) {
            $arrayFraccionamiento = array();
            foreach ($listadoGestoria->result() as $key => $value) {
                // echo "<pre>"; print_r($value); echo "</pre>";
                $fechaVenta = new DateTime($value->fechaVenta);
                $today = new DateTime();
                if ( $today->format("d-m-Y") == $fechaVenta->format("d-m-Y") && $value->pdf_8!='' ) {
                    if ( array_key_exists($value->idFraccionamiento, $arrayFraccionamiento) ) { 
                        $dValidacionVenta = array(
                            "idAltaVenta" => $value->idAltaVenta,
                            "idProspecto" => $value->idProspecto,
                            "idFraccionamiento" => $value->idFraccionamiento,
                            "idProyecto" => $value->idProyecto,
                            "idPromotor" => $value->idPromotor,
                            "idGestoria" => $value->idGestoria
                        );
                        array_push($arrayFraccionamiento[$value->idFraccionamiento], $dValidacionVenta); 
                    }
                    else { 
                        $dValidacionVenta = array(
                            "idAltaVenta" => $value->idAltaVenta,
                            "idProspecto" => $value->idProspecto,
                            "idFraccionamiento" => $value->idFraccionamiento,
                            "idProyecto" => $value->idProyecto,
                            "idPromotor" => $value->idPromotor,
                            "idGestoria" => $value->idGestoria
                        );
                        $arrayFraccionamiento[$value->idFraccionamiento] = [$dValidacionVenta]; 
                    }
                }
            }
            // echo "<pre>"; print_r($arrayFraccionamiento); echo "</pre>";
            $response['mail'] = (count($arrayFraccionamiento)>0)?$this->autoRespuestaGestoria($arrayFraccionamiento):true;
        }
        else {
            $response['mail'] = 0;
        }
        echo json_encode($response);
    }
    
    function autoRespuestaGestoria( $fraccionamientos = null ) {
        /*$copiasNV = 'sistemas@viviend.mx, ';
        $copiasNV .= 'ruben@navegantes.mx';*/

        $copiasNV = 'hsalinas@viviend.mx'. ', ';
        $copiasNV .= 'esalinas@viviend.mx'. ', ';
        $copiasNV .= 'mejora@viviend.mx'. ', ';
        $copiasNV .= 'sistemas@viviend.mx';
        
        $subject = 'Notificación sobre ingreso de expediente | Gestoria'; // titulo
        $cuerpo = '';

        $liga="http://viviend.mx/sistema/emailresources/";
        $liga2="http://viviend.mx/sistema/img/";
        $liga3="http://viviend.mx/sistema/";
        $urlLogoFracc = 'http://viviend.mx/sistema/img/logo-300.png';
        
        
        foreach ($fraccionamientos as $key1 => $value1) {
            $nomFraccionamiento = $this->mfraccionamiento->getCampo('titulo',$key1);
            $cuerpo .= '<h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:18px;margin-bottom: 0px;"> '.$nomFraccionamiento.' </h4>';
            foreach ($value1 as $key2 => $value2) {
                $alta_venta = $this->maltaventa->getById($value2['idAltaVenta']);
                $gestoria = $this->mgestoria->getById($value2['idGestoria']);
                $prospecto = $this->mprospecto->getById($value2['idProspecto']);
                $proyecto = $this->mproyecto->getById($value2['idProyecto']);
                $promotor = $this->musuario->getById($this->maltaventa->getCampo("created_by",$value2['idAltaVenta']));
                
                //$gerente = $this->musuario->getById($this->musuario->getGerente2($proyecto['idFraccionamiento']));
                $qGerentes = $this->musuario->getGerentes2($proyecto['idFraccionamiento']);
                $gerente = '';
                if( !is_numeric($qGerentes) ){
                    foreach($qGerentes->result() as $gteV){
                        $qGerente = $this->musuario->getById($gteV->id);
                        if( !is_numeric($qGerente) ){
                            $gerente = $gerente.$qGerente['nombre'].' '.$qGerente['apellidoP'].' '.$qGerente['apellidoM'].', ';
                        }
                    }
                }
                if( !empty($gerente) ){
                    $gerente = substr($gerente, 0, -2);
                }
                $notaria = $this->mnotaria->getById($alta_venta['idNotaria']);
                // $gestor = $this->musuario->getById($_SESSION[$this->nsession]['rol']);
                
                /*-------------------------------------------------CLIENTE-------------------------------------------------------------------*/
                $cuerpo .= '
                    <table id="table-cliente" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
                        <thead>
                            <tr>
                                <th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">Datos Cliente</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Nombre:</td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$prospecto['nombre'].' '.$prospecto['apellidoP'].' '.$prospecto['apellidoM'].'</td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Lote:</td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$proyecto['lote'].'</td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;"># Paquete:</td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$proyecto['numPaquete'].'</td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Precio Venta:</td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.precio_format($proyecto['precioVenta']).'</td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Avaluo:</td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.precio_format($proyecto['avaluo']).'</td>
                            </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Nombre Promotor:</td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$promotor['nombre'].' '.$promotor['apellidoP'].' '.$promotor['apellidoM'].'</td>
                    </tr>
                        <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Nombre Gerente:</td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gerente.'</td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Estatus:</td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['statusGestoria'].'</td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Tipo Credito:</td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$alta_venta['tipoCredito'].'</td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Aplica folio:</td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['aplicaFolio'].'</td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Número de folio:</td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['numeroFolio'].'</td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Número de crédito:</td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['numeroCredito'].'</td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Certificado de libertad:</td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['certificadoLibertad'].'</td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Constancia de no adeudo:</td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['constanciaNoAdeudo'].'</td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Notaría:</td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$notaria['nombre'].'</td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Fecha firma:</td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.date_format(new DateTime($gestoria['fechaFirma']), 'd/m/Y').'</td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Precio venta OCI:</td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['precioVentaOci'].'</td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Monto OCI:</td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['montoOci'].'</td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Subcuenta:</td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['subCuenta'].'</td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Gastos de titulación:</td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['gastosTitulacion'].'</td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Ahorro voluntario:</td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['ahorroVol'].'</td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Subsidio:</td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['subsidio'].'</td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Suma final:</td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['sumaFinal'].'</td>
                    </tr>
                        </tbody>
                    </table>';
                
                /*----------------------------------------------Promotor----------------------------------------------------------------------*/
                /*$cuerpo .= '
                    <table id="table-promotor" style="width: 80%;margin: 50px auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
                        <thead>
                            <tr>
                                <th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">Promotor</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Nombre:</td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$promotor['nombre'].' '.$promotor['apellidoP'].' '.$promotor['apellidoM'].'</td>
                            </tr>
                        </tbody>
                    </table>';*/
                
                /*----------------------------------------------------------Gerente----------------------------------------------------------*/
                /*$cuerpo .= '
                    <table id="table-gerente" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
                        <thead>
                            <tr>
                                <th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">Gerente de ventas</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Nombre:</td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gerente['nombre'].' '.$gerente['apellidoP'].' '.$gerente['apellidoM'].'</td>
                            </tr>
                        </tbody>
                    </table>';*/
                
                /*----------------------------------------------------------Gestoria----------------------------------------------------------*/
/*                $cuerpo .= '
                    <table id="table-gestoria" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;margin-top:50px;">
                        <thead>
                            <tr>
                                <th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">Datos gestoría</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Estatus:</td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['statusGestoria'].'</td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Estatus:</td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$alta_venta['tipoCredito'].'</td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Aplica folio:</td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['aplicaFolio'].'</td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Número de folio:</td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['numeroFolio'].'</td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Número de crédito:</td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['numeroCredito'].'</td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Fecha de ingreso:</td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.date_format(new DateTime($gestoria['fechaIngreso']), 'd/m/Y').'</td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Certificado de libertad:</td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['certificadoLibertad'].'</td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Constancia de no adeudo:</td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['constanciaNoAdeudo'].'</td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Notaría:</td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$notaria['nombre'].'</td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Fecha firma:</td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.date_format(new DateTime($gestoria['fechaFirma']), 'd/m/Y').'</td>
                            </tr>
                        </tbody>
                    </table>';*/
                
                /*----------------------------------------------------------Montos----------------------------------------------------------*/
                /*$cuerpo .= '
                    <table id="table-montos" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;margin-top:50px;">
                        <thead>
                            <tr>
                                <th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">$ Montos</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Precio venta OCI:</td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.precio_format($gestoria['precioVentaOci']).'</td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Monto OCI:</td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.precio_format($gestoria['montoOci']).'</td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Subcuenta:</td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.precio_format($gestoria['subCuenta']).'</td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Gastos de titulación:</td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.precio_format($gestoria['gastosTitulacion']).'</td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Ahorro voluntario:</td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.precio_format($gestoria['ahorroVol']).'</td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Subsidio:</td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.precio_format($gestoria['subsidio']).'</td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Suma final:</td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.precio_format($gestoria['sumaFinal']).'</td>
                            </tr>
                        </tbody>
                    </table>
                    <hr style="border: 2px solid #EAC633;margin-bottom:30px;margin-top:30px;">
                    ';*/

                    $cuerpo .= '
                    <hr style="border: 2px solid #EAC633;margin-bottom:30px;margin-top:30px;">
                    ';

            }
            
        }


        $mensaje = '
        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
        <html xmlns="http://www.w3.org/1999/xhtml">
        <head>
            <title>Email</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
            <style>
                body, tr, td, span, div, p, a, li {
                    -moz-text-size-adjust:none !important;
                    -webkit-text-size-adjust:none !important;
                    margin:0px !important;
                    -ms-text-size-adjust:none !important;
                    white-space: wrap;
                }
                .lato-light{
                    font-family: "lato" sans-serif !important;
                    font-weight: 300;
                }
                .lato-bold{
                    font-family: "lato" sans-serif !important;
                    font-weight: 700;
                }
                td img {
                    display: block;
                }
                .ReadMsgBody {
                    width: 100%;
                }
                .ExternalClass * {
                    line-height: 100%;
                }
                @media only screen and (max-width:480px) {
                    #logosim{
                        padding:0!important;
                    }
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 320px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
                @media only screen and (min-width:480px) and (max-width:599px) {
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 480px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
            </style>
        </head>
        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
                <tr>
                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
                        <tr>
                            <td>
                                <a href="'.$liga3.'" target="_blank">
                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                                        <tr>
                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
                                                <img width="280" src="'.$urlLogoFracc.'" />
                                            </td>
                                        </tr>
                                    </table>
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
                                    <tr>
                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Ingreso de expediente </h3>
                                            <br><br>
                                            '.$cuerpo.'
                                        </td>
                                    </tr>
                                </table>
                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
                            </td>
                        </tr>
                    </td>
                </tr>
            </table>
        </body>
        </html>';
        //echo $mensaje;exit();
        // para el promotor -------------------------------------------------
        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
        // Cabeceras adicionales
        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
        
        
        $gerentes = "";
        $usuarios = $this->musuario->getAll();
        if ( !is_numeric($usuarios) ){
            foreach ($usuarios->result() as $key3 => $value3) {
                if ( $value3->rol == 4 ) { $gerentes .= $value3->email.","; }
            }
            $gerentes = trim($gerentes, ',');
        }
        
        if ( $gerentes != "" ) { 
            mail($gerentes, $subject, $mensaje, $cabeceras);
        }

        // para el gerente  -------------------------------------------------
        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";

        // Cabeceras adicionales
        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

        // Copy developer  -------------------------------------------------
        $subject2 = 'Viviend - Notificación sobre ingreso de expediente | Gestoria | Copia';
        mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);
        //echo $mensaje;exit();
        return true;
    }
    
    // Validación de comisiones y bonos por día
    public function validacionComisionesBonos()
    {
        $fraccionamientosByPromotores = $this->mfraccionamientoxusuario->getFraccByIdUsuario(2);
        $arrayPromotores = array();
        if ( !is_numeric($fraccionamientosByPromotores) ) {
            foreach ($fraccionamientosByPromotores->result() as $key => $value) {
                if ( array_key_exists($value->idUsuario, $arrayPromotores) ) { 
                    $dPromotores = array( "idFraccionamiento" => $value->idFraccionamiento );
                    array_push($arrayPromotores[$value->idUsuario], $dPromotores); 
                }
                else { 
                    $dPromotores = array( "idFraccionamiento" => $value->idFraccionamiento );
                    $arrayPromotores[$value->idUsuario] = [$dPromotores]; 
                }
            }
        }
        $fraccionamientosByContadores = $this->mfraccionamientoxusuario->getFraccByIdUsuario(7);
        $arrayContadores = array();
        if ( !is_numeric($fraccionamientosByContadores) ) {
            foreach ($fraccionamientosByContadores->result() as $key => $value) {
                if ( array_key_exists($value->idUsuario, $arrayContadores) ) { 
                    $dPromotores = array( "idFraccionamiento" => $value->idFraccionamiento );
                    array_push($arrayContadores[$value->idUsuario], $dPromotores); 
                }
                else { 
                    $dPromotores = array( "idFraccionamiento" => $value->idFraccionamiento );
                    $arrayContadores[$value->idUsuario] = [$dPromotores]; 
                }
            }
        }
        $listadoComisionesBonos = $this->maltaventa->getJoinComisiones();
        
        if ( !is_numeric($listadoComisionesBonos) ) {
            $arrayFraccionamiento = array();
            $arrayComisionesPromotores = array();
            $arrayComisionesContadores = array();
            foreach ($listadoComisionesBonos->result() as $key => $value) {
                $createdComisiones = new DateTime($value->createdComisiones);
                $today = new DateTime();
                if ( $today->format("d-m-Y") == $createdComisiones->format("d-m-Y") ) {
                    if ( array_key_exists($value->idFraccionamiento, $arrayFraccionamiento) ) { 
                        $dComisionesBonos = array(
                            "idAltaVenta" => $value->idAltaVenta,
                            "idProspecto" => $value->idProspecto,
                            "idFraccionamiento" => $value->idFraccionamiento,
                            "idProyecto" => $value->idProyecto,
                            "idPromotor" => $value->idPromotor
                        );
                        array_push($arrayFraccionamiento[$value->idFraccionamiento], $dComisionesBonos); 
                    }
                    else { 
                        $dComisionesBonos = array(
                            "idAltaVenta" => $value->idAltaVenta,
                            "idProspecto" => $value->idProspecto,
                            "idFraccionamiento" => $value->idFraccionamiento,
                            "idProyecto" => $value->idProyecto,
                            "idPromotor" => $value->idPromotor
                        );
                        $arrayFraccionamiento[$value->idFraccionamiento] = [$dComisionesBonos]; 
                    }
                }
                
                foreach ($arrayPromotores as $key2 => $value2) {
                    if ( $key2 == $value->idPromotor && $today->format("d-m-Y") == $createdComisiones->format("d-m-Y") ) {
                        if ( array_key_exists($value->idPromotor, $arrayComisionesPromotores) ) { 
                            $dComisionesBonosPromotor = array(
                                "idAltaVenta" => $value->idAltaVenta,
                                "idProspecto" => $value->idProspecto,
                                "idFraccionamiento" => $value->idFraccionamiento,
                                "idProyecto" => $value->idProyecto,
                                "idPromotor" => $value->idPromotor
                            );
                            array_push($arrayComisionesPromotores[$value->idPromotor], $dComisionesBonosPromotor); 
                        }
                        else { 
                            $dComisionesBonosPromotor = array(
                                "idAltaVenta" => $value->idAltaVenta,
                                "idProspecto" => $value->idProspecto,
                                "idFraccionamiento" => $value->idFraccionamiento,
                                "idProyecto" => $value->idProyecto,
                                "idPromotor" => $value->idPromotor
                            );
                            $arrayComisionesPromotores[$value->idPromotor] = [$dComisionesBonosPromotor]; 
                        }
                    }
                }
                
                foreach ($arrayContadores as $key3 => $value3) {
                    foreach ($value3 as $key3_1 => $value3_1) {
                        // print_r($value3_1);
                        if ( $value3_1['idFraccionamiento'] == $value->idFraccionamiento && $today->format("d-m-Y") == $createdComisiones->format("d-m-Y") ) {
                            if ( array_key_exists($key3, $arrayComisionesContadores) ) { 
                                $dComisionesBonosContadores = array(
                                    "idAltaVenta" => $value->idAltaVenta,
                                    "idProspecto" => $value->idProspecto,
                                    "idFraccionamiento" => $value->idFraccionamiento,
                                    "idProyecto" => $value->idProyecto,
                                    "idPromotor" => $value->idPromotor
                                );
                                array_push($arrayComisionesContadores[$key3], $dComisionesBonosContadores); 
                            }
                            else { 
                                $dComisionesBonosContadores = array(
                                    "idAltaVenta" => $value->idAltaVenta,
                                    "idProspecto" => $value->idProspecto,
                                    "idFraccionamiento" => $value->idFraccionamiento,
                                    "idProyecto" => $value->idProyecto,
                                    "idPromotor" => $value->idPromotor
                                );
                                $arrayComisionesContadores[$key3] = [$dComisionesBonosContadores]; 
                            }
                        }
                    }
                }
            }
            $response['mail'] = (count($arrayFraccionamiento)>0)?$this->autoRespuestaComisionesBonos($arrayFraccionamiento):false;
            foreach ($arrayComisionesPromotores as $key4 => $value4) {
                //$response['mailPromotores'][] = $this->autoRespuestaComisionesBonosPromotores($value4);
            }
            foreach ($arrayComisionesContadores as $key5 => $value5) {
                $response['mailContadores'][] = $this->autoRespuestaComisionesBonosPromotores($value5, 'contadores');
            }
        }
        else {
            $response['mail'] = 0;
        }
        echo json_encode($response);
    }
    
    function autoRespuestaComisionesBonos( $fraccionamientos = null ) {
        /*$copiasNV = 'sistemas@viviend.mx, ';
        $copiasNV .= 'ruben@navegantes.mx';*/

        $copiasNV = 'hsalinas@viviend.mx'. ', ';
        $copiasNV .= 'esalinas@viviend.mx'. ', ';
        $copiasNV .= 'mejora@viviend.mx'. ', ';
        $copiasNV .= 'sistemas@viviend.mx';
        
        $subject = 'Notificación de comisiones | Comisiones o bonos';
        $cuerpo = '';
        
        $liga="http://viviend.mx/sistema/emailresources/";
        $liga2="http://viviend.mx/sistema/img/";
        $liga3="http://viviend.mx/sistema/";
        $urlLogoFracc = 'http://viviend.mx/sistema/img/logo-300.png';
        
        
        foreach ($fraccionamientos as $key1 => $value1) {
            $nomFraccionamiento = $this->mfraccionamiento->getCampo('titulo',$key1);
            $cuerpo .= '<h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:18px;margin-bottom: 0px;"> '.$nomFraccionamiento.' </h4>';
            foreach ($value1 as $key2 => $value2) {
                $alta_venta = $this->maltaventa->getById($value2['idAltaVenta']);
                $info = $this->maltaventa->getGestoriaByIdProy($value2['idProyecto']);
                
                /*-------------------------------------------------------------CUANDO SEA DETONADO----------------------------------------------------------------------------*/
                $montoFinal = $info['sumaFinal'];
                /*variables de saldos*/
                $resultado = ($info['precioVenta']<$info['precioVentaOci'])?$info['sumaFinal'] - $info['precioVenta']:$info['sumaFinal'] - $info['precioVentaOci'];
                $bonoPresupuestoInicial = $info['bonoEquipamiento'];
                $saldo = $resultado - $bonoPresupuestoInicial;
                /*variables de valores finales*/
                $cierre = $montoFinal - $bonoPresupuestoInicial;//$info['bonoPresupuestoInicial'];
                $comision = $this->musuario->getCampo("comision",$info['idPromotor']);
                $nombrePromotor = $this->musuario->getCampo("nombre",$info['idPromotor'])." ".$this->musuario->getCampo("apellidoP",$info['idPromotor']);
                $info2 = $this->maltaventa->getByIdForAutorizaciones($value2['idAltaVenta']);
                $importeComision = $info2['importeComision'];
                /*$netoVenta = $cierre - $importeComision;*/
                $netoVenta =$info2['netoVenta'];

                $cuerpo .= '
                            <table id="table-blackboard" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">CUANDO SEA DETONADO</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                     <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NOMBRE DEL CLIENTE: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info2['nombre'].' '.$info2['apellidoP'].' '.$info2['apellidoM'].'</td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> LOTE: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info2['lote'].' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> MANZANA: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info2['manzana'].' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> VALOR AVALÚO: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['avaluo']).' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> PRECIO VENTA OCI: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['precioVentaOci']).' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> PRECIO VENTA EMPRESA: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['precioVenta']).' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> MONTO FINAL: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($montoFinal).' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> DIF PROPIO PECULIO: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info2['difPropioPeculio']).' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NÚMERO DE CRÉDITO: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['numeroCredito'].' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> RESULTADO: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format( $resultado ).' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> BONO PRESUPUESTO INICIAL: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($bonoPresupuestoInicial).' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> SALDO: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($saldo).' </td>
                                    </tr>
                                     <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> CIERRE: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($cierre).' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> TIPO DE PROMOTOR: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$this->musuario->getCampo("tipoPromotor",$info['idPromotor']).' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> COMISIÓN: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$comision.' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> IMPORTE COMISIÓN: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($importeComision).' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NOMBRE DEL PROMOTOR: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nombrePromotor.' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NETO DE VENTA: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($netoVenta).' </td>
                                    </tr>
                                </tbody>
                            </table>
                            <hr style="border: 2px solid #EAC633;margin-bottom:30px;margin-top:30px;">';

                
                /*---------------------------------------------------------------------SALDOS--------------------------------------------------------------------*/
              /*  $resultado = ($info['precioVenta']<$info['precioVentaOci'])?$info['sumaFinal'] - $info['precioVenta']:$info['sumaFinal'] - $info['precioVentaOci'];
                $bonoPresupuestoInicial = $info['bonoEquipamiento'];
                $saldo = $resultado - $bonoPresupuestoInicial;
                $cuerpo .= '
                            <table id="table-blackboard" style="width: 80%;margin: 50px auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">SALDOS</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> RESULTADO: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format( $resultado ).' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> BONO PRESUPUESTO INICIAL: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($bonoPresupuestoInicial).' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> SALDO: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($saldo).' </td>
                                    </tr>
                                </tbody>
                            </table>';*/
                
                /*--------------------------------------------------------------VALORES FINALES---------------------------------------------------------------------------*/
               /* $cierre = $montoFinal - $bonoPresupuestoInicial;//$info['bonoPresupuestoInicial'];
                $comision = $this->musuario->getCampo("comision",$info['idPromotor']);
                $importeComision = $cierre * $comision/100;
                $nombrePromotor = $this->musuario->getCampo("nombre",$info['idPromotor'])." ".$this->musuario->getCampo("apellidoP",$info['idPromotor']);
                $netoVenta = $cierre - $importeComision;
                $cuerpo .= '
                            <table id="table-blackboard" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">VALORES FINALES</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> CIERRE: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($cierre).' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> TIPO DE PROMOTOR: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$this->musuario->getCampo("tipoPromotor",$info['idPromotor']).' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> COMISIÓN: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$comision.' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> IMPORTE COMISIÓN: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($importeComision).' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NOMBRE DEL PROMOTOR: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nombrePromotor.' </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NETO DE VENTA: </td>
                                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($netoVenta).' </td>
                                    </tr>
                                </tbody>
                            </table>
                            <hr style="border: 2px solid #EAC633;margin-bottom:30px;margin-top:30px;">';*/
            }
        }
        
        
        $mensaje = '
        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
        <html xmlns="http://www.w3.org/1999/xhtml">
        <head>
            <title>Email</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
            <style>
                body, tr, td, span, div, p, a, li {
                    -moz-text-size-adjust:none !important;
                    -webkit-text-size-adjust:none !important;
                    margin:0px !important;
                    -ms-text-size-adjust:none !important;
                    white-space: wrap;
                }
                .lato-light{
                    font-family: "lato" sans-serif !important;
                    font-weight: 300;
                }
                .lato-bold{
                    font-family: "lato" sans-serif !important;
                    font-weight: 700;
                }
                td img {
                    display: block;
                }
                .ReadMsgBody {
                    width: 100%;
                }
                .ExternalClass * {
                    line-height: 100%;
                }
                @media only screen and (max-width:480px) {
                    #logosim{
                        padding:0!important;
                    }
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 320px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
                @media only screen and (min-width:480px) and (max-width:599px) {
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 480px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
            </style>
        </head>
        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
                <tr>
                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
                        <tr>
                            <td>
                                <a href="'.$liga3.'" target="_blank">
                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                                        <tr>
                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
                                                <img width="280" src="'.$urlLogoFracc.'" />
                                            </td>
                                        </tr>
                                    </table>
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
                                    <tr>
                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Notificación de comisión </h3>
                                            <!--<h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:16px;margin-top: 10px;"> De  </h4>-->
                                            <br><br>
                                            '.$cuerpo.'
                                        </td>
                                    </tr>
                                </table>
                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
                            </td>
                        </tr>
                    </td>
                </tr>
            </table>
        </body>
        </html>';
        
       
        // para el gerente de ventas -------------------------------------------------
        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
        
        // Cabeceras adicionales
        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

        $gerentes = "";
        $usuarios = $this->musuario->getAll();
        if ( !is_numeric($usuarios) ){
            foreach ($usuarios->result() as $key3 => $value3) {
                if ( $value3->rol == 4 ) { $gerentes .= $value3->email.","; }
            }
            $gerentes = trim($gerentes, ',');
        }
        
        if ( $gerentes != "" ) { 
            mail($gerentes, $subject, $mensaje, $cabeceras);
        }
        
        $subject2 = $subject." - ADMIN";

        // para el gerente  -------------------------------------------------
        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";

        // Cabeceras adicionales
        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

        // para el administrador
        mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);

        return true;
    }
    
    function autoRespuestaComisionesBonosPromotores( $comisiones = null, $bandera = null ) {
        /*$copiasNV = 'sistemas@viviend.mx, ';
        $copiasNV .= 'ruben@navegantes.mx';*/

        $copiasNV = 'hsalinas@viviend.mx'. ', ';
        $copiasNV .= 'esalinas@viviend.mx'. ', ';
        $copiasNV .= 'mejora@viviend.mx'. ', ';
        $copiasNV .= 'sistemas@viviend.mx';
        
        $subject = 'Notificación de comisiones | Comisiones o bonos';
        $cuerpo = '';
        
        $liga="http://viviend.mx/sistema/emailresources/";
        $liga2="http://viviend.mx/sistema/img/";
        $liga3="http://viviend.mx/sistema/";
        $urlLogoFracc = 'http://viviend.mx/sistema/img/logo-300.png';
        
        $idPromotor = 0;
        $idFracc_ = 0;
        
        foreach ($comisiones as $key2 => $value2) {
            $alta_venta = $this->maltaventa->getById($value2['idAltaVenta']);
            $info = $this->maltaventa->getGestoriaByIdProy($value2['idProyecto']);
            
            $idPromotor = $value2['idPromotor'];
            $idFracc_ = $value2['idFraccionamiento'];
            
            $nomFraccionamiento = $this->mfraccionamiento->getCampo('titulo',$value2['idFraccionamiento']);
            // $cuerpo .= '<h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:18px;margin-bottom: 0px;"> '.$nomFraccionamiento.' </h4>';
            
            /*-------------------------------------------------------------CUANDO SEA DETONADO----------------------------------------------------------------------------*/
            $montoFinal = $info['sumaFinal'];
            /*valores de saldos*/
            $resultado = ($info['precioVenta']<$info['precioVentaOci'])?$info['sumaFinal'] - $info['precioVenta']:$info['sumaFinal'] - $info['precioVentaOci'];
            $bonoPresupuestoInicial = $info['bonoEquipamiento'];
            $saldo = $resultado - $bonoPresupuestoInicial;
            /*valores de valores finales*/
            $cierre = $montoFinal - $bonoPresupuestoInicial;//$info['bonoPresupuestoInicial'];
            $comision = $this->musuario->getCampo("comision",$info['idPromotor']);
            $nombrePromotor = $this->musuario->getCampo("nombre",$info['idPromotor'])." ".$this->musuario->getCampo("apellidoP",$info['idPromotor']);
            $info2 = $this->maltaventa->getByIdForAutorizaciones($value2['idAltaVenta']);
            $importeComision = $info2['importeComision'];
            /*$netoVenta = $cierre - $importeComision;*/
            $netoVenta = $info2['netoVenta'];
              

            $cuerpo .= '
                        <table id="table-blackboard" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
                            <thead>
                                <tr>
                                    <th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">CUANDO SEA DETONADO</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NOMBRE DEL CLIENTE: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info2['nombre'].' '.$info2['apellidoP'].' '.$info2['apellidoM'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> LOTE: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info2['lote'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> MANZANA: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info2['manzana'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> FRACCIONAMIENTO: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nomFraccionamiento.' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> VALOR AVALÚO: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['avaluo']).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> PRECIO VENTA OCI: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['precioVentaOci']).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> PRECIO VENTA EMPRESA: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['precioVenta']).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> MONTO FINAL: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($montoFinal).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> DIF PROPIO PECULIO: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info2['difPropioPeculio']).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NÚMERO DE CRÉDITO: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['numeroCredito'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> RESULTADO: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format( $resultado ).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> BONO PRESUPUESTO INICIAL: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($bonoPresupuestoInicial).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> SALDO: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($saldo).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> CIERRE: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($cierre).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> TIPO DE PROMOTOR: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$this->musuario->getCampo("tipoPromotor",$info['idPromotor']).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> COMISIÓN: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$comision.' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> IMPORTE COMISIÓN: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($importeComision).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NOMBRE DEL PROMOTOR: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nombrePromotor.' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NETO DE VENTA: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($netoVenta).' </td>
                                </tr>
                            </tbody>
                        </table>
                        <hr style="border: 2px solid #EAC633;margin-bottom:30px;margin-top:30px;">';
            
            /*---------------------------------------------------------------------SALDOS--------------------------------------------------------------------*/
           /* $resultado = ($info['precioVenta']<$info['precioVentaOci'])?$info['sumaFinal'] - $info['precioVenta']:$info['sumaFinal'] - $info['precioVentaOci'];
            $bonoPresupuestoInicial = $info['bonoEquipamiento'];
            $saldo = $resultado - $bonoPresupuestoInicial;
            $cuerpo .= '
                        <table id="table-blackboard" style="width: 80%;margin: 50px auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
                            <thead>
                                <tr>
                                    <th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">SALDOS</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> RESULTADO: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format( $resultado ).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> BONO PRESUPUESTO INICIAL: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($bonoPresupuestoInicial).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> SALDO: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($saldo).' </td>
                                </tr>
                            </tbody>
                        </table>';*/
            
            /*--------------------------------------------------------------VALORES FINALES---------------------------------------------------------------------------*/
         /*   $cierre = $montoFinal - $bonoPresupuestoInicial;//$info['bonoPresupuestoInicial'];
            $comision = $this->musuario->getCampo("comision",$info['idPromotor']);
            $importeComision = $cierre * $comision/100;
            $nombrePromotor = $this->musuario->getCampo("nombre",$info['idPromotor'])." ".$this->musuario->getCampo("apellidoP",$info['idPromotor']);
            $netoVenta = $cierre - $importeComision;
            $cuerpo .= '
                        <table id="table-blackboard" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
                            <thead>
                                <tr>
                                    <th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">VALORES FINALES</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> CIERRE: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($cierre).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> TIPO DE PROMOTOR: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$this->musuario->getCampo("tipoPromotor",$info['idPromotor']).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> COMISIÓN: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$comision.' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> IMPORTE COMISIÓN: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($importeComision).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NOMBRE DEL PROMOTOR: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nombrePromotor.' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NETO DE VENTA: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($netoVenta).' </td>
                                </tr>
                            </tbody>
                        </table>
                        <hr style="border: 2px solid #EAC633;margin-bottom:30px;margin-top:30px;">';*/
        }
        
        
        $mensaje = '
        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
        <html xmlns="http://www.w3.org/1999/xhtml">
        <head>
            <title>Email</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
            <style>
                body, tr, td, span, div, p, a, li {
                    -moz-text-size-adjust:none !important;
                    -webkit-text-size-adjust:none !important;
                    margin:0px !important;
                    -ms-text-size-adjust:none !important;
                    white-space: wrap;
                }
                .lato-light{
                    font-family: "lato" sans-serif !important;
                    font-weight: 300;
                }
                .lato-bold{
                    font-family: "lato" sans-serif !important;
                    font-weight: 700;
                }
                td img {
                    display: block;
                }
                .ReadMsgBody {
                    width: 100%;
                }
                .ExternalClass * {
                    line-height: 100%;
                }
                @media only screen and (max-width:480px) {
                    #logosim{
                        padding:0!important;
                    }
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 320px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
                @media only screen and (min-width:480px) and (max-width:599px) {
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 480px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
            </style>
        </head>
        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
                <tr>
                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
                        <tr>
                            <td>
                                <a href="'.$liga3.'" target="_blank">
                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                                        <tr>
                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
                                                <img width="280" src="'.$urlLogoFracc.'" />
                                            </td>
                                        </tr>
                                    </table>
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
                                    <tr>
                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Notificación de comisión </h3>
                                            <!--<h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:16px;margin-top: 10px;"> De  </h4>-->
                                            <br><br>
                                            '.$cuerpo.'
                                        </td>
                                    </tr>
                                </table>
                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
                            </td>
                        </tr>
                    </td>
                </tr>
            </table>
        </body>
        </html>';
    /*     echo $mensaje; exit();*/
        
        // para el gerente de ventas -------------------------------------------------
        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
        // Cabeceras adicionales
        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
        
        
        if ( !is_null($bandera) && $bandera == 'contadores' ) {
            $para = '';
            $contadores_  = $this->mfraccionamientoxusuario->getContabilidadSelectResultByIdFracc( $idFracc_ );
            if ( !is_numeric($contadores_) ) {
                foreach ($contadores_->result() as $key => $value) {
                    $para .= ($this->musuario->getCampo('email',$value->id)!=false?$this->musuario->getCampo('email',$value->id):'');
                    $para .= ',';
                }
                $para = trim($para,',');
                if ( $para != "" && is_string($para) ) { 
                 mail($para, $subject, $mensaje, $cabeceras);
                }
            }
        }
        else {
            $para = $this->musuario->getCampo('email',$idPromotor);
            
            if ( $para != "" && is_string($para) ) { 
                mail($para, $subject, $mensaje, $cabeceras);
            }
        }
        
        $subject2 = $subject." ADMIN";

        // para el gerente  -------------------------------------------------
        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";

        // Cabeceras adicionales
        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

        // para el administrador
        mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);

        return true;
    }
    
    
    public function validacionAutorizaciones()
    {
        $listadoAutorizaciones = $this->maltaventa->getByIdForAutorizaciones2();
        if ( !is_numeric($listadoAutorizaciones) ) {
            $arrayFraccionamiento = array();
            // echo "<pre>"; print_r($listadoAutorizaciones->result()); echo "</pre>"; exit();
            foreach ($listadoAutorizaciones->result() as $key => $value) {
                $createdAutorizaciones = new DateTime($value->createdAutorizaciones);
                $updatedAutorizaciones = new DateTime($value->updatedAutorizaciones);
                $today = new DateTime();
                if ( $today->format("d-m-Y") == $createdAutorizaciones->format("d-m-Y") || $today->format("d-m-Y") == $updatedAutorizaciones->format("d-m-Y") ) {
                    if ( array_key_exists($value->idFraccionamiento, $arrayFraccionamiento) ) { 
                        $dAltaVenta = array(
                            "idAltaVenta" => $value->id,
                            "idProyecto" => $value->idProyecto,
                            "idProspecto" => $value->idProspecto,
                            "idPromotor" => $value->idPromotor,
                            "idFraccionamiento" => $value->idFraccionamiento,
                            "idGestoria" => $value->idGestoria
                        );
                        array_push($arrayFraccionamiento[$value->idFraccionamiento], $dAltaVenta); 
                    }
                    else { 
                        $dAltaVenta = array(
                            "idAltaVenta" => $value->id,
                            "idProyecto" => $value->idProyecto,
                            "idProspecto" => $value->idProspecto,
                            "idPromotor" => $value->idPromotor,
                            "idFraccionamiento" => $value->idFraccionamiento,
                            "idGestoria" => $value->idGestoria
                        );
                        $arrayFraccionamiento[$value->idFraccionamiento] = [$dAltaVenta]; 
                    }
                }
            }
            // echo "<pre>"; print_r($arrayFraccionamiento); echo "</pre>"; exit();
            $response['mail'] = (count($arrayFraccionamiento)>0)?$this->autoRespuestaAutorizaciones($arrayFraccionamiento):false;
        }
        else {
            $response['mail'] = 0;
        }
        echo json_encode($response);
    }
    
    function autoRespuestaAutorizaciones( $fraccionamientos = null ) {
        /*$copiasNV = "sistemas@viviend.mx, ";
        $copiasNV .= "ruben@navegantes.mx";*/

        $copiasNV = 'hsalinas@viviend.mx'. ', ';
        $copiasNV .= 'esalinas@viviend.mx'. ', ';
        $copiasNV .= 'mejora@viviend.mx'. ', ';
        $copiasNV .= 'sistemas@viviend.mx';

        $subject = 'Notificación de autorizaciones | Autorizaciones';
        $cuerpo = '';
        
        
        $liga="http://viviend.mx/sistema/emailresources/";
        $liga2="http://viviend.mx/sistema/img/";
        $liga3="http://viviend.mx/sistema/";
        $urlLogoFracc = 'http://viviend.mx/sistema/img/logo-300.png';
        
        
        foreach ($fraccionamientos as $key1 => $value1) {
            $nomFraccionamiento = $this->mfraccionamiento->getCampo('titulo',$key1);
            $cuerpo .= '<h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:18px;margin-bottom: 0px;"> '.$nomFraccionamiento.' </h4>';
            foreach ($value1 as $key2 => $value2) {
                $info = $this->maltaventa->getByIdForAutorizaciones($value2['idAltaVenta']);
                
                $nomPromotor = $this->musuario->getCampo('nombre',$value2['idPromotor'])." ";
                $nomPromotor .= $this->musuario->getCampo('apellidoP',$value2['idPromotor'])." ";
                $nomPromotor .= $this->musuario->getCampo('apellidoM',$value2['idPromotor']);

                /*$nomGerente = $this->musuario->getCampo('nombre',$this->musuario->getGerente2($value2['idFraccionamiento']))." ";
                $nomGerente .= $this->musuario->getCampo('apellidoP',$this->musuario->getGerente2($value2['idFraccionamiento']))." ";
                $nomGerente .= $this->musuario->getCampo('apellidoM',$this->musuario->getGerente2($value2['idFraccionamiento']));*/
                $qGerentes = $this->musuario->getGerentes2($value2['idFraccionamiento']);
                $nomGerente = '';
                if( !is_numeric($qGerentes) ){
                    foreach($qGerentes->result() as $gteV){
                        $qGerente = $this->musuario->getById($gteV->id);
                        if( !is_numeric($qGerente) ){
                            $nomGerente = $nomGerente.$qGerente['nombre'].' '.$qGerente['apellidoP'].' '.$qGerente['apellidoM'].', ';
                        }
                    }
                }
                if( !empty($nomGerente) ){
                    $nomGerente = substr($nomGerente, 0, -2);
                }

                $sPagoPromotor = ($info['segundoPagoPromotor']>0)?'<tr><td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Segundo pago de promotor: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['segundoPagoPromotor']).' </td>
                                </tr>':'';
                $fSPagoPromotor = ($info['fechaSegundoPagoPromotor'] !='' && $info['fechaSegundoPagoPromotor'] != '0000-00-00')?'<tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha segundo pago de promotor: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($info['fechaSegundoPagoPromotor']), 'd/m/Y').' </td></tr>':'';
                $pPagoCoordinador = ($info['primerPagoCoordinador']>0)?'<tr><td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Primer pago de coordinador: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['primerPagoCoordinador']).' </td></tr>':'';
                $fPPagoCoordinador = ($info['fechaPrimerPagoCoordinador']!='' && $info['fechaPrimerPagoCoordinador']!='0000-00-00')?'<tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha primer pago de coordinador: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($info['fechaPrimerPagoCoordinador']), 'd/m/Y').' </td>
                                </tr>':'';
                $sPagoCoordinador = ($info['segundoPagoCoordinador']>0)?'<tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Segundo pago de coordinador: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['segundoPagoCoordinador']).' </td>
                                </tr>':'';
                $fSPagoCoordinador = ($info['fechaSegundoPagoCoordinador']!='' && $info['fechaSegundoPagoCoordinador']!='0000-00-00')?'<tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha segundo pago de coordinador: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($info['fechaSegundoPagoCoordinador']), 'd/m/Y').' </td>
                                </tr>':'';
                $bonificacion = ($info['bonificacion']>0)?'<tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Bonificación: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['bonificacion']).' </td>
                                </tr>':'';
                $fechaBonificacion = ($info['fechaBonificacion']!='' && $info['fechaBonificacion']!='0000-00-00' && $info['bonificacion']>0)?'<tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha bonificación: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($info['fechaBonificacion']), 'd/m/Y').' </td>
                                </tr>':'';
                $bonoEquipamiento = ($info['bonoEquipamiento']>0)?'<tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> BONO PRESUPUESTO: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['bonoEquipamiento']).' </td>
                                </tr>':'';
                $precioVenta = ($info['precioVenta']>0)?'<tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> PRECIO DE VENTA: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['precioVenta']).' </td>
                                </tr>':'';
                /*-----------------------------------------------------------------------------------------------------------------------------------------*/
                $cuerpo .= '
                        <table id="table-blackboard" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">

                            <tbody>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NOMBRE DEL CLIENTE: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['nombre'].' '.$info['apellidoP'].' '.$info['apellidoM'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> LOTE: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['lote'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> MANZANA: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['manzana'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NOMBRE DEL PROMOTOR: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nomPromotor.' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NOMBRE DEL GERENTE: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nomGerente.' </td>
                                </tr>

                                <!-- <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> MONTO TOTAL: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['montoTotal']).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> DIF PROPIO PECULIO: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['peculioAutorizaciones']).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> RESULTADO: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['resultadoAutorizaciones']).' </td>
                                </tr> -->
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Primer pago de promotor: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['primerPagoPromotor']).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha primer pago de promotor: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($info['fechaPrimerPagoPromotor']), 'd/m/Y').' </td>
                                </tr>

                                '.$sPagoPromotor.'
                                '.$fSPagoPromotor.'
                                '.$pPagoCoordinador.'
                                '.$fPPagoCoordinador.'
                                '.$sPagoCoordinador.'
                                '.$fSPagoCoordinador.'
                                '.$bonificacion.'
                                '.$fechaBonificacion.'
                                '.$bonoEquipamiento.'                            
                                            
                                
                                <!-- <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> PROP DE VENTA: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['propVenta']).' </td>
                                </tr> -->
                                '.$precioVenta.'
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> ESTATUS: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['statusAutorizacion'].' </td>
                                </tr>

                            </tbody>
                        </table>';
                
                $cuerpo .= '                        
                        <hr style="border: 2px solid #EAC633;margin-bottom:30px;margin-top:30px;">';
            }
        }
        
        
        $mensaje = '
        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
        <html xmlns="http://www.w3.org/1999/xhtml">
        <head>
            <title>Email</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
            <style>
                body, tr, td, span, div, p, a, li {
                    -moz-text-size-adjust:none !important;
                    -webkit-text-size-adjust:none !important;
                    margin:0px !important;
                    -ms-text-size-adjust:none !important;
                    white-space: wrap;
                }
                .lato-light{
                    font-family: "lato" sans-serif !important;
                    font-weight: 300;
                }
                .lato-bold{
                    font-family: "lato" sans-serif !important;
                    font-weight: 700;
                }
                td img {
                    display: block;
                }
                .ReadMsgBody {
                    width: 100%;
                }
                .ExternalClass * {
                    line-height: 100%;
                }
                @media only screen and (max-width:480px) {
                    #logosim{
                        padding:0!important;
                    }
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 320px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
                @media only screen and (min-width:480px) and (max-width:599px) {
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 480px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
            </style>
        </head>
        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
                <tr>
                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
                        <tr>
                            <td>
                                <a href="'.$liga3.'" target="_blank">
                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                                        <tr>
                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
                                                <img width="280" src="'.$urlLogoFracc.'" />
                                            </td>
                                        </tr>
                                    </table>
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
                                    <tr>
                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center">
                                            <!--<span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">-->
                                                <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Notificación de autorización </h3>
                                                <br><br>
                                                '.$cuerpo.'
                                            <!--</span>-->
                                        </td>
                                    </tr>
                                </table>
                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
                            </td>
                        </tr>
                    </td>
                </tr>
            </table>
        </body>
        </html>';
        //echo $mensaje;exit();
        // echo $mensaje;
        // para el Contador -------------------------------------------------
        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
        // Cabeceras adicionales
        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
        
        $contadores = "";
        $usuarios = $this->musuario->getAll();
        if ( !is_numeric($usuarios) ){
            foreach ($usuarios->result() as $key3 => $value3) {
                if ( $value3->rol == 7 ) { $contadores .= $value3->email.","; }
            }
            $contadores = trim($contadores, ',');
        }
        
        if ( $contadores != "" ) { 
            mail($contadores, $subject, $mensaje, $cabeceras);
        }
        
        $subject2 = $subject." ADMIN";
        
        // para el gerente  -------------------------------------------------
        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";
        // Cabeceras adicionales
        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
        
        // para el administrador
        mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);
        
        return true;
    }
    
    public function validacionDepositos()
    {
        $listadoDepositos = $this->maltaventa->getByIdForDepositos2();
        // $listadoDepositos = $this->maltaventa->getJoinAutorizaciones();
        if ( !is_numeric($listadoDepositos) ) {
            $arrayFraccionamiento = array();
            // echo "<pre>"; print_r($listadoDepositos->result()); echo "</pre>"; exit();
            foreach ($listadoDepositos->result() as $key => $value) {
                $createdDepositos = new DateTime($value->createdDepositos);
                $today = new DateTime();
                if ( $today->format("d-m-Y") == $createdDepositos->format("d-m-Y") ) {
                    if ( array_key_exists($value->idFraccionamiento, $arrayFraccionamiento) ) { 
                        $dAltaVenta = array(
                            "idAltaVenta" => $value->id,
                            "idProyecto" => $value->idProyecto,
                            "idProspecto" => $value->idProspecto,
                            "idPromotor" => $value->idPromotor,
                            "idFraccionamiento" => $value->idFraccionamiento,
                            "idGestoria" => $value->idGestoria
                        );
                        array_push($arrayFraccionamiento[$value->idFraccionamiento], $dAltaVenta); 
                    }
                    else { 
                        $dAltaVenta = array(
                            "idAltaVenta" => $value->id,
                            "idProyecto" => $value->idProyecto,
                            "idProspecto" => $value->idProspecto,
                            "idPromotor" => $value->idPromotor,
                            "idFraccionamiento" => $value->idFraccionamiento,
                            "idGestoria" => $value->idGestoria
                        );
                        $arrayFraccionamiento[$value->idFraccionamiento] = [$dAltaVenta]; 
                    }
                }
            }
            // echo "<pre>"; print_r($arrayFraccionamiento); echo "</pre>"; exit();
            $response['mail'] = (count($arrayFraccionamiento)>0)?$this->autoRespuestaDepositos($arrayFraccionamiento):false;
        }
        else {
            $response['mail'] = 0;
        }
        echo json_encode($response);
    }
    
    function autoRespuestaDepositos( $fraccionamientos = null ) {
        /*$copiasNV = "sistemas@viviend.mx, ";
        $copiasNV .= "ruben@navegantes.mx";*/

        $copiasNV = 'hsalinas@viviend.mx'. ', ';
        $copiasNV .= 'esalinas@viviend.mx'. ', ';
        $copiasNV .= 'mejora@viviend.mx'. ', ';
        $copiasNV .= 'sistemas@viviend.mx';
        
        
        $subject = 'Notificación de depósito | Depósitos';
        $cuerpo = '';
                
        $liga="http://viviend.mx/sistema/emailresources/";
        $liga2="http://viviend.mx/sistema/img/";
        $liga3="http://viviend.mx/sistema/";
        $urlLogoFracc = 'http://viviend.mx/sistema/img/logo-300.png';
        
        foreach ($fraccionamientos as $key1 => $value1) {
            $nomFraccionamiento = $this->mfraccionamiento->getCampo('titulo',$key1);
            $cuerpo .= '<h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:18px;margin-bottom: 0px;"> '.$nomFraccionamiento.' </h4>';
            foreach ($value1 as $key2 => $value2) {
                $info = $this->maltaventa->getByIdForDepositos($value2['idAltaVenta']);
                
                /*-----------------------------------------------------------------------------------------------------------------------------------------*/
                $cuerpo .= '
                        <table id="table-blackboard" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
                            <thead>
                                <tr>
                                    <th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">CLIENTE</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NOMBRE DEL CLIENTE: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['nombre'].' '.$info['apellidoP'].' '.$info['apellidoM'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> LOTE: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['lote'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> MANZANA: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['manzana'].' </td>
                                </tr>
                            </tbody>
                        </table>';
                
                /*-----------------------------------------------------------------------------------------------------------------------------------------*/
                $nomPromotor = $this->musuario->getCampo('nombre',$value2['idPromotor'])." ";
                $nomPromotor .= $this->musuario->getCampo('apellidoP',$value2['idPromotor'])." ";
                $nomPromotor .= $this->musuario->getCampo('apellidoM',$value2['idPromotor']);
                $cuerpo .= '
                        <table id="table-blackboard" style="width: 80%;margin: 50px auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
                            <thead>
                                <tr>
                                    <th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">PROMOTOR</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NOMBRE DEL PROMOTOR: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nomPromotor.' </td>
                                </tr>
                            </tbody>
                        </table>';
                
                /*-----------------------------------------------------------------------------------------------------------------------------------------*/
                /*$nomGerente = $this->musuario->getCampo('nombre',$this->musuario->getGerente2($value2['idFraccionamiento']))." ";
                $nomGerente .= $this->musuario->getCampo('apellidoP',$this->musuario->getGerente2($value2['idFraccionamiento']))." ";
                $nomGerente .= $this->musuario->getCampo('apellidoM',$this->musuario->getGerente2($value2['idFraccionamiento']));*/
                $qGerentes = $this->musuario->getGerentes2($value2['idFraccionamiento']);
                $nomGerente = '';
                if( !is_numeric($qGerentes) ){
                    foreach($qGerentes->result() as $gteV){
                        $qGerente = $this->musuario->getById($gteV->id);
                        if( !is_numeric($qGerente) ){
                            $nomGerente = $nomGerente.$qGerente['nombre'].' '.$qGerente['apellidoP'].' '.$qGerente['apellidoM'].', ';
                        }
                    }
                }
                if( !empty($nomGerente) ){
                    $nomGerente = substr($nomGerente, 0, -2);
                }
                $cuerpo .= '
                        <table id="table-blackboard" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
                            <thead>
                                <tr>
                                    <th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">GERENTE</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NOMBRE DEL GERENTE: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nomGerente.' </td>
                                </tr>
                            </tbody>
                        </table>';
                
                /*-----------------------------------------------------------------------------------------------------------------------------------------*/
                $cuerpo .= '
                        <table id="table-blackboard" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase; margin-top: 50px;">
                            <thead>
                                <tr>
                                    <th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">CUANDO SEA DETONADO</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NÚMERO DE CRÉDITO: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['numeroCredito'].' </td>
                                </tr>
                                <!-- <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> MONTO TOTAL: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['montoTotalDepositos']).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> DIF PROPIO PECULIO: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['peculioDepositos']).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> RESULTADO: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['resultadoDepositos']).' </td>
                                </tr> -->
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> BONO PROPUESTO: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['bonoEquipamiento']).' </td>
                                </tr>
                                <!-- <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> PROP DE VENTA: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['propVentaDepositos']).' </td>
                                </tr> -->
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> PRECIO DE VENTA: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['precioVenta']).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> AUTORIZACIÓN: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['statusAutorizacionDepositos'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> DEPÓSITO INFONAVIT: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['depositoInfonavit']).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> DEPÓSITO CONAVI: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['depositoConavi']).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> FECHA DEPÓSITO: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($info['fechaDeposito']), 'd/m/Y').' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> CUENTA DEPOSITADA: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['cuentaDepositada'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Pago Uno: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['pagoUno']).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de pago Uno: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($info['fechaPagoUno']), 'd/m/Y').' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Pago Dos: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['pagoDos']).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de pago Dos: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($info['fechaPagoDos']), 'd/m/Y').' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Pago Tres: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['pagoTres']).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de pago Tres: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($info['fechaPagoTres']), 'd/m/Y').' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Pago Cuatro: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['pagoCuatro']).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de pago Cuatro: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($info['fechaPagoCuatro']), 'd/m/Y').' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Pago Cinco: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['pagoCinco']).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de pago Cinco: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($info['fechaPagoCinco']), 'd/m/Y').' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Pago Seis: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['pagoSeis']).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de pago Seis: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($info['fechaPagoSeis']), 'd/m/Y').' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Pago Siete: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['pagoSiete']).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de pago Siete: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($info['fechaPagoSiete']), 'd/m/Y').' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Pago Ocho: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['pagoOcho']).' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de pago Ocho: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($info['fechaPagoOcho']), 'd/m/Y').' </td>
                                </tr>
                            </tbody>
                        </table>
                        <hr style="border: 2px solid #EAC633;margin-bottom:30px;margin-top:30px;">';
            }
        }
        
        $mensaje = '
        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
        <html xmlns="http://www.w3.org/1999/xhtml">
        <head>
            <title>Email</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
            <style>
                body, tr, td, span, div, p, a, li {
                    -moz-text-size-adjust:none !important;
                    -webkit-text-size-adjust:none !important;
                    margin:0px !important;
                    -ms-text-size-adjust:none !important;
                    white-space: wrap;
                }
                .lato-light{
                    font-family: "lato" sans-serif !important;
                    font-weight: 300;
                }
                .lato-bold{
                    font-family: "lato" sans-serif !important;
                    font-weight: 700;
                }
                td img {
                    display: block;
                }
                .ReadMsgBody {
                    width: 100%;
                }
                .ExternalClass * {
                    line-height: 100%;
                }
                @media only screen and (max-width:480px) {
                    #logosim{
                        padding:0!important;
                    }
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 320px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
                @media only screen and (min-width:480px) and (max-width:599px) {
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 480px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
            </style>
        </head>
        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
                <tr>
                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
                        <tr>
                            <td>
                                <a href="'.$liga3.'" target="_blank">
                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                                        <tr>
                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
                                                <img src="'.$urlLogoFracc.'" />
                                            </td>
                                        </tr>
                                    </table>
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
                                    <tr>
                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Notificación de depósitos </h3>
                                            <br><br>
                                            '.$cuerpo.'
                                        </td>
                                    </tr>
                                </table>
                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
                            </td>
                        </tr>
                    </td>
                </tr>
            </table>
        </body>
        </html>';
        
        //echo $mensaje;
        // para el promotor -------------------------------------------------
        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
        // Cabeceras adicionales
        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
        
        $contadores = "";
        $usuarios = $this->musuario->getAll();
        if ( !is_numeric($usuarios) ){
            foreach ($usuarios->result() as $key3 => $value3) {
                if ( $value3->rol == 7 ) { $contadores .= $value3->email.","; }
            }
            $contadores = trim($contadores, ',');
        }
        
        if ( $contadores != "" ) { 
            mail($contadores, $subject, $mensaje, $cabeceras);
        }
        
        $subject2 = $subject." ADMIN";
        
        // para el gerente  -------------------------------------------------
        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";
        
        // Cabeceras adicionales
        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
        
        // para el administrador
        mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);
        
        return true;
    }
    
    public function validacionEntrega()
    {
        $listadoEntrega = $this->maltaventa->getJoinEntrega2();
        if ( !is_numeric($listadoEntrega) ) {
            $arrayFraccionamiento = array();
            // echo "<pre>"; print_r($listadoEntrega->result()); echo "</pre>"; exit();
            foreach ($listadoEntrega->result() as $key => $value) {
                $createdEntrega = new DateTime($value->createdEntrega);
                $today = new DateTime();
                if ( $today->format("d-m-Y") == $createdEntrega->format("d-m-Y") ) {
                    if ( array_key_exists($value->idFraccionamiento, $arrayFraccionamiento) ) { 
                        $dAltaVenta = array(
                            "idAltaVenta" => $value->id,
                            "idProyecto" => $value->idProyecto,
                            "idProspecto" => $value->idProspecto,
                            "idPromotor" => $value->idPromotor,
                            "idFraccionamiento" => $value->idFraccionamiento,
                            "idGestoria" => $value->idGestoria,
                            "idEntrega" => $value->idEntrega
                        );
                        array_push($arrayFraccionamiento[$value->idFraccionamiento], $dAltaVenta); 
                    }
                    else { 
                        $dAltaVenta = array(
                            "idAltaVenta" => $value->id,
                            "idProyecto" => $value->idProyecto,
                            "idProspecto" => $value->idProspecto,
                            "idPromotor" => $value->idPromotor,
                            "idFraccionamiento" => $value->idFraccionamiento,
                            "idGestoria" => $value->idGestoria,
                            "idEntrega" => $value->idEntrega
                        );
                        $arrayFraccionamiento[$value->idFraccionamiento] = [$dAltaVenta]; 
                    }
                }
            }
            // echo "<pre>"; print_r($arrayFraccionamiento); echo "</pre>"; exit();
            $response['mail'] = (count($arrayFraccionamiento)>0)?$this->autoRespuestaEntrega($arrayFraccionamiento):false;
        }
        else {
            $response['mail'] = 0;
        }
        echo json_encode($response);
    }
    
    function autoRespuestaEntrega( $fraccionamientos = null ) {
        /*$copiasNV = "sistemas@viviend.mx, ";
        $copiasNV .= "ruben@navegantes.mx";*/

        $copiasNV = 'hsalinas@viviend.mx'. ', ';
        $copiasNV .= 'esalinas@viviend.mx'. ', ';
        $copiasNV .= 'mejora@viviend.mx'. ', ';
        $copiasNV .= 'sistemas@viviend.mx';
        
        $subject = 'Notificación de Entrega | Entrega de vivienda';
        $cuerpo = '';
        
        $liga="http://viviend.mx/sistema/emailresources/";
        $liga2="http://viviend.mx/sistema/img/";
        $liga3="http://viviend.mx/sistema/";
        $urlLogoFracc = 'http://viviend.mx/sistema/img/logo-300.png';
        
        
        foreach ($fraccionamientos as $key1 => $value1) {
            $nomFraccionamiento = $this->mfraccionamiento->getCampo('titulo',$key1);
            $cuerpo .= '<h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:18px;margin-bottom: 0px;"> '.$nomFraccionamiento.' </h4>';
            foreach ($value1 as $key2 => $value2) {
                $info = $this->maltaventa->getByIdForGestoria($value2['idAltaVenta']);
                $entrega = $this->mentrega->getByIdAltaVenta($value2['idEntrega']);
                
                $nomPromotor = $this->musuario->getCampo('nombre',$value2['idPromotor'])." ";
                $nomPromotor .= $this->musuario->getCampo('apellidoP',$value2['idPromotor'])." ";
                $nomPromotor .= $this->musuario->getCampo('apellidoM',$value2['idPromotor']);
                
                /*-----------------------------------------------------------------------------------------------------------------------------------------*/
                $cuerpo = '
                        <table id="table-blackboard" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
                            <thead>
                                <tr>
                                    <th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">CUANDO SEA EN NOTARIA</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> LOTE: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['lote'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> MANZANA: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['manzana'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NÚMERO OFICIAL: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['nOficial'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> CALLE: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['calle'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NOMBRES: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['nombre'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> APELLIDO PATERNO: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['apellidoP'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> APELLIDO MATERNO: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['apellidoM'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> RFC: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['rfc'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> TELÉFONO: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['telefono'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NSS: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['nss'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> FECHA DE NACIMIENTO: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($info['fechaNac']), 'd/m/Y').' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> ESTATUS: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['statusProyecto'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> PROMOTOR: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nomPromotor.' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> FECHA ENTREGA: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($entrega['fechaEntrega']), 'd/m/Y').' </td>
                                </tr>
                            </tbody>
                        </table>
                        <hr style="border: 2px solid #EAC633;margin-bottom:30px;margin-top:30px;">';
            }
        }
        
        
        $mensaje = '
        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
        <html xmlns="http://www.w3.org/1999/xhtml">
        <head>
            <title>Email</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
            <style>
                body, tr, td, span, div, p, a, li {
                    -moz-text-size-adjust:none !important;
                    -webkit-text-size-adjust:none !important;
                    margin:0px !important;
                    -ms-text-size-adjust:none !important;
                    white-space: wrap;
                }
                .lato-light{
                    font-family: "lato" sans-serif !important;
                    font-weight: 300;
                }
                .lato-bold{
                    font-family: "lato" sans-serif !important;
                    font-weight: 700;
                }
                td img {
                    display: block;
                }
                .ReadMsgBody {
                    width: 100%;
                }
                .ExternalClass * {
                    line-height: 100%;
                }
                @media only screen and (max-width:480px) {
                    #logosim{
                        padding:0!important;
                    }
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 320px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
                @media only screen and (min-width:480px) and (max-width:599px) {
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 480px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
            </style>
        </head>
        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
                <tr>
                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
                        <tr>
                            <td>
                                <a href="'.$liga3.'" target="_blank">
                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                                        <tr>
                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
                                                <img width="280" src="'.$urlLogoFracc.'" />
                                            </td>
                                        </tr>
                                    </table>
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
                                    <tr>
                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Notificación de entrega de vivienda </h3>
                                            <br><br>
                                            '.$cuerpo.'
                                        </td>
                                    </tr>
                                </table>
                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
                            </td>
                        </tr>
                    </td>
                </tr>
            </table>
        </body>
        </html>';
        
        
        // para el gerente de ventas -------------------------------------------------
        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
        // Cabeceras adicionales
        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
        
        
        $gestores = "";
        $gerentes = "";
        $contadores = "";
        $usuarios = $this->musuario->getAll();
        if ( !is_numeric($usuarios) ){
            foreach ($usuarios->result() as $key3 => $value3) {
                if ( $value3->rol == 3 ) { $gestores .= $value3->email.","; }
                if ( $value3->rol == 4 ) { $gerentes .= $value3->email.","; }
                if ( $value3->rol == 7 ) { $contadores .= $value3->email.","; }
            }
            $gestores = trim($gestores, ',');
            $gerentes = trim($gerentes, ',');
            $contadores = trim($contadores, ',');
        }
        
        if ( $gestores != "" ) { 
            mail($gestores, $subject, $mensaje, $cabeceras);
        }
        if ( $gerentes != "" ) { 
            mail($gerentes, $subject, $mensaje, $cabeceras);
        }
        if ( $contadores != "" ) { 
            mail($contadores, $subject, $mensaje, $cabeceras);
        }
        
        
        // para el administrador  -------------------------------------------------
        $subject2 = $subject." | Admin";

        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";
        // Cabeceras adicionales
        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

        // para el administrador
        mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);

        return true;
    }
    
    public function validacionPostventa()
    {
        $listadoPostventa = $this->maltaventa->getJoinPostventa2();
        if ( !is_numeric($listadoPostventa) ) {
            $arrayFraccionamiento = array();
            // echo "<pre>"; print_r($listadoPostventa->result()); echo "</pre>"; exit();
            foreach ($listadoPostventa->result() as $key => $value) {
                $createdPostventa = new DateTime($value->createdPostventa);
                $today = new DateTime();
                if ( $today->format("d-m-Y") == $createdPostventa->format("d-m-Y") ) {
                    if ( array_key_exists($value->idFraccionamiento, $arrayFraccionamiento) ) { 
                        $dAltaVenta = array(
                            "idAltaVenta" => $value->id,
                            "idProyecto" => $value->idProyecto,
                            "idProspecto" => $value->idProspecto,
                            "idPromotor" => $value->idPromotor,
                            "idFraccionamiento" => $value->idFraccionamiento,
                            "idGestoria" => $value->idGestoria,
                            "idPostventa" => $value->idPostventa
                        );
                        array_push($arrayFraccionamiento[$value->idFraccionamiento], $dAltaVenta); 
                    }
                    else { 
                        $dAltaVenta = array(
                            "idAltaVenta" => $value->id,
                            "idProyecto" => $value->idProyecto,
                            "idProspecto" => $value->idProspecto,
                            "idPromotor" => $value->idPromotor,
                            "idFraccionamiento" => $value->idFraccionamiento,
                            "idGestoria" => $value->idGestoria,
                            "idPostventa" => $value->idPostventa
                        );
                        $arrayFraccionamiento[$value->idFraccionamiento] = [$dAltaVenta]; 
                    }
                }
            }
            // echo "<pre>"; print_r($arrayFraccionamiento); echo "</pre>"; exit();
            $response['mail'] = (count($arrayFraccionamiento)>0)?$this->autoRespuestaPostventa($arrayFraccionamiento):false;
        }
        else {
            $response['mail'] = 0;
        }
        echo json_encode($response);
    }
    
    function autoRespuestaPostventa( $fraccionamientos = null ) {
        /*$copiasNV = "sistemas@viviend.mx, ";
        $copiasNV .= "ruben@navegantes.mx";*/

        $copiasNV = 'hsalinas@viviend.mx'. ', ';
        $copiasNV .= 'esalinas@viviend.mx'. ', ';
        $copiasNV .= 'mejora@viviend.mx'. ', ';
        $copiasNV .= 'sistemas@viviend.mx';
        
        $subject = 'Notificación de Postventa | Postventa';
        $cuerpo = '';
        
        $liga="http://viviend.mx/sistema/emailresources/";
        $liga2="http://viviend.mx/sistema/img/";
        $liga3="http://viviend.mx/sistema/";
        $urlLogoFracc = 'http://viviend.mx/sistema/img/logo-300.png';
        
        
        foreach ($fraccionamientos as $key1 => $value1) {
            $nomFraccionamiento = $this->mfraccionamiento->getCampo('titulo',$key1);
            $cuerpo .= '<h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:18px;margin-bottom: 0px;"> '.$nomFraccionamiento.' </h4>';
            foreach ($value1 as $key2 => $value2) {
                $info = $this->maltaventa->getByIdForPostventa($value2['idAltaVenta']);
                $postventa = $this->mpostventa->getByIdAltaVenta($value2['idAltaVenta']);
                
                $nomPromotor = $this->musuario->getCampo('nombre',$value2['idPromotor'])." ";
                $nomPromotor .= $this->musuario->getCampo('apellidoP',$value2['idPromotor'])." ";
                $nomPromotor .= $this->musuario->getCampo('apellidoM',$value2['idPromotor']);
                
                /*-----------------------------------------------------------------------------------------------------------------------------------------*/
                $cuerpo = '
                        <table id="table-blackboard" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
                            <thead>
                                <tr>
                                    <th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">CUANDO SEA EN NOTARIA</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> LOTE: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['lote'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> MANZANA: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['manzana'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NÚMERO OFICIAL: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['nOficial'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> CALLE: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['calle'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NOMBRES: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['nombre'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> APELLIDO PATERNO: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['apellidoP'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> APELLIDO MATERNO: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['apellidoM'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> RFC: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['rfc'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> TELÉFONO: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['telefono'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NSS: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['nss'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> FECHA DE NACIMIENTO: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($info['fechaNac']), 'd/m/Y').' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> ESTATUS: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['statusProyecto'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> PROMOTOR: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nomPromotor.' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> FECHA ENTREGA: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($info['fechaEntrega']), 'd/m/Y').' </td>
                                </tr>
                            </tbody>
                        </table>';
                
                /*-----------------------------------------------------------------------------------------------------------------------------------------*/
                $cuerpo .= '
                        <table id="table-blackboard" style="width: 80%;margin: 50px auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
                            <thead>
                                <tr>
                                    <th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">GARANTÍAS</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> INST. ELÉCTRICAS: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($postventa['instElectricas']), 'd/m/Y').' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> INST. HIDRÁULICAS: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($postventa['instHidraulicas']), 'd/m/Y').' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> INST. SANITARIAS: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($postventa['instSanitarias']), 'd/m/Y').' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> INST. GAS: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($postventa['instGas']), 'd/m/Y').' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> CANCELERÍA: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$postventa['canceleria'].' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> IMPERMEABILIZACION: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($postventa['impermeabilizacion']), 'd/m/Y').' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> ACABADOS: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($postventa['acabados']), 'd/m/Y').' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> ESTRUCTURAL: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($postventa['estructural']), 'd/m/Y').' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> ACCESORIOS: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($postventa['accesorios']), 'd/m/Y').' </td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> CALENTADOR AGUA: </td>
                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($postventa['calentadorAgua']), 'd/m/Y').' </td>
                                </tr>
                            </tbody>
                        </table>
                        <hr style="border: 2px solid #EAC633;margin-bottom:30px;margin-top:30px;">';
            }
        }
        
        $mensaje = '
        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
        <html xmlns="http://www.w3.org/1999/xhtml">
        <head>
            <title>Email</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
            <style>
                body, tr, td, span, div, p, a, li {
                    -moz-text-size-adjust:none !important;
                    -webkit-text-size-adjust:none !important;
                    margin:0px !important;
                    -ms-text-size-adjust:none !important;
                    white-space: wrap;
                }
                .lato-light{
                    font-family: "lato" sans-serif !important;
                    font-weight: 300;
                }
                .lato-bold{
                    font-family: "lato" sans-serif !important;
                    font-weight: 700;
                }
                td img {
                    display: block;
                }
                .ReadMsgBody {
                    width: 100%;
                }
                .ExternalClass * {
                    line-height: 100%;
                }
                @media only screen and (max-width:480px) {
                    #logosim{
                        padding:0!important;
                    }
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 320px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
                @media only screen and (min-width:480px) and (max-width:599px) {
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 480px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
            </style>
        </head>
        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
                <tr>
                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
                        <tr>
                            <td>
                                <a href="'.$liga3.'" target="_blank">
                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                                        <tr>
                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
                                                <img src="'.$urlLogoFracc.'" />
                                            </td>
                                        </tr>
                                    </table>
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
                                    <tr>
                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Notificación de Postventa </h3>
                                            <br><br>
                                            '.$cuerpo.'
                                        </td>
                                    </tr>
                                </table>
                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
                            </td>
                        </tr>
                    </td>
                </tr>
            </table>
        </body>
        </html>';
        
        
        // para el gerente de ventas -------------------------------------------------
        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
        // Cabeceras adicionales
        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
        
        
        $gestores = "";
        $gerentes = "";
        $usuarios = $this->musuario->getAll();
        if ( !is_numeric($usuarios) ){
            foreach ($usuarios->result() as $key3 => $value3) {
                if ( $value3->rol == 3 ) { $gestores .= $value3->email.","; }
                if ( $value3->rol == 4 ) { $gerentes .= $value3->email.","; }
            }
            $gestores = trim($gestores, ',');
            $gerentes = trim($gerentes, ',');
        }
        
        if ( $gestores != "" ) { 
            mail($gestores, $subject, $mensaje, $cabeceras);
        }
        if ( $gerentes != "" ) { 
            mail($gerentes, $subject, $mensaje, $cabeceras);
        }
        
        
        $subject2 = $subject." | Admin";
        
        // para el administrador  -------------------------------------------------
        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";
        // Cabeceras adicionales
        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
        
        // para el administrador
        mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);
        
        return true;
    }

    public function vencimientoCaptacion(){
        $listadoPromotores = $this->mprospecto->getPromotoresCaptacion();//obtenemos prospectos junto con idPromotor asociado

        if(!is_numeric($listadoPromotores)){
            $arrayPromotores = array();
            foreach ($listadoPromotores->result() as $value) {
                if(time() - strtotime($value->fechaAsignacion) > 60*60*24) {// indeica que hay un dia de retraso
                        if ( array_key_exists($value->idPromotor, $arrayPromotores) ) { array_push($arrayPromotores[$value->idPromotor], $value->id); }
                        else { $arrayPromotores[$value->idPromotor] = [$value->id]; }
                }else{
                    //echo "no ha pasado un día";
                }
            }

            if (count($arrayPromotores)>0){
                $autoResp = $this->autoRespuestaCaptacion($arrayPromotores);
                //echo $autoResp;
            }
        }

/*        echo "<pre>";
        print_r($arrayPromotores);
        echo "</pre>";
        exit();*/

        //$hoy = getdate();
        //print_r($hoy);
    }

    function autoRespuestaCaptacion($promotores = null){
        $copiasNV = 'hsalinas@viviend.mx'. ', ';
        $copiasNV .= 'esalinas@viviend.mx'. ', ';
        $copiasNV .= 'mejora@viviend.mx'. ', ';
        $copiasNV .= 'sistemas@viviend.mx';
        
        $subject = 'Vencimiento Captación | '.date("d-m-Y H:i"); // titulo
        $cuerpo = '';
        
        $liga="http://viviend.mx/sistema/emailresources/";
        $liga2="http://viviend.mx/sistema/img/";
        $liga3="http://viviend.mx/sistema/";
        
        $urlLogoFracc = 'http://viviend.mx/sistema/img/logo-300.png';

        if (count($promotores) && $promotores!=null){
            foreach ($promotores as $key => $value1) {
                $nomPromotor = $this->musuario->getCampo('nombre',$key)." ".$this->musuario->getCampo('apellidoP',$key);
                $cuerpo .= '<h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:18px;margin-bottom: 0px;"> '.$nomPromotor.' </h4>';
                foreach ($value1 as $key2 => $value2) {
                    $dProspecto = $this->mprospecto->getById($value2);
                    if ( !is_numeric($dProspecto) ) {
                        $promotor = $this->musuario->getById($dProspecto['idPromotor']);
                        $nomPromotor = $promotor["nombre"]." ".$promotor["apellidoP"]." ".$promotor["apellidoM"];
                        $prototipo = ($dProspecto['idPrototipo']>0)?$this->mprototipos->getCampo('nombre', $dProspecto['idPrototipo']):'';
                        $nomFraccionamiento = ($dProspecto['idFraccionamiento']>0)?$this->mfraccionamiento->getCampo('titulo',$dProspecto['idFraccionamiento']):'';

                        //Actualizamos el campo notificacion recopliación a  1 para indicar que hemos enviado la notificacion de vencimiento de captacion (parte 1)
                        $pData['notificacionRecopilacion'] = 1;
                        $this->mprospecto->actualizar($pData, $dProspecto['id']);
                        
                        $cuerpo .= '
                                    <table id="table-prospecto" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;margin-bottom: 30px;">
                                        <tbody>
                                        <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de asignación: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($dProspecto['fechaAsignacion']), 'd/m/Y H:i').' </td>
                                            </tr>
                                            <!--<tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de prospección: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($dProspecto['fecha']), 'd/m/Y').' </td>
                                            </tr>-->
                                            <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Nombre de prospecto: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['nombre'].' '.$dProspecto['apellidoP'].' '.$dProspecto['apellidoM'].' </td>
                                            </tr>
                                            <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> RFC: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['rfc'].' </td>
                                            </tr>
                                            <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Teléfono: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['telefono'].' </td>
                                            </tr>
                                            <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NSS: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['nss'].' </td>
                                            </tr>
                                            <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de nacimiento: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($dProspecto['fechaNac']), 'd/m/Y').' </td>
                                            </tr>
                                            <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Status prospecto: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['statusProspecto'].' </td>
                                            </tr>
                                            <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Lugar de prospección: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['lugarProspeccion'].' </td>
                                            </tr>
                                            <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Interesado en fraccionamiento: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nomFraccionamiento.' </td>
                                            </tr>
                                            <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Promotor: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nomPromotor.' </td>
                                            </tr>
                                            <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Prototipo: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prototipo.' </td>
                                            </tr>
                                            <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Comentarios: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['comentario'].' </td>
                                            </tr>
                                        </tbody>
                                    </table>';
                    }
                }


            }

        $mensaje = '
        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
        <html xmlns="http://www.w3.org/1999/xhtml">
        <head>
            <title>Email</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
            <style>
                body, tr, td, span, div, p, a, li {
                    -moz-text-size-adjust:none !important;
                    -webkit-text-size-adjust:none !important;
                    margin:0px !important;
                    -ms-text-size-adjust:none !important;
                    white-space: wrap;
                }
                .lato-light{
                    font-family: "lato" sans-serif !important;
                    font-weight: 300;
                }
                .lato-bold{
                    font-family: "lato" sans-serif !important;
                    font-weight: 700;
                }
                td img {
                    display: block;
                }
                .ReadMsgBody {
                    width: 100%;
                }
                .ExternalClass * {
                    line-height: 100%;
                }

                table#table-prospecto td:nth-child(1) {
                    width: 50%;
                    padding-left: 10px;
                }
                table#table-prospecto td:nth-child(2) {
                    width: 50%;
                    padding-left: 10px;
                }

                @media only screen and (max-width:480px) {
                    #logosim{
                        padding:0!important;
                    }
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 320px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
                @media only screen and (min-width:480px) and (max-width:599px) {
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 480px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
            </style>
        </head>
        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
                <tr>
                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
                        <tr>
                            <td>
                                <a href="'.$liga3.'" target="_blank">
                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                                        <tr>
                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
                                                <img width="280" src="'.$urlLogoFracc.'" />
                                            </td>
                                        </tr>
                                    </table>
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
                                    <tr>
                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Vencimiento de Captación </h3>
                                            <br><br>
                                            '.$cuerpo.'
                                        </td>
                                    </tr>
                                </table>
                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
                            </td>
                        </tr>
                    </td>
                </tr>
            </table>
        </body>
        </html>';

        //echo $mensaje;

        // para el gerente de ventas -------------------------------------------------
        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
        // Cabeceras adicionales
        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
        
        $gerentes = "";
        $gestores = "";
        $usuarios = $this->musuario->getAll();
        if ( !is_numeric($usuarios) ){
            foreach ($usuarios->result() as $key3 => $value3) {
                if ( $value3->rol == 3 ) { $gestores .= $value3->email.","; }
                if ( $value3->rol == 4 ) { $gerentes .= $value3->email.","; }
            }
            $gestores = trim($gestores, ',');
            $gerentes = trim($gerentes, ',');
        }
        
        if ( $gerentes != "" ) { 
            mail($gerentes, $subject, $mensaje, $cabeceras);
        }
        if ( $gestores != "" ) { 
            //mail($gestores, $subject, $mensaje, $cabeceras);
        }
        
        $subject2 = $subject;

        // para el gerente  -------------------------------------------------
        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";
        // Cabeceras adicionales
        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
        
        // para el administrador
        mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);

        return true;


        }
            
    }

    public function vencimientoRecopilacion(){
        $listadoPromotores = $this->mprospecto->getPromotoresCaptacion(1); //notificacionRecopilacion 1 indica que únicmanete se envió la notificacion de vencimiento de captacion
/*echo "<pre>";
        print_r($listadoPromotores->result());
echo "</pre>";
        exit();*/

        if(!is_numeric($listadoPromotores)){
            $arrayPromotores = array();
            foreach ($listadoPromotores->result() as $value) {
                if(time() - strtotime($value->fechaCita." ".$value->horaAtencion) > 60*60*24) {// indica que hay un dia de retraso
                    //echo "paso un dia";exit();
                        if ( array_key_exists($value->idPromotor, $arrayPromotores) ) { array_push($arrayPromotores[$value->idPromotor], $value->id); }
                        else { $arrayPromotores[$value->idPromotor] = [$value->id]; }
                }else{
                    //echo "no ha pasado un día"; exit();
                }
            }

            if (count($arrayPromotores)>0){
                //print_r($arrayPromotores);exit();
                $autoResp = $this->autoRespuestaRecopilacion($arrayPromotores);
                //echo $autoResp;
            }
        }
    }

    function autoRespuestaRecopilacion($promotores = null){
        $copiasNV = 'hsalinas@viviend.mx'. ', ';
        $copiasNV .= 'esalinas@viviend.mx'. ', ';
        $copiasNV .= 'mejora@viviend.mx'. ', ';
        $copiasNV .= 'sistemas@viviend.mx';
        
        $subject = 'Vencimiento Para Recopilación | '.date("d-m-Y H:i"); // titulo
        $cuerpo = '';
        
        $liga="http://viviend.mx/sistema/emailresources/";
        $liga2="http://viviend.mx/sistema/img/";
        $liga3="http://viviend.mx/sistema/";
        
        $urlLogoFracc = 'http://viviend.mx/sistema/img/logo-300.png';

        if (count($promotores) && $promotores!=null){
            foreach ($promotores as $key => $value1) {
                $nomPromotor = $this->musuario->getCampo('nombre',$key)." ".$this->musuario->getCampo('apellidoP',$key);
                $cuerpo .= '<h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:18px;margin-bottom: 0px;"> '.$nomPromotor.' </h4>';
                foreach ($value1 as $key2 => $value2) {
                    $dProspecto = $this->mprospecto->getById($value2);
                    if ( !is_numeric($dProspecto) ) {
                        $promotor = $this->musuario->getById($dProspecto['idPromotor']);
                        $nomPromotor = $promotor["nombre"]." ".$promotor["apellidoP"]." ".$promotor["apellidoM"];
                        $prototipo = ($dProspecto['idPrototipo']>0)?$this->mprototipos->getCampo('nombre', $dProspecto['idPrototipo']):'';
                        $nomFraccionamiento = ($dProspecto['idFraccionamiento']>0)?$this->mfraccionamiento->getCampo('titulo',$dProspecto['idFraccionamiento']):'';

                        //Actualizamos el campo notificacion recopliación a 2 para indicar que hemos enviado la notificacion de vencimiento recopilacion (parte 2)
                        $pData['notificacionRecopilacion'] = 2;
                        $this->mprospecto->actualizar($pData, $dProspecto['id']);
                        
                        $cuerpo .= '
                                    <table id="table-prospecto" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;margin-bottom: 30px;">
                                        <tbody>
                                            <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de Cita: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($dProspecto['fechaCita']), 'd/m/Y').' </td>
                                            </tr>
                                            <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Hora de Atención: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['horaAtencion'].' </td>
                                            </tr>
                                            <!--<tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de prospección: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($dProspecto['fecha']), 'd/m/Y').' </td>
                                            </tr>-->
                                            <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Nombre de prospecto: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['nombre'].' '.$dProspecto['apellidoP'].' '.$dProspecto['apellidoM'].' </td>
                                            </tr>
                                            <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> RFC: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['rfc'].' </td>
                                            </tr>
                                            <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Teléfono: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['telefono'].' </td>
                                            </tr>
                                            <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NSS: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['nss'].' </td>
                                            </tr>
                                            <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de nacimiento: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($dProspecto['fechaNac']), 'd/m/Y').' </td>
                                            </tr>
                                            <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Status prospecto: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['statusProspecto'].' </td>
                                            </tr>
                                            <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Lugar de prospección: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['lugarProspeccion'].' </td>
                                            </tr>
                                            <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Interesado en fraccionamiento: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nomFraccionamiento.' </td>
                                            </tr>
                                            <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Promotor: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nomPromotor.' </td>
                                            </tr>
                                            <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Prototipo: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prototipo.' </td>
                                            </tr>
                                            <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Comentarios: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['comentario'].' </td>
                                            </tr>
                                        </tbody>
                                    </table>';
                    }
                }


            }

        $mensaje = '
        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
        <html xmlns="http://www.w3.org/1999/xhtml">
        <head>
            <title>Email</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
            <style>
                body, tr, td, span, div, p, a, li {
                    -moz-text-size-adjust:none !important;
                    -webkit-text-size-adjust:none !important;
                    margin:0px !important;
                    -ms-text-size-adjust:none !important;
                    white-space: wrap;
                }
                .lato-light{
                    font-family: "lato" sans-serif !important;
                    font-weight: 300;
                }
                .lato-bold{
                    font-family: "lato" sans-serif !important;
                    font-weight: 700;
                }
                td img {
                    display: block;
                }
                .ReadMsgBody {
                    width: 100%;
                }
                .ExternalClass * {
                    line-height: 100%;
                }

                table#table-prospecto td:nth-child(1) {
                    width: 50%;
                    padding-left: 10px;
                }
                table#table-prospecto td:nth-child(2) {
                    width: 50%;
                    padding-left: 10px;
                }

                @media only screen and (max-width:480px) {
                    #logosim{
                        padding:0!important;
                    }
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 320px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
                @media only screen and (min-width:480px) and (max-width:599px) {
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 480px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
            </style>
        </head>
        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
                <tr>
                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
                        <tr>
                            <td>
                                <a href="'.$liga3.'" target="_blank">
                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                                        <tr>
                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
                                                <img width="280" src="'.$urlLogoFracc.'" />
                                            </td>
                                        </tr>
                                    </table>
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
                                    <tr>
                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Vencimiento Para Recopilación </h3>
                                            <br><br>
                                            '.$cuerpo.'
                                        </td>
                                    </tr>
                                </table>
                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
                            </td>
                        </tr>
                    </td>
                </tr>
            </table>
        </body>
        </html>';

        //echo $mensaje;

        // para el gerente de ventas -------------------------------------------------
        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
        // Cabeceras adicionales
        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
        
        $gerentes = "";
        $gestores = "";
        $usuarios = $this->musuario->getAll();
        if ( !is_numeric($usuarios) ){
            foreach ($usuarios->result() as $key3 => $value3) {
                if ( $value3->rol == 3 ) { $gestores .= $value3->email.","; }
                if ( $value3->rol == 4 ) { $gerentes .= $value3->email.","; }
            }
            $gestores = trim($gestores, ',');
            $gerentes = trim($gerentes, ',');
        }
        
        if ( $gerentes != "" ) { 
            mail($gerentes, $subject, $mensaje, $cabeceras);
        }
        if ( $gestores != "" ) { 
            //mail($gestores, $subject, $mensaje, $cabeceras);
        }
        
        $subject2 = $subject;

        // para el gerente  -------------------------------------------------
        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";
        // Cabeceras adicionales
        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
        
        // para el administrador
        mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);

        return true;


        }
            
    }

    public function notificacionCita(){
        $listadoPromotores = $this->mprospecto->getPromotoresCaptacion(3);

        if(!is_numeric($listadoPromotores)){
            $arrayPromotores = array();

            $date = date('Y-m-d H:i', strtotime('-1 hour'));
            foreach ($listadoPromotores->result() as $value) {
                $fechaHoraCita = $value->fechaCita." ".$value->horaAtencion;
                $fechaHoraCita = strtotime($value->fechaCita." ".$value->horaAtencion);
                $date = date("Y-m-d H:i", strtotime('-1 hour',$fechaHoraCita));
                if (date("Y-m-d H:i") == $date){
                    //echo "hora igual";exit();
                    if ( array_key_exists($value->idPromotor, $arrayPromotores) ) { array_push($arrayPromotores[$value->idPromotor], $value->id); }
                        else { $arrayPromotores[$value->idPromotor] = [$value->id]; }
                }else{
                    //echo "hora no igual";exit();
                }

            }

            if (count($arrayPromotores)>0){
                $autoResp = $this->autoRespuestaCita($arrayPromotores);
                //echo $autoResp;
            }
        }

    }

    function autoRespuestaCita($promotores = null){
            $copiasNV = 'hsalinas@viviend.mx'. ', ';
            $copiasNV .= 'esalinas@viviend.mx'. ', ';
            $copiasNV .= 'sistemas@viviend.mx';
            
            $copiasNV = 'mercadotecnia@viviend.mx';

            $subject = 'Notificación de Cita | '.date("d-m-Y H:i"); // titulo
            
            $emailPromotores = '';

            // para el gerente de ventas -------------------------------------------------
            // Para enviar un correo HTML, debe establecerse la cabecera Content-type
            $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
            $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
            // Cabeceras adicionales
            $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
            
            $gerentes = "";
            $gestores = "";
            $usuarios = $this->musuario->getAll();
            if ( !is_numeric($usuarios) ){
                foreach ($usuarios->result() as $key3 => $value3) {
                    if ( $value3->rol == 3 ) { $gestores .= $value3->email.","; }
                    if ( $value3->rol == 4 ) { $gerentes .= $value3->email.","; }
                }
                $gestores = trim($gestores, ',');
                $gerentes = trim($gerentes, ',');
            }
            

            
            $subject2 = $subject;

            // para el gerente  -------------------------------------------------
            $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
            $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";
            // Cabeceras adicionales
            $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
            

            $liga="http://viviend.mx/sistema/emailresources/";
            $liga2="http://viviend.mx/sistema/img/";
            $liga3="http://viviend.mx/sistema/";
            
            $urlLogoFracc = 'http://viviend.mx/sistema/img/logo-300.png';

            if (count($promotores) && $promotores!=null){
                foreach ($promotores as $key => $value1) {
                    $cuerpo = '';
                    $nomPromotor = $this->musuario->getCampo('nombre',$key)." ".$this->musuario->getCampo('apellidoP',$key);
                    $cuerpo .= '<h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:18px;margin-bottom: 0px;"> '.$nomPromotor.' </h4>';
                    $emailPromotor = $this->musuario->getCampo('email',$key);
                    foreach ($value1 as $key2 => $value2) {
                        $dProspecto = $this->mprospecto->getById($value2);
                        if ( !is_numeric($dProspecto) ) {
                            $promotor = $this->musuario->getById($dProspecto['idPromotor']);
                            $nomPromotor = $promotor["nombre"]." ".$promotor["apellidoP"]." ".$promotor["apellidoM"];
                            $prototipo = ($dProspecto['idPrototipo']>0)?$this->mprototipos->getCampo('nombre', $dProspecto['idPrototipo']):'';
                            $nomFraccionamiento = ($dProspecto['idFraccionamiento']>0)?$this->mfraccionamiento->getCampo('titulo',$dProspecto['idFraccionamiento']):'';
                            
                            $cuerpo .= '
                                        <table id="table-prospecto" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;margin-bottom: 30px;">
                                            <tbody>
                                                <tr>
                                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha Cita: </td>
                                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($dProspecto['fechaCita']), 'd/m/Y').' </td>
                                                </tr>
                                                <tr>
                                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Hora de Atención: </td>
                                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['horaAtencion'].' </td>
                                                </tr>
                                                <!--<tr>
                                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de asignación: </td>
                                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($dProspecto['fechaAsignacion']), 'd/m/Y H:i').' </td>
                                                </tr>-->
                                                <!--<tr>
                                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de prospección: </td>
                                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($dProspecto['fecha']), 'd/m/Y').' </td>
                                                </tr>-->
                                                <tr>
                                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Nombre de prospecto: </td>
                                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['nombre'].' '.$dProspecto['apellidoP'].' '.$dProspecto['apellidoM'].' </td>
                                                </tr>
                                                <tr>
                                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> RFC: </td>
                                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['rfc'].' </td>
                                                </tr>
                                                <tr>
                                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Teléfono: </td>
                                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['telefono'].' </td>
                                                </tr>
                                                <tr>
                                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NSS: </td>
                                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['nss'].' </td>
                                                </tr>
                                                <tr>
                                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de nacimiento: </td>
                                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($dProspecto['fechaNac']), 'd/m/Y').' </td>
                                                </tr>
                                                <tr>
                                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Status prospecto: </td>
                                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['statusProspecto'].' </td>
                                                </tr>
                                                <tr>
                                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Lugar de prospección: </td>
                                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['lugarProspeccion'].' </td>
                                                </tr>
                                                <tr>
                                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Interesado en fraccionamiento: </td>
                                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nomFraccionamiento.' </td>
                                                </tr>
                                                <tr>
                                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Promotor: </td>
                                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nomPromotor.' </td>
                                                </tr>
                                                <tr>
                                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Prototipo: </td>
                                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prototipo.' </td>
                                                </tr>
                                                <tr>
                                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Comentarios: </td>
                                                    <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$dProspecto['comentario'].' </td>
                                                </tr>
                                            </tbody>
                                        </table>';
                        }
                    }

                    $mensaje = '
            <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
            <html xmlns="http://www.w3.org/1999/xhtml">
            <head>
                <title>Email</title>
                <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
                <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
                <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
                <style>
                    body, tr, td, span, div, p, a, li {
                        -moz-text-size-adjust:none !important;
                        -webkit-text-size-adjust:none !important;
                        margin:0px !important;
                        -ms-text-size-adjust:none !important;
                        white-space: wrap;
                    }
                    .lato-light{
                        font-family: "lato" sans-serif !important;
                        font-weight: 300;
                    }
                    .lato-bold{
                        font-family: "lato" sans-serif !important;
                        font-weight: 700;
                    }
                    td img {
                        display: block;
                    }
                    .ReadMsgBody {
                        width: 100%;
                    }
                    .ExternalClass * {
                        line-height: 100%;
                    }

                    table#table-prospecto td:nth-child(1) {
                        width: 50%;
                        padding-left: 10px;
                    }
                    table#table-prospecto td:nth-child(2) {
                        width: 50%;
                        padding-left: 10px;
                    }

                    @media only screen and (max-width:480px) {
                        #logosim{
                            padding:0!important;
                        }
                        *[class="code4email_wrapper"] {
                            width: 100% !important;
                        }
                        *[class="code4email_main_table"] {
                            width: 320px !important;
                        }
                        *[class="code4email_hide"] {
                            display: none !important;
                        }
                        *[class="code4email_hide"] {
                            display: none !important;
                        }
                        *[class="code4email_center"] {
                            text-align: center !important;
                            padding:10px !important;
                            height:20px !important;
                        }
                        *[class="code4email_clear"] {
                            width: 100% !important;
                            clear: both !important;
                            float: left !important;
                        }
                        *[class="code4email_br"] {
                            display:block !important;
                            width: 1px !important;
                            height:6px !important;
                            clear: both !important;
                        }
                        *[class="code4email_text_p10"] {
                            padding: 0px 10px 10px 10px !important;
                            height:20px !important;
                        }
                        *[class="code4email_w20"] {
                            width: 20px !important;
                        }
                        *[class="code4email_h20"] {
                            height: 20px !important;
                        }
                        *[class="code4email_h20_center"] {
                            height: 20px !important;
                            text-align: center !important;
                        }
                    }
                    @media only screen and (min-width:480px) and (max-width:599px) {
                        *[class="code4email_wrapper"] {
                            width: 100% !important;
                        }
                        *[class="code4email_main_table"] {
                            width: 480px !important;
                        }
                        *[class="code4email_hide"] {
                            display: none !important;
                        }
                        *[class="code4email_hide"] {
                            display: none !important;
                        }
                        *[class="code4email_center"] {
                            text-align: center !important;
                            padding:10px !important;
                            height:20px !important;
                        }
                        *[class="code4email_clear"] {
                            width: 100% !important;
                            clear: both !important;
                            float: left !important;
                        }
                        *[class="code4email_br"] {
                            display:block !important;
                            width: 1px !important;
                            height:6px !important;
                            clear: both !important;
                        }
                        *[class="code4email_text_p10"] {
                            padding: 0px 10px 10px 10px !important;
                            height:20px !important;
                        }
                        *[class="code4email_w20"] {
                            width: 20px !important;
                        }
                        *[class="code4email_h20"] {
                            height: 20px !important;
                        }
                        *[class="code4email_h20_center"] {
                            height: 20px !important;
                            text-align: center !important;
                        }
                    }
                </style>
            </head>
            <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
                <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                    <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
                    <tr>
                        <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
                            <tr>
                                <td>
                                    <a href="'.$liga3.'" target="_blank">
                                        <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                                            <tr>
                                                <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
                                                    <img width="280" src="'.$urlLogoFracc.'" />
                                                </td>
                                            </tr>
                                        </table>
                                    </a>
                                </td>
                            </tr>
                            <tr>
                                <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
                                    <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
                                        <tr>
                                            <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
                                                <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Notificación de Cita </h3>
                                                <br><br>
                                                '.$cuerpo.'
                                            </td>
                                        </tr>
                                    </table>
                                    <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
                                </td>
                            </tr>
                        </td>
                    </tr>
                </table>
            </body>
            </html>';

            //echo $mensaje;

                    //para el vendedor
                     mail($emailPromotor, $subject, $mensaje, $cabeceras);


                    if ( $gerentes != "" ) { 
                        mail($gerentes, $subject, $mensaje, $cabeceras);
                    }
                    if ( $gestores != "" ) { 
                        //mail($gestores, $subject, $mensaje, $cabeceras);
                    }

                    // para el administrador
                    mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);


                }


            return true;


            }
                
    }


    public function vencimientoSeguro(){
        $notifiacion = false;
        $activos = $this->mactivos->getAll(4);
        if (!is_numeric($activos)){
            $arrayResponsables = array();
            foreach ($activos->result() as $value) {
                $notifiacion = false;
                $date = $value->vigenciaPoliza;
                $newdate = strtotime ( '-30 day' , strtotime ( $date ) ) ; //notifiacion 30 dias antes
                $newdate = date ( 'Y-m-d' , $newdate );
                $cincoAntes = strtotime ( '-5 day' , strtotime ( $date ) ) ; //notifiacion 5 dias antes
                $cincoAntes = date ( 'Y-m-d' , $cincoAntes );
                $unoAntes = strtotime ( '-1 day' , strtotime ( $date ) ) ; //notifiacion 1 dias antes
                $unoAntes = date ( 'Y-m-d' , $unoAntes );

                if (date("Y-m-d") == $newdate){
                    $notifiacion = true;
                }if (date("Y-m-d") == $cincoAntes){
                    $notifiacion = true;
                }if (date("Y-m-d") == $unoAntes){
                    $notifiacion = true;
                }

                //if (date("Y-m-d") == $newdate){
                if ($notifiacion==true){
                    $responsableDeActivo = $this->mcartaasignacion->getByIdActivo($value->id);
                    if (!is_numeric($responsableDeActivo)){
                        $idUsuario = $responsableDeActivo['idUsuario'];
                         if ( array_key_exists($idUsuario, $arrayResponsables) ) { array_push($arrayResponsables[$idUsuario], $value->id); }
                        else { $arrayResponsables[$idUsuario] = [$value->id]; }
                    }else{
                        if ( array_key_exists(0, $arrayResponsables) ) { array_push($arrayResponsables[0], $value->id); }
                        else { $arrayResponsables[0] = [$value->id]; }

                    }

                    //echo "hoy toca mantenimiento";
                }else{
                    //echo "no es el dia";
                }

            }

            if (count($arrayResponsables)>0){
                $this->autoRespuestaSeguros($arrayResponsables);
            }

        }

    }

    function autoRespuestaSeguros($arrayResponsables=null){ //El parametro contiene al responsble con activos asignados
        //echo "<pre>";
        //print_r($arrayResponsables);
        //echo "</pre>";

        $copiasNV = 'hsalinas@viviend.mx'. ', ';
        $copiasNV .= 'esalinas@viviend.mx'. ', ';
        $copiasNV .= 'mejora@viviend.mx'. ', ';
        $copiasNV .= 'tramites@viviend.mx'. ', ';
        $copiasNV .= 'sistemas@viviend.mx';
        
        $subject = 'Vencimiento Seguro | '.date("d-m-Y H:i"); // titulo

        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
        // Cabeceras adicionales
        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

        $cuerpoAdmin = ''; // variable para envio a admin
        $liga="http://viviend.mx/sistema/emailresources/";
        $liga2="http://viviend.mx/sistema/img/";
        $liga3="http://viviend.mx/sistema/";
        
        $urlLogoFracc = 'http://viviend.mx/sistema/img/logo-300.png';

        foreach ($arrayResponsables as $key => $value) {
            //echo "responsable: ".$key;
            $cuerpo = ''; //para envio a responsables
            $nomPromotor = $this->musuario->getCampo('nombre',$key)." ".$this->musuario->getCampo('apellidoP',$key);
             $cuerpo .= '<h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:18px;margin-bottom: 0px;"> Responsable: '.$nomPromotor.' </h4>';
             $cuerpoAdmin .= '<h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:18px;margin-bottom: 0px;"> Responsable: '.$nomPromotor.' </h4>';
             $emailResponsable = $this->musuario->getCampo('email',$key);
             
            foreach ($value as $key2 => $value2) {
                //echo " Activo: ".$value2;
                $invInterno = $this->mactivos->getCampo('inventarioInterno',$value2);
                $serie = $this->mactivos->getCampo('serie',$value2);
                $marca = $this->mactivos->getCampo('marca',$value2);
                $modelo = $this->mactivos->getCampo('modelo',$value2);
                $anio = $this->mactivos->getCampo('anio',$value2);
                $placas = $this->mactivos->getCampo('placas',$value2);
                $vigenciaPoliza = $this->mactivos->getCampo('vigenciaPoliza',$value2);
                $vigenciaPoliza = date("d/m/Y", strtotime($vigenciaPoliza));
                    //$cuerpo .= '<br><h5 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:18px;margin-bottom: 0px;margin-top: 0px;"> '.$marca.' </h5>';
                    $cuerpo .= '
                                <table id="table-prospecto" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;margin-bottom: 30px;">
                                    <tbody>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Inventario Interno: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$invInterno.' </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Serie: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$serie.' </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Marca: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$marca.' </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Modelo: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$modelo.' </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Año: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$anio.' </td>
                                        </tr>
                                         <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Placas: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$placas.' </td>
                                        </tr>
                                         <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Vigencia Póliza: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$vigenciaPoliza.' </td>
                                        </tr>

                                    </tbody>
                                </table>';
                    $cuerpoAdmin .= '
                                <table id="table-prospecto" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;margin-bottom: 30px;">
                                    <tbody>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Inventario Interno: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$invInterno.' </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Serie: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$serie.' </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Marca: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$marca.' </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Modelo: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$modelo.' </td>
                                        </tr>
                                        <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Año: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$anio.' </td>
                                        </tr>
                                         <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Placas: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$placas.' </td>
                                        </tr>
                                         <tr>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Vigencia Póliza: </td>
                                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$vigenciaPoliza.' </td>
                                        </tr>

                                    </tbody>
                                </table>';


            }//termina segundo foreach
            //echo "<br><br>";
            //$cuerpo .= "<hr style='color:#57BA7A'>";

            //mensaje que se le envía a cada responsable
            $mensaje = '
            <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
            <html xmlns="http://www.w3.org/1999/xhtml">
            <head>
                <title>Email</title>
                <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
                <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
                <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
                <style>
                    body, tr, td, span, div, p, a, li {
                        -moz-text-size-adjust:none !important;
                        -webkit-text-size-adjust:none !important;
                        margin:0px !important;
                        -ms-text-size-adjust:none !important;
                        white-space: wrap;
                    }
                    .lato-light{
                        font-family: "lato" sans-serif !important;
                        font-weight: 300;
                    }
                    .lato-bold{
                        font-family: "lato" sans-serif !important;
                        font-weight: 700;
                    }
                    td img {
                        display: block;
                    }
                    .ReadMsgBody {
                        width: 100%;
                    }
                    .ExternalClass * {
                        line-height: 100%;
                    }

                    table#table-prospecto td:nth-child(1) {
                        width: 50%;
                        padding-left: 10px;
                    }
                    table#table-prospecto td:nth-child(2) {
                        width: 50%;
                        padding-left: 10px;
                    }

                    @media only screen and (max-width:480px) {
                        #logosim{
                            padding:0!important;
                        }
                        *[class="code4email_wrapper"] {
                            width: 100% !important;
                        }
                        *[class="code4email_main_table"] {
                            width: 320px !important;
                        }
                        *[class="code4email_hide"] {
                            display: none !important;
                        }
                        *[class="code4email_hide"] {
                            display: none !important;
                        }
                        *[class="code4email_center"] {
                            text-align: center !important;
                            padding:10px !important;
                            height:20px !important;
                        }
                        *[class="code4email_clear"] {
                            width: 100% !important;
                            clear: both !important;
                            float: left !important;
                        }
                        *[class="code4email_br"] {
                            display:block !important;
                            width: 1px !important;
                            height:6px !important;
                            clear: both !important;
                        }
                        *[class="code4email_text_p10"] {
                            padding: 0px 10px 10px 10px !important;
                            height:20px !important;
                        }
                        *[class="code4email_w20"] {
                            width: 20px !important;
                        }
                        *[class="code4email_h20"] {
                            height: 20px !important;
                        }
                        *[class="code4email_h20_center"] {
                            height: 20px !important;
                            text-align: center !important;
                        }
                    }
                    @media only screen and (min-width:480px) and (max-width:599px) {
                        *[class="code4email_wrapper"] {
                            width: 100% !important;
                        }
                        *[class="code4email_main_table"] {
                            width: 480px !important;
                        }
                        *[class="code4email_hide"] {
                            display: none !important;
                        }
                        *[class="code4email_hide"] {
                            display: none !important;
                        }
                        *[class="code4email_center"] {
                            text-align: center !important;
                            padding:10px !important;
                            height:20px !important;
                        }
                        *[class="code4email_clear"] {
                            width: 100% !important;
                            clear: both !important;
                            float: left !important;
                        }
                        *[class="code4email_br"] {
                            display:block !important;
                            width: 1px !important;
                            height:6px !important;
                            clear: both !important;
                        }
                        *[class="code4email_text_p10"] {
                            padding: 0px 10px 10px 10px !important;
                            height:20px !important;
                        }
                        *[class="code4email_w20"] {
                            width: 20px !important;
                        }
                        *[class="code4email_h20"] {
                            height: 20px !important;
                        }
                        *[class="code4email_h20_center"] {
                            height: 20px !important;
                            text-align: center !important;
                        }
                    }
                </style>
            </head>
            <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
                <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                    <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
                    <tr>
                        <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
                            <tr>
                                <td>
                                    <a href="'.$liga3.'" target="_blank">
                                        <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                                            <tr>
                                                <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
                                                    <img width="280" src="'.$urlLogoFracc.'" />
                                                </td>
                                            </tr>
                                        </table>
                                    </a>
                                </td>
                            </tr>
                            <tr>
                                <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
                                    <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
                                        <tr>
                                            <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
                                                <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Vencimiento de Seguro </h3>
                                                <br><br>
                                                '.$cuerpo.'
                                            </td>
                                        </tr>
                                    </table>
                                    <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
                                </td>
                            </tr>
                        </td>
                    </tr>
                </table>
            </body>
            </html>';

            //echo $mensaje;

            if ( $emailResponsable != "" ) { 
                mail($emailResponsable, $subject, $mensaje, $cabeceras);
            }

        }//termina primer foreach

            //mensaje que se le envia al admin incluye todas las notificaciones de cada responsable
            $mensaje2 = '
            <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
            <html xmlns="http://www.w3.org/1999/xhtml">
            <head>
                <title>Email</title>
                <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
                <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
                <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
                <style>
                    body, tr, td, span, div, p, a, li {
                        -moz-text-size-adjust:none !important;
                        -webkit-text-size-adjust:none !important;
                        margin:0px !important;
                        -ms-text-size-adjust:none !important;
                        white-space: wrap;
                    }
                    .lato-light{
                        font-family: "lato" sans-serif !important;
                        font-weight: 300;
                    }
                    .lato-bold{
                        font-family: "lato" sans-serif !important;
                        font-weight: 700;
                    }
                    td img {
                        display: block;
                    }
                    .ReadMsgBody {
                        width: 100%;
                    }
                    .ExternalClass * {
                        line-height: 100%;
                    }

                    table#table-prospecto td:nth-child(1) {
                        width: 50%;
                        padding-left: 10px;
                    }
                    table#table-prospecto td:nth-child(2) {
                        width: 50%;
                        padding-left: 10px;
                    }

                    @media only screen and (max-width:480px) {
                        #logosim{
                            padding:0!important;
                        }
                        *[class="code4email_wrapper"] {
                            width: 100% !important;
                        }
                        *[class="code4email_main_table"] {
                            width: 320px !important;
                        }
                        *[class="code4email_hide"] {
                            display: none !important;
                        }
                        *[class="code4email_hide"] {
                            display: none !important;
                        }
                        *[class="code4email_center"] {
                            text-align: center !important;
                            padding:10px !important;
                            height:20px !important;
                        }
                        *[class="code4email_clear"] {
                            width: 100% !important;
                            clear: both !important;
                            float: left !important;
                        }
                        *[class="code4email_br"] {
                            display:block !important;
                            width: 1px !important;
                            height:6px !important;
                            clear: both !important;
                        }
                        *[class="code4email_text_p10"] {
                            padding: 0px 10px 10px 10px !important;
                            height:20px !important;
                        }
                        *[class="code4email_w20"] {
                            width: 20px !important;
                        }
                        *[class="code4email_h20"] {
                            height: 20px !important;
                        }
                        *[class="code4email_h20_center"] {
                            height: 20px !important;
                            text-align: center !important;
                        }
                    }
                    @media only screen and (min-width:480px) and (max-width:599px) {
                        *[class="code4email_wrapper"] {
                            width: 100% !important;
                        }
                        *[class="code4email_main_table"] {
                            width: 480px !important;
                        }
                        *[class="code4email_hide"] {
                            display: none !important;
                        }
                        *[class="code4email_hide"] {
                            display: none !important;
                        }
                        *[class="code4email_center"] {
                            text-align: center !important;
                            padding:10px !important;
                            height:20px !important;
                        }
                        *[class="code4email_clear"] {
                            width: 100% !important;
                            clear: both !important;
                            float: left !important;
                        }
                        *[class="code4email_br"] {
                            display:block !important;
                            width: 1px !important;
                            height:6px !important;
                            clear: both !important;
                        }
                        *[class="code4email_text_p10"] {
                            padding: 0px 10px 10px 10px !important;
                            height:20px !important;
                        }
                        *[class="code4email_w20"] {
                            width: 20px !important;
                        }
                        *[class="code4email_h20"] {
                            height: 20px !important;
                        }
                        *[class="code4email_h20_center"] {
                            height: 20px !important;
                            text-align: center !important;
                        }
                    }
                </style>
            </head>
            <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
                <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                    <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
                    <tr>
                        <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
                            <tr>
                                <td>
                                    <a href="'.$liga3.'" target="_blank">
                                        <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                                            <tr>
                                                <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
                                                    <img width="280" src="'.$urlLogoFracc.'" />
                                                </td>
                                            </tr>
                                        </table>
                                    </a>
                                </td>
                            </tr>
                            <tr>
                                <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
                                    <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
                                        <tr>
                                            <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
                                                <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Vencimiento de Seguro </h3>
                                                <br><br>
                                                '.$cuerpoAdmin.'
                                            </td>
                                        </tr>
                                    </table>
                                    <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
                                </td>
                            </tr>
                        </td>
                    </tr>
                </table>
            </body>
            </html>';
            //echo $mensaje2;

            // para el administrador
            mail($copiasNV, $subject, $mensaje2, $cabeceras);

            return true;



    } 

    public function mantenimientoVehiculo(){
        $notifiacion = false;
        $activos = $this->mactivos->getAll(4);
        if (!is_numeric($activos)){
            foreach ($activos->result() as $value) {
                $notifiacion = false;
                //obtenemos al responsable del activo en la carta de asignacion
                $rResponsable = $this->mcartaasignacion->getByIdActivo($value->id);
                $data['idResponsable'] = (!is_numeric($rResponsable))?$rResponsable['idUsuario']:0;

                $existeMantenimiento = $this->mmantenimientovehiculo->getByIdV($value->id,1); //Último registro en mantxvehiculo con ststusMant = 1
                //$ultimoMHecho = $this->mmantenimientovehiculo->getByIdV($row->id,1); 
                $noHecho = $this->mmantenimientovehiculo->getByIdV($value->id); //Checamos si hay mantenimiento pendiente
                if(!is_numeric($existeMantenimiento)){
                    $fechaUltimoM = $existeMantenimiento['fecha'];
                }else{
                    $created = new DateTime($value->created);
                    $fechaUltimoM = $created->format("Y-m-d");
                    
                }
                $numDia = $value->diasMantenimiento; //exactamente el numero de dias para dar mantenimiento
                $diasNotif = $numDia - 30; //30 dias antes del mantenimiento
                $cincoAntes = $numDia - 5; //cinco dias antes del vencimiento
                $unoAntes = $numDia - 1; //un dia antes del vencimiento
                $vencimientoM = $numDia + 1;//pasando un dia la fecha de mantenimiento

                $fNotificacion =   date('Y-m-d',strtotime($fechaUltimoM . " +$diasNotif day")); //fecha para enviar la notificación 30 dias antes 
                $cincoAntes = date('Y-m-d',strtotime($fechaUltimoM . " +$cincoAntes day"));
                $unoAntes = date('Y-m-d',strtotime($fechaUltimoM . " +$unoAntes day"));
                $fMantenimiento = date('Y-m-d',strtotime($fechaUltimoM . " +$numDia day"));//fecha para el mantenimiento
                $fVencimiento = date('Y-m-d',strtotime($fechaUltimoM . " +$vencimientoM day"));

                $data['idActivo'] = $value->id;
                //$data['idResponsable'] = 18;//obtenemos el id del usaurio asignado a este activo
                $data['fechaMantenimiento'] = $fMantenimiento;

                //validamos 5 y 1 dia antes del vencimiento
                if (date("Y-m-d") == $cincoAntes){
                    $notifiacion = true;
                }if (date("Y-m-d") == $unoAntes){
                    $notifiacion = true;
                }

                if (date("Y-m-d") == $fNotificacion){//verificamos si la fecha para enviar la notificacion ha llegado (30 dias antes)
                    //echo "llegó el dia"."<br>";
                    $pData['idVehiculo'] = $value->id;
                    $pData['descripcion'] = '';
                    $pData['fecha'] = $fMantenimiento;//date("Y-m-d");
                    $pData['statusMantenimiento'] = 0;
                    $idMV = $this->mmantenimientovehiculo->insertar($pData); //insertamos la fecha de mantenimiento
                    //print_r($pData);
                    //exit();
                    $data['asunto'] = 'Notificación de mantenimiento de vehículo';
                    $this->autoRespuestaNotifMant($data);
                }
                if ($notifiacion == true){
                    $data['asunto'] = 'Notificación de mantenimiento de vehículo';
                    $this->autoRespuestaNotifMant($data);
                }
                if (date("Y-m-d") == $fMantenimiento){

                }
                if(!is_numeric($existeMantenimiento) && date("Y-m-d") >= $fVencimiento){ //Se ha retrasado por más de un día y no se ha dado mantenimiento al vehículo
                    if (!is_numeric($noHecho)){
                        if ($noHecho['statusMantenimiento'] == 0 || $noHecho['statusMantenimiento'] == 2){
                            $uData['statusMantenimiento'] = 2;
                            $this->mmantenimientovehiculo->actualizar($uData,$noHecho['id']); 
                            $data['asunto'] = 'Vencimiento para mantenimiento de vehículo';
                            $this->autoRespuestaNotifMant($data);
                        }
                    }
                        
                    
                }

            }
        }

    }


    function autoRespuestaNotifMant($parametros = null){
        $copiasNV = 'hsalinas@viviend.mx'. ', ';
        $copiasNV .= 'esalinas@viviend.mx'. ', ';
        $copiasNV .= 'mejora@viviend.mx'. ', ';
        $copiasNV .= 'tramites@viviend.mx'. ', ';
        $copiasNV .= 'sistemas@viviend.mx';
        
        $subject = $parametros['asunto'].' | '.date("d-m-Y H:i"); // titulo
        
        $emailPromotores = '';

        // para el gerente de ventas -------------------------------------------------
        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
        // Cabeceras adicionales
        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
        
        $gerentes = "";
        $gestores = "";
/*            $usuarios = $this->musuario->getAll();
        if ( !is_numeric($usuarios) ){
            foreach ($usuarios->result() as $key3 => $value3) {
                if ( $value3->rol == 3 ) { $gestores .= $value3->email.","; }
                if ( $value3->rol == 4 ) { $gerentes .= $value3->email.","; }
            }
            $gestores = trim($gestores, ',');
            $gerentes = trim($gerentes, ',');
        }*/           

        
        $subject2 = $subject;

        // para el gerente  -------------------------------------------------
        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";
        // Cabeceras adicionales
        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
        

        $liga="http://viviend.mx/sistema/emailresources/";
        $liga2="http://viviend.mx/sistema/img/";
        $liga3="http://viviend.mx/sistema/";
        
        $urlLogoFracc = 'http://viviend.mx/sistema/img/logo-300.png';

        if ($parametros!=null){
                $cuerpo = '';
                $nomPromotor = ($parametros['idResponsable']>0)?$this->musuario->getCampo('nombre',$parametros['idResponsable'])." ".$this->musuario->getCampo('apellidoP',$parametros['idResponsable']):'';
                $cuerpo .= '<h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:18px;margin-bottom: 0px;"> Responsable: '.$nomPromotor.' </h4>';
                $emailPromotor = ($parametros['idResponsable']>0)?$this->musuario->getCampo('email',$parametros['idResponsable']):'';

                $marca = $this->mactivos->getCampo('marca',$parametros['idActivo']);
                $modelo = $this->mactivos->getCampo('modelo',$parametros['idActivo']);
                $serie = $this->mactivos->getCampo('serie',$parametros['idActivo']);
                $anio = $this->mactivos->getCampo('anio',$parametros['idActivo']);
                $placas = $this->mactivos->getCampo('placas',$parametros['idActivo']);
                $strFechaM = strtotime($parametros['fechaMantenimiento']);
                $fechaMantenimiento = date('d-m-Y',$strFechaM);

                        
                        $cuerpo .= '
                                    <table id="table-prospecto" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;margin-bottom: 30px;">
                                        <tbody>
                                            <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha mantenimiento: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($parametros['fechaMantenimiento']), 'd/m/Y').' </td>
                                            </tr>
                                            <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Marca: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$marca.' </td>
                                            </tr>
                                            <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Modelo: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$modelo.' </td>
                                            </tr>
                                            <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Serie: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$serie.' </td>
                                            </tr>
                                            <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Año: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$anio.' </td>
                                            </tr>
                                            <tr>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Placas: </td>
                                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$placas.' </td>
                                            </tr>

                                        </tbody>
                                    </table>';


                $mensaje = '
        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
        <html xmlns="http://www.w3.org/1999/xhtml">
        <head>
            <title>Email</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
            <style>
                body, tr, td, span, div, p, a, li {
                    -moz-text-size-adjust:none !important;
                    -webkit-text-size-adjust:none !important;
                    margin:0px !important;
                    -ms-text-size-adjust:none !important;
                    white-space: wrap;
                }
                .lato-light{
                    font-family: "lato" sans-serif !important;
                    font-weight: 300;
                }
                .lato-bold{
                    font-family: "lato" sans-serif !important;
                    font-weight: 700;
                }
                td img {
                    display: block;
                }
                .ReadMsgBody {
                    width: 100%;
                }
                .ExternalClass * {
                    line-height: 100%;
                }

                table#table-prospecto td:nth-child(1) {
                    width: 50%;
                    padding-left: 10px;
                }
                table#table-prospecto td:nth-child(2) {
                    width: 50%;
                    padding-left: 10px;
                }

                @media only screen and (max-width:480px) {
                    #logosim{
                        padding:0!important;
                    }
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 320px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
                @media only screen and (min-width:480px) and (max-width:599px) {
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 480px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
            </style>
        </head>
        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
                <tr>
                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
                        <tr>
                            <td>
                                <a href="'.$liga3.'" target="_blank">
                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                                        <tr>
                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
                                                <img width="280" src="'.$urlLogoFracc.'" />
                                            </td>
                                        </tr>
                                    </table>
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
                                    <tr>
                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> '.$parametros['asunto'].' </h3>
                                            <br><br>
                                            '.$cuerpo.'
                                        </td>
                                    </tr>
                                </table>
                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
                            </td>
                        </tr>
                    </td>
                </tr>
            </table>
        </body>
        </html>';

        //echo $mensaje;

                //email para el responsable del activo (vehiculo)
                if($emailPromotor!=''){
                   mail($emailPromotor, $subject, $mensaje, $cabeceras); 
                }                

                // para el administrador
                mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);



        return true;

        }
                
    }

    public function autoRespuestaEstatusGestoria(){
        $subject = 'Tubería Gestoria | '.date("d-m-Y H:i"); // titulo
        $enviar = false;

        $correccionRfc = $this->mareastatus->getStatusByDate('correccion de rfc');
        if($correccionRfc>0){ $enviar=true; }
        $solAvaluo = $this->mareastatus->getStatusByDate('solicitud de avaluo');
        if($solAvaluo>0){ $enviar=true; }
        $correccionAvaluo = $this->mareastatus->getStatusByDate('correccion de avaluo');
        if($correccionAvaluo>0){ $enviar=true; }
        $complementoExpediente = $this->mareastatus->getStatusByDate('complemento de expediente');
        if($complementoExpediente>0){ $enviar=true; }
        $revCondiciones = $this->mareastatus->getStatusByDate('revision de condiciones');
        if($revCondiciones>0){ $enviar=true; }
        $esperaUbicacion = $this->mareastatus->getStatusByDate('espera de ubicacion');
        if($esperaUbicacion>0){ $enviar=true; }
        $autorizado = $this->mareastatus->getStatusByDate('autorizado');
        if($autorizado>0){ $enviar=true; }
        $cancelados = $this->maltaventa->getCancelados();
        if($cancelados>0){ $enviar=true; }

        $liga="http://viviend.mx/sistema/emailresources/";
        $liga2="http://viviend.mx/sistema/img/";
        $liga3="http://viviend.mx/sistema/";
        
        $urlLogoFracc = 'http://viviend.mx/sistema/img/logo-300.png';

        $cuerpo = '';
        $cuerpo .= '
            <table id="table-prospecto" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;margin-bottom: 30px;">
                <tbody>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> CORRECCIÓN DE RFC: </td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> ('.$correccionRfc.') </td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> SOLICITUD DE AVALUO: </td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> ('.$solAvaluo.') </td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> CORRECCIÓN DE AVALUO: </td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> ('.$correccionAvaluo.') </td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> COMPLEMENTO DE EXPEDIENTE: </td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> ('.$complementoExpediente.') </td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> REVISIÓN DE CONDICIONES: </td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> ('.$revCondiciones.') </td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> ESPERA DE UBICACIÓN: </td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> ('.$esperaUbicacion.') </td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> AUTORIZADO: </td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> ('.$autorizado.') </td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> CANCELADOS: </td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> ('.$cancelados.') </td>
                    </tr>
                </tbody>
            </table>';

            $mensaje = '
        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
        <html xmlns="http://www.w3.org/1999/xhtml">
        <head>
            <title>Email</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
            <style>
                body, tr, td, span, div, p, a, li {
                    -moz-text-size-adjust:none !important;
                    -webkit-text-size-adjust:none !important;
                    margin:0px !important;
                    -ms-text-size-adjust:none !important;
                    white-space: wrap;
                }
                .lato-light{
                    font-family: "lato" sans-serif !important;
                    font-weight: 300;
                }
                .lato-bold{
                    font-family: "lato" sans-serif !important;
                    font-weight: 700;
                }
                td img {
                    display: block;
                }
                .ReadMsgBody {
                    width: 100%;
                }
                .ExternalClass * {
                    line-height: 100%;
                }

                table#table-prospecto td:nth-child(1) {
                    width: 50%;
                    padding-left: 10px;
                }
                table#table-prospecto td:nth-child(2) {
                    width: 50%;
                    padding-left: 10px;
                }

                @media only screen and (max-width:480px) {
                    #logosim{
                        padding:0!important;
                    }
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 320px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
                @media only screen and (min-width:480px) and (max-width:599px) {
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 480px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
            </style>
        </head>
        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
                <tr>
                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
                        <tr>
                            <td>
                                <a href="'.$liga3.'" target="_blank">
                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                                        <tr>
                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
                                                <img width="280" src="'.$urlLogoFracc.'" />
                                            </td>
                                        </tr>
                                    </table>
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
                                    <tr>
                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Tubería gestoría </h3>
                                            <br><br>
                                            '.$cuerpo.'
                                        </td>
                                    </tr>
                                </table>
                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
                            </td>
                        </tr>
                    </td>
                </tr>
            </table>
        </body>
        </html>';
        //echo $mensaje;exit();
        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
        // Cabeceras adicionales
        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

        if($enviar){
            $gerentes = "";
            $gestores = "";
            $usuarios = $this->musuario->getAll();
            if ( !is_numeric($usuarios) ){
                foreach ($usuarios->result() as $key3 => $value3) {
                    if ( $value3->rol == 3 ) { $gestores .= $value3->email.","; }
                    //if ( $value3->rol == 4 ) { $gerentes .= $value3->email.","; }
                }
                $gestores = trim($gestores, ',');
                $gerentes = trim($gerentes, ',');
            }
            
            if ( $gerentes != "" ) { 
                mail($gerentes, $subject, $mensaje, $cabeceras);
            }
            if ( $gestores != "" ) { 
                mail($gestores, $subject, $mensaje, $cabeceras);
            }

            $copiasNV = 'hsalinas@viviend.mx'. ', ';
            $copiasNV .= 'esalinas@viviend.mx'. ', ';
            $copiasNV .= 'mejora@viviend.mx'. ', ';
            $copiasNV .= 'sistemas@viviend.mx';

            // para el administrador
            mail($copiasNV, $subject, $mensaje, $cabeceras);
        }
        //echo $mensaje;
        //exit();
    }

    public function autoRespuestaEstatusTitulacion(){
        $subject = 'Tubería Titulación | '.date("d-m-Y H:i"); // titulo
        $enviar = false;

        $esperaIns = $this->mareastatus->getStatusTByDate('espera de inscripcion');
        if($esperaIns>0){ $enviar=true; }
        $inscrito = $this->mareastatus->getStatusTByDate('inscrito');
        if($inscrito>0){ $enviar=true; }
        $ahorroVol = $this->mareastatus->getStatusTByDate('ahorro voluntario');
        if($ahorroVol>0){ $enviar=true; }
        $revCondiciones = $this->mareastatus->getStatusTByDate('revision de condiciones');
        if($revCondiciones>0){ $enviar=true; }
        $notaria = $this->mareastatus->getStatusTByDate('notaria');
        if($notaria>0){ $enviar=true; }
        $firmaEscritura = $this->mareastatus->getStatusTByDate('programado firma de escritura');
        if($firmaEscritura>0){ $enviar=true; }
        $firmado = $this->mareastatus->getStatusTByDate('firmado');
        if($firmado>0){ $enviar=true; }
        $detonado = $this->mareastatus->getStatusTByDate('detonado');
        if($detonado>0){ $enviar=true; }

        $liga="http://viviend.mx/sistema/emailresources/";
        $liga2="http://viviend.mx/sistema/img/";
        $liga3="http://viviend.mx/sistema/";
        
        $urlLogoFracc = 'http://viviend.mx/sistema/img/logo-300.png';

        $cuerpo = '';
        $cuerpo .= '
            <table id="table-prospecto" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;margin-bottom: 30px;">
                <tbody>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> ESPERA DE INSCRIPCIÓN: </td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> ('.$esperaIns.') </td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> INSCRITO: </td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> ('.$inscrito.') </td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> AHORRO VOLUNTARIO: </td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> ('.$ahorroVol.') </td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> REVISIÓN DE CONDICIONES: </td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> ('.$revCondiciones.') </td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NOTARIA: </td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> ('.$notaria.') </td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> PROGRAMADO FIRMA DE ESCRITURA: </td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> ('.$firmaEscritura.') </td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> FIRMADO: </td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> ('.$firmado.') </td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> DETONADO: </td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> ('.$detonado.') </td>
                    </tr>
                </tbody>
            </table>';

            $mensaje = '
        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
        <html xmlns="http://www.w3.org/1999/xhtml">
        <head>
            <title>Email</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
            <style>
                body, tr, td, span, div, p, a, li {
                    -moz-text-size-adjust:none !important;
                    -webkit-text-size-adjust:none !important;
                    margin:0px !important;
                    -ms-text-size-adjust:none !important;
                    white-space: wrap;
                }
                .lato-light{
                    font-family: "lato" sans-serif !important;
                    font-weight: 300;
                }
                .lato-bold{
                    font-family: "lato" sans-serif !important;
                    font-weight: 700;
                }
                td img {
                    display: block;
                }
                .ReadMsgBody {
                    width: 100%;
                }
                .ExternalClass * {
                    line-height: 100%;
                }

                table#table-prospecto td:nth-child(1) {
                    width: 50%;
                    padding-left: 10px;
                }
                table#table-prospecto td:nth-child(2) {
                    width: 50%;
                    padding-left: 10px;
                }

                @media only screen and (max-width:480px) {
                    #logosim{
                        padding:0!important;
                    }
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 320px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
                @media only screen and (min-width:480px) and (max-width:599px) {
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 480px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
            </style>
        </head>
        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
                <tr>
                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
                        <tr>
                            <td>
                                <a href="'.$liga3.'" target="_blank">
                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                                        <tr>
                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
                                                <img width="280" src="'.$urlLogoFracc.'" />
                                            </td>
                                        </tr>
                                    </table>
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
                                    <tr>
                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Tubería Titulación </h3>
                                            <br><br>
                                            '.$cuerpo.'
                                        </td>
                                    </tr>
                                </table>
                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
                            </td>
                        </tr>
                    </td>
                </tr>
            </table>
        </body>
        </html>';
        //echo $mensaje;exit();
        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
        // Cabeceras adicionales
        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

        if($enviar){
            $gerentes = "";
            $gestores = "";
            $usuarios = $this->musuario->getAll();
            if ( !is_numeric($usuarios) ){
                foreach ($usuarios->result() as $key3 => $value3) {
                    if ( $value3->rol == 3 ) { $gestores .= $value3->email.","; }
                    //if ( $value3->rol == 4 ) { $gerentes .= $value3->email.","; }
                }
                $gestores = trim($gestores, ',');
                $gerentes = trim($gerentes, ',');
            }
            
            if ( $gerentes != "" ) { 
                mail($gerentes, $subject, $mensaje, $cabeceras);
            }
            if ( $gestores != "" ) { 
                mail($gestores, $subject, $mensaje, $cabeceras);
            }

            $copiasNV = 'hsalinas@viviend.mx'. ', ';
            $copiasNV .= 'esalinas@viviend.mx'. ', ';
            $copiasNV .= 'mejora@viviend.mx'. ', ';
            $copiasNV .= 'sistemas@viviend.mx';

            // para el administrador
            mail($copiasNV, $subject, $mensaje, $cabeceras);
        }
        //echo $mensaje;
        //exit();
    }

    public function nuevoInventario(){
        $this->load->dbutil();
        $this->load->helper('download');
        $query = $this->mproyecto->getCSV(null,true);
        if (!is_numeric($query)){
            $csv = mb_convert_encoding($this->dbutil->csv_from_result($query, ",", "\n"), "ISO-8859-1", "UTF-8");
            $date=new DateTime();
            $name = "Inventario-".$date->format("d-m-Y").".csv";
            force_download($name, $csv);
        }else{
            //redirect('proyectos');
            $data['msgInvalid'] = "";
        }
    }

    public function autoRespuestaNuevoInventario(){
        $subject = 'Actualización Nuevo Inventario | '.date("d-m-Y H:i"); // titulo


        $liga="http://viviend.mx/sistema/emailresources/";
        $liga2="http://viviend.mx/sistema/img/";
        $liga3="http://viviend.mx/sistema/";
        
        $urlLogoFracc = 'http://viviend.mx/sistema/img/logo-300.png';

        $cuerpo = '';
        $cuerpo .= '
            <table id="table-prospecto" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;margin-bottom: 30px;">
                <tbody>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> ENLACE DE DESCARGA: </td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;">
                            <a href="nuevoInventario">DESCARGAR</a>
                        </td>
                    </tr>
                </tbody>
            </table>';

            $mensaje = '
        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
        <html xmlns="http://www.w3.org/1999/xhtml">
        <head>
            <title>Email</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
            <style>
                body, tr, td, span, div, p, a, li {
                    -moz-text-size-adjust:none !important;
                    -webkit-text-size-adjust:none !important;
                    margin:0px !important;
                    -ms-text-size-adjust:none !important;
                    white-space: wrap;
                }
                .lato-light{
                    font-family: "lato" sans-serif !important;
                    font-weight: 300;
                }
                .lato-bold{
                    font-family: "lato" sans-serif !important;
                    font-weight: 700;
                }
                td img {
                    display: block;
                }
                .ReadMsgBody {
                    width: 100%;
                }
                .ExternalClass * {
                    line-height: 100%;
                }

                table#table-prospecto td:nth-child(1) {
                    width: 50%;
                    padding-left: 10px;
                }
                table#table-prospecto td:nth-child(2) {
                    width: 50%;
                    padding-left: 10px;
                }

                @media only screen and (max-width:480px) {
                    #logosim{
                        padding:0!important;
                    }
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 320px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
                @media only screen and (min-width:480px) and (max-width:599px) {
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 480px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
            </style>
        </head>
        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
                <tr>
                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
                        <tr>
                            <td>
                                <a href="'.$liga3.'" target="_blank">
                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                                        <tr>
                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
                                                <img width="280" src="'.$urlLogoFracc.'" />
                                            </td>
                                        </tr>
                                    </table>
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
                                    <tr>
                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Actualización de Nuevo Inventario </h3>
                                            <br><br>
                                            '.$cuerpo.'
                                        </td>
                                    </tr>
                                </table>
                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
                            </td>
                        </tr>
                    </td>
                </tr>
            </table>
        </body>
        </html>';

        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
        // Cabeceras adicionales
        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

        $query = $this->mproyecto->getCSV(null,true);
        if($query->num_rows()>0){
            $envio=true;
            $gerentes = "";
            $gestores = "";
            $usuarios = $this->musuario->getAll();
            if ( !is_numeric($usuarios) ){
                foreach ($usuarios->result() as $key3 => $value3) {
                    if ( $value3->rol == 3 ) { $gestores .= $value3->email.","; }
                    //if ( $value3->rol == 4 ) { $gerentes .= $value3->email.","; }
                }
                $gestores = trim($gestores, ',');
                $gerentes = trim($gerentes, ',');
            }
            
            if ( $gerentes != "" ) { 
                mail($gerentes, $subject, $mensaje, $cabeceras);
            }
            if ( $gestores != "" ) { 
                mail($gestores, $subject, $mensaje, $cabeceras);
            }

            //tecnica
            $user_tecnica = $this->musuario->getTecnicaBySelectResult();
            if ( !is_numeric($user_tecnica) ) {
                foreach ($user_tecnica->result() as $row) {
                    $mail_ = $this->musuario->getCampo('email',$row->id);
                    if ( $mail_ != null && $mail_ != '' ) { mail($mail_, $subject, $mensaje, $cabeceras); }
                }
            }
            //conta
            $user_conta = $this->musuario->getContabilidadBySelectResult();
            if ( !is_numeric($user_conta) ) {
                foreach ($user_conta->result() as $row) {
                    $mail_ = $this->musuario->getCampo('email',$row->id);
                    if ( $mail_ != null && $mail_ != '' ) { mail($mail_, $subject, $mensaje, $cabeceras); }
                }
            }
            //merca
            $user_merca = $this->musuario->getMercaBySelectResult();
            if ( !is_numeric($user_merca) ) {
                foreach ($user_merca->result() as $row) {
                    $mail_ = $this->musuario->getCampo('email',$row->id);
                    if ( $mail_ != null && $mail_ != '' ) { mail($mail_, $subject, $mensaje, $cabeceras); }
                }
            }
            //merca
            $user_obra = $this->musuario->getResidenteObraBySelectResult();
            if ( !is_numeric($user_obra) ) {
                foreach ($user_obra->result() as $row) {
                    $mail_ = $this->musuario->getCampo('email',$row->id);
                    if ( $mail_ != null && $mail_ != '' ) { mail($mail_, $subject, $mensaje, $cabeceras); }
                }
            }

            $copiasNV = 'hsalinas@viviend.mx'. ', ';
            $copiasNV .= 'esalinas@viviend.mx'. ', ';
            $copiasNV .= 'mejora@viviend.mx'. ', ';
            $copiasNV .= 'sistemas@viviend.mx';

            // para el administrador
            mail($copiasNV, $subject, $mensaje, $cabeceras);
        }else{
            $envio=false;
        }

        /*echo $mensaje."<br>";
        echo $envio;
        exit();*/
    }

    public function fechaHoraServer(){
        echo "<pre>";
        $hoy = getdate();
        print_r($hoy);
        echo "</pre>";
    }

    public function autoTest(){
        $copiasNV = 'hsalinas@viviend.mx'. ', ';
        $copiasNV .= 'esalinas@viviend.mx'. ', ';
        $copiasNV .= 'mejora@viviend.mx'. ', ';
        $copiasNV .= 'sistemas@viviend.mx';

        $subject = 'Test | '.date("d-m-Y H:i"); // titulo
                    $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
            $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
            // Cabeceras adicionales
            $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

            $subject2 = $subject;

            // para el gerente  -------------------------------------------------
            $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
            $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";
            // Cabeceras adicionales
            $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

            $mensaje = "Prueba de envío de mensajes desde viviend.mx";

            //mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);

            //echo "enviado";
    }


    public function actualizaAreaStatusGestoria(){ // SE EJECUTÓ 25 DIC 2018 JUNTO CON TITULACIÓN LLEGÓ AL ID 644 en la tabla areas_status
        $query = $this->db->query("
            SELECT id,idProyecto,idProspecto,fechaApartado,statusValidacion,statusValidacion2,status,created 
            FROM alta_venta 
            WHERE statusValidacion2!=''
        ");
        if($query->num_rows()>0){
            $array = array("correccion de rfc", "solicitud de avaluo", "complemento de expediente", "revision de condiciones", "espera de ubicacion","autorizado");            
            foreach ($query->result() as $row) {
                $statusValidacion2 = $array[array_rand($array, 1)];
                $ae['idArea'] = 1;
                $ae['idAltaVenta'] = $row->id;
                $ae['idStatus'] = $row->statusValidacion2;// $statusValidacion2;//
                $ae['fecha'] = ($row->fechaApartado!='' && $row->fechaApartado!='0000-00-00')?$row->fechaApartado:$row->created;
                $this->mareastatus->insertar($ae);
                //print_r($ae);
                //echo "<br>";
                
            }
            //exit();
            echo "success";
        }
    }

    public function actualizaAreaStatusTitulacion(){ // SE EJECUTÓ 25 DIC 2018 JUNTO CON GESTORÍA LLEGÓ AL ID 644 en la tabla areas_status
        $query = $this->db->query("
            SELECT id,idAltaVenta,statusGestoria,status,created 
            FROM gestoria 
            WHERE statusGestoria!='' 
            AND statusGestoria!='preventa' 
            AND statusGestoria!='correccion de rfc' AND statusGestoria !='0' AND statusGestoria !='folio' AND statusGestoria !='avaluo' AND statusGestoria !='firmados'
        ");
        if($query->num_rows()>0){
            $array = array("espera de inscripcion", "inscrito", "ahorro voluntario", "revision de condiciones", "notaria",'firmado','detonado'); 
            foreach ($query->result() as $row) {
                $statusGestoria = $array[array_rand($array, 1)];
                $rowAv = $this->maltaventa->getById($row->idAltaVenta);
                $rowGestoria = $this->mgestoria->getByIdAV($row->idAltaVenta);
                if(!is_numeric($rowAv)){
                    if(!is_numeric($rowGestoria)){
                        if($rowGestoria['statusGestoria']=='detonado'){
                            $fechaProceso = $rowAv['fechaVenta'];
                        }else{
                            $fechaProceso = $rowAv['fechaProceso'];
                        }                        
                    }else{
                        $fechaProceso = $rowAv['fechaProceso'];
                    }
                }else{
                    $fechaProceso = '';
                }
                $ae['idArea'] = 2;
                $ae['idAltaVenta'] = $row->idAltaVenta;
                $ae['idStatus'] = $row->statusGestoria;// $statusGestoria;//
                $ae['fecha'] = ($fechaProceso!='' && $fechaProceso!='0000-00-00')?$fechaProceso:$row->created;
                $this->mareastatus->insertar($ae);
                //print_r($ae);
                //echo "<br>";
                
            }
            //exit();
            echo "success";
        }
    }

    public function actualizaParaDisponibles(){ //idStatus = 3 disponibilidad en graf colocacion
        $query = $this->db->query("
            SELECT id,fechaApartado,fechaProceso,fechaVenta FROM alta_venta WHERE STATUS = 1 AND idProyecto > 0

        ");
        if($query->num_rows()>0){
            foreach ($query->result() as $row) {
                if($row->fechaApartado!='' && $row->fechaApartado!='0000-00-00' && $row->fechaApartado!=null){
                    $ae['idArea'] = 3;
                    $ae['idAltaVenta'] = $row->id;
                    $ae['idStatus'] = 'apartado';
                    $ae['fecha'] = $row->fechaApartado;
                    $this->mareastatus->insertar($ae);
                    /*echo "<pre>";
                    print_r($ae);
                    echo "</pre>";*/
                }
                if($row->fechaProceso!='' && $row->fechaProceso!='0000-00-00' && $row->fechaProceso!=null){
                    $ae['idArea'] = 3;
                    $ae['idAltaVenta'] = $row->id;
                    $ae['idStatus'] = 'proceso';
                    $ae['fecha'] = $row->fechaProceso;
                    $this->mareastatus->insertar($ae);
                    /*echo "<pre>";
                    print_r($ae);
                    echo "</pre>";*/
                }
                if($row->fechaVenta!='' && $row->fechaVenta!='0000-00-00' && $row->fechaVenta!=null){
                    $ae['idArea'] = 3;
                    $ae['idAltaVenta'] = $row->id;
                    $ae['idStatus'] = 'detonado';
                    $ae['fecha'] = $row->fechaVenta;
                    $this->mareastatus->insertar($ae);
                    /*echo "<pre>";
                    print_r($ae);
                    echo "</pre><br><br>";*/
                }
                
            }
            echo "success";
        }
    }

    public function actualizaEntregas(){ //idStatus = 4, disonibilidad en graf viviendas
        $query = $this->db->query("
            SELECT idAltaVenta, statusGestoria, (SELECT fechaEntrega FROM entrega WHERE entrega.idAltaVenta = gestoria.idAltaVenta) AS 'fechaEntrega', (SELECT statusEntrega FROM entrega WHERE entrega.idAltaVenta = gestoria.idAltaVenta) AS 'estatusEntrega' 
            FROM gestoria 
            WHERE statusGestoria = 'detonado' 
            AND STATUS = 1 
            AND (SELECT STATUS FROM alta_venta WHERE alta_venta.id = gestoria.idAltaVenta) = 1
        ");

        if ($query->num_rows()>0){
            foreach ($query->result() as $row) {
                if($row->estatusEntrega==1){
                    $ae['idArea'] = 4;
                    $ae['idAltaVenta'] = $row->idAltaVenta;
                    $ae['idStatus'] = 'entregadas';
                    $ae['fecha'] = $row->fechaEntrega;
                    $this->mareastatus->insertar($ae);
                    /*echo "<pre>";
                    print_r($ae);
                    echo "</pre>";*/
                }else{
                    $fechaVenta = $this->maltaventa->getCampo('fechaVenta',$row->idAltaVenta);
                    $ae['idArea'] = 4;
                    $ae['idAltaVenta'] = $row->idAltaVenta;
                    $ae['idStatus'] = 'pendientes';
                    $ae['fecha'] = $fechaVenta;
                    $this->mareastatus->insertar($ae);
                    /*echo "<pre>";
                    print_r($ae);
                    echo "</pre><br>";*/
                }
            }
            echo "success";
        }
    }


}