<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
date_default_timezone_set('America/Mexico_City');
class Ms extends MX_Controller {
    public $data,$vParameters,$mainView,$fv,$ret, $urlSendWhatsapp, $keyTest, $keyProduction, $appProduction, $keyActive;

    public function __construct() {
        // Modelos
        // Tools
        $this->load->helper(array('tools','numeros','url','form','date','text','security'));
        $this->load->library("curl");
        $this->load->model(array('mtasks','mlogs_task','malmacenes','mordencompra',
        'mdetalleorden','mmateriales','mempresas', 'mlogsws','mcompra','mrecepcion','mdetallecompra','mdetallerecepcion'));
        $this->port=$this->config->item('portmicro');
        ini_set('memory_limit', '-1');
        ini_set('max_execution_time', 0);

        $this->appProduction = $this->config->item('appProduction');
        $this->keyActive = ($this->appProduction) ? $this->keyProduction : $this->keyTest;
    }

    public function getDocsByEmpresa($idEmpresa=0,$retorno=1,$eliminar=1){
        $almacenes=$this->db->query("SELECT id,idEmpresa,idPaquete,updated,$retorno,$eliminar eliminar FROM almacenes WHERE idEmpresa=$idEmpresa AND idPaquete ORDER BY id DESC");
        $currentDate=date("Y-m-d");
        if($almacenes->num_rows() > 0){
            foreach ($almacenes->result() as $row) {
                $data=[
                    "un"=>$row->idEmpresa,
                    "id_almacen"=> $row->id,
                    "fecha_desde" => "2015-01-01",
                    "fecha_hasta" =>  $currentDate
                ];
                $this->GetOrdenesCompraAlmacen($data,$row);
                $this->GetComprasAlmacen($data,$row);
                $this->GetRecepcionesAlmacen($data,$row);
                $this->db->query("UPDATE almacenes SET updated='$currentDate' WHERE idEmpresa=$idEmpresa AND id=".$row->id);
            }
        }
    }

    public function getDocsByEmpresaAlmacen($idEmpresa=0,$idAlmacen=0,$type="",$retorno=1,$eliminar=0){
        $almacenes=$this->db->query("SELECT id,idEmpresa,idPaquete,updated,$retorno retorno,$eliminar eliminar FROM almacenes WHERE idEmpresa=$idEmpresa AND id=$idAlmacen AND idPaquete");
        $currentDate=date("Y-m-d");
        if($almacenes->num_rows() > 0){
            foreach ($almacenes->result() as $row) {
                $dateFrom=($eliminar==0) ? date_format(new DateTime($row->updated),"Y-m-d") : "2015-01-01";
                $data=[
                    "un"=>$row->idEmpresa,
                    "id_almacen"=> $row->id,
                    "fecha_desde" => $dateFrom,
                    "fecha_hasta" => $currentDate
                ];
                ($type=='' || $type=='O') ? $this->GetOrdenesCompraAlmacen($data,$row) : '';
                ($type=='' || $type=='C') ? $this->GetComprasAlmacen($data,$row) : '';
                ($type=='' || $type=='R') ? $this->GetRecepcionesAlmacen($data,$row) : '';
            }
        }
        ($type=="") ? $this->db->query("UPDATE almacenes SET updated='$currentDate' WHERE idEmpresa=$idEmpresa AND id=$idAlmacen") : '';
    }

    //begin test
    public function getDocsByEmpresaAlmacenTest($idEmpresa=0,$idAlmacen=0,$type="",$retorno=1,$eliminar=0){
        $almacenes=$this->db->query("SELECT id,idEmpresa,idPaquete,updated,$retorno retorno,$eliminar eliminar FROM almacenes WHERE idEmpresa=$idEmpresa AND id=$idAlmacen AND idPaquete");
        $currentDate=date("Y-m-d");
        if($almacenes->num_rows() > 0){
            foreach ($almacenes->result() as $row) {
                $dateFrom=($eliminar==0) ? date_format(new DateTime($row->updated),"Y-m-d") : "2015-01-01";
                $data=[
                    "un"=>$row->idEmpresa,
                    "id_almacen"=> $row->id,
                    "fecha_desde" => $dateFrom,
                    "fecha_hasta" => $currentDate
                ];
                $this->GetOrdenesCompraAlmacenTest($data,$row);
            }
        }
        ($type=="") ? $this->db->query("UPDATE almacenes SET updated='$currentDate' WHERE idEmpresa=$idEmpresa AND id=$idAlmacen") : '';
    }

    public function GetOrdenesCompraAlmacenTest($data,$row){
        $response=$this->myCurl("GetOrdenesCompraAlmacen/test",$data);
        $this->insertData($response,$row,"O");
    }
    //end test

    public function GetOrdenesCompraAlmacen($data,$row){
        $response=$this->myCurl("GetOrdenesCompraAlmacen",$data);
        $this->insertData($response,$row,"O");
    }

    public function GetComprasAlmacen($data,$row){
        $response=$this->myCurl("GetComprasAlmacen",$data);
        $this->insertData($response,$row,"C");
    }

    public function GetRecepcionesAlmacen($data,$row){
        $response=$this->myCurl("GetRecepcionesAlmacen",$data);
        $this->insertData($response,$row,"R");
    }

    public function insertData($json,$row,$type=""){
        $idPaquete=$row->idPaquete;
        $idEmpresa=$row->idEmpresa;
        $retorno=$row->retorno;
        $eliminar=$row->eliminar;
        $id_almacen=$row->id;

        if(isset($json->object_result)){
            if(is_array($json->object_result)){
                $count=[
                    "o"=>["i"=>0,"u"=>0,"t"=>0,"ids"=>[0]],
                    "od"=>["i"=>0,"u"=>0,"t"=>0,"ids"=>[0]],
                    "c"=>["i"=>0,"u"=>0,"t"=>0,"ids"=>[0]],
                    "cd"=>["i"=>0,"u"=>0,"t"=>0,"ids"=>[0]],
                    "r"=>["i"=>0,"u"=>0,"t"=>0,"ids"=>[0]],
                    "rd"=>["i"=>0,"u"=>0,"t"=>0,"ids"=>[0]],
                ];
                if(COUNT($json->object_result) > 0){
                    //Objeto de respuesta
                    foreach ($json->object_result as $doc => $docRow) {
                        switch ($docRow->tipo_docto) {
                            case 'O':
                                $data=[];
                                //Recorre ordenes de compra(orden_compra)
                                foreach ($docRow as $k => $v) {
                                    switch ($k) {
                                        case 'id_orden_compra':
                                            $data['id']=$v;
                                            break;
                                        case 'lista_articulos':
                                            $dataList=[];
                                            //Recorre listado de articulos(detalle_orden)
                                            $count["od"]["ids"]=[0];
                                            foreach ($v as $row) {
                                                foreach ($row as $keyd => $vald){
                                                    $dataList[$keyd]=$vald;
                                                }
                                                //Validaciones de sincronizacion de detalle orden
                                                $dataList['idEmpresa']=$idEmpresa;
                                                $dataList['idPaquete']=$idPaquete;
                                                $dataList['id_almacen']=$id_almacen;
                                                if($this->mdetalleorden->valInsert($dataList['id'],$idEmpresa)){
                                                    $this->mdetalleorden->insertar($dataList);
                                                    $count["od"]["i"]++;
                                                }else if($this->mdetalleorden->valUpdate($dataList['id'],$dataList)){
                                                    $this->mdetalleorden->actualiza($dataList,$dataList['id']);
                                                    $count["od"]["u"]++;
                                                }
                                                array_push($count["od"]["ids"],$dataList['id']); 
                                                $count["od"]["t"]++;
                                            }
                                            break;
                                        default:
                                            $data[$k]=$v;
                                            break;
                                    }
                                }
                                
                                $data['idEmpresa']=$idEmpresa;
                                $data['idPaquete']=$idPaquete;
                                if($this->mordencompra->valInsert($data['id'],$idEmpresa)){
                                    $this->mordencompra->insertar($data);
                                    $count["o"]["i"]++;
                                }else if($this->mordencompra->valUpdate($data['id'],$data)){
                                    $this->mordencompra->actualiza($data,$data['id']);
                                    $count["o"]["u"]++;
                                }
                                array_push($count["o"]["ids"],$data['id']); 
                                $count["o"]["t"]++;
                                //eliminaciones
                                $id_orden_compra=$data['id'];
                                $ids=implode(",",$count["od"]["ids"]);
                                ($retorno==1) ? print("Detalle orden: ".$ids."<br>") : '';
                                ($eliminar == 1) ? $this->db->query("DELETE FROM detalle_orden WHERE (idEmpresa=$idEmpresa AND id_almacen=$id_almacen AND id_orden_compra=$id_orden_compra AND id NOT IN (".$ids."))") : '';
                                echo ($this->db->affected_rows() > 0 && $retorno==1) ? "Afectados Detalle Orden: ".$this->db->affected_rows()."<br>" : '';
                                break;
                            case 'C':
                                $data=[];
                                //Recorre listado de compra
                                foreach ($docRow as $k => $v){
                                    switch ($k) {
                                        case 'id_compra':
                                            $data['id']=$v;
                                            break;
                                        case 'lista_articulos':
                                            $dataList=[];
                                            //Recorre listado de articulos(detalle_compra)
                                            $count["cd"]["ids"]=[0];
                                            foreach ($v as $row) {
                                                foreach ($row as $keyd => $vald){
                                                    $dataList[$keyd]=$vald;
                                                }
                                                //Validaciones de sincronizacion de detalle compra
                                                $dataList['idEmpresa']=$idEmpresa;
                                                $dataList['idPaquete']=$idPaquete;
                                                $dataList['id_almacen']=$id_almacen;
                                                if($this->mdetallecompra->valInsert($dataList['id'],$idEmpresa)){
                                                    $this->mdetallecompra->insertar($dataList);
                                                    $count["cd"]["i"]++;
                                                }else if($this->mdetallecompra->valUpdate($dataList['id'],$dataList)){
                                                    $this->mdetallecompra->actualiza($dataList,$dataList['id']);
                                                    $count["cd"]["u"]++;
                                                }
                                                array_push($count["cd"]["ids"],$dataList['id']); 
                                                $count["cd"]["t"]++;
                                            }
                                            break;
                                        default:
                                            $data[$k]=$v;
                                            break;
                                    }
                                }
                                //Validaciones de sincronizacion de compra
                                $data['idEmpresa']=$idEmpresa;
                                $data['idPaquete']=$idPaquete;
                                if($this->mcompra->valInsert($data['id'],$idEmpresa)){
                                    $this->mcompra->insertar($data);
                                    $count["c"]["i"]++;
                                }else if($this->mcompra->valUpdate($data['id'],$data)){
                                    $this->mcompra->actualiza($data,$data['id']);
                                    $count["c"]["u"]++;
                                }
                                array_push($count["c"]["ids"],$data['id']);
                                $count["c"]["t"]++;
                                //eliminaciones
                                $id_compra=$data['id'];
                                $ids=implode(",",$count["cd"]["ids"]);
                                ($retorno==1) ? print("Detalle compra: ".$ids."<br>") : '';
                                ($eliminar == 1) ? $this->db->query("DELETE FROM detalle_compra WHERE (idEmpresa=$idEmpresa AND id_almacen=$id_almacen AND id_compra=$id_compra AND id NOT IN (".$ids."))") : '';
                                echo ($this->db->affected_rows() > 0 && $retorno==1) ? "Afectados Detalle Compra: ".$this->db->affected_rows()."<br>" : '';
                                break;
                            case 'R':
                                $data=[];
                                //Recorre listado de recepcion
                                foreach ($docRow as $k => $v){
                                    switch ($k) {
                                        case 'id_recepcion':
                                            $data['id']=$v;
                                            break;
                                        case 'lista_articulos':
                                            $dataList=[];
                                            //Recorre listado de articulos(detalle_recepcion)
                                            $count["rd"]["ids"]=[0];
                                            foreach ($v as $row) {
                                                foreach ($row as $keyd => $vald){
                                                    $dataList[$keyd]=$vald;
                                                }
                                                //Validaciones de sincronizacion de detalle recepcion
                                                $dataList['idEmpresa']=$idEmpresa;
                                                $dataList['idPaquete']=$idPaquete;
                                                $dataList['id_almacen']=$id_almacen;
                                                if($this->mdetallerecepcion->valInsert($dataList['id'],$idEmpresa)){
                                                    $this->mdetallerecepcion->insertar($dataList);
                                                    $count["rd"]["i"]++;
                                                }else if($this->mdetallerecepcion->valUpdate($dataList['id'],$dataList)){
                                                    $this->mdetallerecepcion->actualiza($dataList,$dataList['id']);
                                                    $count["rd"]["u"]++;
                                                }
                                                array_push($count["rd"]["ids"],$dataList['id']); 
                                                $count["rd"]["t"]++;
                                            }
                                            break;
                                        default:
                                            $data[$k]=$v;
                                            break;
                                    }
                                }
                                //Validaciones de sincronizacion de recepcion
                                $data['idEmpresa']=$idEmpresa;
                                $data['idPaquete']=$idPaquete;
                                if($this->mrecepcion->valInsert($data['id'],$idEmpresa)){
                                    $this->mrecepcion->insertar($data);
                                    $count["r"]["i"]++;
                                }else if($this->mrecepcion->valUpdate($data['id'],$data)){
                                    $this->mrecepcion->actualiza($data,$data['id']);
                                    $count["r"]["i"]++;
                                }
                                array_push($count["r"]["ids"],$data['id']);
                                $count["r"]["t"]++;
                                //eliminaciones
                                $id_recepcion=$data['id'];
                                $ids=implode(",",$count["rd"]["ids"]);
                                ($retorno==1) ? print("Detalle recepcion: ".$ids."<br>") : '';
                                ($eliminar == 1) ? $this->db->query("DELETE FROM detalle_recepcion WHERE (idEmpresa=$idEmpresa AND id_almacen=$id_almacen AND id_recepcion=$id_recepcion AND id NOT IN (".$ids."))") : '';
                                echo ($this->db->affected_rows() > 0 && $retorno==1) ? "Afectados Detalle Recepcion: ".$this->db->affected_rows()."<br>" : '';
                                break;
                        }
                    } //fin de foreach principal
                }
                //eliminaciones aunque no exista nada
                switch ($type) {
                    case 'O':
                        $ids=implode(",",$count["o"]["ids"]);
                        ($retorno==1) ? print("Mi orden: ".$ids."<br>") : '';
                        ($eliminar == 1) ? $this->db->query("DELETE FROM orden_compra WHERE (idEmpresa=$idEmpresa AND id_almacen=$id_almacen AND id NOT IN (".$ids."))") : '';
                        echo ($this->db->affected_rows() > 0 && $retorno==1) ? "Afectados Orden: ".$this->db->affected_rows()."<br>" : '';
                        ($eliminar == 1) ? $this->db->query("DELETE FROM detalle_orden WHERE (idEmpresa=$idEmpresa AND id_almacen=$id_almacen AND id_orden_compra NOT IN (".$ids."))") : '';
                        echo ($this->db->affected_rows() > 0 && $retorno==1) ? "Afectados Detalle Orden: ".$this->db->affected_rows()."<br>" : '';
                        break;
                    case 'C':
                        $ids=implode(",",$count["c"]["ids"]);
                        ($retorno==1) ? print("Mi Compra: ".$ids."<br>") : '';
                        ($eliminar == 1) ? $this->db->query("DELETE FROM compra WHERE (idEmpresa=$idEmpresa AND id_almacen=$id_almacen AND id NOT IN (".$ids."))") : '';
                        echo ($this->db->affected_rows() > 0 && $retorno==1) ? "Afectados Compra: ".$this->db->affected_rows()."<br>" : '';
                        ($eliminar == 1) ? $this->db->query("DELETE FROM detalle_compra WHERE (idEmpresa=$idEmpresa AND id_almacen=$id_almacen AND id_compra NOT IN (".$ids."))") : '';
                        echo ($this->db->affected_rows() > 0 && $retorno==1) ? "Afectados Detalle Compra: ".$this->db->affected_rows()."<br>" : '';
                        break;
                    case 'R':
                        $ids=implode(",",$count["r"]["ids"]);
                        ($retorno==1) ? print("Mi recepcion: ".$ids."<br>") : '';
                        ($eliminar == 1) ? $this->db->query("DELETE FROM recepcion WHERE (idEmpresa=$idEmpresa AND id_almacen=$id_almacen AND id NOT IN (".$ids."))") : '';
                        echo ($this->db->affected_rows() > 0 && $retorno==1) ? "Afectados Recepcion: ".$this->db->affected_rows()."<br>" : '';
                        ($eliminar == 1) ? $this->db->query("DELETE FROM detalle_recepcion WHERE (idEmpresa=$idEmpresa AND id_almacen=$id_almacen AND id_recepcion NOT IN (".$ids."))") : '';
                        echo ($this->db->affected_rows() > 0 && $retorno==1) ? "Afectados Detalle Recepcion: ".$this->db->affected_rows()."<br>" : '';
                        break;
                }

            }
        }
    }
    public function GetPrecioUnitarioCM($data){
        $precioUnitario=0;
        //['un' => 1, 'id_proveedor' => 343, 'id_articulo' => 9610]
        $response=$this->myCurl("GetPrecioUnitarioCM",$data);
        if(isset($response->object_result)){
            if(is_numeric($response->object_result->precio_unitario)){
                $precioUnitario = $response->object_result->precio_unitario;
            }
        }
        return $precioUnitario;
    }

    public function myCurl($endpoint,$datos){
        $curl = curl_init();
        //INFORMACION A ENVIAR POR POST EN FORMATO JSON
        $datos = json_encode($datos);

        curl_setopt_array($curl, array(
            CURLOPT_PORT => $this->port,
            CURLOPT_URL => $this->config->item('dnsmicro').$endpoint,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 20,
            CURLOPT_TIMEOUT => 1000000,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_FOLLOWLOCATION => 1,
            CURLOPT_POSTFIELDS => $datos,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "postman-token: ab5bf890-47c6-d504-ba8f-82667b58bebd",
                'Content-Type:application/json'
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);

        $json = [];
        if ($err) {
            return "cURL Error #:" . $err;
        }else{
            $json = $response;
            // Comprueba el código de estado HTTP
            if (!curl_errno($curl)) {
              switch ($http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE)) {
                case 200:
                    $json = json_decode($json);
                    return $json;
                    break;
                case 404:
                    echo "Not found";
                    break;
                default:
                    echo 'Unexpected HTTP code: ', $http_code, "\n";
              }
            }
        }
        curl_close($curl);
    }

 

}