<?php
defined('BASEPATH') OR exit('No direct script access allowed');
date_default_timezone_set('America/Mexico_City');
class Fraccionamientos extends MX_Controller {
	public $data,$vParameters,$mainView,$fv;
	public function __construct(){
        $this->nsession = $this->config->item('nsession');
        if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'fraccionamientos'; // form validation variable
            $this->mainView = 'fraccionamientos';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/fraccionamientos/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mfraccionamiento','musuario','mfraccionamientoxusuario','mprototipoxfraccionamiento','mprototipos'));

            // Lbrerias
            // $this->load->library(array('email','session'));
           	$this->data['fotos_www'] = $this->config->item('base_www').'/fraccionamientos/';
            
            //Validación de usuarios
            valSession("ventas",$this->fv);
    }

	public function index(){
		$data['q'] = '';
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

    public function guardar($idFraccionamiento){
        $_SESSION[$this->nsession]['idFraccionamiento']=$idFraccionamiento;
        $_SESSION[$this->nsession]['fraccionamiento']=$this->mfraccionamiento->getCampo("titulo", $idFraccionamiento);
        $_SESSION[$this->nsession]['foto']=$this->mfraccionamiento->getCampo("thumbnail", $idFraccionamiento);
        redirect('blackboard');
    }

    public function dash(){
        $data['q'] = '';
        $data['fraccionamientos'] = $this->mfraccionamiento->getAllFraccionamientos();//getFraccionamientos()
        $this->data['contenido'] = $this->load->view($this->mainView.'/dash_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
    }

    public function aviso(){
        $data['q'] = '';
        //$data['fraccionamientos'] = $this->mfraccionamiento->getFraccionamientos();
        $this->data['contenido'] = $this->load->view($this->mainView.'/aviso_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
    }

    public function listado(){
        $q = $this->mfraccionamiento->getAll();

        if (!is_numeric($q)){
            foreach ($q->result() as $row){
                $array['aaData'][] = array(
                    'titulo' => $row->titulo,
                    'estado' => $row->estado,
                    'municipio' => $row->municipio,
                    'acciones' => acciones($row->id,$this->router->class, false, true, false)
                    );
            }
        } else{
            $array['aaData'][] = array(
                'titulo' => 'No hay registros',
                'estado' => 'No hay registros',
                'municipio' => 'No hay registros',
                'acciones' => 'No hay registros'
                );

        }

        echo json_encode($array);
    }

    public function nuevo()
    {
        // Mensajes
        $data['msg'] = '';
        $resultado = true;
        //array para select multiple
        $data['tecnik'] = '';
        $data['gteV'] = '';
        $data['promotor'] = '';
        $data['gestor'] = '';
        $data['postventa'] = '';
        $data['contabilidad'] = '';

        $data['promotores'] = $this->musuario->getPromotoresBySelectResultAll();
        $data['tecnica'] = $this->musuario->getTecnicaBySelectResult();
        $data['gteVentas'] = $this->musuario->getGteVBySelectResult();
        $data['gestoria'] = $this->musuario->getGestoriaBySelectResult();
        $data['postventas'] = $this->musuario->getPostventaBySelectResult();
        $data['contabilidads'] = $this->musuario->getContabilidadBySelectResult();

        $this->load->library('form_validation');
        if ($this->form_validation->run($this->fv) == FALSE) {
            $data['msg'] = validation_errors();
        } else {

            // Subida de imagenes
            $config = array();
            $this->load->library('upload', $config);
            $this->load->library('image_lib');
            if (isset($_FILES)){
                $imagenes = array();
                foreach($_FILES as $key=>$value){
                    if ($_FILES[$key]['size'] > 0){
                        $_FILES[$key]['name'] = strtolower($_FILES[$key]['name']);
                        $imagenes[] = $key;
                    }
                }
                $totalImagenes = count($imagenes);

                for($i=0; $i< $totalImagenes; $i++){
                    $ext = pathinfo($_FILES[$imagenes[$i]]['name'],PATHINFO_EXTENSION);
                    //Configuracion del thumbnail
                    if($imagenes[$i]!='foto'){
                        $nCampoC = explode("_",$imagenes[$i]);
                        $tipo = $nCampoC[0];
                        $v = $nCampoC[1];

                    } else {
                        $v = 0;
                        $tipo = 'foto';
                    }
                    if ($tipo == 'foto'){
                        //echo 'es tipo foto<br>';
                        $uploaddir = $this->data['fotos_www'];
                        $configT['upload_path'] = $uploaddir;
                        $configT['image_library'] = 'gd2';
                        $configT['create_thumb'] = TRUE;
                        $configT['maintain_ratio'] = FALSE;
                        $configT['width'] = 223;
                        $configT['height'] = 84;
                        //Configuracion de la libreria upload
                        $nextId = $this->mfraccionamiento->nextId();
                        $config['file_name'] =  $nextId."_".$v;
                        $config['overwrite'] = TRUE;
                        $config['upload_path'] = $uploaddir;
                        $config['max_size'] = '1024';
                        $config['allowed_types'] = 'gif|jpg|png';
                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload($imagenes[$i]) )
                        {
                            $redirect = 1;
                            $data['error'] = $this->upload->display_errors();
                        }
                        else
                        {
                            $dataFile = $this->upload->data($imagenes[$i]);
                            $fotoI = 'foto_'.$v;
                            $thumbI = 'thumbnail_'.$v;
                            if ($v == 0){
                                //Foto default
                                $pData['foto'] = $nextId.'_'.$v.'.'.$ext;//$dataFile['file_ext'];// Se crea el thumbnail
                                $configT['source_image'] = $uploaddir.$pData['foto'];
                                $this->image_lib->clear();
                                $this->image_lib->initialize($configT);
                                $this->image_lib->resize();
                                $pData['thumbnail'] = $nextId.'_'.$v.'_thumb.'.$ext;//$dataFile['file_ext'];//Nombre thumbnail
                            } else {
                                $pData[$fotoI] = $nextId.'_'.$v.'.'.$ext;//$dataFile['file_ext'];// Se crea el thumbnail
                                $configT['source_image'] = $uploaddir.$pData[$fotoI];
                                $this->image_lib->clear();
                                $this->image_lib->initialize($configT);
                                $this->image_lib->resize();
                                $pData[$thumbI] = $nextId.'_'.$v.'_thumb.'.$ext;//$dataFile['file_ext'];//Nombre thumbnail
                            }
                        }
                    }

                }
            }

            $pData['titulo'] = strtoupper($this->input->post('titulo', TRUE));
            $pData['estado'] = $this->input->post('estado', TRUE);
            $pData['municipio'] = $this->input->post('municipio', TRUE);
            $pData['colonia'] = $this->input->post('colonia', TRUE);
            $pData['cp'] = $this->input->post('cp', TRUE);
            $pData['status'] = 1;

            //$tecnik = $this->input->post('tecnik', TRUE);
            $tecnik = $_POST['tecnik'];
            //$gteV = $this->input->post('gteV', TRUE);
            $gteV = $_POST['gteV'];
            //$promotor = $this->input->post('promotor', TRUE);
            $promotor = $_POST['promotor'];
            //$gestor = $this->input->post('gestor', TRUE);
            $gestor = $_POST['gestor'];
            //$postventa = $this->input->post('postventa', TRUE);
            $postventa = $_POST['postventa'];
            //$contabilidad = $this->input->post('contabilidad', TRUE);
            $contabilidad = $_POST['contabilidad'];
            //$prototipos = $this->input->post('group-b', TRUE);

            //$prototipos = $this->input->post('prototipos',TRUE);
            $prototipos = $_POST['prototipos'];

            //agregamos a arrays los usuarios que se elegieron en el select multiple
            $push_personal = array();
            if (is_array($tecnik) && !empty($tecnik) && count($tecnik)>0){
                foreach ($tecnik as $t) {
                    $data['tecnik'] .= "-".$t;
                }
                array_push($push_personal, $tecnik);
            }
            if (is_array($gteV) && !empty($gteV) && count($gteV)>0){
                foreach ($gteV as $g) {
                    $data['gteV'] .= "-".$g;
                }
                array_push($push_personal, $gteV);
            }
            if (is_array($promotor) && !empty($promotor) && count($promotor)>0){
                foreach ($promotor as $p) {
                    $data['promotor'] .= "-".$p;
                }
                array_push($push_personal, $promotor);
            }
            if (is_array($gestor) && !empty($gestor) && count($gestor)>0){
                foreach ($gestor as $ge) {
                    $data['gestor'] .= "-".$ge;
                }
                array_push($push_personal, $gestor);
            }
            if (is_array($postventa) && !empty($postventa) && count($postventa)>0){
                foreach ($postventa as $pv) {
                    $data['postventa'] .= "-".$pv;
                }
                array_push($push_personal, $postventa);
            }
            if (is_array($contabilidad) && !empty($contabilidad) && count($contabilidad)>0){
                foreach ($contabilidad as $cb) {
                    $data['contabilidad'] .= "-".$cb;
                }
                array_push($push_personal, $contabilidad);
            }

            //iniciamos la insersion por transacción ya que son dos tablas ivolucradas, fraccionamientos y fraccionamientosxusuarios
            $this->db->trans_start();
            $id = $this->mfraccionamiento->insertar($pData);
            //verificamos si el select de gerente tiene un id >0, sis es así insertamos en fraccxuser
            /*if ($gteV>0){
                $fxuData['idFraccionamiento'] = $id;
                $fxuData['idUsuario'] = $gteV;
                $this->mfraccionamientoxusuario->insertar($fxuData);
            }*/

            $arrayIdUsuario = array();
            $pushFraccxUs = array();
            if (is_array($push_personal) && count($push_personal)>0 && $id > 0){
                //campos de auditoría:created_by, crated,etc.. en las tablas
                $sessionId = (isset($_SESSION[$this->nsession]['id']) && (!empty($_SESSION[$this->nsession] ['id'])) ? $_SESSION[$this->nsession]['id'] : 0);
                $date = date("Y-m-d H:i:s");
                $created = date("Y-m-d H:i:s");
                $updated = date("Y-m-d H:i:s");
                $created_by = $sessionId;
                $updated_by = $sessionId;

                foreach ($push_personal as $key => $value) {
                    foreach ($value as $idUsuario) { //este array contiene los ids de usuarios
                        $arrayIdUsuario = array(
                            "idFraccionamiento" => $id,
                            "idUsuario" => $idUsuario,
                            "created" => $created,
                            "updated" => $updated,
                            "created_by" => $created_by,
                            "updated_by" => $updated_by
                        );
                        array_push($pushFraccxUs, $arrayIdUsuario);
                    }
                }
            }

            if (count($pushFraccxUs)>0 && !empty($pushFraccxUs) ) {
                $this->db->insert_batch('fraccionamientosxusuarios', $pushFraccxUs); //insertamos el batch de usuarios a ese fraccionamiento
            }
            //actualizar created_by de promotores en base al id del gerente agregado al fraccionamiento
            /* 
            if (is_array($promotor) && !empty($promotor) && count($promotor)>0 && $gteV>0 ){
                foreach ($promotor as $idP) {
                    $this->musuario->update($idP,array('created_by' =>$gteV , 'updated_by' =>$gteV));
                }
            }*/
            //Obtiene todos los promotores
            $query=$this->db->query("SELECT id FROM usuarios WHERE rol=2;");
            if($query->num_rows() > 0){
                foreach ($query->result() as $row) {
                    $idPromotor=$row->id;
                    $gerentes="";
                    //Obtiene todos tus gerentes partiendo de los fraccionamientos en los que te encuentras
                    $query2=$this->db->query("SELECT u.id FROM fraccionamientosxusuarios AS fxu, usuarios AS u WHERE
                    idUsuario=u.id AND u.rol=4 AND idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$idPromotor) GROUP BY u.id;");
                    if($query2->num_rows() > 0){
                        foreach ($query2->result() as $row2) {
                            $gerentes.=$row2->id." ";
                        }
                    }
                    //Actualiza created_ by con los gerentes de tus fraccionamientos
                    $this->db->query("UPDATE usuarios SET created_by='$gerentes' WHERE id=".$row->id);
                }
            }

            // Asociar catalogo de prototipos con fracionamiento
            $arrayPrototipos = array();
            $pushPrototipos = array();
            if ( is_array($prototipos) && count($prototipos) > 0 && $id > 0 ) {
                $sessionId = (isset($_SESSION[$this->nsession]['id']) && (!empty($_SESSION[$this->nsession] ['id'])) ? $_SESSION[$this->nsession]['id'] : 0);
                $date = date("Y-m-d H:i:s");
                $created = date("Y-m-d H:i:s");
                $updated = date("Y-m-d H:i:s");
                $created_by = $sessionId;
                $updated_by = $sessionId;
                
                foreach ($prototipos as $idProrotipo) {
                    $arrayPrototipos = array(
                        "idFraccionamiento" => $id,
                        "titulo" => '',
                        "idPrototipo" => $idProrotipo,
                        "status" => 1,
                        "created" => $created,
                        "updated" => $updated,
                        "created_by" => $created_by,
                        "updated_by" => $updated_by
                    );
                    array_push($pushPrototipos, $arrayPrototipos);
                }
            }
            if ( count($pushPrototipos) > 0 && !empty($pushPrototipos) ) {
                $this->db->insert_batch('prototiposxfraccionamiento', $pushPrototipos); //insertamos el batch de usuarios a ese fraccionamiento
            }

            //Logica para insersion de prototipos por fraccionamiento
            /*$arrayPrototipos = array();
            $pushProtoxFracc = array();
            if (is_array($prototipos) && count($prototipos)>0 && $id>0){
                for ($i=0; $i < count($prototipos) ; $i++) {
                    if ($prototipos[$i]['prototipo'] !=''){
                        $arrayPrototipos = array(
                            "idFraccionamiento" => $id,
                            "titulo" => $prototipos[$i]['prototipo'],
                        );
                        array_push($pushProtoxFracc, $arrayPrototipos);
                    }

                }
            }
            if (count($pushProtoxFracc)>0 && !empty($pushProtoxFracc) ) {
                $this->db->insert_batch('prototiposxfraccionamiento', $pushProtoxFracc); //insertamos el batch de prototipos a ese fraccionamiento en la tabla prototiposxfraccionamiento
            }*/

            $this->db->trans_complete();
            if ($this->db->trans_status() === FALSE)
            {
                $resultado = false;
                $data['msgInvalid'] = 'El registro no pudo ser insertado en la BD, verifique la información que intenta guardar';
            }
            if ($resultado==true) {
                redirect($this->router->class."/dash");
            }
        }

        $data['prototipos_'] = $this->mprototipos->getAll();
        $this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
        $this->load->view('templates/main_template', $this->data);

    }

    public function editar($id)
    {
        // Mensajes
        $msg = '';
        $resultado = true;
        // Obteniendo la información
        $info = $this->mfraccionamiento->getById($id);

        $data = $info;

        //array para select multiple
        $data['tecnik'] = '';
        $data['gteV'] = '';
        $data['promotor'] = '';
        $data['gestor'] = '';
        $data['postventa'] = '';
        $data['contabilidad'] = '';

        /* VALIDAR FORMULARIO*/
        $this->load->library('form_validation');

        if (isset($_POST['titulo'])) {
            if ($this->form_validation->run($this->fv) == FALSE) {
                $msg = validation_errors();
            } else {

                $nextId = $id;
                // Subida de imagenes
                $config = array();
                $this->load->library('upload', $config);
                $this->load->library('image_lib');

                if (isset($_FILES)){
                    $imagenes = array();
                    foreach($_FILES as $key=>$value){
                        if ($_FILES[$key]['size'] > 0){
                            $_FILES[$key]['name'] = strtolower($_FILES[$key]['name']);
                            $imagenes[] = $key;
                        }
                    }
                    $totalImagenes = count($imagenes);
                    for($i=0; $i< $totalImagenes; $i++){
                        //Configuracion del thumbnail
                        $ext = pathinfo($_FILES[$imagenes[$i]]['name'],PATHINFO_EXTENSION);
                        if($imagenes[$i]!='foto'){
                            $nCampoC = explode("_",$imagenes[$i]);
                            $tipo = $nCampoC[0];
                            $v = $nCampoC[1];
                        } else {
                            $v = 0;
                            $tipo = 'foto';
                        }
                        if ($tipo == 'foto'){
                            $uploaddir = $this->data['fotos_www'];
                            $configT['upload_path'] = $uploaddir;
                            $configT['image_library'] = 'gd2';
                            $configT['create_thumb'] = TRUE;
                            $configT['maintain_ratio'] = FALSE;
                            $configT['width'] = 223;
                            $configT['height'] = 84;
                            //Configuracion de la libreria upload
                            $nextId = $id;
                            $config['file_name'] =  $nextId."_".$v;
                            $config['overwrite'] = TRUE;
                            $config['upload_path'] = $uploaddir;
                            $config['max_size'] = '1024';
                            $config['allowed_types'] = 'gif|jpg|png';
                            $this->upload->initialize($config);

                            if ( ! $this->upload->do_upload($imagenes[$i]))
                            {
                                $redirect = 1;
                                $data['error'] = $this->upload->display_errors();
                            }
                            else
                            {
                                $dataFile = $this->upload->data($imagenes[$i]);
                                //echo $ext;exit();
                                $fotoI = 'foto_'.$v;
                                $thumbI = 'thumbnail_'.$v;
                                if ($v == 0){
                                    //Foto default
                                    $pData['foto'] = $nextId.'_'.$v.".".$ext;//$dataFile['file_ext'];// Se crea el thumbnail
                                    $configT['source_image'] = $uploaddir.$pData['foto'];
                                    $this->image_lib->clear();
                                    $this->image_lib->initialize($configT);
                                    $this->image_lib->resize();
                                    $pData['thumbnail'] = $nextId.'_'.$v.'_thumb.'.$ext;//$dataFile['file_ext'];//Nombre thumbnail
                                } else {
                                    $pData[$fotoI] = $nextId.'_'.$v.'.'.$ext;//$dataFile['file_ext'];// Se crea el thumbnail
                                    $configT['source_image'] = $uploaddir.$pData[$fotoI];
                                    $this->image_lib->clear();
                                    $this->image_lib->initialize($configT);
                                    $this->image_lib->resize();
                                    $pData[$thumbI] = $nextId.'_'.$v.'_thumb.'.$ext;//$dataFile['file_ext'];//Nombre thumbnail
                                }
                            }
                        }

                    }
                }

                $pData['titulo'] = strtoupper($this->input->post('titulo', TRUE));
                $pData['estado'] = $this->input->post('estado', TRUE);
                $pData['municipio'] = $this->input->post('municipio', TRUE);
                $pData['colonia'] = $this->input->post('colonia', TRUE);
                $pData['cp'] = $this->input->post('cp', TRUE);
                $pData['status'] =$this->input->post('status',TRUE);

                //$tecnik = $this->input->post('tecnik', TRUE);
                $tecnik = $_POST['tecnik'];
                //$gteV = $this->input->post('gteV', TRUE);
                $gteV = $_POST['gteV'];
                //$promotor = $this->input->post('promotor', TRUE);
                $promotor = $_POST['promotor'];
                //$gestor = $this->input->post('gestor', TRUE);
                $gestor = $_POST['gestor'];
                //$postventa = $this->input->post('postventa', TRUE);
                $postventa = $_POST['postventa'];
                //$contabilidad = $this->input->post('contabilidad', TRUE);
                $contabilidad = $_POST['contabilidad'];
                // $prototipos = $this->input->post('group-b', TRUE);
                // $prototiposExistentes = $this->input->post('prototipoExistenteId', TRUE);
                //$prototipos = $this->input->post('prototipos',TRUE);
                $prototipos = $_POST['prototipos'];
                
                // print_r($prototipos); exit();
                //agregamos a arrays los usuarios que se elegieron en el select multiple
                $push_personal = array();
                if (is_array($tecnik) && !empty($tecnik) && count($tecnik)>0){
                    /* 
                    foreach ($tecnik as $t) {
                        $data['tecnik'] .= "-".$t;
                    }*/
                    array_push($push_personal, $tecnik);
                }
                if (is_array($gteV) && !empty($gteV) && count($gteV)>0){
                    /* 
                    foreach ($gteV as $g) {
                        $data['gteV'] .= "-".$g;
                    }*/
                    array_push($push_personal, $gteV);
                }
                if (is_array($promotor) && !empty($promotor) && count($promotor)>0){
                    /* 
                    foreach ($promotor as $p) {
                        $data['promotor'] .= "-".$p;
                    }*/
                    array_push($push_personal, $promotor);
                }
                if (is_array($gestor) && !empty($gestor) && count($gestor)>0){
                    /* 
                    foreach ($gestor as $ge) {
                        $data['gestor'] .= "-".$ge;
                    }*/
                    array_push($push_personal, $gestor);
                }
                if (is_array($postventa) && !empty($postventa) && count($postventa)>0){
                    /* 
                    foreach ($gestor as $ge) {
                        $data['gestor'] .= "-".$ge;
                    }*/
                    array_push($push_personal, $postventa);
                }
                if (is_array($contabilidad) && !empty($contabilidad) && count($contabilidad)>0){
                    /* 
                    foreach ($gestor as $ge) {
                        $data['gestor'] .= "-".$ge;
                    }*/
                    array_push($push_personal, $contabilidad);
                }

                //iniciamos la insersion por transacción ya que son dos tablas ivolucradas, fraccionamientos y fraccionamientosxusuarios
                $this->db->trans_start();
                $this->mfraccionamiento->actualizar($pData, $id);
                $arrayIdUsuario = array();
                $pushFraccxUs = array();
                $this->borrarFxU($id);//eliminamos las coincidencias de fraccionamientosxUsuarios para insertar de nuevo esta relacion en la tabla fraccxuser
                $this->borrarPxF($id);//eliminamos las coincidencias de prototiposxFraccionamientos para insertar de nuevo esta relacion en la tabla protoxFracc
                /*if ($gteV>0){
                    $fxuData['idFraccionamiento'] = $id;
                    $fxuData['idUsuario'] = $gteV;
                    $this->mfraccionamientoxusuario->insertar($fxuData);
                }*/
                if (is_array($push_personal) && count($push_personal)>0 && $id > 0){
                    //campos de auditoría:created_by, crated,etc.. en las tablas
                    $sessionId = (isset($_SESSION[$this->nsession]['id']) && (!empty($_SESSION[$this->nsession] ['id'])) ? $_SESSION[$this->nsession]['id'] : 0);
                    $date = date("Y-m-d H:i:s");
                    $created = date("Y-m-d H:i:s");
                    $updated = date("Y-m-d H:i:s");
                    $created_by = $sessionId;
                    $updated_by = $sessionId;

                    foreach ($push_personal as $key => $value) {
                        foreach ($value as $idUsuario) { //este array contiene los ids de usuarios
                            $arrayIdUsuario = array(
                                "idFraccionamiento" => $id,
                                "idUsuario" => $idUsuario,
                                "created" => $created,
                                "updated" => $updated,
                                "created_by" => $created_by,
                                "updated_by" => $updated_by
                            );
                            array_push($pushFraccxUs, $arrayIdUsuario);
                        }
                    }
                }
                if (count($pushFraccxUs)>0 && !empty($pushFraccxUs) ) {
                    $this->db->insert_batch('fraccionamientosxusuarios', $pushFraccxUs); //insertamos el batch de usuarios a ese fraccionamiento
                }

                /*if (is_array($promotor) && !empty($promotor) && count($promotor)>0 && $gteV>0 ){
                    foreach ($promotor as $idP) {
                        $this->musuario->update($idP,array('created_by' =>$gteV , 'updated_by' =>$gteV));
                    }
                }*/
                //Obtiene todos los promotores
                $query=$this->db->query("SELECT id FROM usuarios WHERE rol=2;");
                if($query->num_rows() > 0){
                    foreach ($query->result() as $row) {
                        $idPromotor=$row->id;
                        $gerentes="";
                        //Obtiene todos tus gerentes partiendo de los fraccionamientos en los que te encuentras
                        $query2=$this->db->query("SELECT u.id FROM fraccionamientosxusuarios AS fxu, usuarios AS u WHERE
                        idUsuario=u.id AND u.rol=4 AND idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$idPromotor) GROUP BY u.id;");
                        if($query2->num_rows() > 0){
                            foreach ($query2->result() as $row2) {
                                $gerentes.=$row2->id." ";
                            }
                        }
                        //Actualiza created_ by con los gerentes de tus fraccionamientos
                        $this->db->query("UPDATE usuarios SET created_by='$gerentes' WHERE id=".$row->id);
                    }
                }
                
                // Asociar catalogo de prototipos con fracionamiento
                $arrayPrototipos = array();
                $pushPrototipos = array();
                if ( is_array($prototipos) && count($prototipos) > 0 && $id > 0 ) {
                    $sessionId = (isset($_SESSION[$this->nsession]['id']) && (!empty($_SESSION[$this->nsession] ['id'])) ? $_SESSION[$this->nsession]['id'] : 0);
                    $date = date("Y-m-d H:i:s");
                    $created = date("Y-m-d H:i:s");
                    $updated = date("Y-m-d H:i:s");
                    $created_by = $sessionId;
                    $updated_by = $sessionId;
                    
                    foreach ($prototipos as $idProrotipo) {
                        $arrayPrototipos = array(
                            "idFraccionamiento" => $id,
                            "titulo" => '',
                            "idPrototipo" => $idProrotipo,
                            "status" => 1,
                            "created" => $created,
                            "updated" => $updated,
                            "created_by" => $created_by,
                            "updated_by" => $updated_by
                        );
                        array_push($pushPrototipos, $arrayPrototipos);
                    }
                }
                if ( count($pushPrototipos) > 0 && !empty($pushPrototipos) ) {
                    $this->db->insert_batch('prototiposxfraccionamiento', $pushPrototipos); //insertamos el batch de usuarios a ese fraccionamiento
                }
                
                //Logica para insersion de prototipos por fraccionamiento
                /*$arrayPrototipos = array();
                $pushProtoxFracc = array();
                if (is_array($prototipos) && count($prototipos)>0 && $id>0){
                    for ($i=0; $i < count($prototipos) ; $i++) {
                        if ($prototipos[$i]['prototipo'] !=''){
                            $arrayPrototipos = array(
                                "idFraccionamiento" => $id,
                                "titulo" => $prototipos[$i]['prototipo'],
                            );
                            array_push($pushProtoxFracc, $arrayPrototipos);
                        }

                    }
                }
                if (count($pushProtoxFracc)>0 && !empty($pushProtoxFracc) ) {
                    $this->db->insert_batch('prototiposxfraccionamiento', $pushProtoxFracc); //insertamos el batch de prototipos a ese fraccionamiento en la tabla prototiposxfraccionamiento
                }

                //Checamos si exitían prototipos, a estos solo los actualizamos
                if (is_array($prototiposExistentes) && count($prototiposExistentes)>0 && !empty($prototiposExistentes) ) {
                    foreach ($prototiposExistentes as $idProrotipo => $nombrePrototipo) {
                        if ($nombrePrototipo!=''){
                            $updateProto['titulo'] = $nombrePrototipo;
                            $this->mprototipoxfraccionamiento->actualizar($updateProto, $idProrotipo);
                        }
                    }
                }*/

                $this->db->trans_complete();
                if ($this->db->trans_status() === FALSE)
                {
                    $resultado = false;
                    $data['msgInvalid'] = 'El registro no pudo ser insertado en la BD, verifique la información que intenta guardar';
                }
                if ($resultado==true) {
                    redirect($this->router->class."/dash");
                }
            }
        }

        $tecnica = $this->mfraccionamientoxusuario->getTecnicaSelectResultByIdFracc($id); //obtenemos usuarios registrados como tecnica en este fraccionamiento
        $gte = $this->mfraccionamientoxusuario->getGteVSelectResultByIdFracc($id); //obtenemos usuarios registrados como gte ventas
        $promot = $this->mfraccionamientoxusuario->getPromotoresSelectResultByIdFracc($id);  //obtenemos usuarios registrados como promotores
        $gest = $this->mfraccionamientoxusuario->getGestoriaSelectResultByIdFracc($id);  //obtenemos usuarios registrados como gestores
        $pvta = $this->mfraccionamientoxusuario->getPostventaSelectResultByIdFracc($id);  //obtenemos usuarios registrados como postventa
        $conta = $this->mfraccionamientoxusuario->getContabilidadSelectResultByIdFracc($id);  //obtenemos usuarios registrados como contabilidad

        if (!is_numeric($tecnica)){
            foreach ($tecnica->result() as $t) {
                $data['tecnik'] .= "-".$t->id; // array para precargar los valores en el multiselec, se antepone un guión
            }
        }
        if (!is_numeric($gte)){
            foreach ($gte->result() as $g) {
                $data['gteV'] .= "-".$g->id;
            }
        }
        if (!is_numeric($promot)){
            foreach ($promot->result() as $p) {
                $data['promotor'] .= "-".$p->id;
            }
        }
        if (!is_numeric($gest)){
            foreach ($gest->result() as $g) {
                $data['gestor'] .= "-".$g->id;
            }
        }
        if (!is_numeric($pvta)){
            foreach ($pvta->result() as $pv) {
                $data['postventa'] .= "-".$pv->id;
            }
        }
        if (!is_numeric($conta)){
            foreach ($conta->result() as $ct) {
                $data['contabilidad'] .= "-".$ct->id;
            }
        }
        //$data['gteV'] = $gte;
        $data['promotores'] = $this->musuario->getPromotoresBySelectResultAll(); // Obtenemos todos los promotores registrado en la BD sin importar el fraccionamiento
        $data['tecnica'] = $this->musuario->getTecnicaBySelectResult();
        $data['gteVentas'] = $this->musuario->getGteVBySelectResult();
        $data['gestoria'] = $this->musuario->getGestoriaBySelectResult();
        $data['postventas'] = $this->musuario->getPostventaBySelectResult();
        $data['contabilidads'] = $this->musuario->getContabilidadBySelectResult();

        $data['prototipos'] = $this->mprototipoxfraccionamiento->getByIdFraccionamiento($id);
        $data['prototypes_'] = '';
        if ( !is_numeric($data['prototipos']) ) { 
            foreach ($data['prototipos']->result() as $pt) {
                $data['prototypes_'] .= "-".$pt->idPrototipo; // array para precargar los valores en el multiselec, se antepone un guión
            }
        }
        
        $data['prototipos_'] = $this->mprototipos->getAll();
        
        $data['msg']=$msg;
        $this->data['contenido'] = $this->load->view($this->mainView . '/editar_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }
    
    public function borrarFxU($id){
          $sql = "DELETE FROM fraccionamientosxusuarios where idFraccionamiento=".$id;
          $this->db->query($sql);
    }
    
    public function borrarPxF($id){
          $sql = "DELETE FROM prototiposxfraccionamiento where idFraccionamiento=".$id;
          $this->db->query($sql);
    }

    public function eliminar(){
        $id = $this->input->post('elid');
        $q = $this->mfraccionamiento->getById($id);
        $cValor = "true";
        $this->mfraccionamiento->borrar($id);
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }

    public function eliminarprototipo()
    {
        $c_valor = "false";
        if (isset($_POST['elid'])){
            $id = $this->input->post('elid');
            $campo = $this->input->post('elcampo');
            if($id !="0"){
                $this->mprototipoxfraccionamiento->borrar($id);
                $c_valor = "true";
            }
            $data = json_encode(array("valor"=>$c_valor));
            echo $data;

        }
    }

    public function eliminarfoto($id=null){
        if(isset($_POST['elid']) || $id!=null){
            if(isset($_POST['elid'])){
               $id = $this->input->post('elid');
            }
            $campo = $this->input->post('elcampo'); //Obteniendo el nombre de la foto y thumbnail
            if($campo !="0"){$foto      = $this->mfraccionamiento->getCampo('foto_'.$campo,$id);
                $thumbnail = $this->mfraccionamiento->getCampo('thumbnail_'.$campo,$id);// Borrando los archivos fisicamente
                if((unlink($this->data['fotos_www']."/".$foto))&&(unlink($this->data['fotos_www']."/".$thumbnail))){// Haciendo update a la tabla
                    $c_data['foto_'.$campo] ='';
                    $c_data['thumbnail_'.$campo] ='';
                    $this->mfraccionamiento->actualizar($c_data,$id);
                    $c_valor = "true";
                }else{
                    $c_valor = "false";
                }
            }else{
                $foto = $this->mfraccionamiento->getCampo('foto',$id);
                $thumbnail = $this->mfraccionamiento->getCampo('thumbnail',$id);// Borrando los archivos fisicamente
                if((unlink($this->data['fotos_www']."/".$foto))&&(unlink($this->data['fotos_www']."/".$thumbnail))){// Haciendo update a la tabla
                    $c_data['foto'] ='';
                    $c_data['thumbnail'] ='';
                    $this->mfraccionamiento->actualizar($c_data,$id);
                    $c_valor = "true";
                }else{
                    $c_valor = "false";
                }
            }
            $data = json_encode(array("valor"=>$c_valor));
            echo $data;
        }
    }

}


