    <?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Formatospdf extends MX_Controller {
    public $data,$vParameters,$mainView,$fv,$idFraccionamiento=0;

    public function __construct(){
    $this->nsession = $this->config->item('nsession');
    if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'Formatospdf'; // form validation variable
            $this->mainView = 'Formatospdf';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/alta_venta/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','url','form','date','text','security','numeros'));
            // Modelos
            $this->load->model(array('maltaventa','mprospecto','mproyecto','mfraccionamiento','musuario', 'mgestoria','mnotaria','mentrega','mprototipos','mcartaasignacion','mactivos','mcategoria','mroles','mcomisiones', 'mmatrizcomisiones',
                //MODELOS PARA MO
                "mactividadesprototipo","mmanoobra","mpresupuestomo","mpresupuestomat","mmaterial","mpaquete","mconstructores","marranque","mcategoriamo","munidades","mactividadmo","mcontadocuentas","mcontadodetalle"
        ));
            // Lbrerias
            // $this->load->library(array('email','session'));
            $this->data['fotos_www'] = $this->config->item('base_www').'/Formatospdf/';

            // Debugging
            $this->output->enable_profiler(false);
            error_reporting(0);
           //Validación de usuarios
          // $this->config->set_item('rol',$_SESSION[$this->nsession]['rol']);
           //$this->allowed=sesiones($this->uri->segment(2),$_SESSION[$this->nsession]['rol'],permisos($this->fv));
    }

    public function setLogo()
    {
        $logoFraccionamiento = $this->mfraccionamiento->getCampo('foto',$this->idFraccionamiento);
        $nomFracc = $this->mfraccionamiento->getCampo('titulo',$this->idFraccionamiento);
        $this->urlLogo = ($logoFraccionamiento!='')?"<img height='80' src='uploads/fraccionamientos/".$logoFraccionamiento."' />":$nomFracc;
    }

	public function index()
	{
		$data['q'] = '';

        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

    public function resumenpmo($id = null){
        $this->load->library("mpdf_lib");
        $data = array();
        //$idPaquete = $this->mmanoobra->getCampo2('idPaquete', $idManoObra);
        $idPrototipo = $this->mmanoobra->getCampo2('idPrototipo', $id);
        $actividadesPresupuesto = $this->mpresupuestomo->getByIdManoObra($id);
        $empty = true;
        if(!is_numeric($actividadesPresupuesto)){
            $arrayPresupuestoMO = array();
            $arrayCategoria = array();
            $countArray = 0;
            foreach ($actividadesPresupuesto->result() as $row) {
                $existe = 0;
                $actividadPrototipo = $this->mactividadesprototipo->getById($row->idActividadPrototipo);
                if (!is_numeric($actividadPrototipo)) {
                    $actividad = $this->mactividadmo->getById($actividadPrototipo['idActividad']);
                    if (!is_numeric($actividad)) {
                        $empty = false;
                        $categoria = $this->mcategoriamo->getById($actividad['idCategoria']);
                        if(!is_numeric($categoria)){
                            if(count($arrayPresupuestoMO) > 0){
                                $countArray = count($arrayPresupuestoMO)-1;
                                for($j = 0; $j<=$countArray; $j++){
                                    if($arrayPresupuestoMO[$j]['clave'] == $categoria['clave']){
                                        $existe++;
                                        $precioUnitario = $arrayPresupuestoMO[$j]['precioUnitario'] + $row->precioUnitario;
                                        $importe = $arrayPresupuestoMO[$j]['importe'] + $row->importe;
                                        $arrayPresupuestoMO[$j]['precioUnitario'] = $precioUnitario;
                                        $arrayPresupuestoMO[$j]['importe'] = $importe;
                                    }
                                }
                                if($existe == 0){
                                    array_push($arrayPresupuestoMO, array('categoria' => $actividad['idCategoria'], 'tipo' => 'C', 'idPresupuesto' => 0, 'clave' => $categoria['clave'], 'descripcion' => $categoria['categoria'], 'unidad' => '', 'cantidad' => '', 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe));
                                }
                            }else{
                                array_push($arrayPresupuestoMO, array('categoria' => $actividad['idCategoria'], 'tipo' => 'C', 'idPresupuesto' => 0, 'clave' => $categoria['clave'], 'descripcion' => $categoria['categoria'], 'unidad' => '', 'cantidad' => '', 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe));
                            }
                        }

                        $unidad = $this->munidades->getById($actividad['idUnidad']);
                        if(!is_numeric($unidad)){
                            array_push($arrayPresupuestoMO, array('categoria' => $actividad['idCategoria'], 'tipo' => 'A', 'idPresupuesto' => $row->id, 'clave' => $actividad['clave'], 'descripcion' => $actividad['descripcion'], 'unidad' => $unidad['abreviatura'], 'cantidad' => $actividadPrototipo['cantidad'], 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe));
                        }
                    }
                }
            }
        }
        $data["empty"]=$empty;
        $data["arrayPresupuestoMO"]=$arrayPresupuestoMO;
        $html = $this->load->view('formatospdf/resumen_view.php',$data,true);
            //echo $html;
            //exit();
        $this->mpdf_lib->downloadPDF($html,"resumen_pmo",0);
    }       
    
    public function arranque($id = null){
        $idPaquetes=$this->marranque->getCampo("idPaquetes",$id);
        $idPaquetes=explode(",", $idPaquetes);
        $this->load->library("mpdf_lib");
        $data = array();

        //ENCABEZADO
        $data["idPaquetes"]=$idPaquetes;
        $data["paquete"]=$this->mpaquete->getById($idPaquetes[0]);
        $data["fraccionamiento"]=$this->mfraccionamiento->getCampo("titulo",$this->mmanoobra->getCampo("idFraccionamiento",$data["paquete"]["idManoObra"]));
        $data["numeroContrato"] = $this->marranque->getCampo("numeroContrato",$id);
        $html = $this->load->view('formatospdf/arranque_view.php',$data,true);
                echo $html;
                exit();
        $nombre="Hoja de Arranque - ".$this->marranque->getCampo("titulo",$id). '(' . date('d-m-Y') . ')"';
        $this->mpdf_lib->downloadPDF($html,$nombre,0);
    }   

    public function reglamentoObra($id = null){
        $this->load->library("mpdf_lib");
        $data = array();
        $nombre="Reglamento - ".$this->marranque->getCampo("titulo",$id). '(' . date('d-m-Y') . ')"';
        $html = $this->load->view('formatospdf/reglamento_obra_view.php',$data,true);
        $this->mpdf_lib->downloadPDF($html,$nombre,0);
    }      

    public function confidencialidad($id = null){
        $idPaquetes=$this->marranque->getCampo("idPaquetes",$id);
        $idPaquetes=explode(",", $idPaquetes);
        $this->load->library("mpdf_lib");
        $data = array();
        //ENCABEZADO
        $data["idPaquetes"]=$idPaquetes;
        $paquete=$this->mpaquete->getById($idPaquetes[0]);
        $data["contratista"]=$this->mconstructores->getCampo("CONCAT(nombre,' ',apellidoP,' ',apellidoM)", $paquete["idConstructor"]);
        $data["domicilioFiscal"]=$this->mconstructores->getCampo("domicilioFiscal", $paquete["idConstructor"]);
        $data["numeroContrato"] = $this->marranque->getCampo("numeroContrato",$id);
        //print_r($data["numeroContrato"]);
        $nombre="Acuerdo de Confidencialidad - ".$this->marranque->getCampo("titulo",$id). '(' . date('d-m-Y') . ')"';
        $html = $this->load->view('formatospdf/confidencialidad_view.php',$data,true);
        $this->mpdf_lib->downloadPDF($html,$nombre,0);
    }   

    public function contratoMo($id = null){

        $this->load->library("mpdf_lib");
        $data = array();

        //paquete
        $idPaquetes=$this->marranque->getCampo("idPaquetes",$id);
        $idPaquetes=explode(",", $idPaquetes);
        $paquete=$this->mpaquete->getById($idPaquetes[0]);
        $data["fraccionamiento"]=$this->mfraccionamiento->getCampo("titulo",$this->mmanoobra->getCampo("idFraccionamiento",$paquete["idManoObra"]));

        //Contratista
        $data["contratista"]=$this->mconstructores->getCampo("CONCAT(nombre,' ',apellidoP,' ',apellidoM)", $paquete["idConstructor"]);
        $data["rfc"]=$this->mconstructores->getCampo("rfc", $paquete["idConstructor"]);
        $data["domicilioFiscal"]=$this->mconstructores->getCampo("domicilioFiscal", $paquete["idConstructor"]);

        //Arranque
        $data["numeroContrato"]=$this->marranque->getCampo("numeroContrato",$id);
        $idSupervisor=$this->marranque->getCampo("idSupervisor",$id);
        $data["supervisor"]=$this->musuario->getCampo("CONCAT(nombre,' ',apellidoP,' ',apellidoM)",$idSupervisor);
        $data["fecha_inicio"]=date_format(new DateTime($this->marranque->getCampo("fecha_inicio",$id)),"d-m-Y");
        $data["fecha_fin"]=date_format(new DateTime($this->marranque->getCampo("fecha_fin",$id)),"d-m-Y");
        $data["fechaFirma"]=date_format(new DateTime($this->marranque->getCampo("fechaFirma",$id)),"d-m-Y");
        foreach ($idPaquetes as $key => $id) {
            $paquete=$this->mpaquete->getById($id);
            $prototipo=$this->mprototipos->getCampo("nombre",$this->mmanoobra->getCampo("idPrototipo",$paquete["idManoObra"]));
            $lotesManzanas=contarLotesManzanas($paquete["rango_lotes"]);
            $data["totalViviendas"]+=$lotesManzanas["total"];
            $totalUnitarioMO = $this->mpresupuestomo->getSumTotalUnitario($paquete["idManoObra"]);
            $totalMOxPaquete += ($totalUnitarioMO * $lotesManzanas["total"]);
            if($key == 0){
                $data["prototiposLotes"]=$prototipo."(".$lotesManzanas["total"].")";
                $data["prototipos"]=$prototipo;
            }else{
                $separador=($key==COUNT($idPaquetes)-1) ? " Y " : ", ";
                $data["prototiposLotes"].=$separador.$prototipo."(".$lotesManzanas["total"].")";    
                $data["prototipos"].=$separador.$prototipo;
            }
        }
        $data["globalMOxPaquete"]=$totalMOxPaquete;

        $html = $this->load->view('formatospdf/contrato_mo_view.php',$data,true);
        //echo $html;
        //exit();
        $nombre="Contrato Mano de Obra - ".$this->marranque->getCampo("titulo",$id). '(' . date('d-m-Y') . ')"';
        $this->mpdf_lib->downloadPDF($html,$nombre,0);
    }      

    public function contratoMoMAt($id = null){
        $this->load->library("mpdf_lib");
        $data = array();

        //paquete
        $idPaquetes=$this->marranque->getCampo("idPaquetes",$id);
        $idPaquetes=explode(",", $idPaquetes);
        $paquete=$this->mpaquete->getById($idPaquetes[0]);
        $data["fraccionamiento"]=$this->mfraccionamiento->getCampo("titulo",$this->mmanoobra->getCampo("idFraccionamiento",$paquete["idManoObra"]));

        //Contratista
        $data["contratista"]=$this->mconstructores->getCampo("CONCAT(nombre,' ',apellidoP,' ',apellidoM)", $paquete["idConstructor"]);
        $data["rfc"]=$this->mconstructores->getCampo("rfc", $paquete["idConstructor"]);
        $data["domicilioFiscal"]=$this->mconstructores->getCampo("domicilioFiscal", $paquete["idConstructor"]);

        //Arranque
        $data["numeroContrato"]=$this->marranque->getCampo("numeroContrato",$id);
        $idSupervisor=$this->marranque->getCampo("idSupervisor",$id);
        $data["supervisor"]=$this->musuario->getCampo("CONCAT(nombre,' ',apellidoP,' ',apellidoM)",$idSupervisor);
        $data["fecha_inicio"]=date_format(new DateTime($this->marranque->getCampo("fecha_inicio",$id)),"d-m-Y");
        $data["fecha_fin"]=date_format(new DateTime($this->marranque->getCampo("fecha_fin",$id)),"d-m-Y");
        $data["fechaFirma"]=date_format(new DateTime($this->marranque->getCampo("fechaFirma",$id)),"d-m-Y");
        foreach ($idPaquetes as $key => $id) {
            $paquete=$this->mpaquete->getById($id);
            $prototipo=$this->mprototipos->getCampo("nombre",$this->mmanoobra->getCampo("idPrototipo",$paquete["idManoObra"]));
            $lotesManzanas=contarLotesManzanas($paquete["rango_lotes"]);
            $data["totalViviendas"]+=$lotesManzanas["total"];
            $totalUnitarioMO = $this->mpresupuestomo->getSumTotalUnitario($paquete["idManoObra"]);
            $totalMOxPaquete += ($totalUnitarioMO * $lotesManzanas["total"]);
            if($key == 0){
                $data["prototiposLotes"]=$prototipo."(".$lotesManzanas["total"].")";
                $data["prototipos"]=$prototipo;
            }else{
                $separador=($key==COUNT($idPaquetes)-1) ? " Y " : ", ";
                $data["prototiposLotes"].=$separador.$prototipo."(".$lotesManzanas["total"].")";    
                $data["prototipos"].=$separador.$prototipo;
            }
        }
        $data["globalMOxPaquete"]=$totalMOxPaquete;

        $html = $this->load->view('formatospdf/contrato_mo_mat_view.php',$data,true);
        //echo $html;
        //exit();
        $nombre="Contrato Mano de Obra y Materiales - ".$this->marranque->getCampo("titulo",$id). '(' . date('d-m-Y') . ')"';
        $this->mpdf_lib->downloadPDF($html,$nombre,0);
    }  
    
    public function promesa($id = null){
        $this->load->library("mpdf_lib");
        $data = array();
        $info = $this->maltaventa->getByIdAll($id);
        
        $data = $info;
        $data['mfraccionamiento'] = $this->mfraccionamiento; 
        $data['mpromotor'] = $this->musuario;
        $data['mprototipo'] = $this->mprototipos;

        $html = $this->load->view('formatospdf/promesa_view.php',$data,true);
            // echo $html;
            // exit();
        $this->mpdf_lib->downloadPDF($html,"promesa",0);
    }
    public function solicitud($id = null){
        $this->load->library("mpdf_lib");
        $data = array();
        $info = $this->maltaventa->getByIdForInfonavit($id);
        /*echo "<pre>";
        print_r($info);
        echo "</pre>";*/
        $data = $info;
        $data['mfraccionamiento'] = $this->mfraccionamiento; 
        $data['mpromotor'] = $this->musuario;
        $data['mprototipo'] = $this->mprototipos;

        $html = $this->load->view('formatospdf/solicitud_view.php',$data,true);
        /*echo $html;
        exit();*/
        $this->mpdf_lib->downloadPDFInfonavit($html,"solicitud",0);
    }
    public function compraventa($id = null){
        $this->load->library("mpdf_lib");
        $data = array();
        $info = $this->maltaventa->getByIdAll($id);
        
        $data = $info;
        $data['mfraccionamiento'] = $this->mfraccionamiento; 
        $this->idFraccionamiento = $info['idFraccionamiento'];
        $this->setLogo();
        $data['mpromotor'] = $this->musuario;
        $data['mprototipo'] = $this->mprototipos;

        $html = $this->load->view('formatospdf/compraventa_view.php',$data,true);
            // echo $html;
            // exit();
        $this->mpdf_lib->downloadPDF($html,"compraventa",0,'footer','header',$this->urlLogo,'','',false,false,$this->idFraccionamiento);

    }
    
    public function reglamento(){
        $this->load->library("mpdf_lib");
        $data = array();
        $html = $this->load->view('formatospdf/reglamento_view.php',$data,true);
       // echo $html;
       //      exit();
        $this->mpdf_lib->downloadPDF($html,"reglamento",0);
    }

    public function manual(){
        $this->load->library("mpdf_lib");
        $data = array();
        $html = $this->load->view('formatospdf/manual_view.php',$data,true);
        $this->mpdf_lib->downloadPDF($html,"manual",0);
    }
    
    
    public function pagare($id = null){
        $this->load->library("mpdf_lib");
        $data = array();

        $info = $this->maltaventa->getByIdAll($id);        
        $data = $info;     
        $data['mfraccionamiento'] = $this->mfraccionamiento; 
        $html = $this->load->view('formatospdf/pagare_view.php',$data,true);
        /*echo $html;
        exit();*/
        $this->mpdf_lib->downloadPDF($html,"pagare",0);
    }   


    public function vales($id = null){

        $this->load->library("mpdf_lib");
        $data = array();
        // obterner los datos del cliente y el lote
        $info = $this->maltaventa->getByIdAll($id);        
        $data = $info;      
        $html = $this->load->view('formatospdf/vales_view.php',$data,true);
        $this->mpdf_lib->downloadPDF($html,"vales",0);

        /*$this->load->library("mpdf_lib");
        $data = array();
        $html = $this->load->view('formatospdf/vales_view.php',$data,true);

        $this->mpdf_lib->downloadPDF($html,"vales",0);*/
    }   

    
    
    
    public function garantias($id = null){
        $this->load->library("mpdf_lib");
        $data = array();

        $info = $this->maltaventa->getByIdAll($id);
        $data = $info;  
        $data['mfraccionamiento'] = $this->mfraccionamiento;  

        $html = $this->load->view('formatospdf/garantias_view.php',$data,true);
        $this->mpdf_lib->downloadPDF($html,"garantias",0);

        $this->load->library("mpdf_lib");
        $data = array();
        $html = $this->load->view('formatospdf/garantias_view.php',$data,true);
            echo $html;
            exit();
        $this->mpdf_lib->downloadPDF($html,"garantias",0);
    }      

    //
    public function aceptacion($id = null){
        $this->load->library("mpdf_lib");
        $data = array();

        $this->load->library("mpdf_lib");
        $data = array();
        $html = $this->load->view('formatospdf/aceptacion_view.php',$data,true);
      /*   echo $html; exit();*/
        $this->mpdf_lib->downloadPDF($html,"aceptacion",0,'footer','header',$this->urlLogo,'titHeader');
    }     


    public function reciboPagoComision($id = null){
        $this->load->library("mpdf_lib");
        $data = array();
        $info = $this->maltaventa->getByIdAll($id);
        $this->idFraccionamiento = $info['idFraccionamiento'];
        $this->setLogo();
        $comision = $this->mcomisiones->getByIdAV($info['id']);
        $idComision = (!is_numeric($comision)) ? $comision['id'] : 0;
        $data['nomCliente'] = $this->mprospecto->getCampo('nombre',$info['idProspecto']);
        $data['apellidoPCliente'] = $this->mprospecto->getCampo('apellidoP',$info['idProspecto']);
        $data['apellidoMCliente'] = $this->mprospecto->getCampo('apellidoM',$info['idProspecto']);

        $data['fraccionamiento'] = $this->mfraccionamiento->getCampo('titulo',$info['idFraccionamiento']);
        $data['manzana'] = $info['manzana'];
        $data['lote'] = $info['lote'];
        //impuestos al 99
        $data['fraccionamiento'] = $this->mfraccionamiento->getCampo('titulo',$info['idFraccionamiento']);

        $data['porcentajeImptoPago1'] = $this->mcomisiones->getCampo('porcentajeImptoPago1',$idComision);
        $data['comisionTotal'] = $this->mcomisiones->getCampo('comision',$idComision);
        $data['porcentajePago1'] = $this->mcomisiones->getCampo('porcentajePago1',$idComision);
        $data['porcentajeComisionPago1'] = $this->mcomisiones->getCampo('porcentajeComision',$idComision);
        $data['fechaPago1'] = $this->mcomisiones->getCampo('fechaPago1',$idComision);

        $data['total'] = $this->mcomisiones->getCampo('totalPago1',$idComision);
        $data['precioVenta'] = $this->mproyecto->getCampo('precioVenta',$info['idProyecto']);
        $data['ronda'] = $this->mgestoria->getRondaByIdAv($id);

        $data['nomPromotor'] = $this->musuario->getCampo("nombre",$info['idPromotor']);
        $data['aPaternoPromotor'] = $this->musuario->getCampo("apellidoP",$info['idPromotor']);
        $data['aMaternoPromotor'] = $this->musuario->getCampo("apellidoM",$info['idPromotor']);

        //Al 90%
        $data['pago1'] = $this->mcomisiones->getCampo('pago1',$idComision);
        //Al 9%
        $data['imptoPago1'] = $this->mcomisiones->getCampo('imptoPago1',$idComision);

        $name = 'Recibo Pago 1_'.date('dmYhHi');
        $html = $this->load->view('formatospdf/recibo_pago_comision_view.php',$data,true);
        $this->mpdf_lib->downloadPDF($html,$name,0,'footer','header',$this->urlLogo,'');
    }  

    public function reciboPagoComision2($id = null){
        $this->load->library("mpdf_lib");
        $data = array();
        $info = $this->maltaventa->getByIdAll($id);
        $comision = $this->mcomisiones->getByIdAV($info['id']);
        $idComision = (!is_numeric($comision)) ? $comision['id'] : 0;
        $fechaDetonacion = (!is_numeric($comision)) ? $comision['fechaDetonacion'] : '0000-00-00';
        $data['nomCliente'] = $this->mprospecto->getCampo('nombre',$info['idProspecto']);
        $tipoPromotor = $this->musuario->getCampo('tipoPromotor',$info['idPromotor']);
        $data['apellidoPCliente'] = $this->mprospecto->getCampo('apellidoP',$info['idProspecto']);
        $data['apellidoMCliente'] = $this->mprospecto->getCampo('apellidoM',$info['idProspecto']);

        $data['fraccionamiento'] = $this->mfraccionamiento->getCampo('titulo',$info['idFraccionamiento']);
        $data['manzana'] = $info['manzana'];
        $data['lote'] = $info['lote'];
        //impuestos al 99
        $data['fraccionamiento'] = $this->mfraccionamiento->getCampo('titulo',$info['idFraccionamiento']);
        /*$data['porcentajeImptoPago1'] = $this->mcomisiones->getCampo('porcentajeImptoPago1',$info['id']);*/
        /*$data['porcentajePago1'] = $this->mcomisiones->getCampo('porcentajePago1',$info['id']);*/
        $data['comisionTotal'] = $this->mcomisiones->getCampo('comision',$idComision);
        $ventasMes = $this->mcomisiones->getVentasMes($info['idPromotor'], $fechaDetonacion);
        $matrizComisiones = $this->mmatrizcomisiones->getByVentasTipoPromotor($ventasMes, $tipoPromotor);
        $porcentajeComision = $matrizComisiones['porcentajeVentas'];
        $data['porcentajeComisionPago2'] = $porcentajeComision;
        $data['fechaPago2'] = $this->mcomisiones->getCampo('fechaPago2',$idComision);

        $data['totalPago2'] = $this->mcomisiones->getCampo('totalPago2',$idComision);
        $data['precioVenta'] = $this->mproyecto->getCampo('precioVenta',$info['idProyecto']);
        $data['ronda'] = $this->mgestoria->getRondaByIdAv($id);

        $data['nomPromotor'] = $this->musuario->getCampo("nombre",$info['idPromotor']);
        $data['aPaternoPromotor'] = $this->musuario->getCampo("apellidoP",$info['idPromotor']);
        $data['aMaternoPromotor'] = $this->musuario->getCampo("apellidoM",$info['idPromotor']);

        
        //Al 90%
        $data['pago2'] = $this->mcomisiones->getCampo('pago2',$idComision);
        //Al 9%
        $data['imptoPago2'] = $this->mcomisiones->getCampo('imptoPago2',$idComision);
    
        $name = 'Recibo Pago 2_'.date('dmYhHi');
        $html = $this->load->view('formatospdf/recibo_pago_comision_2_view.php',$data,true);
        $this->mpdf_lib->downloadPDF($html,$name,0,'footer','header',$this->urlLogo,'');
    }
    
    public function reciboPagoComision3($id = null){
        $this->load->library("mpdf_lib");
        $data = array();
        $info = $this->maltaventa->getByIdAll($id);
        $comision = $this->mcomisiones->getByIdAV($info['id']);
        $idComision = (!is_numeric($comision)) ? $comision['id'] : 0;
        $data['nomCliente'] = $this->mprospecto->getCampo('nombre',$info['idProspecto']);
        $data['apellidoPCliente'] = $this->mprospecto->getCampo('apellidoP',$info['idProspecto']);
        $data['apellidoMCliente'] = $this->mprospecto->getCampo('apellidoM',$info['idProspecto']);

        $data['fraccionamiento'] = $this->mfraccionamiento->getCampo('titulo',$info['idFraccionamiento']);
        $data['manzana'] = $info['manzana'];
        $data['lote'] = $info['lote'];
        //impuestos al 99
        $data['fraccionamiento'] = $this->mfraccionamiento->getCampo('titulo',$info['idFraccionamiento']);

        $data['porcentajeImptoPago1'] = $this->mcomisiones->getCampo('porcentajeImptoAjuste',$idComision);
        $data['comisionTotal'] = $this->mcomisiones->getCampo('comisionAjuste',$idComision);
        $data['porcentajePago1'] = $this->mcomisiones->getCampo('porcentajeAjuste',$idComision);
        $data['porcentajeComisionPago1'] = $this->mcomisiones->getCampo('porcentajeComisionAjuste',$idComision);
        $data['fechaPago1'] = $this->mcomisiones->getCampo('fechaAjuste',$idComision);

        $data['total'] = $this->mcomisiones->getCampo('totalAjuste',$idComision);
        $data['precioVenta'] = $this->mproyecto->getCampo('precioVenta',$info['idProyecto']);
        $data['ronda'] = $this->mgestoria->getRondaByIdAv($id);

        $data['nomPromotor'] = $this->musuario->getCampo("nombre",$info['idPromotor']);
        $data['aPaternoPromotor'] = $this->musuario->getCampo("apellidoP",$info['idPromotor']);
        $data['aMaternoPromotor'] = $this->musuario->getCampo("apellidoM",$info['idPromotor']);

        //Al 90%
        $data['pago1'] = $this->mcomisiones->getCampo('ajuste',$idComision);
        //Al 9%
        $data['imptoPago1'] = $this->mcomisiones->getCampo('imptoAjuste',$idComision);

    
        $name = 'Recibo Pago Ajuste_'.date('dmYhHi');
        $html = $this->load->view('formatospdf/recibo_pago_comision_3_view.php',$data,true);
        $this->mpdf_lib->downloadPDF($html,$name,0,'footer','header',$this->urlLogo,'');
    }

     public function responsiva ($id = null){ // recibe el id que viene de la tabla carta responsiva
        $this->load->library("mpdf_lib");
        $data = array();

        //$info = $this->maltaventa->getByIdAll($id);
        //$data = $info;  
        $data['mfraccionamiento'] = $this->mfraccionamiento;  

        $cartaAsignacion = $this->mcartaasignacion->getById($id);
        //print_r($cartaAsignacion);exit();
        if (!is_numeric($cartaAsignacion)){
            $idActivo = $cartaAsignacion['idActivo']; // id de la tabla activos
            $descripcion = $this->mactivos->getCampo('descripcion',$idActivo);
            $serie = $this->mactivos->getCampo('serie',$idActivo);
            $serie = ($serie == '')?$this->mactivos->getCampo('inventarioInterno',$idActivo):$serie;
            $marca = $this->mactivos->getCampo('marca',$idActivo);
            $modelo = $this->mactivos->getCampo('modelo',$idActivo);
            $anio = $this->mactivos->getCampo('anio',$idActivo);
            $placas = $this->mactivos->getCampo('placas',$idActivo);
            $notas = $cartaAsignacion['notas'];
            $notas = ($notas!='')?'<p style="margin-left: 0.05in; margin-bottom: 0in;margin-top:0.3in; line-height: 150%; font-family:Arial, serif;text-transform: uppercase;font-size:11px;">Notas: '.$notas.'</p>':'';
            $idUsuario = $cartaAsignacion['idUsuario'];
            $fechaAsignacion = $cartaAsignacion['fechaAsignacion'];
            $fechaAsignacion = date("d-M-Y", strtotime($fechaAsignacion));
            $responsable =  $this->musuario->getCampo('nombre',$idUsuario)." ".$this->musuario->getCampo('apellidoP',$idUsuario);
            $data['responsable'] = $responsable;
            $data['celResponsable'] = $this->musuario->getCampo('celular',$idUsuario);
            $idRol = $this->musuario->getCampo('rol',$idUsuario);
            $nombreRol = $this->mroles->getCampo('nombre',$idRol);

            $tipoActivo = $this->mactivos->getCampo('idActivo',$idActivo); // obtenemos el tipo activo (vehiculo, electronica, etc) de la tabla activos
            //echo $tipoActivo."<br>";
            if ($tipoActivo == 3){
                $categoriaElectronica = $this->mactivos->getCampo('idCategoria',$idActivo); //id de la categoria
                $nombreCategoria = $this->mcategoria->getCampo('titulo',$categoriaElectronica);
            }else{
                $categoriaElectronica = 0;
                $nombreCategoria = '';
            }
            switch ($tipoActivo) {
                case '1':
                    $data['asunto'] = 'Mobiliario';
                    $data['contenido'] = '
                        <p style="margin-left: 0.05in; margin-bottom: 0in; line-height: 150%; font-family:Arial, serif;text-transform: uppercase;font-size:14px;">
                            Sirva éste como comprobante de entrega del equipo <strong>'.$descripcion.',</strong> con número de serie <strong>'.$serie.',</strong> el cual pertenece a la empresa Viviend Inmobiliaria S.A. de C.V. y se entrega a <strong>'.$responsable.',</strong> quien se desempeña como <strong>'.$nombreRol.'</strong> en esta empresa y a partir del día <strong>'.get_fecha($fechaAsignacion).'</strong> del presente se compromete a resguardarlo y darle un uso estrictamente laboral, para el mejor desarrollo de sus funciones.
                        </p>
                        <p style="margin-left: 0.05in; margin-bottom: 0in; line-height: 150%; font-family:Arial, serif;text-transform: uppercase;font-size:14px;">
                            Sin más por el momento, quedo a sus órdenes.
                        </p>
                    ';
                    break;
                case '2':
                    $data['asunto'] = 'Otros';
                    $data['contenido'] = '
                        <p style="margin-left: 0.05in; margin-bottom: 0in; line-height: 150%; font-family:Arial, serif;text-transform: uppercase;font-size:14px;">
                            Sirva éste como comprobante de entrega del equipo <strong>'.$descripcion.',</strong> con número de serie <strong>'.$serie.',</strong> el cual pertenece a la empresa Viviend Inmobiliaria S.A. de C.V. y se entrega a <strong>'.$responsable.',</strong> quien se desempeña como <strong>'.$nombreRol.'</strong> en esta empresa y a partir del día <strong>'.get_fecha($fechaAsignacion).'</strong> del presente se compromete a resguardarlo y darle un uso estrictamente laboral, para el mejor desarrollo de sus funciones.
                        </p>
                        <p style="margin-left: 0.05in; margin-bottom: 0in; line-height: 150%; font-family:Arial, serif;text-transform: uppercase;font-size:14px;">
                            Sin más por el momento, quedo a sus órdenes.
                        </p>
                    ';
                    break;
                case '3':
                    $data['asunto'] = 'Electrónica';
                    $data['contenido'] = '
                        <p style="margin-left: 0.05in; margin-bottom: 0in; line-height: 150%; font-family:Arial, serif;text-transform: uppercase;font-size:14px;">
                            Sirva éste como comprobante de entrega del equipo <strong>'.$marca." ".$modelo.',</strong> con número de serie <strong>'.$serie.',</strong> el cual pertenece a la empresa Viviend Inmobiliaria S.A. de C.V. y se entrega a <strong>'.$responsable.',</strong> quien se desempeña como <strong>'.$nombreRol.'</strong> en esta empresa y a partir del día <strong>'.get_fecha($fechaAsignacion).'</strong> del presente se compromete a resguardarlo y darle un uso estrictamente laboral, para el mejor desarrollo de sus funciones.
                        </p>
                        <p style="margin-left: 0.05in; margin-bottom: 0in; line-height: 150%; font-family:Arial, serif;text-transform: uppercase;font-size:14px;">
                            Asimismo, hacemos de su conocimiento que no podrá modificar la configuración del equipo sin ser previamente autorizado.
                        </p>
                        <p style="margin-left: 0.05in; margin-bottom: 0in; line-height: 150%; font-family:Arial, serif;text-transform: uppercase;font-size:14px;">
                            Sin más por el momento, quedo a sus órdenes.
                        </p>
                    ';
                    break;
                case '4':
                    $data['asunto'] = 'Vehículos';

                    $data['contenido'] = '
                    <p style="margin-left: 0.05in; margin-bottom: 0in; line-height: 150%; font-family:Arial, serif;text-transform: uppercase;font-size:14px;">
                        Por medio de la presente, le informo que se hace entrega del vehículo <strong>'.$marca." ".$modelo.'</strong> del año <strong>'.$anio.',</strong> placas <strong>'.$placas.'</strong> a <strong>'.$responsable.',</strong> quien se desempeña como <strong>'.$nombreRol.'</strong> en esta empresa, quien a partir del día <strong>'.get_fecha($fechaAsignacion).'</strong> del presente se compromete a resguardarlo y darle un uso estrictamente laboral, para el mejor desarrollo de sus funciones.
                    </p>
                    <p style="margin-left: 0.05in; margin-bottom: 0in; line-height: 150%; font-family:Arial, serif;text-transform: uppercase;font-size:14px;">
                        Lo anterior deriva de la necesidad de movilidad del empleado para el desarrollo de sus funciones. Asimismo, sirva la presente para informarle que puede utilizar el automóvil a conveniencia, siempre y cuando éste sea cuidado y usado con responsabilidad, sin negligencia.
                    </p>
                    <p style="margin-left: 0.05in; margin-bottom: 0in; line-height: 150%; font-family:Arial, serif;text-transform: uppercase;font-size:14px;">
                        Por otro lado, en caso de robo, tendrá que informarse a la dirección de recursos humanos de esta entidad en un periodo no mayor a las 24 horas, y seguir el proceso de denuncia ante el Ministerio Público.
                    </p>
                    <p style="margin-left: 0.05in; margin-bottom: 0in; line-height: 150%; font-family:Arial, serif;text-transform: uppercase;font-size:14px;">
                        Sin más por el momento, le informo que se realizará la contraentrega de las llaves con este documento.
                    </p>
                    ';
                    break;
                
                default:
                    $data['asunto'] = '';
                    $data['contenido'] = '';
                    # code...
                    break;
            }          

            //echo $categoriaElectronica;
            //print_r($data['contenido']);
        }
        //exit();
        $data['contenido'] .= $notas;
        $html = $this->load->view('formatospdf/responsiva_view.php',$data,true);
        //echo $html;exit();
         $this->mpdf_lib->downloadPDF($html,"responsiva",0,'footer','header',$this->urlLogo,'','');//$fechaAsignacion
    }   
    
    
    public function acta($id = null){
        $this->load->library("mpdf_lib");
        $data = array();
        /*
        $info = $this->maltaventa->getByIdAll($id);
        $data = $info;  
        $data['mfraccionamiento'] = $this->mfraccionamiento;        
        */
        $html = $this->load->view('formatospdf/acta_view.php',$data,true);
        $this->mpdf_lib->downloadPDF($html,"acta",0);     

        // $this->load->library("mpdf_lib");
        // $data = array();
        // $html = $this->load->view('formatospdf/acta_view.php',$data,true);
        //     // echo $html;
        //     // exit();
        // $this->mpdf_lib->downloadPDF($html,"acta",0);
    } 
    
    
    
    public function recepcion($id = null){
        $this->load->library("mpdf_lib");
        $data = array();


        $info = $this->maltaventa->getByIdAll($id);
        $data = $info;  
        $data['mfraccionamiento'] = $this->mfraccionamiento;

        $html = $this->load->view('formatospdf/recepcion_view.php',$data,true);
      /*  echo $html; exit();*/
        $this->mpdf_lib->downloadPDF($html,"recepcion",0);

    }
    
    
    
    public function generales($id = null){
        $this->load->library("mpdf_lib");
        $data = array();
        /*$info = $this->maltaventa->getByIdAll($id);*/
        // $info = $this->maltaventa->getByIdForGestoria($id);
      /*  $data = $info;  
        $data['mfraccionamiento'] = $this->mfraccionamiento;
        $data['mprototipos'] = $this->mprototipos;
        $data['musuario'] = $this->musuario;*/
        
      /*  $this->idFraccionamiento = $info['idFraccionamiento'];*/
        $this->setLogo();
        
        /*echo "<pre>"; print_r($data); echo "</pre>"; exit();*/
        
        $html = $this->load->view('formatospdf/generales_view.php',$data,true);
        
        echo $html; exit();
        
        $this->mpdf_lib->downloadPDF($html,"generales",0,'footer','header',$this->urlLogo,'titHeader');
    }

    public function cufrisa($id = null){
        $this->load->library("mpdf_lib");
        $data = array();
        $info = $this->maltaventa->getByIdAll($id);
        $data = $info; 
        $data['mfraccionamiento'] = $this->mfraccionamiento;
        $this->idFraccionamiento = $info['idFraccionamiento'];
        $this->setLogo();

        $html = $this->load->view('formatospdf/cufrisa_view.php',$data,true);
         // echo $html;
         //    exit();
        // print_r($data); exit();
        $this->mpdf_lib->downloadPDF($html,"cufrisa",0,'footer','header',$this->urlLogo,'titHeader');
        
             // $this->load->library("mpdf_lib");
        // $data = array();
        // $html = $this->load->view('formatospdf/recepcion_view.php',$data,true);
        //     // echo $html;
        //     // exit();
        // $this->mpdf_lib->downloadPDF($html,"recepcion",0);
    } 
    public function actapoliza($id = null){
        $this->load->library("mpdf_lib");
        $data = array();
        $info = $this->maltaventa->getByIdAll($id);
        $data = $info; 
        $data['mfraccionamiento'] = $this->mfraccionamiento;
        $this->idFraccionamiento = $info['idFraccionamiento'];
        $this->setLogo();

        $html = $this->load->view('formatospdf/actapoliza_view.php',$data,true);
         // echo $html;
         //    exit();
        // print_r($data); exit();
        $this->mpdf_lib->downloadPDF($html,"actapoliza",0,'footer','header',$this->urlLogo,'titHeader');
        
             // $this->load->library("mpdf_lib");
        // $data = array();
        // $html = $this->load->view('formatospdf/recepcion_view.php',$data,true);
        //     // echo $html;
        //     // exit();
        // $this->mpdf_lib->downloadPDF($html,"recepcion",0);
    }    
    

    public function reciboPago($id = null){
        $this->load->library("mpdf_lib");
        $data = array();
        $infoDetalle = $this->mcontadodetalle->getById($id);
        $info = $this->mcontadocuentas->getById($infoDetalle['idCuenta']);
        $infoAltaVenta = $this->maltaventa->getByIdAll($info['idAltaVenta']);
        $data['detalle'] = $infoDetalle;
        $data['cuenta'] = $info;
        $data['altaVenta'] = $infoAltaVenta;
        $data['mfraccionamiento'] = $this->mfraccionamiento;
        $this->idFraccionamiento = $infoAltaVenta['idFraccionamiento'];
        $this->setLogo();

        $html = $this->load->view('formatospdf/recibopago_view.php',$data,true);

        $this->mpdf_lib->downloadPDF2($html,"reciboPago",0,'footer','header',$this->urlLogo,'');
    }  

    public function contratoCompraVenta($id = null, $idProyecto=null){
        $this->load->library("mpdf_lib");
        $data = array();

        $info = ($idProyecto == null) ? $this->maltaventa->getByIdAll($id) : $this->maltaventa->getByIdAll2($id);
        if($idProyecto != null){
            $proyecto = $this->mproyecto->getById($idProyecto);
            if(!is_numeric($proyecto)){
                $info = $info + $proyecto;
            }
            /*$idPrototipo = $this->mproyecto->getCampo('idPrototipo', $idProyecto);
            $idFraccionamiento = $this->mproyecto->getCampo('idFraccionamiento', $idProyecto);
            $info['idFraccionamiento'] = $idFraccionamiento;
            $info['idPrototipo'] = $idPrototipo;*/
            $info['idProyecto'] = $idProyecto;
        }
        
        $data = $info;
        $data['fraccionamiento'] = $this->mfraccionamiento->getCampo('titulo', $info['idFraccionamiento']);
        $data['cpFracc'] = $this->mfraccionamiento->getCampo('cp', $info['idFraccionamiento']);
        $data['fechaNac'] = strtotime($info['fechaNac']);
        $data['mpromotor'] = $this->musuario;
        $data['mprototipo'] = $this->mprototipos;
        $data['mproyecto'] = $this->mproyecto;
        $data['days'] = date('d');
        $month = date('m');
        $data['year'] = date('Y');
        $data['monthLetter'] = convertirMes((int)$month);

        $html = $this->load->view('formatospdf/contratoCompraVenta_view.php',$data,true);

        $this->mpdf_lib->downloadPDF2($html,"contratoCompraVenta",0,'footer','header',$this->urlLogo,'titHeader');
    }      

    public function incidencias($id = null){
        $this->load->library("mpdf_lib");
        $data = array();
        $info = $this->maltaventa->getByIdAll($id);
        $data = $info; 
        $data['mfraccionamiento'] = $this->mfraccionamiento;
        $this->idFraccionamiento = $info['idFraccionamiento'];
        $this->setLogo();

        $html = $this->load->view('formatospdf/incidencias_view.php',$data,true);

         print_r($data); exit();
        $this->mpdf_lib->downloadPDF($html,"incidencias",0,'footer','header',$this->urlLogo,'titHeader');
        
    }

}
