<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Firma extends MX_Controller {
	public $data,$vParameters,$mainView,$fv;
	public function __construct(){
	$this->nsession = $this->config->item('nsession');
    if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'firma'; // form validation variable
            $this->mainView = 'firma';
            $this->data['fjs'] = '';
            $this->data['js'] = '';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('musuario'));
            $this->config->set_item('rol', $_SESSION[$this->nsession]['rol']);

            //Validación de usuarios
            $this->config->set_item('rol',$_SESSION[$this->nsession]['rol']);

            $this->data['fotos_www'] = $this->config->item('base_www')."firmas/";
    }

	public function index($idUsuario=0){
		$data['idUsuario'] = $idUsuario;
        $this->load->view($this->mainView.'/index_view',$data);
    }

    public function validarFirma($idUsuario=0){
        if(!file_exists($this->data['fotos_www']."/sign_".$idUsuario.".png")){
            redirect("firma/firmar/".$idUsuario);
        }else{
            redirect("firma/getFirma/".$idUsuario);
        }
    }

    public function getFirma($idUsuario=0){
        $data["imagen"]="uploads/firmas/sign_".$idUsuario.".png";
        $data["idUsuario"]=$idUsuario;
        $this->load->view($this->mainView.'/firma_view.php',$data);
    }

    public function firmar($idUsuario=0){
        $data['js'] = '<script type="text/javascript" src="assets/js/firma/listado.js"></script>
                        <script type="text/javascript" src="assets/js/modernizr-1.6.min.js"></script>';
        $data['idUsuario'] = $idUsuario;
        $this->load->view($this->mainView.'/index_view',$data);
    }

    public function guardarFirma(){
        $idUsuario=$this->input->post("idUsuario");
        // comprobamos si se envió la imagen
        if (isset($_POST['imagen'])) { 
            // llamamos a la funcion uploadImgBase64( img_base64, nombre_fina.png) 
            $subir=$this->uploadImgBase64($_POST['imagen'], 'sign_'.$idUsuario.'.png' );
            if($subir){
                // mostrar la imagen
                redirect("firma/getFirma/".$idUsuario);
            }else{
                echo 'Error al subir imagen';
            }
        }
    }

    // funcion para gusrfdar la imagen base64 en el servidor
    public function uploadImgBase64 ($base64, $name){
        // decodificamos el base64
        $datosBase64 = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $base64));
        // definimos la ruta donde se guardara en el server
        $path= $this->data['fotos_www'].$name;
        // guardamos la imagen en el server
        if(!file_put_contents($path, $datosBase64)){
            // retorno si falla
            return false;
        }else{
            // retorno si todo fue bien
            return true;
        }
    }

}


