<?php 
	defined('BASEPATH') OR exit('No direct script access allowed');
	date_default_timezone_set('America/Mexico_City');

	/**
	 * @todo	Controller for estimations de times
	 * @since	2024-11-07
	 */
	class Estimacion extends MX_Controller {
		public $data,$vParameters,$mainView,$fv;

		public function __construct() {
			$this->nsession = $this->config->item('nsession');
			if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');

			$this->fv = 'estimacion'; // form validation variable
			$this->mainView = 'estimacion';
			$this->data['fjs'] = '';
			$this->data['js'] = ' <script src="assets/js/estimacion/index.js?v=0.6" type="text/javascript"></script>';
			$this->data['css'] = '';
			// Tools
			$this->load->helper(array('tools','url','form','date','text','security'));
			// Models
			$this->load->model(array('musuario','mcortes','mpaquete','mactividadesprototipo','mpresupuestomo'));
			// Libraries
			$this->data['fotos_www'] = $this->config->item('base_www').'/asignacion/';
			$this->load->library('csvimport');
			ini_set('max_execution_time', 0);
		}

		public function importar($idCorte){
			$valCorte=$this->mcortes->valCorteActual($idCorte);
            if(!is_numeric(($valCorte))){
				$i=1;
				$corte=$valCorte->row();
				$file_path = $this->config->item('base_www')."/csv/estimacion.csv";
				if ($this->csvimport->get_array($file_path,'',TRUE)) {
					$csv_array = $this->csvimport->get_array($file_path);
					if (isset($csv_array[0])) {
						foreach ($csv_array as $value) { //recorremos el csv
							$i++;
							if (isset($value['FRACCIONAMIENTO']) && isset($value['LOTE']) && isset($value['MANZANA'])) {
								if (isset($value['PRECIO UNITARIO']) && isset($value['CANTIDAD']) && isset($value['IMPORTE'])) {
									if(isset($value["CLAVE"])){
										if(isset($value["CONTRATISTA"])){
											$contratista=$this->db->query("SELECT id FROM constructores WHERE CONVERT(CONCAT_WS(' ',nombre,apellidoP,apellidoM) USING utf8)=CONVERT('".$value["CONTRATISTA"]."' USING utf8)");
											if($contratista->num_rows() > 0){
												$fraccionamiento=$this->db->query("SELECT id FROM fraccionamientos WHERE titulo='".$value["FRACCIONAMIENTO"]."'");
												if($fraccionamiento->num_rows()>0){
													$actividad=$this->getActByIdClave($fraccionamiento->row()->id,$value["MANZANA"],$value["LOTE"],$value["CLAVE"],$corte);
													if(!is_numeric($actividad)){
														if(intval($actividad->cantidad * $actividad->precioUnitario)==intval($value["IMPORTE"])){
															if(isset($actividad->idAvance) && isset($actividad->idAvance)){
																$this->checkLote([
																	"estado"=>true,
																	"lote"=>$value["LOTE"],
																	"manzana"=>$value["MANZANA"],
																	"lotes"=>$actividad->lotes,
																	"tabla"=>"avanceobra",
																	"column"=>"lotes",
																	"id"=>$actividad->idAvance,
																],false);
																$this->checkLote([
																	"estado"=>true,
																	"lote"=>$value["LOTE"],
																	"manzana"=>$value["MANZANA"],
																	"lotes"=>$actividad->lotesP,
																	"tabla"=>"paquete_presupuesto",
																	"column"=>"lotes",
																	"id"=>$actividad->idPaqP,
																],false);
																$this->setContratista([
																	"lote"=>[
																		"lote"=>$value["LOTE"],
																	],
																	"manzana"=>$value["MANZANA"],
																	"idavance"=>$actividad->idAvance,
																	"idcontratista"=>$contratista->row()->id,
																],false);
															}else{
																echo "No existe la relación, fila $i |".$value["FRACCIONAMIENTO"]." | ".$value["CLAVE"]." | ".$value["LOTE"]." | ".$value["MANZANA"]." | 0 | ".$value["CONTRATISTA"]
																." | ".$value["PRECIO UNITARIO"]." | ".$value["CANTIDAD"]." | ".$value["IMPORTE"]."<br>";
															}
														}else{
															echo "Diferencia de precios, fila $i |".$value["FRACCIONAMIENTO"]." | ".$value["CLAVE"]." | ".$value["LOTE"]." | ".$value["MANZANA"]." | 0 | ".$value["CONTRATISTA"]
															." | ".$value["PRECIO UNITARIO"]." | ".$value["CANTIDAD"]." | ".$value["IMPORTE"]." | ".($actividad->cantidad * $actividad->precioUnitario)."<br>";
															//actualizacion de precios
															/*$this->mactividadesprototipo->actualizar(
																[
																	""=>0
																],$actividad->idActividadPrototipo
															);
															$this->presupuestomo->actualizar(
																[
																	
																],$actividad->idPresupuesto
															);*/
															
														}
													}else{
														echo "No existe la actividad, fila $i |".$value["FRACCIONAMIENTO"]." | ".$value["CLAVE"]." | ".$value["LOTE"]." | ".$value["MANZANA"]." | 0 | ".$value["CONTRATISTA"]
														." | ".$value["PRECIO UNITARIO"]." | ".$value["CANTIDAD"]." | ".$value["IMPORTE"]."<br>";
													}
												}else{
													echo "No existe el fraccionamiento, fila $i<br>";
												}
											}else{
												echo "No existe el contratista ".$value["CONTRATISTA"].",  fila $i<br>";
											}
										}else{
											echo "Debe existir un contratista, fila $i<br>";
										}
									}else{
										echo "Debe existir una clave, fila $i<br>";
									}
								}else{
									echo "Debe existir un precio, cantidad y importe, fila $i <br>";
								}
							}else{
								echo "Debe existir un fraccionamiento, lote y manzana, fila $i <br>";
							}
						}
					}
				}
			}else{
				echo "El corte no existe";
			}
		}

		public function getActByIdClave($idFraccionamiento,$mza,$lote,$clave,$corte){
			$query=$this->db->query("SELECT act.id idActividadPrototipo, pmo.id idPresupuesto,dp.idPaquete,paqp.id idPaqP,paqp.lotes lotesP, act.cantidad, pmo.precioUnitario, pmo.importe, ao.id idAvance, ao.lotes FROM proyectos pro
			LEFT JOIN detalle_paquete dp ON dp.idProyecto=pro.id
			LEFT JOIN paquetes paq ON paq.id=dp.idPaquete
			LEFT JOIN mano_obra mo ON mo.id=paq.idManoObra
			LEFT JOIN presupuesto_mo pmo ON pmo.idManoObra=mo.id
			LEFT JOIN actividadesprototipo act ON act.id=pmo.idActividadPrototipo
			LEFT JOIN actividades_mo actmo ON actmo.id=act.idActividad
			LEFT JOIN paquete_presupuesto paqp ON paqp.idPaquete=paq.id AND paqp.idPresupuestoMO=pmo.id
		
			LEFT JOIN estimacion_programa ion ON ion.idPaquete=paq.id
			LEFT JOIN estimaciones_programa iones ON iones.idEstimacion=ion.id
			LEFT JOIN estimados_programa ados ON ados.idEstimaciones=iones.id AND ados.idPresupuesto=paqp.idPresupuestoMO
			LEFT JOIN avanceobra ao ON ao.idEstimado=ados.id			
			WHERE WEEK(iones.fecha,7)=$corte->semana AND YEAR(iones.fecha)=YEAR('$corte->fechaCorte') AND pro.manzana='$mza' AND
			pro.lote='$lote' AND pro.idFraccionamiento='$idFraccionamiento' AND actmo.clave='$clave' LIMIT 1");

			if($query->num_rows()>0){
				return $query->row();
			}else{
				return 0;
			}
			//segunda version -----------------------------------
			/*$proyecto=$this->db->query("SELECT id FROM proyectos pro WHERE pro.idFraccionamiento='$idFraccionamiento' AND pro.manzana='$mza' AND pro.lote='$lote' ");
			if($proyecto->num_rows()>0){
				$detalle=$this->db->query("SELECT id,idPaquete FROM detalle_paquete WHERE idProyecto=".$proyecto->row()->id);
				if($detalle->num_rows()>0){
					$idPaquete=$detalle->row()->idPaquete;
					$idManoObra=$this->mpaquete->getCampo("idManoObra",$idPaquete);
					if($idManoObra>0){
						$actividad=$this->db->query("SELECT id FROM actividades_mo WHERE clave='".$clave."'");
						if($actividad->num_rows()>0){
							$idActividad=$actividad->row()->id;
							$pmo=$this->db->query("
								SELECT pmo.id, pmo.precioUnitario, pmo.importe, act.cantidad FROM presupuesto_mo pmo
								LEFT JOIN actividadesprototipo act ON act.id=pmo.idActividadPrototipo
								WHERE pmo.idManoObra=$idManoObra AND act.idActividad=$idActividad
							");
							if($pmo->num_rows()>0){
								$paqp=$this->db->query("SELECT id,lotes FROM paquete_presupuesto WHERE idPaquete=$idPaquete AND idPresupuestoMO=".$pmo->row()->id);
								if($paqp->num_rows()>0){
									$estimados=$this->db->query("SELECT ao.id,ao.lotes FROM estimacion_programa ion
													LEFT JOIN estimaciones_programa iones ON iones.idEstimacion=ion.id
													LEFT JOIN estimados_programa ados ON ados.idEstimaciones=iones.id
													LEFT JOIN avanceobra ao ON ao.idEstimado=ados.id
													WHERE WEEK(iones.fecha,7)=$corte->semana AND YEAR(iones.fecha)=YEAR('$corte->fechaCorte') AND 
													ion.idPaquete=$idPaquete AND ados.idPresupuesto=".$pmo->row()->id);
													print_r($estimados->result());
								}
							}
						}
					}
				}
			}*/
		}

		public function index($id=0) {
			$valCorte=$this->mcortes->valCorteActual($id);
            if(!is_numeric(($valCorte))){
				$data["corte"]=$valCorte->row();
				$data['q'] = '';
				$data['fracc'] = $this->db->query(
					"SELECT fr.id,fr.titulo FROM detalle_paquete dp
					LEFT JOIN paquetes paq ON paq.id=dp.idPaquete 
					LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes)
					LEFT JOIN proyectos pro ON pro.id=dp.idProyecto 
					LEFT JOIN fraccionamientos fr ON fr.id=pro.idFraccionamiento
					WHERE arr.estatus_arranque = 2
					GROUP BY fr.id 
					ORDER BY fr.titulo"
				);
				$this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
				$this->load->view('templates/main_template',$this->data);
			}else{
				$this->data['contenido'] = "<h2><strong>Aún no existe un corte para esta semana</strong></h2>";
				$this->load->view('templates/main_template',$this->data);
			}
		}

		public function listado() {
			try {
				$params = $_POST;
				switch ($params['action']) {
					case 'manzana':
						$idFracc = $params['id_fracc'];
						$tipoLote = $params['tipo_lote'];
						$and_where = ($tipoLote>0?' AND paq.tipoLote = '.$tipoLote:'');
						$l_query = $this->db->query(
							"SELECT pro.manzana FROM detalle_paquete dp 
							LEFT JOIN paquetes paq ON paq.id=dp.idPaquete 
							LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes)
							LEFT JOIN proyectos pro ON pro.id=dp.idProyecto 
							WHERE arr.estatus_arranque=2 AND pro.idFraccionamiento=$idFracc $and_where
							GROUP BY pro.manzana 
							ORDER BY pro.manzana ASC"
						);
						$array = $l_query->result();
						( $l_query->num_rows() > 0 ? http_response_code(200): http_response_code(404) );
						break;
					case 'lote':
						$idFracc = $params['id_fracc'];
						$manzana = $params['manzana'];
						$tipoLote = $params['tipo_lote'];
						$idCorte = $params['idCorte'];

						$corte=$this->mcortes->valCorteActual($idCorte);
						if(!is_numeric(($corte))){
							$corte=$corte->row();
							$and_where = ($tipoLote>0?' AND paq.tipoLote = '.$tipoLote:'');
							$l_query = $this->db->query(
								"SELECT 
									dp.idProyecto,paq.id idPaquete,ones.id idEstimaciones,pro.lote, paq.tipoEstimacion, paq.tipoLote,
									CONCAT_WS(' ',const.nombre,const.apellidoP,const.apellidoM) nom_constructor,
									prot.nombre prototipo,
									CONCAT_WS(' ',usu.nombre,usu.apellidoP,usu.apellidoM) nom_supervisor,
									ones.nEstimacion semActual,$corte->semana semAnual,
									ones.fecha fechaInicio,
									date_add(ones.fecha, INTERVAL 6 day) fechaFin
								FROM detalle_paquete dp 
								LEFT JOIN paquetes paq ON paq.id=dp.idPaquete
								LEFT JOIN constructores const ON const.id=paq.idConstructor
								LEFT JOIN proyectos pro ON pro.id=dp.idProyecto
								LEFT JOIN estimacion_programa ion ON ion.idPaquete=dp.idPaquete
								LEFT JOIN estimaciones_programa ones ON ones.idEstimacion=ion.id AND ones.fecha 
								LEFT JOIN arranque arr ON FIND_IN_SET(dp.idPaquete,arr.idPaquetes)
								LEFT JOIN prototipos prot ON prot.id=pro.idPrototipo
								LEFT JOIN usuarios usu ON usu.id=dp.idResidente
								WHERE $corte->semana = WEEK(ones.fecha,7) AND $corte->ano=YEAR(ones.fecha)
									AND arr.estatus_arranque=2
									AND pro.idFraccionamiento=$idFracc
									AND pro.manzana = '$manzana' $and_where
								GROUP BY pro.id
								ORDER BY pro.lote+1 ASC"
							);
							$array = $l_query->result();
							( $l_query->num_rows() > 0 ? http_response_code(200): http_response_code(404) );
						}
						break;
					case 'actividades':
						$idProyecto = $params['idProyecto'];
						$idEstimacion = $params['idEstimacion'];
						$tipo_estimacion = intval($params['tipo_estimacion']);	
						$manzana = $params['manzana'];
						$lote = $params['lote'];
						$aQuery="SELECT 
						ao.id idAvance, ao.lotes, ao.idConstructor idConstructorAo, actmo.clave,actmo.descripcion, ados.idPresupuesto idPresupuesto,
						paqp.id idPptoPaq, paqp.lotes lotesP, prog.semana,paqp.acumulado,ao.avanceC,CAST(actp.cantidad AS real) cantidad,
						ao.iniciado,paqp.lotesI, uni.abreviatura, ones.nEstimacion semActual, paq.idConstructor, pmo.precioUnitario, catmo.categoria
						FROM avanceobra ao
						LEFT JOIN estimados_programa ados ON ados.id=ao.idEstimado
						LEFT JOIN estimaciones_programa ones ON ones.id=ados.idEstimaciones
						LEFT JOIN estimacion_programa ion ON ion.id=ones.idEstimacion
						LEFT JOIN presupuesto_mo pmo ON pmo.id=ados.idPresupuesto
						LEFT JOIN actividadesprototipo actp ON actp.id=pmo.idActividadPrototipo
						LEFT JOIN actividades_mo actmo ON actmo.id=actp.idActividad
						LEFT JOIN unidades uni ON uni.id=actmo.idUnidad
						LEFT JOIN paquete_presupuesto paqp ON paqp.idPaquete=ion.idPaquete AND paqp.idPresupuestoMO=ados.idPresupuesto
						LEFT JOIN paquetes paq ON paq.id=paqp.idPaquete
						LEFT JOIN categorias_mo catmo ON catmo.id=actmo.idCategoria
						LEFT OUTER JOIN programa_obra prog ON prog.idPresupuesto=ados.idPresupuesto 
						AND prog.idPaquete=ion.idPaquete AND prog.idProyecto=$idProyecto
						WHERE ones.id=$idEstimacion
						AND
						(( NOT(paqp.lotes LIKE '$lote/$manzana,%' OR paqp.lotes LIKE '%,$lote/$manzana' 
						OR paqp.lotes LIKE '%,$lote/$manzana,%' OR paqp.lotes = '$lote/$manzana') OR paqp.lotes IS NULL) OR
						(( paqp.lotes LIKE '$lote/$manzana,%' OR paqp.lotes LIKE '%,$lote/$manzana' 
						OR paqp.lotes LIKE '%,$lote/$manzana,%' OR paqp.lotes = '$lote/$manzana' ) AND (ao.lotes LIKE '$lote/$manzana,%' OR ao.lotes LIKE '%,$lote/$manzana' 
						OR ao.lotes LIKE '%,$lote/$manzana,%' OR ao.lotes = '$lote/$manzana') ))";
						$l_query = $this->db->query($aQuery);
						$array = array();
						if($l_query->num_rows() > 0){
							foreach ($l_query->result() as $value) {
								$cant_eje=0;
								$cant_x_eje=0;
								$options_constructores = $this->getOptionsConstructores($lote,$manzana,$value->idConstructorAo,$value->idConstructor);
								$estatus = $this->getStatusPrograma($value->semActual,$value->semana);
								$txt_estatus = ($estatus
									?'<span style="color:white;padding:3px;background-color:green;">EN TIEMPO</span>'
									:'<span style="color:white;padding:3px;background-color:red;">ATRASADA</span>'
								);
								$contratista = '<select id="contratista_'.$value->idAvance.'" style="width:200px;" onchange="setContratista(this)"
									data-idavance="'.$value->idAvance.'"
									>'.$options_constructores.'</select>';
								$txt_checked = '';
								if ($tipo_estimacion == 1) {
									$checked = $this->getStatusCheck($lote,$manzana,$value->lotes);
									$txt_checked = '<input class="myInput" type="checkbox" id="checked_'.$value->idAvance.'" '.($checked?'checked':'').
										' data-preciounitario="'.$value->precioUnitario.'"' .
										' data-idAvance="'.$value->idAvance.'"' .
										' data-lotes="'.$value->lotes.'"' .
										' data-clave="'.$value->clave.'"' .
										' data-descripcion="'.$value->descripcion.'"' .
										' data-idPresupuesto="'.$value->idPresupuesto.'"' .
										' data-idPptoPaq="'.$value->idPptoPaq.'"' .
										' data-lotesP="'.$value->lotesP.'"' .
										' data-semana="'.$value->semana.'"' .
										" data-acumulado='".$value->acumulado."'".
										" data-avanceC='".$value->avanceC."'".
										' data-cantidad="'.$value->cantidad.'"' .
										' data-iniciado="'.$value->iniciado.'"' .
										' data-lotesI="'.$value->lotesI.'"' .
										' data-abreviatura="'.$value->abreviatura.'"' .
										' data-semActual="'.$value->semActual.'"' .
										' onclick="actionCheck(this)"' .
										'>';
										$cant_eje=($checked) ? $value->cantidad : 0;
										$cant_x_eje=$value->cantidad - $cant_eje;
								}
								$txt_estado = "";
								if ( $tipo_estimacion == 2 ) {
									$estado = $this->getCantidadComplentaria($lote,$manzana,$value->avanceC);
									$txt_estado = '<input class="myInput" type="text" style="width:60px;" id="act_estado_'.$value->idAvance.'" value="'.$estado.'"' .
										' data-preciounitario="'.$value->precioUnitario.'"' .
										' data-idAvance="'.$value->idAvance.'"' .
										' data-idPresupuesto="'.$value->idPresupuesto.'"' .
										' data-idPptoPaq="'.$value->idPptoPaq.'"' .
										" data-acumulado='".$value->acumulado."'".
										' data-cantidad="'.$value->cantidad.'"' .
										" data-avanceC='".$value->avanceC."'".
										' onchange="actionChecked(this)"' .
										'>';
									$cant_eje=$this->getCantidadComplentaria($lote,$manzana,$value->acumulado);
									$cant_x_eje=$value->cantidad - $cant_eje;
								}

								$iniciadoMap = ($value->iniciado!==''?explode(',',$value->iniciado):array());
								$ltemza = $lote . '/' . $manzana;
								$txt_iniciado = '<input type="checkbox" id="checked_init_'.$value->idAvance.'" '.
									' data-preciounitario="'.$value->idAvance.'"' .
									' data-iniciado="'.$value->iniciado.'"' .
									' data-idPptoPaq="'.$value->idPptoPaq.'"' .
									' data-lotesI="'.$value->lotesI.'"' .
									' onclick="actionInit(this)"' .
									(in_array($ltemza, $iniciadoMap)?' checked':'') .
									'>';
								$array[] = array(
									'clave' => $value->clave,
									'descripcion' => $value->descripcion,
									'categoria' => $value->categoria,
									'abreviatura' => $value->abreviatura,
									'cant_abrev' => $value->cantidad,
									'precioUnitario' => toNumber($value->precioUnitario),
									'importe' => toNumber($value->precioUnitario * $value->cantidad),
									'estado' => $txt_checked . ' ' . $txt_estado,
									'cant_eje' => "<div id='cant_eje_$value->idAvance'>$cant_eje</div>",
									'cant_x_eje' => "<div id='cant_x_eje_$value->idAvance'>$cant_x_eje</div>",
									'iniciado' => $txt_iniciado,
									'contratista' => $contratista,
									'estatus' => $txt_estatus,
									'total'=>$cant_eje * ($value->precioUnitario * $value->cantidad)
								);
							}
						}
						$output = array(
							"draw" => 1,
							"recordsTotal" => $l_query->num_rows(),
							"recordsFiltered" => $l_query->num_rows(),
							"data" => $array,
						);
						echo json_encode($output);
						exit();
						break;
				}
				$output = array(
					"data" => $array,
				);
				echo json_encode($output);
			} catch (Exception $e) {
				die($e->getMessage());
			}
		}

		private function getCantidadComplentaria($lote, $manzana, $lotes = null) {
			$ltemza = $lote . '/' . $manzana;
			$cantidad = 0.0;
			$myLotes = $lotes ?? '';
			
			if ($myLotes !== 'null' && $myLotes !== '' && $myLotes !== null && !empty($myLotes)) {
				$lotesMap = json_decode($myLotes, true);
				if (array_key_exists($ltemza, $lotesMap)) {
					$cantidad = (double)$lotesMap[$ltemza];
				}
			}
			
			return $cantidad;
		}

		public function getStatusCheck($lote, $manzana, $lotes = null) {
			$lotesArray = (!is_null($lotes) && $lotes !== '') ? explode(',', $lotes) : [];
			$ltemza = $lote . '/' . $manzana;
			return in_array($ltemza, $lotesArray);
		}

		private function getStatusPrograma(?int $semana, ?int $semanaProg): ?bool {
			if ($semana !== null && $semanaProg !== null) {
				return $semana <= $semanaProg;
			} else {
				return false;
			}
		}

		private function getOptionsConstructores($lote,$mza,$idConstructorAo,$idConstructorPaq) {
			$idConstructor=$this->getCantidadComplentaria($lote,$mza,$idConstructorAo);
			$idConstructor=($idConstructor > 0) ? $idConstructor : $idConstructorPaq;
			$l_query = $this->db->query(
				"SELECT id, REPLACE(UPPER(CONCAT_WS(' ',nombre,apellidoP,apellidoM)),'  ',' ') nombre
				FROM constructores
				WHERE status = 1
				ORDER BY id DESC"
			);
			$options_html = '<option value="0" data-idConstructor="'.$idConstructorPaq.'">SELECCIONE UN CONTRATISTA </option>';
			foreach ($l_query->result() as $key => $value) {
				$selected=($value->id==$idConstructor) ? "selected" : "";
				$options_html .= '<option value="'.$value->id.'" '.$selected.'>'.$value->nombre.'</option>';
			}
			return $options_html;
		}

		/**
		 * @param	string	manzana
		 * @param	array	actividad
		 * @param	array	lote
		 * @param	double	cantidad
		 * @param	string	acumulado
		 */
		public function checkComplementaria() {
			try {
				$params = $_POST;
				$userId = $_SESSION['viv']['id'];

				$ltemza = $params['lote']['lote'] . '/' . $params['manzana'];
				// Paquete Presupuesto
				$acumulado = $params['actividad']['acumulado'] ?? '';
				$cant = $params['cantidad'] ?? 0;
				$errors = false;
				$acumuladoMap = array();
				$avanceCMap = array();

				if ($cant > 0) {
					if ($acumulado === '' || $acumulado == 'null') {
						if ($cant <= $params['actividad']['cantidad']) {
							$acumuladoMap[$ltemza] = $cant;
							$avanceCMap[$ltemza] = $cant;
						} else {
							http_response_code(400);
							$output = array(
								"statusCode" => 400,
								"message" => "Cantidad Excedida",
							);
							echo json_encode($output);
							$errors = true;
						}
					} else {
						//$acumuladoMap = json_decode($acumulado, true);
						$acumuladoMap=$acumulado;
						if (array_key_exists($ltemza, $acumuladoMap)) {
							$avanceC = $params['actividad']['avancec'] ?? '';
							$cantidadAvance = ($avanceC === '') ? 0 : (array_key_exists($ltemza, $avanceC) ? $avanceC[$ltemza] : 0);
							$cantAnterior = $acumuladoMap[$ltemza] - $cantidadAvance;
							$cantNueva = $cantAnterior + $cant;
							if ($cantNueva <= $params['actividad']['cantidad']) {
								$acumuladoMap[$ltemza] = $cantNueva;
								// Avance de obra
								if ($avanceC === '' || $avanceC === 'null') {
									$avanceCMap[$ltemza] = $cant;
								} else {
									$avanceCMap = $avanceC;
									$avanceCMap[$ltemza] = $cant;
								}
							} else {
								http_response_code(400);
								$output = array(
									"statusCode" => 400,
									"message" => "Cantidad Excedida",
								);
								echo json_encode($output);
								$errors = true;
							}
						} else {
							$acumuladoMap[$ltemza] = $cant;
						}
					}
					if (!$errors) {
						$this->db->trans_begin();
						// UPDATE AVANCE
						$jsonAvance = json_encode($avanceCMap);
						$idAvance = $params['actividad']['idavance'];
						$qavance = $this->db->query(
							"UPDATE avanceobra SET 
								avanceC='$jsonAvance', 
								updated_by=$userId, 
								updated=CURRENT_TIMESTAMP 
							WHERE id=$idAvance"
						);
						//UPDATE ACUMULADO
						$jsonAcumulado = json_encode($acumuladoMap);
						$idPptoPaq = $params['actividad']['idpptopaq'];
						$qacumulado = $this->db->query(
							"UPDATE paquete_presupuesto SET 
								acumulado='$jsonAcumulado', 
								updated_by=$userId, 
								updated=CURRENT_TIMESTAMP 
							WHERE id=$idPptoPaq"
						);
						//update data
						$cant_eje=$this->getCantidadComplentaria($params['lote']['lote'],$params['manzana'],$jsonAcumulado);
						$cant_x_eje=$params['actividad']['cantidad'] - $cant_eje;
						try {
							$this->db->trans_commit();
							http_response_code(200);
							$output = array(
								"statusCode" => 200,
								"message" => "La información ha sido actualizada.",
								"updateData" => ["cant_eje"=>$cant_eje,"cant_x_eje"=>$cant_x_eje],
							);
							echo json_encode($output);
						} catch (Exception $e) {
							$this->db->trans_rollback();
							http_response_code(500);
							$output = array(
								"statusCode" => 500,
								"title" => "Database Query Failed",
								"message" => $e->getMessage(),
							);
							echo json_encode($output);
						}
					}
				} else {
					http_response_code(400);
					$output = array(
						"statusCode" => 400,
						"title" => "Cantidad no es númerico",
						"message" => "Debes ingresar un valor numérico mayor a cero.",
					);
					echo json_encode($output);
				}
			} catch (Exception $e) {
				if ($this->db->trans_status() === FALSE) {
					$this->db->trans_rollback();
				}
				die($e->getMessage());
			}
		}

		/**
		 * @param	bool	$estado
		 * @param	string	$lote
		 * @param	string	$manzana
		 * @param	string	$lotes
		 * @param	string	$tabla
		 * @param	string	$column
		 * @param	int		$id
		 */
		public function checkLote($params=array(),$retorno=true) {
			$params = (COUNT($params)>0) ? $params : $_POST;
			$estado = filter_var($params['estado'], FILTER_VALIDATE_BOOLEAN);
			$lote = $params['lote'];
			$manzana = $params['manzana'];
			$lotes = $params['lotes'];
			$tabla = $params['tabla'];
			$column = $params['column'];
			$id = $params['id'];

			$userId = $_SESSION['viv']['id'];
			$lotesArray = (!is_null($lotes) && !empty($lotes)) ? explode(',', $lotes) : [];
			$loteManzana = $lote . '/' . $manzana;

			if ($estado) {
				if (!in_array($loteManzana, $lotesArray)) {
					$lotesArray[] = $loteManzana;
				}
			} else {
				if (in_array($loteManzana, $lotesArray)) {
					$lotesArray = array_diff($lotesArray, [$loteManzana]);
				}
			}
			$this->db->trans_begin();
			try {
				// UPDATE
				$myLotes = (count($lotesArray)>0?implode(',', $lotesArray):'');
				$queryUPD = $this->db->query(
					"UPDATE $tabla SET 
						$column='$myLotes', 
						updated_by=$userId,
						updated=CURRENT_TIMESTAMP 
					WHERE id=$id"
				);

				$this->db->trans_commit();
				http_response_code(200);
				$output = array(
					"statusCode" => 200,
					"message" => "La información ha sido actualizada.",
				);
				if($retorno){
					echo json_encode($output);
				}
			} catch (Exception $e) {
				$this->db->trans_rollback();
				http_response_code(500);
				$output = array(
					"statusCode" => 500,
					"title" => "Database Query Failed",
					"message" => $e->getMessage(),
				);
				if($retorno){
					echo json_encode($output);
				}
			}
		}

		/**
		 * @param	number	manzana
		 * @param	array	lote
		 * @param	number	idContratista
		 * @param	number	idAvance
		 */
		public function setContratista($params=[],$retorno=true) {
			$params = (COUNT((array) $params) > 0) ? $params : $_POST;
			try {
				$userId = $_SESSION['viv']['id'];

				$ltemza = $params['lote']['lote'] . '/' . $params['manzana'];
				$idavance = $params['idavance'];
				$idcontratista = $params['idcontratista'];
				$contructorArr = array();
				$avance_obra = $this->db->query("SELECT idConstructor FROM avanceobra WHERE id = {$idavance}")->row();

				if ( in_array($avance_obra->idConstructor, array('','null',null)) ) {
					$contructorArr[$ltemza] = $idcontratista;
				} else {
					$contructorArr = json_decode($avance_obra->idConstructor, true);
					$contructorArr[$ltemza] = $idcontratista;
				}
				$this->db->trans_begin();
				// UPDATE AVANCE
				$jsonAvance = json_encode($contructorArr);
				$qavance = $this->db->query(
					"UPDATE avanceobra SET 
						idConstructor='$jsonAvance', 
						updated_by=$userId, 
						updated=CURRENT_TIMESTAMP 
					WHERE id=$idavance"
				);
				try {
					$this->db->trans_commit();
					http_response_code(200);
					$output = array(
						"statusCode" => 200,
						"message" => "La información ha sido actualizada.",
					);
					if($retorno){
						echo json_encode($output);
					}
				} catch (Exception $e) {
					$this->db->trans_rollback();
					http_response_code(500);
					$output = array(
						"statusCode" => 500,
						"title" => "Database Query Failed",
						"message" => $e->getMessage(),
					);
					if($retorno){
						echo json_encode($output);
					}
				}
			} catch (Exception $e) {
				if ($this->db->trans_status() === FALSE) {
					$this->db->trans_rollback();
				}
				die($e->getMessage());
			}
		}
	}

?>