<?php // Promotor
	defined('BASEPATH') OR exit('No direct script access allowed');

	class Entrega extends MX_Controller {
		public $data,$vParameters,$mainView,$fv,$urlLogo,$appProduction;
		public function __construct() {
			$this->nsession = $this->config->item('nsession');
			if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
			$this->fv = 'entrega'; // form validation variable
			$this->mainView = 'entrega';
			$this->data['fjs'] = '';
			$this->data['js'] = '<script src="assets/js/entrega/listado.js" type="text/javascript"></script>';
			$this->data['css'] = '';
			// Tools
			$this->load->helper(array('tools','numeros','url','form','date','text','security'));
			// Modelos
			$this->load->model(array('maltaventa','mprospecto','mproyecto','mfraccionamiento','musuario','mcomisionbono','mautorizacion',
			'mdeposito','mgestoria','mnotaria','mentrega','mfraccionamientoxusuario','mprototipos','mprototipoxfraccionamiento','mareastatus', 
			'mcomisiones','mconstructores'));//maltaventa tiene los datos para gestoria, mgestoria se usa para obtener la funcion getNext id al guardar archivos
			$this->appProduction = $this->config->item('appProduction');
			// Lbrerias
			// $this->load->library(array('email','session'));
			$this->data['fotos_www'] = $this->config->item('base_www').'/alta_venta/entrega/';

			// Debugging
			$this->output->enable_profiler(false);

			//Validación de usuarios
			valSession("calidad",$this->fv);

			$this->idFraccionamiento = 0;
			// $logoFraccionamiento = $this->mfraccionamiento->getCampo('foto',$_SESSION['viv']['idFraccionamiento']);
			// $nomFracc = $this->mfraccionamiento->getCampo('titulo',$_SESSION['viv']['idFraccionamiento']);
			// $this->urlLogo = ($logoFraccionamiento!='')?"<img height='80' src='uploads/fraccionamientos/".$logoFraccionamiento."' />":$nomFracc;
			$this->urlLogo = '';

			//echo $this->urlLogo;
		}

		public function setLogo()
		{
			$logoFraccionamiento = $this->mfraccionamiento->getCampo('foto',$this->idFraccionamiento);
			$nomFracc = $this->mfraccionamiento->getCampo('titulo',$this->idFraccionamiento);
			$this->urlLogo = ($logoFraccionamiento!='')?"<img height='80' src='uploads/fraccionamientos/".$logoFraccionamiento."' />":$nomFracc;
		}

		public function index() {
			$data['q'] = '';
			$this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
			$this->load->view('templates/main_template',$this->data);
		}


     	public function listado(){
			$q = $this->maltaventa->getJoinEntrega();
	        if (!is_numeric($q)){
	            //print_r($q->result());exit();
	            foreach ($q->result() as $row){
	            	//$existePrimeraComision = $this->mcomisionbono->getByIdAV($row->id);
            		$planoPrototipo = ($this->mprototipos->getCampo("pdf_1",$row->idPrototipo)!='' && $this->mprototipos->getCampo("pdf_1",$row->idPrototipo)!=false)?base_url()."uploads/prototipos/".$this->mprototipos->getCampo("pdf_1",$row->idPrototipo):'';
	            	$dEntrega = $this->mentrega->getByIdAltaVenta($row->idAltaVenta);
	            	$pdf_12 = !is_numeric($dEntrega)?$dEntrega['pdf_12']:0;
	            	$pdf_13 = !is_numeric($dEntrega)?$dEntrega['pdf_13']:0;
	            	$statusEntrega = !is_numeric($dEntrega)?$dEntrega['statusEntrega']:'';
	                $total = $row->monto + $row->subCuenta - $row->gastosOperacion;
	                $fechaEntrega = (!is_numeric($dEntrega))?$dEntrega['fechaEntrega']:'';
					$editar=($statusEntrega==1) ? false : true;
					$retro=($statusEntrega!=1) ? false : true;
	                $array['aaData'][] = array(
	                	'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo',$this->mproyecto->getCampo('idFraccionamiento',$row->idProyecto)),
	                	'ronda' => $row->ronda,
	                    'lote' => $this->mproyecto->getCampo('lote',$row->idProyecto),
	                    'manzana' => $row->manzana,
	                    'cliente' => strtoupper($this->mprospecto->getCampo('nombre',$row->idProspecto)." ".$this->mprospecto->getCampo('apellidoP',$row->idProspecto)." ".$this->mprospecto->getCampo('apellidoM',$row->idProspecto)),
	                    'telefono' => $row->telefono,
	                    'nss' => $row->nss,
						'nOficial' => $row->nOficial,
	                    'promotor' => strtoupper($this->musuario->getCampo("nombre",$row->idPromotor)." ".$this->musuario->getCampo("apellidoP",$row->idPromotor)." ".$this->musuario->getCampo("apellidoM",$row->idPromotor)),
	                    'fechaEntrega' => ($fechaEntrega!='' && $fechaEntrega!='0000-00-00')?date('d/m/Y',strtotime($fechaEntrega)):'',
	                    'precioVenta' => precio_format($row->precioVenta),
	                    'avaluo' => precio_format($row->avaluo),
	                    'precioVentaOci' => precio_format($row->precioVentaOci),
	                    'sumaFinal' => precio_format($row->sumaFinal),
	                    'bonoEquipamiento' => precio_format($row->bonoEquipamiento),
						'constructor' => ($row->idConstructor != "") ? $this->mconstructores->getCampo("CONCAT(nombre,' ',apellidoP,' ',apellidoM)",$row->idConstructor) : "", 
	                    //'comision' => $this->musuario->getCampo("comision",$row->idPromotor)."%",
	                    //'importeComision' => precio_format($row->importeComision),
	                    'statusVivienda' => strtoupper(estatus_proyecto_reporte($row->statusVenta)),
	                    'statusEntrega' => /*$pdf_12!=0&&$pdf_13!=0&&*/$statusEntrega==1?strtoupper('<label style="width: 100%;text-align: center;"><i class="fa fa-check" style="font-size: 20px;"></i>Entregado</label>'):'',
	                    'acciones' => (in_array($_SESSION["viv"]["rol"], permisos("calidad","entrega_edit")['r'])) ? accionesEntrega($row->id,$this->router->class, true, $editar, $retro,'','',false,0,false,0,$planoPrototipo) : accionesNoEdit($row->id,$this->router->class)
	                    );	            	

	            }
	        } else{
	            $array['aaData'][] = array(
	            	'fraccionamiento' => 'No hay registros',
	            	'ronda' => 'No hay registros',
	                'lote' => 'No hay registros',
	                'manzana' => 'No hay registros',
	                'cliente' => 'No hay registros',
	                'telefono' => 'No hay registros',
	                'nss' => 'No hay registros',
					'nOficial' => 'No hay registros',
	                'promotor' => 'No hay registros',
	                'fechaEntrega' => 'No hay registros',
	                'precioVenta' => 'No hay registros',
	                'avaluo' => 'No hay registros',
	                'precioVentaOci' => 'No hay registros',
	                'sumaFinal' => 'No hay registros',
	                'bonoEquipamiento' => 'No hay registros',
	                //'comision' => 'No hay registros',
	                //'importeComision' => 'No hay registros',
	                'statusVivienda' => 'No hay registros',
	                'statusEntrega' => 'No hay registros',
	                'acciones' => 'No hay registros'
	                );
	        }

	        echo json_encode($array);
	    }


	    public function editar($id = null){ // $id = id en tabla alta venta, idGestoria es el id en la tabla gestoria

	    	$data['msg'] = '';
	    	
	    	$data['msgInvalid'] = '';
	    	$resultado = true;
	    	$subir = false;
	    	$contadorArchivos = 0;
	    	$validaEntrega = false;

			$info = $this->maltaventa->getByIdForGestoria($id);

			// print_r($info); exit();
        	$data = (!is_numeric($info)) ? $info : '';
        	$data['disabled'] = (!is_numeric($info)) ? false : true;
        	$data['error'] = '';
        	// print_r($data); // exit();

        	if(is_numeric($info)){
        		$data['id']='';
        		$data['msgInvalid'] = 'No se encontró el registro';
        	}else{
        		$data['msgInvalid'] = '';
        	}

			$idProyecto = (!is_numeric($info)) ? $info['idProyecto'] : 0;

        	//VERIFICAMOS SI EL REGISTRO SE ENCUENTRA EN TABLA ENTREGA
        	$entrega = $this->mentrega->getByIdAltaVenta($id);
        	$data['entrega'] = $entrega;
        	// echo "<pre>"; print_r($data); echo "</pre>"; exit();
        	// echo "<br><br><br>"; print_r($entrega); exit();


        	if (isset($_POST['fechaEntrega'])){
        		// print_r($_POST['input_group_regadera']); exit();

        		$this->load->library('form_validation');
		        if ($this->form_validation->run($this->fv) == FALSE) {
		            $data['msg'] = validation_errors();
		        } else {

	                // Subida de pdf
		            $config = array();
		            $this->load->library('upload', $config);

		            if (isset($_FILES)){
		                $imagenes = array();
		                foreach($_FILES as $key=>$value){
		                    if ($_FILES[$key]['size'] > 0){
		                        $_FILES[$key]['name'] = strtolower($_FILES[$key]['name']);
		                        $imagenes[] = $key;
		                    }
		                }
		                $totalImagenes = count($imagenes);
		                for($i=0; $i< $totalImagenes; $i++){
		                    $ext = pathinfo($_FILES[$imagenes[$i]]['name'],PATHINFO_EXTENSION);
		                    //Configuracion del thumbnail
		                    if($imagenes[$i]!='pdf'){
		                        $nCampoC = explode("_",$imagenes[$i]);
		                        $tipo = $nCampoC[0];
		                        $v = $nCampoC[1];

		                    } else {
		                        $v = 0;
		                        $tipo = 'pdf';
		                    }
		                    if ($tipo == 'pdf'){
		                        $uploaddir = $this->data['fotos_www'];
		                        /*$nextId = $idGestoria;*/
		                        $nextId = (!is_numeric($entrega))?$entrega['id']:$this->mentrega->nextId();
		                        $config['file_name'] =  $nextId."_".$v;
		                        $config['overwrite'] = TRUE;
		                        $config['upload_path'] = $uploaddir;
		                        $config['max_size'] = '80000';
		                        $config['allowed_types'] = 'pdf|jpg|jpeg|png|gif';
		                        $this->upload->initialize($config);
		                        if ( ! $this->upload->do_upload($imagenes[$i]) )
		                        {
		                            $redirect = 1;
		                            $data['error'] = $this->upload->display_errors();
		                        }
		                        else
		                        {
		                        	$contadorArchivos++;
		                            $dataFile = $this->upload->data($imagenes[$i]);
		                            $fotoI = 'pdf_'.$v;
		                            //$thumbI = 'thumbnail_'.$v;
		                            if ($v == 0){
		                                //Foto default
		                                $pData['pdf'] = $nextId.'_'.$v.'.'.$ext;//
		                            } else {
		                                $pData[$fotoI] = $nextId.'_'.$v.'.'.$ext;
		                            }
		                        }
		                    }

		                }
		            }

		        	$fechaEntrega = $this->input->post('fechaEntrega', TRUE);
		        	$fechaEntrega =  str_replace('/', '-', $fechaEntrega);
		        	$pData['idAltaVenta'] = $id;

		        	$pdf_12 = (!is_numeric($entrega))?$entrega['pdf_12']:'';
		        	$pdf_13 = (!is_numeric($entrega))?$entrega['pdf_13']:'';
		        	$existeFE = (!is_numeric($entrega))?$entrega['fechaEntrega']:'';
		        	$statusEntrega = (!is_numeric($entrega))?$entrega['statusEntrega']:0;

		        	if($pdf_12!='' && $pdf_13!=''){
		        		$subir = true;
		        	}elseif($existeFE!='' && $existeFE!='0000-00-00' && $existeFE!='1969-12-31'){

		        	}else{
		        		//$pData['fechaEntrega'] = ($contadorArchivos==2)?'0000-00-00':'0000-00-00';
		        		$pData['fechaEntrega'] = ($contadorArchivos>=1)?date('Y-m-d'):'0000-00-00';
		        		$pData['statusEntrega'] = ($contadorArchivos>=1)?1:0;
		        		$validaEntrega = ($contadorArchivos>=1)?true:false;
		        		//date_format(new DateTime($fechaEntrega),'Y-m-d');     date('Y-m-d', strtotime($fechaEntrega))
		        	}

		        	if($contadorArchivos>=1){
		        		$subir = true;
		        	}

		        	if ( !is_numeric($entrega) && $entrega['statusEntrega']==0 && $subir==false){ // $existeFE!='' && $existeFE!='0000-00-00' && $existeFE!='1969-12-31'
		        		//echo $subir;exit();
		        		$data['error'] = '<span style="color:red;">Es necesario subir todos los documentos</span>';
		        	}else{
			        	// Table one
			        	$data_1 = '';
			        	$data_1 .= $this->input->post('v_regadera',TRUE).'|';
			        	$data_1 .= $this->input->post('v_inodoro',TRUE).'|';
			        	$data_1 .= $this->input->post('v_lavabo',TRUE).'|';
			        	$data_1 .= $this->input->post('v_fregadero',TRUE).'|';
			        	$data_1 .= $this->input->post('v_gas_estufa',TRUE).'|';
			        	$data_1 .= $this->input->post('v_lavadero',TRUE).'|';
			        	$data_1 .= $this->input->post('v_aguafria_drenaje',TRUE).'|';
			        	$data_1 .= $this->input->post('v_aguafriacaliente_boiler',TRUE).'|';
			        	$data_1 .= $this->input->post('v_gas_tanque',TRUE).'|';
			        	$data_1 .= $this->input->post('v_registro_sanitario',TRUE).'|';
			        	$data_1 .= $this->input->post('v_acometida',TRUE).'|';
			        	$data_1 .= $this->input->post('v_base_medidor',TRUE).'|';
			        	$data_1 .= $this->input->post('v_centro_carga',TRUE).'|';
			        	$data_1 .= $this->input->post('v_varilla_tierra',TRUE).'|';
			        	$data_1 .= $this->input->post('v_timbre',TRUE).'|';
			        	$data_1 .= $this->input->post('v_apagadores',TRUE).'|';
			        	$data_1 .= $this->input->post('v_toma_corriente',TRUE).'|';
			        	$data_1 .= $this->input->post('v_television',TRUE).'|';
			        	$data_1 .= $this->input->post('v_marcos_puertas',TRUE).'|';
			        	$data_1 .= $this->input->post('v_ventanas_aluminio',TRUE).'|';
			        	$data_1 .= $this->input->post('v_cisterna',TRUE);

			        	// Table two
			        	$data_2 = '';
			        	$data_2 .= $this->input->post('v_pasamanos_escalera',TRUE).'|';
			        	$data_2 .= $this->input->post('v_vidrios_normales',TRUE).'|';
			        	$data_2 .= $this->input->post('v_mosquiteros',TRUE).'|';
			        	$data_2 .= $this->input->post('v_puertas_interiores',TRUE).'|';
			        	$data_2 .= $this->input->post('v_puertas_exteriores',TRUE).'|';
			        	$data_2 .= $this->input->post('v_chapas_int_ext',TRUE).'|';
			        	$data_2 .= $this->input->post('v_llaves_int_ext',TRUE).'|';
			        	$data_2 .= $this->input->post('v_acabado_exterior',TRUE).'|';
			        	$data_2 .= $this->input->post('v_acabado_interior',TRUE).'|';
			        	$data_2 .= $this->input->post('v_proteccion_balcon',TRUE).'|';
			        	$data_2 .= $this->input->post('v_banquetas',TRUE).'|';
			        	$data_2 .= $this->input->post('v_vitropiso',TRUE).'|';
			        	$data_2 .= $this->input->post('v_azulejo_baño',TRUE).'|';
			        	$data_2 .= $this->input->post('v_azulejo_cocina',TRUE).'|';
			        	$data_2 .= $this->input->post('v_bardas_medianeras',TRUE).'|';
			        	$data_2 .= $this->input->post('v_impermeabilizacion',TRUE).'|';
			        	$data_2 .= $this->input->post('v_focos_ahorradores',TRUE).'|';
			        	$data_2 .= $this->input->post('v_ahorradores_agua',TRUE).'|';
			        	$data_2 .= $this->input->post('v_boiler',TRUE).'|';
			        	$data_2 .= $this->input->post('v_hidroneumatico',TRUE).'|';
			        	$data_2 .= $this->input->post('v_garantias',TRUE);
			        	
			        	// echo "Data 1:<br>".$data_1;
			        	// echo "<br><br>";
			        	// echo "Data 2:<br>".$data_2;
			        	// exit();
			        	// echo "<pre>"; print_r($pData); echo "</pre>"; exit();
			        	$pData['data_1'] = $data_1;
			        	$pData['data_2'] = $data_2;
			        	
			        	$pData['hidroneumatico'] = $this->input->post('v_hidro2',TRUE);
			        	$pData['conectoresGas'] = $this->input->post('v_conectoresGas',TRUE);
			        	$pData['calentador'] = $this->input->post('v_calentador',TRUE);
			        	$pData['tarjaAcero'] = $this->input->post('v_tarjaAcero',TRUE);
			        	$pData['llavesCuadroMedidor'] = $this->input->post('v_llavesCuadroMedidor',TRUE);
			        	$pData['focosAhorradores'] = $this->input->post('v_focosAhorradores',TRUE);
			        	
			        	$this->db->trans_start();
			        	if (!is_numeric($entrega)){
			        		$this->mentrega->actualizar($pData, $entrega['id']);
			        		$idEntrega = $entrega['id'];
			        	}else{
			        		$idEntrega = $this->mentrega->insertar($pData);
			        		//validamos para insertar automaticamente el segundo pago del promotor
			        		$rowComisiones = $this->mcomisionbono->getByIdAv($id);
			        		$rowPagos = $this->mautorizacion->getByIdAv($id);
			        		if(!is_numeric($rowComisiones) && !is_numeric($rowPagos)){
			        			$importeComision = $rowComisiones['importeComision'];
			        			$primerPagoPromotor = $rowPagos['primerPagoPromotor'];
			        			$aData['segundoPagoPromotor'] = ($primerPagoPromotor>0)?$importeComision - $primerPagoPromotor:$importeComision;
			        			$aData['fechaSegundoPagoPromotor'] = date('Y-m-d');
			        			//$this->mautorizacion->actualizar($aData,$rowPagos['id']);
			        		}
			        	}
			        	if($idEntrega>0 && $validaEntrega == true && $statusEntrega==0){
			        		$ae['idArea'] = 4;
			                $ae['idAltaVenta'] = $id;
			                $ae['idStatus'] = 'entregadas';
			                $ae['fecha'] = date('Y-m-d H:i:s');
			                $this->mareastatus->insertar($ae);
			                //echo "se entregó";exit();
			        	}
			        	$this->db->trans_complete();
			        	if ($this->db->trans_status() === FALSE)
			            {
			                $resultado = false;
			                $data['msgInvalid'] = 'El registro no pudo ser insertado en la BD, verifique la información que intenta guardar';
			            }
			            if ($resultado==true) {
			            	$pdf12_ = $this->mentrega->getCampo('pdf_12',$idEntrega);
			            	$pdf13_ = $this->mentrega->getCampo('pdf_13',$idEntrega);
			            	if ( (!is_null($pdf12_) || !is_null($pdf13_) ) && $statusEntrega==0 ) {

								$comision = $this->mcomisiones->getByIdAV($id);
								if(!is_numeric($comision)){
									if(!$comision['statusEntrega']){
										$uData['statusEntrega'] = 1;
										$this->mcomisiones->actualizar($uData, $comision['id']);
									}
								}

			    	        	// Envio de autoRespuesta
			                    $autores = $this->autoRespuesta($id);

								require('Cronjob.php');
                            	$cronjob = new Cronjob();

								$pData2['idProyecto'] = $idProyecto;
                                $pData2['tipo'] = 'entregado';

                                $insert = $cronjob->insertLogsNotifications($pData2);
			            	}
		                    // Redirección
			                redirect($this->router->class."?close");
			            }
		        	}		        	


		        }
	        }

	        $data['mpromotor'] = $this->musuario;

	        $this->data['contenido'] = $this->load->view($this->mainView . '/editar_view', $data, true);
	        $this->load->view('templates/main_template', $this->data);

	    }

	public function retroceso($id = null){ 
		$this->db->query("UPDATE entrega SET statusEntrega=0,fechaEntrega='0000-00-00',pdf_12='',pdf_13='' WHERE idAltaVenta=$id");
		$this->db->query("DELETE FROM logs_notifications WHERE tipo='entrega' AND idProspecto=(SELECT idProspecto FROM alta_venta WHERE id=$id ORDER BY id DESC LIMIT 1)");
		redirect($this->router->class);
	}


	public function ver($id = null)
    {
        //Obtenemos el id del Proyecto a aprtir de id alta venta
        $id = $this->maltaventa->getCampo("idProyecto",$id);
        $info = $this->mproyecto->getById($id);
        $data = $info;
        $data['etapa_alta_venta'] = false;
        $data['etapa_validacion_venta'] = false;
        $data['etapa_gestoria'] = false;
        $data['etapa_comisionbono'] = false;
        $data['etapa_autorizaciones'] = false;
        $data['etapa_deposito'] = false;
        $data['etapa_entrega'] = false;
        $data['etapa_encuesta'] = false;
        $data['etapa_postventa'] = false;

        $altaVenta = $this->maltaventa->getStatusByIdProyecto($id);
        $idAltaVenta = $this->maltaventa->getIdAltaVentaByIdProyecto($id);
        $statusProyecto = (!is_numeric($altaVenta))?$altaVenta->row()->statusValidacion:'';
        
        
        /*
        switch ($statusProyecto) {
            case '0':
                $data['etapa_alta_venta'] = true;
                $data['detalle_venta'] = $this->maltaventa->getAltaVentaByIdProy($id);
                break;
            case '1':
                $data['etapa_alta_venta'] = true;
                $data['etapa_validacion_venta'] = true;
                $data['detalle_venta'] = $this->maltaventa->getValidacionVentaByIdProy($id);
                break;
            case '2':
                $data['etapa_alta_venta'] = true;
                $data['etapa_validacion_venta'] = true;
                $data['detalle_venta'] = $this->maltaventa->getValidacionVentaByIdProy($id);
                break;
            case '3':
            case '4':
            case '5':
                $data['etapa_alta_venta'] = true;
                $data['etapa_validacion_venta'] = true;
                $data['etapa_gestoria'] = true;
                $data['detalle_venta'] = $this->maltaventa->getGestoriaByIdProy($id);

                $comisiones = $this->mcomisionbono->getByIdAV($data['detalle_venta']['id']);//($idAltaVenta->row()->id);
                if ( !is_numeric($comisiones) ) {
                    $data['etapa_comisionbono'] = true;
                    $data['detalle_comisionbono'] = $comisiones;

                }

                $autorizaciones = $this->mautorizacion->getByIdAV($data['detalle_venta']['id']);
                if ( !is_numeric($autorizaciones) ) {
                    $data['etapa_autorizaciones'] = true;
                    $data['detalle_autorizaciones'] = $autorizaciones;
                }

                $deposito = $this->mdeposito->getByIdAV($data['detalle_venta']['id']);
                if ( !is_numeric($deposito) ) {
                    $data['etapa_deposito'] = true;
                    $data['detalle_deposito'] = $deposito;
                }

                $entrega = $this->mentrega->getByIdAV($data['detalle_venta']['id']);
                if ( !is_numeric($entrega) ) {
                    $data['etapa_entrega'] = true;
                    $data['detalle_entrega'] = $entrega;
                }

                $encuesta = $this->mencuestavivienda->getByIdAV($data['detalle_venta']['id']);
                if ( !is_numeric($entrega) ) {
                    $data['etapa_encuesta'] = true;
                    $data['detalle_encuesta'] = $encuesta;
                }

                $postventa = $this->mpostventa->getByIdAV($data['detalle_venta']['id']);
                if ( !is_numeric($postventa) ) {
                    $data['etapa_postventa'] = true;
                    $data['detalle_postventa'] = $postventa;
                }
                break;
            default:

                break;
        }*/

        $data['etapa_alta_venta'] = true;
        $data['etapa_validacion_venta'] = true;
        $data['etapa_gestoria'] = true;
        $data['detalle_venta'] = $this->maltaventa->getGestoriaByIdProy($id);

        $comisiones = $this->mcomisionbono->getByIdAV($data['detalle_venta']['id']);//($idAltaVenta->row()->id);
        if ( !is_numeric($comisiones) ) {
            $data['etapa_comisionbono'] = true;
            $data['detalle_comisionbono'] = $comisiones;

        }

        $autorizaciones = $this->mautorizacion->getByIdAV($data['detalle_venta']['id']);
        if ( !is_numeric($autorizaciones) ) {
            $data['etapa_autorizaciones'] = true;
            $data['detalle_autorizaciones'] = $autorizaciones;
        }

        $deposito = $this->mdeposito->getByIdAV($data['detalle_venta']['id']);
        if ( !is_numeric($deposito) ) {
            $data['etapa_deposito'] = true;
            $data['detalle_deposito'] = $deposito;
        }

        $entrega = $this->mentrega->getByIdAV($data['detalle_venta']['id']);
        if ( !is_numeric($entrega) ) {
            $data['etapa_entrega'] = true;
            $data['detalle_entrega'] = $entrega;
        }

        $data['module'] = 0;//( !is_null($module) ? 'busqueda_vivienda' : 0);
        $data['mpromotor'] = $this->musuario;
        $data['mprototipoxfraccionamiento'] = $this->mprototipoxfraccionamiento;
        $data['mprototipos'] = $this->mprototipos;
        $this->data['contenido'] = $this->load->view($this->mainView . '/ver_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }


        public function eliminar_archivo()
	    {

	        if (isset($_POST['elid'])){
	            $id = $this->input->post('elid');
	            $campo = $this->input->post('elcampo'); //Obteniendo el nombre de la foto y thumbnail
	            if($campo !="0"){
	                $archivo = $this->mentrega->getCampo('pdf_'.$campo,$id);
	                if(unlink($this->data['fotos_www'].$archivo)){// Haciendo update a la tabla
	                    $c_data['pdf_'.$campo] ='';
	                    $this->mentrega->actualizar($c_data,$id);
	                    $c_valor = "true";
	                    //$this->msomos->borrar($id);
	                }else{ $c_valor = "false";}
	            }else{
	                $archivo = $this->mentrega->getCampo('pdf',$id);
	                if(unlink($this->data['fotos_www'].$archivo)){// Haciendo update a la tabla
	                    $c_data['pdf'] ='';
	                    $this->mentrega->actualizar($c_data,$id);
	                    $c_valor = "true";
	                    //$this->msomos->borrar($id);
	                }else{ $c_valor = "false";}
	            }
	            $data = json_encode(array("valor"=>$c_valor));
	            echo $data;

	        }
	    }

	    //Formatos que se expiden
	    /*public function manual($id = null) {
	    	$this->load->library("mpdf_lib");
	    	$data = '';
	    	$data['mfraccionamiento'] = $this->mfraccionamiento;
	    	$html = $this->load->view('formatospdf/manual_view.php',$data,true);
	    	// echo $html;
	    	// exit();
	    	$this->mpdf_lib->downloadPDF($html,"manual",0);
	    }*/

   		public function manual($id = null){
	        $this->load->library("mpdf_lib");
	        $data = '';
	        $info = $this->maltaventa->getByIdAll($id);
	        $data = $info;
	        $data['mfraccionamiento'] = $this->mfraccionamiento;
	        $this->idFraccionamiento = $info['idFraccionamiento'];
	        $this->setLogo();
	        // echo "<pre>"; print_r($data); echo "</pre>"; exit();
	        $html = $this->load->view('formatospdf/manual_view.php',$data,true);
	       // echo $html;
	          //   exit();
	        $this->mpdf_lib->downloadPDF($html,"manual",0,'footer','header',$this->urlLogo,'','',false,false,$this->idFraccionamiento);
	    }

   		/*public function vales($id = null){
	        $this->load->library("mpdf_lib");
	        $data = '';
	        $html = $this->load->view('formatospdf/vales_view.php',$data,true);
	            // echo $html;
	            // exit();
	        $this->mpdf_lib->downloadPDF($html,"vales",0);
    	}

    	public function garantias($id = null){
	        $this->load->library("mpdf_lib");
	        $data = '';
	        $html = $this->load->view('formatospdf/garantias_view.php',$data,true);
	            // echo $html;
	            // exit();
	        $this->mpdf_lib->downloadPDF($html,"garantias",0);
	    }*/

	    public function reglamento($id = null){
	        $this->load->library("mpdf_lib");
	        $data = '';
	        $info = $this->maltaventa->getByIdAll($id);
	        $data = $info;
	        $data['mfraccionamiento'] = $this->mfraccionamiento;
	        $this->idFraccionamiento = $info['idFraccionamiento'];
	        $this->setLogo();
	        // echo "<pre>"; print_r($data); echo "</pre>"; exit();
	        $html = $this->load->view('formatospdf/reglamento_view.php',$data,true);
	       // echo $html;
	          //   exit();
	        $this->mpdf_lib->downloadPDF($html,"entrega",0,'footer','header',$this->urlLogo,'','',false,false,$this->idFraccionamiento);
	    }


	    public function vales($id = null){

	        $this->load->library("mpdf_lib");
	        $data = '';
	        // obterner los datos del cliente y el lote
	        $info = $this->maltaventa->getByIdAll($id);
	        $data = $info;
	        $tecnica = $this->mfraccionamientoxusuario->getTecnicaSelectResultByIdFracc($_SESSION['viv']['idFraccionamiento']);

	        if (!is_numeric($tecnica)){
		        $tecnica = $tecnica->result();
	        	// $data['tecnica'] = $tecnica->result();
	        	// print_r($tecnica[0]->id);
	        	$dTecnica = $this->musuario->getById($tecnica[0]->id);
	        }else{
	        	$dTecnica = '';
	        }
	        
	        $entrega = $this->mentrega->getByIdAltaVenta($id);
        	$data['entrega'] = $entrega;
	        
	        $data['tecnica'] = $dTecnica;
	        // print_r($data); exit();
	        $data['mfraccionamiento'] = $this->mfraccionamiento;
	        $this->idFraccionamiento = $info['idFraccionamiento'];
	        $this->setLogo();
	        // echo "<pre>"; print_r($data); echo "</pre>"; exit();
	        $html = $this->load->view('formatospdf/vales_view.php',$data,true);
	        $this->mpdf_lib->downloadPDF($html,"vales",0,'footer','header',$this->urlLogo,'','',false,false,$this->idFraccionamiento);
	        /*$this->load->library("mpdf_lib");
	        $data = '';
	        $html = $this->load->view('formatospdf/vales_view.php',$data,true);

	        $this->mpdf_lib->downloadPDF($html,"vales",0);*/
	    }

	    public function garantias($id = null){
	        $this->load->library("mpdf_lib");
	        $data = '';

	        $info = $this->maltaventa->getByIdAll($id);
	        $data = $info;
	        $tecnica = $this->mfraccionamientoxusuario->getTecnicaSelectResultByIdFracc($data['idFraccionamiento']);
	        if (!is_numeric($tecnica)){
	        	$tecnica = $tecnica->result();
	        	$dTecnica = $this->musuario->getById($tecnica[0]->id);
	        	$data['tecnica'] = $dTecnica;
	        }else{
	        	$data['tecnica']['nombre'] = '';
	        	$data['tecnica']['apellidoP'] = '';
	        	$data['tecnica']['apellidoM'] = '';
	        }
	        $data['mfraccionamiento'] = $this->mfraccionamiento;
	        $this->idFraccionamiento = $info['idFraccionamiento'];
	        $this->setLogo();
	        // echo "<pre>"; print_r($data); echo "</pre>"; exit();
	        // $data ["mfraccionamiento"]=$this->mfraccionamiento;



	        $html = $this->load->view('formatospdf/garantias_view.php',$data,true);
	        //echo $html;exit();
	        $this->mpdf_lib->downloadPDF($html,"garantias",0,'footer','header',$this->urlLogo,'','',false,false,$this->idFraccionamiento);

	        // $this->load->library("mpdf_lib");
	        // $data = '';
	        // $html = $this->load->view('formatospdf/garantias_view.php',$data,true);
	        //     // echo $html;
	        //     // exit();
	        // $this->mpdf_lib->downloadPDF($html,"garantias",0);
	    }

	    public function recepcion($id = null){
	        $this->load->library("mpdf_lib");
	        $data = array();


	        $info = $this->maltaventa->getByIdAll($id);
	        $data = $info;
	        $tecnica = $this->mfraccionamientoxusuario->getTecnicaSelectResultByIdFracc($data['idFraccionamiento']);
	        if (!is_numeric($tecnica)){
	        	$tecnica = $tecnica->result();
	        	$dTecnica = $this->musuario->getById($tecnica[0]->id);
	        	$data['tecnica'] = $dTecnica;
	        }else{
	        	$data['tecnica']['nombre'] = '';
	        	$data['tecnica']['apellidoP'] = '';
	        	$data['tecnica']['apellidoM'] = '';
	        }

	        $data['mfraccionamiento'] = $this->mfraccionamiento;
	        $this->idFraccionamiento = $info['idFraccionamiento'];
	        $this->setLogo();
	        // echo "<pre>"; print_r($data); echo "</pre>"; exit();
	        $data['entrega'] = $this->mentrega->getByIdAltaVenta($id);

	        // echo "<pre>"; print_r($data); echo "</pre>"; exit();
	        $html = $this->load->view('formatospdf/recepcion_view.php',$data,true);
/*	        echo $html;
	        exit();*/
	        $this->mpdf_lib->downloadPDF($html,"recepcion",0,'footer','header',$this->urlLogo,'','',false,false,$this->idFraccionamiento);


	        // $this->load->library("mpdf_lib");
	        // $data = '';
	        // $html = $this->load->view('formatospdf/recepcion_view.php',$data,true);
	        //     // echo $html;
	        //     // exit();
	        // $this->mpdf_lib->downloadPDF($html,"recepcion",0);
	    }

	    public function cufrisa($id = null){
	        $this->load->library("mpdf_lib");
	        $data = '';
	        $info = $this->maltaventa->getByIdAll($id);
	        $data = $info; 
	        $data['mfraccionamiento'] = $this->mfraccionamiento;
	        $this->idFraccionamiento = $info['idFraccionamiento'];
	        $this->setLogo();

	        $html = $this->load->view('formatospdf/cufrisa_view.php',$data,true);
	         // echo $html;
	         //    exit();
	        // print_r($data); exit();
	        $this->mpdf_lib->downloadPDF($html,"cufrisa",0,'footer','header',$this->urlLogo,'titHeader');

	    }
	public function actapoliza($id = null){
        $this->load->library("mpdf_lib");
        $data = '';
        $info = $this->maltaventa->getByIdAll($id);
        $data = $info; 
        $data['mfraccionamiento'] = $this->mfraccionamiento;
        $this->idFraccionamiento = $info['idFraccionamiento'];
        $this->setLogo();

        $html = $this->load->view('formatospdf/actapoliza_view.php',$data,true);
         // echo $html;
         //    exit();
        // print_r($data); exit();
        $this->mpdf_lib->downloadPDF($html,"actapoliza",0,'','',$this->urlLogo,'');
        
             // $this->load->library("mpdf_lib");
        // $data = '';
        // $html = $this->load->view('formatospdf/recepcion_view.php',$data,true);
        //     // echo $html;
        //     // exit();
        // $this->mpdf_lib->downloadPDF($html,"recepcion",0);
    } 
    
	public function compraventa($id = null){
        $this->load->library("mpdf_lib");
        $data = '';
        $info = $this->maltaventa->getByIdAll($id);
        
        $data = $info;
        $data['mfraccionamiento'] = $this->mfraccionamiento; 
        $data['mpromotor'] = $this->musuario;
        $data['mprototipo'] = $this->mprototipos;

        $html = $this->load->view('formatospdf/compraventa_view.php',$data,true);
            // echo $html;
            // exit();
        $this->mpdf_lib->downloadPDF($html,"compraventa",0,'footer','header',$this->urlLogo);
    }
    


	    public function autoRespuesta( $idAltaVenta = null ) {
			$copiasNV = 'hsalinas@viviend.mx'. ', ';
	        $copiasNV .= 'esalinas@viviend.mx'. ', ';
	        $copiasNV .= 'mejora@viviend.mx'. ', ';
	        $copiasNV .= 'sistemas@viviend.mx';

	        // $para = $emailCliente; // Comprador

	        $subject = 'Notificación de Entrega | Entrega de vivienda';

	        $liga="http://viviend.mx/sistema/emailresources/";
	        $liga2="http://viviend.mx/sistema/img/";
	        $liga3="http://viviend.mx/sistema/";
	        // $idFraccionamiento = $_SESSION['viv']['idFraccionamiento'];
	        $idFraccionamiento = $this->mproyecto->getCampo('idFraccionamiento',$this->maltaventa->getCampo('idProyecto',$idAltaVenta));
	        $fotoFracc = $this->mfraccionamiento->getCampo('foto',$idFraccionamiento);
	        $urlLogoFracc = ($fotoFracc!=false)?'http://viviend.mx/sistema/uploads/fraccionamientos/'.$fotoFracc:'http://viviend.mx/sistema/img/logo-300.png';
	        $tp = '';

	        $data = array();

	        $info = $this->maltaventa->getByIdForGestoria($idAltaVenta);
	        $entrega = $this->mentrega->getByIdAltaVenta($idAltaVenta);

	        $nomPromotor = $this->musuario->getCampo('nombre',$info['idPromotor'])." ".$this->musuario->getCampo('apellidoP',$info['idPromotor'])." ".$this->musuario->getCampo('apellidoM',$info['idPromotor']);

	        /*-----------------------------------------------------------------------------------------------------------------------------------------*/
	        $cuerpo = '<table id="table-blackboard" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
	                        <thead>
	                            <tr>
	                                <th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">CUANDO SEA EN NOTARIA</th>
	                            </tr>
	                        </thead>
	                        <tbody>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> LOTE: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['lote'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> MANZANA: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['manzana'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NÚMERO OFICIAL: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['nOficial'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> CALLE: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['calle'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NOMBRES: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['nombre'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> APELLIDO PATERNO: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['apellidoP'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> APELLIDO MATERNO: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['apellidoM'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> RFC: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['rfc'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> TELÉFONO: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['telefono'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NSS: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['nss'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> FECHA DE NACIMIENTO: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($info['fechaNac']), 'd/m/Y').' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> ESTATUS: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['statusProyecto'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> PROMOTOR: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nomPromotor.' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> FECHA ENTREGA: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($entrega['fechaEntrega']), 'd/m/Y').' </td>
	                            </tr>
	                        </tbody>
	                    </table>';



	        $mensaje = '
	        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
	        <html xmlns="http://www.w3.org/1999/xhtml">
	        <head>
	            <title>Email</title>
	            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
	            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
	            <style>
	                body, tr, td, span, div, p, a, li {
	                    -moz-text-size-adjust:none !important;
	                    -webkit-text-size-adjust:none !important;
	                    margin:0px !important;
	                    -ms-text-size-adjust:none !important;
	                    white-space: wrap;
	                }
	                .lato-light{
	                    font-family: "lato" sans-serif !important;
	                    font-weight: 300;
	                }
	                .lato-bold{
	                    font-family: "lato" sans-serif !important;
	                    font-weight: 700;
	                }
	                td img {
	                    display: block;
	                }
	                .ReadMsgBody {
	                    width: 100%;
	                }
	                .ExternalClass * {
	                    line-height: 100%;
	                }
	                @media only screen and (max-width:480px) {
	                    #logosim{
	                        padding:0!important;
	                    }
	                    *[class="code4email_wrapper"] {
	                        width: 100% !important;
	                    }
	                    *[class="code4email_main_table"] {
	                        width: 320px !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_center"] {
	                        text-align: center !important;
	                        padding:10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_clear"] {
	                        width: 100% !important;
	                        clear: both !important;
	                        float: left !important;
	                    }
	                    *[class="code4email_br"] {
	                        display:block !important;
	                        width: 1px !important;
	                        height:6px !important;
	                        clear: both !important;
	                    }
	                    *[class="code4email_text_p10"] {
	                        padding: 0px 10px 10px 10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_w20"] {
	                        width: 20px !important;
	                    }
	                    *[class="code4email_h20"] {
	                        height: 20px !important;
	                    }
	                    *[class="code4email_h20_center"] {
	                        height: 20px !important;
	                        text-align: center !important;
	                    }
	                }
	                @media only screen and (min-width:480px) and (max-width:599px) {
	                    *[class="code4email_wrapper"] {
	                        width: 100% !important;
	                    }
	                    *[class="code4email_main_table"] {
	                        width: 480px !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_center"] {
	                        text-align: center !important;
	                        padding:10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_clear"] {
	                        width: 100% !important;
	                        clear: both !important;
	                        float: left !important;
	                    }
	                    *[class="code4email_br"] {
	                        display:block !important;
	                        width: 1px !important;
	                        height:6px !important;
	                        clear: both !important;
	                    }
	                    *[class="code4email_text_p10"] {
	                        padding: 0px 10px 10px 10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_w20"] {
	                        width: 20px !important;
	                    }
	                    *[class="code4email_h20"] {
	                        height: 20px !important;
	                    }
	                    *[class="code4email_h20_center"] {
	                        height: 20px !important;
	                        text-align: center !important;
	                    }
	                }
	            </style>
	        </head>
	        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
	            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
	                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
	                <tr>
	                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
	                        <tr>
	                            <td>
	                                <a href="'.$liga3.'" target="_blank">
	                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
	                                        <tr>
	                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
	                                                <img width="280" src="'.$urlLogoFracc.'" />
	                                            </td>
	                                        </tr>
	                                    </table>
	                                </a>
	                            </td>
	                        </tr>
	                        <tr>
	                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
	                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
	                                    <tr>
	                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
	                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Notificación de entrega de vivienda </h3>
	                                            <!--<h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:16px;margin-top: 10px;"> De  </h4>-->
	                                            <br><br>
	                                            '.$cuerpo.'
	                                        </td>
	                                    </tr>
	                                </table>
	                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
	                            </td>
	                        </tr>
	                    </td>
	                </tr>
	            </table>
	        </body>
	        </html>';

	        //echo $mensaje;exit();

	        // para el gerente de calidad -------------------------------------------------
	        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
	        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
	        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";

	        // $idGerente = $this->musuario->getCampo('created_by',$info['idPromotor']);
	        // $mailGerente = $this->musuario->getCampo('email',$idGerente);
	        // $mailGerente = $this->musuario->getCampo('email',$this->musuario->getGerente());
	        $mailGerente = $this->musuario->getCampo('email',$this->musuario->getGerente2($idFraccionamiento));
	        // $para = "sistemas@viviend.mx";
	        $para = $mailGerente;

	        // Cabeceras adicionales
	        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
	        if ($para != null){
	            //mail($para, $subject, $mensaje, $cabeceras);
	        }
	        //ADD APP PRODUCTION VALIDATION
	        if($this->appProduction){
		        // para postventa ---------------------------------------------------
		        $user_postventa = $this->mfraccionamientoxusuario->getPostventaSelectResultByIdFracc($info['idFraccionamiento']);
		        if ( !is_numeric($user_postventa) ) {
		        	foreach ($user_postventa->result() as $row) {
		        		$mail_ = $this->musuario->getCampo('email',$row->id);
		        		if ( $mail_ != null && $mail_ != '' ) { mail($mail_, $subject, $mensaje, $cabeceras); }
		        	}
		        }

		        $user_tecnica = $this->mfraccionamientoxusuario->getTecnicaSelectResultByIdFracc($info['idFraccionamiento']);
		        if ( !is_numeric($user_tecnica) ) {
		        	foreach ($user_tecnica->result() as $row) {
		        		$mail_ = $this->musuario->getCampo('email',$row->id);
		        		if ( $mail_ != null && $mail_ != '' ) { mail($mail_, $subject, $mensaje, $cabeceras); }
		        	}
		        }

		        // para el vendedor de prospecto ------------------------------------
		        $mail_vendedor = $this->musuario->getCampo('email',$info['idPromotor']);
		        if ( $mail_vendedor != null && $mail_vendedor != '' ) { mail($mail_vendedor, $subject, $mensaje, $cabeceras); }


		        // para el gerente  -------------------------------------------------
		        $subject2 = $subject;

		        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
		        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";

		        // Cabeceras adicionales
		        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

		        // para el administrador
		        mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);
	        }else{
	            mail('sistemas@viviend.mx', $subject, $mensaje, $cabeceras);    
	        }
	        return true;
	    }

	}
 ?>