<?php
	defined('BASEPATH') OR exit('No direct script access allowed');
	date_default_timezone_set('America/Mexico_City');
	class Encuesta_postventa extends MX_Controller {

		public $data,$vParameters,$mainView,$fv;

		public function __construct() {
			/*$this->nsession = $this->config->item('nsession');*/
			// if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login'); // Validate session
			$this->fv = 'encuesta_postventa'; // form validation variable
			$this->mainView = 'encuesta_postventa';
			$this->data['fjs'] = '';
			$this->data['js'] = '';
			$this->data['css'] = '';
			// Tools
			$this->load->helper(array('tools','numeros','url','form','date','text','security'));
			// Modelos
			$this->load->model(array('mencuestavivienda', 'maltaventa', 'musuario', 'mproyecto', 'mprospecto','mfraccionamiento', 'mentrega'));

			valSession("ventas",$this->fv);
		}

		public function index($id) {
			$qAltaVenta = $this->maltaventa->getById($id);

			if( !is_numeric($qAltaVenta)){
				$qEntrega = $this->mentrega->getByIdAltaVenta($qAltaVenta['id']);
				if( !is_numeric($qEntrega) ){
					$data = $qAltaVenta;
				}else{
					$data['id'] = $id;
					$data['statusEncuesta'] = 1;
				}
			}else {
				$data['id'] = $id;
				$data['statusEncuesta'] = 1;
			}
			$data['nomCliente'] = $this->mprospecto->getCampo('nombre',$qAltaVenta['id']);
			$data['apaterno'] = $this->mprospecto->getCampo('apellidoP',$qAltaVenta['id']);
			$data['amaterno'] = $this->mprospecto->getCampo('apellidoM',$qAltaVenta['id']);
			//Obtener Fraccionamiento
			$idProyecto=$this->maltaventa->getCampo('idProyecto',$qAltaVenta['id']);
			$data['lote']=$this->mproyecto->getCampo('lote',$idProyecto);
			$data['manzana']=$this->mproyecto->getCampo('manzana',$idProyecto);
			$idFraccionamiento=$this->mproyecto->getCampo('idFraccionamiento',$idProyecto);
			$data['fraccionamiento']=$this->mfraccionamiento->getCampo('titulo',$idFraccionamiento);
			
			$this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
			$this->load->view('templates/encuesta_postventa_template.php',$this->data);
		}

		public function guardar() {
			$datitos['msg'] = 'error';
			if( isset($_POST['id']) && isset($_POST['preguntas'])){
				$pData['idAltaVenta'] = $_POST['id'];
				$pData['fecha'] = date('Y-m-d H:i:s');
				foreach ($_POST['preguntas'] as $preguntas) {
					if( isset( $preguntas['C'] ) && count( $preguntas['C'] ) > 0 ){
						if($preguntas['C'][$preguntas['UC'] - 1][1] == 'S'){
							$extra = ($preguntas['F'] == 'nosotros' )? 'Otro' : 'Why';
							$pData[ $preguntas['F'] . $extra ] = $preguntas['W'];
						}
					}
					$pData[$preguntas['F']] = $preguntas['UC'];
				}
				$id = $this->mencuestavivienda->insertar($pData);
				$aData["statusEncuesta"] = 1;
				$idAV = $this->maltaventa->actualizar($aData, $_POST['id']);
				$datitos['msg'] = '';
			}
			echo json_encode($datitos);
		}
} ?>