<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
date_default_timezone_set('America/Mexico_City');
class Cronjob extends MX_Controller {
    public $data,$vParameters,$mainView,$fv,$ret, $urlSendWhatsapp, $keyTest, $keyProduction, $appProduction, $keyActive, $f;

    public function __construct() {
        // Modelos
        $this->load->library("curl");
        $this->load->model(array('mtasks','mlogs_task','malmacenes','mproveedor','mordencompra',
        'mdetalleorden','mmateriales','mempresas', 'mlogsws','mcompra','mrecepcion','mdetallecompra','mdetallerecepcion','mclaves_articulos'));
        $this->port=$this->config->item('portmicro');
        ini_set('max_execution_time', 0);
        $this->baseLink = $this->config->item('baseLink');
        $this->baseLinkSystem = $this->config->item('baseLinkSystem');
        $this->urlSendWhatsapp = 'https://che-ek.com/api/ws';
        //$this->keyTest = 'ang8sw4ezm3iw8nave2s';
        $this->keyTest = '3b947a0da97d6ee317ff5f6d26665e14';
        $this->keyProduction = '3b947a0da97d6ee317ff5f6d26665e14';
        $this->appProduction = $this->config->item('appProduction');
        $this->keyActive = ($this->appProduction) ? $this->keyProduction : $this->keyTest;

        $this->data['fotos_www'] = $this->config->item('base_www').'/arranque/';

        $this->load->library('phantomcapture', array());
        //Ocultando warnings
        //error_reporting(E_ALL & ~E_WARNING & ~E_NOTICE);
    }

    public function index(){

        $config['url'] = 'http://s1.navegantes.mx/sistema/cronjob/notificaciones_etapas/1853/2/1'; //set url
		$config['filename'] = 'prueba.png'; //set file name
		$config['width'] = 600; // set width
		$config['height'] = 1100; // set height
		$config['diruploads'] = $this->data['fotos_www']; // set dir uploads
		// $config['clipwidth'] = 1024; // optional
		// $config['clipheight'] = 768; // optional

        $this->phantomcapture->initialize($config);
		$valid = $this->phantomcapture->captureit();

    }

    public function testWs($tel="9851045678",$message="test"){
        $this->db->query("UPDATE material mate SET mate.idArranque=(SELECT id FROM arranque arr WHERE FIND_IN_SET(mate.idPaquete,arr.idPaquetes))");
        $data['to'] = '521'.$tel;
        $data['message2'] = $message;
        $data['key'] = $this->keyActive;
        $this->sendWhatsapp($data);
    }

    public function tasks(){
        $logs_task=array();
        $log=array();
        $tasks=$this->mtasks->getByStatus(0);
        if(!is_numeric($tasks)){
            foreach ($tasks->result() as $row){
                switch ($row->tipo) {
                    case 1: //Arranque ejecutar una sola vez - aqui se envia el correo y whatsapp
                        $arrayLotes = $this->getLotes($row->idItem);
                        $count = count($arrayLotes);
                        $countFinish = 0;
                        $mensaje = '';
                        $error = '';
                        $status = 0;
                        foreach($arrayLotes as $key => $value){
                            $pData2['idProyecto'] = $value['idProyecto'];
                            $pData2['tipo'] = 'arranque';

                            $insert = $this->insertLogsNotifications($pData2);
                            if($insert){
                                $countFinish++;
                            }
                        }

                        if($count == $countFinish){
                            $mensaje = 'Se ejecutó el envio de notificaciones de arranque exitosamente - '.date("Y-m-d").':'.date("H:i");
                            $status = 1;
                            $error = '';
                        }/*else{
                            $mensaje = 'Ocurrio un error en el envio de notificaciones de arranque - '.date("Y-m-d").':'.date("H:i");
                            $status = 0;
                            $error = 'Error';
                        }*/


                        $log_task = array(
                            "idTask" => $row->id,
                            "mensaje" => $mensaje,
                            "error" => $error,
                            "status_ws" => $status
                        );
                        $this->insertLogsTask($log_task);
                        break;
                    case 2: //obra negra, acabados,entrega ejecutar una vez día - aqui se envia el correo y whatsapp
                        $this->sendNotifications($row->idItem);

                        $mensaje = 'Se ejecutó el envio de notificaciones exitosamente - '.date("Y-m-d").':'.date("H:i");
                        $status = 1;
                        $error = '';

                        $log_task = array(
                            "idTask" => $row->id,
                            "mensaje" => $mensaje,
                            "error" => $error,
                            "status_ws" => $status
                        );
                        $this->insertLogsTask($log_task);
                        break;
                    case 3:
                        $this->mysqldump($row->url_func,$row->id);
                        break;
                    default:
                        break;
                }
            }
        }
    }

    function insertLogsTask($logs_task){
        if (count($logs_task)>0 && !empty($logs_task) ) {
            $this->db->insert('logs_task', $logs_task);
        }
    }

    public function addAlmacen($array){
        ini_set('max_execution_time', 300);
        $curl = curl_init();
        //INFORMACION A ENVIAR POR POST EN FORMATO JSON
        $idEmpresa=$array["un"];
        $idUsuario = $_SESSION["viv"]['id'];
        $datos=$array;
        $datos = json_encode($datos);
        $time_start = microtime(true);

        curl_setopt_array($curl, array(
            CURLOPT_PORT => $this->config->item('portmicro'),
            CURLOPT_URL => $this->config->item('dnsmicro')."AddAlmacen",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 60000,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_FOLLOWLOCATION => 1,
            CURLOPT_POSTFIELDS => $datos,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "postman-token: ab5bf890-47c6-d504-ba8f-82667b58bebd",
                'Content-Type:application/json'
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        $res['resultado'] = '';

        $json = [];
        if ($err) {
            $res['error'] = true;
            echo "CURL Error #:" . $err;
            $time_end = microtime(true);
            $time = $time_end - $time_start;
            $dataL['time'] = $time;
            $dataL['idEmpresa'] = $idEmpresa;
            $dataL['nombreTabla'] = 'almacenes';
            $dataL['funcion'] = 'AddAlmacen';
            $dataL['http_code'] = 0;
            $dataL['insertados'] = 0;
            $dataL['actualizados'] = 0;
            $dataL['totalRegistros'] = 0;
            $dataL['json'] = "CURL Error #:" . $err;
            $dataL['created'] = date("Y-m-d H:i:s");
            $dataL['updated'] = date("Y-m-d H:i:s");
            $dataL['created_by'] = $idUsuario;
            $dataL['updated_by'] = $idUsuario;
            $this->db->insert('logs_ws', $dataL);
        }else{
            $res['error'] = false;
            $json = $response;
            // Comprueba el código de estado HTTP
            if (!curl_errno($curl)) {
              switch ($http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE)) {
                case 200:
                    $json = json_decode($json, true);
                    if($json['result']){
                        $res['responseObject'] = true;
                        $res['resultado'] = $json['object_result'];
                        $res['error_message'] = $json['error_message'];
                    }else{
                        $res['responseObject'] = false;
                        $res['error_message'] = $json['error_message'];
                    }
                    $time_end = microtime(true);
                    $time = $time_end - $time_start;
                    $dataL['time'] = $time;
                    $dataL['idEmpresa'] = $idEmpresa;
                    $dataL['nombreTabla'] = 'almacenes';
                    $dataL['funcion'] = 'AddAlmacen';
                    $dataL['http_code'] = 0;
                    $dataL['insertados'] = ($json['result'])? 1 : 0;
                    $dataL['actualizados'] = 0;
                    $dataL['totalRegistros'] = ($json['result'])? 1 : 0;
                    $json = json_encode($json);
                    $dataL['json'] = $json;
                    $dataL['created'] = date("Y-m-d H:i:s");
                    $dataL['updated'] = date("Y-m-d H:i:s");
                    $dataL['created_by'] = $idUsuario;
                    $dataL['updated_by'] = $idUsuario;
                    $this->db->insert('logs_ws', $dataL);
                    break;
                case 404:
                    echo "Not found";
                    $time_end = microtime(true);
                    $time = $time_end - $time_start;
                    $dataL['time'] = $time;
                    $dataL['idEmpresa'] = $idEmpresa;
                    $dataL['nombreTabla'] = 'almacenes';
                    $dataL['funcion'] = 'AddAlmacen';
                    $dataL['http_code'] = 0;
                    $dataL['insertados'] = 0;
                    $dataL['actualizados'] = 0;
                    $dataL['totalRegistros'] = 0;
                    $dataL['json'] = $json;
                    $dataL['created'] = date("Y-m-d H:i:s");
                    $dataL['updated'] = date("Y-m-d H:i:s");
                    $dataL['created_by'] = $idUsuario;
                    $dataL['updated_by'] = $idUsuario;
                    $this->db->insert('logs_ws', $dataL);
                    break;
                default:
                    echo 'Unexpected HTTP code: ', $http_code, "\n";
                    $time_end = microtime(true);
                    $time = $time_end - $time_start;
                    $dataL['time'] = $time;
                    $dataL['idEmpresa'] = $idEmpresa;
                    $dataL['nombreTabla'] = 'almacenes';
                    $dataL['funcion'] = 'AddAlmacen';
                    $dataL['http_code'] = 0;
                    $dataL['insertados'] = 0;
                    $dataL['actualizados'] = 0;
                    $dataL['totalRegistros'] = 0;
                    $dataL['json'] = $json;
                    $dataL['created'] = date("Y-m-d H:i:s");
                    $dataL['updated'] = date("Y-m-d H:i:s");
                    $dataL['created_by'] = $idUsuario;
                    $dataL['updated_by'] = $idUsuario;
                    $this->db->insert('logs_ws', $dataL);
                    break;
              }
            }
        }
        curl_close($curl);

        return $res;
    }

    public function mysqldump($url,$idTask){
        $headers = array("Content-Type: multipart/form-data");
        $datos['flag'] = 0;
        $curl = curl_init();
        curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $datos,
        CURLOPT_HTTPHEADER => $headers,
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        $res=json_decode($response);
        print_r($res);
        $log_task = array(
            "idTask" => $idTask,
            "mensaje" => $res->message,
            "error" => $res->errors->error,
            "status_ws" => $res->status
        );
        $this->insertLogsTask($log_task);
    }

    public function getAlmacenes($idEmpresa=0){
        $curl = curl_init();
        //INFORMACION A ENVIAR POR POST EN FORMATO JSON
        $datos = json_encode(array("un" => $idEmpresa));
        $time_start = microtime(true);

        curl_setopt_array($curl, array(
            CURLOPT_PORT => $this->port,
            CURLOPT_URL => $this->config->item('dnsmicro')."getAlmacenes",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30000,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_FOLLOWLOCATION => 1,
            CURLOPT_POSTFIELDS => $datos,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "postman-token: ab5bf890-47c6-d504-ba8f-82667b58bebd",
                'Content-Type:application/json'
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);

        $json = [];
        if ($err) {
            echo "CURL Error #:" . $err;
            $time_end = microtime(true);
            $time = $time_end - $time_start;
            $dataL['time'] = $time;
            $dataL['idEmpresa'] = $idEmpresa;
            $dataL['nombreTabla'] = 'almacenes';
            $dataL['funcion'] = 'getAlmacenes';
            $dataL['http_code'] = 0;
            $dataL['insertados'] = 0;
            $dataL['actualizados'] = 0;
            $dataL['totalRegistros'] = 0;
            $dataL['json'] = "CURL Error #:" . $err;
            $dataL['created'] = date("Y-m-d H:i:s");
            $dataL['updated'] = date("Y-m-d H:i:s");
            $this->db->insert('logs_ws', $dataL);
        }else{
            $json = $response;
            // Comprueba el código de estado HTTP
            if (!curl_errno($curl)) {
                switch ($http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE)) {
                    case 200:
                        $nInsert=0;
                        $nUpdate=0;
                        $nTotal=0;

                            $json = json_decode($json);
                            foreach ($json->object_result as $row){
                                foreach ($row as $key => $val){
                                    switch ($key) {
                                        default:
                                            $data[$key]=$val;
                                    }
                                }
                                $data['idEmpresa']=$idEmpresa;
                                if($this->malmacenes->valInsert($row->id,$idEmpresa)){
                                    $this->malmacenes->insertar($data);
                                    $nInsert++;
                                }else if($this->malmacenes->valUpdate($row->id,$data)){
                                    $this->malmacenes->actualizar($data,$row->id);
                                    $nUpdate++;
                                }
                                $nTotal++;
                            }
                        curl_close($curl);
                        echo "Insertados: ".$nInsert." <br> ";
                        echo "Actualizados: ".$nUpdate." <br> ";
                        echo "Total de registros: ".$nTotal." <br> ";
                        unset($json->object_result);
                        $json = json_encode($json);
                        $time_end = microtime(true);
                        $time = $time_end - $time_start;
                        $dataL['time'] = $time;
                        $dataL['idEmpresa'] = $idEmpresa;
                        $dataL['nombreTabla'] = 'almacenes';
                        $dataL['funcion'] = 'getAlmacenes';
                        $dataL['http_code'] = $http_code;
                        $dataL['insertados'] = $nInsert;
                        $dataL['actualizados'] = $nUpdate;
                        $dataL['totalRegistros'] = $nTotal;
                        $dataL['json'] = $json;
                        $dataL['created'] = date("Y-m-d H:i:s");
                        $dataL['updated'] = date("Y-m-d H:i:s");
                        $this->db->insert('logs_ws', $dataL);
                        break;
                    case 404:
                        echo "Not found";
                        $json = json_decode($json);
                        unset($json->object_result);
                        $json = json_encode($json);
                        $time_end = microtime(true);
                        $time = $time_end - $time_start;
                        $dataL['time'] = $time;
                        $dataL['idEmpresa'] = $idEmpresa;
                        $dataL['nombreTabla'] = 'almacenes';
                        $dataL['funcion'] = 'getAlmacenes';
                        $dataL['http_code'] = $http_code;
                        $dataL['insertados'] = 0;
                        $dataL['actualizados'] = 0;
                        $dataL['totalRegistros'] = 0;
                        $dataL['json'] = $json;
                        $dataL['created'] = date("Y-m-d H:i:s");
                        $dataL['updated'] = date("Y-m-d H:i:s");
                        $this->db->insert('logs_ws', $dataL);
                        break;
                    default:
                        echo 'Unexpected HTTP code: ', $http_code, "\n";
                        $json = json_decode($json);
                        unset($json->object_result);
                        $time_end = microtime(true);
                        $time = $time_end - $time_start;
                        $dataL['time'] = $time;
                        $json = json_encode($json);
                        $dataL['idEmpresa'] = $idEmpresa;
                        $dataL['nombreTabla'] = 'almacenes';
                        $dataL['funcion'] = 'getAlmacenes';
                        $dataL['http_code'] = $http_code;
                        $dataL['insertados'] = 0;
                        $dataL['actualizados'] = 0;
                        $dataL['totalRegistros'] = 0;
                        $dataL['json'] = $json;
                        $dataL['created'] = date("Y-m-d H:i:s");
                        $dataL['updated'] = date("Y-m-d H:i:s");
                        $this->db->insert('logs_ws', $dataL);
                        break;
                }
            }
        }
    }

    public function getProveedores($idEmpresa=0){
        $curl = curl_init();
        //INFORMACION A ENVIAR POR POST EN FORMATO JSON
        $datos = json_encode(array("un" => $idEmpresa));
        $time_start = microtime(true);

        curl_setopt_array($curl, array(
            CURLOPT_PORT => $this->port,
            CURLOPT_URL => $this->config->item('dnsmicro')."GetProveedores",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30000,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_FOLLOWLOCATION => 1,
            CURLOPT_POSTFIELDS => $datos,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "postman-token: ab5bf890-47c6-d504-ba8f-82667b58bebd",
                'Content-Type:application/json'
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        $res['status'] = false;

        $json = [];
        if ($err) {
            echo "CURL Error #:" . $err;
            $time_end = microtime(true);
            $time = $time_end - $time_start;
            $dataL['time'] = $time;
            $dataL['idEmpresa'] = $idEmpresa;
            $dataL['nombreTabla'] = 'proveedores';
            $dataL['funcion'] = 'GetProveedores';
            $dataL['http_code'] = 0;
            $dataL['insertados'] = 0;
            $dataL['actualizados'] = 0;
            $dataL['totalRegistros'] = 0;
            $dataL['json'] = "CURL Error #:" . $err;
            $dataL['created'] = date("Y-m-d H:i:s");
            $dataL['updated'] = date("Y-m-d H:i:s");
            $this->db->insert('logs_ws', $dataL);
        }else{
            $json = $response;
            // Comprueba el código de estado HTTP
            if (!curl_errno($curl)) {
                switch ($http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE)) {
                    case 200:
                        $nInsert=0;
                        $nUpdate=0;
                        $nTotal=0;

                        $json = json_decode($json);
                            foreach ($json->object_result as $row) {
                                foreach ($row as $key => $val){
                                    switch ($key) {
                                        default:
                                            $data[$key]=$val;
                                    }
                                }
                                $data['idEmpresa']=$idEmpresa;
                                if($this->mproveedor->valInsert($data["id"],$idEmpresa)){
                                    $this->mproveedor->insertar($data);
                                    $nInsert++;
                                }else if($this->mproveedor->valUpdate($row->id,$data)){
                                    $this->mproveedor->actualizar($data,$data["id"]);
                                    $nUpdate++;
                                }
                                $nTotal++;
                            }

                        curl_close($curl);
                        echo "Insertados: ".$nInsert." <br> ";
                        echo "Actualizados: ".$nUpdate." <br> ";
                        echo "Total de registros: ".$nTotal." <br> ";
                        unset($json->object_result);
                        $json = json_encode($json);
                        $time_end = microtime(true);
                        $time = $time_end - $time_start;
                        $dataL['time'] = $time;
                        $dataL['idEmpresa'] = $idEmpresa;
                        $dataL['nombreTabla'] = 'proveedores';
                        $dataL['funcion'] = 'GetProveedores';
                        $dataL['http_code'] = $http_code;
                        $dataL['insertados'] = $nInsert;
                        $dataL['actualizados'] = $nUpdate;
                        $dataL['totalRegistros'] = $nTotal;
                        $dataL['json'] = $json;
                        $dataL['created'] = date("Y-m-d H:i:s");
                        $dataL['updated'] = date("Y-m-d H:i:s");
                        $this->db->insert('logs_ws', $dataL);
                        break;
                    case 404:
                        echo "Not found";
                        $json = json_decode($json);
                        unset($json->object_result);
                        $json = json_encode($json);
                        $time_end = microtime(true);
                        $time = $time_end - $time_start;
                        $dataL['time'] = $time;
                        $dataL['idEmpresa'] = $idEmpresa;
                        $dataL['nombreTabla'] = 'proveedores';
                        $dataL['funcion'] = 'GetProveedores';
                        $dataL['http_code'] = $http_code;
                        $dataL['insertados'] = 0;
                        $dataL['actualizados'] = 0;
                        $dataL['totalRegistros'] = 0;
                        $dataL['json'] = $json;
                        $dataL['created'] = date("Y-m-d H:i:s");
                        $dataL['updated'] = date("Y-m-d H:i:s");
                        $this->db->insert('logs_ws', $dataL);
                        break;
                    default:
                        echo 'Unexpected HTTP code: ', $http_code, "\n";
                        $json = json_decode($json);
                        unset($json->object_result);
                        $json = json_encode($json);
                        $time_end = microtime(true);
                        $time = $time_end - $time_start;
                        $dataL['time'] = $time;
                        $dataL['idEmpresa'] = $idEmpresa;
                        $dataL['nombreTabla'] = 'proveedores';
                        $dataL['funcion'] = 'GetProveedores';
                        $dataL['http_code'] = $http_code;
                        $dataL['insertados'] = 0;
                        $dataL['actualizados'] = 0;
                        $dataL['totalRegistros'] = 0;
                        $dataL['json'] = $json;
                        $dataL['created'] = date("Y-m-d H:i:s");
                        $dataL['updated'] = date("Y-m-d H:i:s");
                        $this->db->insert('logs_ws', $dataL);
                        break;
                }
            }
        }
        echo json_encode($res);
    }

    public function getOrdenesCompra($idEmpresa=0){
        $curl = curl_init();
        //INFORMACION A ENVIAR POR POST EN FORMATO JSON
        $datos=array('un' => $idEmpresa, 'bundle' => array('estatus' => 0));
        $datos = json_encode($datos);
        $time_start = microtime(true);

        curl_setopt_array($curl, array(
            CURLOPT_PORT => $this->port,
            CURLOPT_URL => $this->config->item('dnsmicro')."GetOrdenesCompra",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 3600,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_FOLLOWLOCATION => 1,
            CURLOPT_POSTFIELDS => $datos,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "postman-token: ab5bf890-47c6-d504-ba8f-82667b58bebd",
                'Content-Type:application/json'
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);

        $json = [];
        if ($err) {
            echo "CURL Error #:" . $err;
            $time_end = microtime(true);
            $time = $time_end - $time_start;
            $dataL['time'] = $time;
            $dataL['idEmpresa'] = $idEmpresa;
            $dataL['nombreTabla'] = 'orden_compra';
            $dataL['funcion'] = 'GetOrdenesCompra';
            $dataL['http_code'] = 0;
            $dataL['insertados'] = 0;
            $dataL['actualizados'] = 0;
            $dataL['totalRegistros'] = 0;
            $dataL['json'] = "CURL Error #:" . $err;
            $dataL['created'] = date("Y-m-d H:i:s");
            $dataL['updated'] = date("Y-m-d H:i:s");
            $this->db->insert('logs_ws', $dataL);
        }else{
            $json = $response;
            // Comprueba el código de estado HTTP
            if (!curl_errno($curl)) {
                switch ($http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE)) {
                    case 200:
                        //Contadores de prueba
                        $nInsert=0;
                        $nUpdate=0;
                        $nInsert2=0;
                        $nUpdate2=0;
                        $nTotal=0;
                        $nFolios=0;
                        $data=[];
                        //Objeto de respuesta
                        $json = json_decode($json);
                        //Recorre objeto stdClass
                        foreach ($json->object_result as $row) {
                            //Actualizacion por folio
                            $oc=$this->mordencompra->updateIdByFolio($idEmpresa,$row->id,$row->folio);
                            //$ordencompra=$this->mordencompra->getById($row->id);
                            $idAlmacen=$row->id_almacen;
                            $almacen=$this->malmacenes->getByIdEmpresa($idAlmacen,$idEmpresa);
                            if(!is_numeric($almacen)){
                                $idPaquete=$almacen->idPaquete;
                                ($oc) ? $nFolios++ : false;
                                //Recorre ordenes de compra(orden_compra)
                                foreach ($row as $key => $val) {
                                    switch ($key) {
                                        case 'lista_articulos':
                                            $ids="";
                                            //Recorre listado de articulos(detalle_orden)
                                            foreach ($val as $row2) {
                                                $i=0;
                                                foreach ($row2 as $key2 => $val2){
                                                    switch ($key2) {
                                                        case "id":
                                                            $ids.=($i==0) ? $val2 : ",".$val2;
                                                            $i++;
                                                            $data2[$key2]=$val2;
                                                            break;
                                                        default:
                                                            $data2[$key2]=$val2;
                                                            break;
                                                    }
                                                }
                                                //Validaciones de sincronizacion de detalle orden
                                                $data2['idEmpresa']=$idEmpresa;
                                                $data2['idPaquete']=$idPaquete;
                                                if($this->mdetalleorden->valInsert($data2['id'])){
                                                    $this->mdetalleorden->insertar($data2);
                                                    $nInsert2++;
                                                }else if($this->mdetalleorden->valUpdate($data2['id'],$data2)){
                                                    $this->mdetalleorden->actualizar($data2,$data2['id']);
                                                    $nUpdate2++;
                                                }
                                                //Elimina articulos existentes localmente pero no en Microsip
                                                if($ids != ""){
                                                    echo $this->db->query("DELETE FROM detalle_orden WHERE id_orden_compra=$row->id AND idEmpresa=$idEmpresa AND id NOT IN ($ids)");
                                                }
                                            }
                                            break;
                                        default:
                                        $data[$key]=$val;
                                    }
                                }
                                //Validaciones de sincronizacion de ordenes de compra
                                $data['idEmpresa']=$idEmpresa;
                                $data['idPaquete']=$idPaquete;
                                if($this->mordencompra->valInsert($data['id'],$idEmpresa)){
                                    $this->mordencompra->insertar($data);
                                    $nInsert++;
                                }else if($this->mordencompra->valUpdate($data['id'],$data)){
                                    $this->mordencompra->actualizar($data,$data['id']);
                                    $nUpdate++;
                                }
                                $nTotal++;
                            }
                        }
                        curl_close($curl);
                        echo "Insertados: ".$nInsert." <br> ";
                        echo "Actualizados: ".$nUpdate." <br> ";
                        echo "Folios: ".$nFolios." <br> ";
                        echo "Total de registros: ".$nTotal." <br> ";
                        unset($json->object_result);
                        $json = json_encode($json);
                        $time_end = microtime(true);
                        $time = $time_end - $time_start;
                        $dataL['time'] = $time;
                        $dataL['idEmpresa'] = $idEmpresa;
                        $dataL['nombreTabla'] = 'orden_compra';
                        $dataL['funcion'] = 'GetOrdenesCompra';
                        $dataL['http_code'] = $http_code;
                        $dataL['insertados'] = $nInsert;
                        $dataL['actualizados'] = $nUpdate;
                        $dataL['totalRegistros'] = $nTotal;
                        $dataL['json'] = $json;
                        $dataL['created'] = date("Y-m-d H:i:s");
                        $dataL['updated'] = date("Y-m-d H:i:s");
                        $this->db->insert('logs_ws', $dataL);
                        break;
                    case 404:
                        echo "Not found";
                        $json = json_decode($json);
                        unset($json->object_result);
                        $json = json_encode($json);
                        $time_end = microtime(true);
                        $time = $time_end - $time_start;
                        $dataL['time'] = $time;
                        $dataL['idEmpresa'] = $idEmpresa;
                        $dataL['nombreTabla'] = 'orden_compra';
                        $dataL['funcion'] = 'GetOrdenesCompra';
                        $dataL['http_code'] = $http_code;
                        $dataL['insertados'] = 0;
                        $dataL['actualizados'] = 0;
                        $dataL['totalRegistros'] = 0;
                        $dataL['json'] = $json;
                        $dataL['created'] = date("Y-m-d H:i:s");
                        $dataL['updated'] = date("Y-m-d H:i:s");
                        $this->db->insert('logs_ws', $dataL);
                        break;
                    default:
                        echo 'Unexpected HTTP code: ', $http_code, "\n";
                        $json = json_decode($json);
                        unset($json->object_result);
                        $json = json_encode($json);
                        $time_end = microtime(true);
                        $time = $time_end - $time_start;
                        $dataL['time'] = $time;
                        $dataL['idEmpresa'] = $idEmpresa;
                        $dataL['nombreTabla'] = 'orden_compra';
                        $dataL['funcion'] = 'GetOrdenesCompra';
                        $dataL['http_code'] = $http_code;
                        $dataL['insertados'] = 0;
                        $dataL['actualizados'] = 0;
                        $dataL['totalRegistros'] = 0;
                        $dataL['json'] = $json;
                        $dataL['created'] = date("Y-m-d H:i:s");
                        $dataL['updated'] = date("Y-m-d H:i:s");
                        $this->db->insert('logs_ws', $dataL);
                        break;
                }
            }
        }
    }

    public function getArticulos($idEmpresa=0){
        $curl = curl_init();
        //INFORMACION A ENVIAR POR POST EN FORMATO JSON
        $datos=array('un' => $idEmpresa);
        $datos = json_encode($datos);
        $time_start = microtime(true);

        curl_setopt_array($curl, array(
            CURLOPT_PORT => $this->port,
            CURLOPT_URL => $this->config->item('dnsmicro')."GetArticulos",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 3600,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_FOLLOWLOCATION => 1,
            CURLOPT_POSTFIELDS => $datos,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "postman-token: ab5bf890-47c6-d504-ba8f-82667b58bebd",
                'Content-Type:application/json'
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);

        $json = [];
        if ($err) {
            echo "CURL Error #:" . $err;
            $time_end = microtime(true);
            $time = $time_end - $time_start;
            $dataL['time'] = $time;
            $dataL['idEmpresa'] = $idEmpresa;
            $dataL['nombreTabla'] = 'materiales';
            $dataL['funcion'] = 'GetArticulos';
            $dataL['http_code'] = 0;
            $dataL['insertados'] = 0;
            $dataL['actualizados'] = 0;
            $dataL['totalRegistros'] = 0;
            $dataL['json'] = "CURL Error #:" . $err;
            $dataL['created'] = date("Y-m-d H:i:s");
            $dataL['updated'] = date("Y-m-d H:i:s");
            $this->db->insert('logs_ws', $dataL);
        }else{
            $json = $response;
            // Comprueba el código de estado HTTP
            if (!curl_errno($curl)) {
                switch ($http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE)) {
                    case 200:
                        //Contadores de prueba
                        $nInsert=0;
                        $nUpdate=0;
                        $nTotal=0;
                        $data=[];
                        //Objeto de respuesta
                        $json = json_decode($json);
                        $json = $json->result;
                        //Recorre objeto stdClass
                        if(isset($json->object_result) && !empty($json->object_result)){
                            foreach($json->object_result as $row){
                                foreach ($row as $key => $val){
                                    switch ($key) {
                                        case "claves_alternas":
                                            if(is_array($val)){
                                                if(COUNT($val)>0){
                                                    foreach ($val as $row) {
                                                        $exist=$this->mclaves_articulos->valInsert($idEmpresa,$data["id"],$row->clave);
                                                        if(is_numeric($exist)){
                                                            $this->mclaves_articulos->insertar([
                                                                "idEmpresa"=>$idEmpresa,
                                                                "idArticulo"=>$data["id"],
                                                                "clave"=>$row->clave,
                                                            ]);
                                                        }
                                                    }
                                                }
                                            }
                                            break;
                                        case "clave_primaria":
                                            $data["clave"]=$val;
                                            //prueba
                                            break;
                                        default:
                                            $data[$key]=str_replace("'","",$val);
                                    }
                                }
                                //Validaciones de sincronizacion de materiales
                                $data['idEmpresa']=$idEmpresa;
                                if($this->mmateriales->valInsert($data['id'],$idEmpresa)){
                                    $this->mmateriales->insertar($data);
                                    $nInsert++;
                                }else if($this->mmateriales->valUpdate($data['id'],$data)){
                                    $this->mmateriales->actualizar($data,$data['id']);
                                    $nUpdate++;
                                }
                                $nTotal++;
                            }
                        }
                        curl_close($curl);
                        echo "Insertados: ".$nInsert." <br> ";
                        echo "Actualizados: ".$nUpdate." <br> ";
                        echo "Total de registros: ".$nTotal." <br> ";
                        unset($json->object_result);
                        $json = json_encode($json);
                        $time_end = microtime(true);
                        $time = $time_end - $time_start;
                        $dataL['time'] = $time;
                        $dataL['idEmpresa'] = $idEmpresa;
                        $dataL['nombreTabla'] = 'materiales';
                        $dataL['funcion'] = 'GetArticulos';
                        $dataL['http_code'] = $http_code;
                        $dataL['insertados'] = $nInsert;
                        $dataL['actualizados'] = $nUpdate;
                        $dataL['totalRegistros'] = $nTotal;
                        $dataL['json'] = $json;
                        $dataL['created'] = date("Y-m-d H:i:s");
                        $dataL['updated'] = date("Y-m-d H:i:s");
                        $this->db->insert('logs_ws', $dataL);
                        break;
                    case 404:
                        echo "Not found";
                        $json = json_decode($json);
                        unset($json->object_result);
                        $json = json_encode($json);
                        $time_end = microtime(true);
                        $time = $time_end - $time_start;
                        $dataL['time'] = $time;
                        $dataL['idEmpresa'] = $idEmpresa;
                        $dataL['nombreTabla'] = 'materiales';
                        $dataL['funcion'] = 'GetArticulos';
                        $dataL['http_code'] = $http_code;
                        $dataL['insertados'] = 0;
                        $dataL['actualizados'] = 0;
                        $dataL['totalRegistros'] = 0;
                        $dataL['json'] = $json;
                        $dataL['created'] = date("Y-m-d H:i:s");
                        $dataL['updated'] = date("Y-m-d H:i:s");
                        $this->db->insert('logs_ws', $dataL);
                        break;
                    default:
                        echo 'Unexpected HTTP code: ', $http_code, "\n";
                        $json = json_decode($json);
                        unset($json->object_result);
                        $json = json_encode($json);
                        $time_end = microtime(true);
                        $time = $time_end - $time_start;
                        $dataL['time'] = $time;
                        $dataL['idEmpresa'] = $idEmpresa;
                        $dataL['nombreTabla'] = 'materiales';
                        $dataL['funcion'] = 'GetArticulos';
                        $dataL['http_code'] = $http_code;
                        $dataL['insertados'] = 0;
                        $dataL['actualizados'] = 0;
                        $dataL['totalRegistros'] = 0;
                        $dataL['json'] = $json;
                        $dataL['created'] = date("Y-m-d H:i:s");
                        $dataL['updated'] = date("Y-m-d H:i:s");
                        $this->db->insert('logs_ws', $dataL);
                        break;
                }
            }
        }
    }

    public function GetOrdenCompra($idEmpresa,$idOrden,$idPaquete,$retorno=true){
        ini_set('max_execution_time', 0);
        $curl = curl_init();
        //INFORMACION A ENVIAR POR POST EN FORMATO JSON
        $idUsuario = $_SESSION["viv"]['id'];
        $datos=array('un' => $idEmpresa, 'id_orden_compra' => $idOrden);
        $datos = json_encode($datos);
        $time_start = microtime(true);
        $almacen=$this->malmacenes->getByIdPaquete($idEmpresa,$idPaquete);
        $id_almacen=(!is_numeric($almacen)) ? $almacen->id : 0;

        curl_setopt_array($curl, array(
            CURLOPT_PORT => $this->config->item('portmicro'),
            CURLOPT_URL => $this->config->item('dnsmicro')."GetOrdenCompra",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 3600,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_FOLLOWLOCATION => 1,
            CURLOPT_POSTFIELDS => $datos,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "postman-token: ab5bf890-47c6-d504-ba8f-82667b58bebd",
                'Content-Type:application/json'
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);

        $json = [];
        if ($err) {
            echo "CURL Error #:" . $err;
            $time_end = microtime(true);
            $time = $time_end - $time_start;
            $dataL['time'] = $time;
            $dataL['idEmpresa'] = $idEmpresa;
            $dataL['nombreTabla'] = 'compra';
            $dataL['funcion'] = 'GetOrdenCompra';
            $dataL['http_code'] = 0;
            $dataL['insertados'] = 0;
            $dataL['actualizados'] = 0;
            $dataL['totalRegistros'] = 0;
            $dataL['json'] = "CURL Error #:" . $err;
            $dataL['created_by'] = $idUsuario;
            $dataL['updated_by'] = $idUsuario;
            $dataL['created'] = date("Y-m-d H:i:s");
            $dataL['updated'] = date("Y-m-d H:i:s");
            $this->db->insert('logs_ws', $dataL);
            $dataL['nombreTabla'] = 'recepcion';
            $this->db->insert('logs_ws', $dataL);
        }else{
            $json = json_decode($response);
            if(COUNT($json->object_result) > 0){
                //eliminacion de detalles
                //$this->db->query("DELETE FROM detalle_compra WHERE idEmpresa=$idEmpresa AND id_compra IN (SELECT id FROM compra WHERE idEmpresa=$idEmpresa AND idPaquete=$idPaquete AND id_orden_compra=$idOrden)");
                //$this->db->query("DELETE FROM detalle_recepcion WHERE idEmpresa=$idEmpresa AND id_recepcion IN (SELECT id FROM recepcion WHERE idEmpresa=$idEmpresa AND idPaquete=$idPaquete AND id_orden_compra=$idOrden)");
                //$this->db->query("DELETE FROM orden_compra WHERE idEmpresa=$idEmpresa AND idPaquete=$idPaquete AND id=$idOrden");
                //$this->db->query("DELETE FROM detalle_orden WHERE idEmpresa=$idEmpresa AND idPaquete=$idPaquete AND id_orden_compra=$idOrden");
                //$this->db->query("DELETE FROM compra WHERE idEmpresa=$idEmpresa AND idPaquete=$idPaquete AND id_orden_compra=$idOrden");
                //$this->db->query("DELETE FROM recepcion WHERE idEmpresa=$idEmpresa AND idPaquete=$idPaquete AND id_orden_compra=$idOrden");

                // Comprueba el código de estado HTTP
                if (!curl_errno($curl)) {
                switch ($http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE)) {
                    case 200:
                        $count=[
                            "o"=>["i"=>0,"u"=>0,"t"=>0,"f"=>0],
                            "od"=>["i"=>0,"u"=>0,"t"=>0],
                            "c"=>["i"=>0,"u"=>0,"t"=>0],
                            "cd"=>["i"=>0,"u"=>0,"t"=>0],
                            "r"=>["i"=>0,"u"=>0,"t"=>0],
                            "rd"=>["i"=>0,"u"=>0,"t"=>0],
                        ];
                        //Objeto de respuesta
                        foreach ($json->object_result as $doc => $docRow) {
                                switch ($docRow->tipo_docto) {
                                    case 'O':
                                        $data=[];
                                        $oc=$this->mordencompra->updateIdByFolio($idEmpresa,$docRow->id,$docRow->folio);
                                        ($oc) ? $count["o"]["f"]++ : false;
                                        //Recorre ordenes de compra(orden_compra)
                                        foreach ($docRow as $k => $v) {
                                            switch ($k) {
                                                case 'lista_articulos':
                                                    $dataList=[];
                                                    //Recorre listado de articulos(detalle_orden)
                                                    foreach ($v as $row) {
                                                        foreach ($row as $keyd => $vald){
                                                            $dataList[$keyd]=$vald;
                                                        }
                                                        //Validaciones de sincronizacion de detalle orden
                                                        $dataList['idEmpresa']=$idEmpresa;
                                                        $dataList['idPaquete']=$idPaquete;
                                                        $dataList['id_almacen']=$id_almacen;
                                                        if($this->mdetalleorden->valInsert($dataList['id'],$idEmpresa)){
                                                            $this->mdetalleorden->insertar($dataList);
                                                            $count["od"]["i"]++;
                                                        }else if($this->mdetalleorden->valUpdate($dataList['id'],$dataList)){
                                                            $this->mdetalleorden->actualizar($dataList,$dataList['id']);
                                                            $count["od"]["u"]++;
                                                        }
                                                        $count["od"]["t"]++;
                                                    }
                                                    break;
                                                default:
                                                    $data[$k]=$v;
                                                    break;
                                            }
                                        }
                                        
                                        $data['idEmpresa']=$idEmpresa;
                                        $data['idPaquete']=$idPaquete;
                                        if($this->mordencompra->valInsert($data['id'],$idEmpresa)){
                                            $this->mordencompra->insertar($data);
                                            $count["o"]["i"]++;
                                        }else if($this->mordencompra->valUpdate($data['id'],$data)){
                                            $this->mordencompra->actualizar($data,$data['id']);
                                            $count["o"]["u"]++;
                                        }
                                        $count["o"]["t"]++;
                                        break;
                                    case 'C':
                                        $data=[];
                                        //Recorre listado de compra
                                        foreach ($docRow as $k => $v){
                                            switch ($k) {
                                                case 'lista_articulos':
                                                    $dataList=[];
                                                    //Recorre listado de articulos(detalle_orden)
                                                    $count["cd"]["ids"]=[];
                                                    foreach ($v as $row) {
                                                        foreach ($row as $keyd => $vald){
                                                            switch ($keyd) {
                                                                case 'id_orden_compra':
                                                                    $dataList['id_compra']=$vald;
                                                                    break;
                                                                default:
                                                                    $dataList[$keyd]=$vald;
                                                                    break;
                                                            }
                                                        }
                                                        //Validaciones de sincronizacion de detalle orden
                                                        $dataList['idEmpresa']=$idEmpresa;
                                                        $dataList['idPaquete']=$idPaquete;
                                                        $dataList['id_almacen']=$id_almacen;
                                                        if($this->mdetallecompra->valInsert($dataList['id'],$idEmpresa)){
                                                            $this->mdetallecompra->insertar($dataList);
                                                            $count["cd"]["i"]++;
                                                        }else if($this->mdetallecompra->valUpdate($dataList['id'],$dataList)){
                                                            $this->mdetallecompra->actualizar($dataList,$dataList['id']);
                                                            $count["cd"]["u"]++;
                                                        }
                                                        $count["cd"]["t"]++;
                                                    }
                                                    break;
                                                default:
                                                    $data[$k]=$v;
                                                    break;
                                            }
                                        }
                                        //Validaciones de sincronizacion de compra
                                        $data['id_orden_compra']=$idOrden;
                                        $data['idEmpresa']=$idEmpresa;
                                        $data['idPaquete']=$idPaquete;
                                        if($this->mcompra->valInsert($data['id'],$idEmpresa)){
                                            $this->mcompra->insertar($data);
                                            $count["c"]["i"]++;
                                        }else if($this->mcompra->valUpdate($data['id'],$data)){
                                            $this->mcompra->actualizar($data,$data['id']);
                                            $count["c"]["u"]++;
                                        }
                                        $count["c"]["t"]++;
                                        break;
                                    case 'R':
                                        $data=[];
                                        //Recorre listado de recepcion
                                        foreach ($docRow as $k => $v){
                                            switch ($k) {
                                                case 'lista_articulos':
                                                    $dataList=[];
                                                    //Recorre listado de articulos(detalle_recepcion)
                                                    foreach ($v as $row) {
                                                        foreach ($row as $keyd => $vald){
                                                            switch ($keyd) {
                                                                case 'id_orden_compra':
                                                                    $dataList['id_recepcion']=$vald;
                                                                    break;
                                                                default:
                                                                    $dataList[$keyd]=$vald;
                                                                    break;
                                                            }
                                                        }
                                                        //Validaciones de sincronizacion de detalle recepcion
                                                        $dataList['idEmpresa']=$idEmpresa;
                                                        $dataList['idPaquete']=$idPaquete;
                                                        $dataList['id_almacen']=$id_almacen;
                                                        if($this->mdetallerecepcion->valInsert($dataList['id'],$idEmpresa)){
                                                            $this->mdetallerecepcion->insertar($dataList);
                                                            $count["rd"]["i"]++;
                                                        }else if($this->mdetallerecepcion->valUpdate($dataList['id'],$dataList)){
                                                            $this->mdetallerecepcion->actualizar($dataList,$dataList['id']);
                                                            $count["rd"]["u"]++;
                                                        }
                                                        $count["rd"]["t"]++;
                                                    }
                                                    break;
                                                default:
                                                    $data[$k]=$v;
                                                    break;
                                            }
                                        }
                                        //Validaciones de sincronizacion de recepcion
                                        $data['id_orden_compra']=$idOrden;
                                        $data['idEmpresa']=$idEmpresa;
                                        $data['idPaquete']=$idPaquete;
                                        if($this->mrecepcion->valInsert($data['id'],$idEmpresa)){
                                            $this->mrecepcion->insertar($data);
                                            $count["r"]["i"]++;
                                        }else if($this->mrecepcion->valUpdate($data['id'],$data)){
                                            $this->mrecepcion->actualizar($data,$data['id']);
                                            $count["r"]["i"]++;
                                        }
                                        $count["r"]["t"]++;
                                        break;
                                }
                            //}
                        }
                        if($retorno){
                            echo "Insertados en Orden Compra: ".$count["o"]["i"]." <br> ";
                            echo "Actualizados en Orden Compra: ".$count["o"]["u"]." <br> ";
                            echo "Folios Actualizados en Orden Compra: ".$count["o"]["f"]." <br> ";
                            echo "Insertados en Compra: ".$count["c"]["i"]." <br> ";
                            echo "Actualizados en Compra: ".$count["c"]["u"]." <br> ";
                            echo "Insertados en Recepcion: ".$count["r"]["i"]." <br> ";
                            echo "Actualizados en Recepcion: ".$count["r"]["u"]." <br> ";
                        }
                        curl_close($curl);
                        unset($json->object_result);
                        $json = json_encode($json);
                        $time_end = microtime(true);
                        $time = $time_end - $time_start;
                        $dataL['time'] = $time;
                        $dataL['idEmpresa'] = $idEmpresa;
                        $dataL['nombreTabla'] = 'compra';
                        $dataL['funcion'] = 'GetOrdenCompra';
                        $dataL['http_code'] = $http_code;
                        $dataL['insertados'] = 0;
                        $dataL['actualizados'] = 0;
                        $dataL['totalRegistros'] = 0;
                        $dataL['json'] = $json;
                        $dataL['created_by'] = $idUsuario;
                        $dataL['updated_by'] = $idUsuario;
                        $dataL['created'] = date("Y-m-d H:i:s");
                        $dataL['updated'] = date("Y-m-d H:i:s");
                        $this->db->insert('logs_ws', $dataL);
                        $dataL['nombreTabla'] = 'recepcion';
                        $dataL['insertados'] = 0;
                        $dataL['actualizados'] = 0;
                        $dataL['totalRegistros'] = 0;
                        $this->db->insert('logs_ws', $dataL);
                        break;
                    case 404:
                        echo "Not found";
                        $json = json_decode($json);
                        unset($json->object_result);
                        $json = json_encode($json);
                        $time_end = microtime(true);
                        $time = $time_end - $time_start;
                        $dataL['time'] = $time;
                        $dataL['idEmpresa'] = $idEmpresa;
                        $dataL['nombreTabla'] = 'compra';
                        $dataL['funcion'] = 'GetOrdenCompra';
                        $dataL['http_code'] = $http_code;
                        $dataL['insertados'] = 0;
                        $dataL['actualizados'] = 0;
                        $dataL['totalRegistros'] = 0;
                        $dataL['json'] = $json;
                        $dataL['created_by'] = $idUsuario;
                        $dataL['updated_by'] = $idUsuario;
                        $dataL['created'] = date("Y-m-d H:i:s");
                        $dataL['updated'] = date("Y-m-d H:i:s");
                        $this->db->insert('logs_ws', $dataL);
                        $dataL['nombreTabla'] = 'recepcion';
                        $this->db->insert('logs_ws', $dataL);
                        break;
                    default:
                        echo 'Unexpected HTTP code: ', $http_code, "\n";
                        $json = json_decode($json);
                        unset($json->object_result);
                        $json = json_encode($json);
                        $time_end = microtime(true);
                        $time = $time_end - $time_start;
                        $dataL['time'] = $time;
                        $dataL['idEmpresa'] = $idEmpresa;
                        $dataL['nombreTabla'] = 'compra';
                        $dataL['funcion'] = 'GetOrdenCompra';
                        $dataL['http_code'] = $http_code;
                        $dataL['insertados'] = 0;
                        $dataL['actualizados'] = 0;
                        $dataL['totalRegistros'] = 0;
                        $dataL['json'] = $json;
                        $dataL['created_by'] = $idUsuario;
                        $dataL['updated_by'] = $idUsuario;
                        $dataL['created'] = date("Y-m-d H:i:s");
                        $dataL['updated'] = date("Y-m-d H:i:s");
                        $this->db->insert('logs_ws', $dataL);
                        $dataL['nombreTabla'] = 'recepcion';
                        $this->db->insert('logs_ws', $dataL);
                    }
                }
            }else if(isset($json->object_result)){
                if(COUNT($json->object_result) == 0){
                    //eliminacion de detalles
                    //$this->db->query("DELETE FROM detalle_compra WHERE idEmpresa=$idEmpresa AND id_compra IN (SELECT id FROM compra WHERE idEmpresa=$idEmpresa AND idPaquete=$idPaquete AND id_orden_compra=$idOrden)");
                    //$this->db->query("DELETE FROM detalle_recepcion WHERE idEmpresa=$idEmpresa AND id_recepcion IN (SELECT id FROM recepcion WHERE idEmpresa=$idEmpresa AND idPaquete=$idPaquete AND id_orden_compra=$idOrden)");
                    //echo "Eliminacion de orden de compra y sus documentos idEmpresa=$idEmpresa AND idPaquete=$idPaquete AND id=$idOrden";
                    //$this->db->query("DELETE FROM orden_compra WHERE idEmpresa=$idEmpresa AND idPaquete=$idPaquete AND id=$idOrden");
                    //$this->db->query("DELETE FROM detalle_orden WHERE idEmpresa=$idEmpresa AND idPaquete=$idPaquete AND id_orden_compra=$idOrden");
                    //$this->db->query("DELETE FROM compra WHERE idEmpresa=$idEmpresa AND idPaquete=$idPaquete AND id_orden_compra=$idOrden");
                    //$this->db->query("DELETE FROM recepcion WHERE idEmpresa=$idEmpresa AND idPaquete=$idPaquete AND id_orden_compra=$idOrden");
                }
            }
        }
    }

    public function syncEmpresas(){
        $qEmpresa = $this->mempresas->getAll();
        if( !is_numeric($qEmpresa) ){
            foreach($qEmpresa->result() as $row){
                $this->getAlmacenes($row->id);
                $this->getProveedores($row->id);
                $this->getArticulos($row->id);
            }
        }
    }

    public function syncMicrosip(){
        require('Ms.php');
        $ms = new Ms();
        ini_set('max_execution_time', 0);
        $qEmpresa = $this->mempresas->getAll();
        if( !is_numeric($qEmpresa) ){
            foreach($qEmpresa->result() as $row){
                $ms->getDocsByEmpresa($row->id);
            }
        }
    }

    public function sendNotifications($idArranque=null)
    {
        $arrayLotes = $this->getLotes($idArranque);
        foreach($arrayLotes as $key => $value){
            $arrayEtapas = $this->getEtapa($value['idProyecto']);
            foreach($arrayEtapas as $k => $val){
                if($val['status']){
                    $tipo = '';
                    if($val['idSuperCategoria'] == 1){
                        $tipo = 'obra negra';
                    }else if($val['idSuperCategoria'] == 2){
                        $tipo = 'acabados';
                    }else if($val['idSuperCategoria'] == 3){
                        $tipo = 'entrega';
                    }

                    $pData['idProyecto'] = $value['idProyecto'];
                    $pData['tipo'] = $tipo;

                    $insert = $this->insertLogsNotifications($pData);
                    if($insert){
                        break;
                    }else{
                        continue;
                    }
                }
            }
        }

        //$count = $this->resendWhatsapp();
    }

    public function getLotes($idArranque=null)
    {
        $this->load->model(array('marranque', 'mpaquete', 'mdetallepaquete', 'mproyecto'));
        $q = ($idArranque == null) ? $this->marranque->getAll() : $this->marranque->getById2($idArranque);
        $arrayLotes = array();
        if(!is_numeric($q)){
            foreach($q->result() as $row){
                if($row->estatus_arranque == 2){
                    $count = 0;
                    $countIdPaq = explode(',', $row->idPaquetes);
                    $countArray = count($countIdPaq);

                    foreach ($countIdPaq as $key => $value) {
                        $qPaquete = $this->mpaquete->getById($value);
                        if(!is_numeric($qPaquete)){
                            $detallePaquete = $this->mdetallepaquete->getByIdPaquete($qPaquete['id']);
                            if(!is_numeric($detallePaquete)){
                                foreach($detallePaquete->result() as $r){
                                    $proyecto = $this->mproyecto->getById($r->idProyecto);
                                    if(!is_numeric($proyecto)){
                                        $array = array(
                                            'idProyecto' => $proyecto['id'],
                                            'idFraccionamiento' => $proyecto['idFraccionamiento'],
                                            'idPrototipo' => $proyecto['idPrototipo'],
                                            'idPrototipo' => $proyecto['idPrototipo'],
                                            'lote' => $proyecto['lote'],
                                            'manzana' => $proyecto['manzana']
                                        );
                                    }

                                    array_push($arrayLotes, $array);
                                }
                            }
                        }
                    }
                }
            }
        }

        return $arrayLotes;
    }

    public function getEtapa($idProyecto)
    {
        $this->load->model(array('marranque', 'mpaquete', 'mdetallepaquete', 'mproyecto', 'msupercategoriamo', 'mmanoobra'));
        $proyecto = $this->mproyecto->getById($idProyecto);
        $response = array();
        if(!is_numeric($proyecto)){
            $supercat = $this->msupercategoriamo->getAllOrderByAsc();
            $detallePaquete = $this->mdetallepaquete->getByIdProyecto($idProyecto);
            $idPaquete = (!is_numeric($detallePaquete)) ? $detallePaquete->row()->idPaquete : 0;
            if(!is_numeric($supercat)){
                foreach($supercat->result() as $row){
                    $countActividadesFinalizadas = 0;
                    $counPrespuestoMO = 0;
                    $arrayIdsActPro = array();
                    $arrayIdsPmo = array();
                    $activadesPrototipo = $this->db->query("SELECT ap.* FROM actividadesprototipo AS ap WHERE ap.idPrototipo = ".$proyecto['idPrototipo']." AND ap.idCategoria IN ($row->idCategoria)");
                    if($activadesPrototipo->num_rows() > 0){
                        foreach($activadesPrototipo->result() as $r){
                            array_push($arrayIdsActPro, $r->id);
                        }
                    }
                    $impIdsActPro = ($arrayIdsActPro) ? implode(',', $arrayIdsActPro) : 0;
                    $mo = $this->mmanoobra->getByIdFraccionamientoPrototipo($proyecto['idFraccionamiento'], $proyecto['idPrototipo']);
                    if(!is_numeric($mo)){
                        $prespuestoMO = $this->db->query("SELECT * FROM presupuesto_mo AS p WHERE p.idManoObra = ".$mo->row()->id." AND p.idActividadPrototipo IN ($impIdsActPro)");
                        if($prespuestoMO->num_rows() > 0){
                            $counPrespuestoMO = $prespuestoMO->num_rows();
                            foreach($prespuestoMO->result() as $r){
                                array_push($arrayIdsPmo, $r->id);
                            }
                        }
                    }

                    $impIdPmo = ($arrayIdsPmo) ? implode(',', $arrayIdsPmo) : 0;

                    $qAvance = $this->db->query("SELECT av.*, es.nEstimacion FROM estimacion_programa AS en INNER JOIN estimaciones_programa AS es ON en.id = es.idEstimacion 
                    INNER JOIN estimados_programa AS eds ON es.id = eds.idEstimaciones 
                    INNER JOIN avanceobra AS av ON eds.id = av.idEstimado WHERE en.idPaquete = $idPaquete AND eds.idPresupuesto IN ($impIdPmo) AND av.lotes ");
                    if($qAvance->num_rows() > 0){
                        foreach($qAvance->result() as $av){
                            if($av->lotes != ''){
                                $lts = explode(',', $av->lotes);
                                $countLt = count($lts);

                                for($i=0; $i<$countLt;$i++){
                                    $lt = explode('/', $lts[$i]);
                                    if($proyecto['lote'] == $lt[0]){
                                        $countActividadesFinalizadas++;
                                    }
                                }
                            }
                        }
                    }

                    if($counPrespuestoMO == $countActividadesFinalizadas){
                        $response[$row->id]['idSuperCategoria'] = $row->id;
                        $response[$row->id]['superCategoria'] = $row->supercategoria;
                        $response[$row->id]['status'] = 1;
                    }else{
                        $response[$row->id]['idSuperCategoria'] = $row->id;
                        $response[$row->id]['superCategoria'] = $row->supercategoria;
                        $response[$row->id]['status'] = 0;
                    }

                }
            }
        }

        return $response;
    }

    public function insertLogsNotifications($data)
    {
        if(isset($data['idAltaVenta'])){
            $altaVenta = $this->db->query("SELECT * FROM alta_venta WHERE id = ".$data['idAltaVenta']);
        }else{
            $altaVenta = $this->db->query("SELECT * FROM alta_venta WHERE idProyecto = ".$data['idProyecto']);
        }
        
        $valid = 0;
        $type = '5';
        if($data['tipo'] == 'arranque'){
            $type = '1';
        }else if($data['tipo'] == 'obra negra'){
            $type = '2';
        }else if($data['tipo'] == 'acabados'){
            $type = '3';
        }else if($data['tipo'] == 'entrega'){
            $type = '4';
        }else if($data['tipo'] == 'entregado'){
            $type = '5';
        }else if($data['tipo'] == 'alta de venta'){ //validación para el mod. de ventas
            $type = '6';
        }else if($data['tipo'] == 'inscripcion de credito2'){ //estatus en titulación
            $type = '7';
        }else if($data['tipo'] == 'programacion de firma de escrituras'){
            $type = '8';
        }else if($data['tipo'] == 'formalizacion de la venta'){
            $type = '9';
        }else if($data['tipo'] == 'inscripcion de credito3'){
            $type = '10';
        }

        $pData = array();
        if($altaVenta->num_rows() > 0){
            $prospecto = $this->db->query("SELECT * FROM prospectos WHERE id = ".$altaVenta->row()->idProspecto);
            if($prospecto->num_rows() > 0){
                $nombre = $prospecto->row()->nombre;
                $apellidoP = $prospecto->row()->apellidoP;
                $apellidoM = $prospecto->row()->apellidoM;
                $telefono = $prospecto->row()->telefono;
                $email = $prospecto->row()->email;
                $nombreCompleto = $apellidoP.' '.$apellidoM.' '.$nombre;
                $telefonoPromotor;

                $data['idProspecto'] = $prospecto->row()->id;
                $data['via'] = 'email';
                $via = 'email';

                $tipo = $data['tipo'];
                $logsNoti = $this->db->query("SELECT * FROM logs_notifications WHERE idProyecto = ".$data['idProyecto']." AND idProspecto = ".$prospecto->row()->id. " AND tipo = '$tipo' AND via = '$via'");
                if($logsNoti->num_rows() == 0){
                    $subject = "HOLA ".$nombreCompleto." NOTIFICACIÓN DE ".strtoupper($data['tipo']);
                    //$message = "NOTIFICACIÓN DE LOTE EN ".strtoupper($data['tipo']);                    

                    if(isset($data['idAltaVenta'])){
                        $sendData = $this->notificaciones_etapas2($data['idAltaVenta'], $type, 0);
                        $message = $sendData["message"];
                        $telefonoPromotor = $sendData["telefono"];
                        $idAv = $data['idAltaVenta'];
                        unset($data['idAltaVenta']);
                    }else{
                        $sendData = $this->notificaciones_etapas($data['idProyecto'], $type, 0);
                        $message = $sendData["message"];
                        $telefonoPromotor = $sendData["telefono"];
                        //$message = $this->notificaciones_etapas($data['idProyecto'], $type, 0); 
                    }

                    /*if($this->appProduction){
                        $send = $this->sendMail($email, $subject, $message);
                    }else{
                        $send = $this->sendMail('sistemas@viviend.mx', $subject, $message);
                    }*/
                    $send=true;
                    if($send){
                        $data['enviado'] = 1;
                        $data['status'] = 1;
                        $data['created'] = date("Y-m-d H:i:s");
                        $data['updated'] = date("Y-m-d H:i:s");

                        array_push($pData, $data);

                        $this->db->insert_batch('logs_notifications', $pData);

                        if(isset($idAv)){
                            $url = $this->baseLinkSystem."cronjob/notificaciones_etapas2/".$idAv."/".$type."/1";
                        }else{
                            $url = $this->baseLinkSystem."cronjob/notificaciones_etapas/".$data['idProyecto']."/".$type."/1";
                        }
                        /*$accountKey = '26e9dd';
                        $ch = curl_init('http://api.screenshotmachine.com/?key='.$accountKey.'&size=M&format=png&url='.$url);
                        $fp = fopen($this->data['fotos_www'].'/'.$data['idProyecto'].'_'.$data['idProspecto'].'.png', 'wb');
                        curl_setopt($ch, CURLOPT_FILE, $fp);
                        curl_setopt($ch, CURLOPT_HEADER, 0);
                        curl_exec($ch);
                        curl_close($ch);
                        fclose($fp);*/

                        //
                        /*$dataImg = json_decode(file_get_contents('http://api.rest7.com/v1/html_to_image.php?url=' . $url . '&format=png&api_key=0e40d45af0e22b6a508d507e388f9853bbff7e7d'));

                        if (@$dataImg->success !== 1)
                        {
                            die('Failed');
                        }

                        $image = file_get_contents($dataImg->file);

                        file_put_contents($this->data['fotos_www'].'/'.$data['idProyecto'].'_'.$data['idProspecto'].'.png', $image);*/

                        //

                        $arrayConf['url'] = $url; //set url
                        if(isset($idAv)){
                            $arrayConf['filename'] = $idAv.'_'.$data['idProspecto'].'.png'; //set file name 
                        }else{
                           $arrayConf['filename'] = $data['idProyecto'].'_'.$data['idProspecto'].'.png'; //set file name 
                        }
                        $arrayConf['width'] = 600; // set width
		                $arrayConf['height'] = 1100; // set height
                        $arrayConf['diruploads'] = $this->data['fotos_www']; // set dir uploads
                        // $config['clipwidth'] = 1024; // optional
                        // $config['clipheight'] = 768; // optional

                        $this->phantomcapture->initialize($arrayConf);
                        $valid2 = $this->phantomcapture->captureit();

                        sleep(5);

                        if(!$this->appProduction){
                            $telefono = $telefonoPromotor = '9851045678';
                        }

                        $insertDataWhatsapp = $data;
                        $dataSendWhatsapp['to'] = '521'.$telefono;
                        $dataSendWhatsapp['message2'] = leyendaNotifWhatsapp($type);
                        $dataSendWhatsapp['key'] = $this->keyActive;
                        if(isset($idAv)){
                            $dataSendWhatsapp['message'] = new CURLFile($this->data['fotos_www'].'/'.$idAv.'_'.$data['idProspecto'].'.png', mime_content_type($this->data['fotos_www'].'/'.$idAv.'_'.$data['idProspecto'].'.png'));
                        }else{
                            $dataSendWhatsapp['message'] = new CURLFile($this->data['fotos_www'].'/'.$data['idProyecto'].'_'.$data['idProspecto'].'.png', mime_content_type($this->data['fotos_www'].'/'.$data['idProyecto'].'_'.$data['idProspecto'].'.png'));
                        }
                        //envio a promotor
                        if(in_array($type,["6","7","8","9","10"])){
                            $this->sendWhatsappImage($insertDataWhatsapp, $dataSendWhatsapp);
                            sleep(5);
                            $insertDataWhatsapp['tipo'] .= " promotor";
                            $dataSendWhatsapp['to'] = '521'.$telefonoPromotor;
                        }
                        //$dataSendWhatsapp['image'] = new CURLFILE('/'.$this->data['fotos_www'].'/mail_whats.png');
                        $this->sendWhatsappImage($insertDataWhatsapp, $dataSendWhatsapp);

                        $valid = 1;
                    }else{
                        $data['enviado'] = 0;
                        $data['status'] = 1;
                        $data['created'] = date("Y-m-d H:i:s");
                        $data['updated'] = date("Y-m-d H:i:s");

                        array_push($pData, $data);

                        $this->db->insert_batch('logs_notifications', $pData);

                        $valid = 1;
                    }
                }else{
                    if($logsNoti->row()->enviado == 0){
                        $data['id'] = $logsNoti->row()->id;
                        $data['enviado'] = 1;
                        $data['status'] = 1;
                        $data['updated'] = date("Y-m-d H:i:s");

                        array_push($pData, $data);

                        $this->db->update_batch('logs_notifications', $pData, 'id');

                        $valid = 1;
                    }
                }
            }
        }

        return $valid;
    }

    public function notificaciones_etapas2($idAltaVenta, $tipo='5', $viaWhatsapp = 0){ //Notificaciones área de ventas
        $this->load->model(array('maltaventa', 'mprospecto', 'musuario', 'mproyecto', 'mprototipos','mfraccionamiento'));
        $this->load->helper(array('tools','numeros','url','form','date','text','security'));
        $cuerpo = '';
        $htmlArra = '';
        $textNotif = statusNotif($tipo);
        $imgStatus = imgStatus($tipo);
        $leyendaNotif = leyendaNotif($tipo, $viaWhatsapp);
        $leyendaIniciado = leyendaConstruyendo($tipo);
        $logoConstruyendo = logoConstruyendo($tipo);

        $etapa = '';
        $fracc = '';

        $query = $this->db->query('
                    SELECT
                        av.idProspecto,
                        (SELECT UPPER(CONCAT(nombre, " ", apellidoP, " ", apellidoM)) FROM prospectos WHERE id=av.idProspecto) AS cliente,
                        (SELECT nss FROM prospectos WHERE id=av.idProspecto) AS nss,
                        (SELECT titulo FROM fraccionamientos WHERE id=(SELECT idFraccionamiento FROM prospectos WHERE id=idProspecto)) AS fraccionamiento,
                        (SELECT UPPER(CONCAT(nombre, " ", apellidoP, " ", apellidoM)) FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=av.idProspecto)) AS promotor,
                        (SELECT celular FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=av.idProspecto)) AS celular,
                        (SELECT lote FROM proyectos WHERE id=(SELECT idProyecto FROM alta_venta WHERE id = av.id)) AS lote,
                        (SELECT manzana FROM proyectos WHERE id=(SELECT idProyecto FROM alta_venta WHERE id = av.id)) AS manzana,
                        (SELECT nombre FROM prototipos WHERE id=(SELECT idPrototipo FROM prospectos WHERE id=av.idProspecto)) AS prototipo
                    FROM
                        alta_venta AS av
                    WHERE
                        av.id = '.$idAltaVenta.'
                ');

        $cliente = '';
        $promotor = '';
        $celular = '';
        $lote = '';
        $nss = '';
        $manzana = '';
        $nomPrototipo = '';
        $fraccionamiento = '';
        if($query->num_rows() > 0){
            $cliente = $query->row()->cliente;
            $promotor = $query->row()->promotor;;
            $celular = $query->row()->celular;
            $lote = $query->row()->lote;
            $manzana = $query->row()->manzana;
            $nomPrototipo = $query->row()->prototipo;
            $nss = $query->row()->nss;
            $fraccionamiento = $query->row()->fraccionamiento;
        }

        if ($tipo != '5') {
             $etapa = '
                <tr >
                    <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;" class="paddinginfo borderyellow greentitle fs-notif" > ETAPA: </td>
                    <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;" class="paddinginfo borderyellow" >'.$textNotif.'</td>
                </tr';
        }

        if ($tipo == 1 || $tipo == 2|| $tipo == 3 || $tipo == 3 || $tipo == 4) {
             $fracc = '
                <tr>
                    <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow greentitle fs-notif" > FRACCIONAMIENTO: </td>
                    <td  style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow" > '.$fraccionamiento.'  </td>
                </tr> ';
        }else{
             $fracc = '';
        }

        $cuerpo .= '

                    <tr >
                        <td style="padding:10px;" class="paddinginfo " >  </td>
                        <td style="padding:10px;" class="paddinginfo " >    </td>
                    </tr>

                    '. $etapa.'

                    <tr >
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;" class="paddinginfo borderyellow greentitle fs-notif" > CLIENTE: </td>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow" >  '.$cliente.' </td>
                    </tr>
                    <tr >
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;" class="paddinginfo borderyellow greentitle fs-notif" > NSS: </td>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow" >  '.$nss.' </td>
                    </tr>
                    <tr>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow greentitle fs-notif" > ASESOR: </td>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow" > '.strtoupper($promotor).'</td>
                    </tr>
                    <tr>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow greentitle fs-notif" >TEL.PROMOTOR:</td>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"   class="paddinginfo borderyellow" > '.$celular.'  </td>
                    </tr>
                    <tr>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow greentitle fs-notif" >   PROTOTIPO: </td>
                        <td  style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow" > '.$nomPrototipo.'  </td>
                    </tr>
                    '. $fracc.'
                    <tr>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow greentitle fs-notif" >  LOTE (MZ): </td>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow" > '.$lote.'  ('.$manzana.') </td>
                    </tr>

                ';




           $htmlArra ='
                        <tr>
                            <td style="padding: 30px 30px 0px 30px;" class="innerpadding borderbottom">
                                <!-- [if (gte mso 9)|(IE)]>
                                <table width="380" align="left" cellpadding="0" cellspacing="0" border="0">
                                    <tr>
                                    <td>
                                <![endif]-->
                                <table class="col380" align="left" border="0" cellpadding="0" cellspacing="0" style="width: 100%; max-width: 100%;">
                                <tr>
                                    <td>
                                        <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                <tr>
                                                    <td  style="padding:10px;" class="paddinginfo" >
                                                        '.$imgStatus.'

                                                    </td>
                                                    <td  style="padding:10px;color:#248d3b;font-weight:bold;" class="paddinginfo greentitle" >'.$leyendaNotif.'
                                                    </td>
                                                </tr>
                                                <br>
                                                '.$cuerpo.'
                                        </table>
                                    </td>
                                </tr>
                                </table>
                                <!--[if (gte mso 9)|(IE)]>
                                    </td>
                                    </tr>
                                </table>
                                <![endif]-->
                            </td>
                        </tr>

                        <tr>
                            <td style="padding: 0px 30px 30px 30px;" class="innerpadding borderbottom">
                                <table class="col380" align="left" border="0" cellpadding="0" cellspacing="0" style="width: 100%; max-width: 100%;">
                                    <tr>
                                        <td>
                                            <table width="100%" border="0" cellspacing="0" cellpadding="0">

                                                    <tr>
                                                        <td  style="padding:10px;color:#248d3b;font-weight:bold;" class="paddinginfo greentitle" >'.$leyendaIniciado.'
                                                        </td>
                                                    </tr>
                                            </table>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    ';
                    $subject = "";

                    $destMail = '';
                    $notificacion="";
                    //$notificacion = email_notificaciones($htmlArra,'','',$logoConstruyendo);
        if(!$viaWhatsapp){
            return [
                "telefono" => $celular,
                "message" => $notificacion
            ];
        }else{
            echo $notificacion;
        }  
    }

    public function notificaciones_etapas($idProyecto, $tipo='5', $viaWhatsapp = 0){
        $this->load->model(array('maltaventa', 'mprospecto', 'musuario', 'mproyecto', 'mprototipos','mfraccionamiento'));
        $this->load->helper(array('tools','numeros','url','form','date','text','security'));
        $cuerpo = '';
        $htmlArra = '';
        $textNotif = statusNotif($tipo);
        $imgStatus = imgStatus($tipo);
        $leyendaNotif = leyendaNotif($tipo, $viaWhatsapp);
        $leyendaIniciado = leyendaConstruyendo($tipo);
        $logoConstruyendo = logoConstruyendo($tipo);

        $etapa = '';
        $fracc = '';

        $query = $this->db->query('
                    SELECT
                        av.idProspecto,
                        (SELECT UPPER(CONCAT(nombre, " ", apellidoP, " ", apellidoM)) FROM prospectos WHERE id=av.idProspecto) AS cliente,
                        (SELECT nss FROM prospectos WHERE id=av.idProspecto) AS nss,
                        (SELECT titulo FROM fraccionamientos WHERE id=(SELECT idFraccionamiento FROM proyectos WHERE id=idProyecto)) AS fraccionamiento,
                        (SELECT UPPER(CONCAT(nombre, " ", apellidoP, " ", apellidoM)) FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=av.idProspecto)) AS promotor,
                        (SELECT celular FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=av.idProspecto)) AS celular,
                        (SELECT lote FROM proyectos WHERE id=(SELECT idProyecto FROM alta_venta WHERE id = av.id)) AS lote,
                        (SELECT manzana FROM proyectos WHERE id=(SELECT idProyecto FROM alta_venta WHERE id = av.id)) AS manzana,
                        (SELECT nombre FROM prototipos WHERE id=(SELECT idPrototipo FROM prospectos WHERE id=av.idProspecto)) AS prototipo
                    FROM
                        alta_venta AS av
                    WHERE
                        av.idProyecto = '.$idProyecto.'
                ');

        $cliente = '';
        $promotor = '';
        $celular = '';
        $lote = '';
        $nss = '';
        $manzana = '';
        $nomPrototipo = '';
        $fraccionamiento = '';
        if($query->num_rows() > 0){
            $cliente = $query->row()->cliente;
            $promotor = $query->row()->promotor;;
            $celular = $query->row()->celular;
            $lote = $query->row()->lote;
            $manzana = $query->row()->manzana;
            $nomPrototipo = $query->row()->prototipo;
            $nss = $query->row()->nss;
            $fraccionamiento = $query->row()->fraccionamiento;
        }

        /*$idProspecto = $this->maltaventa->getCampo('idProspecto',$idProyecto);
        $cliente = $this->mprospecto->getCampo('nombre', $idProspecto).' '.$this->mprospecto->getCampo('apellidoP', $idProspecto) .' '.$this->mprospecto->getCampo('apellidoM', $idProspecto);
        $idPromotor = $this->mprospecto->getCampo('idPromotor',$idProyecto);
        $promotor =  $this->musuario->getCampo('nombre', $idPromotor).' '.$this->musuario->getCampo('apellidoP', $idPromotor) .' '.$this->musuario->getCampo('apellidoM', $idPromotor);
        $celular = $this->musuario->getCampo('celular', $idPromotor);
        $info =  $this->mproyecto->getById($idProyecto);
        $lote = $this->mproyecto->getCampo('lote', $idProyecto);
        $manzana = $this->mproyecto->getCampo('manzana', $idProyecto);
        $idPrototipo = $this->mproyecto->getCampo('idPrototipo', $idProyecto);
        $nomPrototipo = $this->mprototipos->getCampo('nombre',$idPrototipo);*/



        if ($tipo != '5') {
             $etapa = '
                <tr >
                    <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;" class="paddinginfo borderyellow greentitle fs-notif" > ETAPA: </td>
                    <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;" class="paddinginfo borderyellow" >'.$textNotif.'</td>
                </tr';
        }

        if ($tipo == 1 || $tipo == 2|| $tipo == 3 || $tipo == 3 || $tipo == 4) {
             $fracc = '
                <tr>
                    <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow greentitle fs-notif" > FRACCIONAMIENTO: </td>
                    <td  style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow" > '.$fraccionamiento.'  </td>
                </tr> ';
        }else{
             $fracc = '';
        }

        $cuerpo .= '

                    <tr >
                        <td style="padding:10px;" class="paddinginfo " >  </td>
                        <td style="padding:10px;" class="paddinginfo " >    </td>
                    </tr>

                    '. $etapa.'

                    <tr >
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;" class="paddinginfo borderyellow greentitle fs-notif" > CLIENTE: </td>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow" >  '.$cliente.' </td>
                    </tr>
                    <tr >
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;" class="paddinginfo borderyellow greentitle fs-notif" > NSS: </td>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow" >  '.$nss.' </td>
                    </tr>
                    <tr>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow greentitle fs-notif" > ASESOR: </td>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow" > '.strtoupper($promotor).'</td>
                    </tr>
                    <tr>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow greentitle fs-notif" >TEL.PROMOTOR:</td>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"   class="paddinginfo borderyellow" > '.$celular.'  </td>
                    </tr>
                    <tr>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow greentitle fs-notif" >   PROTOTIPO: </td>
                        <td  style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow" > '.$nomPrototipo.'  </td>
                    </tr>
                    '. $fracc.'
                    <tr>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow greentitle fs-notif" >  LOTE (MZ): </td>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow" > '.$lote.'  ('.$manzana.') </td>
                    </tr>

                ';




           $htmlArra ='
                        <tr>
                            <td style="padding: 30px 30px 0px 30px;" class="innerpadding borderbottom">
                                <!-- [if (gte mso 9)|(IE)]>
                                <table width="380" align="left" cellpadding="0" cellspacing="0" border="0">
                                    <tr>
                                    <td>
                                <![endif]-->
                                <table class="col380" align="left" border="0" cellpadding="0" cellspacing="0" style="width: 100%; max-width: 100%;">
                                <tr>
                                    <td>
                                        <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                <tr>
                                                    <td  style="padding:10px;" class="paddinginfo" >
                                                        '.$imgStatus.'

                                                    </td>
                                                    <td  style="padding:10px;color:#248d3b;font-weight:bold;" class="paddinginfo greentitle" >'.$leyendaNotif.'
                                                    </td>
                                                </tr>
                                                <br>
                                                '.$cuerpo.'
                                        </table>
                                    </td>
                                </tr>
                                </table>
                                <!--[if (gte mso 9)|(IE)]>
                                    </td>
                                    </tr>
                                </table>
                                <![endif]-->
                            </td>
                        </tr>

                        <tr>
                            <td style="padding: 0px 30px 30px 30px;" class="innerpadding borderbottom">
                                <table class="col380" align="left" border="0" cellpadding="0" cellspacing="0" style="width: 100%; max-width: 100%;">
                                    <tr>
                                        <td>
                                            <table width="100%" border="0" cellspacing="0" cellpadding="0">

                                                    <tr>
                                                        <td  style="padding:10px;color:#248d3b;font-weight:bold;" class="paddinginfo greentitle" >'.$leyendaIniciado.'
                                                        </td>
                                                    </tr>
                                            </table>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    ';
                    $subject = "HOLA ".$cliente." NOTIFICACIONES VIVIEND";

                    $destMail = '';
                    $notificacion="";
                    //$notificacion = email_notificaciones($htmlArra,'','',$logoConstruyendo);

        if(!$viaWhatsapp){
            return [
                "telefono" => $celular,
                "message" => $notificacion
            ];
        }else{
            echo $notificacion;
        }  
    }

    protected function sendMail($correo, $asunto='', $mensaje = '') {
        $this->load->library('email');

        $this->email->clear();
        $this->email->set_mailtype("html");
        $this->email->from('notificaciones@viviend.mx', 'Viviend Notificaciones');
        $this->email->to($correo);
        $this->email->subject($asunto);
        $this->email->message($mensaje);

        if ( $this->email->send() ) {
            $respuesta = true;
        }
        else {
            $respuesta = false;
        }
        return $respuesta;
    }

    public function sendWhatsapp($dataSend = array())
    {
        $r['valid'] = 0;
        if(count($dataSend) > 0){

            $dataSend['message'] = $dataSend['message2'];

            unset($dataSend['message2']);

            //$datos = http_build_query($dataSend);
            $datos = $dataSend;

            //$headers = array('Content-Type: application/x-www-form-urlencoded');
            $headers = array("Content-Type: multipart/form-data");

            $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => $this->urlSendWhatsapp.'/sendMessage',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => $datos,
            CURLOPT_HTTPHEADER => $headers,
            ));

            $response = curl_exec($curl);
            $err = curl_error($curl);

            curl_close($curl);

            $res = json_decode($response, true);

            if(!$err){
                echo "Res <br>";
                print_r($res);
                if($res['status'] == 200 && !isset($res["error"])){
                    $r['valid'] = 1;
                    $r['jsonMessage'] = json_encode($datos);
                    $r['jsonResult'] = json_encode($res);
                }else{
                    $r['valid'] = 0;
                    $r['jsonMessage'] = json_encode($datos);
                    $r['jsonResult'] = json_encode($res);
                }
            }else{
                $r['valid'] = 0;
                $r['jsonMessage'] = json_encode($datos);
                $r['jsonResult'] = json_encode($res);
            }
        }else{
            $r['valid'] = 0;
            $r['jsonMessage'] = json_encode(array());
            $r['jsonResult'] = json_encode(array());
        }

        return $r;
    }

    public function sendWhatsappImage($dataInsert = array(), $dataSend = array())
    {
        $valid = 0;
        $data = $dataInsert;
        $pData = array();
        if(count($data) > 0 && count($dataSend) > 0){
            $send = $dataSend;
            $tipo = $data['tipo'];
            $via = 'whatsapp';
            $logsNoti = $this->db->query("SELECT * FROM logs_notifications WHERE idProyecto = ".$data['idProyecto']." AND idProspecto = ".$data['idProspecto']. " AND tipo = '$tipo' AND via = '$via'");
            if($logsNoti->num_rows() == 0){

                unset($dataSend['message2']);

                $curl = curl_init();

                curl_setopt_array($curl, array(
                    CURLOPT_URL => $this->urlSendWhatsapp.'/sendMedia',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_POST => 1,
                    CURLOPT_POSTFIELDS => $dataSend,
                    CURLOPT_VERBOSE => true
                ));

                $response = curl_exec($curl);
                $err = curl_error($curl);

                curl_close($curl);

                $res = json_decode($response, true);

                sleep(4);

                $sendWhatsapp = $this->sendWhatsapp($send);

                if(!$err){
                    if($res['status'] == 200 && !isset($res["error"]) && $sendWhatsapp['valid']){
                        $data['via'] = $via;
                        $data['enviado'] = 1;
                        $data['http_code'] = $res['status'];
                        $data['json'] = $sendWhatsapp['jsonResult'];
                        $data['json2'] = json_encode($res);
                        $data['status'] = 1;
                        $data['created'] = date("Y-m-d H:i:s");
                        $data['updated'] = date("Y-m-d H:i:s");

                        array_push($pData, $data);

                        $this->db->insert_batch('logs_notifications', $pData);

                        $valid = 1;

                        //unlink($this->data['fotos_www'].'/'.$data['idProyecto'].'_'.$data['idProspecto'].'.png');
                    }else{
                        $data['via'] = $via;
                        $data['enviado'] = 0;
                        $data['jsonMessage'] = $sendWhatsapp['jsonMessage'];
                        $data['jsonMedia'] = json_encode($dataSend);
                        $data['status'] = 1;
                        $data['created'] = date("Y-m-d H:i:s");
                        $data['updated'] = date("Y-m-d H:i:s");

                        array_push($pData, $data);

                        $this->db->insert_batch('logs_notifications', $pData);

                        $valid = 0;
                    }
                }else{
                    $data['via'] = $via;
                    $data['enviado'] = 0;
                    $data['jsonMessage'] = $sendWhatsapp['jsonMessage'];
                    $data['jsonMedia'] = json_encode($dataSend);
                    $data['status'] = 1;
                    $data['created'] = date("Y-m-d H:i:s");
                    $data['updated'] = date("Y-m-d H:i:s");

                    array_push($pData, $data);

                    $this->db->insert_batch('logs_notifications', $pData);

                    $valid = 0;
                }
            }else{
                $valid = 0;
            }
        }else{
            $valid = 0;
        }

        return $valid;
    }

    public function resendWhatsapp()
    {
        $count = 0;
        $logsNoti = $this->db->query("SELECT * FROM logs_notifications WHERE via = 'whatsapp' AND enviado = false");
        if($logsNoti->num_rows() > 0){
            foreach($logsNoti->result() as $row){
                $pData = array();
                //Se ejecuta el reenvio para whatsapp con imagen

                $datosMedia = json_decode($row->jsonMedia, true);
                $datosMedia['message'] = new CURLFile($datosMedia['message']['name'], mime_content_type($datosMedia['message']['name']));;

                $curl = curl_init();

                curl_setopt_array($curl, array(
                    CURLOPT_URL => $this->urlSendWhatsapp.'/sendMedia',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_POST => 1,
                    CURLOPT_POSTFIELDS => $datosMedia,
                    CURLOPT_VERBOSE => true
                ));

                $response = curl_exec($curl);
                $err = curl_error($curl);

                curl_close($curl);

                $res = json_decode($response, true);

                sleep(2);

                //Se reenvia el whatsapp solo con texto
                $datosMessage = json_decode($row->jsonMessage, true);

                $headers = array("Content-Type: multipart/form-data");

                $curl1 = curl_init();

                curl_setopt_array($curl1, array(
                CURLOPT_URL => $this->urlSendWhatsapp.'/sendMessage',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => $datosMessage,
                CURLOPT_HTTPHEADER => $headers,
                ));

                $response1 = curl_exec($curl1);
                $err1 = curl_error($curl1);

                curl_close($curl1);

                $res1 = json_decode($response1, true);

                if(!$err && !$err1){
                    if($res['status'] == 200 && !isset($res["error"]) && $res1['status'] == 200 && !isset($res1["error"])){
                        $data['id'] = $row->id;
                        $data['enviado'] = 1;
                        $data['json'] = json_encode($res1);
                        $data['json2'] = json_encode($res);
                        $data['jsonMessage'] = '';
                        $data['jsonMedia'] = '';
                        $data['updated'] = date("Y-m-d H:i:s");

                        array_push($pData, $data);

                        $this->db->update_batch('logs_notifications', $pData, 'id');

                        $count++;

                        unlink($this->data['fotos_www'].'/'.$row->idProyecto.'_'.$row->idProspecto.'.png');
                    }
                }

                sleep(1);

            }
        }

        return $count;
    }

    public function notificationEntrega($fechaInicial = '')
    {
        $this->load->helper(array('tools','numeros','url','form','date','text','security'));
        $fecha = ($fechaInicial != '') ? date("Y-m-d", strtotime($fechaInicial)) : date('Y-m-d');
        $response = 0;

        $query = $this->db->query("SELECT e.id AS idEntrega, e.idAltaVenta, av.idProspecto, av.idProyecto, p.nombre, p.apellidoP, p.apellidoM, p.telefono, p.celular, p.email, e.fechaEntrega, e.statusEntrega
                                    FROM entrega AS e INNER JOIN alta_venta AS av ON av.id = e.idAltaVenta
                                    INNER JOIN prospectos AS p ON p.id = av.idProspecto
                                    WHERE e.statusEntrega = 1 AND e.fechaEntrega <> '' AND e.fechaEntrega >= '$fecha' AND e.fechaEntrega < '2021-10-13'
                                    ");

        if($query->num_rows() > 0){
            foreach($query->result() as $row){

                $telefono = $row->telefono;
                $type = '5';
                $data['idProyecto'] = $row->idProyecto;
                $data['tipo'] = 'entregado';
                $data['idProspecto'] = $row->idProspecto;
                $data['via'] = 'whatsapp';
                $data['enviado'] = 1;
                $data['status'] = 1;
                $data['created'] = date("Y-m-d H:i:s");
                $data['updated'] = date("Y-m-d H:i:s");

                $url = $this->f."sistema/cronjob/notificaciones_etapas/".$data['idProyecto']."/".$type."/1";

                $arrayConf['url'] = $url; //set url
                $arrayConf['filename'] = $data['idProyecto'].'_'.$data['idProspecto'].'.png'; //set file name
                $arrayConf['width'] = 600; // set width
                $arrayConf['height'] = 1100; // set height
                $arrayConf['diruploads'] = $this->data['fotos_www']; // set dir uploads

                $this->phantomcapture->initialize($arrayConf);
                $valid = $this->phantomcapture->captureit();

                sleep(5);

                if(!$this->appProduction){
                    $telefono = '9851045678';
                }

                $insertDataWhatsapp = $data;
                $dataSendWhatsapp['to'] = '521'.$telefono;
                $dataSendWhatsapp['message2'] = leyendaNotifWhatsapp($type);
                $dataSendWhatsapp['message'] = new CURLFile($this->data['fotos_www'].'/'.$data['idProyecto'].'_'.$data['idProspecto'].'.png', mime_content_type($this->data['fotos_www'].'/'.$data['idProyecto'].'_'.$data['idProspecto'].'.png'));
                $dataSendWhatsapp['key'] = $this->keyActive;

                $this->sendWhatsappImage($insertDataWhatsapp, $dataSendWhatsapp);

                $response = 1;

            }
        }

        if($response){
            echo "Se han enviado las notificaciones de entrega correctamente";
        }else{
            echo "Ocurrio un error al enviar las notificaciones";
        }
    }

}