<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Creator extends MX_Controller {
	public $data,$vParameters,$mainView,$fv;
	public function __construct(){
        $this->nsession = $this->config->item('nsession');
        if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'creator'; // form validation variable
            $this->mainView = 'creator';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/creator/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '';
            
            // Tools
            $this->load->helper(array('tools','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('musuario','mdetallepaquete','mproyecto','mprototipos','mfraccionamiento',
			'mpresupuestomo','mpresupuestomat','mmateriales','mempresas','mcreator','mconstructores','mpresupuestos',
            'mestimacionprograma','mestimacionesprograma','mactividadesprototipo','mestimadosprograma','mavanceobra',
            'mpaquete','mpaquetepresupuesto','marranque','mmanoobra'
        ));
            // Lbrerias
           	$this->data['fotos_www'] = $this->config->item('base_www').'/creator/';
            //Validación de usuarios
            valSession("costos",$this->fv);
    }

	public function index(){
		$data['q'] = '';
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

    public function listado(){
        $q = $this->mcreator->getAll();

        if (!is_numeric($q)){
            foreach ($q->result() as $row){
                if($row->estatus == 3){
                    $borrar=$editar=false;
                }else{
                    $borrar=$editar=true;
                }
                $paquetes=$this->db->query("SELECT GROUP_CONCAT(titulo) paqs FROM paquetes WHERE FIND_IN_SET(id,'$row->idPaquetes') ");
                $array['aaData'][] = array(
                    'id' => $row->id,
                    'idEmpresa' => $this->mempresas->getCampo("titulo",$row->idEmpresa),
					'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo',$row->idFraccionamiento),
                    'idArranque' => $this->marranque->getCampo("titulo",$row->idArranque),
                    'paquetes' => ($paquetes->num_rows() > 0) ? $paquetes->row()->paqs : "",
					'titulo' => $row->titulo,
					'estatus' => $this->getStatus($row->estatus),
                    'acciones' => acciones($row->id,$this->router->class,false,$editar,$borrar)
                    );
            }
        } else{
            $array['aaData']=[];
        }
        echo json_encode($array);
    }

    public function getStatus($index){
        $estatus=[
            0 => "Pendiente",
            1 => "Pendiente",
            2 => "Sin Guardar",
            3 => "Finalizado",
        ];
        return $estatus[$index];
    }

    public function nuevo(){
        // Mensajes
        $data['msg'] = '';

        $this->load->library('form_validation');
        if ($this->form_validation->run($this->fv) == FALSE) {
            $data['msg'] = validation_errors();
			$data['empresas']= $this->mempresas->getAll();
			$data['fraccionamientos'] = $this->mfraccionamiento->getAll();
            $this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
            $this->load->view('templates/main_template', $this->data);
        } else {
			$pData['idEmpresa'] = $this->input->post('idEmpresa', TRUE);
			$pData['idFraccionamiento'] = $this->input->post('idFraccionamiento', TRUE);
            $pData['titulo'] = $this->input->post('titulo', TRUE);
            $pData['status'] = 1;
            $id = $this->mcreator->insertar($pData);
            redirect($this->router->class."/agregar/".$id);
        }
    }

    public function editar($id){
        // Mensajes
        $msg = '';
        /* VALIDAR FORMULARIO*/
        $this->load->library('form_validation');

        if (isset($_POST['titulo'])) {
            if ($this->form_validation->run($this->fv) == FALSE) {
                $msg = validation_errors();
            } else {
                $pData['idFraccionamiento'] = $this->input->post('idFraccionamiento', TRUE);
                $pData['titulo'] = $this->input->post('titulo', TRUE);
                $pData['status'] =$this->input->post('status',TRUE);

                $this->mcreator->actualizar($pData, $id);
				redirect($this->router->class."/agregar/".$id);
            }
        }
        // Obteniendo la información
        $info = $this->mcreator->getById($id);

        $data = $info;
        $data['empresas']= $this->mempresas->getAll();
        $data['fraccionamientos'] = $this->mfraccionamiento->getAll();
        $data['msg']=$msg;
        $this->data['contenido'] = $this->load->view($this->mainView . '/editar_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

	public function agregar($id){
        $data=$creator=$this->mcreator->getById($id);
        if($creator["estatus"] < 3){
            $data['msg']="";
            $data["idCreator"]=$id;
            $data["empresa"]=$this->mempresas->getById($data["idEmpresa"]);
            $data["fraccionamiento"]=$this->mfraccionamiento->getById($data["idFraccionamiento"]);
            $data["manzanas"]=$this->mcreator->getManzanas($data["idFraccionamiento"]);
            $this->data['contenido'] = $this->load->view($this->mainView . '/agregar_view', $data, true);
            $this->load->view('templates/main_template', $this->data);
        }else{
            redirect($this->router->class);
        }
    }

	public function resumen($id){
        $creator=$this->mcreator->getById($id);
        if($creator["estatus"] < 3){
            if(isset($_POST["lotes"])){
                $this->mcreator->actualizar(["estatus"=>2],$id);
                $lotes=$_POST["lotes"];
                $lotes=implode(",",$lotes);
                $data=[];
                $data["idCreator"]=$id;
                $data["empresa"]=$this->mempresas->getById($creator["idEmpresa"]);
                $data["fraccionamiento"]=$this->mfraccionamiento->getById($creator["idFraccionamiento"]);
                $data['supervisores'] =$this->db->query("SELECT id,CONCAT(nombre,' ',apellidoP,' ',apellidoM) titulo FROM usuarios WHERE rol=9 AND status=1"); 
                $data['constructores'] = $this->mconstructores->getSelectResult();
                $data["paqs"]=$this->mcreator->getPaquetes($creator["idEmpresa"],$creator["idFraccionamiento"],$lotes);
                $this->data['contenido'] = $this->load->view($this->mainView . '/resumen_view', $data, true);
                $this->load->view('templates/main_template', $this->data);
            }else{
                redirect("creator/agregar/".$id);
            }
        }else{
            redirect($this->router->class);
        }
	}

    public function detalle($id){
        $creator=$this->mcreator->getById($id);
        if($creator["estatus"] < 3){
            if(isset($_POST["data"])){
                $_SESSION[$this->nsession][$id]=$_POST;
                $data=[];
                $data=$_POST;
                $data["idCreator"]=$id;
                $data["empresa"]=$this->mempresas->getById($creator["idEmpresa"]);
                $data["fraccionamiento"]=$this->mfraccionamiento->getById($creator["idFraccionamiento"]);
                $data['supervisores'] =$this->db->query("SELECT id,CONCAT(nombre,' ',apellidoP,' ',apellidoM) titulo FROM usuarios WHERE rol=9 AND status=1"); 
                $data['constructores'] = $this->mconstructores->getSelectResult();
                $this->data['contenido'] = $this->load->view($this->mainView . '/detalle_view', $data, true);
                $this->load->view('templates/main_template', $this->data);
            }
        }else{
            redirect($this->router->class);
        }
    }

    public function crear($id){
        $creator=$this->mcreator->getById($id);
        if($creator["estatus"] < 3){
            $_SESSION[$this->nsession]["idEmpresa"]=$creator["idEmpresa"];
            require("Pmo.php");
            $pmo=new Pmo();
            require("Pmat.php");
            $pmat=new Pmat();
            if(isset($_SESSION[$this->nsession][$id])){
                $info=$_SESSION[$this->nsession][$id];
                $paqs=[];
                foreach ($info["data"] as $row) {
                    //creacion de pptomo
                    $dataPmo['idFraccionamiento'] = $creator["idFraccionamiento"];
                    $dataPmo['idPrototipo'] = $row["idPrototipo"];
                    $dataPmo['idPresupuesto'] = $row["idPresupuesto"];
                    $dataPmo['titulo'] = $row["nombre"]." ".date("d-m-Y");
                    $dataPmo['status'] = 1;
                    $idManoObra=$pmo->pptoByPrototipo($dataPmo);
                    //creación de paquete
                    $idPaquete=$this->crearPaq($row,$idManoObra);
                    array_push($paqs,$idPaquete);
                    //creacion de pptomat
                    $datapmat['idFraccionamiento'] = $creator['idFraccionamiento'];
                    $datapmat['idPrototipo'] = $row['idPrototipo'];
                    $datapmat['idPaquete'] = $idPaquete;
                    $datapmat['idEmpresa'] = $creator['idEmpresa'];
                    $datapmat['idPresupuesto'] = $row['idPresupuesto'];
                    $datapmat['status'] = 1;
                    $idMaterial=$pmat->pptoByPrototipo($datapmat);
                    //creacion de estimaciones
                    $this->crearEstimaciones($idPaquete);
                }
                //creacion de arranque
                $idArranque=$this->crearArranque($id,$info,$paqs);
                $this->mcreator->actualizar(["idArranque"=>$idArranque,"idPaquetes"=>implode(",",$paqs),"estatus"=>3],$id);
                redirect("arranque/ver/".$idArranque);
            }else{
                echo "no existe";
            }
        }else{
            redirect($this->router->class);
        }
    }

    public function crearArranque($id,$info,$paqs){
        $creator=$this->mcreator->getById($id);
        $pData['titulo'] = $info["titulo"];
        $pData['idSupervisor'] = 0;
        $pData['retencionfg'] = $info["fg"];

        if (is_array($paqs) && !empty($paqs) && count($paqs)>0){
            $pData['idPaquetes'] = implode(",",$paqs);
        }
        $fraccionamiento = $this->mfraccionamiento->getCampo("titulo", $creator["idFraccionamiento"]);

        $this->db->query("UPDATE paquetes SET porcentaje_retencion=".$pData['retencionfg']." WHERE id IN (".$pData['idPaquetes'].")");
        $pData['status'] = 1;
        $pData['estatus_arranque'] = 1;
        $pData['ronda'] = 0;
        $pData['tipoAlmacen'] = $info["tipoAlmacen"];
        $pData['idEmpresa'] = $creator["idEmpresa"];
        $pData['fecha_fin']=date("Y-m-d");
        $pData['fechaFirma']=date("Y-m-d");
        $idArranque = $this->marranque->insertar($pData);
        $uData['numeroContrato'] = strtoupper(substr($fraccionamiento, 0, 3) ) . date('d', strtotime(date("Y-m-d"))) . date('m', strtotime(date("Y-m-d"))) . substr(date('Y', strtotime(date("Y-m-d"))), -2) . '-' . $id;
        $this->marranque->actualizar($uData, $id);
        return $idArranque;
    }
    
    public function crearEstimaciones($idPaquete){
        $debug=false;
        //try {
            $this->db->trans_begin();
            $pData['idPaquete'] = $idPaquete;
            $pData['status'] = 1;
            $id = $this->mestimacionprograma->insertar($pData);
            if(is_numeric($id)){
                $idManoObra = $this->mpaquete->getCampo('idManoObra', $pData['idPaquete']);
                $eData['idEstimacion'] = $id;
                $idPrototipo=$this->mmanoobra->getCampo("idPrototipo",$idManoObra);
                $contar = $this->mprototipos->getCampo("estimaciones",$idPrototipo);
                $fecha_inicio = new DateTime($this->mpaquete->getCampo('fecha_inicio', $pData['idPaquete']));
                $intervalo = new DateInterval('P7D');
                // Aqui empieza el guardado de las estimaciones en base al prototipo
                for ($i=1; $i <= $contar; $i++) {
                    $eData['nEstimacion'] = $i;
                    $eData['tipo'] = 1;
                    $eData['fecha'] = $fecha_inicio->format('Y-m-d');
                    //aqui se suma la semana
                    $fecha_inicio->add($intervalo);
                    $idE = $this->mestimacionesprograma->insertar($eData);
                    if($idE > 0){
                        //Aqui empieza el guardado de estimados por estimaciones (Estimacion 1, estimacion 2, etc.)
                        $qCatProt = $this->mactividadesprototipo->getCategoriasByManoObra($idManoObra);
                        if(!is_numeric($qCatProt)){
                            foreach ($qCatProt->result() as $CategoriaProt) {
                                $qActProt = $this->mactividadesprototipo->getAllByManoObraCategoria($idManoObra, $CategoriaProt->idCategoria);
                                if(!is_numeric($qActProt)){
                                    foreach ($qActProt->result() as $ActividadProt) {
                                        $qPresupuesto = $this->mpresupuestomo->getByidManoObraIdActividadPrototipo($idManoObra, $ActividadProt->id);
                                        if(!is_numeric($qPresupuesto)){
                                            $esData['idEstimaciones'] = $idE;
                                            $esData['idPresupuesto'] = $qPresupuesto['id'];
                                            $esData['estimacion'] = 0;//'Mon_0 Tue_0 Wed_0 Thu_0 Fri_0 Sat_0';
                                            $idE2 = $this->mestimadosprograma->insertar($esData);
                                            $avData['idEstimado'] = $idE2;
                                            $idA = $this->mavanceobra->insertar($avData);
                                        }
                                    }
                                }
                                else{
                                    echo ($debug) ? "qActProt : $CategoriaProt->idCategoria <br>" : '';
                                    $fallo = false;
                                }
                            }
                        }
                        else{
                            echo ($debug) ? 'qCatProt<br>' : '';
                            $fallo = false;
                        }
                    }
                    else{
                        echo ($debug) ? 'idEstimacion<br>' : '';
                        $fallo = false;
                    }
                }
            }
            if ($this->db->trans_status() === FALSE){
                echo ($debug) ? 'Rollback<br>' : '';
                $this->db->trans_rollback();
            }
            else{
                echo ($debug) ? 'Fallo'.strval($fallo).'<br>' : '';
                if(!isset($fallo)){
                    $this->db->trans_commit();
                }
                else{
                    echo ($debug) ? 'Rollback2<br>' : '';
                    $this->db->trans_rollback();
                }
            }
        /*}
        catch (\Exception $e)
        {
            if ($this->db->trans_status() === FALSE){
                $this->db->trans_rollback();
                die($e->getMessage());
            }
        }*/
    }

    public function crearPaq($row,$idManoObra){
        $pData['titulo'] = $row["titulo"];
        $pData['idManoObra'] = $idManoObra;
        $pData['idConstructor'] = $row["idConstructor"];
        $lotes = explode(",",$row["lotes"]);

        $fechaInicio = $row["fecha_inicio"];
        $fechaInicio = str_replace('/', '-', $fechaInicio);
        $pData['fecha_inicio'] = ($fechaInicio!='')?date('Y-m-d', strtotime($fechaInicio)):null;
        
        $fechaFin = $row["fecha_fin"];
        $fechaFin = str_replace('/', '-', $fechaFin);
        $pData['fecha_fin'] = ($fechaFin!='')?date('Y-m-d', strtotime($fechaFin)):null;
        $pData['anticipo'] = 0;
        $pData['tipo'] = 0;
        $pData['tipoLote'] = 1;
        $pData['tipoEstimacion'] = 1;
        $pData['status'] = 1;
        $pData['statusPaquete'] = 1;

        foreach($lotes as $lote){
            $existe = $this->mproyecto->getById($lote);
            if(!is_numeric($existe)){
                $lt = $existe['lote'];
                $manzana = $existe['manzana'];
                $lotesProyecto = $this->mdetallepaquete->getByIdProyecto($lote);
                if ( $pData['tipo'] == 1 ){
                    if( (is_numeric($lotesProyecto) ) ){
                        $arrMZ[$manzana][] = $lt;
                    }
                }
            }
        }

        $pData['rango_lotes'] = $row["rangoLotes"];
        $idPaquete = $this->mpaquete->insertar($pData);
        $nLotes=0;
        foreach($lotes as $lote){
            $dData['idPaquete'] = $idPaquete;
            $dData['idProyecto'] = $lote;
            $dData['idResidente'] = $row["idSupervisor"];
            $dData['statusAsignado'] = 0;
            $dData['status'] = 1;

            $idDetalle = $this->mdetallepaquete->insertar($dData);
            $nLotes++;
        }
        $this->mpaquete->actualizar(["nLotes"=>$nLotes],$idPaquete);

        $qPresupuestos = $this->mpresupuestomo->getByIdManoObra($pData['idManoObra']);
        if(!is_numeric($qPresupuestos)){
            foreach($qPresupuestos->result() as $pmo){
                $ppData['idPaquete'] = $idPaquete;
                $ppData['idPresupuestoMO'] = $pmo->id;
                $ppData['lotesCompletados'] = 0;
                $idPackPresu = $this->mpaquetepresupuesto->insertar($ppData); 
            }
        }
        return $idPaquete;
    }

}