<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Constructores extends MX_Controller {
	public $data,$vParameters,$mainView,$fv;
	public function __construct(){
	$this->nsession = $this->config->item('nsession');
    if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'constructores'; // form validation variable
            $this->mainView = 'constructores';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/constructores/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mconstructores','musuario','mpaquete'));
            $this->config->set_item('rol', $_SESSION[$this->nsession]['rol']);
            // Lbrerias
            // $this->load->library(array('email','session'));
           	//$this->data['fotos_www'] = $this->config->item('base_www').'/inicio/';
           // $this->data['fotos_www'] = '/home/puntapro/www/uploads/inicio/';

           //Validación de usuarios
            valSession("obra",$this->fv);
    }

	public function index(){
		$data['q'] = '';
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

    public function listado(){
        $q = $this->mconstructores->getAll();
        if (!is_numeric($q)){
            foreach ($q->result() as $row){
                $array['aaData'][] = array(
                    'nombre' => $row->nombre.' '.$row->apellidoP.' '.$row->apellidoM,
                    'retencion' => $row->retencion,
                    'tipoConstructor' => tipoConstructor($row->tipoConstructor),
                    'acciones' => (in_array($_SESSION[$this->nsession]['rol'], permisos("obra","constructores")['w']))? accionesCatalogosContObra($row->id,$this->router->class,false, true, true) : ''
                );
            }
        } else{
            $array['aaData'][] = array(
                'nombre' => 'No hay registros',
                'retencion' => 'No hay registros',
                'tipoConstructor' => 'No hay registros',
                'acciones' => 'No hay registros'
                );

        }
        echo json_encode($array);
    }

    public function nuevo()
    {
        // Mensajes
        $data['msg'] = '';
        $this->load->library('form_validation');
        if ($this->form_validation->run($this->fv) == FALSE) {
            $data['msg'] = validation_errors();
            $data['paquetes']= $this->mpaquete->getSelectResult();

            $this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
            $this->load->view('templates/main_template', $this->data);
        } else {
            $pData['nombre'] = $this->input->post('nombre', TRUE);
            $pData['apellidoP'] = $this->input->post('apellidoP', TRUE);
            $pData['apellidoM'] = $this->input->post('apellidoM', TRUE);
            $pData['retencion'] = $this->input->post('retencion', TRUE);
            $pData['tipoConstructor'] = $this->input->post('tipoConstructor', TRUE);
            $pData['rfc'] = $this->input->post('rfc', TRUE);
            $pData['domicilioFiscal'] = $this->input->post('domicilioFiscal', TRUE);
            $pData['status'] = 1;
            $id = $this->mconstructores->insertar($pData);
            redirect($this->router->class);
        }

    }

    public function editar($id)
    {
        // Mensajes
        $msg = '';
        /* VALIDAR FORMULARIO*/
        $this->load->library('form_validation');

        if (isset($_POST['nombre'])) {
            if ($this->form_validation->run($this->fv) == FALSE) {
                $msg = validation_errors();
            } else {
                $pData['nombre'] = $this->input->post('nombre', TRUE);
                $pData['apellidoP'] = $this->input->post('apellidoP', TRUE);
                $pData['apellidoM'] = $this->input->post('apellidoM', TRUE);
                $pData['retencion'] = $this->input->post('retencion', TRUE);
                $pData['tipoConstructor'] = $this->input->post('tipoConstructor', TRUE);
                $pData['rfc'] = $this->input->post('rfc', TRUE);
                $pData['domicilioFiscal'] = $this->input->post('domicilioFiscal', TRUE);
                $pData['status'] =$this->input->post('status',TRUE);
                $this->mconstructores->actualizar($pData, $id);
                redirect($this->router->class."?close");
            }
        }
        // Obteniendo la información
        $info = $this->mconstructores->getById($id);
        $data = $info;
        $data['msg']=$msg;
        $this->data['contenido'] = $this->load->view($this->mainView . '/editar_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }


    public function ver($id = null){
        $info = $this->mconstructores->getById($id);
        $data = $info;
        $this->data['contenido'] = $this->load->view($this->mainView . '/ver_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function eliminar(){
        $id = $this->input->post('elid');
        $q = $this->mconstructores->getById($id);
        $cValor = "true";
        $valorBorrar = $this->mconstructores->borrar($id);
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }
    
    public function cambiaStatus(){
        $id = $this->input->post('elid');
        $pData['status'] = 0;
        $q = $this->mconstructores->getById($id);
        $cValor = "true";
        $this->mconstructores->actualizar($pData, $id);
        //$valorBorrar = $this->munidades->borrar($id);
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }
}


