<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class compra extends MX_Controller {
    public $data,$vParameters,$mainView,$fv;
    public function __construct(){
    $this->nsession = $this->config->item('nsession');
    if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'orden_compra'; // form validation variable
            $this->mainView = 'compra';
            $this->data['fjs'] = '';
            $this->data['js'] = ' 
                                  <script src="assets/js/compra/listado.js" type="text/javascript"></script>
                                  <script src="assets/js/compra/listadoDetalle.js" type="text/javascript"></script>
                                  <script src="assets/js/compra/listadoEditar.js" type="text/javascript"></script>
                                  <script src="assets/js/compra/listadoVer.js" type="text/javascript"></script>'
                                  ;
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mcompra', 'mdetallecompra', 'mrecepcion', 'mdetallerecepcion',
                                      'musuario','mproveedor','mordencompra','malmacenes','mempresas'));
            $this->load->library("curl");
            valSession("materiales",$this->fv);
    }

    public function index(){
        $data['q'] = '';
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
    }

    public function excel(){
              $q = $this->mcompra->getAllExcelRows();
       $columnas = array(
                    0 => 'ORDEN COMPRA',
                    1 => 'PROVEEDOR',
                    2 => 'ALMACEN',
                    3 => 'MONEDA',
                    4 => 'FECHA',
                    5 => 'FOLIO',
                    6 => 'IMPORTE',
                    7 => 'NO.ARTICULOS',
                    8 => 'FECHA ENTREGA',
                    9 => 'ESTATUS',
        );
       crearExcel($q,'compra',$columnas);
    }



    public function listadoVer()
    {
        
        $q = $this->mdetallecompra->getAll();

        if (!is_numeric($q)){
            foreach ($q->result() as $row){
                $array['aaData'][] = array(
                'id_compra' => $row->id_compra,
                'id_articulo' => $row->id_articulo,
                'clave_articulo' => $row->clave_articulo,
                'unidades' => $row->unidades,
                'precio_unitario' => $row->precio_unitario,
                'descuento_art' => $row->descuento_art,
                );
            }
        } else{
            $array['aaData'][] = array(
                'id_compra' => 'No hay registros',
                'id_articulo' => 'No hay registros',
                'clave_articulo' => 'No hay registros',
                'unidades' => 'No hay registros',
                'precio_unitario' => 'No hay registros',
                'descuento_art' => 'No hay registros',
                );

        }
      
     
        echo json_encode($array);
    }

    public function ver($id = null)
    {   
        $data='';
        $info =  $this->mdetallecompra->getById($id);

        $data['id_compra'] = $info['id_compra'];
        $data['id_articulo'] = $info['id_articulo'];
        $data['clave_articulo'] = $info['clave_articulo'];
        $data['unidades'] = $info['unidades'];
        $data['precio_unitario'] = $info['precio_unitario'];
        $data['descuento_art'] = $info['descuento_art'];
 
    /*    echo '<pre>';  print_r($info); exit();*/


   /*     $id_proveedor = $info['id_proveedor'];
        $id_almacen = $info['id_almacen'];
        $nomProveedor = $this->mproveedor->getCampo('nombre', $id_proveedor);
        $nomAlmacen = $this->malmacenes->getCampo('nombre', $id_almacen);

        $data['id_orden_compra'] =   $info['id_orden_compra'];
        $data['nomProveedor'] =   $nomProveedor;
        $data['nomAlmacen'] =   $nomAlmacen;
        $data['moneda'] =   $info['id_moneda'];
        $data['folio'] =   $info['folio'];
        $data['fecha'] =   $info['fecha'];
        $data['importe'] =   $info['importe_neto'];
        $data['articulos'] =   $info['numero_articulos'];
        $data['fechaEnt'] =   $info['fecha_entrega'];
        $data['estatus'] =   $info['estatus'];
      */

        $this->data['contenido'] = $this->load->view($this->mainView . '/ver_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
        
    }


    public function listado(){
        $list = $this->mcompra->get_datatables();
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $comp) {
           /* $ordenCompra = $this->mordencompra->getCampo('descripcion',$comp->id_orden_compra);*/
            $nomProveedor = $this->mproveedor->getCampo('nombre',$comp->id_proveedor);
            $nomAlmacen = $this->malmacenes->getCampo('nombre',$comp->id_almacen);
            $acciones = acciones($comp->id, $this->router->class, true,false,false);
/*
            echo $p; exit();*/

            $no++;
            $row = array();
            //$row[] = $no;
            $row[] = $acciones;
            $row[] = $comp->id_orden_compra;
            $row[] = $nomProveedor;
            $row[] = $nomAlmacen;
            $row[] = $comp->id_moneda;
            $row[] = date_format(new DateTime($comp->fecha),'d/m/Y');
            $row[] = ($comp->folio !='' ||$comp->folio != null )?$comp->folio:'';
            $row[] = ($comp->importe_neto !='' ||$comp->importe_neto != null )?$comp->importe_neto:''; ;
            $row[] = ($comp->numero_articulos !='' ||$comp->numero_articulos != null )?$comp->numero_articulos:'';
            $row[] = ($comp->fecha_entrega !='')?date_format(new DateTime($comp->fecha_entrega),'d/m/Y') :'';
            $row[] = $comp->estatus;

            $data[] = $row;
        }

        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->mcompra->count_all(),
                        "recordsFiltered" => $this->mcompra->count_filtered(),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);
    }


    public function updateWS($idOrden){
        ini_set('max_execution_time', 0);
        $curl = curl_init();
        //INFORMACION A ENVIAR POR POST EN FORMATO JSON
        $idEmpresa = $this->mordencompra->getCampo('idEmpresa', $idOrden);
        $idUsuario = $_SESSION["viv"]['id'];
        $datos=array('un' => $idEmpresa, 'id_orden_compra' => $idOrden);
        $datos = json_encode($datos);
        $time_start = microtime(true);
        
        curl_setopt_array($curl, array(
            CURLOPT_PORT => $this->config->item('portmicro'),
            CURLOPT_URL => $this->config->item('dnsmicro')."GetOrdenCompra",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 3600,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_FOLLOWLOCATION => 1,
            CURLOPT_POSTFIELDS => $datos,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "postman-token: ab5bf890-47c6-d504-ba8f-82667b58bebd",
                'Content-Type:application/json'
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);

        $json = [];
        if ($err) {
            echo "CURL Error #:" . $err;
            $time_end = microtime(true);
            $time = $time_end - $time_start;
            $dataL['time'] = $time;
            $dataL['idEmpresa'] = $idEmpresa;
            $dataL['nombreTabla'] = 'compra';
            $dataL['funcion'] = 'GetOrdenCompra';
            $dataL['http_code'] = 0;
            $dataL['insertados'] = 0;
            $dataL['actualizados'] = 0;
            $dataL['totalRegistros'] = 0;
            $dataL['json'] = "CURL Error #:" . $err;
            $dataL['created_by'] = $idUsuario;
            $dataL['updated_by'] = $idUsuario;
            $dataL['created'] = date("Y-m-d H:i:s");
            $dataL['updated'] = date("Y-m-d H:i:s");
            $this->db->insert('logs_ws', $dataL);
            $dataL['nombreTabla'] = 'recepcion';
            $this->db->insert('logs_ws', $dataL);
        }else{
            $json = $response;
            // Comprueba el código de estado HTTP
            if (!curl_errno($curl)) {
              switch ($http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE)) {
                case 200:
                    //Contadores de prueba
                    $nInsert=0;
                    $nUpdate=0;
                    $nTotal=0;
                    $nInsert2=0;
                    $nUpdate2=0;
                    $nTotal2=0;
                    $nInsert3=0;
                    $nUpdate3=0;
                    $nInsert4=0;
                    $nUpdate4=0;
                    $data="";
                    //Objeto de respuesta
                    $json = json_decode($json);
                    //Recorre objeto stdClass
                    foreach ($json->object_result as $k => $row) {
                        //Recorre ordenes de compra(orden_compra)
                        foreach ($row as $key => $val) {
                            switch ($k) {
                                case 'compra':
                                    //Recorre listado de compra
                                    foreach ($row as $key2 => $val2){
                                        switch ($key2) {
                                            case 'lista_articulos':
                                                //Recorre listado de articulos(detalle_orden)
                                                foreach ($val2 as $row3) {
                                                    foreach ($row3 as $key3 => $val3){
                                                        switch ($key3) {
                                                            case 'id_orden_compra':
                                                                $data3['id_compra']=$val3;
                                                                break;
                                                            default:
                                                                $data3[$key3]=$val3;
                                                                break;
                                                        }
                                                    }
                                                }
                                                //Validaciones de sincronizacion de detalle orden
                                                if($this->mdetallecompra->valInsert($data3['id'])){
                                                    $this->mdetallecompra->insertar($data3);
                                                    $nInsert3++;
                                                }else if($this->mdetallecompra->valUpdate($data3['id'],$data3)){
                                                    $this->mdetallecompra->actualizar($data3,$data3['id']);
                                                    $nUpdate3++;
                                                }
                                                break;
                                            default:
                                                $data[$key2]=$val2;
                                                break;
                                        }
                                    }
                                    //Validaciones de sincronizacion de compra
                                    $data['id_orden_compra']=$idOrden;
                                    $data['idEmpresa']=$idEmpresa;
                                    if($this->mcompra->valInsert($data['id'])){
                                        $this->mcompra->insertar($data);
                                        $nInsert++;
                                    }else if($this->mcompra->valUpdate($data['id'],$data)){
                                        $this->mcompra->actualizar($data,$data['id']);
                                        $nUpdate++;
                                    }
                                    $nTotal++;
                                    break;
                                case 'recepcion':
                                    //Recorre listado de recepcion
                                    foreach ($val as $key2 => $val2){
                                        switch ($key2) {
                                            case 'lista_articulos':
                                                //Recorre listado de articulos(detalle_recepcion)
                                                foreach ($val2 as $row4) {
                                                    foreach ($row4 as $key4 => $val4){
                                                        switch ($key4) {
                                                            case 'id_orden_compra':
                                                                $data4['id_recepcion']=$val4;
                                                                break;
                                                            default:
                                                                $data4[$key4]=$val4;
                                                                break;
                                                        }
                                                    }
                                                }
                                                //Validaciones de sincronizacion de detalle recepcion
                                                if($this->mdetallerecepcion->valInsert($data4['id'])){
                                                    $this->mdetallerecepcion->insertar($data4);
                                                    $nInsert4++;
                                                }else if($this->mdetallerecepcion->valUpdate($data4['id'],$data4)){
                                                    $this->mdetallerecepcion->actualizar($data4,$data4['id']);
                                                    $nUpdate4++;
                                                }
                                                break;
                                            default:
                                                $data2[$key2]=$val2;
                                                break;
                                        }
                                    }
                                    //Validaciones de sincronizacion de recepcion
                                    $data2['id_orden_compra']=$idOrden;
                                    $data2['idEmpresa']=$idEmpresa;
                                    if($this->mrecepcion->valInsert($data2['id'])){
                                        $this->mrecepcion->insertar($data2);
                                        $nInsert2++;
                                    }else if($this->mrecepcion->valUpdate($data2['id'],$data2)){
                                        $this->mrecepcion->actualizar($data2,$data2['id']);
                                        $nUpdate2++;
                                    }
                                    $nTotal2++;
                                    break;
                            }
                        }
                    }
                    echo "Insertados en Compra: ".$nInsert." <br> ";
                    echo "Actualizados en Compra: ".$nUpdate." <br> ";
                    echo "Insertados en Recepcion: ".$nInsert2." <br> ";
                    echo "Actualizados en Recepcion: ".$nUpdate2." <br> ";
                    curl_close($curl);
                    unset($json->object_result);
                    $json = json_encode($json);
                    $time_end = microtime(true);
                    $time = $time_end - $time_start;
                    $dataL['time'] = $time;
                    $dataL['idEmpresa'] = $idEmpresa;
                    $dataL['nombreTabla'] = 'compra';
                    $dataL['funcion'] = 'GetOrdenCompra';
                    $dataL['http_code'] = $http_code;
                    $dataL['insertados'] = $nInsert;
                    $dataL['actualizados'] = $nUpdate;
                    $dataL['totalRegistros'] = $nTotal;
                    $dataL['json'] = $json;
                    $dataL['created_by'] = $idUsuario;
                    $dataL['updated_by'] = $idUsuario;
                    $dataL['created'] = date("Y-m-d H:i:s");
                    $dataL['updated'] = date("Y-m-d H:i:s");
                    $this->db->insert('logs_ws', $dataL);
                    $dataL['nombreTabla'] = 'recepcion';
                    $dataL['insertados'] = $nInsert2;
                    $dataL['actualizados'] = $nUpdate2;
                    $dataL['totalRegistros'] = $nTotal2;
                    $this->db->insert('logs_ws', $dataL);
                    redirect($this->mainView);
                    break;
                case 404:
                    echo "Not found";
                    $json = json_decode($json);
                    unset($json->object_result);
                    $json = json_encode($json);
                    $time_end = microtime(true);
                    $time = $time_end - $time_start;
                    $dataL['time'] = $time;
                    $dataL['idEmpresa'] = $idEmpresa;
                    $dataL['nombreTabla'] = 'compra';
                    $dataL['funcion'] = 'GetOrdenCompra';
                    $dataL['http_code'] = $http_code;
                    $dataL['insertados'] = 0;
                    $dataL['actualizados'] = 0;
                    $dataL['totalRegistros'] = 0;
                    $dataL['json'] = $json;
                    $dataL['created_by'] = $idUsuario;
                    $dataL['updated_by'] = $idUsuario;
                    $dataL['created'] = date("Y-m-d H:i:s");
                    $dataL['updated'] = date("Y-m-d H:i:s");
                    $this->db->insert('logs_ws', $dataL);
                    $dataL['nombreTabla'] = 'recepcion';
                    $this->db->insert('logs_ws', $dataL);
                    break;
                default:
                    echo 'Unexpected HTTP code: ', $http_code, "\n";
                    $json = json_decode($json);
                    unset($json->object_result);
                    $json = json_encode($json);
                    $time_end = microtime(true);
                    $time = $time_end - $time_start;
                    $dataL['time'] = $time;
                    $dataL['idEmpresa'] = $idEmpresa;
                    $dataL['nombreTabla'] = 'compra';
                    $dataL['funcion'] = 'GetOrdenCompra';
                    $dataL['http_code'] = $http_code;
                    $dataL['insertados'] = 0;
                    $dataL['actualizados'] = 0;
                    $dataL['totalRegistros'] = 0;
                    $dataL['json'] = $json;
                    $dataL['created_by'] = $idUsuario;
                    $dataL['updated_by'] = $idUsuario;
                    $dataL['created'] = date("Y-m-d H:i:s");
                    $dataL['updated'] = date("Y-m-d H:i:s");
                    $this->db->insert('logs_ws', $dataL);
                    $dataL['nombreTabla'] = 'recepcion';
                    $this->db->insert('logs_ws', $dataL);
              }
            }
        }
    } //

    



}