<?php
    defined('BASEPATH') OR exit('No direct script access allowed');

    class Colocacion extends MX_Controller {
        public $data,$vParameters,$mainView,$fv;

        public function __construct() {
            $this->nsession = $this->config->item('nsession');
            if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'colocacion'; // form validation variable
            $this->mainView = 'colocacion';
            $this->data['fjs'] = '';
            $this->data['js'] = '
                    <script type="text/javascript" src="https://cdn.datatables.net/fixedheader/3.1.3/js/dataTables.fixedHeader.min.js"></script>
                    <script src="assets/js/colocacion/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.16/css/jquery.dataTables.min.css">
                                  <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/fixedheader/3.1.3/css/fixedHeader.dataTables.min.css">';
            // Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mproyecto','mprototipoxfraccionamiento','mprospecto','musuario'));
            $this->config->set_item('rol', $_SESSION[$this->nsession]['rol']);
            // Lbrerias
            $this->load->library('csvimport');
            $this->data['fotos_www'] = $this->config->item('base_www')."csv/";
            // $this->data['fotos_www'] = '/home/puntapro/www/uploads/inicio/';

            // Debugging
            $this->output->enable_profiler(false);

            //Validación de usuarios
            valSession("ventas",$this->fv);
        }

        public function index(){
            $data['q'] = '';
            $data["fraccionamientos"]=$this->musuario->getFraccionamientos();
            $data["promotores"]=$this->musuario->getPromotores();
            $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
            $this->load->view('templates/main_template',$this->data);
        }

        public function getTotal($info){
            $temp=explode("_", $info);
            $total=0;
            if($temp[0] == 0 && $temp[0] != ""){
                $total = $this->mproyecto->getDisponible($info,false,true);
            }else if($temp[0] == -1 && $temp[0] != ""){
                $total = $this->mproyecto->getProspeccion($info,false,true);
            }else{
                $total = $this->mproyecto->getColocacion($info,false,true);
            }
            echo json_encode($total);
        }

        public function export_csv($info=""){
            $this->load->dbutil();
            $this->load->helper('download');

            $query="";
            $temp=explode("_", $info);
            $area=$temp[5];
            if($area=="1"){
                $query = $this->mproyecto->getColocacion($info,true);
            }else if($area=="2"){
                $query = $this->mproyecto->getColocacion2($info,true);
            }

            if(!is_numeric($query)){
                $csv = mb_convert_encoding($this->dbutil->csv_from_result($query, ",", "\n"), "ISO-8859-1", "UTF-8");
                $date=new DateTime();
                $name = "Reporte de colocacion(".$date->format("d-m-Y").").csv";
                force_download($name, $csv);
            }else{
                redirect('colocacion');
            }
        }

        public function listado($info=""){
            $query="";
            $temp=explode("_", $info);
            $area=$temp[5];

            if($area=="1"){
                $query = $this->mproyecto->getColocacion($info);
            }else if($area=="2"){
                $query = $this->mproyecto->getColocacion2($info);
            }

            if ( !is_numeric($query) ) {
                foreach ($query->result() as $row){
                    $fechaProspeccion=($row->fechaProspeccion != "") ? new DateTime($row->fechaProspeccion) : "";
                    $fechaAltaVenta=($row->fechaAltaVenta != "") ? new DateTime($row->fechaAltaVenta) : "";
                    $fechaValidacion=($row->fechaValidacion != "") ? new DateTime($row->fechaValidacion) : "";
                    $fechaGestoria=($row->fechaGestoria != "") ? new DateTime($row->fechaGestoria) : "";
                    $fechaEntregaVivienda=($row->fechaEntregaVivienda != "") ? new DateTime($row->fechaEntregaVivienda) : "";
                    $array['aaData'][] = array(
                        'fraccionamiento' => $row->fraccionamiento,
                        'idPromotor' => $row->idPromotor,
                        'cliente' => $row->cliente,
                        'nss' => $row->nss,
                        'telefono' => $row->telefono,
                        'idLugar' => $row->idLugar,
                        'lote' =>  $row->lote,
                        'manzana' => $row->manzana,
                        'calle' => $row->calle,
                        'nOficial' => $row->nOficial,
                        'idPrototipo' => $row->idPrototipo,
                        'fechaProspeccion' => ($fechaProspeccion != "") ? $fechaProspeccion->format("d-m-Y") : "",
                        'fechaAltaVenta' => ($fechaAltaVenta != "") ? $fechaAltaVenta->format("d-m-Y") : "",
                        'fechaValidacion' => ($fechaValidacion != "") ? $fechaValidacion->format("d-m-Y") : "",
                        'fechaGestoria' => ($fechaGestoria != "") ? $fechaGestoria->format("d-m-Y") : "",
                        'fechaEntregaVivienda' => ($fechaEntregaVivienda != "") ? $fechaEntregaVivienda->format("d-m-Y") : "",
                        'precioVenta' => ($row->precioVenta != "") ? "<div style='text-align:right;margin-right:9px;'>$".number_format($row->precioVenta,2)."</div>" : "",
                        'statusVivienda' => $row->statusVivienda,
                        'statusDtu' => $row->statusDtu,
                        'estatus' => $row->estatus
                        );
                }
            } else{
                $array['aaData'][] = array(
                    'fraccionamiento' => 'No hay registros',
                    'idPromotor' => 'No hay registros',
                    'cliente' => 'No hay registros',
                    'nss' => 'No hay registros',
                    'telefono' => 'No hay registros',
                    'idLugar' => 'No hay registros',
                    'lote' => 'No hay registros',
                    'manzana' => 'No hay registros',
                    'calle' => 'No hay registros',
                    'nOficial' => 'No hay registros',
                    'idPrototipo' => 'No hay registros',
                    'fechaProspeccion' => 'No hay registros',
                    'fechaAltaVenta' => 'No hay registros',
                    'fechaValidacion' => 'No hay registros',
                    'fechaGestoria' => 'No hay registros',
                    'fechaEntregaVivienda' => 'No hay registros',
                    'precioVenta' => 'No hay registros',
                    'statusVivienda' => 'No hay registros',
                    'statusDtu' => 'No hay registros',
                    'estatus' => 'No hay registros'
                );
            }

            echo json_encode($array);
        }
    }
?>