<?php
    defined('BASEPATH') OR exit('No direct script access allowed');

    class Busqueda_vivienda extends MX_Controller {
        public $data,$vParameters,$mainView,$fv;

        public function __construct() {
            $this->nsession = $this->config->item('nsession');
            if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'busqueda_vivienda'; // form validation variable
            $this->mainView = 'busqueda_vivienda';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/busqueda_vivienda/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mproyecto','mprototipoxfraccionamiento','mprospecto','mprototipos','musuario','mfraccionamiento'));
            $this->config->set_item('rol', $_SESSION[$this->nsession]['rol']);
            // Lbrerias
            $this->load->library('csvimport');
            $this->data['fotos_www'] = $this->config->item('base_www')."csv/";
            // $this->data['fotos_www'] = '/home/puntapro/www/uploads/inicio/';

            //Validación de usuarios
            valSession("ventas",$this->fv);
        }

        public function index(){
            $data['q'] = '';
            // $data['prospectos'] = $this->mprospecto->getAllProspectsInAltaVenta();
            $data['prospectos'] = $this->mproyecto->getAllProspectsExistAltaVenta();
            // print_r($data['prospectos']->result()); exit();
            // print_r($data['prospectos']->num_rows()); exit();
            $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
            $this->load->view('templates/main_template',$this->data);
        }

        public function listado(){
            $r['idCliente'] = $_REQUEST['idCliente'];
            $r['nsscliente'] = $_REQUEST['nsscliente'];
            // print_r($r); exit();
            $q = $this->mproyecto->getAllProjectExistAltaVenta($r);
            // print_r($q->result()); exit();
            if ( !is_numeric($q) ) {
                foreach ($q->result() as $row){
                    $array['aaData'][] = array(
                        'fraccionamiento' => $this->mfraccionamiento->getCampo("titulo",$row->idFraccionamiento),
                        'nombCliente' => $this->mprospecto->getCampo('nombre',$row->idProspecto).' '.$this->mprospecto->getCampo('apellidoP',$row->idProspecto),
                        'nss' => $this->mprospecto->getCampo('nss',$row->idProspecto),
                        'titulo' => '<a class="blockui-save" href="proyectos/ver/'.$row->id.'/1">'.$row->lote.'</a>',
                        'manzana' => $row->manzana,
                        // 'prototipo' => $this->mprototipoxfraccionamiento->getCampo("titulo",$row->idPrototipo),
                        'prototipo' => $this->mprototipos->getCampo("nombre",$row->idPrototipo),
                        'precioVenta' => precio_format($row->precioVenta),
                        'avaluo' => precio_format($row->avaluo),
                        'statusVivienda' => estatus_proyecto_reporte($row->statusVenta),
                        'txtstatus' => $row->statusProyecto,
                        'acciones' => acciones($row->id.'/1','proyectos',true, false, false)
                        );
                }
            } else{
                $array['aaData'][] = array(
                    'fraccionamiento' => 'No hay registros',
                    'nombCliente' => 'No hay registros',
                    'nss' => 'No hay registros',
                    'titulo' => 'No hay registros',
                    'manzana' => 'No hay registros',
                    'prototipo' => 'No hay registros',
                    'precioVenta' => 'No hay registros',
                    'avaluo' => 'No hay registros',
                    'statusVivienda' => 'No hay registros',
                    'txtstatus' => 'No hay registros',
                    'acciones' => 'No hay registros'
                    );

            }

            echo json_encode($array);
        }
    }
?>