<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Avaluos extends MX_Controller {
    public $data,$vParameters,$mainView,$fv,$allowed;
    public function __construct(){
    $this->nsession = $this->config->item('nsession');
    if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'avaluos'; // form validation variable
            $this->mainView = 'avaluos';
            $this->data['fjs'] = '';
            $this->data['js'] = '';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mfoliosavaluo','mavaluoproyecto','mproyecto','mfraccionamiento','mprospecto','musuario'));

            // Lbrerias
            $this->load->library(array('csvimport'));
            //$this->data['fotos_www'] = $this->config->item('base_www').'/inicio/';
           // $this->data['fotos_www'] = '/home/puntapro/www/uploads/inicio/';
           $this->allowed=permisos("ventas",$this->fv);
           //Validación de usuarios
	        valSession("ventas",$this->fv);
    }
    //$this->mprospecto->getCampo('nombre',$row->idProspecto)." ".$this->mprospecto->getCampo('apellidoP',$row->idProspecto)
    public function csv(){
        $this->load->dbutil();
        $this->load->helper('download');
        $query=$this->mfoliosavaluo->getCSVFolios();

        if (!is_numeric($query)){
            $csv = mb_convert_encoding($this->dbutil->csv_from_result($query, ",", "\n"), "ISO-8859-1", "UTF-8");
            $date=new DateTime();
            $name = "Avaluos-".$date->format("d-m-Y").".csv";
            force_download($name, $csv);
        }else{
            //redirect('proyectos');
            $data['msgInvalid'] = "No existen registros para exportar";
        }
    }

    public function index(){
        $this->data['js'] .= ' <script src="assets/js/avaluos/listado.js" type="text/javascript"></script>';
        $data['allowed'] = $this->allowed;
        $data['q'] = '';
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
    }

     public function listado(){
        $q = $this->mfoliosavaluo->getAll(0,true);
        if (!is_numeric($q)){
            foreach ($q->result() as $row){
                $estatus = "Pendiente de asignar";
                $fraccionamiento = '';
                $lote = '';
                $mz = '';
                $rowActivo = $this->mavaluoproyecto->getByIdAvaluoActivo($row->id);

                if(!is_numeric($rowActivo)){
                    $estatus = "Activo";
                    $idProyecto = $rowActivo->row()->idProyecto;
                    $lote = $this->mproyecto->getCampo('lote',$idProyecto);
                    $mz = $this->mproyecto->getCampo('manzana',$idProyecto);
                    $idFraccionamiento = $this->mproyecto->getCampo('idFraccionamiento',$idProyecto);
                    $fraccionamiento = $this->mfraccionamiento->getCampo('titulo',$idFraccionamiento);
                }else{
                    $rowInactivo = $this->mavaluoproyecto->getByIdAvaluoInActivo($row->id);
                    if(!is_numeric($rowInactivo)){
                        if($rowInactivo->num_rows()==3){
                            $estatus = "Cancelado";
                            $proyecto = '';
                            $lote = '';
                            $mz = '';
                            $fraccionamiento = '';
                        }else{
                            $estatus = "Pendiente de asignar";
                            $proyecto = '';
                            $lote = '';
                            $mz = '';
                            $fraccionamiento = '';
                        }

                    }
                }

                $array['aaData'][] = array(
                    'titulo' => "<a href='avaluos/historial/$row->id'>".$row->titulo."</a>",
                    'txtstatus' => $estatus,
                    'fraccionamiento' => $fraccionamiento,
                    'fecha' => date('d-m-Y',strtotime($row->created)),
                    'lote' => $lote,
                    'manzana' => $mz,
                    //'txtstatus' => $row->txtstatus,
                    'acciones' => (in_array($this->config->item('rol'), $this->allowed['r'])) ?  acciones($row->id,$this->router->class,false,true,false) : ""

                    );
            }
        }else{
            $array['aaData'][] = array(
                'titulo' => 'No hay registros',
                'txtstatus' => 'No hay registros',
                'fraccionamiento' => 'No hay registros',
                'fecha' => 'No hay registros',
                'lote' => 'No hay registros',
                'manzana' => 'No hay registros',
                //'txtstatus' => 'No hay registros',
                'acciones' => 'No hay registros'
                );

        }

        echo json_encode($array);
    }

    public function listado2(){
        $idAvaluo = $_GET['idAvaluo'];
        $q = $this->mavaluoproyecto->getByIdAvaluo($idAvaluo);

        //$q = $this->mfoliosavaluo->getAll(0,true);
        if (!is_numeric($q)){
            foreach ($q->result() as $row){
                //$rowActivo = $this->mavaluoproyecto->getByIdAvaluoActivo($row->id);
                $folio = $this->mfoliosavaluo->getCampo('titulo',$row->idAvaluo);
                $estatus = ($row->statusAsignacion==1)?"Activo":"Inactivo";
                $idProyecto = $row->idProyecto;
                $lote = $this->mproyecto->getCampo('lote',$idProyecto);
                $mz = $this->mproyecto->getCampo('manzana',$idProyecto);
                $idFraccionamiento = $this->mproyecto->getCampo('idFraccionamiento',$idProyecto);
                $fraccionamiento = $this->mfraccionamiento->getCampo('titulo',$idFraccionamiento);

                $array['aaData'][] = array(
                    'titulo' => $folio,
                    'txtstatus' => $estatus,
                    'fraccionamiento' => $fraccionamiento,
                    'lote' => $lote,
                    'manzana' => $mz,
                    'cliente' => $this->mprospecto->getCampo('nombre',$row->idProspecto)." ".$this->mprospecto->getCampo('apellidoP',$row->idProspecto),
                    'fechaAsignacion' => ($row->fechaAsignacion!='' && $row->fechaAsignacion!='0000-00-00')?date('d/m/Y',strtotime($row->fechaAsignacion)):'',
                    'fechaDesasignacion' => ($row->fechaDesasignacion!='' && $row->fechaDesasignacion!='0000-00-00')?date('d/m/Y',strtotime($row->fechaDesasignacion)):'No Aplica',//$row->fechaDesasignacion,
                    //'txtstatus' => $row->txtstatus,
                    'acciones' => (in_array($this->config->item('rol'), $this->allowed['r'])) ?  acciones($row->id,$this->router->class,false,true,false) : ""

                    );
            }
        }else{
            $array['aaData'][] = array(
                'titulo' => 'No hay registros',
                'txtstatus' => 'No hay registros',
                'fraccionamiento' => 'No hay registros',
                'lote' => 'No hay registros',
                'manzana' => 'No hay registros',
                'cliente' => 'No hay registros',
                'fechaAsignacion' => 'No hay registros',
                'fechaDesasignacion' => 'No hay registros',
                'acciones' => 'No hay registros'
                );

        }

        echo json_encode($array);
    }

    public function historial($id=null){
        $this->data['js'] .= ' <script src="assets/js/avaluos/historial.js" type="text/javascript"></script>';
        $data['msg'] = '';
        $data['idAvaluo'] = $id;
        $this->data['contenido'] = $this->load->view($this->mainView . '/historial_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function nuevo()
    {
        // Mensajes
        $data['msg'] = '';

        $this->load->library('form_validation');
        if ($this->form_validation->run($this->fv) == FALSE) {
            $data['msg'] = validation_errors();

            $this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
            $this->load->view('templates/main_template', $this->data);
        } else {
           /* $pData['idActivo'] = 1;*/

            $pData['titulo'] = $this->input->post('titulo', TRUE);
            /*print_r ($pData);
            exit();
*/         /*   $pData['inventarioInterno'] = $this->input->post('inventarioInterno', TRUE);*/
            $pData['status'] = 1;
            $id = $this->mfoliosavaluo->insertar($pData);
            redirect($this->router->class);
        }

    }

    public function editar($id)
    {
        // Mensajes
        $msg = '';
        /* VALIDAR FORMULARIO*/
        $this->load->library('form_validation');

        if (isset($_POST['titulo'])) {
            if ($this->form_validation->run($this->fv) == FALSE) {
                $msg = validation_errors();
            } else {
                $pData['titulo'] = $this->input->post('titulo', TRUE);
               /* $pData['inventarioInterno'] = $this->input->post('inventarioInterno', TRUE);
                $pData['status'] =$this->input->post('status',TRUE);*/
                $this->mfoliosavaluo->actualizar($pData, $id);
                redirect($this->router->class."?close");
            }
        }
        // Obteniendo la información
        $info = $this->mfoliosavaluo->getById($id);
      /*  print_r($info);
        exit()*/
        $data = $info;
        $data['msg']=$msg;
        $this->data['contenido'] = $this->load->view($this->mainView . '/editar_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function eliminar(){
        $id = $this->input->post('elid');
        $q = $this->mfoliosavaluo->getById($id);
        $cValor = "true";
        $this->mfoliosavaluo->borrar($id);
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }


}


