<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Auth2 extends MX_Controller {
	var $client_service = "frontend-client";
	var $auth_key = "3b947a0da97d6ee317ff5f6d26665e14";
    public function __construct(){
		// Tools
		$this->load->helper(array('tools','numeros','url','form','date','text','security'));
		// Modelos
		$this->load->model(array('mareas','mpuestos','mpostulaciones'));
	}

	public function getAreas(){
		$method = $_SERVER['REQUEST_METHOD'];

		if($method != 'POST'){
			json_output(400,array('status' => 400,'error' => 'Solicitud incorrecta.','config'=> array('excuse' => true,'retry'=>false,'logout' => true)));
		} else {
			$params = $_POST;		
			if(isset($params['key']) && $params['key'] == $this->auth_key ){
				$auth=true;
				if( $auth ) {
					$response = $this->db->query("SELECT idArea,ar.titulo FROM puestos pu
					LEFT JOIN areas ar ON ar.id=pu.idArea
					WHERE pu.statusChatbot=1 GROUP BY pu.idArea");
					if ($response->num_rows()>0) {
						json_output( 200, array('status' => 200,'error' => '','validate' => true, 'list' => $response->result_array()) );
					}else{
						json_output( 206, array('status' => 206,'validate' => false,'error' => 'No se encontraron areas','config'=> array('excuse' => true,'retry'=>false,'logout' => true)) );
					}
				}
		    } else {
				return json_output(401, array('status' => 401,'validate' => false,'error' => 'Sin autorización.'));
			}
		}
	}

	public function getPuestosByArea(){
		$method = $_SERVER['REQUEST_METHOD'];

		if($method != 'POST'){
			json_output(400,array('status' => 400,'error' => 'Solicitud incorrecta.','config'=> array('excuse' => true,'retry'=>false,'logout' => true)));
		} else {
			$params = $_POST;		
			if(isset($params['key']) && isset($params['idArea']) && $params['key'] == $this->auth_key ){
				$idArea=$params['idArea'];
				$auth=true;
				if( $auth ) {
					$response = $this->db->query("SELECT id,titulo FROM puestos WHERE statusChatbot=1 AND status=1 AND idArea=$idArea");
					if ($response->num_rows()>0) {
						json_output( 200, array('status' => 200,'error' => '','validate' => true, 'list' => $response->result_array()) );
					}else{
						json_output( 206, array('status' => 206,'validate' => false,'error' => 'No se encontraron puestos','config'=> array('excuse' => true,'retry'=>false,'logout' => true)) );
					}
				}
		    } else {
				return json_output(401, array('status' => 401,'validate' => false,'error' => 'Sin autorización.'));
			}
		}
	}

	public function savePostulacion(){
		$method = $_SERVER['REQUEST_METHOD'];

		if($method != 'POST'){
			json_output(400,array('status' => 400,'error' => 'Solicitud incorrecta.','config'=> array('excuse' => true,'retry'=>false,'logout' => true)));
		} else {
			$params = $_POST;		
			if(isset($params['key']) && $params['key'] == $this->auth_key ){
				$auth=true;
				if( $auth ) {
					unset($params["key"]);
					$id=$this->mpostulaciones->insertar($params);
					json_output( 200, array('status' => 200,'error' => '','validate' => true, 'id' => $id));
				}
		    } else {
				return json_output(401, array('status' => 401,'validate' => false,'error' => 'Sin autorización.'));
			}
		}
	}

}