<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Auth extends MX_Controller {
	var $client_service = "frontend-client";
	var $auth_key = "3b947a0da97d6ee317ff5f6d26665e14";
    public function __construct(){
		// Tools
		$this->load->helper(array('tools','numeros','url','form','date','text','security'));
		// Modelos
		$this->load->model(array('mprospecto','mgarantia','maltaventa','mentrega', 'mpostventa', 'mincidente', 'mautenticacion'));
	}

	public function validatePhone(){
		$method = $_SERVER['REQUEST_METHOD'];

		if($method != 'POST'){
			json_output(400,array('status' => 400,'error' => 'Solicitud incorrecta.','config'=> array('excuse' => true,'retry'=>false,'logout' => true)));
		} else {
			$params = $_POST;
			
			if(isset($params['key']) && $params['key'] == $this->auth_key ){
				if ( isset($params['telefono'])) {
			        $response = true;
					if ( $response ) {
						json_output( 200, array('status' => 200, 'error' => '', 'validate' => true));
					}else{
						json_output( 206, array('status' => 206,'validate' => false,'error' => 'no se encontró su número telefónico','config'=> array('excuse' => true,'retry'=>false,'logout' => true)));
					}
		        }else{
					json_output( 206, array('status' => 206,'validate' => false,'error' => 'No ha enviado el número telefónico.') );
		        }
		    } else {
				return json_output(401, array('status' => 401,'validate' => false,'error' => 'Sin autorización.'));
			}
		}
	}

	public function validateCredentials(){
		$method = $_SERVER['REQUEST_METHOD'];

		if($method != 'POST'){
			json_output(400,array('status' => 400,'error' => 'Solicitud incorrecta.','config'=> array('excuse' => true,'retry'=>false,'logout' => true)));
		} else {
			$params = $_POST;
			
			if(isset($params['key']) && $params['key'] == $this->auth_key ){
				if ( isset($params['password']) && isset($params['telefono']) ) {
			        $response = $this->mprospecto->getNombreByTelCred($params['telefono'], $params['password'] );
					if ( !is_numeric($response) ) {
						//$query = $this->db->query("SELECT * FROM logs_notifications WHERE tipo = 'entregado' AND idProspecto = " . $response->row()->id);
						$query = $this->db->query("SELECT av.idProyecto FROM entrega e LEFT JOIN alta_venta av ON av.id=e.idAltaVenta WHERE e.statusEntrega=1 AND av.idProspecto=".$response->row()->id);
						if($query->num_rows() > 0){
							$query2 = $this->db->query("SELECT id FROM entrega WHERE (SELECT idProyecto FROM alta_venta WHERE id=idAltaVenta)=".$query->row()->idProyecto);
							if( $query2->num_rows() > 0){
								$last = $this->mautenticacion->getLastLoginByIdProspecto($response->row()->id);
								if( !is_numeric($last) ){
									if( date('Y-m-d H:i:s') < $last['expired_at'] ){
										$this->mautenticacion->borrar($last['id']);
									}
								}
								$last_login = date('Y-m-d H:i:s');
								$token = $this->auth_key;
								$expired_at = date("Y-m-d H:i:s", strtotime('+12 hours'));
								$aData['idProspecto'] = $response->row()->id;
								$aData['token'] = $token;
								$aData['expired_at'] = $expired_at;
								$this->mautenticacion->insertar($aData);
									json_output( 200, array('status' => 200, 'error' => '', 'validate' => true, 'name' => $response->row()->NombreCom, 'token' => $aData['token'], 'idProspecto' => $aData['idProspecto'], 'expired_at' => $aData['expired_at'] ) );
							}else{
								json_output( 206, array('status' => 206,'validate' => false,'error' => 'aun no le han entregado su vivienda, inténtelo más tarde.','config'=> array('excuse' => true,'retry'=>false,'logout'=>true)) );
							}
						}else{
							json_output( 206, array('status' => 206,'validate' => false,'error' => 'aun no le han entregado su vivienda, inténtelo más tarde.','config'=> array('excuse' => true,'retry'=>false,'logout'=>true)) );
						}
					}else{
						json_output( 206, array('status' => 206,'validate' => false,'error' => 'el NSS o CURP que ingreso no fue encontrado','config'=> array('excuse' => true,'retry'=>true)));
					}
		        }else{
					json_output( 206, array('status' => 206,'validate' => false,'error' => 'No ha enviado todos los datos.') );
		        }
		    } else {
				return json_output(401, array('status' => 401,'validate' => false,'error' => 'Sin autorización.'));
			}
		}
	}

	public function getWarranties(){
		$method = $_SERVER['REQUEST_METHOD'];

		if($method != 'POST'){
			json_output(400,array('status' => 400,'error' => 'Solicitud incorrecta.','config'=> array('excuse' => true,'retry'=>false,'logout' => true)));
		} else {
			$params = $_POST;		
			if(isset($params['key']) && $params['key'] == $this->auth_key ){
				$auth=true;
				if( $auth ) {
					$response = $this->mgarantia->getAllASC();
					if ( !is_numeric($response) ) {
						foreach($response->result() as $garan){
							$garantias[] = array('id' => $garan->id, 'nombre' => $garan->id . '.- ' . $garan->nombre);
						}
						json_output( 200, array('status' => 200,'error' => '','validate' => true, 'list' => $garantias) );
					}else{
						json_output( 206, array('status' => 206,'validate' => false,'error' => 'No sé encontraron garantías.','config'=> array('excuse' => true,'retry'=>false,'logout' => true)) );
					}
				}
		    } else {
				return json_output(401, array('status' => 401,'validate' => false,'error' => 'Sin autorización.'));
			}
		}
	}
	
	public function validateValidity(){
		$method = $_SERVER['REQUEST_METHOD'];

		if($method != 'POST'){
			json_output(400,array('status' => 400,'error' => 'Solicitud incorrecta.','config'=> array('excuse' => true,'retry'=>false,'logout' => true)));
		} else {
			$params = $_POST;
			
			if(isset($params['key']) && $params['key'] == $this->auth_key ){
				$auth=true;
				if( $auth ) {
					if ( isset($params['idGarantia']) ) {
						$qAltaV = $this->maltaventa->getByIdProspecto($params['idProspecto']);
						if ( !is_numeric($qAltaV) ) {
							$qEntrega = $this->mentrega->getByIdAltaVenta($qAltaV['id']);
							if( !is_numeric($qEntrega) ){
								$qGarantia = $this->mgarantia->getById($params['idGarantia']);
								if( !is_numeric($qGarantia) ){
									$fechaVencimiento = new DateTime($qEntrega['fechaEntrega']);
									$fechaVencimiento->add(new DateInterval('P'.$qGarantia['vigencia'].'D'));
									if ( $fechaVencimiento->format('y') > date( 'y', strtotime($qEntrega['fechaEntrega']) ) ) {
										$y = ( ( $fechaVencimiento->format('y') - date( 'y', strtotime($qEntrega['fechaEntrega']) ) ) - 1 ) * 12;
										$vigencia = $fechaVencimiento->format('m') + ( 12 - date( 'm', strtotime($qEntrega['fechaEntrega']) ) ) + $y;
									}else{
										$vigencia = $fechaVencimiento->format('m') - date( 'm', strtotime($qEntrega['fechaEntrega']) );
									}
									$validar = ( date('y-m-d') <= $fechaVencimiento->format('y-m-d') )? true : false;
									$error=(!$validar) ? 'la vigencia de la garantía '.$qGarantia['nombre'].' ha vencido el día '.$fechaVencimiento->format('d-m-Y') : '';
									json_output( 200, array('status' => 200, 'validate' => $validar, 'error' => $error,'vigencia' => $vigencia . ' meses', 'vigenciaD' => $qGarantia['vigencia'] . ' días', 'fechaVencimiento' => $fechaVencimiento->format('d/m/Y'),'config' => array('retry' => false,'logout' => !$validar)));
								}
								else{
									json_output( 206, array('status' => 206,'validate' => false,'error' => 'no se pudo encontrar la garantía','config'=> array('excuse' => true,'retry'=>true)));
								}
							}else{
								json_output( 206, array('status' => 206,'validate' => false,'error' => 'No se pudo encontrar la fecha de entrega para validar la vigencia.','config'=> array('excuse' => true,'retry'=>false,'logout' => true)) );
							}
						}else{
							json_output( 206, array('status' => 206,'validate' => false,'error' => 'No se encontrò el lote al que esta asociado.','config'=> array('excuse' => true,'retry'=>false,'logout' => true)) );
						}
					}else{
						json_output( 206, array('status' => 206,'validate' => false,'error' => 'No ha enviado todos los datos.','config'=> array('excuse' => true,'retry'=>false,'logout' => true)));
					}
				}
		    } else {
				json_output(401, array('status' => 401,'validate' => false,'error' => 'Sin autorización.','config'=> array('excuse' => true,'retry'=>false,'logout' => true)));
			}
		}
	}

	public function generateInvoice(){
		$method = $_SERVER['REQUEST_METHOD'];

		if($method != 'POST'){
			json_output(400,array('status' => 400,'error' => 'Solicitud incorrecta.','config'=> array('excuse' => true,'retry'=>false,'logout' => true)));
		} else {
			$params = $_POST;
			
			if(isset($params['key']) && $params['key'] == $this->auth_key){
				$auth = true;
				if( $auth ) {
					$qAltaV = $this->maltaventa->getByIdProspecto($params['idProspecto']);

					if ( !is_numeric($qAltaV) ) {
						$qEntrega = $this->mentrega->getByIdAltaVenta($qAltaV['id']);
						if( !is_numeric($qEntrega) ){
							$qGarantia = $this->mgarantia->getById($params['idGarantia']);
							if( !is_numeric($qGarantia) ){
								//Para datos de postventa
								if( $qGarantia['abreviacion'] == 'canceleria'){
									$fechaTexto = 'NA';
								}else{
									$fechaVencimiento = new DateTime($qEntrega['fechaEntrega']);
									$fechaVencimiento->add(new DateInterval('P'.$qGarantia['vigencia'].'D'));
									$fechaTexto = $fechaVencimiento->format('Y-m-d');
								}
								$pData[$qGarantia['abreviacion']] = $fechaTexto;
								$pData['idAltaVenta'] = $qAltaV['id'];
					        	$pData['statusIncidencia'] = 1;
								$pData[$qGarantia['abreviacion']] = $fechaTexto;
								$idPost = $this->mpostventa->insertar($pData);
								//Datos para incidente
								$iData['idPostventa'] = $idPost;								
								$iData[$qGarantia['abreviacion']] = true;
								$desParam = 'desc'.ucfirst($qGarantia['abreviacion']);
								$iData[$desParam] = $params['descripcion'];
					        	$iData['fechaAbierto'] = date('Y-m-d');
					        	$iData['statusIncidencia'] = 1;
					        	$iData['status'] = 1;
								$iData['created_by'] = 406;
								$iData['created'] = date('Y-m-d');
								$id = $this->mincidente->insert($iData);
								$folio = date('m') . date('y') . $id;
								json_output( 200, array('status' => 200, 'folio' => $folio, 'id' => $id, 'error' => '','validate' => true) );
							}
							else{
								json_output( 206, array('status' => 206,'validate' => false,'error' => 'no se pudo encontrar la garantía','config'=> array('excuse' => true,'retry'=>true)) );
							}
						}else{
							json_output( 206, array('status' => 206,'validate' => false,'error' => 'No se pudo encontrar el registro de entrega.','config'=> array('excuse' => true,'retry'=>false,'logout' => true)) );
						}
					}else{
						json_output( 206, array('status' => 206,'validate' => false,'error' => 'No se encontró el lote al que esta asociado.','config'=> array('excuse' => true,'retry'=>false,'logout' => true)) );
					}
				}
		    } else{
				json_output( 401, array('status' => 401,'validate' => false,'error' => 'Sin autorización.') );
	        }
		}
	}

	public function getStatusFolio(){
		return false;
	}
}