<?php
defined('BASEPATH') OR exit('No direct script access allowed');
date_default_timezone_set('America/Mexico_City');
class Asignacion extends MX_Controller {
	public $data,$vParameters,$mainView,$fv;
	public function __construct(){
        $this->nsession = $this->config->item('nsession');
        if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'asignacion'; // form validation variable
            $this->mainView = 'asignacion';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/asignacion/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('musuario','mdetallepaquete','mfraccionamiento','mpaquete'));

            // Lbrerias
            // $this->load->library(array('email','session'));
           	$this->data['fotos_www'] = $this->config->item('base_www').'/asignacion/';
            
            //Validación de usuarios
            valSession("obra",$this->fv);
    }

	public function index(){
		$data['q'] = '';
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

    public function listado(){
        $q=$this->db->query("SELECT fra.* FROM detalle_paquete dp 
        LEFT JOIN arranque arr ON FIND_IN_SET(dp.idPaquete,arr.idPaquetes) 
        LEFT JOIN proyectos pro ON pro.id=dp.idProyecto
        LEFT JOIN fraccionamientos fra ON fra.id=pro.idFraccionamiento
        WHERE arr.estatus_arranque < 3 GROUP BY pro.idFraccionamiento  
        ORDER BY `fra`.`id` DESC");

        if ($q->num_rows() > 0) {
            foreach ($q->result() as $row){
                $array['aaData'][] = array(
                    'titulo' => $row->titulo,
                    'estado' => $row->estado,
                    'municipio' => $row->municipio,
                    'acciones' => accionesAsignacion($row->id,$this->router->class)
                    );
            }
        } else{
            $array['aaData'][] = array(
                'titulo' => 'No hay registros',
                'estado' => 'No hay registros',
                'municipio' => 'No hay registros',
                'acciones' => 'No hay registros'
                );
        }
        echo json_encode($array);
    }

    public function supervisores($id=0){
        $data["fraccionamiento"] = $this->mfraccionamiento->getById($id);
        $data["manzanas"]=$this->db->query("SELECT pro.manzana FROM detalle_paquete dp 
        LEFT JOIN arranque arr ON FIND_IN_SET(dp.idPaquete,arr.idPaquetes) 
        LEFT JOIN proyectos pro ON pro.id=dp.idProyecto
        LEFT JOIN fraccionamientos fra ON fra.id=pro.idFraccionamiento
        WHERE arr.estatus_arranque < 3 AND pro.idFraccionamiento=$id
        GROUP BY pro.manzana ORDER BY pro.manzana+1 ASC");
        //$data["mdetallepaquete"]=$this->mdetallepaquete;
        $data["supervisores"]=$this->db->query("SELECT id,CONCAT(nombre,' ',apellidoP,' ',apellidoM) titulo FROM usuarios WHERE rol=9 AND status=1");

        $data["msg"]="";
        $this->data['contenido'] = $this->load->view($this->mainView.'/supervisores_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
    }

    public function coordinadores($id=0){
        $data["fraccionamiento"] = $this->mfraccionamiento->getById($id);
        $data["manzanas"]=$this->db->query("SELECT pro.manzana FROM detalle_paquete dp 
            LEFT JOIN arranque arr ON FIND_IN_SET(dp.idPaquete,arr.idPaquetes) 
            LEFT JOIN proyectos pro ON pro.id=dp.idProyecto
            LEFT JOIN fraccionamientos fra ON fra.id=pro.idFraccionamiento
            WHERE arr.estatus_arranque < 3 AND pro.idFraccionamiento=$id
            GROUP BY pro.manzana ORDER BY pro.manzana+1 ASC");
        $data["coordinadores"]=$this->db->query("SELECT id,CONCAT(nombre,' ',apellidoP,' ',apellidoM) titulo FROM usuarios WHERE rol=18 AND status=1");

        $data["msg"]="";
        $this->data['contenido'] = $this->load->view($this->mainView.'/coordinadores_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
    }

    public function contratistas($id=0){
        $data["fraccionamiento"] = $this->mfraccionamiento->getById($id);
        $data["paquetes"]=$this->db->query("SELECT paq.id, paq.titulo, paq.idConstructor, paq.rango_lotes,
        paq.fecha_inicio, paq.fecha_fin, arr.estatus_arranque FROM detalle_paquete dp
        LEFT JOIN paquetes paq ON paq.id=dp.idPaquete
        LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes) 
        LEFT JOIN proyectos pro ON pro.id=dp.idProyecto
        LEFT JOIN fraccionamientos fra ON fra.id=pro.idFraccionamiento
        WHERE arr.estatus_arranque < 3 AND pro.idFraccionamiento=$id
        GROUP BY paq.id ORDER BY paq.id ASC");
        $data["constructores"]=$this->db->query("SELECT id,CONCAT(nombre,' ',apellidoP,' ',apellidoM) titulo FROM constructores WHERE status=1");
        //echo "<pre>";
        //print_r($data["paquetes"]->result());
        //exit();
        $data["msg"]="";
        $this->data['contenido'] = $this->load->view($this->mainView.'/contratistas_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
    }

    public function updateLote(){
        $idSupervisor = $this->input->post('idSupervisor', TRUE);
        $idPptoPaq = $this->input->post('idPptoPaq', TRUE);
        $this->mdetallepaquete->actualizar(["idResidente"=>$idSupervisor],$idPptoPaq);
        echo json_encode("listo");
    }

    public function updateLoteCoordinador(){
        $idCoordinador = $this->input->post('idCoordinador', TRUE);
        $idPptoPaq = $this->input->post('idPptoPaq', TRUE);
        $this->mdetallepaquete->actualizar(["idCoordinador"=>$idCoordinador],$idPptoPaq);
        echo json_encode("listo");
    }

    public function updateConstructor(){
        $idConstructor = $this->input->post('idConstructor', TRUE);
        $idPaq = $this->input->post('idPaq', TRUE);
        $this->mpaquete->actualizar(["idConstructor"=>$idConstructor],$idPaq);
        echo json_encode("listo");
    }

}


