<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Arranque extends MX_Controller {
    public $data,$vParameters,$mainView,$fv;
    public function __construct(){
    $this->nsession = $this->config->item('nsession');
    if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'arranque'; // form validation variable
            $this->mainView = 'arranque';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/arranque/listado.js?v=0.4" type="text/javascript"></script>';
            $this->data['css'] = '<link href="assets/css/bootstrap.min.css" rel="stylesheet" type="text/css">';
            // Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mactividadmo','musuario','munidades','mcategoriamo','marranque','mpaquete', 
            'mfraccionamiento', 'mmanoobra', 'mmaterial', 'mestimacionprograma', 'mdetallepaquete','mprototipos',
            'mpresupuestomat','mpresupuestomo', 'malmacenes','mproyecto','maltaventa','mprospecto', 'mconstructores', 
            'mordenpago','mordencompra','marranques','mempresas'));
            $this->config->set_item('rol', $_SESSION[$this->nsession]['rol']);
            // Lbrerias
            // $this->load->library(array('email','session'));
            $this->data['fotos_www'] = $this->config->item('base_www').'/arranque/';
           // $this->data['fotos_www'] = '/home/puntapro/www/uploads/inicio/';

           //Validación de usuarios
            valSession("obra",$this->fv);
    }

    public function index(){
        $data['q'] = '';
        /*$data['notificacion'] = '';
        $data['showNotification'] = 0;
        $data['isTable'] = 0;
        if(isset($_SESSION['notificacion']) && isset($_SESSION['showNotification'])){
            $data['notificacion'] = $_SESSION['notificacion'];
            $data['showNotification'] = json_decode($_SESSION['showNotification']);
            $data['isTable'] = json_decode($_SESSION['isTable']);
            unset($_SESSION['notificacion']);
            unset($_SESSION['showNotification']);
            unset($_SESSION['isTable']);
        }*/
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
    }

    public function formatos($id){
        $data['q'] = '';
        $data['id'] =$id;
        $this->data['contenido'] = $this->load->view($this->mainView.'/formatos_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
    }

    public function listado(){
        $q = $this->marranques->get_datatables();

        if (!is_numeric($q)){
            foreach ($q->result() as $row){
                $editar = true;
                $encurso = false;
                $finalizado = false;
                switch ($row->estatus_arranque) {
                    case 1:
                        $editar = true;
                        $count = 0;
                        $countIdPaq = explode(',', $row->idPaquetes);
                        $countArray = count($countIdPaq);

                        foreach ($countIdPaq as $key => $value) {
                            $qPaquete = $this->mpaquete->getById($value);
                            if(!is_numeric($qPaquete)){
                                $manoObra = $this->mmanoobra->getById($qPaquete['idManoObra']);
                                $material = $this->mmaterial->getByIdPaquete($qPaquete['id']);
                                $estimacion = $this->mestimacionprograma->getByIdPaquete($qPaquete['id']);
                                $detallePaquete = $this->mdetallepaquete->getByIdPaquete($qPaquete['id']);
                                if(isset($manoObra['id']) && isset($material['id']) && isset($estimacion['id'])){
                                    if($manoObra['id'] != '' && $material['id'] != '' && $estimacion['id'] != '' && $detallePaquete->num_rows() > 0){
                                        $count++;
                                    }
                                }
                            }
                        }

                        if($count == $countArray){
                            $encurso = true;
                        }
                        $encurso = true;
                        $finalizado = false;
                        break;
                    case 2:
                        $editar = false;
                        $encurso = false;
                        $finalizado = true;
                        break;
                    case 3:
                        $editar = false;
                        $encurso = false;
                        $finalizado = false;
                        break;
                }

                $paquetes = explode( ',', $row->idPaquetes);
                $ids = '';
                $i = 0;
                $nompaquetes = '';
                $totalArranque = 0;
                $totalArranqueMAT = 0;
                $totalArranqueMO = 0;
                $MOPagado = 0;
                $MATComprado=0;
                foreach ($paquetes as $paq) {
                    $nompaquetes .= $this->mpaquete->getCampo('titulo',$paq).",";
                    $rango_lotes = $this->mpaquete->getCampo('rango_lotes', $paq);
                    if( !empty($rango_lotes) ){
                        $lotesManzana = contarLotesManzanas($rango_lotes);
                        $lotes = $lotesManzana['total'];
                        $qMaterial = $this->mmaterial->getByIdPaquete($paq);
                        if(!is_numeric($qMaterial)){
                            $totalUnitarioMAT = $this->mpresupuestomat->getSumTotalUnitario($qMaterial["id"]);
                            $totalPMAT = $totalUnitarioMAT * $lotes;
                        } else{
                            $totalPMAT = 0;
                        }
                        $idMO = $this->mpaquete->getCampo('idManoObra', $paq);
                        $totalUnitarioMO = $this->mpresupuestomo->getSumTotalUnitario($idMO,$paq);
                        $totalPMO = $totalUnitarioMO * $lotes;
                    } else {
                        $totalPMAT = 0;
                        $totalPMO = 0;
                    }
                    $totalArranqueMAT = $totalPMAT + $totalArranqueMAT;
                    $totalArranqueMO = $totalArranqueMO + $totalPMO;

                    $oden_pago = $this->mordenpago->getTotalFacturadoPagadoByIdPaquete($paq);
                    $total_orden_pago = (!is_numeric($oden_pago)) ? $oden_pago->row()->total : 0;

                    $MOPagado = $MOPagado + $total_orden_pago;
                    //Materiales comprados
                    $ocs=$this->mordencompra->getImporteBypaq($paq);
                    $MATComprado+=$ocs->total;
                }
                $totalArranque = $totalArranqueMAT + $totalArranqueMO;
                $totalEjecutado= $MOPagado + $MATComprado;
                $eliminar=true;
                if($row->estatus_arranque > 1){
                    $eliminar=false;
                }
                $array[] = array(
                    'tipoAlmacen' => getTipoAlmacen($row->tipoAlmacen),
                    'titulo' => $row->titulo,
                    'idPaquetes' => substr($nompaquetes, 0, -1),
                    'numeroContrato' => $row->numeroContrato,
	               	'totalMO' => precio_format($totalArranqueMO),
	               	'totalMat' => precio_format($totalArranqueMAT),
	                'totalArranque' => precio_format($totalArranque),
	                'moPagado' => precio_format($MOPagado),
                    'matComprado' => precio_format($MATComprado),
                    'totalEjecutado' => precio_format($totalEjecutado),
                    'moPorPagar' => precio_format($totalArranqueMO - $MOPagado),
                    'matPorComprar' => precio_format($totalArranqueMAT - $MATComprado),
                    'totalPorEjecutar' => precio_format($totalArranque - $totalEjecutado),
                    'estatusArranque' => bgStatus($row->estatus_arranque),
                    'fecha_inicio' => ($row->fecha_inicio!='0000-00-00' && $row->fecha_inicio!='')?date('d/m/Y',strtotime($row->fecha_inicio)):'',
                    'fecha_fin' => ($row->fecha_fin!='0000-00-00' && $row->fecha_fin!='')?date('d/m/Y',strtotime($row->fecha_fin)):'',
                    'acciones' => (in_array($_SESSION[$this->nsession]['rol'], permisos("obra","arranque")['w']))? accionesArranque($row->id,$this->router->class,true, $editar, $eliminar,true, $encurso, $finalizado) : ''
                    );
            }
        } else{
            $array = [];

        }
        $output = array(
            "draw" => $_POST['draw'],
            "recordsTotal" => $this->marranques->count_all(),
            "recordsFiltered" => $this->marranques->count_filtered(),
            "data" => $array,
        );
        //output to json format
        echo json_encode($output);
    }

    public function nuevo()
    {
        // Mensajes
        $data['paketes'] = '';
        $data['msg'] = '';
        $this->load->library('form_validation');
        if ($this->form_validation->run($this->fv) == FALSE) {
            $data['msg'] = validation_errors();
            $data['paquetes']= $this->mpaquete->getByExistInArranque();
            $data['categoria']= $this->mcategoriamo->getSelectResult();
            $data['residentes']  = $this->musuario->getResidentesByPaquetes();
            $data['empresas']= $this->mempresas->getAll();
            $this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
            $this->load->view('templates/main_template', $this->data);
        } else {
            $pData['titulo'] = $this->input->post('titulo', TRUE);
            $paketes = $_POST["paketes"];
            $pData['idSupervisor'] = $this->input->post('idSupervisor', TRUE);
            $pData['retencionfg'] = $this->input->post('retencionfg', TRUE);

            $fecha_inicio = $this->input->post('fecha_inicio', TRUE);
            $fecha_inicio =  str_replace('/', '-', $fecha_inicio);
            $pData['fecha_inicio'] = ($fecha_inicio!='')?date('Y-m-d', strtotime($fecha_inicio)):'0000-00-00';

            $fecha_fin = $this->input->post('fecha_fin', TRUE);
            $fecha_fin =  str_replace('/', '-', $fecha_fin);
            $pData['fecha_fin'] = ($fecha_fin!='')?date('Y-m-d', strtotime($fecha_fin)):'0000-00-00';

            $fechaFirma = $this->input->post('fechaFirma', TRUE);
            $fechaFirma =  str_replace('/', '-', $fechaFirma);
            $pData['fechaFirma'] = ($fechaFirma!='')?date('Y-m-d', strtotime($fechaFirma)):'0000-00-00';

            $push_paketes = array();
            if (is_array($paketes) && !empty($paketes) && count($paketes)>0){
                $i=0;
                $pData['idPaquetes'] = '';
                foreach ($paketes as $t) {
                    $pData['idPaquetes'] .= ($i==0 ) ? $t : ",".$t;
                    $i+=1;
                }
                $idMO = $this->mpaquete->getCampo('idManoObra', $t);
                array_push($push_paketes, $paketes);
            }
            $fraccionamiento = $this->mfraccionamiento->getCampo("titulo", $this->mmanoobra->getCampo("idFraccionamiento", $idMO) );

            //$this->db->query("UPDATE paquetes SET porcentaje_retencion=".$pData['retencionfg']." WHERE id IN (".$pData['idPaquetes'].")");
            $pData['status'] = 1;
            $pData['estatus_arranque'] = 1;
            $pData['ronda'] = $this->input->post('ronda', TRUE);
            $pData['tipoAlmacen'] = $this->input->post('tipoAlmacen', TRUE);
            $pData['idEmpresa'] = $this->input->post('idEmpresa', TRUE);
            $id = $this->marranque->insertar($pData);
            $uData['numeroContrato'] = strtoupper(substr($fraccionamiento, 0, 3) ) . date('d', strtotime($fechaFirma)) . date('m', strtotime($fechaFirma)) . substr(date('Y', strtotime($fechaFirma)), -2) . '-' . $id;
            $this->marranque->actualizar($uData, $id);

            redirect($this->router->class);
        }
    }

    public function editar($id)
    {
        $info = $this->marranque->getById($id);
        //echo '<pre>'; print_r($info); exit();
        $data = $info;
        $data['paketes'] = '';
        $msg = '';
        /* VALIDAR FORMULARIO*/
        $this->load->library('form_validation');

        /*if (isset($_POST['clave'])) {*/
           /*     echo $_POST['clave']; exit();*/
            if ($this->form_validation->run($this->fv) == FALSE) {
                $msg = validation_errors();
            } else {
                 /*   $data['paketes'] = '';*/
                    $pData['titulo'] = $this->input->post('titulo', TRUE);
                   /*     echo $pData['titulo']; exit();*/
                    /*$pData['idPaquetes'] = $this->input->post('idPaquetes', TRUE);  */
                    $paketes = $_POST["paketes"];
                   /* echo $paketes; exit();*/
                    //$pData['numeroContrato'] = $this->input->post('numeroContrato', TRUE);
                    $pData['idSupervisor'] = $this->input->post('idSupervisor', TRUE);
                    $pData['retencionfg'] = $this->input->post('retencionfg', TRUE);
                    $pData['ronda'] = $this->input->post('ronda', TRUE);
                    $pData['tipoAlmacen'] = $this->input->post('tipoAlmacen', TRUE);
                    $pData['idEmpresa'] = $this->input->post('idEmpresa', TRUE);

                    $fecha_inicio = $this->input->post('fecha_inicio', TRUE);
                    $fecha_inicio =  str_replace('/', '-', $fecha_inicio);
                    $pData['fecha_inicio'] = ($fecha_inicio!='')?date('Y-m-d', strtotime($fecha_inicio)):'0000-00-00';

                    $fecha_fin = $this->input->post('fecha_fin', TRUE);
                    $fecha_fin =  str_replace('/', '-', $fecha_fin);
                    $pData['fecha_fin'] = ($fecha_fin!='')?date('Y-m-d', strtotime($fecha_fin)):'0000-00-00';

                    $fechaFirma = $this->input->post('fechaFirma', TRUE);
                    $fechaFirma =  str_replace('/', '-', $fechaFirma);
                    $pData['fechaFirma'] = ($fechaFirma!='')?date('Y-m-d', strtotime($fechaFirma)):'0000-00-00';

                    if (is_array($paketes) && !empty($paketes) && count($paketes)>0){
                        $i=0;
                        foreach ($paketes as $t) {
                            $pData['idPaquetes'] .= ($i==0 ) ? $t : ",".$t;
                            $i+=1;
                        }
                        array_push($paketes);
                    }
                $this->db->query("UPDATE paquetes SET porcentaje_retencion=".$pData['retencionfg']." WHERE id IN (".$pData['idPaquetes'].")");
                $this->marranque->actualizar($pData,$id);
                redirect($this->router->class."?close");
            }
            // Mensajes
       /* } */
        // Obteniendo la información

        $data['residentes']  = $this->musuario->getResidentesByPaquetes();
        $data['paketes']  = str_replace(",", "-", $this->marranque->getCampo('idPaquetes',$id));
        $data['msg']=$msg;
        $data['unidad']= $this->munidades->getSelectResult();
        $data['categoria']= $this->mcategoriamo->getSelectResult();
        $data['paquetes']= $this->mpaquete->getByExistInArranque($data["idEmpresa"],$id,$data["idPaquetes"]);
        $data['empresas']= $this->mempresas->getAll();
        $data['idArranque']=$id;

        $this->data['contenido'] = $this->load->view($this->mainView . '/editar_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function eliminar(){
        $id = $this->input->post('elid');
        $q = $this->marranque->getById($id);
        $cValor = "true";
        $valorBorrar = $this->marranque->borrar($id);
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }

    public function sendNotification($idProyecto, $tipo=5){
        $cuerpo = '';
        $htmlArra = '';
        $textNotif = statusNotif($tipo);
        $imgStatus = imgStatus($tipo);
        $leyendaNotif = leyendaNotif($tipo);
        $leyendaIniciado = leyendaConstruyendo($tipo);
        $logoConstruyendo = logoConstruyendo($tipo);
        $etapa = '';
        $fracc = '';
        $lotefracc = '';

        /*$idProspecto = $this->maltaventa->getCampo('idProspecto',$idProyecto);
        $nss = $this->mprospecto->getCampo('nss',$idProspecto);
        $idFraccionamiento = $this->mproyecto->getCampo('idFraccionamiento',$idProyecto);
        $fraccionamiento = $this->mfraccionamiento->getCampo('titulo',$idFraccionamiento );

        $cliente = $this->mprospecto->getCampo('nombre', $idProspecto).' '.$this->mprospecto->getCampo('apellidoP', $idProspecto) .' '.$this->mprospecto->getCampo('apellidoM', $idProspecto);
        $idPromotor = $this->mprospecto->getCampo('idPromotor',$idProyecto);
        $promotor =  $this->musuario->getCampo('nombre', $idPromotor).' '.$this->musuario->getCampo('apellidoP', $idPromotor) .' '.$this->musuario->getCampo('apellidoM', $idPromotor);
        $celular = $this->musuario->getCampo('celular', $idPromotor);
        $info =  $this->mproyecto->getById($idProyecto);
        $lote = $this->mproyecto->getCampo('lote', $idProyecto);
        $manzana = $this->mproyecto->getCampo('manzana', $idProyecto);
        $idPrototipo = $this->mproyecto->getCampo('idPrototipo', $idProyecto);
        $nomPrototipo = $this->mprototipos->getCampo('nombre',$idPrototipo);*/
        $query = $this->db->query('
                    SELECT
                        av.idProspecto,
                        (SELECT UPPER(CONCAT(nombre, " ", apellidoP, " ", apellidoM)) FROM prospectos WHERE id=av.idProspecto) AS cliente,
                        (SELECT nss FROM prospectos WHERE id=av.idProspecto) AS nss,
                        (SELECT titulo FROM fraccionamientos WHERE id=(SELECT idFraccionamiento FROM proyectos WHERE id=idProyecto)) AS fraccionamiento,
                        (SELECT UPPER(CONCAT(nombre, " ", apellidoP, " ", apellidoM)) FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=av.idProspecto)) AS promotor,
                        (SELECT celular FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=av.idProspecto)) AS celular,
                        (SELECT lote FROM proyectos WHERE id=(SELECT idProyecto FROM alta_venta WHERE id = av.id)) AS lote,
                        (SELECT manzana FROM proyectos WHERE id=(SELECT idProyecto FROM alta_venta WHERE id = av.id)) AS manzana,

                        (SELECT nombre FROM prototipos WHERE id=(SELECT idPrototipo FROM prospectos WHERE id=av.idProspecto)) AS prototipo
                    FROM
                        alta_venta AS av
                    WHERE
                        av.idProyecto = '.$idProyecto.'
                ');

        $cliente = '';
        $promotor = '';
        $celular = '';
        $lote = '';
        $nss = '';
        $manzana = '';
        $nomPrototipo = '';
        $fraccionamiento = '';
        if($query->num_rows() > 0){
            $cliente = $query->row()->cliente;
            $promotor = $query->row()->promotor;;
            $celular = $query->row()->celular;
            $lote = $query->row()->lote;
            $manzana = $query->row()->manzana;
            $nomPrototipo = $query->row()->prototipo;
            $nss = $query->row()->nss;
            $fraccionamiento = $query->row()->fraccionamiento;
        }




        if ($tipo !=5) {
             $etapa = '
                <tr >
                    <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;" class="paddinginfo borderyellow greentitle fs-notif" > ETAPA: </td>
                    <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;" class="paddinginfo borderyellow" >'.$textNotif.'</td>
                </tr';
        }


        if ($tipo == 1 || $tipo == 2|| $tipo == 3 || $tipo == 4) {
             $fracc = '
                <tr>
                    <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow greentitle fs-notif" > FRACCIONAMIENTO: </td>
                    <td  style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow" > '.$fraccionamiento.'  </td>
                </tr> ';
        }else{
             $fracc = '';
        }


        $lotefracc ='
                <tr>
                    <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow greentitle fs-notif" >LOTE (MZ): </td>
                    <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow" > '.$lote.' ('.$manzana.' )  </td>
                </tr>

        ';


        $cuerpo .= '

                    <tr id="testdiv" >
                        <td style="padding:10px;" class="paddinginfo " >  </td>
                        <td style="padding:10px;" class="paddinginfo " >    </td>
                    </tr>

                    '. $etapa.'

                    <tr>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;" class="paddinginfo borderyellow greentitle fs-notif" > CLIENTE: </td>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow" >  '.strtoupper($cliente).' </td>
                    </tr>
                    <tr >
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;" class="paddinginfo borderyellow greentitle fs-notif" > NSS: </td>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow" >  '.strtoupper($nss).' </td>
                    </tr>
                    <tr>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow greentitle fs-notif" > ASESOR: </td>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow" > '.strtoupper($promotor).'</td>
                    </tr>
                    <tr>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow greentitle fs-notif" >TEL.PROMOTOR:</td>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"   class="paddinginfo borderyellow" > '.$celular.'  </td>
                    </tr>
                    <tr>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow greentitle fs-notif" >   PROTOTIPO: </td>
                        <td  style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow" > '.$nomPrototipo.'  </td>
                    </tr>
                    '. $fracc.'


                     '. $lotefracc.'


                    <tr>


                ';




           $htmlArra ='
                        <tr>
                            <td style="padding: 30px 30px 30px 30px;" class="innerpadding borderbottom">
                                <!-- [if (gte mso 9)|(IE)]>
                                <table width="380" align="left" cellpadding="0" cellspacing="0" border="0">
                                    <tr>
                                    <td>
                                <![endif]-->
                                <table class="col380" align="left" border="0" cellpadding="0" cellspacing="0" style="width: 100%; max-width: 100%;">
                                <tr>
                                    <td>
                                        <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                <tr>
                                                    <td  style="padding:10px;" class="paddinginfo" >
                                                        '.$imgStatus.'

                                                    </td>
                                                    <td  style="padding:10px;color:#248d3b;font-weight:bold;" class="paddinginfo greentitle" >'.$leyendaNotif.'
                                                    </td>
                                                </tr>
                                                <br>
                                                '.$cuerpo.'
                                        </table>
                                    </td>
                                </tr>
                                </table>
                                <!--[if (gte mso 9)|(IE)]>
                                    </td>
                                    </tr>
                                </table>
                                <![endif]-->
                            </td>
                        </tr>

                        <tr>
                            <td style="padding: 0px 30px 30px 30px;" class="innerpadding borderbottom">

                                <table class="col380" align="left" border="0" cellpadding="0" cellspacing="0" style="width: 100%; max-width: 100%;">
                                    <tr>
                                        <td>
                                            <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                    <tr>
                                                        <td  style="padding:10px;color:#248d3b;font-weight:bold;" class="paddinginfo greentitle" >'.$leyendaIniciado.'
                                                        </td>
                                                    </tr>
                                            </table>
                                        </td>
                                    </tr>
                                </table>

                            </td>
                        </tr>
                    ';
                    $subject = "HOLA ".$cliente." NOTIFICACIÓN DE ARRANQUE EN CURSO";
                    $destMail = '';
                    $notificacion = email_notificaciones($htmlArra,$subject,'sistemas@viviend.mx',$logoConstruyendo);
                    $notificacion = email_notificaciones($htmlArra,$subject,'administracion@viviend.mx',$logoConstruyendo);
                    $notificacion = email_notificaciones($htmlArra,$subject,'hsalinas@viviend.mx',$logoConstruyendo);
                    $notificacion = email_notificaciones($htmlArra,$subject,'esalinas@viviend.mx',$logoConstruyendo);
                    $notificacion = email_notificaciones($htmlArra,$subject,'alejandra@viviend.mx',$logoConstruyendo);
                    $notificacion = email_notificaciones($htmlArra,$subject,'liliana@viviend.mx',$logoConstruyendo);
                    $notificacion = email_notificaciones($htmlArra,$subject,'contabilidad@viviend.mx',$logoConstruyendo);
                    $notificacion = email_notificaciones($htmlArra,$subject,'contabilidad2@viviend.mx',$logoConstruyendo);
                    $notificacion = email_notificaciones($htmlArra,$subject,'control@viviend.mx',$logoConstruyendo);
                    $notificacion = email_notificaciones($htmlArra,$subject,'costos@viviend.mx',$logoConstruyendo);
                    $notificacion = email_notificaciones($htmlArra,$subject,'tecnico@viviend.mx',$logoConstruyendo);
                    //echo $notificacion; exit();
    }

    function getClave($lenght=5){
        $str_result = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
        return substr(str_shuffle($str_result), 0, $lenght);
    }

    public function ver($id){
        // Obtenemos la informacion de arranque por id
         $info = $this->marranque->getById($id);

        $ids[] = 0;
        $temp = explode(',', $info['idPaquetes']);
        if( !empty($temp[0]) ){
            foreach($temp as $v){
                if( !in_array($v, $ids, true) && is_numeric($v)){
                    $ids[] = $v;
                }
            }
        }

        $data['rows'] = '';
        $paquetes = $this->mpaquete->getInIds($ids);

         $sum = 0;
        foreach ($paquetes->result() as $row) {
            $idPrototipo = $this->mmanoobra->getCampo('idPrototipo',$row->idManoObra);
            $idpaquete   = $row->id;
            $fechaFormatIni = ($row->fecha_inicio!='')?date('d/m/Y', strtotime($row->fecha_inicio)):'0000-00-00';
            $fechaFormatFin = ($row->fecha_fin!='')?date('d/m/Y', strtotime($row->fecha_fin)):'0000-00-00';
            $dataInfo['nompaquete']   = strtoupper($row->titulo);
            $dataInfo['idProto']   = $this->mprototipos->getCampo('nombre',$idPrototipo);
            $dataInfo['fechaIni']   = $fechaFormatIni;
            $dataInfo['fechaFin']   = $fechaFormatFin;
            $dataInfo['noViviendas']   = $row->rango_lotes;
            //LLAMAR GET INFO VER
            $getInfo = $this->getInfoVer($idpaquete);
            $sum += ($getInfo != 0) ?  $getInfo['totalEncabezado'] : 0.00 ;
    
        
          if($getInfo != 0){
                $dataInfo['prototipo'] = $getInfo['prototipo'];
                $dataInfo['fraccionamiento'] = $getInfo['fraccionamiento'];
                $dataInfo['rangoLotes'] = $getInfo['rangoLotes'];
                $dataInfo['presupuestoViv'] = $getInfo['presupuestoViv'];
                $dataInfo['presupuestoPaq'] = $getInfo['presupuestoPaq'];
                $dataInfo['total_unitario'] = $getInfo['total_unitario'];
                $dataInfo['total_paquete'] = $getInfo['total_paquete'];
                $dataInfo['costoM2'] = $getInfo['costoM2'];
                $dataInfo['m2Viv'] = $getInfo['m2Viv'];
                $dataInfo['totalEncabezado'] = $sum;
                $dataInfo['pptoTotal'] = $getInfo['pptoTotal'];
                $dataInfo['contratista'] = $getInfo['contratista'];
                //ppt unitario materuales
            }else{
                $dataInfo['prototipo'] = '';
                $dataInfo['fraccionamiento'] = '';
                $dataInfo['rangoLotes'] = '';
                $dataInfo['presupuestoViv'] = '';
                $dataInfo['presupuestoPaq'] = '';
                $dataInfo['total_unitario'] = '';
                $dataInfo['total_paquete'] = '';
                $dataInfo['costoM2'] = '';
                $dataInfo['pptoTotal'] = '';
                $dataInfo['m2Viv'] = '';
                $dataInfo['totalEncabezado'] = '';
                $dataInfo['contratista'] = '';
            }

            $data['rows'] .=  $this->load->view($this->mainView . '/rows_view', $dataInfo, true);

        }

        $data['total'] = $sum;
        $data['info'] = $this->marranque->getById($id);
        $this->data['contenido'] = $this->load->view($this->mainView . '/ver_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }
  

    

    public function getInfoVer($idPaquete)
    {
        $paquete = $this->mpaquete->getById($idPaquete);
        $qManoObra = $this->mmanoobra->getById($paquete['idManoObra']);
        $superficieM2 = $this->mprototipos->getCampo('superficieM2',$qManoObra['idPrototipo']);
        $prototipo = $this->mprototipos->getById($qManoObra['idPrototipo']);
        $qContratista = $this->mconstructores->getById($paquete['idConstructor']);
        $contratista = (!is_numeric($qContratista)) ? $qContratista['nombre'].' '.$qContratista['apellidoP'].' '.$qContratista['apellidoM'] : '';

        $totalPresupuestoMO = $this->mpresupuestomo->getSumTotalUnitario($paquete["idManoObra"],$idPaquete);
        $totalUnitario = $totalPresupuestoMO;
        $lotesManzana = contarLotesManzanas($paquete['rango_lotes']);
        $lotes = $lotesManzana['total'];
        $totalPaquete = $totalUnitario * $lotes;

        $material = $this->mmaterial->getByIdFraccIdProtIdMO($qManoObra['idFraccionamiento'], $qManoObra['idPrototipo'], $idPaquete);
        $detalle = $this->mdetallepaquete->getByIdPaquete($idPaquete);
        // Ppto. Total = Ppto. X paquete mo + Ppto. X paquete mat.
        $totalEncabezado = '';
        if (!is_numeric($paquete) && !is_numeric($prototipo) && !is_numeric($material)) {
            $presupuestoViv = $this->mpresupuestomat->getSumTotalImporte($material['id']);
            //$lotes = (!is_numeric($detalle)) ? $detalle->num_rows() : 0;
            $presupuestoPaq = $presupuestoViv * $lotes;
            $costoM2 = $presupuestoViv / $superficieM2;
            $pptoTotal = $totalPaquete + $presupuestoPaq;
            //$totalEncabezado += $pptoTotal;
            $response = array('prototipo' => $prototipo['titulo'],
                'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo', $qManoObra['idFraccionamiento']),
                'rangoLotes' => (!is_numeric($detalle))? $detalle->num_rows() : 0,
                'presupuestoViv' => precio_format($presupuestoViv),
                'presupuestoPaq' => precio_format($presupuestoPaq),
                'total_unitario' => "$".number_format($totalUnitario,2),
                'total_paquete' => "$".number_format($totalPaquete,2),
                'pptoTotal' => "$".number_format($pptoTotal,2),
                'costoM2' => precio_format($costoM2),
                'totalEncabezado' => $pptoTotal,
                'm2Viv' => $prototipo['superficieM2'],
                'contratista' => $contratista
            );
        } else {
            $response = 0;
        }
        return $response;
    }

    public function getPaquetes($idEmpresa,$idArranque=0){
        $idPaquetes=$this->marranque->getCampo('idPaquetes',$idArranque);
        $paquetes = $this->mpaquete->getByExistInArranque($idEmpresa,$idArranque,$idPaquetes);
        $paquetes=(!is_numeric($paquetes)) ? $paquetes->result() : 0;
        echo json_encode($paquetes);
    }

    public function cambioEstatus($id, $estatus){
        $info = $this->marranque->getById($id);
        $msg = array();
        $sesion = 0;
        $isTable = 0;
        $showNotification = 0;
        $seguir = false;
        if($estatus == 2){
            $showNotification = 1;
            $count = 0;
            $countIdPaq = explode(',', $info['idPaquetes']);
            $countArray = count($countIdPaq);
            foreach ($countIdPaq as $key => $value) {
                $qPaquete = $this->mpaquete->getById($value);
                if(!is_numeric($qPaquete)){
                    $manoObra = $this->mmanoobra->getById($qPaquete['idManoObra']);
                    $material = $this->mmaterial->getByIdPaquete($qPaquete['id']);
                    $estimacion = $this->mestimacionprograma->getByIdPaquete($qPaquete['id']);
                    $detallePaquete = $this->mdetallepaquete->getByIdPaquete($qPaquete['id']);
                    $checkPrograma=$this->checkPrograma($qPaquete['id']);

                    if((!is_numeric($manoObra) && $manoObra['id'] != '') && (!is_numeric($estimacion) && $estimacion['id'] != '') && $detallePaquete->num_rows() > 0 && $checkPrograma){
                        $count++;
                    }else{
                        $isTable = 1;
                        $msg[$qPaquete['titulo']]['paquete'] = $qPaquete['titulo'];
                        if(!is_numeric($manoObra) && $manoObra['id'] != ''){
                            //$msg .= '<td>SI</td>';
                            $msg[$qPaquete['titulo']]['pmo'] = '<i class="fa fa-check" style="color: green;" aria-hidden="true"></i>';
                        }else{
                            //$msg .= '<td>NO</td>';
                            $msg[$qPaquete['titulo']]['pmo'] = '<i class="fa fa-times" style="color: red;" aria-hidden="true"></i>';
                        }
                        if(!is_numeric($material) && $material['id'] != ''){
                            //$msg .= '<td>SI</td>';
                            $msg[$qPaquete['titulo']]['pmat'] = '<i class="fa fa-check" style="color: green;" aria-hidden="true"></i>';
                        }else{
                            //$msg .= '<td>NO</td>';
                            $msg[$qPaquete['titulo']]['pmat'] = '<i class="fa fa-times" style="color: red;" aria-hidden="true"></i>';
                        }
                        if(!is_numeric($estimacion) && $estimacion['id'] != ''){
                            //$msg .= '<td>SI</td>';
                            $msg[$qPaquete['titulo']]['estimaciones'] = '<i class="fa fa-check" style="color: green;" aria-hidden="true"></i>';
                        }else{
                            //$msg .= '<td>NO</td>';
                            $msg[$qPaquete['titulo']]['estimaciones'] = '<i class="fa fa-times" style="color: red;" aria-hidden="true"></i>';
                        }
                        if($detallePaquete->num_rows() > 0){
                            //$msg .= '<td>SI</td>';
                            $msg[$qPaquete['titulo']]['residentes'] = '<i class="fa fa-check" style="color: green;" aria-hidden="true"></i>';
                        }else{
                            //$msg .= '<td>NO</td>';
                            $msg[$qPaquete['titulo']]['residentes'] = '<i class="fa fa-times" style="color: red;" aria-hidden="true"></i>';
                        }
                        if($checkPrograma){
                            //$msg .= '<td>SI</td>';
                            $msg[$qPaquete['titulo']]['programa'] = '<i class="fa fa-check" style="color: green;" aria-hidden="true"></i>';
                        }else{
                            //$msg .= '<td>NO</td>';
                            $msg[$qPaquete['titulo']]['programa'] = '<i class="fa fa-times" style="color: red;" aria-hidden="true"></i>';
                        }
                        //$msg .= '</tr>';
                    }
                }
            }

            if($count == $countArray){
                $seguir = true;
            }

            if($seguir){
                $ids[] = 0;
                $temp = explode(',', $info['idPaquetes']);
                if( !empty($temp[0]) ){
                    foreach($temp as $v){
                        if( !in_array($v, $ids, true) && is_numeric($v)){
                            $ids[] = $v;
                        }
                    }
                }
                $paquetes = $this->mpaquete->getInIds($ids);
                $destinatarioMail = correosNotificaciones('arranque');
                $cuerpo = '';
                $htmlArra = '';
                $sum = 0;

                foreach ($paquetes->result() as $row) {
                    $idPrototipo = $this->mmanoobra->getCampo('idPrototipo',$row->idManoObra);
                    $idpaquete   = $row->id;
                    $fechaFormatIni = ($row->fecha_inicio!='')?date('d/m/Y', strtotime($row->fecha_inicio)):'0000-00-00';
                    $fechaFormatFin = ($row->fecha_fin!='')?date('d/m/Y', strtotime($row->fecha_fin)):'0000-00-00';
                    $nompaquete   = strtoupper($row->titulo);
                    $idProto   = $this->mprototipos->getCampo('nombre',$idPrototipo);
                    $fechaIni   = $fechaFormatIni;
                    $fechaFin   = $fechaFormatFin;
                    $noViviendas   = $row->rango_lotes;
                    //LLAMAR GET INFO VER
                    $getInfo = $this->getInfoVer($idpaquete);
                    $sum +=  $getInfo['totalEncabezado'];

                    if($getInfo != 0){
                        $data['prototipo'] = $getInfo['prototipo'];
                        $data['fraccionamiento'] = $getInfo['fraccionamiento'];
                        $data['rangoLotes'] = $getInfo['rangoLotes'];
                        $data['presupuestoViv'] = $getInfo['presupuestoViv'];
                        $data['presupuestoPaq'] = $getInfo['presupuestoPaq'];
                        $data['total_unitario'] = $getInfo['total_unitario'];
                        $data['total_paquete'] = $getInfo['total_paquete'];
                        $data['costoM2'] = $getInfo['costoM2'];
                        $data['m2Viv'] = $getInfo['m2Viv'];
                        $data['totalEncabezado'] = $sum;
                        $data['pptoTotal'] = $getInfo['pptoTotal'];
                        //ppt unitario materuales
                    }else{
                        $data['prototipo'] = '';
                        $data['fraccionamiento'] = '';
                        $data['rangoLotes'] = '';
                        $data['presupuestoViv'] = '';
                        $data['presupuestoPaq'] = '';
                        $data['total_unitario'] = '';
                        $data['total_paquete'] = '';
                        $data['costoM2'] = '';
                        $data['pptoTotal'] = '';
                        $data['m2Viv'] = '';
                        $data['totalEncabezado'] = '';
                    }

                    $cuerpo .= '
                        <tr >
                            <td class="paddinginfo " >  </td>
                            <td class="paddinginfo " >    </td>
                        </tr>
                        <tr >
                            <td class="paddinginfo borderyellow greentitle" > PAQUETE: </td>
                            <td class="paddinginfo borderyellow" > '. $nompaquete.'    </td>
                        </tr>
                        <tr>
                            <td class="paddinginfo borderyellow greentitle" > PROTOTIPO: </td>
                            <td class="paddinginfo borderyellow" > '. $idProto.'    </td>
                        </tr>
                        <tr>
                            <td class="paddinginfo borderyellow greentitle" >  FECHA INICIO: </td>
                            <td class="paddinginfo borderyellow" > '. $fechaIni.'    </td>
                        </tr>
                        <tr>
                            <td class="paddinginfo borderyellow greentitle" >  FECHA FINAL: </td>
                            <td class="paddinginfo borderyellow" > '. $fechaFin.'    </td>
                        </tr>
                        <tr>
                            <td class="paddinginfo borderyellow greentitle" >  No. VIVIENDAS: </td>
                            <td class="paddinginfo borderyellow" > '. $data['rangoLotes'] .'    </td>
                        </tr>
                            <tr>
                            <td class="paddinginfo borderyellow greentitle" > PPTO. UNITARIO MO: </td>
                            <td class="paddinginfo borderyellow" >'.$data['total_unitario'].'  </td>
                        </tr>
                        <tr>
                            <td class="paddinginfo borderyellow greentitle" > PPTO. X PAQUETE MO: </td>
                            <td class="paddinginfo borderyellow" > '.$data['total_paquete'].' </td>
                        </tr>
                        <tr>
                            <td class="paddinginfo borderyellow greentitle" > PPTO. UNITARIO MAT: </td>
                            <td class="paddinginfo borderyellow" > '.$data['presupuestoViv'] .' </td>
                        </tr>
                        <tr>
                            <td class="paddinginfo borderyellow greentitle" > PPTO. X PAQUETE MAT: </td>
                            <td class="paddinginfo borderyellow" > '.$data['presupuestoPaq'] .' </td>
                        </tr>
                        <tr>
                            <td class="paddinginfo borderyellow greentitle" > PPTO. TOTAL: </td>
                            <td class="paddinginfo borderyellow" >  '.$data['pptoTotal'].' </td>
                        </tr>
                    ';

                }   //Termina el foreach

                $htmlArra ='
                    <tr>
                        <td class="innerpadding borderbottom">
                            <!-- [if (gte mso 9)|(IE)]>
                            <table width="380" align="left" cellpadding="0" cellspacing="0" border="0">
                                <tr>
                                <td>
                            <![endif]-->
                            <table class="col380" align="left" border="0" cellpadding="0" cellspacing="0" style="width: 100%; max-width: 100%;">
                            <tr>
                                <td>
                                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                        <tr>
                                            <td class="paddinginfo greentitle" > </td>
                                            <td class="paddinginfo" >
                                                <table border="0" cellspacing="0" cellpadding="0">
                                                    <tr>
                                                        <td class="paddingencabezados greentitle" > Arranque: </td>
                                                        <td class="" > '.$info['titulo'].' </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="paddingencabezados greentitle" > N° Contrato: </td>
                                                        <td class="" > '.$info['numeroContrato'].' </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="paddingencabezados greentitle" > Fecha Inicio:</td>
                                                        <td class="" >'.date('d/m/Y', strtotime($info['fecha_inicio'])).'</td>
                                                    </tr>
                                                    <tr>
                                                        <td class="paddingencabezados greentitle" > Total:</td>
                                                        <td class="" >'.precio_format($data['totalEncabezado']).'</td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <br>
                                        '.$cuerpo.'
                                        <!--  <tr>
                                            <td class="paddinginfo borderyellow greentitle" > PAQUETE: </td>
                                            <td class="paddinginfo borderyellow" > 1    </td>
                                        </tr> -->


                                </table>
                                </td>
                            </tr>
                            </table>
                            <!--[if (gte mso 9)|(IE)]>
                                </td>
                                </tr>
                            </table>
                            <![endif]-->
                        </td>
                    </tr>
                ';
                $subject = $info['titulo'].' '.'En Curso' ;
                $destMail = $destinatarioMail['to'];
                $notificacion = email_notificaciones($htmlArra,$subject,$destMail,'');

                //creacion de almacenes
                require('Cronjob.php');
                $cronjob = new Cronjob();
                $mData = array();
                if(!is_numeric($info)){
                    $crearAlmacen = false;
                    $msgError = '';
                    $countPq = 0;
                    //validacion de tipo de arranque
                    if($info["tipoAlmacen"]==1){
                        $array = explode(',', $info['idPaquetes']);
                        $countAlmacenes = 0;
                        foreach ($array as $key => $value) {
                            $qPaquete = $this->mpaquete->getById($value);
                            if(!is_numeric($qPaquete)){
                                $material = $this->mmaterial->getByIdPaquete($qPaquete['id']);
                                if(!is_numeric($material)){
                                    $crearAlmacen = true;
                                    $idEmpresa = (!is_numeric($material)) ? $material['idEmpresa'] : 0;
                                    $countPq++;
                                    $mData['un'] = $idEmpresa;
                                    $mData['nombre'] = $qPaquete['titulo'];
                                    $mData['nombre_abrev'] = "Abrev";
                                    $mData['ciudad_id'] = "0";
                                    $mData['cp'] = "";
                                    $mData['telefono1'] = "";
                                    $mData['telefono2'] = "";
                                    $mData['clave'] = $this->getClave();

                                    $response = $cronjob->addAlmacen($mData);
                                    if($response['error'] == false){
                                        if($response['responseObject']){
                                            unset($mData['un']);
                                            $mData['ciudad'] = $mData['ciudad_id'];
                                            unset($mData['ciudad_id']);
                                            //$idEmpresa = $_SESSION["viv"]['idEmpresa'];
                                            $mData['idEmpresa'] = $idEmpresa;
                                            $mData['idPaquete'] = $qPaquete['id'];
                                            $mData['id'] = $response['resultado']['id'];
                                            $mData['id_departamento'] = $response['resultado']['id_departamento'];

                                            if($this->malmacenes->valInsert($mData['id'],$idEmpresa)){
                                                $idAlmacen = $this->malmacenes->insertar($mData);
                                                $countAlmacenes++;
                                            }
                                        }else{
                                            $msgError .= $response['error_message'].'<br><br>';
                                        }
                                    }else{
                                        $msgError .= $response['error_message'].'<br><br>';
                                    }
                                }
                            }
                        }
                    }else if($info["tipoAlmacen"]==2){
                        $countAlmacenes = 0;
                        $crearAlmacen = true;
                        $idEmpresa = $info["idEmpresa"];
                        $countPq++;
                        $mData['un'] = $idEmpresa;
                        $mData['nombre'] = $info["titulo"];
                        $mData['nombre_abrev'] = "Abrev";
                        $mData['ciudad_id'] = "0";
                        $mData['cp'] = "";
                        $mData['telefono1'] = "";
                        $mData['telefono2'] = "";
                        $mData['clave'] = $this->getClave();

                        $response = $cronjob->addAlmacen($mData);
                        if($response['error'] == false){
                            if($response['responseObject']){
                                unset($mData['un']);
                                $mData['ciudad'] = $mData['ciudad_id'];
                                unset($mData['ciudad_id']);
                                $mData['idEmpresa'] = $idEmpresa;
                                $mData['idPaquete'] = $info["idPaquetes"];
                                $mData['id'] = $response['resultado']['id'];
                                $mData['id_departamento'] = $response['resultado']['id_departamento'];
                                $mData['idArranque'] = $info["id"];
                                $mData['tipoAlmacen'] = $info["tipoAlmacen"];

                                if($this->malmacenes->valInsert($mData['id'],$idEmpresa)){
                                    $idAlmacen = $this->malmacenes->insertar($mData);
                                    $countAlmacenes++;
                                }
                            }else{
                                $msgError .= $response['error_message'].'<br><br>';
                            }
                        }else{
                            $msgError .= $response['error_message'].'<br><br>';
                        }
                        $idPaquetes=$info['idPaquetes'];
                        $this->db->query("UPDATE material mate SET mate.idArranque=(SELECT id FROM arranque arr WHERE FIND_IN_SET(mate.idPaquete,arr.idPaquetes)) AND FIND_IN_SET(mate.idPaquete,'$idPaquetes')");
                    }

                    if($crearAlmacen){
                        if($countPq == $countAlmacenes){
                            $isTable = 0;
                            $msg = 'EL ARRANQUE '.$info['titulo'].' SE PONDRÁ EN CURSO';

                            $pData['estatus_arranque'] = 2;
                            $this->marranque->actualizar($pData, $info['id']);
                            $this->insertTasks($id);
                        }else{
                            $isTable = 0;
                            $msg = 'ERRORES ECONTRADOS AL CREAR LOS ALMACENES DEL ARRANQUE <br><br><br>'.$msgError;
                        }
                    }
                }
            }
        }else if($estatus == 3){
            $isTable = 0;
            $showNotification = 1;
            $msg = 'EL ARRANQUE '.$info['titulo'].' SE PONDRÁ EN FINALIZADO';
            $pData['estatus_arranque'] = 3;
            $this->marranque->actualizar($pData, $info['id']);
        }
        $data['notificacion'] = $msg;
        $data['showNotification'] = $showNotification;
        $data['isTable'] = $isTable;
        $data['sesion'] = $sesion;
        // variables para arranque y excedenete
        echo json_encode($data);
    }

    public function checkPrograma($idPaquete){
        $status=false;
        $rowPaq=$this->db->query("SELECT paq.id,paq.idManoObra,paq.nLotes,paq.titulo FROM paquetes paq
        LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes)
        WHERE arr.estatus_arranque=1 AND paq.id=$idPaquete");
        if($rowPaq->num_rows() > 0){
            $rowPaq=$rowPaq->row();
            $pmo=$this->db->query("SELECT id FROM presupuesto_mo WHERE tipo=1 AND idManoObra=".$rowPaq->idManoObra);
            $programa=$this->db->query("SELECT id FROM programa_obra WHERE idPaquete=$idPaquete");
            if(($pmo->num_rows()*$rowPaq->nLotes) == $programa->num_rows()){
                $status=true;
            }
        }
        return $status;
    }

    function insertTasks($idArranque=0){
        $tasks=array(
            array('url_func' => 'sendNotifications','idItem' => $idArranque,'periodo'=>0, 'descripcion' => 'arranque', 'tipo' => 1, 'status' => 0),
            array('url_func' => 'sendNotifications','idItem' => $idArranque,'periodo'=>1, 'descripcion' => 'obra negra, acabados,entrega', 'tipo' => 2, 'status' => 0),
        );
        if (count($tasks)>0 && !empty($tasks) ) {
            $this->db->insert_batch('tasks', $tasks);
        }
    }
}


