<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Apis extends MX_Controller {
	var $auth_key = "3b947a0da97d6ee317ff5f6d26665e14";
    public function __construct(){
		// Tools
		$this->load->helper(array('tools','numeros','url','form','date','text','security'));
		// Modelos
		$this->load->model(array('musuario','mestimadosprograma','mavanceobra'));
		ini_set('memory_limit', '-1');
		ini_set('max_execution_time', 0);
	}

	public function getAllCategorias(){
		$token=$this->getBearerToken();
		if($token==$this->auth_key){
			if(isset($_POST["estatus"])){
				$estatus=$_POST["estatus"];
				$query=$this->db->query("SELECT id,clave,categoria FROM categorias_mat WHERE status=$estatus");
				$response=$query->result();
				json_output(200,["error"=>"","result"=>$response]);
			}else{
				json_output( 206, ['error' => "Datos Incorrectos"]);
			}
		}else{
			json_output(401, array('status' => 401,'error' => 'Sin autorización.'));
		}
	}

	public function getAllFraccionamientos(){
		$token=$this->getBearerToken();
		if($token==$this->auth_key){
			if(isset($_POST["estatus"])){
				$estatus=$_POST["estatus"];
				$query=$this->db->query("SELECT fr.id,fr.titulo FROM material mat
				LEFT JOIN fraccionamientos fr ON mat.idFraccionamiento=fr.id
				WHERE fr.status=$estatus GROUP BY mat.idFraccionamiento");
				$response=$query->result();
				json_output(200,["error"=>"","result"=>$response]);
			}else{
				json_output( 206, ['error' => "Datos Incorrectos"]);
			}
		}else{
			json_output(401, array('status' => 401,'error' => 'Sin autorización.'));
		}
	}

	public function getLteMza(){
		$token=$this->getBearerToken();
		if($token==$this->auth_key){
			if(isset($_POST["idFraccionamiento"]) && isset($_POST["lote"]) && isset($_POST["manzana"])){
				$idFraccionamiento=$_POST["idFraccionamiento"];
				$lote=$_POST["lote"];
				$manzana=$_POST["manzana"];
				$query=$this->db->query("SELECT dp.idProyecto,mat.idEmpresa,alm.id idAlmacen,dp.idPaquete,paq.titulo tituloPaquete FROM detalle_paquete dp
										LEFT JOIN paquetes paq ON paq.id=dp.idPaquete
										LEFT JOIN proyectos pro ON pro.id=dp.idProyecto 
										LEFT JOIN material mat ON mat.idPaquete=dp.idPaquete
										LEFT JOIN almacenes alm ON FIND_IN_SET(dp.idPaquete,alm.idPaquete) AND alm.idEmpresa=mat.idEmpresa
										WHERE pro.lote='$lote' AND pro.manzana='$manzana' AND pro.idFraccionamiento=$idFraccionamiento");
				$response=$query->result();
				json_output(200,["error"=>"","result"=>$response]);
			}else{
				json_output( 206, ['error' => "Datos Incorrectos"]);
			}
		}else{
			json_output(401, array('status' => 401,'error' => 'Sin autorización.'));
		}
	}

	public function getCantPptoByIdArticulo(){
		$token=$this->getBearerToken();
		if($token==$this->auth_key){
			if(isset($_POST["idEmpresa"]) && isset($_POST["idPaquete"]) && isset($_POST["idArticulo"])){
				$idEmpresa=$_POST["idEmpresa"];
				$idPaquete=$_POST["idPaquete"];
				$idArticulo=$_POST["idArticulo"];
				$cantidad="SUM(DISTINCT (mact.cantidad) + mact.id) - SUM(DISTINCT mact.id) cantidad";
				$query=$this->db->query("SELECT $cantidad,pmat.clave FROM presupuesto_mat pmat
										LEFT JOIN material mat ON mat.id=pmat.idMaterial
										LEFT JOIN materialesactividadprototipo mact ON mact.id=pmat.idMateriales
										LEFT JOIN materiales mate ON mate.id=mact.idMaterial AND mate.idEmpresa=$idEmpresa
										WHERE mat.idPaquete=$idPaquete AND mat.idEmpresa=$idEmpresa AND mact.idMaterial=$idArticulo
										GROUP BY mact.idMaterial,pmat.clave");
				$response=$query->result();
				json_output(200,["error"=>"","result"=>$response]);
			}else{
				json_output( 206, ['error' => "Datos Incorrectos"]);
			}
		}else{
			json_output(401, array('status' => 401,'error' => 'Sin autorización.'));
		}
	}

	public function getCantPptoByClaveCategoria(){
		$token=$this->getBearerToken();
		if($token==$this->auth_key){
			if(isset($_POST["idEmpresa"]) && isset($_POST["idPaquete"]) && isset($_POST["claveCategoria"])){
				$idEmpresa=$_POST["idEmpresa"];
				$idPaquete=$_POST["idPaquete"];
				$claveCategoria=$_POST["claveCategoria"];
				$cantidad="SUM(DISTINCT (mact.cantidad) + mact.id) - SUM(DISTINCT mact.id) cantidad";
				$query=$this->db->query("SELECT mact.idMaterial idArticulo,$cantidad,pmat.clave FROM presupuesto_mat pmat
										LEFT JOIN material mat ON mat.id=pmat.idMaterial
										LEFT JOIN materialesactividadprototipo mact ON mact.id=pmat.idMateriales
										LEFT JOIN materiales mate ON mate.id=mact.idMaterial AND mate.idEmpresa=$idEmpresa
										WHERE mat.idPaquete=$idPaquete AND mat.idEmpresa=$idEmpresa AND pmat.clave_cat='$claveCategoria'
										GROUP BY mact.idMaterial,pmat.clave");
				$response=$query->result();
				json_output(200,["error"=>"","result"=>$response]);
			}else{
				json_output( 206, ['error' => "Datos Incorrectos"]);
			}
		}else{
			json_output(401, array('status' => 401,'error' => 'Sin autorización.'));
		}
	}

	private function getBearerToken(): ?string {
        $headers = array_change_key_case(getallheaders(), CASE_LOWER);
        if (!isset($headers['authorization'])) {
            return null;
        }
        return trim(str_replace('Bearer', '', $headers['authorization']));
    }

}