<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Api extends MX_Controller {
	var $auth_key = "3b947a0da97d6ee317ff5f6d26665e14";
    public $_db,$time_start,$time_end;
    public function __construct(){
		// Tools
		$this->load->helper(array('tools','numeros','url','form','date','text','security'));
		// Modelos
		$this->load->model(array('musuario','mestimadosprograma','mavanceobra','mcortes','mlogsws'));
		ini_set('memory_limit', '-1');
		ini_set('max_execution_time', 0);
		$this->_db = $this->load->database('default', true);
	}

	public function getTableMat(){
		$method = $_SERVER['REQUEST_METHOD'];
		$response=[];
		if($method != 'POST'){
			json_output(400,array('status' => 400,'msg' => 'Incorrecta'));
		}else{
			$data=$_POST;
			if (isset($data['table'])){
				$table=$data['table'];
				$response=$this->_db->query("SELECT * FROM $table");
			}
			$response=($response->num_rows() > 0) ? $response->result() : 0;
			json_output(200,$response);
		}
	}

	public function login(){
		$method = $_SERVER['REQUEST_METHOD'];
		$auth=false;
		if($method != 'POST'){
			json_output(400,array('status' => 400,'msg' => 'Incorrecta'));
		}else{
			$data=$_POST;
			//if(isset($data['key']) && $data['key'] == $this->auth_key ){
				if (isset($data['user'])){
					$tipo=(isset($data['calidad'])) ? 'calidad' : 'obra';
					$res = $this->musuario->checkUserApi($data["user"],sha1($data["pass"]),$tipo);
					if ($res->num_rows() == 1){
						if ($res->row()->status == 1){
							$_SESSION[$this->nsession] = array(
								'usuario'       => $res->row()->usuario,
								'id'            =>$res->row()->id,
								'rol'            =>$res->row()->rol
							);
							$data['error'] = 0;
							$data['titulo'] = '';
							$data['msg'] = 'Bienvenido.';
							$data['id'] = intval($res->row()->id);
							$data['usuario'] = $res->row()->usuario;
							$data['nombre'] = $res->row()->nombre;
							$data['rol'] = intval($res->row()->rol);
							$data['url'] = site_url('inicio');
							$data['authToken']=$_SESSION["__ci_last_regenerate"];
							$auth=true;
						} else {
							$data['titulo'] = 'Error';
							$data['error'] = 1;
							$data['msg'] = 'Tu cuenta ha sido desactivada.';
						}
					} else {
						$data['titulo'] = 'Error';
						$data['error'] = 1;
						$data['msg'] = 'Tu nombre de usuario o contrase&ntilde;a son incorrectos.';
					}
				}
				$data["auth"]=$auth;
				json_output(200,$data);
		    //} else {
			//	return json_output(401, array('status' => 401,'error' => 'Sin autorización.','auth'=>$auth));
			//}
		}
	}

	public function sync(){
		$method = $_SERVER['REQUEST_METHOD'];
		if($method != 'POST'){
			json_output(400,array('status' => 400,'msg' => 'Incorrecta'));
		}else{
			$myquery="";
			$data=$_POST;
			$result=[];
			$filterCalidad=(isset($data["calidad"])) ? "AND (ao.lotes OR ao.avanceC OR ao.iniciado)" : "";
			if(isset($data["tabla"]) && isset($data["idSupervisor"])){
				$checkup=isset($data["checkup"]) ? $data["checkup"] : false;
				$idSupervisor=$data["idSupervisor"];
				$tipo=isset($data["calidad"]) ? "calidad": "obra";
				$mark=isset($data["mark"]) ? $data["mark"] : 0;
				$tabla=$data["tabla"];
				switch ($tabla) {
					case 'fraccionamientos':
						$query=$this->myquery('fr',$data,"		
						LEFT JOIN proyectos pro ON pro.id=dp.idProyecto 
						LEFT JOIN fraccionamientos fr ON fr.id=pro.idFraccionamiento","","fraccionamientos");
						break;
					case 'proyectos':
						$query=$this->myquery('pro',$data,"		
						LEFT JOIN proyectos pro ON pro.id=dp.idProyecto","","proyectos");
						break;
					case 'categorias_mo':
						$query=$this->myquery('cmo',$data,"		
        				LEFT JOIN mano_obra mo ON mo.id=paq.idManoObra
						LEFT JOIN presupuesto_mo pmo ON pmo.idManoObra=mo.id
						LEFT JOIN actividadesprototipo act ON act.id=pmo.idActividadPrototipo
						LEFT JOIN actividades_mo actmo ON actmo.id=act.idActividad
                        LEFT JOIN categorias_mo cmo ON cmo.id=actmo.idCategoria","","categorias_mo");
						break;
					case 'unidades':
						$query=$this->myquery('unit',$data,"		
        				LEFT JOIN mano_obra mo ON mo.id=paq.idManoObra
						LEFT JOIN presupuesto_mo pmo ON pmo.idManoObra=mo.id
						LEFT JOIN actividadesprototipo act ON act.id=pmo.idActividadPrototipo
						LEFT JOIN actividades_mo actmo ON actmo.id=act.idActividad
                        LEFT JOIN unidades unit ON unit.id=actmo.idUnidad","","unidades");
						break;
					case 'detalle_paquete':
						$query=$this->myquery('dp',$data,"","","detalle_paquete");
						$column=$this->getColumn($data);
						$tmpQuery=$this->db->query("SELECT id FROM detalle_paquete dp WHERE dp.$column=$idSupervisor");
						if(!$checkup){
							if($tmpQuery->num_rows()>0){
								$ids=implode(',',array_column($tmpQuery->result(),'id'));
								$myquery="UPDATE detalle_paquete SET $column=0 WHERE id NOT IN ('$ids') AND $column=$idSupervisor";
							}
						}
						break;
					case 'arranque':
						$query=$this->myquery('arr',$data,"","","arranque");
						break;
					case 'paquetes':
						$query=$this->myquery('paq',$data,"","","paquetes");
						break;
					case 'paquete_presupuesto':
						$query=$this->myquery('pp',$data,"LEFT JOIN paquete_presupuesto pp ON pp.idPaquete=paq.id","","paquete_presupuesto");
						break;
					case 'programa_obra':
						$query=$this->myquery('prog',$data,"LEFT JOIN programa_obra prog ON prog.idPaquete=paq.id","","programa_obra");
						break;
					case 'mano_obra':
						$query=$this->myquery('mo',$data,"LEFT JOIN mano_obra mo ON mo.id=paq.idManoObra","","mano_obra");
						break;
					case 'presupuesto_mo':
						$query=$this->myquery('pmo',$data,"
						LEFT JOIN mano_obra mo ON mo.id=paq.idManoObra
						LEFT JOIN presupuesto_mo pmo ON pmo.idManoObra=mo.id","","presupuesto_mo");
						break;
					case 'actividades_mo':
						$query=$this->myquery('actmo',$data,"		
						LEFT JOIN mano_obra mo ON mo.id=paq.idManoObra
						LEFT JOIN presupuesto_mo pmo ON pmo.idManoObra=mo.id
						LEFT JOIN actividadesprototipo act ON act.id=pmo.idActividadPrototipo
						LEFT JOIN actividades_mo actmo ON actmo.id=act.idActividad","","actividades_mo");
						break;
					case 'prototipos':
						$query=$this->myquery('pr',$data,"		
						LEFT JOIN proyectos pro ON pro.id=dp.idProyecto 
						LEFT JOIN prototipos pr ON pr.id=pro.idPrototipo","","prototipos");
						break;
					case 'constructores':
						$query=$this->myquery('con',$data,"LEFT JOIN constructores con ON con.id=paq.idConstructor","","constructores");
						break;
					//estimaciones
					case 'estimacion_programa':
						$query=$this->myquery('ion',$data,"		
						LEFT JOIN estimacion_programa ion ON ion.idPaquete=paq.id
						LEFT JOIN estimaciones_programa iones ON iones.idEstimacion=ion.id","","estimacion_programa");
						break;
					case 'estimaciones_programa':
						$query=$this->myquery('iones',$data,"		
						LEFT JOIN estimacion_programa ion ON ion.idPaquete=paq.id
						LEFT JOIN estimaciones_programa iones ON iones.idEstimacion=ion.id","","estimaciones_programa");
						break;
					case 'estimados_programa':
						$query=$this->myquery('ados',$data,"		
						LEFT JOIN estimacion_programa ion ON ion.idPaquete=paq.id
						LEFT JOIN estimaciones_programa iones ON iones.idEstimacion=ion.id
						LEFT JOIN estimados_programa ados ON ados.idEstimaciones=iones.id
						LEFT JOIN avanceobra ao ON ao.idEstimado=ados.id","AND WEEK(iones.fecha,7)=WEEK(NOW(),7) $filterCalidad","estimados_programa");
						break;
					case 'avanceobra':
						$query=$this->myquery('ao',$data,"		
						LEFT JOIN estimacion_programa ion ON ion.idPaquete=paq.id
						LEFT JOIN estimaciones_programa iones ON iones.idEstimacion=ion.id
						LEFT JOIN estimados_programa ados ON ados.idEstimaciones=iones.id
						LEFT JOIN avanceobra ao ON ao.idEstimado=ados.id","AND WEEK(iones.fecha,7)=WEEK(NOW(),7) $filterCalidad","avanceobra");
						break;
					case 'ajustes':
						$query=$this->myquery('aju',$data,"		
						LEFT JOIN ajustes aju ON aju.idProyecto=dp.idProyecto","AND aju.tipoPpto=2","ajustes");
						break;
					case 'actividadesprototipo':
						$query=$this->myquery('act',$data,"		
						LEFT JOIN mano_obra mo ON mo.id=paq.idManoObra
						LEFT JOIN presupuesto_mo pmo ON pmo.idManoObra=mo.id
						LEFT JOIN actividadesprototipo act ON act.id=pmo.idActividadPrototipo","","actividadesprototipo");
						break;
					case 'usuarios':
						$query=$this->myquery('user',$data,"		
						LEFT JOIN usuarios user ON user.id=dp.idResidente","","usuarios");
						break;
					default:
						$query=0;
						break;
				}
				//ejecución de query
				$result=(!is_numeric($result)) ? $this->_db->query($query)->result() : [];
				//ajustes de query para SQLite
				if ($tabla == 'estimados_programa' || $tabla == 'avanceobra'){
					$query=str_replace("WEEK(iones.fecha,7)=WEEK(NOW(),7)"," strftime('%W',iones.fecha)=strftime('%W',date('now','weekday 0', '-6 days')) ",$query);
					//$query=str_replace("WEEK(iones.fecha,7)=WEEK(NOW(),7)","strftime('%W',iones.fecha)=strftime('%W','now') ",$query);
				}
				if($checkup){
					$query=str_replace("FIND_IN_SET(paq.id,arr.idPaquetes)", "(arr.idPaquetes LIKE '%' || paq.id || ',%' OR arr.idPaquetes LIKE '%,' ||
					paq.id OR arr.idPaquetes LIKE '%,' || paq.id || ',%' OR arr.idPaquetes = paq.id)", $query);
				}else{	
					$query="";
				}
				//insert logs_ws
				if(!$checkup){
					$logQuery="SELECT id FROM logs_ws WHERE created_by=$idSupervisor AND nombreTabla LIKE '%syncApp%' 
					AND TIMESTAMPDIFF(MINUTE,created,NOW()) < 30 AND actualizados=0 ORDER BY id DESC LIMIT 1";
					if(!is_numeric($mark)){
						if($mark=="inicio"){
							//INIT SYNC
							$_SESSION[$this->nsession]["time_start"] = microtime(true);
							$dataL['nombreTabla'] = 'syncApp-'.$mark;
							$dataL['funcion'] = $tipo;
							$dataL['http_code'] = isset($data["fecha"]) ? $data["fecha"] : "";
							$dataL['insertados'] = 1;
							$dataL['json'] = isset($data["json"]) ? $data["json"] : "";
							$idLog=$this->mlogsws->insertar($dataL);
							$this->db->query("UPDATE logs_ws SET created_by=$idSupervisor WHERE id=$idLog");
						}else if($mark=="fin"){
							//END SYNC
							$dataL['nombreTabla'] = 'syncApp-'.$mark;
							$dataL['actualizados'] = 1;
							$lastLog=$this->db->query($logQuery);
							if($lastLog->num_rows()>0){
								$idLog=$lastLog->row()->id;
								$this->mlogsws->actualizar($dataL,$idLog);
							}
						}else{
							//SYNC
							$dataL['nombreTabla'] = 'syncApp-'.$tabla;
							$lastLog=$this->db->query($logQuery);
							if($lastLog->num_rows()>0){
								$idLog=$lastLog->row()->id;
								$this->mlogsws->actualizar($dataL,$idLog);
							}
						}
					}
				}
				json_output(200,["error"=>"","result"=>$result,"query"=>$query,"myquery"=>$myquery]);
			}else{
				json_output(401, array('status' => 401,'error' => 'Sin autorización.'));
			}
		}
	}

	public function myquery($alias,$data,$body='',$extra='',$table=""){
		$column=$this->getColumn($data);
		$checkup=isset($data["checkup"]) ? $data["checkup"] : false;
		$filter=" WHERE arr.estatus_arranque=2 AND dp.$column > 0 AND dp.$column IS NOT NULL ";
		$filter.=(isset($data["idSupervisor"])) ? " AND dp.$column=".$data["idSupervisor"] : "";
		$filter.=(isset($data["fecha"])) ? " AND $alias.updated > '".$data["fecha"]."' " : "";
		$fields=getApiColumns($table,$alias);
		$columns=($checkup) ? "COUNT(DISTINCT $alias.id) n" : "$fields,NOW() synced";
		$init=" detalle_paquete dp
		LEFT JOIN paquetes paq ON paq.id=dp.idPaquete 
		LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes) ";

		$query="SELECT $columns FROM $init $body $filter $extra";
		$query.=($checkup) ? "" : " GROUP BY $alias.id ORDER BY $alias.id DESC";
		return $query;
	}

	public function getColumn($data){
		$column="";
		if(isset($data["calidad"])){
			$column=(isset($data["coordinador"])) ? "idCoordinadorC" : "idInspector";
		}else{
			$column=(isset($data["coordinador"])) ? "idCoordinador" : "idResidente";
		}
		return $column;
	}

	public function updateObra(){
		$method = $_SERVER['REQUEST_METHOD'];
		if($method != 'POST'){
			json_output(400,array('status' => 400,'msg' => 'Incorrecta'));
		}else{
			$query=$test='';
			$post=$_POST;
			if(isset($post['table']) && isset($post['data']) && isset($post['id']) ){
				$table=$post['table'];
				$data=($post['data'] != '') ? json_decode($post['data']) : [];
				$idSupervisor=$post['id'];
				$tipo=(isset($_POST['calidad'])) ? 'calidad' : 'obra';
				//validacion de permisos de actualizacion por lote/manzana y supervisor
				if(COUNT($data) > 0 && ($table=="paquete_presupuesto" || $table=="avanceobra")){
					foreach ($data as $row) {
						if($tipo=="obra"){
							$query=$this->getQuery($row->id,$idSupervisor,$table,"lotes",$tipo);
							//validaciones de obra ------------
							if($query->num_rows() > 0){
								$query=$query->row();
								if($query->ltemza != ''){
									//LOTE CONCEPTO
									if($query->tipoEstimacion==1){
										$this->getLotesStr($row,$query,$row->lotes,"lotes");
									//COMPLEMENTARIA
									}else if($query->tipoEstimacion==2){
										$ltemzaArr=explode(',',$query->ltemza);
										$lotes=($table == "avanceobra") ? $row->avanceC : $row->acumulado;
										$lotesArr=($lotes!= '') ? json_decode($lotes,true) : [];
										$lotesU=($table == "avanceobra") ? $query->avanceC : $query->acumulado;
										$lotesUArr=($lotesU != '') ? json_decode($lotesU,true) : [];
										if(COUNT($lotesArr) > 0){
											foreach ($lotesArr as $lote => $cantidad) {
												if(in_array($lote,$ltemzaArr)){
													$lotesUArr[$lote]=floatval($cantidad);
												}
											}
											//actualizacion
											$column=($table == "avanceobra") ? 'avanceC' : 'acumulado';
											$lotesStr=json_encode($lotesUArr);
											$this->_db->query("UPDATE $table SET $column='$lotesStr',updated=NOW(),updated_by=$idSupervisor WHERE id=$row->id");
										}
									}
									//insertar iniciado
									$column=($table == "avanceobra") ? 'iniciado' : 'lotesI';
									$insertLotes=($table == "avanceobra") ? $row->iniciado : $row->lotesI;
									$query=$this->getQuery($row->id,$idSupervisor,$table,$column,$tipo);
									$query=$query->row();
									$this->getLotesStr($row,$query,$insertLotes,$column);
								}
							}//fin validaciones de obra--------------
						}else if($tipo=="calidad" && $table=="avanceobra"){
							$query=$this->getQuery($row->id,$idSupervisor,$table,"calidad",$tipo);
							$query=$query->row();
							//test
							$ltemzaArr=explode(',',$query->ltemza);
							$lotesArr=json_decode($row->calidad,true);
							$lotesUArr=($query->lotes != '') ? json_decode($query->lotes,true) : [];
							if(COUNT($lotesArr) > 0){
								foreach ($lotesArr as $lote => $valor) {
									if(in_array($lote,$ltemzaArr)){
										$lotesUArr[$lote]=$valor;
									}
								}
								//actualizacion
								$lotesStr=json_encode($lotesUArr);
								$this->_db->query("UPDATE $table SET calidad='$lotesStr',updated=NOW(),updated_by=$idSupervisor WHERE id=$row->id");
							}
						}
					}
				}
				$now=$this->_db->query("SELECT ADDTIME(NOW(), '2') timedate");
				json_output(200,["error"=>"","result"=>$now->row()->timedate,'test'=>$test]);
			}else{
				json_output(401, array('status' => 401,'error' => 'Sin autorización.'));
			}
		}
	}

	public function getLotesStr($row,$query,$insertLotes,$column="lotes"){
		$table=$_POST['table'];
		$idSupervisor=$_POST['id'];
		$ltemzaArr=explode(',',$query->ltemza);
		$lotesArr=($insertLotes != '') ? explode(',',$insertLotes) : [];
		$lotesUArr=($query->lotes != '') ? explode(',',$query->lotes) : [];
		if(COUNT($lotesArr) > 0){
			foreach ($lotesArr as $lote) {
				if(in_array($lote,$ltemzaArr)){
					if(!in_array($lote,$lotesUArr)){
						array_push($lotesUArr,$lote);
					}
				}
			}
			//actualizacion
			$lotesStr=implode(',',$lotesUArr);
			//print(($column=="iniciado" && $lotesStr!="") ? "iniciado ".$row->id." ".$table."-".$column."-".$lotesStr."<br>" : "");
			$this->_db->query("UPDATE $table SET $column='$lotesStr',updated=NOW(),updated_by=$idSupervisor WHERE id=$row->id");
		}
	}

	public function getQuery($id,$idSupervisor,$table,$column,$tipo){
		$columnSupervisor=($tipo=="obra") ? "idResidente" : "idInspector";
		$query="";
		if($table=="avanceobra"){
			$query="SELECT GROUP_CONCAT(pro.lote,'/',pro.manzana) ltemza,ao.$column lotes,ao.avanceC,paq.tipoEstimacion FROM detalle_paquete dp 
			LEFT JOIN paquetes paq ON paq.id=dp.idPaquete
			LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes)
			LEFT JOIN estimacion_programa ion ON ion.idPaquete=paq.id 
			LEFT JOIN estimaciones_programa iones ON iones.idEstimacion=ion.id 
			LEFT JOIN estimados_programa ados ON ados.idEstimaciones=iones.id 
			LEFT JOIN proyectos pro ON pro.id=dp.idProyecto 
			LEFT JOIN avanceobra ao ON ao.idEstimado=ados.id 
			LEFT JOIN paquete_presupuesto paqp ON paqp.idPresupuestoMO=ados.idPresupuesto AND paqp.idPaquete=paq.id
			WHERE arr.estatus_arranque=2 AND WEEK(iones.fecha,7)=WEEK(NOW(),7) AND dp.$columnSupervisor=$idSupervisor AND ao.id=$id
			GROUP BY ao.id ORDER BY ao.id DESC";
		}else if($table=="paquete_presupuesto"){
			$query="SELECT GROUP_CONCAT(pro.lote,'/',pro.manzana) ltemza,paqp.$column lotes,paqp.acumulado,paq.tipoEstimacion FROM detalle_paquete dp
			LEFT JOIN paquetes paq ON paq.id=dp.idPaquete
			LEFT JOIN arranque arr ON paq.id IN (arr.idPaquetes)
			LEFT JOIN proyectos pro ON pro.id=dp.idProyecto
			LEFT JOIN paquete_presupuesto paqp ON paqp.idPaquete=paq.id
			WHERE arr.estatus_arranque=2 AND dp.$columnSupervisor=$idSupervisor AND paqp.id=$id 
			GROUP BY paqp.id ORDER BY paqp.id DESC";
		}
		return $this->_db->query($query);
	}

}