<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Almacenes extends MX_Controller {
    public $data,$vParameters,$mainView,$fv;
    public function __construct(){
    $this->nsession = $this->config->item('nsession');
    if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'almacenes'; // form validation variable
            $this->mainView = 'almacenes';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/almacenes/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '';
            // tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('malmacenes','musuario','munidades','mcategoriamo','msubcategoriamo','mempresas', 'mlogsws'));
            $this->load->library("curl");
    			valSession("materiales",$this->fv);
            error_reporting(0);
    }


      public function updateWS(){
        ini_set('max_execution_time', 300);
        $curl = curl_init();
        //INFORMACION A ENVIAR POR POST EN FORMATO JSON
        $idEmpresa = $_SESSION["viv"]['idEmpresa'];
        $idUsuario = $_SESSION["viv"]['id'];
        $datos = json_encode(array("un" => $idEmpresa));
        $time_start = microtime(true);
        curl_setopt_array($curl, array(
            CURLOPT_PORT => $this->config->item('portmicro'),
            CURLOPT_URL => $this->config->item('dnsmicro')."getAlmacenes",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30000,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_FOLLOWLOCATION => 1,
            CURLOPT_POSTFIELDS => $datos,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "postman-token: ab5bf890-47c6-d504-ba8f-82667b58bebd",
                'Content-Type:application/json'
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);

        $json = [];
        if ($err) {
            echo "CURL Error #:" . $err;
            $time_end = microtime(true);
            $time = $time_end - $time_start;
            $dataL['time'] = $time;
            $dataL['idEmpresa'] = $idEmpresa;
            $dataL['nombreTabla'] = 'almacenes';
            $dataL['funcion'] = 'getAlmacenes';
            $dataL['http_code'] = 0;
            $dataL['insertados'] = 0;
            $dataL['actualizados'] = 0;
            $dataL['totalRegistros'] = 0;
            $dataL['json'] = "CURL Error #:" . $err;
            $dataL['created'] = date("Y-m-d H:i:s");
            $dataL['updated'] = date("Y-m-d H:i:s");
            $dataL['created_by'] = $idUsuario;
            $dataL['updated_by'] = $idUsuario;
            $this->db->insert('logs_ws', $dataL);
        }else{
            $json = $response;
            // Comprueba el código de estado HTTP
            if (!curl_errno($curl)) {
                switch ($http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE)) {   
                    case 200:
                        $nInsert=0;
                        $nUpdate=0;
                        $nTotal=0;

                            $json = json_decode($json);
                            foreach ($json->object_result as $row){
                                foreach ($row as $key => $val){
                                    switch ($key) {
                                        default:
                                            $data[$key]=$val;
                                    }
                                } 
                                $data['idEmpresa']=$idEmpresa;
                                if($this->malmacenes->valInsert($row->id,$idEmpresa)){
                                    $this->malmacenes->insertar($data);
                                    $nInsert++; 
                                }else if($this->malmacenes->valUpdate($row->id,$data)){
                                    $this->malmacenes->actualizar($data,$row->id);
                                    $nUpdate++;
                                }
                                $nTotal++;
                            }   

                        echo "Insertados: ".$nInsert." <br> ";
                        echo "Actualizados: ".$nUpdate." <br> ";
                        echo "Total de registros: ".$nTotal." <br> ";
                        curl_close($curl);
                        unset($json->object_result);
                        $json = json_encode($json);
                        $time_end = microtime(true);
                        $time = $time_end - $time_start;
                        $dataL['time'] = $time;
                        $dataL['idEmpresa'] = $idEmpresa;
                        $dataL['nombreTabla'] = 'almacenes';
                        $dataL['funcion'] = 'getAlmacenes';
                        $dataL['http_code'] = $http_code;
                        $dataL['insertados'] = $nInsert;
                        $dataL['actualizados'] = $nUpdate;
                        $dataL['totalRegistros'] = $nTotal;
                        $dataL['json'] = $json;
                        $dataL['created'] = date("Y-m-d H:i:s");
                        $dataL['updated'] = date("Y-m-d H:i:s");
                        $dataL['created_by'] = $idUsuario;
                        $dataL['updated_by'] = $idUsuario;
                        $this->db->insert('logs_ws', $dataL);
                        redirect($this->mainView);
                        break;
                    case 404:
                        echo "Not found";
                        $json = json_decode($json);
                        unset($json->object_result);
                        $json = json_encode($json);
                        $time_end = microtime(true);
                        $time = $time_end - $time_start;
                        $dataL['time'] = $time;
                        $dataL['idEmpresa'] = $idEmpresa;
                        $dataL['nombreTabla'] = 'almacenes';
                        $dataL['funcion'] = 'getAlmacenes';
                        $dataL['http_code'] = $http_code;
                        $dataL['insertados'] = 0;
                        $dataL['actualizados'] = 0;
                        $dataL['totalRegistros'] = 0;
                        $dataL['json'] = $json;
                        $dataL['created'] = date("Y-m-d H:i:s");
                        $dataL['updated'] = date("Y-m-d H:i:s");
                        $dataL['created_by'] = $idUsuario;
                        $dataL['updated_by'] = $idUsuario;
                        $this->db->insert('logs_ws', $dataL);
                        break;
                    default:
                        echo 'Unexpected HTTP code: ', $http_code, "\n";
                        $json = json_decode($json);
                        unset($json->object_result);
                        $json = json_encode($json);
                        $time_end = microtime(true);
                        $time = $time_end - $time_start;
                        $dataL['time'] = $time;
                        $dataL['idEmpresa'] = $idEmpresa;
                        $dataL['nombreTabla'] = 'almacenes';
                        $dataL['funcion'] = 'getAlmacenes';
                        $dataL['http_code'] = $http_code;
                        $dataL['insertados'] = 0;
                        $dataL['actualizados'] = 0;
                        $dataL['totalRegistros'] = 0;
                        $dataL['json'] = $json;
                        $dataL['created'] = date("Y-m-d H:i:s");
                        $dataL['updated'] = date("Y-m-d H:i:s");
                        $dataL['created_by'] = $idUsuario;
                        $dataL['updated_by'] = $idUsuario;
                        $this->db->insert('logs_ws', $dataL);
                        break;
                }
            }
        }
        curl_close($curl);
    }

    public function index(){
        $data['q'] = '';
        $idEmpresa = $_SESSION["viv"]['idEmpresa'];
        $logsWs = $this->mlogsws->getByIdEmpresaTabla($idEmpresa, 'almacenes');
        $msgLogs = '';
        $showNotification = 0;
        if(!is_numeric($logsWs)){
            if($logsWs['status'] == 0){
                $user = $this->musuario->getById($logsWs['created_by']);
                $msgLogs = 'Sincronización Realizada Por: '.$user['nombre'].' '.$user['apellidoP'].'<br><br><br>';
                $msgLogs .= 'Registros Insertados: '.$logsWs['insertados'].'<br><br>';
                $msgLogs .= 'Registros Actualizados: '.$logsWs['actualizados'].'<br><br>';
                $msgLogs .= 'Total Registros: '.$logsWs['totalRegistros'].'<br><br>';
                $showNotification = 1;
                $pData['status'] = 1;
                $this->mlogsws->actualizar($pData, $logsWs['id']);
            }
        }
        $data['msgLogs'] = $msgLogs;
        $data['showNotification'] = $showNotification;
        // $data['seccion'] = $this->uri->segment(1);
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
    }

    public function excel(){
       $q = $this->malmacenes->getAllExcelRows();
       $columnas = array(
                    0 => 'NOMBRE',
                    1 => 'NOMBRE ABREV',
                    2 => 'CIUDAD',
                    3 => 'C.P',
                    4 => 'TELEFONO 1',
                    5 => 'TELEFONO 2'
        );
       crearExcel($q,'almacenes',$columnas);
    }

    public function listado(){
        $list = $this->malmacenes->get_datatables();
        /*echo '<pre>';  print_r($list); exit();*/
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $almacenes) {
            $no++;
            $row = array();
            //$row[] = $no;
            $row[] = $almacenes->nombre;
            $row[] = $almacenes->nombre_abrev;
            $row[] = $almacenes->ciudad;
            $row[] = $almacenes->cp;
            $row[] = $almacenes->telefono1;
            $row[] = $almacenes->telefono2;

            $data[] = $row;
        }

        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->malmacenes->count_all(),
                        "recordsFiltered" => $this->malmacenes->count_filtered(),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);
    }

    public function nuevo()
    {
        // Mensajes}
        $data['msg'] = '';
        $this->load->library('form_validation');
        if ($this->form_validation->run($this->fv) == FALSE) {
            $data['msg'] = validation_errors();

            /*$data['unidad']= $this->munidades->getSelectResult();
            $data['categoria']= $this->mcategoriamo->getSelectResult();
            $data['subcatetegoria']= $this->msubcategoriamo->getSelectResult();*/
             /*   echo '<pre>'; print_r($data['unidad']->result()) ; exit();*/
            $this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
            $this->load->view('templates/main_template', $this->data);
        } else {
            $pData['nombre'] = $this->input->post('nombre', TRUE);
            $pData['nombre_abrev'] = $this->input->post('nombre_abrev', TRUE);
            $pData['ciudad'] = $this->input->post('ciudad', TRUE);
            $pData['cp'] = $this->input->post('cp', TRUE);
            $pData['telefono1'] = $this->input->post('telefono1', TRUE);
            $pData['telefono2'] = $this->input->post('telefono2', TRUE);
            $pData['status'] = 1;
            $id = $this->malmacenes->insertar($pData);
            redirect($this->router->class);
        }


    }

    public function editar($id)
    {
        // Mensajes
        $msg = '';
        /* VALIDAR FORMULARIO*/
        $this->load->library('form_validation');

        if (isset($_POST['clave'])) {
            if ($this->form_validation->run($this->fv) == FALSE) {
                $msg = validation_errors();
            } else {
                  $pData['nombre'] = $this->input->post('nombre', TRUE);
                  $pData['nombre_abrev'] = $this->input->post('nombre_abrev', TRUE);
                  $pData['ciudad'] = $this->input->post('ciudad', TRUE);
                  $pData['cp'] = $this->input->post('cp', TRUE);
                  $pData['telefono1'] = $this->input->post('telefono1', TRUE);
                  $pData['telefono2'] = $this->input->post('telefono2', TRUE);
                /*  $pData['status'] =$this->input->post('status',TRUE);*/
                $this->malmacenes->actualizar($pData, $id);
                redirect($this->router->class."?close");
            }
        }
        // Obteniendo la información
        $info = $this->malmacenes->getById($id);
        //echo '<pre>'; print_r($info); exit();

        $data = $info;
        $data['msg']=$msg;
        $data['unidad']= $this->munidades->getSelectResult();
        $data['categorias']= $this->mcategoriamo->getSelectResult();
        $data['subcategorias']= $this->msubcategoriamo->getSelectResult();

        $this->data['contenido'] = $this->load->view($this->mainView . '/editar_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function ver($id = null){
        $info = $this->malmacenes->getById($id);
        $data = $info;
      /*   print_r($data); exit();*/
        $this->data['contenido'] = $this->load->view($this->mainView . '/ver_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function eliminar(){
        $id = $this->input->post('elid');
        $q = $this->malmacenes->getById($id);
        $cValor = "true";
        $valorBorrar = $this->malmacenes->borrar($id);
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }

    public function addAlmacen($array){
        ini_set('max_execution_time', 300);
        $curl = curl_init();
        //INFORMACION A ENVIAR POR POST EN FORMATO JSON
        $idEmpresa = $_SESSION["viv"]['idEmpresa'];
        $idUsuario = $_SESSION["viv"]['id'];
        $datos=$array;
        $datos = json_encode($datos);
        $time_start = microtime(true);

        curl_setopt_array($curl, array(
            CURLOPT_PORT => $this->config->item('portmicro'),
            CURLOPT_URL => $this->config->item('dnsmicro')."AddAlmacen",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 60000,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_FOLLOWLOCATION => 1,
            CURLOPT_POSTFIELDS => $datos,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "postman-token: ab5bf890-47c6-d504-ba8f-82667b58bebd",
                'Content-Type:application/json'
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        $res['resultado'] = '';

        $json = [];
        if ($err) {
            $res['error'] = true;
            echo "CURL Error #:" . $err;
            $time_end = microtime(true);
            $time = $time_end - $time_start;
            $dataL['time'] = $time;
            $dataL['idEmpresa'] = $idEmpresa;
            $dataL['nombreTabla'] = 'almacenes';
            $dataL['funcion'] = 'AddAlmacen';
            $dataL['http_code'] = 0;
            $dataL['insertados'] = 0;
            $dataL['actualizados'] = 0;
            $dataL['totalRegistros'] = 0;
            $dataL['json'] = "CURL Error #:" . $err;
            $dataL['created'] = date("Y-m-d H:i:s");
            $dataL['updated'] = date("Y-m-d H:i:s");
            $dataL['created_by'] = $idUsuario;
            $dataL['updated_by'] = $idUsuario;
            $this->db->insert('logs_ws', $dataL);
        }else{
            $res['error'] = false;
            $json = $response;
            // Comprueba el código de estado HTTP
            if (!curl_errno($curl)) {
              switch ($http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE)) {
                case 200:
                    $json = json_decode($json, true);
                    if($json['result']){
                        $res['responseObject'] = true;
                        $res['resultado'] = $json['object_result'];
                        $res['error_message'] = $json['error_message'];
                    }else{
                        $res['responseObject'] = false;
                        $res['error_message'] = $json['error_message'];
                    }
                    $time_end = microtime(true);
                    $time = $time_end - $time_start;
                    $dataL['time'] = $time;
                    $dataL['idEmpresa'] = $idEmpresa;
                    $dataL['nombreTabla'] = 'almacenes';
                    $dataL['funcion'] = 'AddAlmacen';
                    $dataL['http_code'] = 0;
                    $dataL['insertados'] = ($json['result'])? 1 : 0;
                    $dataL['actualizados'] = 0;
                    $dataL['totalRegistros'] = ($json['result'])? 1 : 0;
                    $json = json_encode($json);
                    $dataL['json'] = $json;
                    $dataL['created'] = date("Y-m-d H:i:s");
                    $dataL['updated'] = date("Y-m-d H:i:s");
                    $dataL['created_by'] = $idUsuario;
                    $dataL['updated_by'] = $idUsuario;
                    $this->db->insert('logs_ws', $dataL);
                    break;
                case 404:
                    echo "Not found";
                    $time_end = microtime(true);
                    $time = $time_end - $time_start;
                    $dataL['time'] = $time;
                    $dataL['idEmpresa'] = $idEmpresa;
                    $dataL['nombreTabla'] = 'almacenes';
                    $dataL['funcion'] = 'AddAlmacen';
                    $dataL['http_code'] = 0;
                    $dataL['insertados'] = 0;
                    $dataL['actualizados'] = 0;
                    $dataL['totalRegistros'] = 0;
                    $dataL['json'] = $json;
                    $dataL['created'] = date("Y-m-d H:i:s");
                    $dataL['updated'] = date("Y-m-d H:i:s");
                    $dataL['created_by'] = $idUsuario;
                    $dataL['updated_by'] = $idUsuario;
                    $this->db->insert('logs_ws', $dataL);
                    break;
                default:
                    echo 'Unexpected HTTP code: ', $http_code, "\n";
                    $time_end = microtime(true);
                    $time = $time_end - $time_start;
                    $dataL['time'] = $time;
                    $dataL['idEmpresa'] = $idEmpresa;
                    $dataL['nombreTabla'] = 'almacenes';
                    $dataL['funcion'] = 'AddAlmacen';
                    $dataL['http_code'] = 0;
                    $dataL['insertados'] = 0;
                    $dataL['actualizados'] = 0;
                    $dataL['totalRegistros'] = 0;
                    $dataL['json'] = $json;
                    $dataL['created'] = date("Y-m-d H:i:s");
                    $dataL['updated'] = date("Y-m-d H:i:s");
                    $dataL['created_by'] = $idUsuario;
                    $dataL['updated_by'] = $idUsuario;
                    $this->db->insert('logs_ws', $dataL);
                    break;
              }
            }
        }
        curl_close($curl);

        return $res;
    }
   
}